/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.dialect;

import io.xpipe.app.beacon.AppBeaconServer;
import io.xpipe.app.core.AppInstallation;
import io.xpipe.app.core.AppSystemInfo;
import io.xpipe.app.ext.FileEntry;
import io.xpipe.app.ext.FileSystem;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.NewLine;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialectAskpass;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellDumbMode;
import io.xpipe.app.process.ShellLaunchCommand;
import io.xpipe.core.FileInfo;
import io.xpipe.core.FileKind;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.core.StreamCharset;
import io.xpipe.ext.proc.c;
import io.xpipe.ext.proc.dialect.b;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;

public final class a
implements ShellDialect {
    private static final List<SimpleDateFormat> aK = List.of(new SimpleDateFormat("MM/dd/yyyy HH:mm a"), new SimpleDateFormat("dd/MM/yyyy HH:mm"));
    private final 1 aL = new ShellLaunchCommand(this){
        private Boolean aM;
        private /* synthetic */ a aN;
        {
            this.aN = a2;
        }

        public final String inlineCdCommand(String object) {
            object = "&cd /D " + ((String)object).replaceAll(" ", "^ ") + "&" + this.loginCommand() + "&" + this.aN.getPassthroughExitCommand();
            return "cmd /c \"" + (String)object + "\"";
        }

        public final List<String> localCommand() {
            Path path = null;
            String string = System.getenv("ComSpec");
            if (string != null) {
                try {
                    path = Path.of(string.strip(), new String[0]);
                }
                catch (InvalidPathException invalidPathException) {}
            }
            if (path == null) {
                path = AppSystemInfo.ofWindows().getSystemRoot().resolve("System32", new String[]{"cmd.exe"});
            }
            if (this.aM == null) {
                this.aM = Files.isRegularFile(path, new LinkOption[0]);
            }
            return List.of(this.aM != false ? path.toString() : "cmd");
        }

        public final List<String> loginCommand(OsType.Any any) {
            return List.of("cmd");
        }
    };

    public final String unsetEnvironmentVariableCommand(String string) {
        return "set \"" + string + "=\"";
    }

    public final CommandBuilder launchAsnyc(CommandBuilder commandBuilder) {
        return CommandBuilder.of().environment(commandBuilder.getEnvironmentVariables()).add(new String[]{"start"}).addQuoted("").add(shellControl -> commandBuilder.buildBase(shellControl));
    }

    public final String terminalLauncherScript(UUID uUID, String string, boolean bl) {
        int n2 = AppBeaconServer.get().getPort();
        Path path = AppInstallation.ofCurrent().getCliExecutablePath();
        String string2 = "echo Press [r] to restart or any other key to close this session ...\nFor /F \"skip=1 Usebackq Tokens=* Delims=\" %%F in (`\"replace ? . /u /w\"`) Do @Set \"Key=PREFIX%%F\"\nif \"%Key%\"==\"PREFIXr\" (GOTO start)\n";
        String string3 = "IF %%ERRORLEVEL%% NEQ 0 (\n%s\n)\n".formatted(string2.strip());
        return ":start\n%s\n\"%s\" terminal-wait --port %s --request %s\nset \"R=%%ERRORLEVEL%%\"\nIF %%R%% NEQ 0 (GOTO end)\n\nFOR /F \"delims=\" %%%%i IN ('\"%s\" terminal-launch --port %s --request %s') DO set \"FILE=%%%%i\"\nIF NOT EXIST \"%%FILE%%\" (GOTO end)\nCALL \"%%FILE%%\"\n\n:end\n%s\nTITLE Exited\necho Shell session has ended\nexit\n".formatted(this.changeTitleCommand(string), path, n2, uUID.toString(), path, n2, uUID.toString(), bl ? string2 : string3);
    }

    public final String getExecutableName() {
        return "cmd";
    }

    public final String getCatchAllVariable() {
        return "%*";
    }

    public final String queryVersion(ShellControl object) {
        ShellControl shellControl = object;
        String string = shellControl.executeSimpleStringCommand(shellControl.getShellDialect().getPrintEnvironmentVariableCommand("ComSpec")).replaceAll("\\\\", "$0$0");
        if (((Optional)(object = object.command("wmic datafile where name=\"" + string + "\" get Version /value").readStdoutIfPossible())).isPresent()) {
            return "cmd v" + ((String)((Optional)object).get()).replace("Version=", "").strip();
        }
        return null;
    }

    public final CommandControl queryFileSize(ShellControl shellControl, String string) {
        string = "for %%I in (%s) do @(if exist %%I (echo %%~zI) else (CALL))".formatted(this.fileArgument(string));
        return shellControl.command(this.b(string, null));
    }

    public final long queryDirectorySize(ShellControl object, String string) {
        object = object.command(CommandBuilder.of().add(new String[]{"dir", "/s"}).addFile(string)).readStdoutOrThrow();
        if ((object = ((String)object).strip().lines().toList()).size() < 2) {
            return 0L;
        }
        Object object2 = object;
        object = (String)object2.get(object2.size() - 2);
        object = ((String)object).split("\\s+");
        object = object[((Object)object).length - 2];
        object = ((String)object).replaceAll("\\D", "");
        long l2 = Long.parseLong((String)object);
        return l2;
    }

    public final CommandControl prepareUserTempDirectory(ShellControl shellControl, String string) {
        return shellControl.command(this.getMkdirsCommand(string));
    }

    public final FilePath getInitFileName(ShellControl shellControl, int n2) {
        return shellControl.getSystemTemporaryDirectory().join(new String[]{"xpipe-" + n2 + ".bat"});
    }

    public final CommandControl directoryExists(ShellControl shellControl, String string) {
        string = String.format("(if exist %s (ECHO:) else (CALL))", "\"" + String.valueOf(FilePath.of((String)string).toDirectory()) + "\\*\"");
        return shellControl.command(string);
    }

    public final CommandControl evaluateExpression(ShellControl shellControl, String string) {
        return shellControl.command("echo " + string);
    }

    public final CommandControl resolveDirectory(ShellControl shellControl, String string) {
        if (string.startsWith("\\\\")) {
            throw (UnsupportedOperationException)ErrorEventFactory.expected((Throwable)new UnsupportedOperationException("cmd.exe does not support UNC paths. Use a PowerShell environment instead."));
        }
        return shellControl.command(this.getEchoCommand(string, false));
    }

    public final String literalArgument(String string) {
        string = string.replaceAll("[\"]", "\"$0");
        return "\"" + string + "\"";
    }

    public final String fileArgument(String string) {
        string = string.replaceAll("[%^]", "^$0").replaceAll("\\^[^%]", "\"$0\"");
        return "\"" + string + "\"";
    }

    public final String quoteArgument(String string) {
        string = string.replaceAll("[\"]", "^$0");
        return "\"" + string + "\"";
    }

    public final String prepareTerminalEnvironmentCommands() {
        return "set TERM=xterm-256color\nset COLORTERM=truecolor\n%s\n".formatted(this.unsetEnvironmentVariableCommand("NO_COLOR"));
    }

    public final String addToPathVariableCommand(List<String> object, boolean bl) {
        object = String.join((CharSequence)";", object);
        object = bl ? "%PATH%;" + (String)object : (String)object + ";%PATH%";
        return "set \"PATH=" + (String)object + "\"";
    }

    public final String changeTitleCommand(String string) {
        string = string.length() > 2 && Character.isSurrogate(string.charAt(0)) ? string.substring(2) : string;
        return "TITLE " + this.l(string);
    }

    public final CommandControl createStreamFileWriteCommand(ShellControl object, String object2, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (l2 == 0L) {
            return object.command(CommandBuilder.of().add(new String[]{"type", "NUL", ">"}).addFile((String)object2));
        }
        object2 = object.isLocal() ? "(where pwsh >NUL 2>NUL && pwsh " + a.a((String)object2, l2, false) + ") || (where pwsh >NUL 2>NUL || \"%SystemRoot%\\System32\\WindowsPowerShell\\v1.0\\powershell\" " + a.a((String)object2, l2, false) + ")" : "(where pwsh >NUL 2>NUL && pwsh " + a.a((String)object2, l2, false) + ") || (where pwsh >NUL 2>NUL || \"%SystemRoot%\\System32\\WindowsPowerShell\\v1.0\\powershell\" " + a.a((String)object2, l2, true) + ")";
        object = new c((ShellControl)object, CommandBuilder.ofString((String)object2), null){

            @Override
            public final void close() {
                try {
                    try {
                        this.a.writeLine("");
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        super.close();
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
            }
        };
        return object;
    }

    public final String getCdCommand(String string) {
        return String.format("cd /D %s", this.fileArgument(string));
    }

    public final String getScriptFileEnding() {
        return "bat";
    }

    public final String assembleCommand(String charSequence, Map<String, String> object) {
        charSequence = new StringBuilder((String)charSequence);
        for (Map.Entry entry : object.entrySet()) {
            ((StringBuilder)charSequence).insert(0, this.getSetEnvironmentVariableCommand((String)entry.getKey(), (String)entry.getValue()) + this.getConcatenationOperator());
        }
        return ((StringBuilder)charSequence).toString();
    }

    public final Stream<FileEntry> listFiles(FileSystem object, ShellControl object2, String object3, boolean bl) {
        FilePath filePath = FilePath.of((String)object3);
        Object object4 = "^|";
        object4 = "%~fG" + "^|" + "%~tG" + (String)object4 + "%~zG" + (String)object4 + "%~aG";
        String string = String.format("(for %%G in (" + (bl ? "*" : filePath.getFileName()) + ") do @echo %s)", object4);
        String string2 = String.format("(for /D %%G in (*) do @echo %s)", object4);
        object4 = String.format("(for /F \"delims=\" %%G in ('dir /B /A:h 2^>NUL') do @echo %s) 2>NUL", object4);
        object4 = string + (String)(bl ? this.getConcatenationOperator() + string2 + this.getConcatenationOperator() + (String)object4 : "");
        object2 = object2.command(this.b((String)object4, (String)object3)).withWorkingDirectory(bl ? filePath : filePath.getParent()).start();
        object3 = new AtomicReference();
        AtomicReference atomicReference = new AtomicReference();
        object = new io.xpipe.ext.proc.dialect.c((CommandControl)object2, arg_0 -> a.a((AtomicReference)object3, atomicReference, (FileSystem)object, arg_0), 0);
        object2 = () -> a.b((io.xpipe.ext.proc.dialect.c)object);
        return (Stream)StreamSupport.stream(object2.spliterator(), false).onClose(() -> a.a((io.xpipe.ext.proc.dialect.c)object));
    }

    public final Stream<String> listRoots(ShellControl object) {
        Optional optional = object.command("fsutil fsinfo drives").readStdoutIfPossible();
        if (optional.isPresent()) {
            return Arrays.stream(((String)optional.get()).split(" ")).filter(string -> string.matches("\\w:\\\\"));
        }
        if (((Optional)(object = object.command(CommandBuilder.of().add(new String[]{"wmic", "logicaldisk", "get", "caption"})).readStdoutIfPossible())).isPresent()) {
            return ((String)((Optional)object).get()).lines().skip(1L).filter(string -> !string.isBlank()).map(string -> string.strip() + "\\");
        }
        return Stream.of("C:\\");
    }

    public final String getPauseCommand() {
        return "echo Press enter to close this session ...&pause >NUL";
    }

    public final String prepareScriptContent(ShellControl shellControl, String string) {
        return "@echo off\r\n\"%SystemRoot%\\System32\\chcp.com\" 65001 >NUL\r\n" + string + "\r\n";
    }

    public final String environmentVariable(String string) {
        return "%" + string + "%";
    }

    public final String getConcatenationOperator() {
        return "&";
    }

    public final String getDiscardStdoutOperator() {
        return ">NUL";
    }

    public final String getDiscardAllOperator() {
        return ">NUL 2>&1";
    }

    public final String nullStdin(String string) {
        return string + "<NUL";
    }

    public final ShellDialectAskpass getAskpass() {
        return new b();
    }

    public final String getSetEnvironmentVariableCommand(String string, String string2) {
        return "set \"" + string + "=" + string2 + "\"";
    }

    public final String getEchoCommand(String string, boolean bl) {
        string = string.isEmpty() ? "echo:" : "echo " + this.l(string).replaceAll("\r\n", "^\r\n");
        return (bl ? "(" : "") + string + (bl ? ")1>&2" : "");
    }

    public final String getPrintVariableCommand(String string) {
        return "(call echo ^%" + string + "^%)";
    }

    public final CommandControl printUsernameCommand(ShellControl shellControl) {
        return shellControl.command("echo %USERNAME%");
    }

    public final String getPrintStartEchoCommand(String string) {
        return "echo " + string.charAt(0) + "^" + string.substring(1);
    }

    public final Optional<String> executeRobustBootstrapOutputCommand(ShellControl object, String object2) {
        if (object.getTtyState().isPreservesOutput()) {
            Optional optional = object.command((String)object2).readStdoutIfPossible();
            return optional;
        }
        String string = UUID.randomUUID().toString();
        String string2 = UUID.randomUUID().toString();
        object2 = ((String)object2).startsWith("(") && ((String)object2).endsWith(")") ? ((String)object2).substring(1, ((String)object2).length() - 1) : object2;
        if (((Optional)(object = object.command((String)(object2 = "FOR /F \"tokens=*\" %%g IN ('%s') do @CALL ECHO %s%%g%s".formatted(object2, string.charAt(0) + "^" + string.substring(1), string2.charAt(0) + "^" + string2.substring(1)))).readStdoutIfPossible())).isEmpty()) {
            return object;
        }
        object2 = Pattern.compile(string + "(.*?)" + string2, 32);
        object = ((Pattern)object2).matcher((CharSequence)((Optional)object).get());
        if (((Matcher)object).find()) {
            return Optional.of(((Matcher)object).group(1).strip());
        }
        return Optional.empty();
    }

    public final String getPrintExitCodeCommand(String string, String string2, String string3) {
        return "(call echo " + string + string2.charAt(0) + "^" + string2.substring(1) + "^%" + this.getExitCodeVariable() + "^%" + string3 + ")";
    }

    public final int assignMissingExitCode() {
        return 0;
    }

    public final CommandBuilder getOpenScriptCommand(String string) {
        return CommandBuilder.of().add(new String[]{"cmd.exe", "/c"}).addFile(string);
    }

    public final String terminalInitCommand(ShellControl shellControl, String string, boolean bl) {
        return "cmd.exe /K \"" + string + "\"";
    }

    public final String runScriptCommand(ShellControl object, String string) {
        try {
            object = this.b((ShellControl)object, string);
            return object.orElseGet(() -> this.fileArgument(string));
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
    }

    public final String sourceScriptCommand(ShellControl object, String string) {
        try {
            object = this.b((ShellControl)object, string);
            return "CALL " + object.orElseGet(() -> this.fileArgument(string));
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
    }

    public final String executeCommandWithShell(String string) {
        return "cmd /C " + string;
    }

    public final String getMkdirsCommand(String string) {
        return String.format("(if not exist %s MKDIR %s)", this.fileArgument(string), this.fileArgument(string));
    }

    public final CommandControl getFileReadCommand(ShellControl shellControl, String object) {
        object = "$ErrorActionPreference = 'Stop'\n$i = [System.IO.File]::OpenRead(%s)\n$o = [Console]::OpenStandardOutput()\n$i.CopyTo($o)\n$i.Close()\n$o.Close()\n".formatted(ShellDialects.POWERSHELL.fileArgument((String)object)).lines().collect(Collectors.joining(";"));
        object = "-NoProfile -Command \"" + (String)object + "\"";
        return shellControl.command(CommandBuilder.of().add(arg_0 -> a.a((String)object, arg_0)));
    }

    public final String getPrintWorkingDirectoryCommand() {
        return "CD";
    }

    public final StreamCharset getTextCharset() {
        return StreamCharset.UTF8;
    }

    public final CommandControl getFileCopyCommand(ShellControl shellControl, String string, String string2) {
        return shellControl.command(commandBuilder -> commandBuilder.add(new String[]{"COPY"}).addFile(string).addFile(string2));
    }

    public final CommandControl getFileMoveCommand(ShellControl shellControl, String string, String string2) {
        String string3 = this.fileArgument(FilePath.of((String)string).removeTrailingSlash());
        String string4 = this.fileArgument(FilePath.of((String)string2).removeTrailingSlash());
        if (string.equalsIgnoreCase(string2)) {
            return shellControl.command("MOVE /Y %s %s".formatted(string3, string4));
        }
        return shellControl.command("(if not exist %s (MOVE /Y %s %s) else (CALL))".formatted(this.fileArgument(string2), string3, string4));
    }

    public final boolean requiresScript(String object) {
        if (super.requiresScript((String)object)) {
            return true;
        }
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            if (object2 <= 127) continue;
            return true;
        }
        return false;
    }

    public final CommandControl createTextFileWriteCommand(ShellControl object, String object2, String object3) {
        try {
            if (AppPrefs.get() == null || AppPrefs.get().disableCertutilUse().get()) {
                String string2 = object3;
                object3 = object2;
                object2 = object;
                object = this;
                object3 = new String(Base64.getEncoder().encode(((String)object3).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                return object2.command("\"%%SystemRoot%%\\System32\\WindowsPowerShell\\v1.0\\powershell\" -NoProfile -Command \"$data=[System.Text.Encoding]::UTF8.GetString([System.Convert]::FromBase64String('%s'));Write-Host -NoNewLine $data\" > %s".formatted(object3, ((a)object).fileArgument(string2)));
            }
            object2 = new String(Base64.getEncoder().encode(((String)object2).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            String string3 = this.b((ShellControl)object, (String)object3).orElseGet(() -> this.o((String)object3));
            object3 = this.b((ShellControl)object, (String)object3).map(string -> string + ".tmp").orElseGet(() -> this.m((String)object3));
            object2 = String.format("%s> %s & \"%%SystemRoot%%\\System32\\certutil\" -f -decode %s %s & DEL /f /q %s", this.getEchoCommand((String)object2, false), object3, object3, string3, object3);
            return object.command((String)object2);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
    }

    public final CommandControl createScriptTextFileWriteCommand(ShellControl object, String string, String string2) {
        try {
            return this.createTextFileWriteCommand((ShellControl)object, string, string2);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
    }

    public final CommandControl deleteFileOrDirectory(ShellControl shellControl, String string) {
        return shellControl.command(String.format("(if exist %s (rd /s /q %s) else (DEL /f /q %s & if exist %s (CALL) else (ECHO:)))", this.fileArgument(string + "\\*"), this.fileArgument(string), this.fileArgument(string), this.fileArgument(string)));
    }

    public final String clearDisplayCommand() {
        return null;
    }

    public final ShellLaunchCommand getLaunchCommand() {
        return this.aL;
    }

    public final ShellDumbMode getDumbMode() {
        return new ShellDumbMode(){

            public final void prepareDumbInit(ShellControl shellControl) {
                shellControl.writeLine("\"%SystemRoot%\\System32\\chcp.com\" 65001 >NUL");
                shellControl.writeLine("set TERM=dumb");
                shellControl.writeLine("set LC_ALL=C");
                shellControl.writeLine("set LANG=C");
                shellControl.writeLine("set LANGUAGE=C");
            }
        };
    }

    public final CommandControl createFileExistsCommand(ShellControl shellControl, String string) {
        Object object = FilePath.of((String)string).toDirectory().toString() + "\\*";
        object = this.b(shellControl, (String)object).orElse("\"" + (String)object + "\"");
        object = String.format("if not exist %s (ECHO:) else (CALL)", object);
        string = this.b(shellControl, string).orElse(this.fileArgument(string));
        string = String.format("(if exist %s (%s) else (CALL))", string, object);
        return shellControl.command(string);
    }

    public final CommandControl symbolicLink(ShellControl shellControl, String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public final CommandControl getFileDeleteCommand(ShellControl shellControl, String string) {
        return shellControl.command(commandBuilder -> commandBuilder.add(new String[]{"DEL", "/f", "/q"}).addFile(string));
    }

    public final CommandControl getFileTouchCommand(ShellControl shellControl, String string) {
        return shellControl.command(commandBuilder -> commandBuilder.add(new String[]{"COPY", "NUL"}).addFile(string));
    }

    public final String getWhichCommand(String string) {
        return String.format("WHERE %s", this.fileArgument(string));
    }

    public final Charset determineCharset(ShellControl shellControl) {
        return StandardCharsets.UTF_8;
    }

    public final NewLine getNewLine() {
        return NewLine.CRLF;
    }

    public final String getId() {
        return "cmd";
    }

    public final String getDisplayName() {
        return "cmd";
    }

    public final boolean doesEchoInputByDefault() {
        return true;
    }

    private static String a(String string, long l2, boolean bl) {
        string = "-NoProfile -Command \"$ErrorActionPreference = 'Stop';$i = [Console]::OpenStandardInput();$o = [System.IO.File]::Create('%s');$left=[long] %s;$buffer = new-object byte[] 33668;while (($left -gt 0) -and ($read = $i.Read($buffer, 0, [math]::Min([long] 33668, $left)))) {$o.Write($buffer, 0, $read);$left=[math]::Max($left - $read, 0)%s};$o.Close()\"".formatted(string.replaceAll("'", "''"), l2, bl ? ";Start-Sleep -Milliseconds 50" : "");
        return string;
    }

    public final String l(String string) {
        return string.replaceAll("[&^|<>\"]", "^$0");
    }

    public final String getExitCodeVariable() {
        return "errorlevel";
    }

    private String b(String string, String string2) {
        if (this.requiresScript(string) || string2 != null && this.requiresScript(string2)) {
            return string.replaceAll("%", "%%");
        }
        return string;
    }

    private Optional<String> b(ShellControl object, String string) {
        if (object.getOsType() != OsType.WINDOWS) {
            return Optional.empty();
        }
        boolean bl = this.requiresScript(string);
        if (bl) {
            String string2;
            if (string.startsWith(object.view().userHome().toString()) && !this.requiresScript(string2 = string.replace(object.view().userHome().toString(), Matcher.quoteReplacement("%USERPROFILE%")))) {
                return Optional.of("\"" + string2 + "\"");
            }
            Object object2 = object.isLocal() ? System.getenv("HOMEDRIVE") : object.view().getEnvironmentVariable("HOMEDRIVE");
            if (object2 == null || ((String)object2).isEmpty()) {
                object2 = "C:";
            }
            String string3 = object.isLocal() ? System.getProperty("user.name") : object.view().user();
            object2 = Pattern.compile((String)object2 + "\\\\Users\\\\([^\\\\]+)").matcher(string);
            if (((Matcher)object2).find() && string3.equals(((Matcher)object2).group(1)) && !this.requiresScript((String)(object2 = ((Matcher)object2).replaceFirst(Matcher.quoteReplacement("%USERPROFILE%"))))) {
                return Optional.of("\"" + (String)object2 + "\"");
            }
            object2 = object.getSystemTemporaryDirectory().toString();
            if (!((String)object2).isEmpty() && string.startsWith((String)object2) && !this.requiresScript((String)(object = string.replace((CharSequence)object2, Matcher.quoteReplacement("%TEMP%"))))) {
                return Optional.of("\"" + (String)object + "\"");
            }
        }
        return Optional.empty();
    }

    @Generated
    public a() {
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof a)) {
            return false;
        }
        object = (a)object;
        ShellLaunchCommand shellLaunchCommand = this.getLaunchCommand();
        object = ((a)object).getLaunchCommand();
        return !(shellLaunchCommand == null ? object != null : !shellLaunchCommand.equals(object));
    }

    @Generated
    public final int hashCode() {
        ShellLaunchCommand shellLaunchCommand = this.getLaunchCommand();
        int n2 = 59 + (shellLaunchCommand == null ? 43 : shellLaunchCommand.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "CmdDialect(launchCommand=" + String.valueOf(this.getLaunchCommand()) + ")";
    }

    private /* synthetic */ String m(String string) {
        return this.fileArgument(string + ".tmp");
    }

    private /* synthetic */ String o(String string) {
        return this.fileArgument(string);
    }

    private static /* synthetic */ String a(String string, ShellControl object) {
        if ((object = object.view().findProgram("pwsh")).isPresent()) {
            return "pwsh " + string;
        }
        return "\"%SystemRoot%\\System32\\WindowsPowerShell\\v1.0\\powershell\" " + string;
    }

    private static /* synthetic */ void a(io.xpipe.ext.proc.dialect.c c2) {
        c2.close();
    }

    private static /* synthetic */ Iterator b(io.xpipe.ext.proc.dialect.c c2) {
        return c2;
    }

    private static /* synthetic */ FileEntry a(AtomicReference atomicReference, AtomicReference atomicReference2, FileSystem fileSystem, String object) {
        Object object2;
        if (((String[])(object = object.split("\\|"))).length < 4) {
            return null;
        }
        Instant instant = null;
        if (atomicReference.get() == null) {
            for (SimpleDateFormat simpleDateFormat : aK) {
                try {
                    instant = simpleDateFormat.parse(object[1]).toInstant();
                }
                catch (Exception exception) {
                    continue;
                }
                atomicReference2.set(simpleDateFormat);
                break;
            }
            atomicReference.set(atomicReference2.get() != null);
        } else if (((Boolean)atomicReference.get()).booleanValue()) {
            try {
                object2 = object[1];
                instant = ((SimpleDateFormat)atomicReference2.get()).parse((String)object2).toInstant();
            }
            catch (Exception exception) {
                atomicReference.set(Boolean.FALSE);
            }
        }
        object2 = object[3];
        boolean bl = ((String)object2).charAt(0) == 'd';
        boolean bl2 = ((String)object2).contains("l");
        if (bl && bl2) {
            return null;
        }
        FileKind fileKind = bl ? FileKind.DIRECTORY : FileKind.FILE;
        atomicReference2 = fileKind == FileKind.FILE ? (object[2].isBlank() ? "0" : object[2].replaceAll("[, ]", "")) : null;
        object = object[0];
        return new FileEntry(fileSystem, FilePath.of((String)object), instant, (String)((Object)atomicReference2), (FileInfo)new FileInfo.Windows((String)object2), fileKind);
    }
}

