/******************************************************************************
* Copyright (c) 2024 - 2025 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


#ifndef XPM_PINFUNC_H_
#define XPM_PINFUNC_H_

#include "xpm_device.h"

#ifdef __cplusplus
extern "C" {
#endif

#define FUNC_NAME_SIZE		(16U)		/* Function name string size */
#define MAX_GROUPS_PER_RES	(6U)		/* Max No. of groups per query response */
#define INVALID_FUNC_ID 	(0xFFFFU)
#define END_OF_GRP		(0xFFU)		/* -1 */
#define RESERVED_GRP		(0xFFFEU)	/* -2 */

typedef struct XPm_PinFunc XPm_PinFunc;

/**
 * The Pin Function class.
 */
struct XPm_PinFunc {
	char Name[FUNC_NAME_SIZE]; /**< Function name */
	u8 Id; /**< Function ID */
	u8 NumPins; /**< Number of pins needed for this function */
	u8 NumGroups; /**< Number of groups for this function */
	u16 DevIdx; /**< Device index for this function */
	u16 LmioRegMask; /**< Register mask value to select this function */
	u16 PmioRegMask; /**< Register mask value to select this function */
	u16 *Groups; /**< Array of group identifier */
};
enum PmPinGrpIds {
	PIN_GRP_SD0_0 = 0,
	PIN_GRP_SD0_1 = 1,
	PIN_GRP_SD1_0 = 2,
	PIN_GRP_SD1_1 = 3,
	PIN_GRP_UFS_0 = 4,
	PIN_GRP_UFS_1 = 5,
	PIN_GRP_UFS_2 = 6,
	PIN_GRP_UFS_3 = 7,
	PIN_GRP_CAN0_0 = 8,
	PIN_GRP_CAN0_1 = 9,
	PIN_GRP_CAN0_2 = 10,
	PIN_GRP_CAN0_3 = 11,
	PIN_GRP_CAN0_4 = 12,
	PIN_GRP_CAN0_5 = 13,
	PIN_GRP_CAN0_6 = 14,
	PIN_GRP_CAN0_7 = 15,
	PIN_GRP_CAN0_8 = 16,
	PIN_GRP_CAN0_9 = 17,
	PIN_GRP_CAN1_0 = 18,
	PIN_GRP_CAN1_1 = 19,
	PIN_GRP_CAN1_2 = 20,
	PIN_GRP_CAN1_3 = 21,
	PIN_GRP_CAN1_4 = 22,
	PIN_GRP_CAN1_5 = 23,
	PIN_GRP_CAN1_6 = 24,
	PIN_GRP_CAN1_7 = 25,
	PIN_GRP_CAN1_8 = 26,
	PIN_GRP_CAN1_9 = 27,
	PIN_GRP_CAN2_0 = 28,
	PIN_GRP_CAN2_1 = 29,
	PIN_GRP_CAN2_2 = 30,
	PIN_GRP_CAN2_3 = 31,
	PIN_GRP_CAN2_4 = 32,
	PIN_GRP_CAN2_5 = 33,
	PIN_GRP_CAN2_6 = 34,
	PIN_GRP_CAN2_7 = 35,
	PIN_GRP_CAN3_0 = 36,
	PIN_GRP_CAN3_1 = 37,
	PIN_GRP_CAN3_2 = 38,
	PIN_GRP_CAN3_3 = 39,
	PIN_GRP_CAN3_4 = 40,
	PIN_GRP_CAN3_5 = 41,
	PIN_GRP_CAN3_6 = 42,
	PIN_GRP_CAN3_7 = 43,
	PIN_GRP_GEM0_0 = 44,
	PIN_GRP_GEM0_1 = 45,
	PIN_GRP_GEM1_0 = 46,
	PIN_GRP_GEM1_1 = 47,
	PIN_GRP_I2C0_0 = 48,
	PIN_GRP_I2C0_1 = 49,
	PIN_GRP_I2C0_2 = 50,
	PIN_GRP_I2C0_3 = 51,
	PIN_GRP_I2C0_4 = 52,
	PIN_GRP_I2C0_5 = 53,
	PIN_GRP_I2C1_0 = 54,
	PIN_GRP_I2C1_1 = 55,
	PIN_GRP_I2C1_2 = 56,
	PIN_GRP_I2C1_3 = 57,
	PIN_GRP_I2C1_4 = 58,
	PIN_GRP_I2C1_5 = 59,
	PIN_GRP_I2C1_6 = 60,
	PIN_GRP_OSPI_0 = 61,
	PIN_GRP_PCIE_0 = 62,
	PIN_GRP_PCIE_1 = 63,
	PIN_GRP_PCIE_2 = 64,
	PIN_GRP_QSPI_0 = 65,
	PIN_GRP_SMAP_0 = 66,
	PIN_GRP_SPI0_0 = 67,
	PIN_GRP_SPI0_1 = 68,
	PIN_GRP_SPI0_2 = 69,
	PIN_GRP_SPI0_3 = 70,
	PIN_GRP_SPI0_4 = 71,
	PIN_GRP_SPI0_5 = 72,
	PIN_GRP_SPI1_0 = 73,
	PIN_GRP_SPI1_1 = 74,
	PIN_GRP_SPI1_2 = 75,
	PIN_GRP_SPI1_3 = 76,
	PIN_GRP_SPI1_4 = 77,
	PIN_GRP_SPI1_5 = 78,
	PIN_GRP_USB0_0 = 79,
	PIN_GRP_USB1_0 = 80,
	PIN_GRP_WWDT_0 = 81,
	PIN_GRP_WWDT_1 = 82,
	PIN_GRP_WWDT_2 = 83,
	PIN_GRP_WWDT_3 = 84,
	PIN_GRP_WWDT_4 = 85,
	PIN_GRP_CAN1_10 = 86,
	PIN_GRP_GPIO0_0 = 87,
	PIN_GRP_GPIO0_1 = 88,
	PIN_GRP_GPIO0_2 = 89,
	PIN_GRP_GPIO0_3 = 90,
	PIN_GRP_GPIO0_4 = 91,
	PIN_GRP_GPIO0_5 = 92,
	PIN_GRP_GPIO0_6 = 93,
	PIN_GRP_GPIO0_7 = 94,
	PIN_GRP_GPIO0_8 = 95,
	PIN_GRP_GPIO0_9 = 96,
	PIN_GRP_GPIO1_0 = 97,
	PIN_GRP_GPIO1_1 = 98,
	PIN_GRP_GPIO1_2 = 99,
	PIN_GRP_GPIO1_3 = 100,
	PIN_GRP_GPIO1_4 = 101,
	PIN_GRP_GPIO1_5 = 102,
	PIN_GRP_GPIO1_6 = 103,
	PIN_GRP_GPIO1_7 = 104,
	PIN_GRP_GPIO1_8 = 105,
	PIN_GRP_GPIO1_9 = 106,
	PIN_GRP_GPIO2_0 = 107,
	PIN_GRP_GPIO2_1 = 108,
	PIN_GRP_GPIO2_2 = 109,
	PIN_GRP_GPIO2_3 = 110,
	PIN_GRP_GPIO2_4 = 111,
	PIN_GRP_GPIO2_5 = 112,
	PIN_GRP_GPIO2_6 = 113,
	PIN_GRP_GPIO2_7 = 114,
	PIN_GRP_GPIO2_8 = 115,
	PIN_GRP_GPIO2_9 = 116,
	PIN_GRP_MDIO0_0 = 117,
	PIN_GRP_MDIO0_1 = 118,
	PIN_GRP_MDIO1_0 = 119,
	PIN_GRP_MDIO1_1 = 120,
	PIN_GRP_MDIO2_0 = 121,
	PIN_GRP_MDIO2_1 = 122,
	PIN_GRP_MDIO2_2 = 123,
	PIN_GRP_MDIO2_3 = 124,
	PIN_GRP_TRACE_0 = 125,
	PIN_GRP_TRACE_1 = 126,
	PIN_GRP_TRACE_2 = 127,
	PIN_GRP_UART0_0 = 128,
	PIN_GRP_UART0_1 = 129,
	PIN_GRP_UART0_2 = 130,
	PIN_GRP_UART0_3 = 131,
	PIN_GRP_UART0_4 = 132,
	PIN_GRP_UART0_5 = 133,
	PIN_GRP_UART0_6 = 134,
	PIN_GRP_UART0_7 = 135,
	PIN_GRP_UART0_8 = 136,
	PIN_GRP_UART1_0 = 137,
	PIN_GRP_UART1_1 = 138,
	PIN_GRP_UART1_2 = 139,
	PIN_GRP_UART1_3 = 140,
	PIN_GRP_UART1_4 = 141,
	PIN_GRP_UART1_5 = 142,
	PIN_GRP_UART1_6 = 143,
	PIN_GRP_UART1_7 = 144,
	PIN_GRP_UART1_8 = 145,
	PIN_GRP_GPIO0_10 = 146,
	PIN_GRP_GPIO0_11 = 147,
	PIN_GRP_GPIO0_12 = 148,
	PIN_GRP_GPIO0_13 = 149,
	PIN_GRP_GPIO0_14 = 150,
	PIN_GRP_GPIO0_15 = 151,
	PIN_GRP_GPIO0_16 = 152,
	PIN_GRP_GPIO0_17 = 153,
	PIN_GRP_GPIO0_18 = 154,
	PIN_GRP_GPIO0_19 = 155,
	PIN_GRP_GPIO0_20 = 156,
	PIN_GRP_GPIO0_21 = 157,
	PIN_GRP_GPIO0_22 = 158,
	PIN_GRP_GPIO0_23 = 159,
	PIN_GRP_GPIO0_24 = 160,
	PIN_GRP_GPIO0_25 = 161,
	PIN_GRP_GPIO1_10 = 162,
	PIN_GRP_GPIO1_11 = 163,
	PIN_GRP_GPIO1_12 = 164,
	PIN_GRP_GPIO1_13 = 165,
	PIN_GRP_GPIO1_14 = 166,
	PIN_GRP_GPIO1_15 = 167,
	PIN_GRP_GPIO1_16 = 168,
	PIN_GRP_GPIO1_17 = 169,
	PIN_GRP_GPIO1_18 = 170,
	PIN_GRP_GPIO1_19 = 171,
	PIN_GRP_GPIO1_20 = 172,
	PIN_GRP_GPIO1_21 = 173,
	PIN_GRP_GPIO1_22 = 174,
	PIN_GRP_GPIO1_23 = 175,
	PIN_GRP_GPIO1_24 = 176,
	PIN_GRP_GPIO1_25 = 177,
	PIN_GRP_GPIO2_10 = 178,
	PIN_GRP_GPIO2_11 = 179,
	PIN_GRP_GPIO2_12 = 180,
	PIN_GRP_GPIO2_13 = 181,
	PIN_GRP_GPIO2_14 = 182,
	PIN_GRP_GPIO2_15 = 183,
	PIN_GRP_GPIO2_16 = 184,
	PIN_GRP_GPIO2_17 = 185,
	PIN_GRP_GPIO2_18 = 186,
	PIN_GRP_GPIO2_19 = 187,
	PIN_GRP_GPIO2_20 = 188,
	PIN_GRP_GPIO2_21 = 189,
	PIN_GRP_GPIO2_22 = 190,
	PIN_GRP_GPIO2_23 = 191,
	PIN_GRP_GPIO2_24 = 192,
	PIN_GRP_GPIO2_25 = 193,
	PIN_GRP_SD0_CD_0 = 194,
	PIN_GRP_SD0_CD_1 = 195,
	PIN_GRP_SD0_PC_0 = 196,
	PIN_GRP_SD0_PC_1 = 197,
	PIN_GRP_SD0_WP_0 = 198,
	PIN_GRP_SD0_WP_1 = 199,
	PIN_GRP_SD1_PC_0 = 200,
	PIN_GRP_SD1_PC_1 = 201,
	PIN_GRP_GEM_TSU_0 = 202,
	PIN_GRP_GEM_TSU_1 = 203,
	PIN_GRP_GEM_TSU_2 = 204,
	PIN_GRP_GEM_TSU_3 = 205,
	PIN_GRP_OSPI_SS_0 = 206,
	PIN_GRP_QSPI_SS_0 = 207,
	PIN_GRP_SPI0_SS_0 = 208,
	PIN_GRP_SPI0_SS_1 = 209,
	PIN_GRP_SPI0_SS_2 = 210,
	PIN_GRP_SPI0_SS_3 = 211,
	PIN_GRP_SPI0_SS_4 = 212,
	PIN_GRP_SPI0_SS_5 = 213,
	PIN_GRP_SPI1_SS_0 = 214,
	PIN_GRP_SPI1_SS_1 = 215,
	PIN_GRP_SPI1_SS_2 = 216,
	PIN_GRP_SPI1_SS_3 = 217,
	PIN_GRP_SPI1_SS_4 = 218,
	PIN_GRP_SPI1_SS_5 = 219,
	PIN_GRP_TEST_CLK_0 = 220,
	PIN_GRP_TTC0_CLK_0 = 221,
	PIN_GRP_TTC0_CLK_1 = 222,
	PIN_GRP_TTC0_CLK_2 = 223,
	PIN_GRP_TTC0_CLK_3 = 224,
	PIN_GRP_TTC0_CLK_4 = 225,
	PIN_GRP_TTC0_CLK_5 = 226,
	PIN_GRP_TTC0_CLK_6 = 227,
	PIN_GRP_TTC0_CLK_7 = 228,
	PIN_GRP_TTC0_WAV_0 = 229,
	PIN_GRP_TTC0_WAV_1 = 230,
	PIN_GRP_TTC0_WAV_2 = 231,
	PIN_GRP_TTC0_WAV_3 = 232,
	PIN_GRP_TTC0_WAV_4 = 233,
	PIN_GRP_TTC0_WAV_5 = 234,
	PIN_GRP_TTC0_WAV_6 = 235,
	PIN_GRP_TTC0_WAV_7 = 236,
	PIN_GRP_TTC1_CLK_0 = 237,
	PIN_GRP_TTC1_CLK_1 = 238,
	PIN_GRP_TTC1_CLK_2 = 239,
	PIN_GRP_TTC1_CLK_3 = 240,
	PIN_GRP_TTC1_CLK_4 = 241,
	PIN_GRP_TTC1_CLK_5 = 242,
	PIN_GRP_TTC1_CLK_6 = 243,
	PIN_GRP_TTC1_CLK_7 = 244,
	PIN_GRP_TTC1_CLK_8 = 245,
	PIN_GRP_TTC1_WAV_0 = 246,
	PIN_GRP_TTC1_WAV_1 = 247,
	PIN_GRP_TTC1_WAV_2 = 248,
	PIN_GRP_TTC1_WAV_3 = 249,
	PIN_GRP_TTC1_WAV_4 = 250,
	PIN_GRP_TTC1_WAV_5 = 251,
	PIN_GRP_TTC1_WAV_6 = 252,
	PIN_GRP_TTC1_WAV_7 = 253,
	PIN_GRP_TTC1_WAV_8 = 254,
	PIN_GRP_TTC2_CLK_0 = 255,
	PIN_GRP_TTC2_CLK_1 = 256,
	PIN_GRP_TTC2_CLK_2 = 257,
	PIN_GRP_TTC2_WAV_0 = 258,
	PIN_GRP_TTC2_WAV_1 = 259,
	PIN_GRP_TTC2_WAV_2 = 260,
	PIN_GRP_TTC3_CLK_0 = 261,
	PIN_GRP_TTC3_CLK_1 = 262,
	PIN_GRP_TTC3_WAV_0 = 263,
	PIN_GRP_TTC3_WAV_1 = 264,
	PIN_GRP_TEST_SCAN_0 = 265,
	PIN_GRP_TRACE_CLK_0 = 266,
	PIN_GRP_TRACE_CLK_1 = 267,
	PIN_GRP_TRACE_CLK_2 = 268,
	PIN_GRP_MMI_DP_HPD_0 = 269,
	PIN_GRP_MMI_DP_HPD_1 = 270,
	PIN_GRP_MMI_DP_HPD_2 = 271,
	PIN_GRP_MMI_DP_HPD_3 = 272,
	PIN_GRP_OSPI_RST_N_0 = 273,
	PIN_GRP_QSPI_FBCLK_0 = 274,
	PIN_GRP_SYSMON_I2C_0 = 275,
	PIN_GRP_SYSMON_I2C_1 = 276,
	PIN_GRP_SYSMON_I2C_2 = 277,
	PIN_GRP_SYSMON_I2C_3 = 278,
	PIN_GRP_SYSMON_I2C_4 = 279,
	PIN_GRP_SYSMON_I2C_5 = 280,
	PIN_GRP_SYSMON_I2C_6 = 281,
	PIN_GRP_SYSMON_I2C_7 = 282,
	PIN_GRP_SYSMON_I2C_8 = 283,
	PIN_GRP_SYSMON_I2C_9 = 284,
	PIN_GRP_SYSMON_I2C_10 = 285,
	PIN_GRP_SYSMON_I2C_11 = 286,
	PIN_GRP_SYSMON_I2C_12 = 287,
	PIN_GRP_SYSMON_I2C_13 = 288,
	PIN_GRP_SYSMON_I2C_14 = 289,
	PIN_GRP_SYSMON_I2C_15 = 290,
	PIN_GRP_OSPI_ECC_FAIL_0 = 291,
	PIN_GRP_OSPI_ECC_FAIL_1 = 292,
	PIN_GRP_EXT_TAMPER_TRIG_0 = 293,
	PIN_GRP_EXT_TAMPER_TRIG_1 = 294,
	PIN_GRP_EXT_TAMPER_TRIG_2 = 295,
	PIN_GRP_EXT_TAMPER_TRIG_3 = 296,
	PIN_GRP_EXT_TAMPER_TRIG_4 = 297,
	PIN_GRP_EXT_TAMPER_TRIG_5 = 298,
	PIN_GRP_EXT_TAMPER_TRIG_6 = 299,
	PIN_GRP_SYSMON_I2C_ALERT_0 = 300,
	PIN_GRP_SYSMON_I2C_ALERT_1 = 301,
	PIN_GRP_SYSMON_I2C_ALERT_2 = 302,
	PIN_GRP_SYSMON_I2C_ALERT_3 = 303,
	PIN_GRP_SYSMON_I2C_ALERT_4 = 304,
	PIN_GRP_SYSMON_I2C_ALERT_5 = 305,
	PIN_GRP_SYSMON_I2C_ALERT_6 = 306,
	PIN_GRP_SYSMON_I2C_ALERT_7 = 307,
	PIN_GRP_SYSMON_I2C_ALERT_8 = 308,
	PIN_GRP_SYSMON_I2C_ALERT_9 = 309,
	PIN_GRP_SYSMON_I2C_ALERT_10 = 310,
	PIN_GRP_SYSMON_I2C_ALERT_11 = 311,
	PIN_GRP_SYSMON_I2C_ALERT_12 = 312,
	PIN_GRP_SYSMON_I2C_ALERT_13 = 313,
	PIN_GRP_SYSMON_I2C_ALERT_14 = 314,
	PIN_GRP_SYSMON_I2C_ALERT_15 = 315,
};
/************************** Function Prototypes ******************************/
XPm_PinFunc *XPmPinFunc_GetById(u32 FuncId);
XStatus XPmPinFunc_GetNumFuncs(u32 *NumFuncs);
XStatus XPmPinFunc_GetFuncName(u32 FuncId, char *FuncName);
XStatus XPmPinFunc_GetNumFuncGroups(u32 FuncId, u32 *NumGroups);
XStatus XPmPinFunc_GetFuncGroups(u32 FuncId, u32 Index, u16 *Groups);

#ifdef __cplusplus
}
#endif

/** @} */
#endif /* XPM_PINFUNC_H_ */
