/******************************************************************************
* Copyright (c) 2015 - 2020 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


#ifndef XPFW_RESETS_H_
#define XPFW_RESETS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "xstatus.h"

/*****************************************************************************/
/**
 * @brief PS-Only Reset Routine
 */
/*****************************************************************************/
void XPfw_ResetPsOnly(void);

/*****************************************************************************/
/**
 * @brief System Reset Routine
 */
/*****************************************************************************/
void XPfw_ResetSystem(void);

/*****************************************************************************/
/**
 * @brief FPD Reset Routine
 */
/*****************************************************************************/

XStatus XPfw_ResetFpd(void);

/*****************************************************************************/
/**
 * @brief RPU Reset Routine
 */
/*****************************************************************************/
XStatus XPfw_ResetRpu(void);

#ifdef __cplusplus
}
#endif

#endif /* XPFW_RESETS_H_ */
