/******************************************************************************
* Copyright (c) 2015 - 2021 Xilinx, Inc.  All rights reserved.
* Copyright (c) 2022 - 2025 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/



#ifndef XPFW_DEFAULT_H_
#define XPFW_DEFAULT_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "xpfw_config.h"
#include "xpfw_util.h"
#include "xpfw_debug.h"

/* BSP Headers */
#include "xil_io.h"
#include "xil_types.h"
#include "mb_interface.h"
#include "xstatus.h"
#ifdef SDT
#include "xparameters.h"
#endif
/* REGDB Headers */
#include "pmu_local.h"
#include "pmu_iomodule.h"
#include "pmu_global.h"
#include "ipi.h"
#include "uart0.h"
#include "uart1.h"
#include "crl_apb.h"
#include "lpd_slcr.h"
#include "rtc.h"

/* Base address of the IOU_SLCR module */
#define IOU_SLCR_BASE			0xFF180000U
#define IOU_SLCR_MIO_PIN_32_OFFSET	0x00000080U /* GPO 0 */
#define IOU_SLCR_MIO_PIN_33_OFFSET	0x00000084U /* GPO 1 */
#define IOU_SLCR_MIO_PIN_34_OFFSET	0x00000088U /* GPO 2 */
#define IOU_SLCR_MIO_PIN_35_OFFSET	0x0000008CU /* GPO 3 */
#define IOU_SLCR_MIO_PIN_36_OFFSET	0x00000090U /* GPO 4 */
#define IOU_SLCR_MIO_PIN_37_OFFSET	0x00000094U /* GPO 5 */

#define IOU_SLCR_CTRL		( IOU_SLCR_BASE + (u32)(0x600U) )

#define SLVERR_MASK				(u32)(0x1U)

/* XPPU SINK Registers */
#define XPPU_SINK_BASE_ADDR		0xFF9CFF00U
#define XPPU_SINK_ERR_CTRL		(XPPU_SINK_BASE_ADDR + 0xECU)

/* BBRAM registers */
#define BBRAM_BASE_ADDR			0xFFCD0000U
#define BBRAM_SLVERR_REG		(BBRAM_BASE_ADDR + 0x34U)

/* RAM address used for scrubbing */
#define PARAM_RAM_LOW_ADDRESS		0Xffdc0000U
#define PARAM_RAM_HIGH_ADDRESS		0Xffdcff00U

/* RAM base address for general usage */
#define PMU_RAM_BASE_ADDR		0Xffdc0000U

/* Canonical PMU Register defines*/

/* XPMU_ZDMA_0 to XPMU_ZDMA_15 */
#if (defined(XPAR_XZDMA_0_DEVICE_ID)) || (defined(XPAR_XZDMA_0_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_0_DEVICE_ID XPAR_XZDMA_0_BASEADDR
#endif
	#if (XPAR_XZDMA_0_BASEADDR == 0xFFA80000U)
		#define XPMU_ZDMA_0 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_0_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFFA90000U)
		#define XPMU_ZDMA_1 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_1_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFFAA0000U)
		#define XPMU_ZDMA_2 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_2_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFFAB0000U)
		#define XPMU_ZDMA_3 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_3_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFFAC0000U)
		#define XPMU_ZDMA_4 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_4_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFFAD0000U)
		#define XPMU_ZDMA_5 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_5_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFFAE0000U)
		#define XPMU_ZDMA_6 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_6_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFFAF0000U)
		#define XPMU_ZDMA_7 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_7_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFD500000U)
		#define XPMU_ZDMA_8 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_8_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFD510000U)
		#define XPMU_ZDMA_9 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_9_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFD520000U)
		#define XPMU_ZDMA_10 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_10_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFD530000U)
		#define XPMU_ZDMA_11 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_11_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_0_BASEADDR
	#elif (XPAR_XZDMA_0_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_0_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_0_BASEADDR
	#endif
#endif /*XPAR_XZDMA_0_DEVICE_ID*/
#if (defined(XPAR_XZDMA_1_DEVICE_ID)) || (defined(XPAR_XZDMA_1_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_1_DEVICE_ID XPAR_XZDMA_1_BASEADDR
#endif
	#if (XPAR_XZDMA_1_BASEADDR == 0xFFA90000U)
		#define XPMU_ZDMA_1 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_1_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFFAA0000U)
		#define XPMU_ZDMA_2 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_2_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFFAB0000U)
		#define XPMU_ZDMA_3 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_3_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFFAC0000U)
		#define XPMU_ZDMA_4 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_4_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFFAD0000U)
		#define XPMU_ZDMA_5 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_5_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFFAE0000U)
		#define XPMU_ZDMA_6 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_6_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFFAF0000U)
		#define XPMU_ZDMA_7 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_7_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFD500000U)
		#define XPMU_ZDMA_8 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_8_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFD510000U)
		#define XPMU_ZDMA_9 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_9_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFD520000U)
		#define XPMU_ZDMA_10 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_10_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFD530000U)
		#define XPMU_ZDMA_11 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_11_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_1_BASEADDR
	#elif (XPAR_XZDMA_1_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_1_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_1_BASEADDR
	#endif
#endif /*XPAR_XZDMA_1_DEVICE_ID*/
#if (defined(XPAR_XZDMA_2_DEVICE_ID)) || (defined(XPAR_XZDMA_2_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_2_DEVICE_ID XPAR_XZDMA_2_BASEADDR
#endif

	#if (XPAR_XZDMA_2_BASEADDR == 0xFFAA0000U)
		#define XPMU_ZDMA_2 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_2_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFFAB0000U)
		#define XPMU_ZDMA_3 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_3_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFFAC0000U)
		#define XPMU_ZDMA_4 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_4_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFFAD0000U)
		#define XPMU_ZDMA_5 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_5_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFFAE0000U)
		#define XPMU_ZDMA_6 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_6_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFFAF0000U)
		#define XPMU_ZDMA_7 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_7_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFD500000U)
		#define XPMU_ZDMA_8 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_8_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFD510000U)
		#define XPMU_ZDMA_9 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_9_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFD520000U)
		#define XPMU_ZDMA_10 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_10_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFD530000U)
		#define XPMU_ZDMA_11 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_11_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_2_BASEADDR
	#elif (XPAR_XZDMA_2_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_2_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_2_BASEADDR
	#endif
#endif /*XPAR_XZDMA_2_DEVICE_ID*/
#if (defined(XPAR_XZDMA_3_DEVICE_ID)) || (defined(XPAR_XZDMA_3_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_3_DEVICE_ID XPAR_XZDMA_3_BASEADDR
#endif
	#if (XPAR_XZDMA_3_BASEADDR == 0xFFAB0000U)
		#define XPMU_ZDMA_3 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_3_BASEADDR XPAR_XZDMA_3_BASEADDR
	#elif (XPAR_XZDMA_3_BASEADDR == 0xFFAC0000U)
		#define XPMU_ZDMA_4 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_4_BASEADDR XPAR_XZDMA_3_BASEADDR
	#elif (XPAR_XZDMA_3_BASEADDR == 0xFFAD0000U)
		#define XPMU_ZDMA_5 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_5_BASEADDR XPAR_XZDMA_3_BASEADDR
	#elif (XPAR_XZDMA_3_BASEADDR == 0xFFAE0000U)
		#define XPMU_ZDMA_6 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_6_BASEADDR XPAR_XZDMA_3_BASEADDR
	#elif (XPAR_XZDMA_3_BASEADDR == 0xFFAF0000U)
		#define XPMU_ZDMA_7 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_7_BASEADDR XPAR_XZDMA_3_BASEADDR
	#elif (XPAR_XZDMA_3_BASEADDR == 0xFD500000U)
		#define XPMU_ZDMA_8 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_8_BASEADDR XPAR_XZDMA_3_BASEADDR
	#elif (XPAR_XZDMA_3_BASEADDR == 0xFD510000U)
		#define XPMU_ZDMA_9 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_9_BASEADDR XPAR_XZDMA_3_BASEADDR
	#elif (XPAR_XZDMA_3_BASEADDR == 0xFD520000U)
		#define XPMU_ZDMA_10 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_10_BASEADDR XPAR_XZDMA_3_BASEADDR
	#elif (XPAR_XZDMA_3_BASEADDR == 0xFD530000U)
		#define XPMU_ZDMA_11 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_11_BASEADDR XPAR_XZDMA_3_BASEADDR
	#elif (XPAR_XZDMA_3_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_3_BASEADDR
	#elif (XPAR_XZDMA_3_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_3_BASEADDR
	#elif (XPAR_XZDMA_3_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_3_BASEADDR
	#elif (XPAR_XZDMA_3_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_3_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_3_BASEADDR
	#endif
#endif /*XPAR_XZDMA_3_DEVICE_ID*/
#if (defined(XPAR_XZDMA_4_DEVICE_ID)) || (defined(XPAR_XZDMA_4_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_4_DEVICE_ID XPAR_XZDMA_4_BASEADDR
#endif
	#if (XPAR_XZDMA_4_BASEADDR == 0xFFAC0000U)
		#define XPMU_ZDMA_4 XPAR_XZDMA_4_DEVICE_ID
		#define XPMU_ZDMA_4_BASEADDR XPAR_XZDMA_4_BASEADDR
	#elif (XPAR_XZDMA_4_BASEADDR == 0xFFAD0000U)
		#define XPMU_ZDMA_5 XPAR_XZDMA_4_DEVICE_ID
		#define XPMU_ZDMA_5_BASEADDR XPAR_XZDMA_4_BASEADDR
	#elif (XPAR_XZDMA_4_BASEADDR == 0xFFAE0000U)
		#define XPMU_ZDMA_6 XPAR_XZDMA_4_DEVICE_ID
		#define XPMU_ZDMA_6_BASEADDR XPAR_XZDMA_4_BASEADDR
	#elif (XPAR_XZDMA_4_BASEADDR == 0xFFAF0000U)
		#define XPMU_ZDMA_7 XPAR_XZDMA_4_DEVICE_ID
		#define XPMU_ZDMA_7_BASEADDR XPAR_XZDMA_4_BASEADDR
	#elif (XPAR_XZDMA_4_BASEADDR == 0xFD500000U)
		#define XPMU_ZDMA_8 XPAR_XZDMA_4_DEVICE_ID
		#define XPMU_ZDMA_8_BASEADDR XPAR_XZDMA_4_BASEADDR
	#elif (XPAR_XZDMA_4_BASEADDR == 0xFD510000U)
		#define XPMU_ZDMA_9 XPAR_XZDMA_4_DEVICE_ID
		#define XPMU_ZDMA_9_BASEADDR XPAR_XZDMA_4_BASEADDR
	#elif (XPAR_XZDMA_4_BASEADDR == 0xFD520000U)
		#define XPMU_ZDMA_10 XPAR_XZDMA_4_DEVICE_ID
		#define XPMU_ZDMA_10_BASEADDR XPAR_XZDMA_4_BASEADDR
	#elif (XPAR_XZDMA_4_BASEADDR == 0xFD530000U)
		#define XPMU_ZDMA_11 XPAR_XZDMA_4_DEVICE_ID
		#define XPMU_ZDMA_11_BASEADDR XPAR_XZDMA_4_BASEADDR
	#elif (XPAR_XZDMA_4_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_4_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_4_BASEADDR
	#elif (XPAR_XZDMA_4_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_4_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_4_BASEADDR
	#elif (XPAR_XZDMA_4_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_4_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_4_BASEADDR
	#elif (XPAR_XZDMA_4_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_4_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_4_BASEADDR
	#endif
#endif /*XPAR_XZDMA_4_DEVICE_ID*/
#if (defined(XPAR_XZDMA_5_DEVICE_ID)) || (defined(XPAR_XZDMA_5_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_5_DEVICE_ID XPAR_XZDMA_5_BASEADDR
#endif
	#if (XPAR_XZDMA_5_BASEADDR == 0xFFAD0000U)
		#define XPMU_ZDMA_5 XPAR_XZDMA_5_DEVICE_ID
		#define XPMU_ZDMA_5_BASEADDR XPAR_XZDMA_5_BASEADDR
	#elif (XPAR_XZDMA_5_BASEADDR == 0xFFAE0000U)
		#define XPMU_ZDMA_6 XPAR_XZDMA_5_DEVICE_ID
		#define XPMU_ZDMA_6_BASEADDR XPAR_XZDMA_5_BASEADDR
	#elif (XPAR_XZDMA_5_BASEADDR == 0xFFAF0000U)
		#define XPMU_ZDMA_7 XPAR_XZDMA_5_DEVICE_ID
		#define XPMU_ZDMA_7_BASEADDR XPAR_XZDMA_5_BASEADDR
	#elif (XPAR_XZDMA_5_BASEADDR == 0xFD500000U)
		#define XPMU_ZDMA_8 XPAR_XZDMA_5_DEVICE_ID
		#define XPMU_ZDMA_8_BASEADDR XPAR_XZDMA_5_BASEADDR
	#elif (XPAR_XZDMA_5_BASEADDR == 0xFD510000U)
		#define XPMU_ZDMA_9 XPAR_XZDMA_5_DEVICE_ID
		#define XPMU_ZDMA_9_BASEADDR XPAR_XZDMA_5_BASEADDR
	#elif (XPAR_XZDMA_5_BASEADDR == 0xFD520000U)
		#define XPMU_ZDMA_10 XPAR_XZDMA_5_DEVICE_ID
		#define XPMU_ZDMA_10_BASEADDR XPAR_XZDMA_5_BASEADDR
	#elif (XPAR_XZDMA_5_BASEADDR == 0xFD530000U)
		#define XPMU_ZDMA_11 XPAR_XZDMA_5_DEVICE_ID
		#define XPMU_ZDMA_11_BASEADDR XPAR_XZDMA_5_BASEADDR
	#elif (XPAR_XZDMA_5_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_5_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_5_BASEADDR
	#elif (XPAR_XZDMA_5_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_5_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_5_BASEADDR
	#elif (XPAR_XZDMA_5_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_5_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_5_BASEADDR
	#elif (XPAR_XZDMA_5_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_5_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_5_BASEADDR
	#endif
#endif /*XPAR_XZDMA_5_DEVICE_ID*/
#if (defined(XPAR_XZDMA_6_DEVICE_ID)) || (defined(XPAR_XZDMA_6_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_6_DEVICE_ID XPAR_XZDMA_6_BASEADDR
#endif
	#if (XPAR_XZDMA_6_BASEADDR == 0xFFAE0000U)
		#define XPMU_ZDMA_6 XPAR_XZDMA_6_DEVICE_ID
		#define XPMU_ZDMA_6_BASEADDR XPAR_XZDMA_6_BASEADDR
	#elif (XPAR_XZDMA_6_BASEADDR == 0xFFAF0000U)
		#define XPMU_ZDMA_7 XPAR_XZDMA_6_DEVICE_ID
		#define XPMU_ZDMA_7_BASEADDR XPAR_XZDMA_6_BASEADDR
	#elif (XPAR_XZDMA_6_BASEADDR == 0xFD500000U)
		#define XPMU_ZDMA_8 XPAR_XZDMA_6_DEVICE_ID
		#define XPMU_ZDMA_8_BASEADDR XPAR_XZDMA_6_BASEADDR
	#elif (XPAR_XZDMA_6_BASEADDR == 0xFD510000U)
		#define XPMU_ZDMA_9 XPAR_XZDMA_6_DEVICE_ID
		#define XPMU_ZDMA_9_BASEADDR XPAR_XZDMA_6_BASEADDR
	#elif (XPAR_XZDMA_6_BASEADDR == 0xFD520000U)
		#define XPMU_ZDMA_10 XPAR_XZDMA_6_DEVICE_ID
		#define XPMU_ZDMA_10_BASEADDR XPAR_XZDMA_6_BASEADDR
	#elif (XPAR_XZDMA_6_BASEADDR == 0xFD530000U)
		#define XPMU_ZDMA_11 XPAR_XZDMA_6_DEVICE_ID
		#define XPMU_ZDMA_11_BASEADDR XPAR_XZDMA_6_BASEADDR
	#elif (XPAR_XZDMA_6_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_6_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_6_BASEADDR
	#elif (XPAR_XZDMA_6_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_6_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_6_BASEADDR
	#elif (XPAR_XZDMA_6_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_6_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_6_BASEADDR
	#elif (XPAR_XZDMA_6_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_6_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_6_BASEADDR
	#endif
#endif /*XPAR_XZDMA_6_DEVICE_ID*/
#if (defined(XPAR_XZDMA_7_DEVICE_ID)) || (defined(XPAR_XZDMA_7_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_7_DEVICE_ID XPAR_XZDMA_7_BASEADDR
#endif
	#if (XPAR_XZDMA_7_BASEADDR == 0xFFAF0000U)
		#define XPMU_ZDMA_7 XPAR_XZDMA_7_DEVICE_ID
		#define XPMU_ZDMA_7_BASEADDR XPAR_XZDMA_7_BASEADDR
	#elif (XPAR_XZDMA_7_BASEADDR == 0xFD500000U)
		#define XPMU_ZDMA_8 XPAR_XZDMA_7_DEVICE_ID
		#define XPMU_ZDMA_8_BASEADDR XPAR_XZDMA_7_BASEADDR
	#elif (XPAR_XZDMA_7_BASEADDR == 0xFD510000U)
		#define XPMU_ZDMA_9 XPAR_XZDMA_7_DEVICE_ID
		#define XPMU_ZDMA_9_BASEADDR XPAR_XZDMA_7_BASEADDR
	#elif (XPAR_XZDMA_7_BASEADDR == 0xFD520000U)
		#define XPMU_ZDMA_10 XPAR_XZDMA_7_DEVICE_ID
		#define XPMU_ZDMA_10_BASEADDR XPAR_XZDMA_7_BASEADDR
	#elif (XPAR_XZDMA_7_BASEADDR == 0xFD530000U)
		#define XPMU_ZDMA_11 XPAR_XZDMA_7_DEVICE_ID
		#define XPMU_ZDMA_11_BASEADDR XPAR_XZDMA_7_BASEADDR
	#elif (XPAR_XZDMA_7_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_7_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_7_BASEADDR
	#elif (XPAR_XZDMA_7_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_7_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_7_BASEADDR
	#elif (XPAR_XZDMA_7_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_7_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_7_BASEADDR
	#elif (XPAR_XZDMA_7_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_7_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_7_BASEADDR
	#endif
#endif /*XPAR_XZDMA_7_DEVICE_ID*/
#if (defined(XPAR_XZDMA_8_DEVICE_ID)) || (defined(XPAR_XZDMA_8_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_8_DEVICE_ID XPAR_XZDMA_8_BASEADDR
#endif
	#if (XPAR_XZDMA_8_BASEADDR == 0xFD500000U)
		#define XPMU_ZDMA_8 XPAR_XZDMA_8_DEVICE_ID
		#define XPMU_ZDMA_8_BASEADDR XPAR_XZDMA_8_BASEADDR
	#elif (XPAR_XZDMA_8_BASEADDR == 0xFD510000U)
		#define XPMU_ZDMA_9 XPAR_XZDMA_8_DEVICE_ID
		#define XPMU_ZDMA_9_BASEADDR XPAR_XZDMA_8_BASEADDR
	#elif (XPAR_XZDMA_8_BASEADDR == 0xFD520000U)
		#define XPMU_ZDMA_10 XPAR_XZDMA_8_DEVICE_ID
		#define XPMU_ZDMA_10_BASEADDR XPAR_XZDMA_8_BASEADDR
	#elif (XPAR_XZDMA_8_BASEADDR == 0xFD530000U)
		#define XPMU_ZDMA_11 XPAR_XZDMA_8_DEVICE_ID
		#define XPMU_ZDMA_11_BASEADDR XPAR_XZDMA_8_BASEADDR
	#elif (XPAR_XZDMA_8_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_8_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_8_BASEADDR
	#elif (XPAR_XZDMA_8_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_8_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_8_BASEADDR
	#elif (XPAR_XZDMA_8_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_8_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_8_BASEADDR
	#elif (XPAR_XZDMA_8_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_8_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_8_BASEADDR
	#endif
#endif /*XPAR_XZDMA_8_DEVICE_ID*/
#if (defined(XPAR_XZDMA_9_DEVICE_ID)) || (defined(XPAR_XZDMA_9_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_9_DEVICE_ID XPAR_XZDMA_9_BASEADDR
#endif
	#if (XPAR_XZDMA_9_BASEADDR == 0xFD510000U)
		#define XPMU_ZDMA_9 XPAR_XZDMA_9_DEVICE_ID
		#define XPMU_ZDMA_9_BASEADDR XPAR_XZDMA_9_BASEADDR
	#elif (XPAR_XZDMA_9_BASEADDR == 0xFD520000U)
		#define XPMU_ZDMA_10 XPAR_XZDMA_9_DEVICE_ID
		#define XPMU_ZDMA_10_BASEADDR XPAR_XZDMA_9_BASEADDR
	#elif (XPAR_XZDMA_9_BASEADDR == 0xFD530000U)
		#define XPMU_ZDMA_11 XPAR_XZDMA_9_DEVICE_ID
		#define XPMU_ZDMA_11_BASEADDR XPAR_XZDMA_9_BASEADDR
	#elif (XPAR_XZDMA_9_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_9_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_9_BASEADDR
	#elif (XPAR_XZDMA_9_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_9_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_9_BASEADDR
	#elif (XPAR_XZDMA_9_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_9_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_9_BASEADDR
	#elif (XPAR_XZDMA_9_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_9_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_9_BASEADDR
	#endif
#endif /*XPAR_XZDMA_9_DEVICE_ID*/
#if (defined(XPAR_XZDMA_10_DEVICE_ID)) || (defined(XPAR_XZDMA_10_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_10_DEVICE_ID XPAR_XZDMA_10_BASEADDR
#endif
	#if (XPAR_XZDMA_10_BASEADDR == 0xFD520000U)
		#define XPMU_ZDMA_10 XPAR_XZDMA_10_DEVICE_ID
		#define XPMU_ZDMA_10_BASEADDR XPAR_XZDMA_10_BASEADDR
	#elif (XPAR_XZDMA_10_BASEADDR == 0xFD530000U)
		#define XPMU_ZDMA_11 XPAR_XZDMA_10_DEVICE_ID
		#define XPMU_ZDMA_11_BASEADDR XPAR_XZDMA_10_BASEADDR
	#elif (XPAR_XZDMA_10_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_10_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_10_BASEADDR
	#elif (XPAR_XZDMA_10_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_10_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_10_BASEADDR
	#elif (XPAR_XZDMA_10_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_10_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_10_BASEADDR
	#elif (XPAR_XZDMA_10_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_10_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_10_BASEADDR
	#endif
#endif /*XPAR_XZDMA_10_DEVICE_ID*/
#if (defined(XPAR_XZDMA_11_DEVICE_ID)) || (defined(XPAR_XZDMA_11_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_11_DEVICE_ID XPAR_XZDMA_11_BASEADDR
#endif
	#if (XPAR_XZDMA_11_BASEADDR == 0xFD530000U)
		#define XPMU_ZDMA_11 XPAR_XZDMA_11_DEVICE_ID
		#define XPMU_ZDMA_11_BASEADDR XPAR_XZDMA_11_BASEADDR
	#elif (XPAR_XZDMA_11_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_11_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_11_BASEADDR
	#elif (XPAR_XZDMA_11_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_11_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_11_BASEADDR
	#elif (XPAR_XZDMA_11_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_11_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_11_BASEADDR
	#elif (XPAR_XZDMA_11_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_11_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_11_BASEADDR
	#endif
#endif /*XPAR_XZDMA_11_DEVICE_ID*/
#if (defined(XPAR_XZDMA_12_DEVICE_ID)) || (defined(XPAR_XZDMA_12_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_12_DEVICE_ID XPAR_XZDMA_12_BASEADDR
#endif
	#if (XPAR_XZDMA_12_BASEADDR == 0xFD540000U)
		#define XPMU_ZDMA_12 XPAR_XZDMA_12_DEVICE_ID
		#define XPMU_ZDMA_12_BASEADDR XPAR_XZDMA_12_BASEADDR
	#elif (XPAR_XZDMA_12_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_12_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_12_BASEADDR
	#elif (XPAR_XZDMA_12_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_12_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_12_BASEADDR
	#elif (XPAR_XZDMA_12_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_12_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_12_BASEADDR
	#endif
#endif /*XPAR_XZDMA_12_DEVICE_ID*/
#if (defined(XPAR_XZDMA_13_DEVICE_ID)) || (defined(XPAR_XZDMA_13_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_13_DEVICE_ID XPAR_XZDMA_13_BASEADDR
#endif
	#if (XPAR_XZDMA_13_BASEADDR == 0xFD550000U)
		#define XPMU_ZDMA_13 XPAR_XZDMA_13_DEVICE_ID
		#define XPMU_ZDMA_13_BASEADDR XPAR_XZDMA_13_BASEADDR
	#elif (XPAR_XZDMA_13_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_13_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_13_BASEADDR
	#elif (XPAR_XZDMA_13_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_13_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_13_BASEADDR
	#endif
#endif /*XPAR_XZDMA_13_DEVICE_ID*/
#if (defined(XPAR_XZDMA_14_DEVICE_ID)) || (defined(XPAR_XZDMA_14_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_14_DEVICE_ID XPAR_XZDMA_14_BASEADDR
#endif
	#if (XPAR_XZDMA_14_BASEADDR == 0xFD560000U)
		#define XPMU_ZDMA_14 XPAR_XZDMA_14_DEVICE_ID
		#define XPMU_ZDMA_14_BASEADDR XPAR_XZDMA_14_BASEADDR
	#elif (XPAR_XZDMA_14_BASEADDR == 0xFD570000U)
		#define XPMU_ZDMA_15 XPAR_XZDMA_14_DEVICE_ID
		#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_14_BASEADDR
	#endif
#endif /*XPAR_XZDMA_14_DEVICE_ID*/
#if (defined(XPAR_XZDMA_15_DEVICE_ID)) || (defined(XPAR_XZDMA_15_BASEADDR))
#ifdef SDT
#define XPAR_XZDMA_15_DEVICE_ID XPAR_XZDMA_15_BASEADDR
#endif
	#define XPMU_ZDMA_15 XPAR_XZDMA_15_DEVICE_ID
	#define XPMU_ZDMA_15_BASEADDR XPAR_XZDMA_15_BASEADDR
#endif /*XPAR_XZDMA_15_DEVICE_ID*/

/* XPMU_PMUWDT, XPMU_LPDWDT, XPMU_FPDWDT*/
#if (defined(XPAR_XWDTPS_0_DEVICE_ID)) || (defined(XPAR_XWDTPS_0_BASEADDR))
	#if (XPAR_XWDTPS_0_BASEADDR == 0xFFCB0000U)
#ifdef SDT
#define XPAR_XWDTPS_0_DEVICE_ID XPAR_XWDTPS_0_BASEADDR
#endif
		#define XPMU_PMUWDT XPAR_XWDTPS_0_DEVICE_ID
		#define XPMU_PMUWDT_BASEADDR XPAR_XWDTPS_0_BASEADDR
		#define XPMU_PMUWDT_WDT_CLK XPAR_XWDTPS_0_WDT_CLK_FREQ_HZ
	#elif (XPAR_XWDTPS_0_BASEADDR == 0xFF150000U)
#ifdef SDT
#define XPAR_XWDTPS_0_DEVICE_ID XPAR_XWDTPS_0_BASEADDR
#endif
		#define XPMU_LPDWDT XPAR_XWDTPS_0_DEVICE_ID
		#define XPMU_LPDWDT_BASEADDR XPAR_XWDTPS_0_BASEADDR
		#define XPMU_LPDWDT_WDT_CLK XPAR_XWDTPS_0_WDT_CLK_FREQ_HZ
	#elif (XPAR_XWDTPS_0_BASEADDR == 0xFD4D0000U)
#ifdef SDT
#define XPAR_XWDTPS_0_DEVICE_ID XPAR_XWDTPS_0_BASEADDR
#endif
		#define XPMU_FPDWDT XPAR_XWDTPS_0_DEVICE_ID
		#define XPMU_FPDWDT_BASEADDR XPAR_XWDTPS_0_BASEADDR
		#define XPMU_FPDWDT_WDT_CLK XPAR_XWDTPS_0_WDT_CLK_FREQ_HZ
	#endif
#endif /*XPAR_XWDTPS_0_DEVICE_ID*/
#if (defined(XPAR_XWDTPS_1_DEVICE_ID)) || (defined(XPAR_XWDTPS_1_BASEADDR))
	#if (XPAR_XWDTPS_1_BASEADDR == 0xFFCB0000U)
#ifdef SDT
#define XPAR_XWDTPS_1_DEVICE_ID XPAR_XWDTPS_1_BASEADDR
#endif
		#define XPMU_PMUWDT XPAR_XWDTPS_1_DEVICE_ID
		#define XPMU_PMUWDT_BASEADDR XPAR_XWDTPS_1_BASEADDR
		#define XPMU_PMUWDT_WDT_CLK XPAR_XWDTPS_1_WDT_CLK_FREQ_HZ
	#elif (XPAR_XWDTPS_1_BASEADDR == 0xFF150000U)
#ifdef SDT
#define XPAR_XWDTPS_1_DEVICE_ID XPAR_XWDTPS_1_BASEADDR
#endif
		#define XPMU_LPDWDT XPAR_XWDTPS_1_DEVICE_ID
		#define XPMU_LPDWDT_BASEADDR XPAR_XWDTPS_1_BASEADDR
		#define XPMU_LPDWDT_WDT_CLK XPAR_XWDTPS_1_WDT_CLK_FREQ_HZ
	#elif (XPAR_XWDTPS_1_BASEADDR == 0xFD4D0000U)
#ifdef SDT
#define XPAR_XWDTPS_1_DEVICE_ID XPAR_XWDTPS_1_BASEADDR
#endif
		#define XPMU_FPDWDT XPAR_XWDTPS_1_DEVICE_ID
		#define XPMU_FPDWDT_BASEADDR XPAR_XWDTPS_1_BASEADDR
		#define XPMU_FPDWDT_WDT_CLK XPAR_XWDTPS_1_WDT_CLK_FREQ_HZ
	#endif
#endif /*XPAR_XWDTPS_1_DEVICE_ID*/
#if (defined(XPAR_XWDTPS_2_DEVICE_ID)) || (defined(XPAR_XWDTPS_2_BASEADDR))
	#if (XPAR_XWDTPS_2_BASEADDR == 0xFFCB0000U)
#ifdef SDT
#define XPAR_XWDTPS_2_DEVICE_ID XPAR_XWDTPS_2_BASEADDR
#endif
		#define XPMU_PMUWDT XPAR_XWDTPS_2_DEVICE_ID
		#define XPMU_PMUWDT_BASEADDR XPAR_XWDTPS_2_BASEADDR
		#define XPMU_PMUWDT_WDT_CLK XPAR_XWDTPS_2_WDT_CLK_FREQ_HZ
	#elif (XPAR_XWDTPS_2_BASEADDR == 0xFF150000U)
#ifdef SDT
#define XPAR_XWDTPS_2_DEVICE_ID XPAR_XWDTPS_2_BASEADDR
#endif
		#define XPMU_LPDWDT XPAR_XWDTPS_2_DEVICE_ID
		#define XPMU_LPDWDT_BASEADDR XPAR_XWDTPS_2_BASEADDR
		#define XPMU_LPDWDT_WDT_CLK XPAR_XWDTPS_2_WDT_CLK_FREQ_HZ
	#elif (XPAR_XWDTPS_2_BASEADDR == 0xFD4D0000U)
#ifdef SDT
#define XPAR_XWDTPS_2_DEVICE_ID XPAR_XWDTPS_2_BASEADDR
#endif
		#define XPMU_FPDWDT XPAR_XWDTPS_2_DEVICE_ID
		#define XPMU_FPDWDT_BASEADDR XPAR_XWDTPS_2_BASEADDR
		#define XPMU_FPDWDT_WDT_CLK XPAR_XWDTPS_2_WDT_CLK_FREQ_HZ
	#endif
#endif /*XPAR_XWDTPS_2_DEVICE_ID*/

/* XPMU_XTTCPS_0 to XPMU_XTTCPS_11 */
#if (defined(XPAR_XTTCPS_0_DEVICE_ID)) || (defined(XPAR_XTTCPS_0_BASEADDR))
#ifdef SDT
#define XPAR_XTTCPS_0_DEVICE_ID XPAR_XTTCPS_0_BASEADDR
#endif
	#if (XPAR_XTTCPS_0_BASEADDR == 0xFF110000U)
		#define XPMU_XTTCPS_0 XPAR_XTTCPS_0_DEVICE_ID
		#define XPMU_XTTCPS_0_BASEADDR XPAR_XTTCPS_0_BASEADDR
	#elif (XPAR_XTTCPS_0_BASEADDR == 0xFF110004U)
		#define XPMU_XTTCPS_1 XPAR_XTTCPS_0_DEVICE_ID
		#define XPMU_XTTCPS_1_BASEADDR XPAR_XTTCPS_0_BASEADDR
	#elif (XPAR_XTTCPS_0_BASEADDR == 0xFF110008U)
		#define XPMU_XTTCPS_2 XPAR_XTTCPS_0_DEVICE_ID
		#define XPMU_XTTCPS_2_BASEADDR XPAR_XTTCPS_0_BASEADDR
	#elif (XPAR_XTTCPS_0_BASEADDR == 0xFF120000U)
		#define XPMU_XTTCPS_3 XPAR_XTTCPS_0_DEVICE_ID
		#define XPMU_XTTCPS_3_BASEADDR XPAR_XTTCPS_0_BASEADDR
	#elif (XPAR_XTTCPS_0_BASEADDR == 0xFF120004U)
		#define XPMU_XTTCPS_4 XPAR_XTTCPS_0_DEVICE_ID
		#define XPMU_XTTCPS_4_BASEADDR XPAR_XTTCPS_0_BASEADDR
	#elif (XPAR_XTTCPS_0_BASEADDR == 0xFF120008U)
		#define XPMU_XTTCPS_5 XPAR_XTTCPS_0_DEVICE_ID
		#define XPMU_XTTCPS_5_BASEADDR XPAR_XTTCPS_0_BASEADDR
	#elif (XPAR_XTTCPS_0_BASEADDR == 0xFF130000U)
		#define XPMU_XTTCPS_6 XPAR_XTTCPS_0_DEVICE_ID
		#define XPMU_XTTCPS_6_BASEADDR XPAR_XTTCPS_0_BASEADDR
	#elif (XPAR_XTTCPS_0_BASEADDR == 0xFF130004U)
		#define XPMU_XTTCPS_7 XPAR_XTTCPS_0_DEVICE_ID
		#define XPMU_XTTCPS_7_BASEADDR XPAR_XTTCPS_0_BASEADDR
	#elif (XPAR_XTTCPS_0_BASEADDR == 0xFF130008U)
		#define XPMU_XTTCPS_8 XPAR_XTTCPS_0_DEVICE_ID
		#define XPMU_XTTCPS_8_BASEADDR XPAR_XTTCPS_0_BASEADDR
	#elif (XPAR_XTTCPS_0_BASEADDR == 0xFF140000U)
		#define XPMU_XTTCPS_9 XPAR_XTTCPS_0_DEVICE_ID
		#define XPMU_XTTCPS_9_BASEADDR XPAR_XTTCPS_0_BASEADDR
	#elif (XPAR_XTTCPS_0_BASEADDR == 0xFF140004U)
		#define XPMU_XTTCPS_10 XPAR_XTTCPS_0_DEVICE_ID
		#define XPMU_XTTCPS_10_BASEADDR XPAR_XTTCPS_0_BASEADDR
	#elif (XPAR_XTTCPS_0_BASEADDR == 0xFF140008U)
		#define XPMU_XTTCPS_11 XPAR_XTTCPS_0_DEVICE_ID
		#define XPMU_XTTCPS_11_BASEADDR XPAR_XTTCPS_0_BASEADDR
	#endif
#endif /*XPAR_XTTCPS_0_DEVICE_ID*/
#if (defined(XPAR_XTTCPS_1_DEVICE_ID)) || (defined(XPAR_XTTCPS_1_BASEADDR))
#ifdef SDT
#define XPAR_XTTCPS_1_DEVICE_ID XPAR_XTTCPS_1_BASEADDR
#endif
	#if (XPAR_XTTCPS_1_BASEADDR == 0xFF110004U)
		#define XPMU_XTTCPS_1 XPAR_XTTCPS_1_DEVICE_ID
		#define XPMU_XTTCPS_1_BASEADDR XPAR_XTTCPS_1_BASEADDR
	#elif (XPAR_XTTCPS_1_BASEADDR == 0xFF110008U)
		#define XPMU_XTTCPS_2 XPAR_XTTCPS_1_DEVICE_ID
		#define XPMU_XTTCPS_2_BASEADDR XPAR_XTTCPS_1_BASEADDR
	#elif (XPAR_XTTCPS_1_BASEADDR == 0xFF120000U)
		#define XPMU_XTTCPS_3 XPAR_XTTCPS_1_DEVICE_ID
		#define XPMU_XTTCPS_3_BASEADDR XPAR_XTTCPS_1_BASEADDR
	#elif (XPAR_XTTCPS_1_BASEADDR == 0xFF120004U)
		#define XPMU_XTTCPS_4 XPAR_XTTCPS_1_DEVICE_ID
		#define XPMU_XTTCPS_4_BASEADDR XPAR_XTTCPS_1_BASEADDR
	#elif (XPAR_XTTCPS_1_BASEADDR == 0xFF120008U)
		#define XPMU_XTTCPS_5 XPAR_XTTCPS_1_DEVICE_ID
		#define XPMU_XTTCPS_5_BASEADDR XPAR_XTTCPS_1_BASEADDR
	#elif (XPAR_XTTCPS_1_BASEADDR == 0xFF130000U)
		#define XPMU_XTTCPS_6 XPAR_XTTCPS_1_DEVICE_ID
		#define XPMU_XTTCPS_6_BASEADDR XPAR_XTTCPS_1_BASEADDR
	#elif (XPAR_XTTCPS_1_BASEADDR == 0xFF130004U)
		#define XPMU_XTTCPS_7 XPAR_XTTCPS_1_DEVICE_ID
		#define XPMU_XTTCPS_7_BASEADDR XPAR_XTTCPS_1_BASEADDR
	#elif (XPAR_XTTCPS_1_BASEADDR == 0xFF130008U)
		#define XPMU_XTTCPS_8 XPAR_XTTCPS_1_DEVICE_ID
		#define XPMU_XTTCPS_8_BASEADDR XPAR_XTTCPS_1_BASEADDR
	#elif (XPAR_XTTCPS_1_BASEADDR == 0xFF140000U)
		#define XPMU_XTTCPS_9 XPAR_XTTCPS_1_DEVICE_ID
		#define XPMU_XTTCPS_9_BASEADDR XPAR_XTTCPS_1_BASEADDR
	#elif (XPAR_XTTCPS_1_BASEADDR == 0xFF140004U)
		#define XPMU_XTTCPS_10 XPAR_XTTCPS_1_DEVICE_ID
		#define XPMU_XTTCPS_10_BASEADDR XPAR_XTTCPS_1_BASEADDR
	#elif (XPAR_XTTCPS_1_BASEADDR == 0xFF140008U)
		#define XPMU_XTTCPS_11 XPAR_XTTCPS_1_DEVICE_ID
		#define XPMU_XTTCPS_11_BASEADDR XPAR_XTTCPS_1_BASEADDR
	#endif
#endif /*XPAR_XTTCPS_1_DEVICE_ID*/
#if (defined(XPAR_XTTCPS_2_DEVICE_ID)) || (defined(XPAR_XTTCPS_2_BASEADDR))
#ifdef SDT
#define XPAR_XTTCPS_2_DEVICE_ID XPAR_XTTCPS_2_BASEADDR
#endif
	#if (XPAR_XTTCPS_2_BASEADDR == 0xFF110008U)
		#define XPMU_XTTCPS_2 XPAR_XTTCPS_2_DEVICE_ID
		#define XPMU_XTTCPS_2_BASEADDR XPAR_XTTCPS_2_BASEADDR
	#elif (XPAR_XTTCPS_2_BASEADDR == 0xFF120000U)
		#define XPMU_XTTCPS_3 XPAR_XTTCPS_2_DEVICE_ID
		#define XPMU_XTTCPS_3_BASEADDR XPAR_XTTCPS_2_BASEADDR
	#elif (XPAR_XTTCPS_2_BASEADDR == 0xFF120004U)
		#define XPMU_XTTCPS_4 XPAR_XTTCPS_2_DEVICE_ID
		#define XPMU_XTTCPS_4_BASEADDR XPAR_XTTCPS_2_BASEADDR
	#elif (XPAR_XTTCPS_2_BASEADDR == 0xFF120008U)
		#define XPMU_XTTCPS_5 XPAR_XTTCPS_2_DEVICE_ID
		#define XPMU_XTTCPS_5_BASEADDR XPAR_XTTCPS_2_BASEADDR
	#elif (XPAR_XTTCPS_2_BASEADDR == 0xFF130000U)
		#define XPMU_XTTCPS_6 XPAR_XTTCPS_2_DEVICE_ID
		#define XPMU_XTTCPS_6_BASEADDR XPAR_XTTCPS_2_BASEADDR
	#elif (XPAR_XTTCPS_2_BASEADDR == 0xFF130004U)
		#define XPMU_XTTCPS_7 XPAR_XTTCPS_2_DEVICE_ID
		#define XPMU_XTTCPS_7_BASEADDR XPAR_XTTCPS_2_BASEADDR
	#elif (XPAR_XTTCPS_2_BASEADDR == 0xFF130008U)
		#define XPMU_XTTCPS_8 XPAR_XTTCPS_2_DEVICE_ID
		#define XPMU_XTTCPS_8_BASEADDR XPAR_XTTCPS_2_BASEADDR
	#elif (XPAR_XTTCPS_2_BASEADDR == 0xFF140000U)
		#define XPMU_XTTCPS_9 XPAR_XTTCPS_2_DEVICE_ID
		#define XPMU_XTTCPS_9_BASEADDR XPAR_XTTCPS_2_BASEADDR
	#elif (XPAR_XTTCPS_2_BASEADDR == 0xFF140004U)
		#define XPMU_XTTCPS_10 XPAR_XTTCPS_2_DEVICE_ID
		#define XPMU_XTTCPS_10_BASEADDR XPAR_XTTCPS_2_BASEADDR
	#elif (XPAR_XTTCPS_2_BASEADDR == 0xFF140008U)
		#define XPMU_XTTCPS_11 XPAR_XTTCPS_2_DEVICE_ID
		#define XPMU_XTTCPS_11_BASEADDR XPAR_XTTCPS_2_BASEADDR
	#endif
#endif /*XPAR_XTTCPS_2_DEVICE_ID*/
#if (defined(XPAR_XTTCPS_3_DEVICE_ID)) || (defined(XPAR_XTTCPS_3_BASEADDR))
#ifdef SDT
#define XPAR_XTTCPS_3_DEVICE_ID XPAR_XTTCPS_3_BASEADDR
#endif
	#if (XPAR_XTTCPS_3_BASEADDR == 0xFF120000U)
		#define XPMU_XTTCPS_3 XPAR_XTTCPS_3_DEVICE_ID
		#define XPMU_XTTCPS_3_BASEADDR XPAR_XTTCPS_3_BASEADDR
	#elif (XPAR_XTTCPS_3_BASEADDR == 0xFF120004U)
		#define XPMU_XTTCPS_4 XPAR_XTTCPS_3_DEVICE_ID
		#define XPMU_XTTCPS_4_BASEADDR XPAR_XTTCPS_3_BASEADDR
	#elif (XPAR_XTTCPS_3_BASEADDR == 0xFF120008U)
		#define XPMU_XTTCPS_5 XPAR_XTTCPS_3_DEVICE_ID
		#define XPMU_XTTCPS_5_BASEADDR XPAR_XTTCPS_3_BASEADDR
	#elif (XPAR_XTTCPS_3_BASEADDR == 0xFF130000U)
		#define XPMU_XTTCPS_6 XPAR_XTTCPS_3_DEVICE_ID
		#define XPMU_XTTCPS_6_BASEADDR XPAR_XTTCPS_3_BASEADDR
	#elif (XPAR_XTTCPS_3_BASEADDR == 0xFF130004U)
		#define XPMU_XTTCPS_7 XPAR_XTTCPS_3_DEVICE_ID
		#define XPMU_XTTCPS_7_BASEADDR XPAR_XTTCPS_3_BASEADDR
	#elif (XPAR_XTTCPS_3_BASEADDR == 0xFF130008U)
		#define XPMU_XTTCPS_8 XPAR_XTTCPS_3_DEVICE_ID
		#define XPMU_XTTCPS_8_BASEADDR XPAR_XTTCPS_3_BASEADDR
	#elif (XPAR_XTTCPS_3_BASEADDR == 0xFF140000U)
		#define XPMU_XTTCPS_9 XPAR_XTTCPS_3_DEVICE_ID
		#define XPMU_XTTCPS_9_BASEADDR XPAR_XTTCPS_3_BASEADDR
	#elif (XPAR_XTTCPS_3_BASEADDR == 0xFF140004U)
		#define XPMU_XTTCPS_10 XPAR_XTTCPS_3_DEVICE_ID
		#define XPMU_XTTCPS_10_BASEADDR XPAR_XTTCPS_3_BASEADDR
	#elif (XPAR_XTTCPS_3_BASEADDR == 0xFF140008U)
		#define XPMU_XTTCPS_11 XPAR_XTTCPS_3_DEVICE_ID
		#define XPMU_XTTCPS_11_BASEADDR XPAR_XTTCPS_3_BASEADDR
	#endif
#endif /*XPAR_XTTCPS_3_DEVICE_ID*/
#if (defined(XPAR_XTTCPS_4_DEVICE_ID)) || (defined(XPAR_XTTCPS_4_BASEADDR))
#ifdef SDT
#define XPAR_XTTCPS_4_DEVICE_ID XPAR_XTTCPS_4_BASEADDR
#endif
	#if (XPAR_XTTCPS_4_BASEADDR == 0xFF120004U)
		#define XPMU_XTTCPS_4 XPAR_XTTCPS_4_DEVICE_ID
		#define XPMU_XTTCPS_4_BASEADDR XPAR_XTTCPS_4_BASEADDR
	#elif (XPAR_XTTCPS_4_BASEADDR == 0xFF120008U)
		#define XPMU_XTTCPS_5 XPAR_XTTCPS_4_DEVICE_ID
		#define XPMU_XTTCPS_5_BASEADDR XPAR_XTTCPS_4_BASEADDR
	#elif (XPAR_XTTCPS_4_BASEADDR == 0xFF130000U)
		#define XPMU_XTTCPS_6 XPAR_XTTCPS_4_DEVICE_ID
		#define XPMU_XTTCPS_6_BASEADDR XPAR_XTTCPS_4_BASEADDR
	#elif (XPAR_XTTCPS_4_BASEADDR == 0xFF130004U)
		#define XPMU_XTTCPS_7 XPAR_XTTCPS_4_DEVICE_ID
		#define XPMU_XTTCPS_7_BASEADDR XPAR_XTTCPS_4_BASEADDR
	#elif (XPAR_XTTCPS_4_BASEADDR == 0xFF130008U)
		#define XPMU_XTTCPS_8 XPAR_XTTCPS_4_DEVICE_ID
		#define XPMU_XTTCPS_8_BASEADDR XPAR_XTTCPS_4_BASEADDR
	#elif (XPAR_XTTCPS_4_BASEADDR == 0xFF140000U)
		#define XPMU_XTTCPS_9 XPAR_XTTCPS_4_DEVICE_ID
		#define XPMU_XTTCPS_9_BASEADDR XPAR_XTTCPS_4_BASEADDR
	#elif (XPAR_XTTCPS_4_BASEADDR == 0xFF140004U)
		#define XPMU_XTTCPS_10 XPAR_XTTCPS_4_DEVICE_ID
		#define XPMU_XTTCPS_10_BASEADDR XPAR_XTTCPS_4_BASEADDR
	#elif (XPAR_XTTCPS_4_BASEADDR == 0xFF140008U)
		#define XPMU_XTTCPS_11 XPAR_XTTCPS_4_DEVICE_ID
		#define XPMU_XTTCPS_11_BASEADDR XPAR_XTTCPS_4_BASEADDR
	#endif
#endif /*XPAR_XTTCPS_4_DEVICE_ID*/
#if (defined(XPAR_XTTCPS_5_DEVICE_ID)) || (defined(XPAR_XTTCPS_5_BASEADDR))
	#if (XPAR_XTTCPS_5_BASEADDR == 0xFF120008U)
#ifdef SDT
#define XPAR_XTTCPS_5_DEVICE_ID XPAR_XTTCPS_5_BASEADDR
#endif
		#define XPMU_XTTCPS_5 XPAR_XTTCPS_5_DEVICE_ID
		#define XPMU_XTTCPS_5_BASEADDR XPAR_XTTCPS_5_BASEADDR
	#elif (XPAR_XTTCPS_5_BASEADDR == 0xFF130000U)
		#define XPMU_XTTCPS_6 XPAR_XTTCPS_5_DEVICE_ID
		#define XPMU_XTTCPS_6_BASEADDR XPAR_XTTCPS_5_BASEADDR
	#elif (XPAR_XTTCPS_5_BASEADDR == 0xFF130004U)
		#define XPMU_XTTCPS_7 XPAR_XTTCPS_5_DEVICE_ID
		#define XPMU_XTTCPS_7_BASEADDR XPAR_XTTCPS_5_BASEADDR
	#elif (XPAR_XTTCPS_5_BASEADDR == 0xFF130008U)
		#define XPMU_XTTCPS_8 XPAR_XTTCPS_5_DEVICE_ID
		#define XPMU_XTTCPS_8_BASEADDR XPAR_XTTCPS_5_BASEADDR
	#elif (XPAR_XTTCPS_5_BASEADDR == 0xFF140000U)
		#define XPMU_XTTCPS_9 XPAR_XTTCPS_5_DEVICE_ID
		#define XPMU_XTTCPS_9_BASEADDR XPAR_XTTCPS_5_BASEADDR
	#elif (XPAR_XTTCPS_5_BASEADDR == 0xFF140004U)
		#define XPMU_XTTCPS_10 XPAR_XTTCPS_5_DEVICE_ID
		#define XPMU_XTTCPS_10_BASEADDR XPAR_XTTCPS_5_BASEADDR
	#elif (XPAR_XTTCPS_5_BASEADDR == 0xFF140008U)
		#define XPMU_XTTCPS_11 XPAR_XTTCPS_5_DEVICE_ID
		#define XPMU_XTTCPS_11_BASEADDR XPAR_XTTCPS_5_BASEADDR
	#endif
#endif /*XPAR_XTTCPS_5_DEVICE_ID*/
#if (defined(XPAR_XTTCPS_6_DEVICE_ID)) || (defined(XPAR_XTTCPS_6_BASEADDR))
#ifdef SDT
#define XPAR_XTTCPS_6_DEVICE_ID XPAR_XTTCPS_6_BASEADDR
#endif
	#if (XPAR_XTTCPS_6_BASEADDR == 0xFF130000U)
		#define XPMU_XTTCPS_6 XPAR_XTTCPS_6_DEVICE_ID
		#define XPMU_XTTCPS_6_BASEADDR XPAR_XTTCPS_6_BASEADDR
	#elif (XPAR_XTTCPS_6_BASEADDR == 0xFF130004U)
		#define XPMU_XTTCPS_7 XPAR_XTTCPS_6_DEVICE_ID
		#define XPMU_XTTCPS_7_BASEADDR XPAR_XTTCPS_6_BASEADDR
	#elif (XPAR_XTTCPS_6_BASEADDR == 0xFF130008U)
		#define XPMU_XTTCPS_8 XPAR_XTTCPS_6_DEVICE_ID
		#define XPMU_XTTCPS_8_BASEADDR XPAR_XTTCPS_6_BASEADDR
	#elif (XPAR_XTTCPS_6_BASEADDR == 0xFF140000U)
		#define XPMU_XTTCPS_9 XPAR_XTTCPS_6_DEVICE_ID
		#define XPMU_XTTCPS_9_BASEADDR XPAR_XTTCPS_6_BASEADDR
	#elif (XPAR_XTTCPS_6_BASEADDR == 0xFF140004U)
		#define XPMU_XTTCPS_10 XPAR_XTTCPS_6_DEVICE_ID
		#define XPMU_XTTCPS_10_BASEADDR XPAR_XTTCPS_6_BASEADDR
	#elif (XPAR_XTTCPS_6_BASEADDR == 0xFF140008U)
		#define XPMU_XTTCPS_11 XPAR_XTTCPS_6_DEVICE_ID
		#define XPMU_XTTCPS_11_BASEADDR XPAR_XTTCPS_6_BASEADDR
	#endif
#endif /*XPAR_XTTCPS_6_DEVICE_ID*/
#if (defined(XPAR_XTTCPS_7_DEVICE_ID)) || (defined(XPAR_XTTCPS_7_BASEADDR))
#ifdef SDT
#define XPAR_XTTCPS_7_DEVICE_ID XPAR_XTTCPS_7_BASEADDR
#endif
	#if (XPAR_XTTCPS_7_BASEADDR == 0xFF130004U)
		#define XPMU_XTTCPS_7 XPAR_XTTCPS_7_DEVICE_ID
		#define XPMU_XTTCPS_7_BASEADDR XPAR_XTTCPS_7_BASEADDR
	#elif (XPAR_XTTCPS_7_BASEADDR == 0xFF130008U)
		#define XPMU_XTTCPS_8 XPAR_XTTCPS_7_DEVICE_ID
		#define XPMU_XTTCPS_8_BASEADDR XPAR_XTTCPS_7_BASEADDR
	#elif (XPAR_XTTCPS_7_BASEADDR == 0xFF140000U)
		#define XPMU_XTTCPS_9 XPAR_XTTCPS_7_DEVICE_ID
		#define XPMU_XTTCPS_9_BASEADDR XPAR_XTTCPS_7_BASEADDR
	#elif (XPAR_XTTCPS_7_BASEADDR == 0xFF140004U)
		#define XPMU_XTTCPS_10 XPAR_XTTCPS_7_DEVICE_ID
		#define XPMU_XTTCPS_10_BASEADDR XPAR_XTTCPS_7_BASEADDR
	#elif (XPAR_XTTCPS_7_BASEADDR == 0xFF140008U)
		#define XPMU_XTTCPS_11 XPAR_XTTCPS_7_DEVICE_ID
		#define XPMU_XTTCPS_11_BASEADDR XPAR_XTTCPS_7_BASEADDR
	#endif
#endif /*XPAR_XTTCPS_7_DEVICE_ID*/
#if (defined(XPAR_XTTCPS_8_DEVICE_ID)) || (defined(XPAR_XTTCPS_8_BASEADDR))
#ifdef SDT
#define XPAR_XTTCPS_8_DEVICE_ID XPAR_XTTCPS_8_BASEADDR
#endif
	#if (XPAR_XTTCPS_8_BASEADDR == 0xFF130008U)
		#define XPMU_XTTCPS_8 XPAR_XTTCPS_8_DEVICE_ID
		#define XPMU_XTTCPS_8_BASEADDR XPAR_XTTCPS_8_BASEADDR
	#elif (XPAR_XTTCPS_8_BASEADDR == 0xFF140000U)
		#define XPMU_XTTCPS_9 XPAR_XTTCPS_8_DEVICE_ID
		#define XPMU_XTTCPS_9_BASEADDR XPAR_XTTCPS_8_BASEADDR
	#elif (XPAR_XTTCPS_8_BASEADDR == 0xFF140004U)
		#define XPMU_XTTCPS_10 XPAR_XTTCPS_8_DEVICE_ID
		#define XPMU_XTTCPS_10_BASEADDR XPAR_XTTCPS_8_BASEADDR
	#elif (XPAR_XTTCPS_8_BASEADDR == 0xFF140008U)
		#define XPMU_XTTCPS_11 XPAR_XTTCPS_8_DEVICE_ID
		#define XPMU_XTTCPS_11_BASEADDR XPAR_XTTCPS_8_BASEADDR
	#endif
#endif /*XPAR_XTTCPS_8_DEVICE_ID*/
#if (defined(XPAR_XTTCPS_9_DEVICE_ID)) || (defined(XPAR_XTTCPS_9_BASEADDR))
#ifdef SDT
#define XPAR_XTTCPS_9_DEVICE_ID XPAR_XTTCPS_9_BASEADDR
#endif
	#if (XPAR_XTTCPS_9_BASEADDR == 0xFF140000U)
		#define XPMU_XTTCPS_9 XPAR_XTTCPS_9_DEVICE_ID
		#define XPMU_XTTCPS_9_BASEADDR XPAR_XTTCPS_9_BASEADDR
	#elif (XPAR_XTTCPS_9_BASEADDR == 0xFF140004U)
		#define XPMU_XTTCPS_10 XPAR_XTTCPS_9_DEVICE_ID
		#define XPMU_XTTCPS_10_BASEADDR XPAR_XTTCPS_9_BASEADDR
	#elif (XPAR_XTTCPS_9_BASEADDR == 0xFF140008U)
		#define XPMU_XTTCPS_11 XPAR_XTTCPS_9_DEVICE_ID
		#define XPMU_XTTCPS_11_BASEADDR XPAR_XTTCPS_9_BASEADDR
	#endif
#endif /*XPAR_XTTCPS_9_DEVICE_ID*/
#if (defined(XPAR_XTTCPS_10_DEVICE_ID)) || (defined(XPAR_XTTCPS_10_BASEADDR))
#ifdef SDT
#define XPAR_XTTCPS_10_DEVICE_ID XPAR_XTTCPS_10_BASEADDR
#endif
	#if (XPAR_XTTCPS_10_BASEADDR == 0xFF140004U)
		#define XPMU_XTTCPS_10 XPAR_XTTCPS_10_DEVICE_ID
		#define XPMU_XTTCPS_10_BASEADDR XPAR_XTTCPS_10_BASEADDR
	#elif (XPAR_XTTCPS_10_BASEADDR == 0xFF140008U)
		#define XPMU_XTTCPS_11 XPAR_XTTCPS_10_DEVICE_ID
		#define XPMU_XTTCPS_11_BASEADDR XPAR_XTTCPS_10_BASEADDR
	#endif
#endif /*XPAR_XTTCPS_10_DEVICE_ID*/
#if (defined(XPAR_XTTCPS_11_DEVICE_ID)) || (defined(XPAR_XTTCPS_11_BASEADDR))
#ifdef SDT
#define XPAR_XTTCPS_11_DEVICE_ID XPAR_XTTCPS_11_BASEADDR
#endif
	#define XPMU_XTTCPS_11 XPAR_XTTCPS_11_DEVICE_ID
	#define XPMU_XTTCPS_11_BASEADDR XPAR_XTTCPS_11_BASEADDR
#endif /*XPAR_XTTCPS_11_DEVICE_ID*/

/* XPMU_SD_0 and XPMU_SD_1 */
#if (defined(XPAR_XSDPS_0_DEVICE_ID)) || (defined(XPAR_XSDPS_0_BASEADDR))
	#if (XPAR_XSDPS_0_BASEADDR == 0xFF160000U)
#ifndef SDT
		#define XPMU_SD_0 XPAR_XSDPS_0_DEVICE_ID
#else
		#define XPMU_SD_0 XPAR_XSDPS_0_BASEADDR

#endif
		#define XPMU_SD_0_BASEADDR XPAR_XSDPS_0_BASEADDR
	#elif (XPAR_XSDPS_0_BASEADDR == 0xFF170000U)
#ifndef SDT
		#define XPMU_SD_1 XPAR_XSDPS_0_DEVICE_ID
#else
		#define XPMU_SD_1 XPAR_XSDPS_0_BASEADDR
#endif
		#define XPMU_SD_1_BASEADDR XPAR_XSDPS_0_BASEADDR
	#endif
#endif /*XPAR_XSDPS_0_DEVICE_ID*/
#if (defined(XPAR_XSDPS_1_DEVICE_ID)) || (defined(XPAR_XSDPS_1_BASEADDR))
#ifndef SDT
	#define XPMU_SD_1 XPAR_XSDPS_1_DEVICE_ID
#else
	#define XPMU_SD_1 XPAR_XSDPS_1_BASEADDR
#endif
	#define XPMU_SD_1_BASEADDR XPAR_XSDPS_1_BASEADDR
#endif /*XPAR_XSDPS_1_DEVICE_ID*/

/* XPMU_I2C_0 and XPMU_I2C_1 */
#if (defined(XPAR_XIICPS_0_DEVICE_ID)) || (defined(XPAR_XIICPS_0_BASEADDR))
	#if (XPAR_XIICPS_0_BASEADDR == 0xFF020000U)
#ifndef SDT
		#define XPMU_I2C_0 XPAR_XIICPS_0_DEVICE_ID
#else
		#define XPMU_I2C_0 XPAR_XIICPS_0_BASEADDR
#endif
		#define XPMU_I2C_0_BASEADDR XPAR_XIICPS_0_BASEADDR
	#elif (XPAR_XIICPS_0_BASEADDR == 0xFF030000U)
#ifndef SDT
		#define XPMU_I2C_1 XPAR_XIICPS_0_DEVICE_ID
#else
		#define XPMU_I2C_1 XPAR_XIICPS_0_BASEADDR
#endif
		#define XPMU_I2C_1_BASEADDR XPAR_XIICPS_0_BASEADDR
	#endif
#endif /*XPAR_XIICPS_0_DEVICE_ID*/
#if (defined(XPAR_XIICPS_1_DEVICE_ID)) || (defined(XPAR_XIICPS_1_BASEADDR))
#ifndef SDT
	#define XPMU_I2C_1 XPAR_XIICPS_1_DEVICE_ID
#else
	#define XPMU_I2C_1 XPAR_XIICPS_1_BASEADDR
#endif
	#define XPMU_I2C_1_BASEADDR XPAR_XIICPS_1_BASEADDR
#endif /*XPAR_XIICPS_1_DEVICE_ID*/

/* XPMU_ETHERNET_0 to XPMU_ETHERNET_3 */
#if (defined(XPAR_XEMACPS_0_DEVICE_ID)) || (defined(XPAR_XEMACPS_0_BASEADDR))
	#if (XPAR_XEMACPS_0_BASEADDR == 0xFF0B0000U)
#ifndef SDT
		#define XPMU_ETHERNET_0 XPAR_XEMACPS_0_DEVICE_ID
#else
		#define XPMU_ETHERNET_0 XPAR_XEMACPS_0_BASEADDR
#endif
		#define XPMU_ETHERNET_0_BASEADDR XPAR_XEMACPS_0_BASEADDR
	#elif (XPAR_XEMACPS_0_BASEADDR == 0xFF0C0000U)
#ifndef SDT
		#define XPMU_ETHERNET_1 XPAR_XEMACPS_0_DEVICE_ID
#else
		#define XPMU_ETHERNET_1 XPAR_XEMACPS_0_BASEADDR
#endif
		#define XPMU_ETHERNET_1_BASEADDR XPAR_XEMACPS_0_BASEADDR
	#elif (XPAR_XEMACPS_0_BASEADDR == 0xFF0D0000U)
#ifndef SDT
		#define XPMU_ETHERNET_2 XPAR_XEMACPS_0_DEVICE_ID
#else
		#define XPMU_ETHERNET_2 XPAR_XEMACPS_0_BASEADDR
#endif
		#define XPMU_ETHERNET_2_BASEADDR XPAR_XEMACPS_0_BASEADDR
	#elif (XPAR_XEMACPS_0_BASEADDR == 0xFF0E0000U)
#ifndef SDT
		#define XPMU_ETHERNET_3 XPAR_XEMACPS_0_DEVICE_ID
#else
		#define XPMU_ETHERNET_3 XPAR_XEMACPS_0_BASEADDR
#endif
		#define XPMU_ETHERNET_3_BASEADDR XPAR_XEMACPS_0_BASEADDR
	#endif
#endif /*XPAR_XEMACPS_0_DEVICE_ID*/
#if (defined(XPAR_XEMACPS_1_DEVICE_ID)) || (defined(XPAR_XEMACPS_1_BASEADDR))
	#if (XPAR_XEMACPS_1_BASEADDR == 0xFF0C0000U)
#ifndef SDT
		#define XPMU_ETHERNET_1 XPAR_XEMACPS_1_DEVICE_ID
#else
		#define XPMU_ETHERNET_1 XPAR_XEMACPS_1_BASEADDR
#endif
		#define XPMU_ETHERNET_1_BASEADDR XPAR_XEMACPS_1_BASEADDR
	#elif (XPAR_XEMACPS_1_BASEADDR == 0xFF0D0000U)
#ifndef SDT
		#define XPMU_ETHERNET_2 XPAR_XEMACPS_1_DEVICE_ID
#else
		#define XPMU_ETHERNET_2 XPAR_XEMACPS_1_BASEADDR
#endif
		#define XPMU_ETHERNET_2_BASEADDR XPAR_XEMACPS_1_BASEADDR
	#elif (XPAR_XEMACPS_1_BASEADDR == 0xFF0E0000U)
#ifndef SDT
		#define XPMU_ETHERNET_3 XPAR_XEMACPS_1_DEVICE_ID
#else
		#define XPMU_ETHERNET_3 XPAR_XEMACPS_1_BASEADDR
#endif
		#define XPMU_ETHERNET_3_BASEADDR XPAR_XEMACPS_1_BASEADDR
	#endif
#endif /*XPAR_XEMACPS_1_DEVICE_ID*/
#if (defined(XPAR_XEMACPS_2_DEVICE_ID)) || (defined(XPAR_XEMACPS_2_BASEADDR))
	#if (XPAR_XEMACPS_2_BASEADDR == 0xFF0D0000U)
#ifndef SDT
		#define XPMU_ETHERNET_2 XPAR_XEMACPS_2_DEVICE_ID
#else
		#define XPMU_ETHERNET_2 XPAR_XEMACPS_2_BASEADDR
#endif
		#define XPMU_ETHERNET_2_BASEADDR XPAR_XEMACPS_2_BASEADDR
	#elif (XPAR_XEMACPS_2_BASEADDR == 0xFF0E0000U)
#ifndef SDT
		#define XPMU_ETHERNET_3 XPAR_XEMACPS_2_DEVICE_ID
#else
		#define XPMU_ETHERNET_3 XPAR_XEMACPS_2_BASEADDR
#endif
		#define XPMU_ETHERNET_3_BASEADDR XPAR_XEMACPS_2_BASEADDR
	#endif
#endif /*XPAR_XEMACPS_2_DEVICE_ID*/
#if (defined(XPAR_XEMACPS_3_DEVICE_ID)) || (defined(XPAR_XEMACPS_3_BASEADDR))
#ifndef SDT
	#define XPMU_ETHERNET_3 XPAR_XEMACPS_3_DEVICE_ID
#else
	#define XPMU_ETHERNET_3 XPAR_XEMACPS_3_BASEADDR
#endif
	#define XPMU_ETHERNET_3_BASEADDR XPAR_XEMACPS_3_BASEADDR
#endif /*XPAR_XEMACPS_3_DEVICE_ID*/

/* XPMU_IPI_0 to XPMU_IPI_3 */
#if (defined(XPAR_XIPIPSU_0_DEVICE_ID)) || (defined(XPAR_XIPIPSU_0_BASEADDR))
	#if (XPAR_XIPIPSU_0_BASEADDR == 0xff330000U) || (XPAR_XIPIPSU_0_BASE_ADDRESS == 0xff330000U)
#ifndef SDT
		#define XPMU_IPI_0 XPAR_XIPIPSU_0_DEVICE_ID
		#define XPMU_IPI_0_BASEADDR XPAR_XIPIPSU_0_BASE_ADDRESS
#else
		#define XPMU_IPI_0 XPAR_XIPIPSU_0_BASEADDR
		#define XPMU_IPI_0_BASEADDR XPAR_XIPIPSU_0_BASEADDR
#endif
	#elif (XPAR_XIPIPSU_0_BASEADDR == 0xFF331000U) || (XPAR_XIPIPSU_0_BASE_ADDRESS == 0xFF331000U)
#ifndef SDT
		#define XPMU_IPI_1 XPAR_XIPIPSU_0_DEVICE_ID
		#define XPMU_IPI_1_BASEADDR XPAR_XIPIPSU_0_BASE_ADDRESS
#else
		#define XPMU_IPI_1 XPAR_XIPIPSU_0_BASEADDR
		#define XPMU_IPI_1_BASEADDR XPAR_XIPIPSU_0_BASEADDR
#endif
	#elif (XPAR_XIPIPSU_0_BASEADDR == 0xFF332000U) || (XPAR_XIPIPSU_0_BASE_ADDRESS == 0xFF332000U)
#ifndef SDT
		#define XPMU_IPI_2 XPAR_XIPIPSU_0_DEVICE_ID
		#define XPMU_IPI_2_BASEADDR XPAR_XIPIPSU_0_BASE_ADDRESS
#else
		#define XPMU_IPI_2 XPAR_XIPIPSU_0_BASEADDR
		#define XPMU_IPI_2_BASEADDR XPAR_XIPIPSU_0_BASEADDR
#endif
	#elif (XPAR_XIPIPSU_0_BASEADDR == 0xFF333000U) || (XPAR_XIPIPSU_0_BASE_ADDRESS == 0xFF333000U)
#ifndef SDT
		#define XPMU_IPI_3 XPAR_XIPIPSU_0_DEVICE_ID
		#define XPMU_IPI_3_BASEADDR XPAR_XIPIPSU_0_BASE_ADDRESS
#else
		#define XPMU_IPI_3 XPAR_XIPIPSU_0_BASEADDR
		#define XPMU_IPI_3_BASEADDR XPAR_XIPIPSU_0_BASEADDR
#endif
	#endif
#endif /*XPAR_XIPIPSU_0_DEVICE_ID*/
#if (defined(XPAR_XIPIPSU_1_DEVICE_ID)) || (defined(XPAR_XIPIPSU_1_BASEADDR))
	#if (XPAR_XIPIPSU_1_BASEADDR == 0xff331000U) || (XPAR_XIPIPSU_1_BASE_ADDRESS == 0xff331000U)
#ifndef SDT
		#define XPMU_IPI_1 XPAR_XIPIPSU_1_DEVICE_ID
		#define XPMU_IPI_1_BASEADDR XPAR_XIPIPSU_1_BASE_ADDRESS
#else
		#define XPMU_IPI_1 XPAR_XIPIPSU_1_BASEADDR
		#define XPMU_IPI_1_BASEADDR XPAR_XIPIPSU_1_BASEADDR
#endif
	#elif (XPAR_XIPIPSU_1_BASEADDR == 0xFF332000U) || (XPAR_XIPIPSU_1_BASE_ADDRESS == 0xff331000U)
#ifndef SDT
		#define XPMU_IPI_2 XPAR_XIPIPSU_1_DEVICE_ID
		#define XPMU_IPI_2_BASEADDR XPAR_XIPIPSU_1_BASE_ADDRESS
#else
		#define XPMU_IPI_2 XPAR_XIPIPSU_1_BASEADDR
		#define XPMU_IPI_2_BASEADDR XPAR_XIPIPSU_1_BASEADDR
#endif
	#elif (XPAR_XIPIPSU_1_BASEADDR == 0xFF333000U) || (XPAR_XIPIPSU_1_BASE_ADDRESS == 0xFF333000U)
#ifndef SDT
		#define XPMU_IPI_3 XPAR_XIPIPSU_1_DEVICE_ID
		#define XPMU_IPI_3_BASEADDR XPAR_XIPIPSU_1_BASE_ADDRESS
#else
		#define XPMU_IPI_3 XPAR_XIPIPSU_1_BASEADDR
		#define XPMU_IPI_3_BASEADDR XPAR_XIPIPSU_1_BASEADDR
#endif
	#endif
#endif /*XPAR_XIPIPSU_1_DEVICE_ID*/
#if (defined(XPAR_XIPIPSU_2_DEVICE_ID)) || (defined(XPAR_XIPIPSU_2_BASEADDR))
	#if (XPAR_XIPIPSU_2_BASEADDR == 0xFF332000U) || (XPAR_XIPIPSU_2_BASE_ADDRESS == 0xFF332000U)
#ifndef SDT
		#define XPMU_IPI_2 XPAR_XIPIPSU_2_DEVICE_ID
		#define XPMU_IPI_2_BASEADDR XPAR_XIPIPSU_2_BASE_ADDRESS
#else
		#define XPMU_IPI_2 XPAR_XIPIPSU_2_BASEADDR
		#define XPMU_IPI_2_BASEADDR XPAR_XIPIPSU_2_BASEADDR
#endif
	#elif (XPAR_XIPIPSU_2_BASEADDR == 0xFF333000U) || (XPAR_XIPIPSU_2_BASE_ADDRESS == 0xFF333000U)
#ifndef SDT
		#define XPMU_IPI_3 XPAR_XIPIPSU_2_DEVICE_ID
		#define XPMU_IPI_3_BASEADDR XPAR_XIPIPSU_2_BASE_ADDRESS
#else
		#define XPMU_IPI_3 XPAR_XIPIPSU_2_BASEADDR
		#define XPMU_IPI_3_BASEADDR XPAR_XIPIPSU_2_BASEADDR
#endif
	#endif
#endif /*XPAR_XIPIPSU_2_DEVICE_ID*/
#if (defined(XPAR_XIPIPSU_3_DEVICE_ID)) || (defined(XPAR_XIPIPSU_3_BASEADDR))
#ifndef SDT
		#define XPMU_IPI_3 XPAR_XIPIPSU_3_DEVICE_ID
		#define XPMU_IPI_3_BASEADDR XPAR_XIPIPSU_3_BASE_ADDRESS
#else
		#define XPMU_IPI_3 XPAR_XIPIPSU_3_BASEADDR
		#define XPMU_IPI_3_BASEADDR XPAR_XIPIPSU_3_BASEADDR
#endif
#endif /*XPAR_XIPIPSU_3_DEVICE_ID*/

/* XPMU_CAN_0 and XPMU_CAN_1 */
#if (defined(XPAR_XCANPS_0_DEVICE_ID)) || (defined(XPAR_XCANPS_0_BASEADDR))
	#if (XPAR_XCANPS_0_BASEADDR == 0xFF060000U)
#ifndef SDT
		#define XPMU_CAN_0 XPAR_XCANPS_0_DEVICE_ID
#else
		#define XPMU_CAN_0 XPAR_XCANPS_0_BASEADDR
#endif
		#define XPMU_CAN_0_BASEADDR XPAR_XCANPS_0_BASEADDR
	#elif (XPAR_XCANPS_0_BASEADDR == 0xFF070000U)
#ifndef SDT
		#define XPMU_CAN_1 XPAR_XCANPS_0_DEVICE_ID
#else
		#define XPMU_CAN_1 XPAR_XCANPS_0_BASEADDR
#endif
		#define XPMU_CAN_1_BASEADDR XPAR_XCANPS_0_BASEADDR
	#endif
#endif /*XPAR_XCANPS_0_DEVICE_ID*/
#if (defined(XPAR_XCANPS_1_DEVICE_ID)) || (defined(XPAR_XCANPS_1_BASEADDR))
#ifndef SDT
	#define XPMU_CAN_1 XPAR_XCANPS_1_DEVICE_ID
#else
	#define XPMU_CAN_1 XPAR_XCANPS_1_BASEADDR
#endif
	#define XPMU_CAN_1_BASEADDR XPAR_XCANPS_1_BASEADDR
#endif /*XPAR_XCANPS_1_DEVICE_ID*/

/* XPMU_UART_0 and XPMU_UART_1 */
#if (defined(XPAR_XUARTPS_0_DEVICE_ID)) || (defined(XPAR_XUARTPS_0_BASEADDR))
	#if (XPAR_XUARTPS_0_BASEADDR == 0xFF000000U)
#ifndef SDT
		#define XPMU_UART_0 XPAR_XUARTPS_0_DEVICE_ID
#else
		#define XPMU_UART_0 XPAR_XUARTPS_0_BASEADDR
#endif
		#define XPMU_UART_0_BASEADDR XPAR_XUARTPS_0_BASEADDR
	#elif (XPAR_XUARTPS_0_BASEADDR == 0xFF010000U)
#ifndef SDT
		#define XPMU_UART_1 XPAR_XUARTPS_0_DEVICE_ID
#else
		#define XPMU_UART_1 XPAR_XUARTPS_0_BASEADDR
#endif
		#define XPMU_UART_1_BASEADDR XPAR_XUARTPS_0_BASEADDR
	#endif
#endif /*XPAR_XUARTPS_0_DEVICE_ID*/
#if (defined(XPAR_XUARTPS_1_DEVICE_ID)) || (defined(XPAR_XUARTPS_1_BASEADDR))
#ifndef SDT
	#define XPMU_UART_1 XPAR_XUARTPS_1_DEVICE_ID
#else
	#define XPMU_UART_1 XPAR_XUARTPS_1_BASEADDR
#endif
	#define XPMU_UART_1_BASEADDR XPAR_XUARTPS_1_BASEADDR
#endif /*XPAR_XUARTPS_1_DEVICE_ID*/

/* XPMU_SPI_0 and XPMU_SPI_1 */
#if (defined(XPAR_XSPIPS_0_DEVICE_ID)) || (defined(XPAR_XSPIPS_0_BASEADDR))
	#if (XPAR_XSPIPS_0_BASEADDR == 0xFF040000U)
#ifdef SDT
		#define XPMU_SPI_0 XPAR_XSPIPS_0_DEVICE_ID
#else
		#define XPMU_SPI_0 XPAR_XSPIPS_0_BASEADDR
#endif
		#define XPMU_SPI_0_BASEADDR XPAR_XSPIPS_0_BASEADDR
	#elif (XPAR_XSPIPS_0_BASEADDR == 0xFF050000U)
#ifdef SDT
		#define XPMU_SPI_1 XPAR_XSPIPS_0_DEVICE_ID
#else
		#define XPMU_SPI_1 XPAR_XSPIPS_0_BASEADDR
#endif
		#define XPMU_SPI_1_BASEADDR XPAR_XSPIPS_0_BASEADDR
	#endif
#endif /*XPAR_XSPIPS_0_DEVICE_ID*/
#if (defined(XPAR_XSPIPS_1_DEVICE_ID)) || (defined(XPAR_XSPIPS_1_BASEADDR))
#ifdef SDT
	#define XPMU_SPI_1 XPAR_XSPIPS_1_DEVICE_ID
#else
	#define XPMU_SPI_1 XPAR_XSPIPS_1_BASEADDR
#endif
	#define XPMU_SPI_1_BASEADDR XPAR_XSPIPS_1_BASEADDR
#endif /*XPAR_XSPIPS_1_DEVICE_ID*/

/* XPMU_USB_0 and XPMU_USB_1 */
#if (defined(XPAR_XUSBPSU_0_DEVICE_ID)) || (defined(XPAR_XUSBPSU_0_BASEADDR))
	#if (XPAR_XUSBPSU_0_BASEADDR == 0xFE200000U)
#ifdef SDT
		#define XPMU_USB_0 XPAR_XUSBPSU_0_DEVICE_ID
#else
		#define XPMU_USB_0 XPAR_XUSBPSU_0_BASEADDR
#endif
		#define XPMU_USB_0_BASEADDR XPAR_XUSBPSU_0_BASEADDR
	#elif (XPAR_XUSBPSU_0_BASEADDR == 0xFE300000U)
#ifdef SDT
		#define XPMU_USB_1 XPAR_XUSBPSU_0_DEVICE_ID
#else
		#define XPMU_USB_1 XPAR_XUSBPSU_0_BASEADDR
#endif
		#define XPMU_USB_1_BASEADDR XPAR_XUSBPSU_0_BASEADDR
	#endif
#endif /*XPAR_XUSBPSU_0_DEVICE_ID*/
#if (defined(XPAR_XUSBPSU_1_DEVICE_ID)) || (defined(XPAR_XUSBPSU_1_BASEADDR))
#ifdef SDT
	#define XPMU_USB_1 XPAR_XUSBPSU_1_DEVICE_ID
#else
	#define XPMU_USB_1 XPAR_XUSBPSU_1_BASEADDR
#endif
	#define XPMU_USB_1_BASEADDR XPAR_XUSBPSU_1_BASEADDR
#endif /*XPAR_XUSBPSU_1_DEVICE_ID*/

#ifdef ENABLE_SMMU
#define XPAR_PSU_SMMU_GPV_S_NSCR0	((XPAR_PSU_SMMU_GPV_S_AXI_BASEADDR) + (0x400U))
#define XPAR_PSU_SMMU_GPV_S_NSCR0_MASK	0x00000001U
#endif /*ENABLE SMMU*/

/* Register Access Macros */

#define XPfw_Write32(Addr, Value)  Xil_Out32((Addr), (Value))

#define XPfw_Read32(Addr)  Xil_In32((Addr))

#define XPfw_RMW32  XPfw_UtilRMW

#define ARRAYSIZE(x)	(u32)(sizeof(x)/sizeof(x[0]))
/* Custom Flags */

#define MASK_ALL 	0XffffffffU
#define ENABLE_ALL	0XffffffffU
#define ALL_HIGH	0XffffffffU
#define FLAG_ALL	0XffffffffU

#define MASK32_ALL_HIGH	((u32)0xFFFFFFFFU)
#define MASK32_ALL_LOW	((u32)0x0U)


#define YES 0x01U
#define NO 0x00U


#define XPFW_ACCESS_ALLOWED 0x01U
#define XPFW_ACCESS_DENIED	0x00U

/*
 * time in ms for checking psu init completion by FSBL
 */
#define CHECK_FSBL_COMPLETION	100U

#define FSBL_COMPLETION			1U

#define IPI_CRC_ERROR_OCCURRED	0x1U
#define HW_EXCEPTION_RECEIVED	0x2U

/* Error code to be written for RPU_run mode error */
#define RPU_RUN_MODE_ERROR 		0x04U

/* Handler Table Structure */
typedef void (*VoidFunction_t)(void);
struct HandlerTable{
	u32 Mask;
	VoidFunction_t Handler;
};

#ifdef __cplusplus
}
#endif

#endif /* XPFW_DEFAULT_H_ */
