/******************************************************************************
* Copyright (c) 2015 - 2020 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

#ifndef RPU_H_
#define RPU_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * RPU Base Address
 */
#define RPU_BASEADDR      ((u32)0XFF9A0000U)

/**
 * Register: RPU_RPU_GLBL_CNTL
 */
#define RPU_RPU_GLBL_CNTL    ( ( RPU_BASEADDR ) + ((u32)0X00000000U) )

#define RPU_RPU_GLBL_CNTL_GIC_AXPROT_SHIFT   10
#define RPU_RPU_GLBL_CNTL_GIC_AXPROT_WIDTH   1
#define RPU_RPU_GLBL_CNTL_GIC_AXPROT_MASK    ((u32)0X00000400U)

#define RPU_RPU_GLBL_CNTL_TCM_CLK_CNTL_SHIFT   8
#define RPU_RPU_GLBL_CNTL_TCM_CLK_CNTL_WIDTH   1
#define RPU_RPU_GLBL_CNTL_TCM_CLK_CNTL_MASK    ((u32)0X00000100U)

#define RPU_RPU_GLBL_CNTL_TCM_WAIT_SHIFT   7
#define RPU_RPU_GLBL_CNTL_TCM_WAIT_WIDTH   1
#define RPU_RPU_GLBL_CNTL_TCM_WAIT_MASK    ((u32)0X00000080U)

#define RPU_RPU_GLBL_CNTL_TCM_COMB_SHIFT   6
#define RPU_RPU_GLBL_CNTL_TCM_COMB_WIDTH   1
#define RPU_RPU_GLBL_CNTL_TCM_COMB_MASK    ((u32)0X00000040U)

#define RPU_RPU_GLBL_CNTL_TEINIT_SHIFT   5
#define RPU_RPU_GLBL_CNTL_TEINIT_WIDTH   1
#define RPU_RPU_GLBL_CNTL_TEINIT_MASK    ((u32)0X00000020U)

#define RPU_RPU_GLBL_CNTL_SLCLAMP_SHIFT   4
#define RPU_RPU_GLBL_CNTL_SLCLAMP_WIDTH   1
#define RPU_RPU_GLBL_CNTL_SLCLAMP_MASK    ((u32)0X00000010U)

#define RPU_RPU_GLBL_CNTL_SLSPLIT_SHIFT   3
#define RPU_RPU_GLBL_CNTL_SLSPLIT_WIDTH   1
#define RPU_RPU_GLBL_CNTL_SLSPLIT_MASK    ((u32)0X00000008U)

#define RPU_RPU_GLBL_CNTL_DBGNOCLKSTOP_SHIFT   2
#define RPU_RPU_GLBL_CNTL_DBGNOCLKSTOP_WIDTH   1
#define RPU_RPU_GLBL_CNTL_DBGNOCLKSTOP_MASK    ((u32)0X00000004U)

#define RPU_RPU_GLBL_CNTL_CFGIE_SHIFT   1
#define RPU_RPU_GLBL_CNTL_CFGIE_WIDTH   1
#define RPU_RPU_GLBL_CNTL_CFGIE_MASK    ((u32)0X00000002U)

#define RPU_RPU_GLBL_CNTL_CFGEE_SHIFT   0
#define RPU_RPU_GLBL_CNTL_CFGEE_WIDTH   1
#define RPU_RPU_GLBL_CNTL_CFGEE_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_GLBL_STATUS
 */
#define RPU_RPU_GLBL_STATUS    ( ( RPU_BASEADDR ) + ((u32)0X00000004U) )

#define RPU_RPU_GLBL_STATUS_DBGNOPWRDWN_SHIFT   0
#define RPU_RPU_GLBL_STATUS_DBGNOPWRDWN_WIDTH   1
#define RPU_RPU_GLBL_STATUS_DBGNOPWRDWN_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_ERR_CNTL
 */
#define RPU_RPU_ERR_CNTL    ( ( RPU_BASEADDR ) + ((u32)0X00000008U) )

#define RPU_RPU_ERR_CNTL_APB_ERR_RES_SHIFT   0
#define RPU_RPU_ERR_CNTL_APB_ERR_RES_WIDTH   1
#define RPU_RPU_ERR_CNTL_APB_ERR_RES_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_RAM
 */
#define RPU_RPU_RAM    ( ( RPU_BASEADDR ) + ((u32)0X0000000CU) )

#define RPU_RPU_RAM_RAMCONTROL1_SHIFT   8
#define RPU_RPU_RAM_RAMCONTROL1_WIDTH   8
#define RPU_RPU_RAM_RAMCONTROL1_MASK    ((u32)0X0000FF00U)

#define RPU_RPU_RAM_RAMCONTROL0_SHIFT   0
#define RPU_RPU_RAM_RAMCONTROL0_WIDTH   8
#define RPU_RPU_RAM_RAMCONTROL0_MASK    ((u32)0X000000FFU)

/**
 * Register: RPU_RPU_CACHE_DATA
 */
#define RPU_RPU_CACHE_DATA    ( ( RPU_BASEADDR ) + ((u32)0X00000010U) )

#define RPU_RPU_CACHE_DATA_DDIRTY_EMAS_SHIFT   29
#define RPU_RPU_CACHE_DATA_DDIRTY_EMAS_WIDTH   1
#define RPU_RPU_CACHE_DATA_DDIRTY_EMAS_MASK    ((u32)0X20000000U)

#define RPU_RPU_CACHE_DATA_DDIRTY_EMAW_SHIFT   27
#define RPU_RPU_CACHE_DATA_DDIRTY_EMAW_WIDTH   2
#define RPU_RPU_CACHE_DATA_DDIRTY_EMAW_MASK    ((u32)0X18000000U)

#define RPU_RPU_CACHE_DATA_DDIRTY_EMA_SHIFT   24
#define RPU_RPU_CACHE_DATA_DDIRTY_EMA_WIDTH   3
#define RPU_RPU_CACHE_DATA_DDIRTY_EMA_MASK    ((u32)0X07000000U)

#define RPU_RPU_CACHE_DATA_DTAG_EMAS_SHIFT   23
#define RPU_RPU_CACHE_DATA_DTAG_EMAS_WIDTH   1
#define RPU_RPU_CACHE_DATA_DTAG_EMAS_MASK    ((u32)0X00800000U)

#define RPU_RPU_CACHE_DATA_DTAG_EMAW_SHIFT   21
#define RPU_RPU_CACHE_DATA_DTAG_EMAW_WIDTH   2
#define RPU_RPU_CACHE_DATA_DTAG_EMAW_MASK    ((u32)0X00600000U)

#define RPU_RPU_CACHE_DATA_DTAG_EMA_SHIFT   18
#define RPU_RPU_CACHE_DATA_DTAG_EMA_WIDTH   3
#define RPU_RPU_CACHE_DATA_DTAG_EMA_MASK    ((u32)0X001C0000U)

#define RPU_RPU_CACHE_DATA_DDATA_EMAS_SHIFT   17
#define RPU_RPU_CACHE_DATA_DDATA_EMAS_WIDTH   1
#define RPU_RPU_CACHE_DATA_DDATA_EMAS_MASK    ((u32)0X00020000U)

#define RPU_RPU_CACHE_DATA_DDATA_EMAW_SHIFT   15
#define RPU_RPU_CACHE_DATA_DDATA_EMAW_WIDTH   2
#define RPU_RPU_CACHE_DATA_DDATA_EMAW_MASK    ((u32)0X00018000U)

#define RPU_RPU_CACHE_DATA_DDATA_EMA_SHIFT   12
#define RPU_RPU_CACHE_DATA_DDATA_EMA_WIDTH   3
#define RPU_RPU_CACHE_DATA_DDATA_EMA_MASK    ((u32)0X00007000U)

#define RPU_RPU_CACHE_DATA_ITAG_EMAS_SHIFT   11
#define RPU_RPU_CACHE_DATA_ITAG_EMAS_WIDTH   1
#define RPU_RPU_CACHE_DATA_ITAG_EMAS_MASK    ((u32)0X00000800U)

#define RPU_RPU_CACHE_DATA_ITAG_EMAW_SHIFT   9
#define RPU_RPU_CACHE_DATA_ITAG_EMAW_WIDTH   2
#define RPU_RPU_CACHE_DATA_ITAG_EMAW_MASK    ((u32)0X00000600U)

#define RPU_RPU_CACHE_DATA_ITAG_EMA_SHIFT   6
#define RPU_RPU_CACHE_DATA_ITAG_EMA_WIDTH   3
#define RPU_RPU_CACHE_DATA_ITAG_EMA_MASK    ((u32)0X000001C0U)

#define RPU_RPU_CACHE_DATA_IDATA_EMAS_SHIFT   5
#define RPU_RPU_CACHE_DATA_IDATA_EMAS_WIDTH   1
#define RPU_RPU_CACHE_DATA_IDATA_EMAS_MASK    ((u32)0X00000020U)

#define RPU_RPU_CACHE_DATA_IDATA_EMAW_SHIFT   3
#define RPU_RPU_CACHE_DATA_IDATA_EMAW_WIDTH   2
#define RPU_RPU_CACHE_DATA_IDATA_EMAW_MASK    ((u32)0X00000018U)

#define RPU_RPU_CACHE_DATA_IDATA_EMA_SHIFT   0
#define RPU_RPU_CACHE_DATA_IDATA_EMA_WIDTH   3
#define RPU_RPU_CACHE_DATA_IDATA_EMA_MASK    ((u32)0X00000007U)

/**
 * Register: RPU_RPU_CACHE_SYN
 */
#define RPU_RPU_CACHE_SYN    ( ( RPU_BASEADDR ) + ((u32)0X00000014U) )

#define RPU_RPU_CACHE_SYN_DDIRTY_EMAS_SHIFT   29
#define RPU_RPU_CACHE_SYN_DDIRTY_EMAS_WIDTH   1
#define RPU_RPU_CACHE_SYN_DDIRTY_EMAS_MASK    ((u32)0X20000000U)

#define RPU_RPU_CACHE_SYN_DDIRTY_EMAW_SHIFT   27
#define RPU_RPU_CACHE_SYN_DDIRTY_EMAW_WIDTH   2
#define RPU_RPU_CACHE_SYN_DDIRTY_EMAW_MASK    ((u32)0X18000000U)

#define RPU_RPU_CACHE_SYN_DDIRTY_EMA_SHIFT   24
#define RPU_RPU_CACHE_SYN_DDIRTY_EMA_WIDTH   3
#define RPU_RPU_CACHE_SYN_DDIRTY_EMA_MASK    ((u32)0X07000000U)

#define RPU_RPU_CACHE_SYN_DTAG_EMAS_SHIFT   23
#define RPU_RPU_CACHE_SYN_DTAG_EMAS_WIDTH   1
#define RPU_RPU_CACHE_SYN_DTAG_EMAS_MASK    ((u32)0X00800000U)

#define RPU_RPU_CACHE_SYN_DTAG_EMAW_SHIFT   21
#define RPU_RPU_CACHE_SYN_DTAG_EMAW_WIDTH   2
#define RPU_RPU_CACHE_SYN_DTAG_EMAW_MASK    ((u32)0X00600000U)

#define RPU_RPU_CACHE_SYN_DTAG_EMA_SHIFT   18
#define RPU_RPU_CACHE_SYN_DTAG_EMA_WIDTH   3
#define RPU_RPU_CACHE_SYN_DTAG_EMA_MASK    ((u32)0X001C0000U)

#define RPU_RPU_CACHE_SYN_DDATA_EMAS_SHIFT   17
#define RPU_RPU_CACHE_SYN_DDATA_EMAS_WIDTH   1
#define RPU_RPU_CACHE_SYN_DDATA_EMAS_MASK    ((u32)0X00020000U)

#define RPU_RPU_CACHE_SYN_DDATA_EMAW_SHIFT   15
#define RPU_RPU_CACHE_SYN_DDATA_EMAW_WIDTH   2
#define RPU_RPU_CACHE_SYN_DDATA_EMAW_MASK    ((u32)0X00018000U)

#define RPU_RPU_CACHE_SYN_DDATA_EMA_SHIFT   12
#define RPU_RPU_CACHE_SYN_DDATA_EMA_WIDTH   3
#define RPU_RPU_CACHE_SYN_DDATA_EMA_MASK    ((u32)0X00007000U)

#define RPU_RPU_CACHE_SYN_ITAG_EMAS_SHIFT   11
#define RPU_RPU_CACHE_SYN_ITAG_EMAS_WIDTH   1
#define RPU_RPU_CACHE_SYN_ITAG_EMAS_MASK    ((u32)0X00000800U)

#define RPU_RPU_CACHE_SYN_ITAG_EMAW_SHIFT   9
#define RPU_RPU_CACHE_SYN_ITAG_EMAW_WIDTH   2
#define RPU_RPU_CACHE_SYN_ITAG_EMAW_MASK    ((u32)0X00000600U)

#define RPU_RPU_CACHE_SYN_ITAG_EMA_SHIFT   6
#define RPU_RPU_CACHE_SYN_ITAG_EMA_WIDTH   3
#define RPU_RPU_CACHE_SYN_ITAG_EMA_MASK    ((u32)0X000001C0U)

#define RPU_RPU_CACHE_SYN_IDATA_EMAS_SHIFT   5
#define RPU_RPU_CACHE_SYN_IDATA_EMAS_WIDTH   1
#define RPU_RPU_CACHE_SYN_IDATA_EMAS_MASK    ((u32)0X00000020U)

#define RPU_RPU_CACHE_SYN_IDATA_EMAW_SHIFT   3
#define RPU_RPU_CACHE_SYN_IDATA_EMAW_WIDTH   2
#define RPU_RPU_CACHE_SYN_IDATA_EMAW_MASK    ((u32)0X00000018U)

#define RPU_RPU_CACHE_SYN_IDATA_EMA_SHIFT   0
#define RPU_RPU_CACHE_SYN_IDATA_EMA_WIDTH   3
#define RPU_RPU_CACHE_SYN_IDATA_EMA_MASK    ((u32)0X00000007U)

/**
 * Register: RPU_RPU_TCM_DATA
 */
#define RPU_RPU_TCM_DATA    ( ( RPU_BASEADDR ) + ((u32)0X00000018U) )

#define RPU_RPU_TCM_DATA_B_EMAS_SHIFT   17
#define RPU_RPU_TCM_DATA_B_EMAS_WIDTH   1
#define RPU_RPU_TCM_DATA_B_EMAS_MASK    ((u32)0X00020000U)

#define RPU_RPU_TCM_DATA_B_EMAW_SHIFT   15
#define RPU_RPU_TCM_DATA_B_EMAW_WIDTH   2
#define RPU_RPU_TCM_DATA_B_EMAW_MASK    ((u32)0X00018000U)

#define RPU_RPU_TCM_DATA_B_EMA_SHIFT   12
#define RPU_RPU_TCM_DATA_B_EMA_WIDTH   3
#define RPU_RPU_TCM_DATA_B_EMA_MASK    ((u32)0X00007000U)

#define RPU_RPU_TCM_DATA_A_EMAS_SHIFT   5
#define RPU_RPU_TCM_DATA_A_EMAS_WIDTH   1
#define RPU_RPU_TCM_DATA_A_EMAS_MASK    ((u32)0X00000020U)

#define RPU_RPU_TCM_DATA_A_EMAW_SHIFT   3
#define RPU_RPU_TCM_DATA_A_EMAW_WIDTH   2
#define RPU_RPU_TCM_DATA_A_EMAW_MASK    ((u32)0X00000018U)

#define RPU_RPU_TCM_DATA_A_EMA_SHIFT   0
#define RPU_RPU_TCM_DATA_A_EMA_WIDTH   3
#define RPU_RPU_TCM_DATA_A_EMA_MASK    ((u32)0X00000007U)

/**
 * Register: RPU_RPU_TCM_SYN
 */
#define RPU_RPU_TCM_SYN    ( ( RPU_BASEADDR ) + ((u32)0X0000001CU) )

#define RPU_RPU_TCM_SYN_B_EMAS_SHIFT   23
#define RPU_RPU_TCM_SYN_B_EMAS_WIDTH   1
#define RPU_RPU_TCM_SYN_B_EMAS_MASK    ((u32)0X00800000U)

#define RPU_RPU_TCM_SYN_B_EMAW_SHIFT   21
#define RPU_RPU_TCM_SYN_B_EMAW_WIDTH   2
#define RPU_RPU_TCM_SYN_B_EMAW_MASK    ((u32)0X00600000U)

#define RPU_RPU_TCM_SYN_B_EMA_SHIFT   18
#define RPU_RPU_TCM_SYN_B_EMA_WIDTH   3
#define RPU_RPU_TCM_SYN_B_EMA_MASK    ((u32)0X001C0000U)

#define RPU_RPU_TCM_SYN_A_EMAS_SHIFT   11
#define RPU_RPU_TCM_SYN_A_EMAS_WIDTH   1
#define RPU_RPU_TCM_SYN_A_EMAS_MASK    ((u32)0X00000800U)

#define RPU_RPU_TCM_SYN_A_EMAW_SHIFT   9
#define RPU_RPU_TCM_SYN_A_EMAW_WIDTH   2
#define RPU_RPU_TCM_SYN_A_EMAW_MASK    ((u32)0X00000600U)

#define RPU_RPU_TCM_SYN_A_EMA_SHIFT   6
#define RPU_RPU_TCM_SYN_A_EMA_WIDTH   3
#define RPU_RPU_TCM_SYN_A_EMA_MASK    ((u32)0X000001C0U)

/**
 * Register: RPU_RPU_ERR_INJ
 */
#define RPU_RPU_ERR_INJ    ( ( RPU_BASEADDR ) + ((u32)0X00000020U) )

#define RPU_RPU_ERR_INJ_DCCMINP2_SHIFT   8
#define RPU_RPU_ERR_INJ_DCCMINP2_WIDTH   8
#define RPU_RPU_ERR_INJ_DCCMINP2_MASK    ((u32)0X0000FF00U)

#define RPU_RPU_ERR_INJ_DCCMINP_SHIFT   0
#define RPU_RPU_ERR_INJ_DCCMINP_WIDTH   8
#define RPU_RPU_ERR_INJ_DCCMINP_MASK    ((u32)0X000000FFU)

/**
 * Register: RPU_RPU_CCF_MASK
 */
#define RPU_RPU_CCF_MASK    ( ( RPU_BASEADDR ) + ((u32)0X00000024U) )

#define RPU_RPU_CCF_MASK_TEST_MBIST_MODE_SHIFT   7
#define RPU_RPU_CCF_MASK_TEST_MBIST_MODE_WIDTH   1
#define RPU_RPU_CCF_MASK_TEST_MBIST_MODE_MASK    ((u32)0X00000080U)

#define RPU_RPU_CCF_MASK_TEST_SCAN_MODE_LP_SHIFT   6
#define RPU_RPU_CCF_MASK_TEST_SCAN_MODE_LP_WIDTH   1
#define RPU_RPU_CCF_MASK_TEST_SCAN_MODE_LP_MASK    ((u32)0X00000040U)

#define RPU_RPU_CCF_MASK_TEST_SCAN_MODE_SHIFT   5
#define RPU_RPU_CCF_MASK_TEST_SCAN_MODE_WIDTH   1
#define RPU_RPU_CCF_MASK_TEST_SCAN_MODE_MASK    ((u32)0X00000020U)

#define RPU_RPU_CCF_MASK_ISO_SHIFT   4
#define RPU_RPU_CCF_MASK_ISO_WIDTH   1
#define RPU_RPU_CCF_MASK_ISO_MASK    ((u32)0X00000010U)

#define RPU_RPU_CCF_MASK_PGE_SHIFT   3
#define RPU_RPU_CCF_MASK_PGE_WIDTH   1
#define RPU_RPU_CCF_MASK_PGE_MASK    ((u32)0X00000008U)

#define RPU_RPU_CCF_MASK_R50_DBG_RST_SHIFT   2
#define RPU_RPU_CCF_MASK_R50_DBG_RST_WIDTH   1
#define RPU_RPU_CCF_MASK_R50_DBG_RST_MASK    ((u32)0X00000004U)

#define RPU_RPU_CCF_MASK_R50_RST_SHIFT   1
#define RPU_RPU_CCF_MASK_R50_RST_WIDTH   1
#define RPU_RPU_CCF_MASK_R50_RST_MASK    ((u32)0X00000002U)

#define RPU_RPU_CCF_MASK_PGE_RST_SHIFT   0
#define RPU_RPU_CCF_MASK_PGE_RST_WIDTH   1
#define RPU_RPU_CCF_MASK_PGE_RST_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_INTR_0
 */
#define RPU_RPU_INTR_0    ( ( RPU_BASEADDR ) + ((u32)0X00000028U) )

#define RPU_RPU_INTR_0_SPI_SHIFT   0
#define RPU_RPU_INTR_0_SPI_WIDTH   32
#define RPU_RPU_INTR_0_SPI_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: RPU_RPU_INTR_1
 */
#define RPU_RPU_INTR_1    ( ( RPU_BASEADDR ) + ((u32)0X0000002CU) )

#define RPU_RPU_INTR_1_SPI_SHIFT   0
#define RPU_RPU_INTR_1_SPI_WIDTH   32
#define RPU_RPU_INTR_1_SPI_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: RPU_RPU_INTR_2
 */
#define RPU_RPU_INTR_2    ( ( RPU_BASEADDR ) + ((u32)0X00000030U) )

#define RPU_RPU_INTR_2_SPI_SHIFT   0
#define RPU_RPU_INTR_2_SPI_WIDTH   32
#define RPU_RPU_INTR_2_SPI_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: RPU_RPU_INTR_3
 */
#define RPU_RPU_INTR_3    ( ( RPU_BASEADDR ) + ((u32)0X00000034U) )

#define RPU_RPU_INTR_3_SPI_SHIFT   0
#define RPU_RPU_INTR_3_SPI_WIDTH   32
#define RPU_RPU_INTR_3_SPI_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: RPU_RPU_INTR_4
 */
#define RPU_RPU_INTR_4    ( ( RPU_BASEADDR ) + ((u32)0X00000038U) )

#define RPU_RPU_INTR_4_SPI_SHIFT   0
#define RPU_RPU_INTR_4_SPI_WIDTH   32
#define RPU_RPU_INTR_4_SPI_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: RPU_RPU_INTR_MASK_0
 */
#define RPU_RPU_INTR_MASK_0    ( ( RPU_BASEADDR ) + ((u32)0X00000040U) )

#define RPU_RPU_INTR_MASK_0_SPI_SHIFT   0
#define RPU_RPU_INTR_MASK_0_SPI_WIDTH   32
#define RPU_RPU_INTR_MASK_0_SPI_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: RPU_RPU_INTR_MASK_1
 */
#define RPU_RPU_INTR_MASK_1    ( ( RPU_BASEADDR ) + ((u32)0X00000044U) )

#define RPU_RPU_INTR_MASK_1_SPI_SHIFT   0
#define RPU_RPU_INTR_MASK_1_SPI_WIDTH   32
#define RPU_RPU_INTR_MASK_1_SPI_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: RPU_RPU_INTR_MASK_2
 */
#define RPU_RPU_INTR_MASK_2    ( ( RPU_BASEADDR ) + ((u32)0X00000048U) )

#define RPU_RPU_INTR_MASK_2_SPI_SHIFT   0
#define RPU_RPU_INTR_MASK_2_SPI_WIDTH   32
#define RPU_RPU_INTR_MASK_2_SPI_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: RPU_RPU_INTR_MASK_3
 */
#define RPU_RPU_INTR_MASK_3    ( ( RPU_BASEADDR ) + ((u32)0X0000004CU) )

#define RPU_RPU_INTR_MASK_3_SPI_SHIFT   0
#define RPU_RPU_INTR_MASK_3_SPI_WIDTH   32
#define RPU_RPU_INTR_MASK_3_SPI_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: RPU_RPU_INTR_MASK_4
 */
#define RPU_RPU_INTR_MASK_4    ( ( RPU_BASEADDR ) + ((u32)0X00000050U) )

#define RPU_RPU_INTR_MASK_4_SPI_SHIFT   0
#define RPU_RPU_INTR_MASK_4_SPI_WIDTH   32
#define RPU_RPU_INTR_MASK_4_SPI_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: RPU_RPU_CCF_VAL
 */
#define RPU_RPU_CCF_VAL    ( ( RPU_BASEADDR ) + ((u32)0X00000054U) )

#define RPU_RPU_CCF_VAL_TEST_MBIST_MODE_SHIFT   7
#define RPU_RPU_CCF_VAL_TEST_MBIST_MODE_WIDTH   1
#define RPU_RPU_CCF_VAL_TEST_MBIST_MODE_MASK    ((u32)0X00000080U)

#define RPU_RPU_CCF_VAL_TEST_SCAN_MODE_LP_SHIFT   6
#define RPU_RPU_CCF_VAL_TEST_SCAN_MODE_LP_WIDTH   1
#define RPU_RPU_CCF_VAL_TEST_SCAN_MODE_LP_MASK    ((u32)0X00000040U)

#define RPU_RPU_CCF_VAL_TEST_SCAN_MODE_SHIFT   5
#define RPU_RPU_CCF_VAL_TEST_SCAN_MODE_WIDTH   1
#define RPU_RPU_CCF_VAL_TEST_SCAN_MODE_MASK    ((u32)0X00000020U)

#define RPU_RPU_CCF_VAL_ISO_SHIFT   4
#define RPU_RPU_CCF_VAL_ISO_WIDTH   1
#define RPU_RPU_CCF_VAL_ISO_MASK    ((u32)0X00000010U)

#define RPU_RPU_CCF_VAL_PGE_SHIFT   3
#define RPU_RPU_CCF_VAL_PGE_WIDTH   1
#define RPU_RPU_CCF_VAL_PGE_MASK    ((u32)0X00000008U)

#define RPU_RPU_CCF_VAL_R50_DBG_RST_SHIFT   2
#define RPU_RPU_CCF_VAL_R50_DBG_RST_WIDTH   1
#define RPU_RPU_CCF_VAL_R50_DBG_RST_MASK    ((u32)0X00000004U)

#define RPU_RPU_CCF_VAL_R50_RST_SHIFT   1
#define RPU_RPU_CCF_VAL_R50_RST_WIDTH   1
#define RPU_RPU_CCF_VAL_R50_RST_MASK    ((u32)0X00000002U)

#define RPU_RPU_CCF_VAL_PGE_RST_SHIFT   0
#define RPU_RPU_CCF_VAL_PGE_RST_WIDTH   1
#define RPU_RPU_CCF_VAL_PGE_RST_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_SAFETY_CHK
 */
#define RPU_RPU_SAFETY_CHK    ( ( RPU_BASEADDR ) + ((u32)0X000000F0U) )

#define RPU_RPU_SAFETY_CHK_VAL_SHIFT   0
#define RPU_RPU_SAFETY_CHK_VAL_WIDTH   32
#define RPU_RPU_SAFETY_CHK_VAL_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: RPU_RPU
 */
#define RPU_RPU    ( ( RPU_BASEADDR ) + ((u32)0X000000F4U) )

#define RPU_RPU_ECO_SHIFT   0
#define RPU_RPU_ECO_WIDTH   32
#define RPU_RPU_ECO_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: RPU_RPU_0_CFG
 */
#define RPU_RPU_0_CFG    ( ( RPU_BASEADDR ) + ((u32)0X00000100U) )

#define RPU_RPU_0_CFG_CFGNMFI0_SHIFT   3
#define RPU_RPU_0_CFG_CFGNMFI0_WIDTH   1
#define RPU_RPU_0_CFG_CFGNMFI0_MASK    ((u32)0X00000008U)

#define RPU_RPU_0_CFG_VINITHI_SHIFT   2
#define RPU_RPU_0_CFG_VINITHI_WIDTH   1
#define RPU_RPU_0_CFG_VINITHI_MASK    ((u32)0X00000004U)

#define RPU_RPU_0_CFG_COHERENT_SHIFT   1
#define RPU_RPU_0_CFG_COHERENT_WIDTH   1
#define RPU_RPU_0_CFG_COHERENT_MASK    ((u32)0X00000002U)

#define RPU_RPU_0_CFG_NCPUHALT_SHIFT   0
#define RPU_RPU_0_CFG_NCPUHALT_WIDTH   1
#define RPU_RPU_0_CFG_NCPUHALT_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_0_STATUS
 */
#define RPU_RPU_0_STATUS    ( ( RPU_BASEADDR ) + ((u32)0X00000104U) )

#define RPU_RPU_0_STATUS_NVALRESET_SHIFT   5
#define RPU_RPU_0_STATUS_NVALRESET_WIDTH   1
#define RPU_RPU_0_STATUS_NVALRESET_MASK    ((u32)0X00000020U)

#define RPU_RPU_0_STATUS_NVALIRQ_SHIFT   4
#define RPU_RPU_0_STATUS_NVALIRQ_WIDTH   1
#define RPU_RPU_0_STATUS_NVALIRQ_MASK    ((u32)0X00000010U)

#define RPU_RPU_0_STATUS_NVALFIQ_SHIFT   3
#define RPU_RPU_0_STATUS_NVALFIQ_WIDTH   1
#define RPU_RPU_0_STATUS_NVALFIQ_MASK    ((u32)0X00000008U)

#define RPU_RPU_0_STATUS_NWFIPIPESTOPPED_SHIFT   2
#define RPU_RPU_0_STATUS_NWFIPIPESTOPPED_WIDTH   1
#define RPU_RPU_0_STATUS_NWFIPIPESTOPPED_MASK    ((u32)0X00000004U)

#define RPU_RPU_0_STATUS_NWFEPIPESTOPPED_SHIFT   1
#define RPU_RPU_0_STATUS_NWFEPIPESTOPPED_WIDTH   1
#define RPU_RPU_0_STATUS_NWFEPIPESTOPPED_MASK    ((u32)0X00000002U)

#define RPU_RPU_0_STATUS_NCLKSTOPPED_SHIFT   0
#define RPU_RPU_0_STATUS_NCLKSTOPPED_WIDTH   1
#define RPU_RPU_0_STATUS_NCLKSTOPPED_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_0_PWRDWN
 */
#define RPU_RPU_0_PWRDWN    ( ( RPU_BASEADDR ) + ((u32)0X00000108U) )

#define RPU_RPU_0_PWRDWN_EN_SHIFT   0
#define RPU_RPU_0_PWRDWN_EN_WIDTH   1
#define RPU_RPU_0_PWRDWN_EN_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_0_ISR
 */
#define RPU_RPU_0_ISR    ( ( RPU_BASEADDR ) + ((u32)0X00000114U) )

#define RPU_RPU_0_ISR_FPUFC_SHIFT   24
#define RPU_RPU_0_ISR_FPUFC_WIDTH   1
#define RPU_RPU_0_ISR_FPUFC_MASK    ((u32)0X01000000U)

#define RPU_RPU_0_ISR_FPOFC_SHIFT   23
#define RPU_RPU_0_ISR_FPOFC_WIDTH   1
#define RPU_RPU_0_ISR_FPOFC_MASK    ((u32)0X00800000U)

#define RPU_RPU_0_ISR_FPIXC_SHIFT   22
#define RPU_RPU_0_ISR_FPIXC_WIDTH   1
#define RPU_RPU_0_ISR_FPIXC_MASK    ((u32)0X00400000U)

#define RPU_RPU_0_ISR_FPIOC_SHIFT   21
#define RPU_RPU_0_ISR_FPIOC_WIDTH   1
#define RPU_RPU_0_ISR_FPIOC_MASK    ((u32)0X00200000U)

#define RPU_RPU_0_ISR_FPIDC_SHIFT   20
#define RPU_RPU_0_ISR_FPIDC_WIDTH   1
#define RPU_RPU_0_ISR_FPIDC_MASK    ((u32)0X00100000U)

#define RPU_RPU_0_ISR_FPDZC_SHIFT   19
#define RPU_RPU_0_ISR_FPDZC_WIDTH   1
#define RPU_RPU_0_ISR_FPDZC_MASK    ((u32)0X00080000U)

#define RPU_RPU_0_ISR_TCM_ASLV_CE_SHIFT   18
#define RPU_RPU_0_ISR_TCM_ASLV_CE_WIDTH   1
#define RPU_RPU_0_ISR_TCM_ASLV_CE_MASK    ((u32)0X00040000U)

#define RPU_RPU_0_ISR_TCM_ASLV_FAT_SHIFT   17
#define RPU_RPU_0_ISR_TCM_ASLV_FAT_WIDTH   1
#define RPU_RPU_0_ISR_TCM_ASLV_FAT_MASK    ((u32)0X00020000U)

#define RPU_RPU_0_ISR_TCM_LST_CE_SHIFT   16
#define RPU_RPU_0_ISR_TCM_LST_CE_WIDTH   1
#define RPU_RPU_0_ISR_TCM_LST_CE_MASK    ((u32)0X00010000U)

#define RPU_RPU_0_ISR_TCM_PREFETCH_CE_SHIFT   15
#define RPU_RPU_0_ISR_TCM_PREFETCH_CE_WIDTH   1
#define RPU_RPU_0_ISR_TCM_PREFETCH_CE_MASK    ((u32)0X00008000U)

#define RPU_RPU_0_ISR_B1TCM_CE_SHIFT   14
#define RPU_RPU_0_ISR_B1TCM_CE_WIDTH   1
#define RPU_RPU_0_ISR_B1TCM_CE_MASK    ((u32)0X00004000U)

#define RPU_RPU_0_ISR_B0TCM_CE_SHIFT   13
#define RPU_RPU_0_ISR_B0TCM_CE_WIDTH   1
#define RPU_RPU_0_ISR_B0TCM_CE_MASK    ((u32)0X00002000U)

#define RPU_RPU_0_ISR_ATCM_CE_SHIFT   12
#define RPU_RPU_0_ISR_ATCM_CE_WIDTH   1
#define RPU_RPU_0_ISR_ATCM_CE_MASK    ((u32)0X00001000U)

#define RPU_RPU_0_ISR_B1TCM_UE_SHIFT   11
#define RPU_RPU_0_ISR_B1TCM_UE_WIDTH   1
#define RPU_RPU_0_ISR_B1TCM_UE_MASK    ((u32)0X00000800U)

#define RPU_RPU_0_ISR_B0TCM_UE_SHIFT   10
#define RPU_RPU_0_ISR_B0TCM_UE_WIDTH   1
#define RPU_RPU_0_ISR_B0TCM_UE_MASK    ((u32)0X00000400U)

#define RPU_RPU_0_ISR_ATCM_UE_SHIFT   9
#define RPU_RPU_0_ISR_ATCM_UE_WIDTH   1
#define RPU_RPU_0_ISR_ATCM_UE_MASK    ((u32)0X00000200U)

#define RPU_RPU_0_ISR_DTAG_DIRTY_FAT_SHIFT   8
#define RPU_RPU_0_ISR_DTAG_DIRTY_FAT_WIDTH   1
#define RPU_RPU_0_ISR_DTAG_DIRTY_FAT_MASK    ((u32)0X00000100U)

#define RPU_RPU_0_ISR_DDATA_FAT_SHIFT   7
#define RPU_RPU_0_ISR_DDATA_FAT_WIDTH   1
#define RPU_RPU_0_ISR_DDATA_FAT_MASK    ((u32)0X00000080U)

#define RPU_RPU_0_ISR_TCM_LST_FAT_SHIFT   6
#define RPU_RPU_0_ISR_TCM_LST_FAT_WIDTH   1
#define RPU_RPU_0_ISR_TCM_LST_FAT_MASK    ((u32)0X00000040U)

#define RPU_RPU_0_ISR_TCM_PREFETCH_FAT_SHIFT   5
#define RPU_RPU_0_ISR_TCM_PREFETCH_FAT_WIDTH   1
#define RPU_RPU_0_ISR_TCM_PREFETCH_FAT_MASK    ((u32)0X00000020U)

#define RPU_RPU_0_ISR_DDATA_CE_SHIFT   4
#define RPU_RPU_0_ISR_DDATA_CE_WIDTH   1
#define RPU_RPU_0_ISR_DDATA_CE_MASK    ((u32)0X00000010U)

#define RPU_RPU_0_ISR_DTAG_DIRTY_CE_SHIFT   3
#define RPU_RPU_0_ISR_DTAG_DIRTY_CE_WIDTH   1
#define RPU_RPU_0_ISR_DTAG_DIRTY_CE_MASK    ((u32)0X00000008U)

#define RPU_RPU_0_ISR_IDATA_CE_SHIFT   2
#define RPU_RPU_0_ISR_IDATA_CE_WIDTH   1
#define RPU_RPU_0_ISR_IDATA_CE_MASK    ((u32)0X00000004U)

#define RPU_RPU_0_ISR_ITAG_CE_SHIFT   1
#define RPU_RPU_0_ISR_ITAG_CE_WIDTH   1
#define RPU_RPU_0_ISR_ITAG_CE_MASK    ((u32)0X00000002U)

#define RPU_RPU_0_ISR_APB_ERR_SHIFT   0
#define RPU_RPU_0_ISR_APB_ERR_WIDTH   1
#define RPU_RPU_0_ISR_APB_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_0_IMR
 */
#define RPU_RPU_0_IMR    ( ( RPU_BASEADDR ) + ((u32)0X00000118U) )

#define RPU_RPU_0_IMR_FPUFC_SHIFT   24
#define RPU_RPU_0_IMR_FPUFC_WIDTH   1
#define RPU_RPU_0_IMR_FPUFC_MASK    ((u32)0X01000000U)

#define RPU_RPU_0_IMR_FPOFC_SHIFT   23
#define RPU_RPU_0_IMR_FPOFC_WIDTH   1
#define RPU_RPU_0_IMR_FPOFC_MASK    ((u32)0X00800000U)

#define RPU_RPU_0_IMR_FPIXC_SHIFT   22
#define RPU_RPU_0_IMR_FPIXC_WIDTH   1
#define RPU_RPU_0_IMR_FPIXC_MASK    ((u32)0X00400000U)

#define RPU_RPU_0_IMR_FPIOC_SHIFT   21
#define RPU_RPU_0_IMR_FPIOC_WIDTH   1
#define RPU_RPU_0_IMR_FPIOC_MASK    ((u32)0X00200000U)

#define RPU_RPU_0_IMR_FPIDC_SHIFT   20
#define RPU_RPU_0_IMR_FPIDC_WIDTH   1
#define RPU_RPU_0_IMR_FPIDC_MASK    ((u32)0X00100000U)

#define RPU_RPU_0_IMR_FPDZC_SHIFT   19
#define RPU_RPU_0_IMR_FPDZC_WIDTH   1
#define RPU_RPU_0_IMR_FPDZC_MASK    ((u32)0X00080000U)

#define RPU_RPU_0_IMR_TCM_ASLV_CE_SHIFT   18
#define RPU_RPU_0_IMR_TCM_ASLV_CE_WIDTH   1
#define RPU_RPU_0_IMR_TCM_ASLV_CE_MASK    ((u32)0X00040000U)

#define RPU_RPU_0_IMR_TCM_ASLV_FAT_SHIFT   17
#define RPU_RPU_0_IMR_TCM_ASLV_FAT_WIDTH   1
#define RPU_RPU_0_IMR_TCM_ASLV_FAT_MASK    ((u32)0X00020000U)

#define RPU_RPU_0_IMR_TCM_LST_CE_SHIFT   16
#define RPU_RPU_0_IMR_TCM_LST_CE_WIDTH   1
#define RPU_RPU_0_IMR_TCM_LST_CE_MASK    ((u32)0X00010000U)

#define RPU_RPU_0_IMR_TCM_PREFETCH_CE_SHIFT   15
#define RPU_RPU_0_IMR_TCM_PREFETCH_CE_WIDTH   1
#define RPU_RPU_0_IMR_TCM_PREFETCH_CE_MASK    ((u32)0X00008000U)

#define RPU_RPU_0_IMR_B1TCM_CE_SHIFT   14
#define RPU_RPU_0_IMR_B1TCM_CE_WIDTH   1
#define RPU_RPU_0_IMR_B1TCM_CE_MASK    ((u32)0X00004000U)

#define RPU_RPU_0_IMR_B0TCM_CE_SHIFT   13
#define RPU_RPU_0_IMR_B0TCM_CE_WIDTH   1
#define RPU_RPU_0_IMR_B0TCM_CE_MASK    ((u32)0X00002000U)

#define RPU_RPU_0_IMR_ATCM_CE_SHIFT   12
#define RPU_RPU_0_IMR_ATCM_CE_WIDTH   1
#define RPU_RPU_0_IMR_ATCM_CE_MASK    ((u32)0X00001000U)

#define RPU_RPU_0_IMR_B1TCM_UE_SHIFT   11
#define RPU_RPU_0_IMR_B1TCM_UE_WIDTH   1
#define RPU_RPU_0_IMR_B1TCM_UE_MASK    ((u32)0X00000800U)

#define RPU_RPU_0_IMR_B0TCM_UE_SHIFT   10
#define RPU_RPU_0_IMR_B0TCM_UE_WIDTH   1
#define RPU_RPU_0_IMR_B0TCM_UE_MASK    ((u32)0X00000400U)

#define RPU_RPU_0_IMR_ATCM_UE_SHIFT   9
#define RPU_RPU_0_IMR_ATCM_UE_WIDTH   1
#define RPU_RPU_0_IMR_ATCM_UE_MASK    ((u32)0X00000200U)

#define RPU_RPU_0_IMR_DTAG_DIRTY_FAT_SHIFT   8
#define RPU_RPU_0_IMR_DTAG_DIRTY_FAT_WIDTH   1
#define RPU_RPU_0_IMR_DTAG_DIRTY_FAT_MASK    ((u32)0X00000100U)

#define RPU_RPU_0_IMR_DDATA_FAT_SHIFT   7
#define RPU_RPU_0_IMR_DDATA_FAT_WIDTH   1
#define RPU_RPU_0_IMR_DDATA_FAT_MASK    ((u32)0X00000080U)

#define RPU_RPU_0_IMR_TCM_LST_FAT_SHIFT   6
#define RPU_RPU_0_IMR_TCM_LST_FAT_WIDTH   1
#define RPU_RPU_0_IMR_TCM_LST_FAT_MASK    ((u32)0X00000040U)

#define RPU_RPU_0_IMR_TCM_PREFETCH_FAT_SHIFT   5
#define RPU_RPU_0_IMR_TCM_PREFETCH_FAT_WIDTH   1
#define RPU_RPU_0_IMR_TCM_PREFETCH_FAT_MASK    ((u32)0X00000020U)

#define RPU_RPU_0_IMR_DDATA_CE_SHIFT   4
#define RPU_RPU_0_IMR_DDATA_CE_WIDTH   1
#define RPU_RPU_0_IMR_DDATA_CE_MASK    ((u32)0X00000010U)

#define RPU_RPU_0_IMR_DTAG_DIRTY_CE_SHIFT   3
#define RPU_RPU_0_IMR_DTAG_DIRTY_CE_WIDTH   1
#define RPU_RPU_0_IMR_DTAG_DIRTY_CE_MASK    ((u32)0X00000008U)

#define RPU_RPU_0_IMR_IDATA_CE_SHIFT   2
#define RPU_RPU_0_IMR_IDATA_CE_WIDTH   1
#define RPU_RPU_0_IMR_IDATA_CE_MASK    ((u32)0X00000004U)

#define RPU_RPU_0_IMR_ITAG_CE_SHIFT   1
#define RPU_RPU_0_IMR_ITAG_CE_WIDTH   1
#define RPU_RPU_0_IMR_ITAG_CE_MASK    ((u32)0X00000002U)

#define RPU_RPU_0_IMR_APB_ERR_SHIFT   0
#define RPU_RPU_0_IMR_APB_ERR_WIDTH   1
#define RPU_RPU_0_IMR_APB_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_0_IEN
 */
#define RPU_RPU_0_IEN    ( ( RPU_BASEADDR ) + ((u32)0X0000011CU) )

#define RPU_RPU_0_IEN_FPUFC_SHIFT   24
#define RPU_RPU_0_IEN_FPUFC_WIDTH   1
#define RPU_RPU_0_IEN_FPUFC_MASK    ((u32)0X01000000U)

#define RPU_RPU_0_IEN_FPOFC_SHIFT   23
#define RPU_RPU_0_IEN_FPOFC_WIDTH   1
#define RPU_RPU_0_IEN_FPOFC_MASK    ((u32)0X00800000U)

#define RPU_RPU_0_IEN_FPIXC_SHIFT   22
#define RPU_RPU_0_IEN_FPIXC_WIDTH   1
#define RPU_RPU_0_IEN_FPIXC_MASK    ((u32)0X00400000U)

#define RPU_RPU_0_IEN_FPIOC_SHIFT   21
#define RPU_RPU_0_IEN_FPIOC_WIDTH   1
#define RPU_RPU_0_IEN_FPIOC_MASK    ((u32)0X00200000U)

#define RPU_RPU_0_IEN_FPIDC_SHIFT   20
#define RPU_RPU_0_IEN_FPIDC_WIDTH   1
#define RPU_RPU_0_IEN_FPIDC_MASK    ((u32)0X00100000U)

#define RPU_RPU_0_IEN_FPDZC_SHIFT   19
#define RPU_RPU_0_IEN_FPDZC_WIDTH   1
#define RPU_RPU_0_IEN_FPDZC_MASK    ((u32)0X00080000U)

#define RPU_RPU_0_IEN_TCM_ASLV_CE_SHIFT   18
#define RPU_RPU_0_IEN_TCM_ASLV_CE_WIDTH   1
#define RPU_RPU_0_IEN_TCM_ASLV_CE_MASK    ((u32)0X00040000U)

#define RPU_RPU_0_IEN_TCM_ASLV_FAT_SHIFT   17
#define RPU_RPU_0_IEN_TCM_ASLV_FAT_WIDTH   1
#define RPU_RPU_0_IEN_TCM_ASLV_FAT_MASK    ((u32)0X00020000U)

#define RPU_RPU_0_IEN_TCM_LST_CE_SHIFT   16
#define RPU_RPU_0_IEN_TCM_LST_CE_WIDTH   1
#define RPU_RPU_0_IEN_TCM_LST_CE_MASK    ((u32)0X00010000U)

#define RPU_RPU_0_IEN_TCM_PREFETCH_CE_SHIFT   15
#define RPU_RPU_0_IEN_TCM_PREFETCH_CE_WIDTH   1
#define RPU_RPU_0_IEN_TCM_PREFETCH_CE_MASK    ((u32)0X00008000U)

#define RPU_RPU_0_IEN_B1TCM_CE_SHIFT   14
#define RPU_RPU_0_IEN_B1TCM_CE_WIDTH   1
#define RPU_RPU_0_IEN_B1TCM_CE_MASK    ((u32)0X00004000U)

#define RPU_RPU_0_IEN_B0TCM_CE_SHIFT   13
#define RPU_RPU_0_IEN_B0TCM_CE_WIDTH   1
#define RPU_RPU_0_IEN_B0TCM_CE_MASK    ((u32)0X00002000U)

#define RPU_RPU_0_IEN_ATCM_CE_SHIFT   12
#define RPU_RPU_0_IEN_ATCM_CE_WIDTH   1
#define RPU_RPU_0_IEN_ATCM_CE_MASK    ((u32)0X00001000U)

#define RPU_RPU_0_IEN_B1TCM_UE_SHIFT   11
#define RPU_RPU_0_IEN_B1TCM_UE_WIDTH   1
#define RPU_RPU_0_IEN_B1TCM_UE_MASK    ((u32)0X00000800U)

#define RPU_RPU_0_IEN_B0TCM_UE_SHIFT   10
#define RPU_RPU_0_IEN_B0TCM_UE_WIDTH   1
#define RPU_RPU_0_IEN_B0TCM_UE_MASK    ((u32)0X00000400U)

#define RPU_RPU_0_IEN_ATCM_UE_SHIFT   9
#define RPU_RPU_0_IEN_ATCM_UE_WIDTH   1
#define RPU_RPU_0_IEN_ATCM_UE_MASK    ((u32)0X00000200U)

#define RPU_RPU_0_IEN_DTAG_DIRTY_FAT_SHIFT   8
#define RPU_RPU_0_IEN_DTAG_DIRTY_FAT_WIDTH   1
#define RPU_RPU_0_IEN_DTAG_DIRTY_FAT_MASK    ((u32)0X00000100U)

#define RPU_RPU_0_IEN_DDATA_FAT_SHIFT   7
#define RPU_RPU_0_IEN_DDATA_FAT_WIDTH   1
#define RPU_RPU_0_IEN_DDATA_FAT_MASK    ((u32)0X00000080U)

#define RPU_RPU_0_IEN_TCM_LST_FAT_SHIFT   6
#define RPU_RPU_0_IEN_TCM_LST_FAT_WIDTH   1
#define RPU_RPU_0_IEN_TCM_LST_FAT_MASK    ((u32)0X00000040U)

#define RPU_RPU_0_IEN_TCM_PREFETCH_FAT_SHIFT   5
#define RPU_RPU_0_IEN_TCM_PREFETCH_FAT_WIDTH   1
#define RPU_RPU_0_IEN_TCM_PREFETCH_FAT_MASK    ((u32)0X00000020U)

#define RPU_RPU_0_IEN_DDATA_CE_SHIFT   4
#define RPU_RPU_0_IEN_DDATA_CE_WIDTH   1
#define RPU_RPU_0_IEN_DDATA_CE_MASK    ((u32)0X00000010U)

#define RPU_RPU_0_IEN_DTAG_DIRTY_CE_SHIFT   3
#define RPU_RPU_0_IEN_DTAG_DIRTY_CE_WIDTH   1
#define RPU_RPU_0_IEN_DTAG_DIRTY_CE_MASK    ((u32)0X00000008U)

#define RPU_RPU_0_IEN_IDATA_CE_SHIFT   2
#define RPU_RPU_0_IEN_IDATA_CE_WIDTH   1
#define RPU_RPU_0_IEN_IDATA_CE_MASK    ((u32)0X00000004U)

#define RPU_RPU_0_IEN_ITAG_CE_SHIFT   1
#define RPU_RPU_0_IEN_ITAG_CE_WIDTH   1
#define RPU_RPU_0_IEN_ITAG_CE_MASK    ((u32)0X00000002U)

#define RPU_RPU_0_IEN_APB_ERR_SHIFT   0
#define RPU_RPU_0_IEN_APB_ERR_WIDTH   1
#define RPU_RPU_0_IEN_APB_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_0_IDS
 */
#define RPU_RPU_0_IDS    ( ( RPU_BASEADDR ) + ((u32)0X00000120U) )

#define RPU_RPU_0_IDS_FPUFC_SHIFT   24
#define RPU_RPU_0_IDS_FPUFC_WIDTH   1
#define RPU_RPU_0_IDS_FPUFC_MASK    ((u32)0X01000000U)

#define RPU_RPU_0_IDS_FPOFC_SHIFT   23
#define RPU_RPU_0_IDS_FPOFC_WIDTH   1
#define RPU_RPU_0_IDS_FPOFC_MASK    ((u32)0X00800000U)

#define RPU_RPU_0_IDS_FPIXC_SHIFT   22
#define RPU_RPU_0_IDS_FPIXC_WIDTH   1
#define RPU_RPU_0_IDS_FPIXC_MASK    ((u32)0X00400000U)

#define RPU_RPU_0_IDS_FPIOC_SHIFT   21
#define RPU_RPU_0_IDS_FPIOC_WIDTH   1
#define RPU_RPU_0_IDS_FPIOC_MASK    ((u32)0X00200000U)

#define RPU_RPU_0_IDS_FPIDC_SHIFT   20
#define RPU_RPU_0_IDS_FPIDC_WIDTH   1
#define RPU_RPU_0_IDS_FPIDC_MASK    ((u32)0X00100000U)

#define RPU_RPU_0_IDS_FPDZC_SHIFT   19
#define RPU_RPU_0_IDS_FPDZC_WIDTH   1
#define RPU_RPU_0_IDS_FPDZC_MASK    ((u32)0X00080000U)

#define RPU_RPU_0_IDS_TCM_ASLV_CE_SHIFT   18
#define RPU_RPU_0_IDS_TCM_ASLV_CE_WIDTH   1
#define RPU_RPU_0_IDS_TCM_ASLV_CE_MASK    ((u32)0X00040000U)

#define RPU_RPU_0_IDS_TCM_ASLV_FAT_SHIFT   17
#define RPU_RPU_0_IDS_TCM_ASLV_FAT_WIDTH   1
#define RPU_RPU_0_IDS_TCM_ASLV_FAT_MASK    ((u32)0X00020000U)

#define RPU_RPU_0_IDS_TCM_LST_CE_SHIFT   16
#define RPU_RPU_0_IDS_TCM_LST_CE_WIDTH   1
#define RPU_RPU_0_IDS_TCM_LST_CE_MASK    ((u32)0X00010000U)

#define RPU_RPU_0_IDS_TCM_PREFETCH_CE_SHIFT   15
#define RPU_RPU_0_IDS_TCM_PREFETCH_CE_WIDTH   1
#define RPU_RPU_0_IDS_TCM_PREFETCH_CE_MASK    ((u32)0X00008000U)

#define RPU_RPU_0_IDS_B1TCM_CE_SHIFT   14
#define RPU_RPU_0_IDS_B1TCM_CE_WIDTH   1
#define RPU_RPU_0_IDS_B1TCM_CE_MASK    ((u32)0X00004000U)

#define RPU_RPU_0_IDS_B0TCM_CE_SHIFT   13
#define RPU_RPU_0_IDS_B0TCM_CE_WIDTH   1
#define RPU_RPU_0_IDS_B0TCM_CE_MASK    ((u32)0X00002000U)

#define RPU_RPU_0_IDS_ATCM_CE_SHIFT   12
#define RPU_RPU_0_IDS_ATCM_CE_WIDTH   1
#define RPU_RPU_0_IDS_ATCM_CE_MASK    ((u32)0X00001000U)

#define RPU_RPU_0_IDS_B1TCM_UE_SHIFT   11
#define RPU_RPU_0_IDS_B1TCM_UE_WIDTH   1
#define RPU_RPU_0_IDS_B1TCM_UE_MASK    ((u32)0X00000800U)

#define RPU_RPU_0_IDS_B0TCM_UE_SHIFT   10
#define RPU_RPU_0_IDS_B0TCM_UE_WIDTH   1
#define RPU_RPU_0_IDS_B0TCM_UE_MASK    ((u32)0X00000400U)

#define RPU_RPU_0_IDS_ATCM_UE_SHIFT   9
#define RPU_RPU_0_IDS_ATCM_UE_WIDTH   1
#define RPU_RPU_0_IDS_ATCM_UE_MASK    ((u32)0X00000200U)

#define RPU_RPU_0_IDS_DTAG_DIRTY_FAT_SHIFT   8
#define RPU_RPU_0_IDS_DTAG_DIRTY_FAT_WIDTH   1
#define RPU_RPU_0_IDS_DTAG_DIRTY_FAT_MASK    ((u32)0X00000100U)

#define RPU_RPU_0_IDS_DDATA_FAT_SHIFT   7
#define RPU_RPU_0_IDS_DDATA_FAT_WIDTH   1
#define RPU_RPU_0_IDS_DDATA_FAT_MASK    ((u32)0X00000080U)

#define RPU_RPU_0_IDS_TCM_LST_FAT_SHIFT   6
#define RPU_RPU_0_IDS_TCM_LST_FAT_WIDTH   1
#define RPU_RPU_0_IDS_TCM_LST_FAT_MASK    ((u32)0X00000040U)

#define RPU_RPU_0_IDS_TCM_PREFETCH_FAT_SHIFT   5
#define RPU_RPU_0_IDS_TCM_PREFETCH_FAT_WIDTH   1
#define RPU_RPU_0_IDS_TCM_PREFETCH_FAT_MASK    ((u32)0X00000020U)

#define RPU_RPU_0_IDS_DDATA_CE_SHIFT   4
#define RPU_RPU_0_IDS_DDATA_CE_WIDTH   1
#define RPU_RPU_0_IDS_DDATA_CE_MASK    ((u32)0X00000010U)

#define RPU_RPU_0_IDS_DTAG_DIRTY_CE_SHIFT   3
#define RPU_RPU_0_IDS_DTAG_DIRTY_CE_WIDTH   1
#define RPU_RPU_0_IDS_DTAG_DIRTY_CE_MASK    ((u32)0X00000008U)

#define RPU_RPU_0_IDS_IDATA_CE_SHIFT   2
#define RPU_RPU_0_IDS_IDATA_CE_WIDTH   1
#define RPU_RPU_0_IDS_IDATA_CE_MASK    ((u32)0X00000004U)

#define RPU_RPU_0_IDS_ITAG_CE_SHIFT   1
#define RPU_RPU_0_IDS_ITAG_CE_WIDTH   1
#define RPU_RPU_0_IDS_ITAG_CE_MASK    ((u32)0X00000002U)

#define RPU_RPU_0_IDS_APB_ERR_SHIFT   0
#define RPU_RPU_0_IDS_APB_ERR_WIDTH   1
#define RPU_RPU_0_IDS_APB_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_0_SLV_BASE
 */
#define RPU_RPU_0_SLV_BASE    ( ( RPU_BASEADDR ) + ((u32)0X00000124U) )

#define RPU_RPU_0_SLV_BASE_ADDR_SHIFT   0
#define RPU_RPU_0_SLV_BASE_ADDR_WIDTH   8
#define RPU_RPU_0_SLV_BASE_ADDR_MASK    ((u32)0X000000FFU)

/**
 * Register: RPU_RPU_0_AXI_OVER
 */
#define RPU_RPU_0_AXI_OVER    ( ( RPU_BASEADDR ) + ((u32)0X00000128U) )

#define RPU_RPU_0_AXI_OVER_AWCACHE_SHIFT   6
#define RPU_RPU_0_AXI_OVER_AWCACHE_WIDTH   4
#define RPU_RPU_0_AXI_OVER_AWCACHE_MASK    ((u32)0X000003C0U)

#define RPU_RPU_0_AXI_OVER_ARCACHE_SHIFT   2
#define RPU_RPU_0_AXI_OVER_ARCACHE_WIDTH   4
#define RPU_RPU_0_AXI_OVER_ARCACHE_MASK    ((u32)0X0000003CU)

#define RPU_RPU_0_AXI_OVER_AWCACHE_EN_SHIFT   1
#define RPU_RPU_0_AXI_OVER_AWCACHE_EN_WIDTH   1
#define RPU_RPU_0_AXI_OVER_AWCACHE_EN_MASK    ((u32)0X00000002U)

#define RPU_RPU_0_AXI_OVER_ARCACHE_EN_SHIFT   0
#define RPU_RPU_0_AXI_OVER_ARCACHE_EN_WIDTH   1
#define RPU_RPU_0_AXI_OVER_ARCACHE_EN_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_1_CFG
 */
#define RPU_RPU_1_CFG    ( ( RPU_BASEADDR ) + ((u32)0X00000200U) )

#define RPU_RPU_1_CFG_CFGNMFI1_SHIFT   3
#define RPU_RPU_1_CFG_CFGNMFI1_WIDTH   1
#define RPU_RPU_1_CFG_CFGNMFI1_MASK    ((u32)0X00000008U)

#define RPU_RPU_1_CFG_VINITHI_SHIFT   2
#define RPU_RPU_1_CFG_VINITHI_WIDTH   1
#define RPU_RPU_1_CFG_VINITHI_MASK    ((u32)0X00000004U)

#define RPU_RPU_1_CFG_COHERENT_SHIFT   1
#define RPU_RPU_1_CFG_COHERENT_WIDTH   1
#define RPU_RPU_1_CFG_COHERENT_MASK    ((u32)0X00000002U)

#define RPU_RPU_1_CFG_NCPUHALT_SHIFT   0
#define RPU_RPU_1_CFG_NCPUHALT_WIDTH   1
#define RPU_RPU_1_CFG_NCPUHALT_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_1_STATUS
 */
#define RPU_RPU_1_STATUS    ( ( RPU_BASEADDR ) + ((u32)0X00000204U) )

#define RPU_RPU_1_STATUS_NVALRESET_SHIFT   5
#define RPU_RPU_1_STATUS_NVALRESET_WIDTH   1
#define RPU_RPU_1_STATUS_NVALRESET_MASK    ((u32)0X00000020U)

#define RPU_RPU_1_STATUS_NVALIRQ_SHIFT   4
#define RPU_RPU_1_STATUS_NVALIRQ_WIDTH   1
#define RPU_RPU_1_STATUS_NVALIRQ_MASK    ((u32)0X00000010U)

#define RPU_RPU_1_STATUS_NVALFIQ_SHIFT   3
#define RPU_RPU_1_STATUS_NVALFIQ_WIDTH   1
#define RPU_RPU_1_STATUS_NVALFIQ_MASK    ((u32)0X00000008U)

#define RPU_RPU_1_STATUS_NWFIPIPESTOPPED_SHIFT   2
#define RPU_RPU_1_STATUS_NWFIPIPESTOPPED_WIDTH   1
#define RPU_RPU_1_STATUS_NWFIPIPESTOPPED_MASK    ((u32)0X00000004U)

#define RPU_RPU_1_STATUS_NWFEPIPESTOPPED_SHIFT   1
#define RPU_RPU_1_STATUS_NWFEPIPESTOPPED_WIDTH   1
#define RPU_RPU_1_STATUS_NWFEPIPESTOPPED_MASK    ((u32)0X00000002U)

#define RPU_RPU_1_STATUS_NCLKSTOPPED_SHIFT   0
#define RPU_RPU_1_STATUS_NCLKSTOPPED_WIDTH   1
#define RPU_RPU_1_STATUS_NCLKSTOPPED_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_1_PWRDWN
 */
#define RPU_RPU_1_PWRDWN    ( ( RPU_BASEADDR ) + ((u32)0X00000208U) )

#define RPU_RPU_1_PWRDWN_EN_SHIFT   0
#define RPU_RPU_1_PWRDWN_EN_WIDTH   1
#define RPU_RPU_1_PWRDWN_EN_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_1_ISR
 */
#define RPU_RPU_1_ISR    ( ( RPU_BASEADDR ) + ((u32)0X00000214U) )

#define RPU_RPU_1_ISR_FPUFC_SHIFT   24
#define RPU_RPU_1_ISR_FPUFC_WIDTH   1
#define RPU_RPU_1_ISR_FPUFC_MASK    ((u32)0X01000000U)

#define RPU_RPU_1_ISR_FPOFC_SHIFT   23
#define RPU_RPU_1_ISR_FPOFC_WIDTH   1
#define RPU_RPU_1_ISR_FPOFC_MASK    ((u32)0X00800000U)

#define RPU_RPU_1_ISR_FPIXC_SHIFT   22
#define RPU_RPU_1_ISR_FPIXC_WIDTH   1
#define RPU_RPU_1_ISR_FPIXC_MASK    ((u32)0X00400000U)

#define RPU_RPU_1_ISR_FPIOC_SHIFT   21
#define RPU_RPU_1_ISR_FPIOC_WIDTH   1
#define RPU_RPU_1_ISR_FPIOC_MASK    ((u32)0X00200000U)

#define RPU_RPU_1_ISR_FPIDC_SHIFT   20
#define RPU_RPU_1_ISR_FPIDC_WIDTH   1
#define RPU_RPU_1_ISR_FPIDC_MASK    ((u32)0X00100000U)

#define RPU_RPU_1_ISR_FPDZC_SHIFT   19
#define RPU_RPU_1_ISR_FPDZC_WIDTH   1
#define RPU_RPU_1_ISR_FPDZC_MASK    ((u32)0X00080000U)

#define RPU_RPU_1_ISR_TCM_ASLV_CE_SHIFT   18
#define RPU_RPU_1_ISR_TCM_ASLV_CE_WIDTH   1
#define RPU_RPU_1_ISR_TCM_ASLV_CE_MASK    ((u32)0X00040000U)

#define RPU_RPU_1_ISR_TCM_ASLV_FAT_SHIFT   17
#define RPU_RPU_1_ISR_TCM_ASLV_FAT_WIDTH   1
#define RPU_RPU_1_ISR_TCM_ASLV_FAT_MASK    ((u32)0X00020000U)

#define RPU_RPU_1_ISR_TCM_LST_CE_SHIFT   16
#define RPU_RPU_1_ISR_TCM_LST_CE_WIDTH   1
#define RPU_RPU_1_ISR_TCM_LST_CE_MASK    ((u32)0X00010000U)

#define RPU_RPU_1_ISR_TCM_PREFETCH_CE_SHIFT   15
#define RPU_RPU_1_ISR_TCM_PREFETCH_CE_WIDTH   1
#define RPU_RPU_1_ISR_TCM_PREFETCH_CE_MASK    ((u32)0X00008000U)

#define RPU_RPU_1_ISR_B1TCM_CE_SHIFT   14
#define RPU_RPU_1_ISR_B1TCM_CE_WIDTH   1
#define RPU_RPU_1_ISR_B1TCM_CE_MASK    ((u32)0X00004000U)

#define RPU_RPU_1_ISR_B0TCM_CE_SHIFT   13
#define RPU_RPU_1_ISR_B0TCM_CE_WIDTH   1
#define RPU_RPU_1_ISR_B0TCM_CE_MASK    ((u32)0X00002000U)

#define RPU_RPU_1_ISR_ATCM_CE_SHIFT   12
#define RPU_RPU_1_ISR_ATCM_CE_WIDTH   1
#define RPU_RPU_1_ISR_ATCM_CE_MASK    ((u32)0X00001000U)

#define RPU_RPU_1_ISR_B1TCM_UE_SHIFT   11
#define RPU_RPU_1_ISR_B1TCM_UE_WIDTH   1
#define RPU_RPU_1_ISR_B1TCM_UE_MASK    ((u32)0X00000800U)

#define RPU_RPU_1_ISR_B0TCM_UE_SHIFT   10
#define RPU_RPU_1_ISR_B0TCM_UE_WIDTH   1
#define RPU_RPU_1_ISR_B0TCM_UE_MASK    ((u32)0X00000400U)

#define RPU_RPU_1_ISR_ATCM_UE_SHIFT   9
#define RPU_RPU_1_ISR_ATCM_UE_WIDTH   1
#define RPU_RPU_1_ISR_ATCM_UE_MASK    ((u32)0X00000200U)

#define RPU_RPU_1_ISR_DTAG_DIRTY_FAT_SHIFT   8
#define RPU_RPU_1_ISR_DTAG_DIRTY_FAT_WIDTH   1
#define RPU_RPU_1_ISR_DTAG_DIRTY_FAT_MASK    ((u32)0X00000100U)

#define RPU_RPU_1_ISR_DDATA_FAT_SHIFT   7
#define RPU_RPU_1_ISR_DDATA_FAT_WIDTH   1
#define RPU_RPU_1_ISR_DDATA_FAT_MASK    ((u32)0X00000080U)

#define RPU_RPU_1_ISR_TCM_LST_FAT_SHIFT   6
#define RPU_RPU_1_ISR_TCM_LST_FAT_WIDTH   1
#define RPU_RPU_1_ISR_TCM_LST_FAT_MASK    ((u32)0X00000040U)

#define RPU_RPU_1_ISR_TCM_PREFETCH_FAT_SHIFT   5
#define RPU_RPU_1_ISR_TCM_PREFETCH_FAT_WIDTH   1
#define RPU_RPU_1_ISR_TCM_PREFETCH_FAT_MASK    ((u32)0X00000020U)

#define RPU_RPU_1_ISR_DDATA_CE_SHIFT   4
#define RPU_RPU_1_ISR_DDATA_CE_WIDTH   1
#define RPU_RPU_1_ISR_DDATA_CE_MASK    ((u32)0X00000010U)

#define RPU_RPU_1_ISR_DTAG_DIRTY_CE_SHIFT   3
#define RPU_RPU_1_ISR_DTAG_DIRTY_CE_WIDTH   1
#define RPU_RPU_1_ISR_DTAG_DIRTY_CE_MASK    ((u32)0X00000008U)

#define RPU_RPU_1_ISR_IDATA_CE_SHIFT   2
#define RPU_RPU_1_ISR_IDATA_CE_WIDTH   1
#define RPU_RPU_1_ISR_IDATA_CE_MASK    ((u32)0X00000004U)

#define RPU_RPU_1_ISR_ITAG_CE_SHIFT   1
#define RPU_RPU_1_ISR_ITAG_CE_WIDTH   1
#define RPU_RPU_1_ISR_ITAG_CE_MASK    ((u32)0X00000002U)

#define RPU_RPU_1_ISR_APB_ERR_SHIFT   0
#define RPU_RPU_1_ISR_APB_ERR_WIDTH   1
#define RPU_RPU_1_ISR_APB_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_1_IMR
 */
#define RPU_RPU_1_IMR    ( ( RPU_BASEADDR ) + ((u32)0X00000218U) )

#define RPU_RPU_1_IMR_FPUFC_SHIFT   24
#define RPU_RPU_1_IMR_FPUFC_WIDTH   1
#define RPU_RPU_1_IMR_FPUFC_MASK    ((u32)0X01000000U)

#define RPU_RPU_1_IMR_FPOFC_SHIFT   23
#define RPU_RPU_1_IMR_FPOFC_WIDTH   1
#define RPU_RPU_1_IMR_FPOFC_MASK    ((u32)0X00800000U)

#define RPU_RPU_1_IMR_FPIXC_SHIFT   22
#define RPU_RPU_1_IMR_FPIXC_WIDTH   1
#define RPU_RPU_1_IMR_FPIXC_MASK    ((u32)0X00400000U)

#define RPU_RPU_1_IMR_FPIOC_SHIFT   21
#define RPU_RPU_1_IMR_FPIOC_WIDTH   1
#define RPU_RPU_1_IMR_FPIOC_MASK    ((u32)0X00200000U)

#define RPU_RPU_1_IMR_FPIDC_SHIFT   20
#define RPU_RPU_1_IMR_FPIDC_WIDTH   1
#define RPU_RPU_1_IMR_FPIDC_MASK    ((u32)0X00100000U)

#define RPU_RPU_1_IMR_FPDZC_SHIFT   19
#define RPU_RPU_1_IMR_FPDZC_WIDTH   1
#define RPU_RPU_1_IMR_FPDZC_MASK    ((u32)0X00080000U)

#define RPU_RPU_1_IMR_TCM_ASLV_CE_SHIFT   18
#define RPU_RPU_1_IMR_TCM_ASLV_CE_WIDTH   1
#define RPU_RPU_1_IMR_TCM_ASLV_CE_MASK    ((u32)0X00040000U)

#define RPU_RPU_1_IMR_TCM_ASLV_FAT_SHIFT   17
#define RPU_RPU_1_IMR_TCM_ASLV_FAT_WIDTH   1
#define RPU_RPU_1_IMR_TCM_ASLV_FAT_MASK    ((u32)0X00020000U)

#define RPU_RPU_1_IMR_TCM_LST_CE_SHIFT   16
#define RPU_RPU_1_IMR_TCM_LST_CE_WIDTH   1
#define RPU_RPU_1_IMR_TCM_LST_CE_MASK    ((u32)0X00010000U)

#define RPU_RPU_1_IMR_TCM_PREFETCH_CE_SHIFT   15
#define RPU_RPU_1_IMR_TCM_PREFETCH_CE_WIDTH   1
#define RPU_RPU_1_IMR_TCM_PREFETCH_CE_MASK    ((u32)0X00008000U)

#define RPU_RPU_1_IMR_B1TCM_CE_SHIFT   14
#define RPU_RPU_1_IMR_B1TCM_CE_WIDTH   1
#define RPU_RPU_1_IMR_B1TCM_CE_MASK    ((u32)0X00004000U)

#define RPU_RPU_1_IMR_B0TCM_CE_SHIFT   13
#define RPU_RPU_1_IMR_B0TCM_CE_WIDTH   1
#define RPU_RPU_1_IMR_B0TCM_CE_MASK    ((u32)0X00002000U)

#define RPU_RPU_1_IMR_ATCM_CE_SHIFT   12
#define RPU_RPU_1_IMR_ATCM_CE_WIDTH   1
#define RPU_RPU_1_IMR_ATCM_CE_MASK    ((u32)0X00001000U)

#define RPU_RPU_1_IMR_B1TCM_UE_SHIFT   11
#define RPU_RPU_1_IMR_B1TCM_UE_WIDTH   1
#define RPU_RPU_1_IMR_B1TCM_UE_MASK    ((u32)0X00000800U)

#define RPU_RPU_1_IMR_B0TCM_UE_SHIFT   10
#define RPU_RPU_1_IMR_B0TCM_UE_WIDTH   1
#define RPU_RPU_1_IMR_B0TCM_UE_MASK    ((u32)0X00000400U)

#define RPU_RPU_1_IMR_ATCM_UE_SHIFT   9
#define RPU_RPU_1_IMR_ATCM_UE_WIDTH   1
#define RPU_RPU_1_IMR_ATCM_UE_MASK    ((u32)0X00000200U)

#define RPU_RPU_1_IMR_DTAG_DIRTY_FAT_SHIFT   8
#define RPU_RPU_1_IMR_DTAG_DIRTY_FAT_WIDTH   1
#define RPU_RPU_1_IMR_DTAG_DIRTY_FAT_MASK    ((u32)0X00000100U)

#define RPU_RPU_1_IMR_DDATA_FAT_SHIFT   7
#define RPU_RPU_1_IMR_DDATA_FAT_WIDTH   1
#define RPU_RPU_1_IMR_DDATA_FAT_MASK    ((u32)0X00000080U)

#define RPU_RPU_1_IMR_TCM_LST_FAT_SHIFT   6
#define RPU_RPU_1_IMR_TCM_LST_FAT_WIDTH   1
#define RPU_RPU_1_IMR_TCM_LST_FAT_MASK    ((u32)0X00000040U)

#define RPU_RPU_1_IMR_TCM_PREFETCH_FAT_SHIFT   5
#define RPU_RPU_1_IMR_TCM_PREFETCH_FAT_WIDTH   1
#define RPU_RPU_1_IMR_TCM_PREFETCH_FAT_MASK    ((u32)0X00000020U)

#define RPU_RPU_1_IMR_DDATA_CE_SHIFT   4
#define RPU_RPU_1_IMR_DDATA_CE_WIDTH   1
#define RPU_RPU_1_IMR_DDATA_CE_MASK    ((u32)0X00000010U)

#define RPU_RPU_1_IMR_DTAG_DIRTY_CE_SHIFT   3
#define RPU_RPU_1_IMR_DTAG_DIRTY_CE_WIDTH   1
#define RPU_RPU_1_IMR_DTAG_DIRTY_CE_MASK    ((u32)0X00000008U)

#define RPU_RPU_1_IMR_IDATA_CE_SHIFT   2
#define RPU_RPU_1_IMR_IDATA_CE_WIDTH   1
#define RPU_RPU_1_IMR_IDATA_CE_MASK    ((u32)0X00000004U)

#define RPU_RPU_1_IMR_ITAG_CE_SHIFT   1
#define RPU_RPU_1_IMR_ITAG_CE_WIDTH   1
#define RPU_RPU_1_IMR_ITAG_CE_MASK    ((u32)0X00000002U)

#define RPU_RPU_1_IMR_APB_ERR_SHIFT   0
#define RPU_RPU_1_IMR_APB_ERR_WIDTH   1
#define RPU_RPU_1_IMR_APB_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_1_IEN
 */
#define RPU_RPU_1_IEN    ( ( RPU_BASEADDR ) + ((u32)0X0000021CU) )

#define RPU_RPU_1_IEN_FPUFC_SHIFT   24
#define RPU_RPU_1_IEN_FPUFC_WIDTH   1
#define RPU_RPU_1_IEN_FPUFC_MASK    ((u32)0X01000000U)

#define RPU_RPU_1_IEN_FPOFC_SHIFT   23
#define RPU_RPU_1_IEN_FPOFC_WIDTH   1
#define RPU_RPU_1_IEN_FPOFC_MASK    ((u32)0X00800000U)

#define RPU_RPU_1_IEN_FPIXC_SHIFT   22
#define RPU_RPU_1_IEN_FPIXC_WIDTH   1
#define RPU_RPU_1_IEN_FPIXC_MASK    ((u32)0X00400000U)

#define RPU_RPU_1_IEN_FPIOC_SHIFT   21
#define RPU_RPU_1_IEN_FPIOC_WIDTH   1
#define RPU_RPU_1_IEN_FPIOC_MASK    ((u32)0X00200000U)

#define RPU_RPU_1_IEN_FPIDC_SHIFT   20
#define RPU_RPU_1_IEN_FPIDC_WIDTH   1
#define RPU_RPU_1_IEN_FPIDC_MASK    ((u32)0X00100000U)

#define RPU_RPU_1_IEN_FPDZC_SHIFT   19
#define RPU_RPU_1_IEN_FPDZC_WIDTH   1
#define RPU_RPU_1_IEN_FPDZC_MASK    ((u32)0X00080000U)

#define RPU_RPU_1_IEN_TCM_ASLV_CE_SHIFT   18
#define RPU_RPU_1_IEN_TCM_ASLV_CE_WIDTH   1
#define RPU_RPU_1_IEN_TCM_ASLV_CE_MASK    ((u32)0X00040000U)

#define RPU_RPU_1_IEN_TCM_ASLV_FAT_SHIFT   17
#define RPU_RPU_1_IEN_TCM_ASLV_FAT_WIDTH   1
#define RPU_RPU_1_IEN_TCM_ASLV_FAT_MASK    ((u32)0X00020000U)

#define RPU_RPU_1_IEN_TCM_LST_CE_SHIFT   16
#define RPU_RPU_1_IEN_TCM_LST_CE_WIDTH   1
#define RPU_RPU_1_IEN_TCM_LST_CE_MASK    ((u32)0X00010000U)

#define RPU_RPU_1_IEN_TCM_PREFETCH_CE_SHIFT   15
#define RPU_RPU_1_IEN_TCM_PREFETCH_CE_WIDTH   1
#define RPU_RPU_1_IEN_TCM_PREFETCH_CE_MASK    ((u32)0X00008000U)

#define RPU_RPU_1_IEN_B1TCM_CE_SHIFT   14
#define RPU_RPU_1_IEN_B1TCM_CE_WIDTH   1
#define RPU_RPU_1_IEN_B1TCM_CE_MASK    ((u32)0X00004000U)

#define RPU_RPU_1_IEN_B0TCM_CE_SHIFT   13
#define RPU_RPU_1_IEN_B0TCM_CE_WIDTH   1
#define RPU_RPU_1_IEN_B0TCM_CE_MASK    ((u32)0X00002000U)

#define RPU_RPU_1_IEN_ATCM_CE_SHIFT   12
#define RPU_RPU_1_IEN_ATCM_CE_WIDTH   1
#define RPU_RPU_1_IEN_ATCM_CE_MASK    ((u32)0X00001000U)

#define RPU_RPU_1_IEN_B1TCM_UE_SHIFT   11
#define RPU_RPU_1_IEN_B1TCM_UE_WIDTH   1
#define RPU_RPU_1_IEN_B1TCM_UE_MASK    ((u32)0X00000800U)

#define RPU_RPU_1_IEN_B0TCM_UE_SHIFT   10
#define RPU_RPU_1_IEN_B0TCM_UE_WIDTH   1
#define RPU_RPU_1_IEN_B0TCM_UE_MASK    ((u32)0X00000400U)

#define RPU_RPU_1_IEN_ATCM_UE_SHIFT   9
#define RPU_RPU_1_IEN_ATCM_UE_WIDTH   1
#define RPU_RPU_1_IEN_ATCM_UE_MASK    ((u32)0X00000200U)

#define RPU_RPU_1_IEN_DTAG_DIRTY_FAT_SHIFT   8
#define RPU_RPU_1_IEN_DTAG_DIRTY_FAT_WIDTH   1
#define RPU_RPU_1_IEN_DTAG_DIRTY_FAT_MASK    ((u32)0X00000100U)

#define RPU_RPU_1_IEN_DDATA_FAT_SHIFT   7
#define RPU_RPU_1_IEN_DDATA_FAT_WIDTH   1
#define RPU_RPU_1_IEN_DDATA_FAT_MASK    ((u32)0X00000080U)

#define RPU_RPU_1_IEN_TCM_LST_FAT_SHIFT   6
#define RPU_RPU_1_IEN_TCM_LST_FAT_WIDTH   1
#define RPU_RPU_1_IEN_TCM_LST_FAT_MASK    ((u32)0X00000040U)

#define RPU_RPU_1_IEN_TCM_PREFETCH_FAT_SHIFT   5
#define RPU_RPU_1_IEN_TCM_PREFETCH_FAT_WIDTH   1
#define RPU_RPU_1_IEN_TCM_PREFETCH_FAT_MASK    ((u32)0X00000020U)

#define RPU_RPU_1_IEN_DDATA_CE_SHIFT   4
#define RPU_RPU_1_IEN_DDATA_CE_WIDTH   1
#define RPU_RPU_1_IEN_DDATA_CE_MASK    ((u32)0X00000010U)

#define RPU_RPU_1_IEN_DTAG_DIRTY_CE_SHIFT   3
#define RPU_RPU_1_IEN_DTAG_DIRTY_CE_WIDTH   1
#define RPU_RPU_1_IEN_DTAG_DIRTY_CE_MASK    ((u32)0X00000008U)

#define RPU_RPU_1_IEN_IDATA_CE_SHIFT   2
#define RPU_RPU_1_IEN_IDATA_CE_WIDTH   1
#define RPU_RPU_1_IEN_IDATA_CE_MASK    ((u32)0X00000004U)

#define RPU_RPU_1_IEN_ITAG_CE_SHIFT   1
#define RPU_RPU_1_IEN_ITAG_CE_WIDTH   1
#define RPU_RPU_1_IEN_ITAG_CE_MASK    ((u32)0X00000002U)

#define RPU_RPU_1_IEN_APB_ERR_SHIFT   0
#define RPU_RPU_1_IEN_APB_ERR_WIDTH   1
#define RPU_RPU_1_IEN_APB_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_1_IDS
 */
#define RPU_RPU_1_IDS    ( ( RPU_BASEADDR ) + ((u32)0X00000220U) )

#define RPU_RPU_1_IDS_FPUFC_SHIFT   24
#define RPU_RPU_1_IDS_FPUFC_WIDTH   1
#define RPU_RPU_1_IDS_FPUFC_MASK    ((u32)0X01000000U)

#define RPU_RPU_1_IDS_FPOFC_SHIFT   23
#define RPU_RPU_1_IDS_FPOFC_WIDTH   1
#define RPU_RPU_1_IDS_FPOFC_MASK    ((u32)0X00800000U)

#define RPU_RPU_1_IDS_FPIXC_SHIFT   22
#define RPU_RPU_1_IDS_FPIXC_WIDTH   1
#define RPU_RPU_1_IDS_FPIXC_MASK    ((u32)0X00400000U)

#define RPU_RPU_1_IDS_FPIOC_SHIFT   21
#define RPU_RPU_1_IDS_FPIOC_WIDTH   1
#define RPU_RPU_1_IDS_FPIOC_MASK    ((u32)0X00200000U)

#define RPU_RPU_1_IDS_FPIDC_SHIFT   20
#define RPU_RPU_1_IDS_FPIDC_WIDTH   1
#define RPU_RPU_1_IDS_FPIDC_MASK    ((u32)0X00100000U)

#define RPU_RPU_1_IDS_FPDZC_SHIFT   19
#define RPU_RPU_1_IDS_FPDZC_WIDTH   1
#define RPU_RPU_1_IDS_FPDZC_MASK    ((u32)0X00080000U)

#define RPU_RPU_1_IDS_TCM_ASLV_CE_SHIFT   18
#define RPU_RPU_1_IDS_TCM_ASLV_CE_WIDTH   1
#define RPU_RPU_1_IDS_TCM_ASLV_CE_MASK    ((u32)0X00040000U)

#define RPU_RPU_1_IDS_TCM_ASLV_FAT_SHIFT   17
#define RPU_RPU_1_IDS_TCM_ASLV_FAT_WIDTH   1
#define RPU_RPU_1_IDS_TCM_ASLV_FAT_MASK    ((u32)0X00020000U)

#define RPU_RPU_1_IDS_TCM_LST_CE_SHIFT   16
#define RPU_RPU_1_IDS_TCM_LST_CE_WIDTH   1
#define RPU_RPU_1_IDS_TCM_LST_CE_MASK    ((u32)0X00010000U)

#define RPU_RPU_1_IDS_TCM_PREFETCH_CE_SHIFT   15
#define RPU_RPU_1_IDS_TCM_PREFETCH_CE_WIDTH   1
#define RPU_RPU_1_IDS_TCM_PREFETCH_CE_MASK    ((u32)0X00008000U)

#define RPU_RPU_1_IDS_B1TCM_CE_SHIFT   14
#define RPU_RPU_1_IDS_B1TCM_CE_WIDTH   1
#define RPU_RPU_1_IDS_B1TCM_CE_MASK    ((u32)0X00004000U)

#define RPU_RPU_1_IDS_B0TCM_CE_SHIFT   13
#define RPU_RPU_1_IDS_B0TCM_CE_WIDTH   1
#define RPU_RPU_1_IDS_B0TCM_CE_MASK    ((u32)0X00002000U)

#define RPU_RPU_1_IDS_ATCM_CE_SHIFT   12
#define RPU_RPU_1_IDS_ATCM_CE_WIDTH   1
#define RPU_RPU_1_IDS_ATCM_CE_MASK    ((u32)0X00001000U)

#define RPU_RPU_1_IDS_B1TCM_UE_SHIFT   11
#define RPU_RPU_1_IDS_B1TCM_UE_WIDTH   1
#define RPU_RPU_1_IDS_B1TCM_UE_MASK    ((u32)0X00000800U)

#define RPU_RPU_1_IDS_B0TCM_UE_SHIFT   10
#define RPU_RPU_1_IDS_B0TCM_UE_WIDTH   1
#define RPU_RPU_1_IDS_B0TCM_UE_MASK    ((u32)0X00000400U)

#define RPU_RPU_1_IDS_ATCM_UE_SHIFT   9
#define RPU_RPU_1_IDS_ATCM_UE_WIDTH   1
#define RPU_RPU_1_IDS_ATCM_UE_MASK    ((u32)0X00000200U)

#define RPU_RPU_1_IDS_DTAG_DIRTY_FAT_SHIFT   8
#define RPU_RPU_1_IDS_DTAG_DIRTY_FAT_WIDTH   1
#define RPU_RPU_1_IDS_DTAG_DIRTY_FAT_MASK    ((u32)0X00000100U)

#define RPU_RPU_1_IDS_DDATA_FAT_SHIFT   7
#define RPU_RPU_1_IDS_DDATA_FAT_WIDTH   1
#define RPU_RPU_1_IDS_DDATA_FAT_MASK    ((u32)0X00000080U)

#define RPU_RPU_1_IDS_TCM_LST_FAT_SHIFT   6
#define RPU_RPU_1_IDS_TCM_LST_FAT_WIDTH   1
#define RPU_RPU_1_IDS_TCM_LST_FAT_MASK    ((u32)0X00000040U)

#define RPU_RPU_1_IDS_TCM_PREFETCH_FAT_SHIFT   5
#define RPU_RPU_1_IDS_TCM_PREFETCH_FAT_WIDTH   1
#define RPU_RPU_1_IDS_TCM_PREFETCH_FAT_MASK    ((u32)0X00000020U)

#define RPU_RPU_1_IDS_DDATA_CE_SHIFT   4
#define RPU_RPU_1_IDS_DDATA_CE_WIDTH   1
#define RPU_RPU_1_IDS_DDATA_CE_MASK    ((u32)0X00000010U)

#define RPU_RPU_1_IDS_DTAG_DIRTY_CE_SHIFT   3
#define RPU_RPU_1_IDS_DTAG_DIRTY_CE_WIDTH   1
#define RPU_RPU_1_IDS_DTAG_DIRTY_CE_MASK    ((u32)0X00000008U)

#define RPU_RPU_1_IDS_IDATA_CE_SHIFT   2
#define RPU_RPU_1_IDS_IDATA_CE_WIDTH   1
#define RPU_RPU_1_IDS_IDATA_CE_MASK    ((u32)0X00000004U)

#define RPU_RPU_1_IDS_ITAG_CE_SHIFT   1
#define RPU_RPU_1_IDS_ITAG_CE_WIDTH   1
#define RPU_RPU_1_IDS_ITAG_CE_MASK    ((u32)0X00000002U)

#define RPU_RPU_1_IDS_APB_ERR_SHIFT   0
#define RPU_RPU_1_IDS_APB_ERR_WIDTH   1
#define RPU_RPU_1_IDS_APB_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: RPU_RPU_1_SLV_BASE
 */
#define RPU_RPU_1_SLV_BASE    ( ( RPU_BASEADDR ) + ((u32)0X00000224U) )

#define RPU_RPU_1_SLV_BASE_ADDR_SHIFT   0
#define RPU_RPU_1_SLV_BASE_ADDR_WIDTH   8
#define RPU_RPU_1_SLV_BASE_ADDR_MASK    ((u32)0X000000FFU)

/**
 * Register: RPU_RPU_1_AXI_OVER
 */
#define RPU_RPU_1_AXI_OVER    ( ( RPU_BASEADDR ) + ((u32)0X00000228U) )

#define RPU_RPU_1_AXI_OVER_AWCACHE_SHIFT   6
#define RPU_RPU_1_AXI_OVER_AWCACHE_WIDTH   4
#define RPU_RPU_1_AXI_OVER_AWCACHE_MASK    ((u32)0X000003C0U)

#define RPU_RPU_1_AXI_OVER_ARCACHE_SHIFT   2
#define RPU_RPU_1_AXI_OVER_ARCACHE_WIDTH   4
#define RPU_RPU_1_AXI_OVER_ARCACHE_MASK    ((u32)0X0000003CU)

#define RPU_RPU_1_AXI_OVER_AWCACHE_EN_SHIFT   1
#define RPU_RPU_1_AXI_OVER_AWCACHE_EN_WIDTH   1
#define RPU_RPU_1_AXI_OVER_AWCACHE_EN_MASK    ((u32)0X00000002U)

#define RPU_RPU_1_AXI_OVER_ARCACHE_EN_SHIFT   0
#define RPU_RPU_1_AXI_OVER_ARCACHE_EN_WIDTH   1
#define RPU_RPU_1_AXI_OVER_ARCACHE_EN_MASK    ((u32)0X00000001U)

#ifdef __cplusplus
}
#endif


#endif /* _RPU_H_ */
