/******************************************************************************
* Copyright (c) 2015 - 2020 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

#ifndef PMU_GLOBAL_H_
#define PMU_GLOBAL_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * PMU_GLOBAL Base Address
 */
#define PMU_GLOBAL_BASEADDR      ((u32)0XFFD80000U)

/**
 * Register: PMU_GLOBAL_GLOBAL_CNTRL
 */
#define PMU_GLOBAL_GLOBAL_CNTRL    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000000U) )

#define PMU_GLOBAL_GLOBAL_CNTRL_MB_SLEEP_SHIFT   16
#define PMU_GLOBAL_GLOBAL_CNTRL_MB_SLEEP_WIDTH   1
#define PMU_GLOBAL_GLOBAL_CNTRL_MB_SLEEP_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_GLOBAL_CNTRL_WRITE_QOS_SHIFT   12
#define PMU_GLOBAL_GLOBAL_CNTRL_WRITE_QOS_WIDTH   4
#define PMU_GLOBAL_GLOBAL_CNTRL_WRITE_QOS_MASK    ((u32)0X0000F000U)

#define PMU_GLOBAL_GLOBAL_CNTRL_READ_QOS_SHIFT   8
#define PMU_GLOBAL_GLOBAL_CNTRL_READ_QOS_WIDTH   4
#define PMU_GLOBAL_GLOBAL_CNTRL_READ_QOS_MASK    ((u32)0X00000F00U)

#define PMU_GLOBAL_GLOBAL_CNTRL_FW_IS_PRESENT_SHIFT   4
#define PMU_GLOBAL_GLOBAL_CNTRL_FW_IS_PRESENT_WIDTH   1
#define PMU_GLOBAL_GLOBAL_CNTRL_FW_IS_PRESENT_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_GLOBAL_CNTRL_COHERENT_SHIFT   2
#define PMU_GLOBAL_GLOBAL_CNTRL_COHERENT_WIDTH   1
#define PMU_GLOBAL_GLOBAL_CNTRL_COHERENT_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_GLOBAL_CNTRL_SLVERR_ENABLE_SHIFT   1
#define PMU_GLOBAL_GLOBAL_CNTRL_SLVERR_ENABLE_WIDTH   1
#define PMU_GLOBAL_GLOBAL_CNTRL_SLVERR_ENABLE_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_GLOBAL_CNTRL_DONT_SLEEP_SHIFT   0
#define PMU_GLOBAL_GLOBAL_CNTRL_DONT_SLEEP_WIDTH   1
#define PMU_GLOBAL_GLOBAL_CNTRL_DONT_SLEEP_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_PS_CNTRL
 */
#define PMU_GLOBAL_PS_CNTRL    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000004U) )

#define PMU_GLOBAL_PS_CNTRL_PROG_GATE_STATUS_SHIFT   16
#define PMU_GLOBAL_PS_CNTRL_PROG_GATE_STATUS_WIDTH   1
#define PMU_GLOBAL_PS_CNTRL_PROG_GATE_STATUS_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_PS_CNTRL_PROG_ENABLE_SHIFT   1
#define PMU_GLOBAL_PS_CNTRL_PROG_ENABLE_WIDTH   1
#define PMU_GLOBAL_PS_CNTRL_PROG_ENABLE_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_PS_CNTRL_PROG_GATE_SHIFT   0
#define PMU_GLOBAL_PS_CNTRL_PROG_GATE_WIDTH   1
#define PMU_GLOBAL_PS_CNTRL_PROG_GATE_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_APU_PWR_STATUS_INIT
 */
#define PMU_GLOBAL_APU_PWR_STATUS_INIT    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000008U) )

#define PMU_GLOBAL_APU_PWR_STATUS_INIT_ACPU3_SHIFT   3
#define PMU_GLOBAL_APU_PWR_STATUS_INIT_ACPU3_WIDTH   1
#define PMU_GLOBAL_APU_PWR_STATUS_INIT_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_APU_PWR_STATUS_INIT_ACPU2_SHIFT   2
#define PMU_GLOBAL_APU_PWR_STATUS_INIT_ACPU2_WIDTH   1
#define PMU_GLOBAL_APU_PWR_STATUS_INIT_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_APU_PWR_STATUS_INIT_ACPU1_SHIFT   1
#define PMU_GLOBAL_APU_PWR_STATUS_INIT_ACPU1_WIDTH   1
#define PMU_GLOBAL_APU_PWR_STATUS_INIT_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_APU_PWR_STATUS_INIT_ACPU0_SHIFT   0
#define PMU_GLOBAL_APU_PWR_STATUS_INIT_ACPU0_WIDTH   1
#define PMU_GLOBAL_APU_PWR_STATUS_INIT_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_MEM_CNTRL
 */
#define PMU_GLOBAL_MEM_CNTRL    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000000CU) )

#define PMU_GLOBAL_MEM_CNTRL_ROM1_KEN_SHIFT   23
#define PMU_GLOBAL_MEM_CNTRL_ROM1_KEN_WIDTH   1
#define PMU_GLOBAL_MEM_CNTRL_ROM1_KEN_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_MEM_CNTRL_ROM1_EMA_SHIFT   20
#define PMU_GLOBAL_MEM_CNTRL_ROM1_EMA_WIDTH   3
#define PMU_GLOBAL_MEM_CNTRL_ROM1_EMA_MASK    ((u32)0X00700000U)

#define PMU_GLOBAL_MEM_CNTRL_ROM0_KEN_SHIFT   19
#define PMU_GLOBAL_MEM_CNTRL_ROM0_KEN_WIDTH   1
#define PMU_GLOBAL_MEM_CNTRL_ROM0_KEN_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_MEM_CNTRL_ROM0_EMA_SHIFT   16
#define PMU_GLOBAL_MEM_CNTRL_ROM0_EMA_WIDTH   3
#define PMU_GLOBAL_MEM_CNTRL_ROM0_EMA_MASK    ((u32)0X00070000U)

#define PMU_GLOBAL_MEM_CNTRL_ECC_RAM_EMAS_SHIFT   11
#define PMU_GLOBAL_MEM_CNTRL_ECC_RAM_EMAS_WIDTH   1
#define PMU_GLOBAL_MEM_CNTRL_ECC_RAM_EMAS_MASK    ((u32)0X00000800U)

#define PMU_GLOBAL_MEM_CNTRL_ECC_RAM_EMAW_SHIFT   9
#define PMU_GLOBAL_MEM_CNTRL_ECC_RAM_EMAW_WIDTH   2
#define PMU_GLOBAL_MEM_CNTRL_ECC_RAM_EMAW_MASK    ((u32)0X00000600U)

#define PMU_GLOBAL_MEM_CNTRL_ECC_RAM_EMA_SHIFT   6
#define PMU_GLOBAL_MEM_CNTRL_ECC_RAM_EMA_WIDTH   3
#define PMU_GLOBAL_MEM_CNTRL_ECC_RAM_EMA_MASK    ((u32)0X000001C0U)

#define PMU_GLOBAL_MEM_CNTRL_DATA_RAM_EMAS_SHIFT   5
#define PMU_GLOBAL_MEM_CNTRL_DATA_RAM_EMAS_WIDTH   1
#define PMU_GLOBAL_MEM_CNTRL_DATA_RAM_EMAS_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_MEM_CNTRL_DATA_RAM_EMAW_SHIFT   3
#define PMU_GLOBAL_MEM_CNTRL_DATA_RAM_EMAW_WIDTH   2
#define PMU_GLOBAL_MEM_CNTRL_DATA_RAM_EMAW_MASK    ((u32)0X00000018U)

#define PMU_GLOBAL_MEM_CNTRL_DATA_RAM_EMA_SHIFT   0
#define PMU_GLOBAL_MEM_CNTRL_DATA_RAM_EMA_WIDTH   3
#define PMU_GLOBAL_MEM_CNTRL_DATA_RAM_EMA_MASK    ((u32)0X00000007U)

/**
 * Register: PMU_GLOBAL_ADDR_ERROR_STATUS
 */
#define PMU_GLOBAL_ADDR_ERROR_STATUS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000010U) )

#define PMU_GLOBAL_ADDR_ERROR_STATUS_STATUS_SHIFT   0
#define PMU_GLOBAL_ADDR_ERROR_STATUS_STATUS_WIDTH   1
#define PMU_GLOBAL_ADDR_ERROR_STATUS_STATUS_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ADDR_ERROR_INT_MASK
 */
#define PMU_GLOBAL_ADDR_ERROR_INT_MASK    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000014U) )

#define PMU_GLOBAL_ADDR_ERROR_INT_MASK_MASK_SHIFT   0
#define PMU_GLOBAL_ADDR_ERROR_INT_MASK_MASK_WIDTH   1
#define PMU_GLOBAL_ADDR_ERROR_INT_MASK_MASK_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ADDR_ERROR_INT_EN
 */
#define PMU_GLOBAL_ADDR_ERROR_INT_EN    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000018U) )

#define PMU_GLOBAL_ADDR_ERROR_INT_EN_ENABLE_SHIFT   0
#define PMU_GLOBAL_ADDR_ERROR_INT_EN_ENABLE_WIDTH   1
#define PMU_GLOBAL_ADDR_ERROR_INT_EN_ENABLE_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ADDR_ERROR_INT_DIS
 */
#define PMU_GLOBAL_ADDR_ERROR_INT_DIS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000001CU) )

#define PMU_GLOBAL_ADDR_ERROR_INT_DIS_DISABLE_SHIFT   0
#define PMU_GLOBAL_ADDR_ERROR_INT_DIS_DISABLE_WIDTH   1
#define PMU_GLOBAL_ADDR_ERROR_INT_DIS_DISABLE_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_GLOBAL_GEN_STORAGE0
 */
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE0    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000030U) )

#define PMU_GLOBAL_GLOBAL_GEN_STORAGE0_REG_SHIFT   0
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE0_REG_WIDTH   32
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE0_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_GLOBAL_GEN_STORAGE1
 */
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000034U) )

#define PMU_GLOBAL_GLOBAL_GEN_STORAGE1_REG_SHIFT   0
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE1_REG_WIDTH   32
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE1_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_GLOBAL_GEN_STORAGE2
 */
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000038U) )

#define PMU_GLOBAL_GLOBAL_GEN_STORAGE2_REG_SHIFT   0
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE2_REG_WIDTH   32
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE2_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_GLOBAL_GEN_STORAGE3
 */
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE3    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000003CU) )

#define PMU_GLOBAL_GLOBAL_GEN_STORAGE3_REG_SHIFT   0
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE3_REG_WIDTH   32
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE3_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_GLOBAL_GEN_STORAGE4
 */
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE4    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000040U) )

#define PMU_GLOBAL_GLOBAL_GEN_STORAGE4_REG_SHIFT   0
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE4_REG_WIDTH   32
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE4_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_GLOBAL_GEN_STORAGE5
 */
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE5    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000044U) )

#define PMU_GLOBAL_GLOBAL_GEN_STORAGE5_REG_SHIFT   0
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE5_REG_WIDTH   32
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE5_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_GLOBAL_GEN_STORAGE6
 */
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE6    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000048U) )

#define PMU_GLOBAL_GLOBAL_GEN_STORAGE6_REG_SHIFT   0
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE6_REG_WIDTH   32
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE6_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_GLOBAL_GEN_STORAGE7
 */
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE7    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000004CU) )

#define PMU_GLOBAL_GLOBAL_GEN_STORAGE7_REG_SHIFT   0
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE7_REG_WIDTH   32
#define PMU_GLOBAL_GLOBAL_GEN_STORAGE7_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_PERS_GLOB_GEN_STORAGE0
 */
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE0    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000050U) )

#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE0_REG_SHIFT   0
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE0_REG_WIDTH   32
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE0_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_PERS_GLOB_GEN_STORAGE1
 */
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000054U) )

#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE1_REG_SHIFT   0
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE1_REG_WIDTH   32
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE1_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_PERS_GLOB_GEN_STORAGE2
 */
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000058U) )

#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE2_REG_SHIFT   0
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE2_REG_WIDTH   32
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE2_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_PERS_GLOB_GEN_STORAGE3
 */
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE3    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000005CU) )

#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE3_REG_SHIFT   0
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE3_REG_WIDTH   32
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE3_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_PERS_GLOB_GEN_STORAGE4
 */
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE4    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000060U) )

#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE4_REG_SHIFT   0
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE4_REG_WIDTH   32
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE4_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_PERS_GLOB_GEN_STORAGE5
 */
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE5    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000064U) )

#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE5_REG_SHIFT   0
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE5_REG_WIDTH   32
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE5_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_PERS_GLOB_GEN_STORAGE6
 */
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE6    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000068U) )

#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE6_REG_SHIFT   0
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE6_REG_WIDTH   32
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE6_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_PERS_GLOB_GEN_STORAGE7
 */
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE7    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000006CU) )

#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE7_REG_SHIFT   0
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE7_REG_WIDTH   32
#define PMU_GLOBAL_PERS_GLOB_GEN_STORAGE7_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_DDR_CNTRL
 */
#define PMU_GLOBAL_DDR_CNTRL    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000070U) )

#define PMU_GLOBAL_DDR_CNTRL_RET_SHIFT   0
#define PMU_GLOBAL_DDR_CNTRL_RET_WIDTH   1
#define PMU_GLOBAL_DDR_CNTRL_RET_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_PWR_STATE
 */
#define PMU_GLOBAL_PWR_STATE    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000100U) )

#define PMU_GLOBAL_PWR_STATE_PL_SHIFT   23
#define PMU_GLOBAL_PWR_STATE_PL_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_PL_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_PWR_STATE_FP_SHIFT   22
#define PMU_GLOBAL_PWR_STATE_FP_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_FP_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_PWR_STATE_USB1_SHIFT   21
#define PMU_GLOBAL_PWR_STATE_USB1_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_USB1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_PWR_STATE_USB0_SHIFT   20
#define PMU_GLOBAL_PWR_STATE_USB0_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_USB0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_PWR_STATE_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_PWR_STATE_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_PWR_STATE_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_PWR_STATE_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_PWR_STATE_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_PWR_STATE_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_PWR_STATE_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_PWR_STATE_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_PWR_STATE_TCM1B_SHIFT   15
#define PMU_GLOBAL_PWR_STATE_TCM1B_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_PWR_STATE_TCM1A_SHIFT   14
#define PMU_GLOBAL_PWR_STATE_TCM1A_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_PWR_STATE_TCM0B_SHIFT   13
#define PMU_GLOBAL_PWR_STATE_TCM0B_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_PWR_STATE_TCM0A_SHIFT   12
#define PMU_GLOBAL_PWR_STATE_TCM0A_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_PWR_STATE_R5_1_SHIFT   11
#define PMU_GLOBAL_PWR_STATE_R5_1_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_R5_1_MASK    ((u32)0X00000800U)

#define PMU_GLOBAL_PWR_STATE_R5_0_SHIFT   10
#define PMU_GLOBAL_PWR_STATE_R5_0_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_R5_0_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_PWR_STATE_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_PWR_STATE_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_L2_BANK0_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_PWR_STATE_PP1_SHIFT   5
#define PMU_GLOBAL_PWR_STATE_PP1_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_PP1_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_PWR_STATE_PP0_SHIFT   4
#define PMU_GLOBAL_PWR_STATE_PP0_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_PP0_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_PWR_STATE_ACPU3_SHIFT   3
#define PMU_GLOBAL_PWR_STATE_ACPU3_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_PWR_STATE_ACPU2_SHIFT   2
#define PMU_GLOBAL_PWR_STATE_ACPU2_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_PWR_STATE_ACPU1_SHIFT   1
#define PMU_GLOBAL_PWR_STATE_ACPU1_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_PWR_STATE_ACPU0_SHIFT   0
#define PMU_GLOBAL_PWR_STATE_ACPU0_WIDTH   1
#define PMU_GLOBAL_PWR_STATE_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_AUX_PWR_STATE
 */
#define PMU_GLOBAL_AUX_PWR_STATE    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000104U) )

#define PMU_GLOBAL_AUX_PWR_STATE_ACPU3_EMULATION_SHIFT   31
#define PMU_GLOBAL_AUX_PWR_STATE_ACPU3_EMULATION_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_ACPU3_EMULATION_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_AUX_PWR_STATE_ACPU2_EMULATION_SHIFT   30
#define PMU_GLOBAL_AUX_PWR_STATE_ACPU2_EMULATION_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_ACPU2_EMULATION_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_AUX_PWR_STATE_ACPU1_EMULATION_SHIFT   29
#define PMU_GLOBAL_AUX_PWR_STATE_ACPU1_EMULATION_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_ACPU1_EMULATION_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_AUX_PWR_STATE_ACPU0_EMULATION_SHIFT   28
#define PMU_GLOBAL_AUX_PWR_STATE_ACPU0_EMULATION_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_ACPU0_EMULATION_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_AUX_PWR_STATE_RPU_EMULATION_SHIFT   27
#define PMU_GLOBAL_AUX_PWR_STATE_RPU_EMULATION_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_RPU_EMULATION_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_AUX_PWR_STATE_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_AUX_PWR_STATE_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_AUX_PWR_STATE_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_AUX_PWR_STATE_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_AUX_PWR_STATE_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_AUX_PWR_STATE_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_AUX_PWR_STATE_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_AUX_PWR_STATE_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_AUX_PWR_STATE_TCM1B_SHIFT   15
#define PMU_GLOBAL_AUX_PWR_STATE_TCM1B_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_AUX_PWR_STATE_TCM1A_SHIFT   14
#define PMU_GLOBAL_AUX_PWR_STATE_TCM1A_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_AUX_PWR_STATE_TCM0B_SHIFT   13
#define PMU_GLOBAL_AUX_PWR_STATE_TCM0B_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_AUX_PWR_STATE_TCM0A_SHIFT   12
#define PMU_GLOBAL_AUX_PWR_STATE_TCM0A_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_AUX_PWR_STATE_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_AUX_PWR_STATE_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_AUX_PWR_STATE_L2_BANK0_MASK    ((u32)0X00000080U)

/**
 * Register: PMU_GLOBAL_RAM_RET_CNTRL
 */
#define PMU_GLOBAL_RAM_RET_CNTRL    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000108U) )

#define PMU_GLOBAL_RAM_RET_CNTRL_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_RAM_RET_CNTRL_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_RAM_RET_CNTRL_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_RAM_RET_CNTRL_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_RAM_RET_CNTRL_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_RAM_RET_CNTRL_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_RAM_RET_CNTRL_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_RAM_RET_CNTRL_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_RAM_RET_CNTRL_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_RAM_RET_CNTRL_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_RAM_RET_CNTRL_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_RAM_RET_CNTRL_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_RAM_RET_CNTRL_TCM1B_SHIFT   15
#define PMU_GLOBAL_RAM_RET_CNTRL_TCM1B_WIDTH   1
#define PMU_GLOBAL_RAM_RET_CNTRL_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_RAM_RET_CNTRL_TCM1A_SHIFT   14
#define PMU_GLOBAL_RAM_RET_CNTRL_TCM1A_WIDTH   1
#define PMU_GLOBAL_RAM_RET_CNTRL_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_RAM_RET_CNTRL_TCM0B_SHIFT   13
#define PMU_GLOBAL_RAM_RET_CNTRL_TCM0B_WIDTH   1
#define PMU_GLOBAL_RAM_RET_CNTRL_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_RAM_RET_CNTRL_TCM0A_SHIFT   12
#define PMU_GLOBAL_RAM_RET_CNTRL_TCM0A_WIDTH   1
#define PMU_GLOBAL_RAM_RET_CNTRL_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_RAM_RET_CNTRL_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_RAM_RET_CNTRL_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_RAM_RET_CNTRL_L2_BANK0_MASK    ((u32)0X00000080U)

/**
 * Register: PMU_GLOBAL_PWR_SUPPLY_STATUS
 */
#define PMU_GLOBAL_PWR_SUPPLY_STATUS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000010CU) )

#define PMU_GLOBAL_PWR_SUPPLY_STATUS_VCC_PSAUX_SHIFT   2
#define PMU_GLOBAL_PWR_SUPPLY_STATUS_VCC_PSAUX_WIDTH   1
#define PMU_GLOBAL_PWR_SUPPLY_STATUS_VCC_PSAUX_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_PWR_SUPPLY_STATUS_VCC_INT_SHIFT   1
#define PMU_GLOBAL_PWR_SUPPLY_STATUS_VCC_INT_WIDTH   1
#define PMU_GLOBAL_PWR_SUPPLY_STATUS_VCC_INT_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_PWR_SUPPLY_STATUS_VCC_PSINTFP_SHIFT   0
#define PMU_GLOBAL_PWR_SUPPLY_STATUS_VCC_PSINTFP_WIDTH   1
#define PMU_GLOBAL_PWR_SUPPLY_STATUS_VCC_PSINTFP_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_PWRUP_STATUS
 */
#define PMU_GLOBAL_REQ_PWRUP_STATUS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000110U) )

#define PMU_GLOBAL_REQ_PWRUP_STATUS_PL_SHIFT   23
#define PMU_GLOBAL_REQ_PWRUP_STATUS_PL_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_PL_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_FP_SHIFT   22
#define PMU_GLOBAL_REQ_PWRUP_STATUS_FP_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_FP_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_USB1_SHIFT   21
#define PMU_GLOBAL_REQ_PWRUP_STATUS_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_USB1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_USB0_SHIFT   20
#define PMU_GLOBAL_REQ_PWRUP_STATUS_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_USB0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_REQ_PWRUP_STATUS_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_REQ_PWRUP_STATUS_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_REQ_PWRUP_STATUS_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_REQ_PWRUP_STATUS_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_TCM1B_SHIFT   15
#define PMU_GLOBAL_REQ_PWRUP_STATUS_TCM1B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_TCM1A_SHIFT   14
#define PMU_GLOBAL_REQ_PWRUP_STATUS_TCM1A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_TCM0B_SHIFT   13
#define PMU_GLOBAL_REQ_PWRUP_STATUS_TCM0B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_TCM0A_SHIFT   12
#define PMU_GLOBAL_REQ_PWRUP_STATUS_TCM0A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_PWRUP_STATUS_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_REQ_PWRUP_STATUS_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_L2_BANK0_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_PP1_SHIFT   5
#define PMU_GLOBAL_REQ_PWRUP_STATUS_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_PP1_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_PP0_SHIFT   4
#define PMU_GLOBAL_REQ_PWRUP_STATUS_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_PP0_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_PWRUP_STATUS_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_PWRUP_STATUS_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_PWRUP_STATUS_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_PWRUP_STATUS_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_STATUS_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_PWRUP_INT_MASK
 */
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000114U) )

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_PL_SHIFT   23
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_PL_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_PL_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_FP_SHIFT   22
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_FP_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_FP_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_USB1_SHIFT   21
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_USB1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_USB0_SHIFT   20
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_USB0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_TCM1B_SHIFT   15
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_TCM1B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_TCM1A_SHIFT   14
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_TCM1A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_TCM0B_SHIFT   13
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_TCM0B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_TCM0A_SHIFT   12
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_TCM0A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_L2_BANK0_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_PP1_SHIFT   5
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_PP1_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_PP0_SHIFT   4
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_PP0_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_MASK_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_PWRUP_INT_EN
 */
#define PMU_GLOBAL_REQ_PWRUP_INT_EN    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000118U) )

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_PL_SHIFT   23
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_PL_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_PL_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_FP_SHIFT   22
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_FP_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_FP_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_USB1_SHIFT   21
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_USB1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_USB0_SHIFT   20
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_USB0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_TCM1B_SHIFT   15
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_TCM1B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_TCM1A_SHIFT   14
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_TCM1A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_TCM0B_SHIFT   13
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_TCM0B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_TCM0A_SHIFT   12
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_TCM0A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_L2_BANK0_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_PP1_SHIFT   5
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_PP1_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_PP0_SHIFT   4
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_PP0_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_PWRUP_INT_EN_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_EN_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_PWRUP_INT_DIS
 */
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000011CU) )

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_PL_SHIFT   23
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_PL_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_PL_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_FP_SHIFT   22
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_FP_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_FP_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_USB1_SHIFT   21
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_USB1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_USB0_SHIFT   20
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_USB0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_TCM1B_SHIFT   15
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_TCM1B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_TCM1A_SHIFT   14
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_TCM1A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_TCM0B_SHIFT   13
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_TCM0B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_TCM0A_SHIFT   12
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_TCM0A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_L2_BANK0_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_PP1_SHIFT   5
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_PP1_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_PP0_SHIFT   4
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_PP0_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_INT_DIS_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_PWRUP_TRIG
 */
#define PMU_GLOBAL_REQ_PWRUP_TRIG    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000120U) )

#define PMU_GLOBAL_REQ_PWRUP_TRIG_PL_SHIFT   23
#define PMU_GLOBAL_REQ_PWRUP_TRIG_PL_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_PL_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_FP_SHIFT   22
#define PMU_GLOBAL_REQ_PWRUP_TRIG_FP_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_FP_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_USB1_SHIFT   21
#define PMU_GLOBAL_REQ_PWRUP_TRIG_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_USB1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_USB0_SHIFT   20
#define PMU_GLOBAL_REQ_PWRUP_TRIG_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_USB0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_REQ_PWRUP_TRIG_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_REQ_PWRUP_TRIG_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_REQ_PWRUP_TRIG_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_REQ_PWRUP_TRIG_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_TCM1B_SHIFT   15
#define PMU_GLOBAL_REQ_PWRUP_TRIG_TCM1B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_TCM1A_SHIFT   14
#define PMU_GLOBAL_REQ_PWRUP_TRIG_TCM1A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_TCM0B_SHIFT   13
#define PMU_GLOBAL_REQ_PWRUP_TRIG_TCM0B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_TCM0A_SHIFT   12
#define PMU_GLOBAL_REQ_PWRUP_TRIG_TCM0A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_PWRUP_TRIG_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_REQ_PWRUP_TRIG_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_L2_BANK0_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_PP1_SHIFT   5
#define PMU_GLOBAL_REQ_PWRUP_TRIG_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_PP1_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_PP0_SHIFT   4
#define PMU_GLOBAL_REQ_PWRUP_TRIG_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_PP0_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_PWRUP_TRIG_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_PWRUP_TRIG_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_PWRUP_TRIG_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_PWRUP_TRIG_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRUP_TRIG_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_PWRDWN_STATUS
 */
#define PMU_GLOBAL_REQ_PWRDWN_STATUS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000210U) )

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_PL_SHIFT   23
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_PL_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_PL_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_FP_SHIFT   22
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_FP_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_FP_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_USB1_SHIFT   21
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_USB1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_USB0_SHIFT   20
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_USB0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_TCM1B_SHIFT   15
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_TCM1B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_TCM1A_SHIFT   14
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_TCM1A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_TCM0B_SHIFT   13
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_TCM0B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_TCM0A_SHIFT   12
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_TCM0A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_L2_BANK0_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_PP1_SHIFT   5
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_PP1_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_PP0_SHIFT   4
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_PP0_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_PWRDWN_STATUS_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_STATUS_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_PWRDWN_INT_MASK
 */
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000214U) )

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_PL_SHIFT   23
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_PL_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_PL_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_FP_SHIFT   22
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_FP_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_FP_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_USB1_SHIFT   21
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_USB1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_USB0_SHIFT   20
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_USB0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_TCM1B_SHIFT   15
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_TCM1B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_TCM1A_SHIFT   14
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_TCM1A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_TCM0B_SHIFT   13
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_TCM0B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_TCM0A_SHIFT   12
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_TCM0A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_L2_BANK0_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_PP1_SHIFT   5
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_PP1_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_PP0_SHIFT   4
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_PP0_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_MASK_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_PWRDWN_INT_EN
 */
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000218U) )

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_PL_SHIFT   23
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_PL_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_PL_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_FP_SHIFT   22
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_FP_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_FP_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_USB1_SHIFT   21
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_USB1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_USB0_SHIFT   20
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_USB0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_TCM1B_SHIFT   15
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_TCM1B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_TCM1A_SHIFT   14
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_TCM1A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_TCM0B_SHIFT   13
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_TCM0B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_TCM0A_SHIFT   12
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_TCM0A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_L2_BANK0_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_PP1_SHIFT   5
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_PP1_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_PP0_SHIFT   4
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_PP0_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_EN_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_PWRDWN_INT_DIS
 */
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000021CU) )

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_PL_SHIFT   23
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_PL_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_PL_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_FP_SHIFT   22
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_FP_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_FP_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_USB1_SHIFT   21
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_USB1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_USB0_SHIFT   20
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_USB0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_TCM1B_SHIFT   15
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_TCM1B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_TCM1A_SHIFT   14
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_TCM1A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_TCM0B_SHIFT   13
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_TCM0B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_TCM0A_SHIFT   12
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_TCM0A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_L2_BANK0_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_PP1_SHIFT   5
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_PP1_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_PP0_SHIFT   4
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_PP0_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_INT_DIS_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_PWRDWN_TRIG
 */
#define PMU_GLOBAL_REQ_PWRDWN_TRIG    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000220U) )

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_PL_SHIFT   23
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_PL_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_PL_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_FP_SHIFT   22
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_FP_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_FP_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_USB1_SHIFT   21
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_USB1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_USB0_SHIFT   20
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_USB0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_OCM_BANK3_SHIFT   19
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_OCM_BANK3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_OCM_BANK3_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_OCM_BANK2_SHIFT   18
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_OCM_BANK2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_OCM_BANK2_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_OCM_BANK1_SHIFT   17
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_OCM_BANK1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_OCM_BANK1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_OCM_BANK0_SHIFT   16
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_OCM_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_OCM_BANK0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_TCM1B_SHIFT   15
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_TCM1B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_TCM1B_MASK    ((u32)0X00008000U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_TCM1A_SHIFT   14
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_TCM1A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_TCM1A_MASK    ((u32)0X00004000U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_TCM0B_SHIFT   13
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_TCM0B_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_TCM0B_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_TCM0A_SHIFT   12
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_TCM0A_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_TCM0A_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_L2_BANK0_SHIFT   7
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_L2_BANK0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_L2_BANK0_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_PP1_SHIFT   5
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_PP1_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_PP0_SHIFT   4
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_PP0_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_PWRDWN_TRIG_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_PWRDWN_TRIG_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_ISO_STATUS
 */
#define PMU_GLOBAL_REQ_ISO_STATUS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000310U) )

#define PMU_GLOBAL_REQ_ISO_STATUS_FP_LOCKED_SHIFT   4
#define PMU_GLOBAL_REQ_ISO_STATUS_FP_LOCKED_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_STATUS_FP_LOCKED_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_ISO_STATUS_PL_NONPCAP_SHIFT   2
#define PMU_GLOBAL_REQ_ISO_STATUS_PL_NONPCAP_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_STATUS_PL_NONPCAP_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_ISO_STATUS_PL_SHIFT   1
#define PMU_GLOBAL_REQ_ISO_STATUS_PL_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_STATUS_PL_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_ISO_STATUS_FP_SHIFT   0
#define PMU_GLOBAL_REQ_ISO_STATUS_FP_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_STATUS_FP_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_ISO_INT_MASK
 */
#define PMU_GLOBAL_REQ_ISO_INT_MASK    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000314U) )

#define PMU_GLOBAL_REQ_ISO_INT_MASK_FP_LOCKED_SHIFT   4
#define PMU_GLOBAL_REQ_ISO_INT_MASK_FP_LOCKED_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_INT_MASK_FP_LOCKED_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_ISO_INT_MASK_PL_NONPCAP_SHIFT   2
#define PMU_GLOBAL_REQ_ISO_INT_MASK_PL_NONPCAP_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_INT_MASK_PL_NONPCAP_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_ISO_INT_MASK_PL_SHIFT   1
#define PMU_GLOBAL_REQ_ISO_INT_MASK_PL_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_INT_MASK_PL_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_ISO_INT_MASK_FP_SHIFT   0
#define PMU_GLOBAL_REQ_ISO_INT_MASK_FP_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_INT_MASK_FP_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_ISO_INT_EN
 */
#define PMU_GLOBAL_REQ_ISO_INT_EN    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000318U) )

#define PMU_GLOBAL_REQ_ISO_INT_EN_FP_LOCKED_SHIFT   4
#define PMU_GLOBAL_REQ_ISO_INT_EN_FP_LOCKED_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_INT_EN_FP_LOCKED_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_ISO_INT_EN_PL_NONPCAP_SHIFT   2
#define PMU_GLOBAL_REQ_ISO_INT_EN_PL_NONPCAP_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_INT_EN_PL_NONPCAP_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_ISO_INT_EN_PL_SHIFT   1
#define PMU_GLOBAL_REQ_ISO_INT_EN_PL_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_INT_EN_PL_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_ISO_INT_EN_FP_SHIFT   0
#define PMU_GLOBAL_REQ_ISO_INT_EN_FP_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_INT_EN_FP_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_ISO_INT_DIS
 */
#define PMU_GLOBAL_REQ_ISO_INT_DIS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000031CU) )

#define PMU_GLOBAL_REQ_ISO_INT_DIS_FP_LOCKED_SHIFT   4
#define PMU_GLOBAL_REQ_ISO_INT_DIS_FP_LOCKED_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_INT_DIS_FP_LOCKED_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_ISO_INT_DIS_PL_NONPCAP_SHIFT   2
#define PMU_GLOBAL_REQ_ISO_INT_DIS_PL_NONPCAP_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_INT_DIS_PL_NONPCAP_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_ISO_INT_DIS_PL_SHIFT   1
#define PMU_GLOBAL_REQ_ISO_INT_DIS_PL_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_INT_DIS_PL_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_ISO_INT_DIS_FP_SHIFT   0
#define PMU_GLOBAL_REQ_ISO_INT_DIS_FP_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_INT_DIS_FP_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_ISO_TRIG
 */
#define PMU_GLOBAL_REQ_ISO_TRIG    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000320U) )

#define PMU_GLOBAL_REQ_ISO_TRIG_FP_LOCKED_SHIFT   4
#define PMU_GLOBAL_REQ_ISO_TRIG_FP_LOCKED_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_TRIG_FP_LOCKED_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_ISO_TRIG_PL_NONPCAP_SHIFT   2
#define PMU_GLOBAL_REQ_ISO_TRIG_PL_NONPCAP_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_TRIG_PL_NONPCAP_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_ISO_TRIG_PL_SHIFT   1
#define PMU_GLOBAL_REQ_ISO_TRIG_PL_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_TRIG_PL_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_ISO_TRIG_FP_SHIFT   0
#define PMU_GLOBAL_REQ_ISO_TRIG_FP_WIDTH   1
#define PMU_GLOBAL_REQ_ISO_TRIG_FP_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_SWRST_STATUS
 */
#define PMU_GLOBAL_REQ_SWRST_STATUS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000410U) )

#define PMU_GLOBAL_REQ_SWRST_STATUS_PL_SHIFT   31
#define PMU_GLOBAL_REQ_SWRST_STATUS_PL_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_PL_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_FP_SHIFT   30
#define PMU_GLOBAL_REQ_SWRST_STATUS_FP_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_FP_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_LP_SHIFT   29
#define PMU_GLOBAL_REQ_SWRST_STATUS_LP_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_LP_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_PS_ONLY_SHIFT   28
#define PMU_GLOBAL_REQ_SWRST_STATUS_PS_ONLY_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_PS_ONLY_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_IOU_SHIFT   27
#define PMU_GLOBAL_REQ_SWRST_STATUS_IOU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_IOU_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_USB1_SHIFT   25
#define PMU_GLOBAL_REQ_SWRST_STATUS_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_USB1_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_USB0_SHIFT   24
#define PMU_GLOBAL_REQ_SWRST_STATUS_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_USB0_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_GEM3_SHIFT   23
#define PMU_GLOBAL_REQ_SWRST_STATUS_GEM3_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_GEM3_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_GEM2_SHIFT   22
#define PMU_GLOBAL_REQ_SWRST_STATUS_GEM2_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_GEM2_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_GEM1_SHIFT   21
#define PMU_GLOBAL_REQ_SWRST_STATUS_GEM1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_GEM1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_GEM0_SHIFT   20
#define PMU_GLOBAL_REQ_SWRST_STATUS_GEM0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_GEM0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_RPU_SHIFT   18
#define PMU_GLOBAL_REQ_SWRST_STATUS_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_RPU_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_R5_1_SHIFT   17
#define PMU_GLOBAL_REQ_SWRST_STATUS_R5_1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_R5_1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_R5_0_SHIFT   16
#define PMU_GLOBAL_REQ_SWRST_STATUS_R5_0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_R5_0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_DISPLAY_PORT_SHIFT   12
#define PMU_GLOBAL_REQ_SWRST_STATUS_DISPLAY_PORT_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_DISPLAY_PORT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_SATA_SHIFT   10
#define PMU_GLOBAL_REQ_SWRST_STATUS_SATA_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_SATA_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_PCIE_SHIFT   9
#define PMU_GLOBAL_REQ_SWRST_STATUS_PCIE_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_PCIE_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_GPU_SHIFT   8
#define PMU_GLOBAL_REQ_SWRST_STATUS_GPU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_GPU_MASK    ((u32)0X00000100U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_PP1_SHIFT   7
#define PMU_GLOBAL_REQ_SWRST_STATUS_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_PP1_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_PP0_SHIFT   6
#define PMU_GLOBAL_REQ_SWRST_STATUS_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_PP0_MASK    ((u32)0X00000040U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_APU_SHIFT   4
#define PMU_GLOBAL_REQ_SWRST_STATUS_APU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_APU_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_SWRST_STATUS_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_SWRST_STATUS_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_SWRST_STATUS_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_SWRST_STATUS_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_STATUS_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_SWRST_INT_MASK
 */
#define PMU_GLOBAL_REQ_SWRST_INT_MASK    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000414U) )

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PL_SHIFT   31
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PL_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PL_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_FP_SHIFT   30
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_FP_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_FP_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_LP_SHIFT   29
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_LP_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_LP_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PS_ONLY_SHIFT   28
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PS_ONLY_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PS_ONLY_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_IOU_SHIFT   27
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_IOU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_IOU_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_USB1_SHIFT   25
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_USB1_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_USB0_SHIFT   24
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_USB0_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GEM3_SHIFT   23
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GEM3_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GEM3_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GEM2_SHIFT   22
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GEM2_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GEM2_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GEM1_SHIFT   21
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GEM1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GEM1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GEM0_SHIFT   20
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GEM0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GEM0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_LS_R5_SHIFT   18
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_LS_R5_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_LS_R5_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_R5_1_SHIFT   17
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_R5_1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_R5_1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_R5_0_SHIFT   16
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_R5_0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_R5_0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_DISPLAY_PORT_SHIFT   12
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_DISPLAY_PORT_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_DISPLAY_PORT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_SATA_SHIFT   10
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_SATA_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_SATA_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PCIE_SHIFT   9
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PCIE_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PCIE_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GPU_SHIFT   8
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GPU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_GPU_MASK    ((u32)0X00000100U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PP1_SHIFT   7
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PP1_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PP0_SHIFT   6
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_PP0_MASK    ((u32)0X00000040U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_APU_SHIFT   4
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_APU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_APU_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_SWRST_INT_MASK_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_MASK_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_SWRST_INT_EN
 */
#define PMU_GLOBAL_REQ_SWRST_INT_EN    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000418U) )

#define PMU_GLOBAL_REQ_SWRST_INT_EN_PL_SHIFT   31
#define PMU_GLOBAL_REQ_SWRST_INT_EN_PL_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_PL_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_FP_SHIFT   30
#define PMU_GLOBAL_REQ_SWRST_INT_EN_FP_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_FP_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_LP_SHIFT   29
#define PMU_GLOBAL_REQ_SWRST_INT_EN_LP_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_LP_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_PS_ONLY_SHIFT   28
#define PMU_GLOBAL_REQ_SWRST_INT_EN_PS_ONLY_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_PS_ONLY_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_IOU_SHIFT   27
#define PMU_GLOBAL_REQ_SWRST_INT_EN_IOU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_IOU_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_USB1_SHIFT   25
#define PMU_GLOBAL_REQ_SWRST_INT_EN_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_USB1_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_USB0_SHIFT   24
#define PMU_GLOBAL_REQ_SWRST_INT_EN_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_USB0_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_GEM3_SHIFT   23
#define PMU_GLOBAL_REQ_SWRST_INT_EN_GEM3_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_GEM3_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_GEM2_SHIFT   22
#define PMU_GLOBAL_REQ_SWRST_INT_EN_GEM2_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_GEM2_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_GEM1_SHIFT   21
#define PMU_GLOBAL_REQ_SWRST_INT_EN_GEM1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_GEM1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_GEM0_SHIFT   20
#define PMU_GLOBAL_REQ_SWRST_INT_EN_GEM0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_GEM0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_LS_R5_SHIFT   18
#define PMU_GLOBAL_REQ_SWRST_INT_EN_LS_R5_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_LS_R5_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_R5_1_SHIFT   17
#define PMU_GLOBAL_REQ_SWRST_INT_EN_R5_1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_R5_1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_R5_0_SHIFT   16
#define PMU_GLOBAL_REQ_SWRST_INT_EN_R5_0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_R5_0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_DISPLAY_PORT_SHIFT   12
#define PMU_GLOBAL_REQ_SWRST_INT_EN_DISPLAY_PORT_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_DISPLAY_PORT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_SATA_SHIFT   10
#define PMU_GLOBAL_REQ_SWRST_INT_EN_SATA_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_SATA_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_PCIE_SHIFT   9
#define PMU_GLOBAL_REQ_SWRST_INT_EN_PCIE_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_PCIE_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_GPU_SHIFT   8
#define PMU_GLOBAL_REQ_SWRST_INT_EN_GPU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_GPU_MASK    ((u32)0X00000100U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_PP1_SHIFT   7
#define PMU_GLOBAL_REQ_SWRST_INT_EN_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_PP1_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_PP0_SHIFT   6
#define PMU_GLOBAL_REQ_SWRST_INT_EN_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_PP0_MASK    ((u32)0X00000040U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_APU_SHIFT   4
#define PMU_GLOBAL_REQ_SWRST_INT_EN_APU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_APU_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_SWRST_INT_EN_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_SWRST_INT_EN_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_SWRST_INT_EN_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_SWRST_INT_EN_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_EN_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_SWRST_INT_DIS
 */
#define PMU_GLOBAL_REQ_SWRST_INT_DIS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000041CU) )

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PL_SHIFT   31
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PL_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PL_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_FP_SHIFT   30
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_FP_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_FP_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_LP_SHIFT   29
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_LP_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_LP_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PS_ONLY_SHIFT   28
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PS_ONLY_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PS_ONLY_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_IOU_SHIFT   27
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_IOU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_IOU_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_USB1_SHIFT   25
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_USB1_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_USB0_SHIFT   24
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_USB0_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GEM3_SHIFT   23
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GEM3_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GEM3_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GEM2_SHIFT   22
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GEM2_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GEM2_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GEM1_SHIFT   21
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GEM1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GEM1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GEM0_SHIFT   20
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GEM0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GEM0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_LS_R5_SHIFT   18
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_LS_R5_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_LS_R5_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_R5_1_SHIFT   17
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_R5_1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_R5_1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_R5_0_SHIFT   16
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_R5_0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_R5_0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_DISPLAY_PORT_SHIFT   12
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_DISPLAY_PORT_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_DISPLAY_PORT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_SATA_SHIFT   10
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_SATA_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_SATA_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PCIE_SHIFT   9
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PCIE_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PCIE_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GPU_SHIFT   8
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GPU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_GPU_MASK    ((u32)0X00000100U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PP1_SHIFT   7
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PP1_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PP0_SHIFT   6
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_PP0_MASK    ((u32)0X00000040U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_APU_SHIFT   4
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_APU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_APU_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_SWRST_INT_DIS_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_INT_DIS_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_SWRST_TRIG
 */
#define PMU_GLOBAL_REQ_SWRST_TRIG    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000420U) )

#define PMU_GLOBAL_REQ_SWRST_TRIG_PL_SHIFT   31
#define PMU_GLOBAL_REQ_SWRST_TRIG_PL_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_PL_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_FP_SHIFT   30
#define PMU_GLOBAL_REQ_SWRST_TRIG_FP_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_FP_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_LP_SHIFT   29
#define PMU_GLOBAL_REQ_SWRST_TRIG_LP_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_LP_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_PS_ONLY_SHIFT   28
#define PMU_GLOBAL_REQ_SWRST_TRIG_PS_ONLY_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_PS_ONLY_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_IOU_SHIFT   27
#define PMU_GLOBAL_REQ_SWRST_TRIG_IOU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_IOU_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_USB1_SHIFT   25
#define PMU_GLOBAL_REQ_SWRST_TRIG_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_USB1_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_USB0_SHIFT   24
#define PMU_GLOBAL_REQ_SWRST_TRIG_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_USB0_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_GEM3_SHIFT   23
#define PMU_GLOBAL_REQ_SWRST_TRIG_GEM3_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_GEM3_MASK    ((u32)0X00800000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_GEM2_SHIFT   22
#define PMU_GLOBAL_REQ_SWRST_TRIG_GEM2_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_GEM2_MASK    ((u32)0X00400000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_GEM1_SHIFT   21
#define PMU_GLOBAL_REQ_SWRST_TRIG_GEM1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_GEM1_MASK    ((u32)0X00200000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_GEM0_SHIFT   20
#define PMU_GLOBAL_REQ_SWRST_TRIG_GEM0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_GEM0_MASK    ((u32)0X00100000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_LS_R5_SHIFT   18
#define PMU_GLOBAL_REQ_SWRST_TRIG_LS_R5_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_LS_R5_MASK    ((u32)0X00040000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_R5_1_SHIFT   17
#define PMU_GLOBAL_REQ_SWRST_TRIG_R5_1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_R5_1_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_R5_0_SHIFT   16
#define PMU_GLOBAL_REQ_SWRST_TRIG_R5_0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_R5_0_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_DISPLAY_PORT_SHIFT   12
#define PMU_GLOBAL_REQ_SWRST_TRIG_DISPLAY_PORT_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_DISPLAY_PORT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_SATA_SHIFT   10
#define PMU_GLOBAL_REQ_SWRST_TRIG_SATA_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_SATA_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_PCIE_SHIFT   9
#define PMU_GLOBAL_REQ_SWRST_TRIG_PCIE_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_PCIE_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_GPU_SHIFT   8
#define PMU_GLOBAL_REQ_SWRST_TRIG_GPU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_GPU_MASK    ((u32)0X00000100U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_PP1_SHIFT   7
#define PMU_GLOBAL_REQ_SWRST_TRIG_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_PP1_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_PP0_SHIFT   6
#define PMU_GLOBAL_REQ_SWRST_TRIG_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_PP0_MASK    ((u32)0X00000040U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_APU_SHIFT   4
#define PMU_GLOBAL_REQ_SWRST_TRIG_APU_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_APU_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_SWRST_TRIG_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_SWRST_TRIG_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_SWRST_TRIG_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_SWRST_TRIG_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_SWRST_TRIG_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_LOGCLR_STATUS
 */
#define PMU_GLOBAL_REQ_LOGCLR_STATUS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000510U) )

#define PMU_GLOBAL_REQ_LOGCLR_STATUS_FP_SHIFT   17
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_FP_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_FP_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_LOGCLR_STATUS_LP_SHIFT   16
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_LP_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_LP_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_LOGCLR_STATUS_USB1_SHIFT   13
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_USB1_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_LOGCLR_STATUS_USB0_SHIFT   12
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_USB0_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_LOGCLR_STATUS_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_LOGCLR_STATUS_PP1_SHIFT   7
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_PP1_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_LOGCLR_STATUS_PP0_SHIFT   6
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_PP0_MASK    ((u32)0X00000040U)

#define PMU_GLOBAL_REQ_LOGCLR_STATUS_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_LOGCLR_STATUS_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_LOGCLR_STATUS_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_LOGCLR_STATUS_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_STATUS_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_LOGCLR_INT_MASK
 */
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000514U) )

#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_FP_SHIFT   17
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_FP_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_FP_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_LP_SHIFT   16
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_LP_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_LP_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_USB1_SHIFT   13
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_USB1_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_USB0_SHIFT   12
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_USB0_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_PP1_SHIFT   7
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_PP1_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_PP0_SHIFT   6
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_PP0_MASK    ((u32)0X00000040U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_MASK_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_LOGCLR_INT_EN
 */
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000518U) )

#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_FP_SHIFT   17
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_FP_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_FP_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_LP_SHIFT   16
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_LP_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_LP_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_USB1_SHIFT   13
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_USB1_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_USB0_SHIFT   12
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_USB0_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_PP1_SHIFT   7
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_PP1_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_PP0_SHIFT   6
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_PP0_MASK    ((u32)0X00000040U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_EN_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_LOGCLR_INT_DIS
 */
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000051CU) )

#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_FP_SHIFT   17
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_FP_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_FP_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_LP_SHIFT   16
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_LP_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_LP_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_USB1_SHIFT   13
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_USB1_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_USB0_SHIFT   12
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_USB0_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_PP1_SHIFT   7
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_PP1_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_PP0_SHIFT   6
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_PP0_MASK    ((u32)0X00000040U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_INT_DIS_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_REQ_LOGCLR_TRIG
 */
#define PMU_GLOBAL_REQ_LOGCLR_TRIG    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000520U) )

#define PMU_GLOBAL_REQ_LOGCLR_TRIG_FP_SHIFT   17
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_FP_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_FP_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_REQ_LOGCLR_TRIG_LP_SHIFT   16
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_LP_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_LP_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_REQ_LOGCLR_TRIG_USB1_SHIFT   13
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_USB1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_USB1_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_REQ_LOGCLR_TRIG_USB0_SHIFT   12
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_USB0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_USB0_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_REQ_LOGCLR_TRIG_RPU_SHIFT   10
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_RPU_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_REQ_LOGCLR_TRIG_PP1_SHIFT   7
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_PP1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_PP1_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_REQ_LOGCLR_TRIG_PP0_SHIFT   6
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_PP0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_PP0_MASK    ((u32)0X00000040U)

#define PMU_GLOBAL_REQ_LOGCLR_TRIG_ACPU3_SHIFT   3
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_ACPU3_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_REQ_LOGCLR_TRIG_ACPU2_SHIFT   2
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_ACPU2_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_REQ_LOGCLR_TRIG_ACPU1_SHIFT   1
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_ACPU1_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_REQ_LOGCLR_TRIG_ACPU0_SHIFT   0
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_ACPU0_WIDTH   1
#define PMU_GLOBAL_REQ_LOGCLR_TRIG_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_LOGCLR_STATUS
 */
#define PMU_GLOBAL_LOGCLR_STATUS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000524U) )

#define PMU_GLOBAL_LOGCLR_STATUS_FP_SHIFT   17
#define PMU_GLOBAL_LOGCLR_STATUS_FP_WIDTH   1
#define PMU_GLOBAL_LOGCLR_STATUS_FP_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_LOGCLR_STATUS_LP_SHIFT   16
#define PMU_GLOBAL_LOGCLR_STATUS_LP_WIDTH   1
#define PMU_GLOBAL_LOGCLR_STATUS_LP_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_LOGCLR_STATUS_USB1_SHIFT   13
#define PMU_GLOBAL_LOGCLR_STATUS_USB1_WIDTH   1
#define PMU_GLOBAL_LOGCLR_STATUS_USB1_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_LOGCLR_STATUS_USB0_SHIFT   12
#define PMU_GLOBAL_LOGCLR_STATUS_USB0_WIDTH   1
#define PMU_GLOBAL_LOGCLR_STATUS_USB0_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_LOGCLR_STATUS_RPU_SHIFT   10
#define PMU_GLOBAL_LOGCLR_STATUS_RPU_WIDTH   1
#define PMU_GLOBAL_LOGCLR_STATUS_RPU_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_LOGCLR_STATUS_PP1_SHIFT   7
#define PMU_GLOBAL_LOGCLR_STATUS_PP1_WIDTH   1
#define PMU_GLOBAL_LOGCLR_STATUS_PP1_MASK    ((u32)0X00000080U)

#define PMU_GLOBAL_LOGCLR_STATUS_PP0_SHIFT   6
#define PMU_GLOBAL_LOGCLR_STATUS_PP0_WIDTH   1
#define PMU_GLOBAL_LOGCLR_STATUS_PP0_MASK    ((u32)0X00000040U)

#define PMU_GLOBAL_LOGCLR_STATUS_ACPU3_SHIFT   3
#define PMU_GLOBAL_LOGCLR_STATUS_ACPU3_WIDTH   1
#define PMU_GLOBAL_LOGCLR_STATUS_ACPU3_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_LOGCLR_STATUS_ACPU2_SHIFT   2
#define PMU_GLOBAL_LOGCLR_STATUS_ACPU2_WIDTH   1
#define PMU_GLOBAL_LOGCLR_STATUS_ACPU2_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_LOGCLR_STATUS_ACPU1_SHIFT   1
#define PMU_GLOBAL_LOGCLR_STATUS_ACPU1_WIDTH   1
#define PMU_GLOBAL_LOGCLR_STATUS_ACPU1_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_LOGCLR_STATUS_ACPU0_SHIFT   0
#define PMU_GLOBAL_LOGCLR_STATUS_ACPU0_WIDTH   1
#define PMU_GLOBAL_LOGCLR_STATUS_ACPU0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_CSU_BR_ERROR
 */
#define PMU_GLOBAL_CSU_BR_ERROR    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000528U) )

#define PMU_GLOBAL_CSU_BR_ERROR_BR_ERROR_SHIFT   31
#define PMU_GLOBAL_CSU_BR_ERROR_BR_ERROR_WIDTH   1
#define PMU_GLOBAL_CSU_BR_ERROR_BR_ERROR_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_CSU_BR_ERROR_ERR_TYPE_SHIFT   0
#define PMU_GLOBAL_CSU_BR_ERROR_ERR_TYPE_WIDTH   16
#define PMU_GLOBAL_CSU_BR_ERROR_ERR_TYPE_MASK    ((u32)0X0000FFFFU)

/**
 * Register: PMU_GLOBAL_MB_FAULT_STATUS
 */
#define PMU_GLOBAL_MB_FAULT_STATUS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000052CU) )

#define PMU_GLOBAL_MB_FAULT_STATUS_R_FFAIL_SHIFT   24
#define PMU_GLOBAL_MB_FAULT_STATUS_R_FFAIL_WIDTH   8
#define PMU_GLOBAL_MB_FAULT_STATUS_R_FFAIL_MASK    ((u32)0XFF000000U)

#define PMU_GLOBAL_MB_FAULT_STATUS_R_SLEEP_RST_SHIFT   19
#define PMU_GLOBAL_MB_FAULT_STATUS_R_SLEEP_RST_WIDTH   1
#define PMU_GLOBAL_MB_FAULT_STATUS_R_SLEEP_RST_MASK    ((u32)0X00080000U)

#define PMU_GLOBAL_MB_FAULT_STATUS_R_LSFAIL_SHIFT   16
#define PMU_GLOBAL_MB_FAULT_STATUS_R_LSFAIL_WIDTH   3
#define PMU_GLOBAL_MB_FAULT_STATUS_R_LSFAIL_MASK    ((u32)0X00070000U)

#define PMU_GLOBAL_MB_FAULT_STATUS_N_FFAIL_SHIFT   8
#define PMU_GLOBAL_MB_FAULT_STATUS_N_FFAIL_WIDTH   8
#define PMU_GLOBAL_MB_FAULT_STATUS_N_FFAIL_MASK    ((u32)0X0000FF00U)

#define PMU_GLOBAL_MB_FAULT_STATUS_N_SLEEP_RST_SHIFT   3
#define PMU_GLOBAL_MB_FAULT_STATUS_N_SLEEP_RST_WIDTH   1
#define PMU_GLOBAL_MB_FAULT_STATUS_N_SLEEP_RST_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_MB_FAULT_STATUS_N_LSFAIL_SHIFT   0
#define PMU_GLOBAL_MB_FAULT_STATUS_N_LSFAIL_WIDTH   3
#define PMU_GLOBAL_MB_FAULT_STATUS_N_LSFAIL_MASK    ((u32)0X00000007U)

/**
 * Register: PMU_GLOBAL_ERROR_STATUS_1
 */
#define PMU_GLOBAL_ERROR_STATUS_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000530U) )

#define PMU_GLOBAL_ERROR_STATUS_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_STATUS_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_STATUS_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_STATUS_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_STATUS_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_STATUS_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_STATUS_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_STATUS_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_STATUS_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_STATUS_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_STATUS_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_STATUS_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_STATUS_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_STATUS_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_STATUS_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_STATUS_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_STATUS_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_STATUS_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_STATUS_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_STATUS_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_STATUS_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_STATUS_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_STATUS_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_STATUS_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_STATUS_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_STATUS_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_STATUS_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_STATUS_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_STATUS_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_STATUS_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_STATUS_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_STATUS_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_STATUS_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_STATUS_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_STATUS_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_STATUS_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_STATUS_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_STATUS_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_STATUS_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_INT_MASK_1
 */
#define PMU_GLOBAL_ERROR_INT_MASK_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000534U) )

#define PMU_GLOBAL_ERROR_INT_MASK_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_INT_MASK_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_INT_MASK_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_INT_MASK_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_INT_MASK_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_INT_MASK_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_INT_MASK_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_INT_MASK_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_INT_MASK_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_INT_MASK_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_INT_MASK_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_INT_MASK_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_INT_MASK_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_INT_MASK_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_INT_MASK_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_INT_MASK_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_INT_MASK_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_INT_MASK_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_INT_MASK_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_INT_MASK_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_INT_MASK_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_INT_MASK_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_INT_EN_1
 */
#define PMU_GLOBAL_ERROR_INT_EN_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000538U) )

#define PMU_GLOBAL_ERROR_INT_EN_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_INT_EN_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_INT_EN_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_INT_EN_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_INT_EN_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_INT_EN_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_INT_EN_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_INT_EN_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_INT_EN_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_INT_EN_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_INT_EN_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_INT_EN_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_INT_EN_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_INT_EN_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_INT_EN_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_INT_EN_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_INT_EN_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_INT_EN_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_INT_EN_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_INT_EN_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_INT_EN_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_INT_EN_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_INT_EN_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_INT_EN_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_INT_EN_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_INT_EN_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_INT_EN_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_INT_EN_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_INT_EN_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_INT_EN_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_INT_EN_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_INT_EN_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_INT_EN_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_INT_EN_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_INT_EN_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_INT_EN_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_INT_EN_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_INT_EN_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_INT_EN_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_INT_DIS_1
 */
#define PMU_GLOBAL_ERROR_INT_DIS_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000053CU) )

#define PMU_GLOBAL_ERROR_INT_DIS_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_INT_DIS_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_INT_DIS_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_INT_DIS_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_INT_DIS_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_INT_DIS_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_INT_DIS_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_INT_DIS_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_INT_DIS_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_INT_DIS_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_INT_DIS_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_INT_DIS_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_INT_DIS_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_INT_DIS_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_INT_DIS_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_INT_DIS_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_INT_DIS_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_INT_DIS_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_INT_DIS_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_INT_DIS_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_INT_DIS_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_INT_DIS_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_STATUS_2
 */
#define PMU_GLOBAL_ERROR_STATUS_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000540U) )

#define PMU_GLOBAL_ERROR_STATUS_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_STATUS_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_STATUS_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_STATUS_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_STATUS_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_STATUS_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_STATUS_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_STATUS_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_STATUS_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_STATUS_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_STATUS_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_STATUS_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_STATUS_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_STATUS_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_STATUS_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_STATUS_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_STATUS_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_STATUS_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_STATUS_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_STATUS_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_STATUS_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_STATUS_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_STATUS_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_ERROR_INT_MASK_2
 */
#define PMU_GLOBAL_ERROR_INT_MASK_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000544U) )

#define PMU_GLOBAL_ERROR_INT_MASK_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_INT_MASK_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_INT_MASK_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_INT_MASK_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_INT_MASK_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_INT_MASK_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_INT_MASK_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_INT_MASK_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_INT_MASK_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_INT_MASK_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_INT_MASK_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_INT_MASK_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_INT_MASK_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_MASK_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_INT_MASK_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_INT_MASK_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_INT_MASK_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_INT_MASK_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_INT_MASK_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_INT_MASK_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_INT_MASK_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_INT_MASK_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_INT_MASK_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_ERROR_INT_EN_2
 */
#define PMU_GLOBAL_ERROR_INT_EN_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000548U) )

#define PMU_GLOBAL_ERROR_INT_EN_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_INT_EN_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_INT_EN_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_INT_EN_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_INT_EN_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_INT_EN_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_INT_EN_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_INT_EN_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_INT_EN_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_INT_EN_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_INT_EN_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_INT_EN_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_INT_EN_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_EN_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_INT_EN_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_INT_EN_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_INT_EN_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_INT_EN_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_INT_EN_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_INT_EN_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_INT_EN_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_INT_EN_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_INT_EN_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_ERROR_INT_DIS_2
 */
#define PMU_GLOBAL_ERROR_INT_DIS_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000054CU) )

#define PMU_GLOBAL_ERROR_INT_DIS_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_INT_DIS_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_INT_DIS_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_INT_DIS_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_INT_DIS_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_INT_DIS_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_INT_DIS_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_INT_DIS_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_INT_DIS_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_INT_DIS_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_INT_DIS_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_INT_DIS_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_INT_DIS_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_INT_DIS_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_INT_DIS_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_INT_DIS_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_INT_DIS_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_INT_DIS_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_INT_DIS_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_INT_DIS_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_INT_DIS_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_INT_DIS_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_INT_DIS_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_ERROR_POR_MASK_1
 */
#define PMU_GLOBAL_ERROR_POR_MASK_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000550U) )

#define PMU_GLOBAL_ERROR_POR_MASK_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_POR_MASK_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_POR_MASK_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_POR_MASK_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_POR_MASK_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_POR_MASK_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_POR_MASK_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_POR_MASK_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_POR_MASK_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_POR_MASK_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_POR_MASK_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_POR_MASK_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_POR_MASK_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_POR_MASK_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_POR_MASK_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_POR_MASK_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_POR_MASK_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_POR_MASK_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_POR_MASK_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_POR_MASK_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_POR_MASK_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_POR_MASK_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_POR_EN_1
 */
#define PMU_GLOBAL_ERROR_POR_EN_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000554U) )

#define PMU_GLOBAL_ERROR_POR_EN_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_POR_EN_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_POR_EN_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_POR_EN_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_POR_EN_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_POR_EN_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_POR_EN_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_POR_EN_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_POR_EN_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_POR_EN_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_POR_EN_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_POR_EN_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_POR_EN_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_POR_EN_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_POR_EN_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_POR_EN_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_POR_EN_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_POR_EN_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_POR_EN_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_POR_EN_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_POR_EN_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_POR_EN_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_POR_EN_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_POR_EN_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_POR_EN_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_POR_EN_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_POR_EN_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_POR_EN_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_POR_EN_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_POR_EN_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_POR_EN_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_POR_EN_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_POR_EN_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_POR_EN_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_POR_EN_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_POR_EN_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_POR_EN_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_POR_EN_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_POR_EN_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_POR_DIS_1
 */
#define PMU_GLOBAL_ERROR_POR_DIS_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000558U) )

#define PMU_GLOBAL_ERROR_POR_DIS_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_POR_DIS_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_POR_DIS_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_POR_DIS_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_POR_DIS_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_POR_DIS_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_POR_DIS_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_POR_DIS_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_POR_DIS_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_POR_DIS_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_POR_DIS_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_POR_DIS_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_POR_DIS_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_POR_DIS_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_POR_DIS_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_POR_DIS_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_POR_DIS_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_POR_DIS_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_POR_DIS_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_POR_DIS_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_POR_DIS_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_POR_DIS_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_POR_MASK_2
 */
#define PMU_GLOBAL_ERROR_POR_MASK_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000055CU) )

#define PMU_GLOBAL_ERROR_POR_MASK_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_POR_MASK_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_POR_MASK_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_POR_MASK_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_POR_MASK_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_POR_MASK_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_POR_MASK_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_POR_MASK_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_POR_MASK_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_POR_MASK_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_POR_MASK_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_POR_MASK_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_POR_MASK_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_MASK_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_POR_MASK_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_POR_MASK_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_POR_MASK_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_POR_MASK_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_POR_MASK_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_POR_MASK_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_POR_MASK_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_POR_MASK_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_POR_MASK_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_ERROR_POR_EN_2
 */
#define PMU_GLOBAL_ERROR_POR_EN_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000560U) )

#define PMU_GLOBAL_ERROR_POR_EN_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_POR_EN_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_POR_EN_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_POR_EN_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_POR_EN_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_POR_EN_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_POR_EN_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_POR_EN_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_POR_EN_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_POR_EN_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_POR_EN_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_POR_EN_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_POR_EN_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_EN_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_POR_EN_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_POR_EN_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_POR_EN_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_POR_EN_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_POR_EN_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_POR_EN_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_POR_EN_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_POR_EN_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_POR_EN_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_ERROR_POR_DIS_2
 */
#define PMU_GLOBAL_ERROR_POR_DIS_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000564U) )

#define PMU_GLOBAL_ERROR_POR_DIS_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_POR_DIS_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_POR_DIS_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_POR_DIS_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_POR_DIS_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_POR_DIS_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_POR_DIS_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_POR_DIS_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_POR_DIS_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_POR_DIS_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_POR_DIS_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_POR_DIS_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_POR_DIS_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_POR_DIS_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_POR_DIS_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_POR_DIS_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_POR_DIS_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_POR_DIS_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_POR_DIS_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_POR_DIS_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_POR_DIS_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_POR_DIS_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_POR_DIS_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_ERROR_SRST_MASK_1
 */
#define PMU_GLOBAL_ERROR_SRST_MASK_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000568U) )

#define PMU_GLOBAL_ERROR_SRST_MASK_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_SRST_MASK_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_SRST_MASK_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_SRST_MASK_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_SRST_MASK_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_SRST_MASK_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_SRST_MASK_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_SRST_MASK_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_SRST_MASK_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_SRST_MASK_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_SRST_MASK_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_SRST_MASK_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_SRST_MASK_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_SRST_MASK_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_SRST_MASK_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_SRST_MASK_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_SRST_MASK_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_SRST_MASK_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_SRST_MASK_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_SRST_MASK_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_SRST_MASK_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_SRST_MASK_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_SRST_EN_1
 */
#define PMU_GLOBAL_ERROR_SRST_EN_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000056CU) )

#define PMU_GLOBAL_ERROR_SRST_EN_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_SRST_EN_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_SRST_EN_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_SRST_EN_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_SRST_EN_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_SRST_EN_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_SRST_EN_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_SRST_EN_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_SRST_EN_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_SRST_EN_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_SRST_EN_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_SRST_EN_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_SRST_EN_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_SRST_EN_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_SRST_EN_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_SRST_EN_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_SRST_EN_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_SRST_EN_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_SRST_EN_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_SRST_EN_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_SRST_EN_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_SRST_EN_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_SRST_DIS_1
 */
#define PMU_GLOBAL_ERROR_SRST_DIS_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000570U) )

#define PMU_GLOBAL_ERROR_SRST_DIS_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_SRST_DIS_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_SRST_DIS_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_SRST_DIS_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_SRST_DIS_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_SRST_DIS_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_SRST_DIS_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_SRST_DIS_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_SRST_DIS_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_SRST_DIS_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_SRST_DIS_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_SRST_DIS_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_SRST_DIS_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_SRST_DIS_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_SRST_DIS_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_SRST_DIS_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_SRST_DIS_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_SRST_DIS_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_SRST_DIS_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_SRST_DIS_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_SRST_DIS_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_SRST_DIS_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_SRST_MASK_2
 */
#define PMU_GLOBAL_ERROR_SRST_MASK_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000574U) )

#define PMU_GLOBAL_ERROR_SRST_MASK_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_SRST_MASK_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_SRST_MASK_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_SRST_MASK_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_SRST_MASK_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_SRST_MASK_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_SRST_MASK_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_SRST_MASK_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_MASK_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_SRST_MASK_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_SRST_MASK_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_SRST_MASK_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_SRST_MASK_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_SRST_MASK_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_SRST_MASK_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_SRST_MASK_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_SRST_MASK_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_SRST_MASK_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_ERROR_SRST_EN_2
 */
#define PMU_GLOBAL_ERROR_SRST_EN_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000578U) )

#define PMU_GLOBAL_ERROR_SRST_EN_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_SRST_EN_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_SRST_EN_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_SRST_EN_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_SRST_EN_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_SRST_EN_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_SRST_EN_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_SRST_EN_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_SRST_EN_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_SRST_EN_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_SRST_EN_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_SRST_EN_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_SRST_EN_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_EN_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_SRST_EN_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_SRST_EN_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_SRST_EN_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_SRST_EN_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_SRST_EN_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_SRST_EN_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_SRST_EN_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_SRST_EN_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_SRST_EN_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_ERROR_SRST_DIS_2
 */
#define PMU_GLOBAL_ERROR_SRST_DIS_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000057CU) )

#define PMU_GLOBAL_ERROR_SRST_DIS_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_SRST_DIS_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_SRST_DIS_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_SRST_DIS_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_SRST_DIS_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_SRST_DIS_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_SRST_DIS_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_SRST_DIS_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_SRST_DIS_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_SRST_DIS_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_SRST_DIS_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_SRST_DIS_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_SRST_DIS_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_SRST_DIS_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_SRST_DIS_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_SRST_DIS_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_SRST_DIS_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_SRST_DIS_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_ERROR_SIG_MASK_1
 */
#define PMU_GLOBAL_ERROR_SIG_MASK_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000580U) )

#define PMU_GLOBAL_ERROR_SIG_MASK_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_SIG_MASK_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_SIG_MASK_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_SIG_MASK_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_SIG_MASK_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_SIG_MASK_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_SIG_MASK_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_SIG_MASK_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_SIG_MASK_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_SIG_MASK_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_SIG_MASK_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_SIG_MASK_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_SIG_MASK_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_SIG_MASK_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_SIG_MASK_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_SIG_MASK_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_SIG_MASK_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_SIG_MASK_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_SIG_MASK_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_SIG_MASK_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_SIG_MASK_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_SIG_MASK_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_SIG_EN_1
 */
#define PMU_GLOBAL_ERROR_SIG_EN_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000584U) )

#define PMU_GLOBAL_ERROR_SIG_EN_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_SIG_EN_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_SIG_EN_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_SIG_EN_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_SIG_EN_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_SIG_EN_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_SIG_EN_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_SIG_EN_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_SIG_EN_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_SIG_EN_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_SIG_EN_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_SIG_EN_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_SIG_EN_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_SIG_EN_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_SIG_EN_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_SIG_EN_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_SIG_EN_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_SIG_EN_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_SIG_EN_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_SIG_EN_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_SIG_EN_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_SIG_EN_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_SIG_DIS_1
 */
#define PMU_GLOBAL_ERROR_SIG_DIS_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000588U) )

#define PMU_GLOBAL_ERROR_SIG_DIS_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_SIG_DIS_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_SIG_DIS_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_SIG_DIS_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_SIG_DIS_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_SIG_DIS_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_SIG_DIS_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_SIG_DIS_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_SIG_DIS_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_SIG_DIS_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_SIG_DIS_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_SIG_DIS_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_SIG_DIS_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_SIG_DIS_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_SIG_DIS_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_SIG_DIS_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_SIG_DIS_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_SIG_DIS_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_SIG_DIS_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_SIG_DIS_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_SIG_DIS_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_SIG_DIS_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_SIG_MASK_2
 */
#define PMU_GLOBAL_ERROR_SIG_MASK_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000058CU) )

#define PMU_GLOBAL_ERROR_SIG_MASK_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_SIG_MASK_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_SIG_MASK_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_SIG_MASK_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_SIG_MASK_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_SIG_MASK_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_SIG_MASK_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_SIG_MASK_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_MASK_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_SIG_MASK_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_SIG_MASK_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_SIG_MASK_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_SIG_MASK_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_SIG_MASK_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_SIG_MASK_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_SIG_MASK_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_SIG_MASK_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_SIG_MASK_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_ERROR_SIG_EN_2
 */
#define PMU_GLOBAL_ERROR_SIG_EN_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000590U) )

#define PMU_GLOBAL_ERROR_SIG_EN_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_SIG_EN_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_SIG_EN_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_SIG_EN_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_SIG_EN_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_SIG_EN_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_SIG_EN_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_SIG_EN_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_SIG_EN_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_SIG_EN_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_SIG_EN_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_SIG_EN_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_SIG_EN_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_EN_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_SIG_EN_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_SIG_EN_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_SIG_EN_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_SIG_EN_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_SIG_EN_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_SIG_EN_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_SIG_EN_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_SIG_EN_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_SIG_EN_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_ERROR_SIG_DIS_2
 */
#define PMU_GLOBAL_ERROR_SIG_DIS_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000594U) )

#define PMU_GLOBAL_ERROR_SIG_DIS_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_SIG_DIS_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_SIG_DIS_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_SIG_DIS_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_SIG_DIS_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_SIG_DIS_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_SIG_DIS_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_SIG_DIS_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_SIG_DIS_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_SIG_DIS_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_SIG_DIS_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_SIG_DIS_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_SIG_DIS_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_SIG_DIS_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_SIG_DIS_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_SIG_DIS_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_SIG_DIS_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_SIG_DIS_2_TO_MASK    ((u32)0X00000003U)

#define PMU_GLOBAL_ERROR_SIG_2_IOPLL_SHIFT	8
#define PMU_GLOBAL_ERROR_SIG_2_RPLL_SHIFT	9
#define PMU_GLOBAL_ERROR_SIG_2_APLL_SHIFT	10
#define PMU_GLOBAL_ERROR_SIG_2_DPLL_SHIFT	11
#define PMU_GLOBAL_ERROR_SIG_2_VPLL_SHIFT	12

/**
 * Register: PMU_GLOBAL_ERROR_EN_1
 */
#define PMU_GLOBAL_ERROR_EN_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X000005A0U) )

#define PMU_GLOBAL_ERROR_EN_1_AUX3_SHIFT   31
#define PMU_GLOBAL_ERROR_EN_1_AUX3_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_AUX3_MASK    ((u32)0X80000000U)

#define PMU_GLOBAL_ERROR_EN_1_AUX2_SHIFT   30
#define PMU_GLOBAL_ERROR_EN_1_AUX2_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_AUX2_MASK    ((u32)0X40000000U)

#define PMU_GLOBAL_ERROR_EN_1_AUX1_SHIFT   29
#define PMU_GLOBAL_ERROR_EN_1_AUX1_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_AUX1_MASK    ((u32)0X20000000U)

#define PMU_GLOBAL_ERROR_EN_1_AUX0_SHIFT   28
#define PMU_GLOBAL_ERROR_EN_1_AUX0_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_AUX0_MASK    ((u32)0X10000000U)

#define PMU_GLOBAL_ERROR_EN_1_CSU_SWDT_SHIFT   27
#define PMU_GLOBAL_ERROR_EN_1_CSU_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_CSU_SWDT_MASK    ((u32)0X08000000U)

#define PMU_GLOBAL_ERROR_EN_1_CLK_MON_SHIFT   26
#define PMU_GLOBAL_ERROR_EN_1_CLK_MON_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_CLK_MON_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_EN_1_XMPU_SHIFT   24
#define PMU_GLOBAL_ERROR_EN_1_XMPU_WIDTH   2
#define PMU_GLOBAL_ERROR_EN_1_XMPU_MASK    ((u32)0X03000000U)

#define PMU_GLOBAL_ERROR_EN_1_PWR_SUPPLY_SHIFT   16
#define PMU_GLOBAL_ERROR_EN_1_PWR_SUPPLY_WIDTH   8
#define PMU_GLOBAL_ERROR_EN_1_PWR_SUPPLY_MASK    ((u32)0X00FF0000U)

#define PMU_GLOBAL_ERROR_EN_1_FPD_SWDT_SHIFT   13
#define PMU_GLOBAL_ERROR_EN_1_FPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_FPD_SWDT_MASK    ((u32)0X00002000U)

#define PMU_GLOBAL_ERROR_EN_1_LPD_SWDT_SHIFT   12
#define PMU_GLOBAL_ERROR_EN_1_LPD_SWDT_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_LPD_SWDT_MASK    ((u32)0X00001000U)

#define PMU_GLOBAL_ERROR_EN_1_RPU_CCF_SHIFT   9
#define PMU_GLOBAL_ERROR_EN_1_RPU_CCF_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_RPU_CCF_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_ERROR_EN_1_RPU_LS_SHIFT   6
#define PMU_GLOBAL_ERROR_EN_1_RPU_LS_WIDTH   2
#define PMU_GLOBAL_ERROR_EN_1_RPU_LS_MASK    ((u32)0X000000C0U)

#define PMU_GLOBAL_ERROR_EN_1_FPD_TEMP_SHIFT   5
#define PMU_GLOBAL_ERROR_EN_1_FPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_FPD_TEMP_MASK    ((u32)0X00000020U)

#define PMU_GLOBAL_ERROR_EN_1_LPD_TEMP_SHIFT   4
#define PMU_GLOBAL_ERROR_EN_1_LPD_TEMP_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_LPD_TEMP_MASK    ((u32)0X00000010U)

#define PMU_GLOBAL_ERROR_EN_1_RPU1_SHIFT   3
#define PMU_GLOBAL_ERROR_EN_1_RPU1_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_RPU1_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_ERROR_EN_1_RPU0_SHIFT   2
#define PMU_GLOBAL_ERROR_EN_1_RPU0_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_RPU0_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_ERROR_EN_1_OCM_ECC_SHIFT   1
#define PMU_GLOBAL_ERROR_EN_1_OCM_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_OCM_ECC_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ERROR_EN_1_DDR_ECC_SHIFT   0
#define PMU_GLOBAL_ERROR_EN_1_DDR_ECC_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_1_DDR_ECC_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ERROR_EN_2
 */
#define PMU_GLOBAL_ERROR_EN_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X000005A4U) )

#define PMU_GLOBAL_ERROR_EN_2_CSU_ROM_SHIFT   26
#define PMU_GLOBAL_ERROR_EN_2_CSU_ROM_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_2_CSU_ROM_MASK    ((u32)0X04000000U)

#define PMU_GLOBAL_ERROR_EN_2_PMU_PB_SHIFT   25
#define PMU_GLOBAL_ERROR_EN_2_PMU_PB_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_2_PMU_PB_MASK    ((u32)0X02000000U)

#define PMU_GLOBAL_ERROR_EN_2_PMU_SERVICE_SHIFT   24
#define PMU_GLOBAL_ERROR_EN_2_PMU_SERVICE_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_2_PMU_SERVICE_MASK    ((u32)0X01000000U)

#define PMU_GLOBAL_ERROR_EN_2_PMU_FW_SHIFT   18
#define PMU_GLOBAL_ERROR_EN_2_PMU_FW_WIDTH   4
#define PMU_GLOBAL_ERROR_EN_2_PMU_FW_MASK    ((u32)0X003C0000U)

#define PMU_GLOBAL_ERROR_EN_2_PMU_UC_SHIFT   17
#define PMU_GLOBAL_ERROR_EN_2_PMU_UC_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_2_PMU_UC_MASK    ((u32)0X00020000U)

#define PMU_GLOBAL_ERROR_EN_2_CSU_SHIFT   16
#define PMU_GLOBAL_ERROR_EN_2_CSU_WIDTH   1
#define PMU_GLOBAL_ERROR_EN_2_CSU_MASK    ((u32)0X00010000U)

#define PMU_GLOBAL_ERROR_EN_2_PLL_LOCK_SHIFT   8
#define PMU_GLOBAL_ERROR_EN_2_PLL_LOCK_WIDTH   5
#define PMU_GLOBAL_ERROR_EN_2_PLL_LOCK_MASK    ((u32)0X00001F00U)

#define PMU_GLOBAL_ERROR_EN_2_PL_SHIFT   2
#define PMU_GLOBAL_ERROR_EN_2_PL_WIDTH   4
#define PMU_GLOBAL_ERROR_EN_2_PL_MASK    ((u32)0X0000003CU)

#define PMU_GLOBAL_ERROR_EN_2_TO_SHIFT   0
#define PMU_GLOBAL_ERROR_EN_2_TO_WIDTH   2
#define PMU_GLOBAL_ERROR_EN_2_TO_MASK    ((u32)0X00000003U)

/**
 * Register: PMU_GLOBAL_AIB_CNTRL
 */
#define PMU_GLOBAL_AIB_CNTRL    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000600U) )

#define PMU_GLOBAL_AIB_CNTRL_FPD_AFI_FS_SHIFT   3
#define PMU_GLOBAL_AIB_CNTRL_FPD_AFI_FS_WIDTH   1
#define PMU_GLOBAL_AIB_CNTRL_FPD_AFI_FS_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_AIB_CNTRL_FPD_AFI_FM_SHIFT   2
#define PMU_GLOBAL_AIB_CNTRL_FPD_AFI_FM_WIDTH   1
#define PMU_GLOBAL_AIB_CNTRL_FPD_AFI_FM_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_AIB_CNTRL_LPD_AFI_FS_SHIFT   1
#define PMU_GLOBAL_AIB_CNTRL_LPD_AFI_FS_WIDTH   1
#define PMU_GLOBAL_AIB_CNTRL_LPD_AFI_FS_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_AIB_CNTRL_LPD_AFI_FM_SHIFT   0
#define PMU_GLOBAL_AIB_CNTRL_LPD_AFI_FM_WIDTH   1
#define PMU_GLOBAL_AIB_CNTRL_LPD_AFI_FM_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_AIB_STATUS
 */
#define PMU_GLOBAL_AIB_STATUS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000604U) )

#define PMU_GLOBAL_AIB_STATUS_FPD_AFI_FS_SHIFT   3
#define PMU_GLOBAL_AIB_STATUS_FPD_AFI_FS_WIDTH   1
#define PMU_GLOBAL_AIB_STATUS_FPD_AFI_FS_MASK    ((u32)0X00000008U)

#define PMU_GLOBAL_AIB_STATUS_FPD_AFI_FM_SHIFT   2
#define PMU_GLOBAL_AIB_STATUS_FPD_AFI_FM_WIDTH   1
#define PMU_GLOBAL_AIB_STATUS_FPD_AFI_FM_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_AIB_STATUS_LPD_AFI_FS_SHIFT   1
#define PMU_GLOBAL_AIB_STATUS_LPD_AFI_FS_WIDTH   1
#define PMU_GLOBAL_AIB_STATUS_LPD_AFI_FS_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_AIB_STATUS_LPD_AFI_FM_SHIFT   0
#define PMU_GLOBAL_AIB_STATUS_LPD_AFI_FM_WIDTH   1
#define PMU_GLOBAL_AIB_STATUS_LPD_AFI_FM_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_GLOBAL_RESET
 */
#define PMU_GLOBAL_GLOBAL_RESET    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000608U) )

#define PMU_GLOBAL_GLOBAL_RESET_PS_ONLY_RST_SHIFT   10
#define PMU_GLOBAL_GLOBAL_RESET_PS_ONLY_RST_WIDTH   1
#define PMU_GLOBAL_GLOBAL_RESET_PS_ONLY_RST_MASK    ((u32)0X00000400U)

#define PMU_GLOBAL_GLOBAL_RESET_FPD_RST_SHIFT   9
#define PMU_GLOBAL_GLOBAL_RESET_FPD_RST_WIDTH   1
#define PMU_GLOBAL_GLOBAL_RESET_FPD_RST_MASK    ((u32)0X00000200U)

#define PMU_GLOBAL_GLOBAL_RESET_RPU_LS_RST_SHIFT   8
#define PMU_GLOBAL_GLOBAL_RESET_RPU_LS_RST_WIDTH   1
#define PMU_GLOBAL_GLOBAL_RESET_RPU_LS_RST_MASK    ((u32)0X00000100U)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_STATUS
 */
#define PMU_GLOBAL_ROM_VALIDATION_STATUS    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000610U) )

#define PMU_GLOBAL_ROM_VALIDATION_STATUS_PASS_SHIFT   1
#define PMU_GLOBAL_ROM_VALIDATION_STATUS_PASS_WIDTH   1
#define PMU_GLOBAL_ROM_VALIDATION_STATUS_PASS_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_ROM_VALIDATION_STATUS_DONE_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_STATUS_DONE_WIDTH   1
#define PMU_GLOBAL_ROM_VALIDATION_STATUS_DONE_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_DIGEST_0
 */
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_0    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000614U) )

#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_0_WORD_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_0_WORD_WIDTH   32
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_0_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_DIGEST_1
 */
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000618U) )

#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_1_WORD_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_1_WORD_WIDTH   32
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_1_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_DIGEST_2
 */
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000061CU) )

#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_2_WORD_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_2_WORD_WIDTH   32
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_2_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_DIGEST_3
 */
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_3    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000620U) )

#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_3_WORD_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_3_WORD_WIDTH   32
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_3_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_DIGEST_4
 */
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_4    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000624U) )

#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_4_WORD_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_4_WORD_WIDTH   32
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_4_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_DIGEST_5
 */
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_5    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000628U) )

#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_5_WORD_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_5_WORD_WIDTH   32
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_5_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_DIGEST_6
 */
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_6    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000062CU) )

#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_6_WORD_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_6_WORD_WIDTH   32
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_6_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_DIGEST_7
 */
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_7    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000630U) )

#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_7_WORD_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_7_WORD_WIDTH   32
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_7_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_DIGEST_8
 */
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_8    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000634U) )

#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_8_WORD_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_8_WORD_WIDTH   32
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_8_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_DIGEST_9
 */
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_9    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000638U) )

#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_9_WORD_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_9_WORD_WIDTH   32
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_9_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_DIGEST_10
 */
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_10    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X0000063CU) )

#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_10_WORD_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_10_WORD_WIDTH   32
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_10_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ROM_VALIDATION_DIGEST_11
 */
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_11    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000640U) )

#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_11_WORD_SHIFT   0
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_11_WORD_WIDTH   32
#define PMU_GLOBAL_ROM_VALIDATION_DIGEST_11_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_SAFETY_GATE
 */
#define PMU_GLOBAL_SAFETY_GATE    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000650U) )

#define PMU_GLOBAL_SAFETY_GATE_PMU_LOGCLR_ENABLE_SHIFT   2
#define PMU_GLOBAL_SAFETY_GATE_PMU_LOGCLR_ENABLE_WIDTH   1
#define PMU_GLOBAL_SAFETY_GATE_PMU_LOGCLR_ENABLE_MASK    ((u32)0X00000004U)

#define PMU_GLOBAL_SAFETY_GATE_LBIST_ENABLE_SHIFT   1
#define PMU_GLOBAL_SAFETY_GATE_LBIST_ENABLE_WIDTH   1
#define PMU_GLOBAL_SAFETY_GATE_LBIST_ENABLE_MASK    ((u32)0X00000002U)

#define PMU_GLOBAL_SAFETY_GATE_SCAN_ENABLE_SHIFT   0
#define PMU_GLOBAL_SAFETY_GATE_SCAN_ENABLE_WIDTH   1
#define PMU_GLOBAL_SAFETY_GATE_SCAN_ENABLE_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_GLOBAL_MBIST_RST
 */
#define PMU_GLOBAL_MBIST_RST    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000700U) )

#define PMU_GLOBAL_MBIST_RST_REG_SHIFT   0
#define PMU_GLOBAL_MBIST_RST_REG_WIDTH   32
#define PMU_GLOBAL_MBIST_RST_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_MBIST_PG_EN
 */
#define PMU_GLOBAL_MBIST_PG_EN    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000704U) )

#define PMU_GLOBAL_MBIST_PG_EN_REG_SHIFT   0
#define PMU_GLOBAL_MBIST_PG_EN_REG_WIDTH   32
#define PMU_GLOBAL_MBIST_PG_EN_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_MBIST_SETUP
 */
#define PMU_GLOBAL_MBIST_SETUP    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000708U) )

#define PMU_GLOBAL_MBIST_SETUP_REG_SHIFT   0
#define PMU_GLOBAL_MBIST_SETUP_REG_WIDTH   32
#define PMU_GLOBAL_MBIST_SETUP_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_MBIST_DONE
 */
#define PMU_GLOBAL_MBIST_DONE    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000710U) )

#define PMU_GLOBAL_MBIST_DONE_WORD_SHIFT   0
#define PMU_GLOBAL_MBIST_DONE_WORD_WIDTH   32
#define PMU_GLOBAL_MBIST_DONE_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_MBIST_GOOD
 */
#define PMU_GLOBAL_MBIST_GOOD    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000714U) )

#define PMU_GLOBAL_MBIST_GOOD_WORD_SHIFT   0
#define PMU_GLOBAL_MBIST_GOOD_WORD_WIDTH   32
#define PMU_GLOBAL_MBIST_GOOD_WORD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_SAFETY_CHK
 */
#define PMU_GLOBAL_SAFETY_CHK    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000800U) )

#define PMU_GLOBAL_SAFETY_CHK_REG_SHIFT   0
#define PMU_GLOBAL_SAFETY_CHK_REG_WIDTH   32
#define PMU_GLOBAL_SAFETY_CHK_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ECO_1
 */
#define PMU_GLOBAL_ECO_1    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000804U) )

#define PMU_GLOBAL_ECO_1_REG_SHIFT   0
#define PMU_GLOBAL_ECO_1_REG_WIDTH   32
#define PMU_GLOBAL_ECO_1_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_GLOBAL_ECO_2
 */
#define PMU_GLOBAL_ECO_2    ( ( PMU_GLOBAL_BASEADDR ) + ((u32)0X00000808U) )

#define PMU_GLOBAL_ECO_2_REG_SHIFT   0
#define PMU_GLOBAL_ECO_2_REG_WIDTH   32
#define PMU_GLOBAL_ECO_2_REG_MASK    ((u32)0XFFFFFFFFU)

#ifdef __cplusplus
}
#endif


#endif /* _PMU_GLOBAL_H_ */
