/******************************************************************************
* Copyright (c) 2015 - 2020 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


#ifndef LPD_SLCR_H_
#define LPD_SLCR_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * LPD_SLCR Base Address
 */
#define LPD_SLCR_BASEADDR      ((u32)0XFF410000U)

/**
 * Register: LPD_SLCR_WPROT0
 */
#define LPD_SLCR_WPROT0    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000000U) )

#define LPD_SLCR_WPROT0_ACTIVE_SHIFT   0
#define LPD_SLCR_WPROT0_ACTIVE_WIDTH   1
#define LPD_SLCR_WPROT0_ACTIVE_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_CTRL
 */
#define LPD_SLCR_CTRL    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000004U) )

#define LPD_SLCR_CTRL_SLVERR_ENABLE_SHIFT   0
#define LPD_SLCR_CTRL_SLVERR_ENABLE_WIDTH   1
#define LPD_SLCR_CTRL_SLVERR_ENABLE_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ISR
 */
#define LPD_SLCR_ISR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000008U) )

#define LPD_SLCR_ISR_ADDR_DECODE_ERR_SHIFT   0
#define LPD_SLCR_ISR_ADDR_DECODE_ERR_WIDTH   1
#define LPD_SLCR_ISR_ADDR_DECODE_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_IMR
 */
#define LPD_SLCR_IMR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000000CU) )

#define LPD_SLCR_IMR_ADDR_DECODE_ERR_SHIFT   0
#define LPD_SLCR_IMR_ADDR_DECODE_ERR_WIDTH   1
#define LPD_SLCR_IMR_ADDR_DECODE_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_IER
 */
#define LPD_SLCR_IER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000010U) )

#define LPD_SLCR_IER_ADDR_DECODE_ERR_SHIFT   0
#define LPD_SLCR_IER_ADDR_DECODE_ERR_WIDTH   1
#define LPD_SLCR_IER_ADDR_DECODE_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_IDR
 */
#define LPD_SLCR_IDR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000014U) )

#define LPD_SLCR_IDR_ADDR_DECODE_ERR_SHIFT   0
#define LPD_SLCR_IDR_ADDR_DECODE_ERR_WIDTH   1
#define LPD_SLCR_IDR_ADDR_DECODE_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ITR
 */
#define LPD_SLCR_ITR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000018U) )

#define LPD_SLCR_ITR_ADDR_DECODE_ERR_SHIFT   0
#define LPD_SLCR_ITR_ADDR_DECODE_ERR_WIDTH   1
#define LPD_SLCR_ITR_ADDR_DECODE_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ECO
 */
#define LPD_SLCR_ECO    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000001CU) )

#define LPD_SLCR_ECO_FIELD_SHIFT   0
#define LPD_SLCR_ECO_FIELD_WIDTH   32
#define LPD_SLCR_ECO_FIELD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_PERSISTENT0
 */
#define LPD_SLCR_PERSISTENT0    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000020U) )

#define LPD_SLCR_PERSISTENT0_REG_SHIFT   0
#define LPD_SLCR_PERSISTENT0_REG_WIDTH   32
#define LPD_SLCR_PERSISTENT0_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_PERSISTENT1
 */
#define LPD_SLCR_PERSISTENT1    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000024U) )

#define LPD_SLCR_PERSISTENT1_REG_SHIFT   0
#define LPD_SLCR_PERSISTENT1_REG_WIDTH   32
#define LPD_SLCR_PERSISTENT1_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_PERSISTENT2
 */
#define LPD_SLCR_PERSISTENT2    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000028U) )

#define LPD_SLCR_PERSISTENT2_REG_SHIFT   0
#define LPD_SLCR_PERSISTENT2_REG_WIDTH   32
#define LPD_SLCR_PERSISTENT2_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_PERSISTENT3
 */
#define LPD_SLCR_PERSISTENT3    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000002CU) )

#define LPD_SLCR_PERSISTENT3_REG_SHIFT   0
#define LPD_SLCR_PERSISTENT3_REG_WIDTH   32
#define LPD_SLCR_PERSISTENT3_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_PERSISTENT4
 */
#define LPD_SLCR_PERSISTENT4    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000030U) )

#define LPD_SLCR_PERSISTENT4_REG_SHIFT   0
#define LPD_SLCR_PERSISTENT4_REG_WIDTH   32
#define LPD_SLCR_PERSISTENT4_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_PERSISTENT5
 */
#define LPD_SLCR_PERSISTENT5    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000034U) )

#define LPD_SLCR_PERSISTENT5_REG_SHIFT   0
#define LPD_SLCR_PERSISTENT5_REG_WIDTH   32
#define LPD_SLCR_PERSISTENT5_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_PERSISTENT6
 */
#define LPD_SLCR_PERSISTENT6    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000038U) )

#define LPD_SLCR_PERSISTENT6_REG_SHIFT   0
#define LPD_SLCR_PERSISTENT6_REG_WIDTH   32
#define LPD_SLCR_PERSISTENT6_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_PERSISTENT7
 */
#define LPD_SLCR_PERSISTENT7    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000003CU) )

#define LPD_SLCR_PERSISTENT7_REG_SHIFT   0
#define LPD_SLCR_PERSISTENT7_REG_WIDTH   32
#define LPD_SLCR_PERSISTENT7_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_SAFETY_CHK0
 */
#define LPD_SLCR_SAFETY_CHK0    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000040U) )

#define LPD_SLCR_SAFETY_CHK0_CHK_VAL_SHIFT   0
#define LPD_SLCR_SAFETY_CHK0_CHK_VAL_WIDTH   32
#define LPD_SLCR_SAFETY_CHK0_CHK_VAL_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_SAFETY_CHK1
 */
#define LPD_SLCR_SAFETY_CHK1    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000044U) )

#define LPD_SLCR_SAFETY_CHK1_CHK_VAL_SHIFT   0
#define LPD_SLCR_SAFETY_CHK1_CHK_VAL_WIDTH   32
#define LPD_SLCR_SAFETY_CHK1_CHK_VAL_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_SAFETY_CHK2
 */
#define LPD_SLCR_SAFETY_CHK2    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000048U) )

#define LPD_SLCR_SAFETY_CHK2_CHK_VAL_SHIFT   0
#define LPD_SLCR_SAFETY_CHK2_CHK_VAL_WIDTH   32
#define LPD_SLCR_SAFETY_CHK2_CHK_VAL_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_SAFETY_CHK3
 */
#define LPD_SLCR_SAFETY_CHK3    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000004CU) )

#define LPD_SLCR_SAFETY_CHK3_CHK_VAL_SHIFT   0
#define LPD_SLCR_SAFETY_CHK3_CHK_VAL_WIDTH   32
#define LPD_SLCR_SAFETY_CHK3_CHK_VAL_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_CSUPMU_WDT_CLK_SEL
 */
#define LPD_SLCR_CSUPMU_WDT_CLK_SEL    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00000050U) )

#define LPD_SLCR_CSUPMU_WDT_CLK_SEL_SELECT_SHIFT   0
#define LPD_SLCR_CSUPMU_WDT_CLK_SEL_SELECT_WIDTH   1
#define LPD_SLCR_CSUPMU_WDT_CLK_SEL_SELECT_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ADMA_CFG
 */
#define LPD_SLCR_ADMA_CFG    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000200CU) )

#define LPD_SLCR_ADMA_CFG_BUS_WIDTH_SHIFT   5
#define LPD_SLCR_ADMA_CFG_BUS_WIDTH_WIDTH   2
#define LPD_SLCR_ADMA_CFG_BUS_WIDTH_MASK    ((u32)0X00000060U)

#define LPD_SLCR_ADMA_CFG_NUM_CH_SHIFT   0
#define LPD_SLCR_ADMA_CFG_NUM_CH_WIDTH   5
#define LPD_SLCR_ADMA_CFG_NUM_CH_MASK    ((u32)0X0000001FU)

/**
 * Register: LPD_SLCR_ADMA_RAM
 */
#define LPD_SLCR_ADMA_RAM    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00002010U) )

#define LPD_SLCR_ADMA_RAM_RAM1_EMAB_SHIFT   12
#define LPD_SLCR_ADMA_RAM_RAM1_EMAB_WIDTH   3
#define LPD_SLCR_ADMA_RAM_RAM1_EMAB_MASK    ((u32)0X00007000U)

#define LPD_SLCR_ADMA_RAM_RAM1_EMASA_SHIFT   11
#define LPD_SLCR_ADMA_RAM_RAM1_EMASA_WIDTH   1
#define LPD_SLCR_ADMA_RAM_RAM1_EMASA_MASK    ((u32)0X00000800U)

#define LPD_SLCR_ADMA_RAM_RAM1_EMAA_SHIFT   8
#define LPD_SLCR_ADMA_RAM_RAM1_EMAA_WIDTH   3
#define LPD_SLCR_ADMA_RAM_RAM1_EMAA_MASK    ((u32)0X00000700U)

#define LPD_SLCR_ADMA_RAM_RAM0_EMAB_SHIFT   4
#define LPD_SLCR_ADMA_RAM_RAM0_EMAB_WIDTH   3
#define LPD_SLCR_ADMA_RAM_RAM0_EMAB_MASK    ((u32)0X00000070U)

#define LPD_SLCR_ADMA_RAM_RAM0_EMASA_SHIFT   3
#define LPD_SLCR_ADMA_RAM_RAM0_EMASA_WIDTH   1
#define LPD_SLCR_ADMA_RAM_RAM0_EMASA_MASK    ((u32)0X00000008U)

#define LPD_SLCR_ADMA_RAM_RAM0_EMAA_SHIFT   0
#define LPD_SLCR_ADMA_RAM_RAM0_EMAA_WIDTH   3
#define LPD_SLCR_ADMA_RAM_RAM0_EMAA_MASK    ((u32)0X00000007U)

/**
 * Register: LPD_SLCR_ERR_AIBAXI_ISR
 */
#define LPD_SLCR_ERR_AIBAXI_ISR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00003000U) )

#define LPD_SLCR_ERR_AIBAXI_ISR_AFIFS2_SHIFT   28
#define LPD_SLCR_ERR_AIBAXI_ISR_AFIFS2_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_AFIFS2_MASK    ((u32)0X10000000U)

#define LPD_SLCR_ERR_AIBAXI_ISR_LPD_DDR_SHIFT   27
#define LPD_SLCR_ERR_AIBAXI_ISR_LPD_DDR_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_LPD_DDR_MASK    ((u32)0X08000000U)

#define LPD_SLCR_ERR_AIBAXI_ISR_OCMS_SHIFT   26
#define LPD_SLCR_ERR_AIBAXI_ISR_OCMS_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_OCMS_MASK    ((u32)0X04000000U)

#define LPD_SLCR_ERR_AIBAXI_ISR_FPD_MAIN_SHIFT   24
#define LPD_SLCR_ERR_AIBAXI_ISR_FPD_MAIN_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_FPD_MAIN_MASK    ((u32)0X01000000U)

#define LPD_SLCR_ERR_AIBAXI_ISR_USB1S_SHIFT   23
#define LPD_SLCR_ERR_AIBAXI_ISR_USB1S_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_USB1S_MASK    ((u32)0X00800000U)

#define LPD_SLCR_ERR_AIBAXI_ISR_USB0S_SHIFT   22
#define LPD_SLCR_ERR_AIBAXI_ISR_USB0S_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_USB0S_MASK    ((u32)0X00400000U)

#define LPD_SLCR_ERR_AIBAXI_ISR_RPUS1_SHIFT   19
#define LPD_SLCR_ERR_AIBAXI_ISR_RPUS1_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_RPUS1_MASK    ((u32)0X00080000U)

#define LPD_SLCR_ERR_AIBAXI_ISR_RPUS0_SHIFT   18
#define LPD_SLCR_ERR_AIBAXI_ISR_RPUS0_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_RPUS0_MASK    ((u32)0X00040000U)

#define LPD_SLCR_ERR_AIBAXI_ISR_RPUM1_SHIFT   17
#define LPD_SLCR_ERR_AIBAXI_ISR_RPUM1_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_RPUM1_MASK    ((u32)0X00020000U)

#define LPD_SLCR_ERR_AIBAXI_ISR_RPUM0_SHIFT   16
#define LPD_SLCR_ERR_AIBAXI_ISR_RPUM0_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_RPUM0_MASK    ((u32)0X00010000U)

#define LPD_SLCR_ERR_AIBAXI_ISR_FPD_OCM_SHIFT   3
#define LPD_SLCR_ERR_AIBAXI_ISR_FPD_OCM_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_FPD_OCM_MASK    ((u32)0X00000008U)

#define LPD_SLCR_ERR_AIBAXI_ISR_FPD_LPDIBS_SHIFT   2
#define LPD_SLCR_ERR_AIBAXI_ISR_FPD_LPDIBS_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_FPD_LPDIBS_MASK    ((u32)0X00000004U)

#define LPD_SLCR_ERR_AIBAXI_ISR_AFIFS1_SHIFT   1
#define LPD_SLCR_ERR_AIBAXI_ISR_AFIFS1_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_AFIFS1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ERR_AIBAXI_ISR_AFIFS0_SHIFT   0
#define LPD_SLCR_ERR_AIBAXI_ISR_AFIFS0_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_ISR_AFIFS0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ERR_AIBAXI_IMR
 */
#define LPD_SLCR_ERR_AIBAXI_IMR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00003008U) )

#define LPD_SLCR_ERR_AIBAXI_IMR_AFIFS2_SHIFT   28
#define LPD_SLCR_ERR_AIBAXI_IMR_AFIFS2_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_AFIFS2_MASK    ((u32)0X10000000U)

#define LPD_SLCR_ERR_AIBAXI_IMR_LPD_DDR_SHIFT   27
#define LPD_SLCR_ERR_AIBAXI_IMR_LPD_DDR_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_LPD_DDR_MASK    ((u32)0X08000000U)

#define LPD_SLCR_ERR_AIBAXI_IMR_OCMS_SHIFT   26
#define LPD_SLCR_ERR_AIBAXI_IMR_OCMS_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_OCMS_MASK    ((u32)0X04000000U)

#define LPD_SLCR_ERR_AIBAXI_IMR_FPD_MAIN_SHIFT   24
#define LPD_SLCR_ERR_AIBAXI_IMR_FPD_MAIN_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_FPD_MAIN_MASK    ((u32)0X01000000U)

#define LPD_SLCR_ERR_AIBAXI_IMR_USB1S_SHIFT   23
#define LPD_SLCR_ERR_AIBAXI_IMR_USB1S_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_USB1S_MASK    ((u32)0X00800000U)

#define LPD_SLCR_ERR_AIBAXI_IMR_USB0S_SHIFT   22
#define LPD_SLCR_ERR_AIBAXI_IMR_USB0S_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_USB0S_MASK    ((u32)0X00400000U)

#define LPD_SLCR_ERR_AIBAXI_IMR_RPUS1_SHIFT   19
#define LPD_SLCR_ERR_AIBAXI_IMR_RPUS1_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_RPUS1_MASK    ((u32)0X00080000U)

#define LPD_SLCR_ERR_AIBAXI_IMR_RPUS0_SHIFT   18
#define LPD_SLCR_ERR_AIBAXI_IMR_RPUS0_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_RPUS0_MASK    ((u32)0X00040000U)

#define LPD_SLCR_ERR_AIBAXI_IMR_RPUM1_SHIFT   17
#define LPD_SLCR_ERR_AIBAXI_IMR_RPUM1_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_RPUM1_MASK    ((u32)0X00020000U)

#define LPD_SLCR_ERR_AIBAXI_IMR_RPUM0_SHIFT   16
#define LPD_SLCR_ERR_AIBAXI_IMR_RPUM0_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_RPUM0_MASK    ((u32)0X00010000U)

#define LPD_SLCR_ERR_AIBAXI_IMR_FPD_OCM_SHIFT   3
#define LPD_SLCR_ERR_AIBAXI_IMR_FPD_OCM_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_FPD_OCM_MASK    ((u32)0X00000008U)

#define LPD_SLCR_ERR_AIBAXI_IMR_FPD_LPDIBS_SHIFT   2
#define LPD_SLCR_ERR_AIBAXI_IMR_FPD_LPDIBS_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_FPD_LPDIBS_MASK    ((u32)0X00000004U)

#define LPD_SLCR_ERR_AIBAXI_IMR_AFIFS1_SHIFT   1
#define LPD_SLCR_ERR_AIBAXI_IMR_AFIFS1_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_AFIFS1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ERR_AIBAXI_IMR_AFIFS0_SHIFT   0
#define LPD_SLCR_ERR_AIBAXI_IMR_AFIFS0_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IMR_AFIFS0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ERR_AIBAXI_IER
 */
#define LPD_SLCR_ERR_AIBAXI_IER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00003010U) )

#define LPD_SLCR_ERR_AIBAXI_IER_AFIFS2_SHIFT   28
#define LPD_SLCR_ERR_AIBAXI_IER_AFIFS2_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_AFIFS2_MASK    ((u32)0X10000000U)

#define LPD_SLCR_ERR_AIBAXI_IER_LPD_DDR_SHIFT   27
#define LPD_SLCR_ERR_AIBAXI_IER_LPD_DDR_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_LPD_DDR_MASK    ((u32)0X08000000U)

#define LPD_SLCR_ERR_AIBAXI_IER_OCMS_SHIFT   26
#define LPD_SLCR_ERR_AIBAXI_IER_OCMS_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_OCMS_MASK    ((u32)0X04000000U)

#define LPD_SLCR_ERR_AIBAXI_IER_FPD_MAIN_SHIFT   24
#define LPD_SLCR_ERR_AIBAXI_IER_FPD_MAIN_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_FPD_MAIN_MASK    ((u32)0X01000000U)

#define LPD_SLCR_ERR_AIBAXI_IER_USB1S_SHIFT   23
#define LPD_SLCR_ERR_AIBAXI_IER_USB1S_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_USB1S_MASK    ((u32)0X00800000U)

#define LPD_SLCR_ERR_AIBAXI_IER_USB0S_SHIFT   22
#define LPD_SLCR_ERR_AIBAXI_IER_USB0S_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_USB0S_MASK    ((u32)0X00400000U)

#define LPD_SLCR_ERR_AIBAXI_IER_RPUS1_SHIFT   19
#define LPD_SLCR_ERR_AIBAXI_IER_RPUS1_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_RPUS1_MASK    ((u32)0X00080000U)

#define LPD_SLCR_ERR_AIBAXI_IER_RPUS0_SHIFT   18
#define LPD_SLCR_ERR_AIBAXI_IER_RPUS0_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_RPUS0_MASK    ((u32)0X00040000U)

#define LPD_SLCR_ERR_AIBAXI_IER_RPUM1_SHIFT   17
#define LPD_SLCR_ERR_AIBAXI_IER_RPUM1_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_RPUM1_MASK    ((u32)0X00020000U)

#define LPD_SLCR_ERR_AIBAXI_IER_RPUM0_SHIFT   16
#define LPD_SLCR_ERR_AIBAXI_IER_RPUM0_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_RPUM0_MASK    ((u32)0X00010000U)

#define LPD_SLCR_ERR_AIBAXI_IER_FPD_OCM_SHIFT   3
#define LPD_SLCR_ERR_AIBAXI_IER_FPD_OCM_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_FPD_OCM_MASK    ((u32)0X00000008U)

#define LPD_SLCR_ERR_AIBAXI_IER_FPD_LPDIBS_SHIFT   2
#define LPD_SLCR_ERR_AIBAXI_IER_FPD_LPDIBS_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_FPD_LPDIBS_MASK    ((u32)0X00000004U)

#define LPD_SLCR_ERR_AIBAXI_IER_AFIFS1_SHIFT   1
#define LPD_SLCR_ERR_AIBAXI_IER_AFIFS1_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_AFIFS1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ERR_AIBAXI_IER_AFIFS0_SHIFT   0
#define LPD_SLCR_ERR_AIBAXI_IER_AFIFS0_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IER_AFIFS0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ERR_AIBAXI_IDR
 */
#define LPD_SLCR_ERR_AIBAXI_IDR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00003018U) )

#define LPD_SLCR_ERR_AIBAXI_IDR_AFIFS2_SHIFT   28
#define LPD_SLCR_ERR_AIBAXI_IDR_AFIFS2_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_AFIFS2_MASK    ((u32)0X10000000U)

#define LPD_SLCR_ERR_AIBAXI_IDR_LPD_DDR_SHIFT   27
#define LPD_SLCR_ERR_AIBAXI_IDR_LPD_DDR_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_LPD_DDR_MASK    ((u32)0X08000000U)

#define LPD_SLCR_ERR_AIBAXI_IDR_OCMS_SHIFT   26
#define LPD_SLCR_ERR_AIBAXI_IDR_OCMS_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_OCMS_MASK    ((u32)0X04000000U)

#define LPD_SLCR_ERR_AIBAXI_IDR_FPD_MAIN_SHIFT   24
#define LPD_SLCR_ERR_AIBAXI_IDR_FPD_MAIN_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_FPD_MAIN_MASK    ((u32)0X01000000U)

#define LPD_SLCR_ERR_AIBAXI_IDR_USB1S_SHIFT   23
#define LPD_SLCR_ERR_AIBAXI_IDR_USB1S_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_USB1S_MASK    ((u32)0X00800000U)

#define LPD_SLCR_ERR_AIBAXI_IDR_USB0S_SHIFT   22
#define LPD_SLCR_ERR_AIBAXI_IDR_USB0S_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_USB0S_MASK    ((u32)0X00400000U)

#define LPD_SLCR_ERR_AIBAXI_IDR_RPUS1_SHIFT   19
#define LPD_SLCR_ERR_AIBAXI_IDR_RPUS1_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_RPUS1_MASK    ((u32)0X00080000U)

#define LPD_SLCR_ERR_AIBAXI_IDR_RPUS0_SHIFT   18
#define LPD_SLCR_ERR_AIBAXI_IDR_RPUS0_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_RPUS0_MASK    ((u32)0X00040000U)

#define LPD_SLCR_ERR_AIBAXI_IDR_RPUM1_SHIFT   17
#define LPD_SLCR_ERR_AIBAXI_IDR_RPUM1_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_RPUM1_MASK    ((u32)0X00020000U)

#define LPD_SLCR_ERR_AIBAXI_IDR_RPUM0_SHIFT   16
#define LPD_SLCR_ERR_AIBAXI_IDR_RPUM0_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_RPUM0_MASK    ((u32)0X00010000U)

#define LPD_SLCR_ERR_AIBAXI_IDR_FPD_OCM_SHIFT   3
#define LPD_SLCR_ERR_AIBAXI_IDR_FPD_OCM_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_FPD_OCM_MASK    ((u32)0X00000008U)

#define LPD_SLCR_ERR_AIBAXI_IDR_FPD_LPDIBS_SHIFT   2
#define LPD_SLCR_ERR_AIBAXI_IDR_FPD_LPDIBS_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_FPD_LPDIBS_MASK    ((u32)0X00000004U)

#define LPD_SLCR_ERR_AIBAXI_IDR_AFIFS1_SHIFT   1
#define LPD_SLCR_ERR_AIBAXI_IDR_AFIFS1_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_AFIFS1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ERR_AIBAXI_IDR_AFIFS0_SHIFT   0
#define LPD_SLCR_ERR_AIBAXI_IDR_AFIFS0_WIDTH   1
#define LPD_SLCR_ERR_AIBAXI_IDR_AFIFS0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ERR_AIBAPB_ISR
 */
#define LPD_SLCR_ERR_AIBAPB_ISR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00003020U) )

#define LPD_SLCR_ERR_AIBAPB_ISR_GPU_SHIFT   0
#define LPD_SLCR_ERR_AIBAPB_ISR_GPU_WIDTH   1
#define LPD_SLCR_ERR_AIBAPB_ISR_GPU_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ERR_AIBAPB_IMR
 */
#define LPD_SLCR_ERR_AIBAPB_IMR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00003024U) )

#define LPD_SLCR_ERR_AIBAPB_IMR_GPU_SHIFT   0
#define LPD_SLCR_ERR_AIBAPB_IMR_GPU_WIDTH   1
#define LPD_SLCR_ERR_AIBAPB_IMR_GPU_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ERR_AIBAPB_IER
 */
#define LPD_SLCR_ERR_AIBAPB_IER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00003028U) )

#define LPD_SLCR_ERR_AIBAPB_IER_GPU_SHIFT   0
#define LPD_SLCR_ERR_AIBAPB_IER_GPU_WIDTH   1
#define LPD_SLCR_ERR_AIBAPB_IER_GPU_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ERR_AIBAPB_IDR
 */
#define LPD_SLCR_ERR_AIBAPB_IDR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000302CU) )

#define LPD_SLCR_ERR_AIBAPB_IDR_GPU_SHIFT   0
#define LPD_SLCR_ERR_AIBAPB_IDR_GPU_WIDTH   1
#define LPD_SLCR_ERR_AIBAPB_IDR_GPU_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ISO_AIBAXI_REQ
 */
#define LPD_SLCR_ISO_AIBAXI_REQ    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00003030U) )

#define LPD_SLCR_ISO_AIBAXI_REQ_AFIFS2_SHIFT   28
#define LPD_SLCR_ISO_AIBAXI_REQ_AFIFS2_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_AFIFS2_MASK    ((u32)0X10000000U)

#define LPD_SLCR_ISO_AIBAXI_REQ_LPD_DDR_SHIFT   27
#define LPD_SLCR_ISO_AIBAXI_REQ_LPD_DDR_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_LPD_DDR_MASK    ((u32)0X08000000U)

#define LPD_SLCR_ISO_AIBAXI_REQ_OCMS_SHIFT   26
#define LPD_SLCR_ISO_AIBAXI_REQ_OCMS_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_OCMS_MASK    ((u32)0X04000000U)

#define LPD_SLCR_ISO_AIBAXI_REQ_FPD_MAIN_SHIFT   24
#define LPD_SLCR_ISO_AIBAXI_REQ_FPD_MAIN_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_FPD_MAIN_MASK    ((u32)0X01000000U)

#define LPD_SLCR_ISO_AIBAXI_REQ_USB1S_SHIFT   23
#define LPD_SLCR_ISO_AIBAXI_REQ_USB1S_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_USB1S_MASK    ((u32)0X00800000U)

#define LPD_SLCR_ISO_AIBAXI_REQ_USB0S_SHIFT   22
#define LPD_SLCR_ISO_AIBAXI_REQ_USB0S_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_USB0S_MASK    ((u32)0X00400000U)

#define LPD_SLCR_ISO_AIBAXI_REQ_RPUS1_SHIFT   19
#define LPD_SLCR_ISO_AIBAXI_REQ_RPUS1_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_RPUS1_MASK    ((u32)0X00080000U)

#define LPD_SLCR_ISO_AIBAXI_REQ_RPUS0_SHIFT   18
#define LPD_SLCR_ISO_AIBAXI_REQ_RPUS0_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_RPUS0_MASK    ((u32)0X00040000U)

#define LPD_SLCR_ISO_AIBAXI_REQ_RPUM1_SHIFT   17
#define LPD_SLCR_ISO_AIBAXI_REQ_RPUM1_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_RPUM1_MASK    ((u32)0X00020000U)

#define LPD_SLCR_ISO_AIBAXI_REQ_RPUM0_SHIFT   16
#define LPD_SLCR_ISO_AIBAXI_REQ_RPUM0_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_RPUM0_MASK    ((u32)0X00010000U)

#define LPD_SLCR_ISO_AIBAXI_REQ_FPD_OCM_SHIFT   3
#define LPD_SLCR_ISO_AIBAXI_REQ_FPD_OCM_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_FPD_OCM_MASK    ((u32)0X00000008U)

#define LPD_SLCR_ISO_AIBAXI_REQ_FPD_LPDIBS_SHIFT   2
#define LPD_SLCR_ISO_AIBAXI_REQ_FPD_LPDIBS_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_FPD_LPDIBS_MASK    ((u32)0X00000004U)

#define LPD_SLCR_ISO_AIBAXI_REQ_AFIFS1_SHIFT   1
#define LPD_SLCR_ISO_AIBAXI_REQ_AFIFS1_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_AFIFS1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ISO_AIBAXI_REQ_AFIFS0_SHIFT   0
#define LPD_SLCR_ISO_AIBAXI_REQ_AFIFS0_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_REQ_AFIFS0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ISO_AIBAXI_TYPE
 */
#define LPD_SLCR_ISO_AIBAXI_TYPE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00003038U) )

#define LPD_SLCR_ISO_AIBAXI_TYPE_AFIFS2_SHIFT   28
#define LPD_SLCR_ISO_AIBAXI_TYPE_AFIFS2_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_AFIFS2_MASK    ((u32)0X10000000U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_LPD_DDR_SHIFT   27
#define LPD_SLCR_ISO_AIBAXI_TYPE_LPD_DDR_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_LPD_DDR_MASK    ((u32)0X08000000U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_OCMS_SHIFT   26
#define LPD_SLCR_ISO_AIBAXI_TYPE_OCMS_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_OCMS_MASK    ((u32)0X04000000U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_FPD_MAIN_SHIFT   24
#define LPD_SLCR_ISO_AIBAXI_TYPE_FPD_MAIN_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_FPD_MAIN_MASK    ((u32)0X01000000U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_USB1S_SHIFT   23
#define LPD_SLCR_ISO_AIBAXI_TYPE_USB1S_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_USB1S_MASK    ((u32)0X00800000U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_USB0S_SHIFT   22
#define LPD_SLCR_ISO_AIBAXI_TYPE_USB0S_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_USB0S_MASK    ((u32)0X00400000U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_RPUS1_SHIFT   19
#define LPD_SLCR_ISO_AIBAXI_TYPE_RPUS1_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_RPUS1_MASK    ((u32)0X00080000U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_RPUS0_SHIFT   18
#define LPD_SLCR_ISO_AIBAXI_TYPE_RPUS0_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_RPUS0_MASK    ((u32)0X00040000U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_RPUM1_SHIFT   17
#define LPD_SLCR_ISO_AIBAXI_TYPE_RPUM1_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_RPUM1_MASK    ((u32)0X00020000U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_RPUM0_SHIFT   16
#define LPD_SLCR_ISO_AIBAXI_TYPE_RPUM0_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_RPUM0_MASK    ((u32)0X00010000U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_FPD_OCM_SHIFT   3
#define LPD_SLCR_ISO_AIBAXI_TYPE_FPD_OCM_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_FPD_OCM_MASK    ((u32)0X00000008U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_FPD_LPDIBS_SHIFT   2
#define LPD_SLCR_ISO_AIBAXI_TYPE_FPD_LPDIBS_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_FPD_LPDIBS_MASK    ((u32)0X00000004U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_AFIFS1_SHIFT   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_AFIFS1_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_AFIFS1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ISO_AIBAXI_TYPE_AFIFS0_SHIFT   0
#define LPD_SLCR_ISO_AIBAXI_TYPE_AFIFS0_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_TYPE_AFIFS0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ISO_AIBAXI_ACK
 */
#define LPD_SLCR_ISO_AIBAXI_ACK    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00003040U) )

#define LPD_SLCR_ISO_AIBAXI_ACK_AFIFS2_SHIFT   28
#define LPD_SLCR_ISO_AIBAXI_ACK_AFIFS2_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_AFIFS2_MASK    ((u32)0X10000000U)

#define LPD_SLCR_ISO_AIBAXI_ACK_LPD_DDR_SHIFT   27
#define LPD_SLCR_ISO_AIBAXI_ACK_LPD_DDR_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_LPD_DDR_MASK    ((u32)0X08000000U)

#define LPD_SLCR_ISO_AIBAXI_ACK_OCMS_SHIFT   26
#define LPD_SLCR_ISO_AIBAXI_ACK_OCMS_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_OCMS_MASK    ((u32)0X04000000U)

#define LPD_SLCR_ISO_AIBAXI_ACK_FPD_MAIN_SHIFT   24
#define LPD_SLCR_ISO_AIBAXI_ACK_FPD_MAIN_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_FPD_MAIN_MASK    ((u32)0X01000000U)

#define LPD_SLCR_ISO_AIBAXI_ACK_USB1S_SHIFT   23
#define LPD_SLCR_ISO_AIBAXI_ACK_USB1S_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_USB1S_MASK    ((u32)0X00800000U)

#define LPD_SLCR_ISO_AIBAXI_ACK_USB0S_SHIFT   22
#define LPD_SLCR_ISO_AIBAXI_ACK_USB0S_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_USB0S_MASK    ((u32)0X00400000U)

#define LPD_SLCR_ISO_AIBAXI_ACK_RPUS1_SHIFT   19
#define LPD_SLCR_ISO_AIBAXI_ACK_RPUS1_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_RPUS1_MASK    ((u32)0X00080000U)

#define LPD_SLCR_ISO_AIBAXI_ACK_RPUS0_SHIFT   18
#define LPD_SLCR_ISO_AIBAXI_ACK_RPUS0_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_RPUS0_MASK    ((u32)0X00040000U)

#define LPD_SLCR_ISO_AIBAXI_ACK_RPUM1_SHIFT   17
#define LPD_SLCR_ISO_AIBAXI_ACK_RPUM1_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_RPUM1_MASK    ((u32)0X00020000U)

#define LPD_SLCR_ISO_AIBAXI_ACK_RPUM0_SHIFT   16
#define LPD_SLCR_ISO_AIBAXI_ACK_RPUM0_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_RPUM0_MASK    ((u32)0X00010000U)

#define LPD_SLCR_ISO_AIBAXI_ACK_FPD_OCM_SHIFT   3
#define LPD_SLCR_ISO_AIBAXI_ACK_FPD_OCM_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_FPD_OCM_MASK    ((u32)0X00000008U)

#define LPD_SLCR_ISO_AIBAXI_ACK_FPD_LPDIBS_SHIFT   2
#define LPD_SLCR_ISO_AIBAXI_ACK_FPD_LPDIBS_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_FPD_LPDIBS_MASK    ((u32)0X00000004U)

#define LPD_SLCR_ISO_AIBAXI_ACK_AFIFS1_SHIFT   1
#define LPD_SLCR_ISO_AIBAXI_ACK_AFIFS1_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_AFIFS1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ISO_AIBAXI_ACK_AFIFS0_SHIFT   0
#define LPD_SLCR_ISO_AIBAXI_ACK_AFIFS0_WIDTH   1
#define LPD_SLCR_ISO_AIBAXI_ACK_AFIFS0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ISO_AIBAPB_REQ
 */
#define LPD_SLCR_ISO_AIBAPB_REQ    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00003048U) )

#define LPD_SLCR_ISO_AIBAPB_REQ_GPU_SHIFT   0
#define LPD_SLCR_ISO_AIBAPB_REQ_GPU_WIDTH   1
#define LPD_SLCR_ISO_AIBAPB_REQ_GPU_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ISO_AIBAPB_TYPE
 */
#define LPD_SLCR_ISO_AIBAPB_TYPE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000304CU) )

#define LPD_SLCR_ISO_AIBAPB_TYPE_GPU_SHIFT   0
#define LPD_SLCR_ISO_AIBAPB_TYPE_GPU_WIDTH   1
#define LPD_SLCR_ISO_AIBAPB_TYPE_GPU_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ISO_AIBAPB_ACK
 */
#define LPD_SLCR_ISO_AIBAPB_ACK    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00003050U) )

#define LPD_SLCR_ISO_AIBAPB_ACK_GPU_SHIFT   0
#define LPD_SLCR_ISO_AIBAPB_ACK_GPU_WIDTH   1
#define LPD_SLCR_ISO_AIBAPB_ACK_GPU_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ERR_ATB_ISR
 */
#define LPD_SLCR_ERR_ATB_ISR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00006000U) )

#define LPD_SLCR_ERR_ATB_ISR_AFIFS2_SHIFT   1
#define LPD_SLCR_ERR_ATB_ISR_AFIFS2_WIDTH   1
#define LPD_SLCR_ERR_ATB_ISR_AFIFS2_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ERR_ATB_ISR_LPDM_SHIFT   0
#define LPD_SLCR_ERR_ATB_ISR_LPDM_WIDTH   1
#define LPD_SLCR_ERR_ATB_ISR_LPDM_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ERR_ATB_IMR
 */
#define LPD_SLCR_ERR_ATB_IMR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00006004U) )

#define LPD_SLCR_ERR_ATB_IMR_AFIFS2_SHIFT   1
#define LPD_SLCR_ERR_ATB_IMR_AFIFS2_WIDTH   1
#define LPD_SLCR_ERR_ATB_IMR_AFIFS2_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ERR_ATB_IMR_LPDM_SHIFT   0
#define LPD_SLCR_ERR_ATB_IMR_LPDM_WIDTH   1
#define LPD_SLCR_ERR_ATB_IMR_LPDM_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ERR_ATB_IER
 */
#define LPD_SLCR_ERR_ATB_IER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00006008U) )

#define LPD_SLCR_ERR_ATB_IER_AFIFS2_SHIFT   1
#define LPD_SLCR_ERR_ATB_IER_AFIFS2_WIDTH   1
#define LPD_SLCR_ERR_ATB_IER_AFIFS2_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ERR_ATB_IER_LPDM_SHIFT   0
#define LPD_SLCR_ERR_ATB_IER_LPDM_WIDTH   1
#define LPD_SLCR_ERR_ATB_IER_LPDM_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ERR_ATB_IDR
 */
#define LPD_SLCR_ERR_ATB_IDR    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000600CU) )

#define LPD_SLCR_ERR_ATB_IDR_AFIFS2_SHIFT   1
#define LPD_SLCR_ERR_ATB_IDR_AFIFS2_WIDTH   1
#define LPD_SLCR_ERR_ATB_IDR_AFIFS2_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ERR_ATB_IDR_LPDM_SHIFT   0
#define LPD_SLCR_ERR_ATB_IDR_LPDM_WIDTH   1
#define LPD_SLCR_ERR_ATB_IDR_LPDM_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ATB_CMD_STORE_EN
 */
#define LPD_SLCR_ATB_CMD_STORE_EN    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00006010U) )

#define LPD_SLCR_ATB_CMD_STORE_EN_AFIFS2_SHIFT   1
#define LPD_SLCR_ATB_CMD_STORE_EN_AFIFS2_WIDTH   1
#define LPD_SLCR_ATB_CMD_STORE_EN_AFIFS2_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ATB_CMD_STORE_EN_LPDM_SHIFT   0
#define LPD_SLCR_ATB_CMD_STORE_EN_LPDM_WIDTH   1
#define LPD_SLCR_ATB_CMD_STORE_EN_LPDM_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ATB_RESP_EN
 */
#define LPD_SLCR_ATB_RESP_EN    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00006014U) )

#define LPD_SLCR_ATB_RESP_EN_AFIFS2_SHIFT   1
#define LPD_SLCR_ATB_RESP_EN_AFIFS2_WIDTH   1
#define LPD_SLCR_ATB_RESP_EN_AFIFS2_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ATB_RESP_EN_LPDM_SHIFT   0
#define LPD_SLCR_ATB_RESP_EN_LPDM_WIDTH   1
#define LPD_SLCR_ATB_RESP_EN_LPDM_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ATB_RESP_TYPE
 */
#define LPD_SLCR_ATB_RESP_TYPE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00006018U) )

#define LPD_SLCR_ATB_RESP_TYPE_AFIFS2_SHIFT   1
#define LPD_SLCR_ATB_RESP_TYPE_AFIFS2_WIDTH   1
#define LPD_SLCR_ATB_RESP_TYPE_AFIFS2_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ATB_RESP_TYPE_LPDM_SHIFT   0
#define LPD_SLCR_ATB_RESP_TYPE_LPDM_WIDTH   1
#define LPD_SLCR_ATB_RESP_TYPE_LPDM_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ATB_ERR_INJECT
 */
#define LPD_SLCR_ATB_ERR_INJECT    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000601CU) )

#define LPD_SLCR_ATB_ERR_INJECT_AFIFS2_SHIFT   1
#define LPD_SLCR_ATB_ERR_INJECT_AFIFS2_WIDTH   1
#define LPD_SLCR_ATB_ERR_INJECT_AFIFS2_MASK    ((u32)0X00000002U)

#define LPD_SLCR_ATB_ERR_INJECT_LPDM_SHIFT   0
#define LPD_SLCR_ATB_ERR_INJECT_LPDM_WIDTH   1
#define LPD_SLCR_ATB_ERR_INJECT_LPDM_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_ATB_PRESCALE
 */
#define LPD_SLCR_ATB_PRESCALE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00006020U) )

#define LPD_SLCR_ATB_PRESCALE_ENABLE_SHIFT   16
#define LPD_SLCR_ATB_PRESCALE_ENABLE_WIDTH   1
#define LPD_SLCR_ATB_PRESCALE_ENABLE_MASK    ((u32)0X00010000U)

#define LPD_SLCR_ATB_PRESCALE_VALUE_SHIFT   0
#define LPD_SLCR_ATB_PRESCALE_VALUE_WIDTH   16
#define LPD_SLCR_ATB_PRESCALE_VALUE_MASK    ((u32)0X0000FFFFU)

/**
 * Register: LPD_SLCR_MUTEX0
 */
#define LPD_SLCR_MUTEX0    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00007000U) )

#define LPD_SLCR_MUTEX0_ID_SHIFT   0
#define LPD_SLCR_MUTEX0_ID_WIDTH   32
#define LPD_SLCR_MUTEX0_ID_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_MUTEX1
 */
#define LPD_SLCR_MUTEX1    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00007004U) )

#define LPD_SLCR_MUTEX1_ID_SHIFT   0
#define LPD_SLCR_MUTEX1_ID_WIDTH   32
#define LPD_SLCR_MUTEX1_ID_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_MUTEX2
 */
#define LPD_SLCR_MUTEX2    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00007008U) )

#define LPD_SLCR_MUTEX2_ID_SHIFT   0
#define LPD_SLCR_MUTEX2_ID_WIDTH   32
#define LPD_SLCR_MUTEX2_ID_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_MUTEX3
 */
#define LPD_SLCR_MUTEX3    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000700CU) )

#define LPD_SLCR_MUTEX3_ID_SHIFT   0
#define LPD_SLCR_MUTEX3_ID_WIDTH   32
#define LPD_SLCR_MUTEX3_ID_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: LPD_SLCR_GICP0_IRQ_STATUS
 */
#define LPD_SLCR_GICP0_IRQ_STATUS    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008000U) )

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC31_SHIFT   31
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC31_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC30_SHIFT   30
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC30_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC29_SHIFT   29
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC29_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC28_SHIFT   28
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC28_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC27_SHIFT   27
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC27_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC26_SHIFT   26
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC26_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC25_SHIFT   25
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC25_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC24_SHIFT   24
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC24_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC23_SHIFT   23
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC23_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC22_SHIFT   22
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC22_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC21_SHIFT   21
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC21_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC20_SHIFT   20
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC20_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC19_SHIFT   19
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC19_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC18_SHIFT   18
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC18_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC17_SHIFT   17
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC17_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC16_SHIFT   16
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC16_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC15_SHIFT   15
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC15_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC14_SHIFT   14
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC14_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC13_SHIFT   13
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC13_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC12_SHIFT   12
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC12_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC11_SHIFT   11
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC11_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC10_SHIFT   10
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC10_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC9_SHIFT   9
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC9_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC8_SHIFT   8
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC8_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC7_SHIFT   7
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC7_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC6_SHIFT   6
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC6_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC5_SHIFT   5
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC5_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC4_SHIFT   4
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC4_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC3_SHIFT   3
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC3_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC2_SHIFT   2
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC2_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC1_SHIFT   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC1_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP0_IRQ_STATUS_SRC0_SHIFT   0
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC0_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_STATUS_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP0_IRQ_MASK
 */
#define LPD_SLCR_GICP0_IRQ_MASK    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008004U) )

#define LPD_SLCR_GICP0_IRQ_MASK_SRC31_SHIFT   31
#define LPD_SLCR_GICP0_IRQ_MASK_SRC31_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC30_SHIFT   30
#define LPD_SLCR_GICP0_IRQ_MASK_SRC30_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC29_SHIFT   29
#define LPD_SLCR_GICP0_IRQ_MASK_SRC29_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC28_SHIFT   28
#define LPD_SLCR_GICP0_IRQ_MASK_SRC28_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC27_SHIFT   27
#define LPD_SLCR_GICP0_IRQ_MASK_SRC27_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC26_SHIFT   26
#define LPD_SLCR_GICP0_IRQ_MASK_SRC26_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC25_SHIFT   25
#define LPD_SLCR_GICP0_IRQ_MASK_SRC25_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC24_SHIFT   24
#define LPD_SLCR_GICP0_IRQ_MASK_SRC24_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC23_SHIFT   23
#define LPD_SLCR_GICP0_IRQ_MASK_SRC23_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC22_SHIFT   22
#define LPD_SLCR_GICP0_IRQ_MASK_SRC22_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC21_SHIFT   21
#define LPD_SLCR_GICP0_IRQ_MASK_SRC21_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC20_SHIFT   20
#define LPD_SLCR_GICP0_IRQ_MASK_SRC20_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC19_SHIFT   19
#define LPD_SLCR_GICP0_IRQ_MASK_SRC19_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC18_SHIFT   18
#define LPD_SLCR_GICP0_IRQ_MASK_SRC18_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC17_SHIFT   17
#define LPD_SLCR_GICP0_IRQ_MASK_SRC17_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC16_SHIFT   16
#define LPD_SLCR_GICP0_IRQ_MASK_SRC16_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC15_SHIFT   15
#define LPD_SLCR_GICP0_IRQ_MASK_SRC15_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC14_SHIFT   14
#define LPD_SLCR_GICP0_IRQ_MASK_SRC14_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC13_SHIFT   13
#define LPD_SLCR_GICP0_IRQ_MASK_SRC13_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC12_SHIFT   12
#define LPD_SLCR_GICP0_IRQ_MASK_SRC12_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC11_SHIFT   11
#define LPD_SLCR_GICP0_IRQ_MASK_SRC11_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC10_SHIFT   10
#define LPD_SLCR_GICP0_IRQ_MASK_SRC10_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC9_SHIFT   9
#define LPD_SLCR_GICP0_IRQ_MASK_SRC9_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC8_SHIFT   8
#define LPD_SLCR_GICP0_IRQ_MASK_SRC8_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC7_SHIFT   7
#define LPD_SLCR_GICP0_IRQ_MASK_SRC7_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC6_SHIFT   6
#define LPD_SLCR_GICP0_IRQ_MASK_SRC6_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC5_SHIFT   5
#define LPD_SLCR_GICP0_IRQ_MASK_SRC5_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC4_SHIFT   4
#define LPD_SLCR_GICP0_IRQ_MASK_SRC4_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC3_SHIFT   3
#define LPD_SLCR_GICP0_IRQ_MASK_SRC3_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC2_SHIFT   2
#define LPD_SLCR_GICP0_IRQ_MASK_SRC2_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC1_SHIFT   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC1_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP0_IRQ_MASK_SRC0_SHIFT   0
#define LPD_SLCR_GICP0_IRQ_MASK_SRC0_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_MASK_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP0_IRQ_ENABLE
 */
#define LPD_SLCR_GICP0_IRQ_ENABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008008U) )

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_ENABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP0_IRQ_DISABLE
 */
#define LPD_SLCR_GICP0_IRQ_DISABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000800CU) )

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_DISABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP0_IRQ_TRIGGER
 */
#define LPD_SLCR_GICP0_IRQ_TRIGGER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008010U) )

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC31_SHIFT   31
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC31_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC30_SHIFT   30
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC30_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC29_SHIFT   29
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC29_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC28_SHIFT   28
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC28_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC27_SHIFT   27
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC27_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC26_SHIFT   26
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC26_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC25_SHIFT   25
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC25_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC24_SHIFT   24
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC24_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC23_SHIFT   23
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC23_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC22_SHIFT   22
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC22_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC21_SHIFT   21
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC21_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC20_SHIFT   20
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC20_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC19_SHIFT   19
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC19_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC18_SHIFT   18
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC18_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC17_SHIFT   17
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC17_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC16_SHIFT   16
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC16_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC15_SHIFT   15
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC15_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC14_SHIFT   14
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC14_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC13_SHIFT   13
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC13_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC12_SHIFT   12
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC12_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC11_SHIFT   11
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC11_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC10_SHIFT   10
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC10_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC9_SHIFT   9
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC9_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC8_SHIFT   8
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC8_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC7_SHIFT   7
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC7_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC6_SHIFT   6
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC6_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC5_SHIFT   5
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC5_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC4_SHIFT   4
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC4_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC3_SHIFT   3
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC3_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC2_SHIFT   2
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC2_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC1_SHIFT   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC1_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC0_SHIFT   0
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC0_WIDTH   1
#define LPD_SLCR_GICP0_IRQ_TRIGGER_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP1_IRQ_STATUS
 */
#define LPD_SLCR_GICP1_IRQ_STATUS    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008014U) )

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC31_SHIFT   31
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC31_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC30_SHIFT   30
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC30_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC29_SHIFT   29
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC29_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC28_SHIFT   28
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC28_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC27_SHIFT   27
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC27_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC26_SHIFT   26
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC26_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC25_SHIFT   25
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC25_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC24_SHIFT   24
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC24_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC23_SHIFT   23
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC23_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC22_SHIFT   22
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC22_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC21_SHIFT   21
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC21_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC20_SHIFT   20
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC20_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC19_SHIFT   19
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC19_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC18_SHIFT   18
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC18_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC17_SHIFT   17
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC17_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC16_SHIFT   16
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC16_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC15_SHIFT   15
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC15_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC14_SHIFT   14
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC14_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC13_SHIFT   13
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC13_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC12_SHIFT   12
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC12_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC11_SHIFT   11
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC11_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC10_SHIFT   10
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC10_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC9_SHIFT   9
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC9_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC8_SHIFT   8
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC8_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC7_SHIFT   7
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC7_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC6_SHIFT   6
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC6_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC5_SHIFT   5
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC5_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC4_SHIFT   4
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC4_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC3_SHIFT   3
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC3_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC2_SHIFT   2
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC2_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC1_SHIFT   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC1_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP1_IRQ_STATUS_SRC0_SHIFT   0
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC0_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_STATUS_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP1_IRQ_MASK
 */
#define LPD_SLCR_GICP1_IRQ_MASK    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008018U) )

#define LPD_SLCR_GICP1_IRQ_MASK_SRC31_SHIFT   31
#define LPD_SLCR_GICP1_IRQ_MASK_SRC31_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC30_SHIFT   30
#define LPD_SLCR_GICP1_IRQ_MASK_SRC30_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC29_SHIFT   29
#define LPD_SLCR_GICP1_IRQ_MASK_SRC29_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC28_SHIFT   28
#define LPD_SLCR_GICP1_IRQ_MASK_SRC28_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC27_SHIFT   27
#define LPD_SLCR_GICP1_IRQ_MASK_SRC27_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC26_SHIFT   26
#define LPD_SLCR_GICP1_IRQ_MASK_SRC26_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC25_SHIFT   25
#define LPD_SLCR_GICP1_IRQ_MASK_SRC25_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC24_SHIFT   24
#define LPD_SLCR_GICP1_IRQ_MASK_SRC24_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC23_SHIFT   23
#define LPD_SLCR_GICP1_IRQ_MASK_SRC23_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC22_SHIFT   22
#define LPD_SLCR_GICP1_IRQ_MASK_SRC22_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC21_SHIFT   21
#define LPD_SLCR_GICP1_IRQ_MASK_SRC21_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC20_SHIFT   20
#define LPD_SLCR_GICP1_IRQ_MASK_SRC20_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC19_SHIFT   19
#define LPD_SLCR_GICP1_IRQ_MASK_SRC19_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC18_SHIFT   18
#define LPD_SLCR_GICP1_IRQ_MASK_SRC18_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC17_SHIFT   17
#define LPD_SLCR_GICP1_IRQ_MASK_SRC17_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC16_SHIFT   16
#define LPD_SLCR_GICP1_IRQ_MASK_SRC16_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC15_SHIFT   15
#define LPD_SLCR_GICP1_IRQ_MASK_SRC15_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC14_SHIFT   14
#define LPD_SLCR_GICP1_IRQ_MASK_SRC14_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC13_SHIFT   13
#define LPD_SLCR_GICP1_IRQ_MASK_SRC13_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC12_SHIFT   12
#define LPD_SLCR_GICP1_IRQ_MASK_SRC12_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC11_SHIFT   11
#define LPD_SLCR_GICP1_IRQ_MASK_SRC11_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC10_SHIFT   10
#define LPD_SLCR_GICP1_IRQ_MASK_SRC10_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC9_SHIFT   9
#define LPD_SLCR_GICP1_IRQ_MASK_SRC9_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC8_SHIFT   8
#define LPD_SLCR_GICP1_IRQ_MASK_SRC8_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC7_SHIFT   7
#define LPD_SLCR_GICP1_IRQ_MASK_SRC7_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC6_SHIFT   6
#define LPD_SLCR_GICP1_IRQ_MASK_SRC6_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC5_SHIFT   5
#define LPD_SLCR_GICP1_IRQ_MASK_SRC5_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC4_SHIFT   4
#define LPD_SLCR_GICP1_IRQ_MASK_SRC4_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC3_SHIFT   3
#define LPD_SLCR_GICP1_IRQ_MASK_SRC3_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC2_SHIFT   2
#define LPD_SLCR_GICP1_IRQ_MASK_SRC2_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC1_SHIFT   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC1_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP1_IRQ_MASK_SRC0_SHIFT   0
#define LPD_SLCR_GICP1_IRQ_MASK_SRC0_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_MASK_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP1_IRQ_ENABLE
 */
#define LPD_SLCR_GICP1_IRQ_ENABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000801CU) )

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_ENABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP1_IRQ_DISABLE
 */
#define LPD_SLCR_GICP1_IRQ_DISABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008020U) )

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_DISABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP1_IRQ_TRIGGER
 */
#define LPD_SLCR_GICP1_IRQ_TRIGGER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008024U) )

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC31_SHIFT   31
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC31_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC30_SHIFT   30
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC30_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC29_SHIFT   29
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC29_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC28_SHIFT   28
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC28_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC27_SHIFT   27
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC27_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC26_SHIFT   26
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC26_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC25_SHIFT   25
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC25_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC24_SHIFT   24
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC24_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC23_SHIFT   23
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC23_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC22_SHIFT   22
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC22_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC21_SHIFT   21
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC21_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC20_SHIFT   20
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC20_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC19_SHIFT   19
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC19_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC18_SHIFT   18
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC18_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC17_SHIFT   17
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC17_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC16_SHIFT   16
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC16_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC15_SHIFT   15
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC15_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC14_SHIFT   14
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC14_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC13_SHIFT   13
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC13_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC12_SHIFT   12
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC12_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC11_SHIFT   11
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC11_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC10_SHIFT   10
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC10_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC9_SHIFT   9
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC9_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC8_SHIFT   8
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC8_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC7_SHIFT   7
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC7_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC6_SHIFT   6
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC6_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC5_SHIFT   5
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC5_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC4_SHIFT   4
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC4_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC3_SHIFT   3
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC3_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC2_SHIFT   2
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC2_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC1_SHIFT   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC1_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC0_SHIFT   0
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC0_WIDTH   1
#define LPD_SLCR_GICP1_IRQ_TRIGGER_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP2_IRQ_STATUS
 */
#define LPD_SLCR_GICP2_IRQ_STATUS    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008028U) )

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC31_SHIFT   31
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC31_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC30_SHIFT   30
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC30_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC29_SHIFT   29
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC29_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC28_SHIFT   28
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC28_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC27_SHIFT   27
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC27_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC26_SHIFT   26
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC26_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC25_SHIFT   25
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC25_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC24_SHIFT   24
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC24_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC23_SHIFT   23
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC23_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC22_SHIFT   22
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC22_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC21_SHIFT   21
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC21_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC20_SHIFT   20
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC20_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC19_SHIFT   19
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC19_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC18_SHIFT   18
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC18_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC17_SHIFT   17
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC17_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC16_SHIFT   16
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC16_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC15_SHIFT   15
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC15_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC14_SHIFT   14
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC14_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC13_SHIFT   13
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC13_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC12_SHIFT   12
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC12_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC11_SHIFT   11
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC11_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC10_SHIFT   10
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC10_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC9_SHIFT   9
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC9_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC8_SHIFT   8
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC8_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC7_SHIFT   7
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC7_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC6_SHIFT   6
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC6_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC5_SHIFT   5
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC5_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC4_SHIFT   4
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC4_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC3_SHIFT   3
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC3_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC2_SHIFT   2
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC2_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC1_SHIFT   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC1_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP2_IRQ_STATUS_SRC0_SHIFT   0
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC0_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_STATUS_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP2_IRQ_MASK
 */
#define LPD_SLCR_GICP2_IRQ_MASK    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000802CU) )

#define LPD_SLCR_GICP2_IRQ_MASK_SRC31_SHIFT   31
#define LPD_SLCR_GICP2_IRQ_MASK_SRC31_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC30_SHIFT   30
#define LPD_SLCR_GICP2_IRQ_MASK_SRC30_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC29_SHIFT   29
#define LPD_SLCR_GICP2_IRQ_MASK_SRC29_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC28_SHIFT   28
#define LPD_SLCR_GICP2_IRQ_MASK_SRC28_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC27_SHIFT   27
#define LPD_SLCR_GICP2_IRQ_MASK_SRC27_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC26_SHIFT   26
#define LPD_SLCR_GICP2_IRQ_MASK_SRC26_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC25_SHIFT   25
#define LPD_SLCR_GICP2_IRQ_MASK_SRC25_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC24_SHIFT   24
#define LPD_SLCR_GICP2_IRQ_MASK_SRC24_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC23_SHIFT   23
#define LPD_SLCR_GICP2_IRQ_MASK_SRC23_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC22_SHIFT   22
#define LPD_SLCR_GICP2_IRQ_MASK_SRC22_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC21_SHIFT   21
#define LPD_SLCR_GICP2_IRQ_MASK_SRC21_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC20_SHIFT   20
#define LPD_SLCR_GICP2_IRQ_MASK_SRC20_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC19_SHIFT   19
#define LPD_SLCR_GICP2_IRQ_MASK_SRC19_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC18_SHIFT   18
#define LPD_SLCR_GICP2_IRQ_MASK_SRC18_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC17_SHIFT   17
#define LPD_SLCR_GICP2_IRQ_MASK_SRC17_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC16_SHIFT   16
#define LPD_SLCR_GICP2_IRQ_MASK_SRC16_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC15_SHIFT   15
#define LPD_SLCR_GICP2_IRQ_MASK_SRC15_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC14_SHIFT   14
#define LPD_SLCR_GICP2_IRQ_MASK_SRC14_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC13_SHIFT   13
#define LPD_SLCR_GICP2_IRQ_MASK_SRC13_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC12_SHIFT   12
#define LPD_SLCR_GICP2_IRQ_MASK_SRC12_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC11_SHIFT   11
#define LPD_SLCR_GICP2_IRQ_MASK_SRC11_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC10_SHIFT   10
#define LPD_SLCR_GICP2_IRQ_MASK_SRC10_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC9_SHIFT   9
#define LPD_SLCR_GICP2_IRQ_MASK_SRC9_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC8_SHIFT   8
#define LPD_SLCR_GICP2_IRQ_MASK_SRC8_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC7_SHIFT   7
#define LPD_SLCR_GICP2_IRQ_MASK_SRC7_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC6_SHIFT   6
#define LPD_SLCR_GICP2_IRQ_MASK_SRC6_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC5_SHIFT   5
#define LPD_SLCR_GICP2_IRQ_MASK_SRC5_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC4_SHIFT   4
#define LPD_SLCR_GICP2_IRQ_MASK_SRC4_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC3_SHIFT   3
#define LPD_SLCR_GICP2_IRQ_MASK_SRC3_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC2_SHIFT   2
#define LPD_SLCR_GICP2_IRQ_MASK_SRC2_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC1_SHIFT   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC1_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP2_IRQ_MASK_SRC0_SHIFT   0
#define LPD_SLCR_GICP2_IRQ_MASK_SRC0_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_MASK_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP2_IRQ_ENABLE
 */
#define LPD_SLCR_GICP2_IRQ_ENABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008030U) )

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_ENABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP2_IRQ_DISABLE
 */
#define LPD_SLCR_GICP2_IRQ_DISABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008034U) )

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_DISABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP2_IRQ_TRIGGER
 */
#define LPD_SLCR_GICP2_IRQ_TRIGGER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008038U) )

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC31_SHIFT   31
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC31_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC30_SHIFT   30
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC30_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC29_SHIFT   29
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC29_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC28_SHIFT   28
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC28_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC27_SHIFT   27
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC27_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC26_SHIFT   26
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC26_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC25_SHIFT   25
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC25_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC24_SHIFT   24
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC24_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC23_SHIFT   23
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC23_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC22_SHIFT   22
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC22_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC21_SHIFT   21
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC21_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC20_SHIFT   20
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC20_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC19_SHIFT   19
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC19_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC18_SHIFT   18
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC18_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC17_SHIFT   17
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC17_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC16_SHIFT   16
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC16_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC15_SHIFT   15
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC15_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC14_SHIFT   14
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC14_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC13_SHIFT   13
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC13_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC12_SHIFT   12
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC12_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC11_SHIFT   11
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC11_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC10_SHIFT   10
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC10_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC9_SHIFT   9
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC9_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC8_SHIFT   8
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC8_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC7_SHIFT   7
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC7_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC6_SHIFT   6
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC6_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC5_SHIFT   5
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC5_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC4_SHIFT   4
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC4_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC3_SHIFT   3
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC3_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC2_SHIFT   2
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC2_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC1_SHIFT   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC1_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC0_SHIFT   0
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC0_WIDTH   1
#define LPD_SLCR_GICP2_IRQ_TRIGGER_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP3_IRQ_STATUS
 */
#define LPD_SLCR_GICP3_IRQ_STATUS    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000803CU) )

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC31_SHIFT   31
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC31_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC30_SHIFT   30
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC30_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC29_SHIFT   29
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC29_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC28_SHIFT   28
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC28_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC27_SHIFT   27
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC27_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC26_SHIFT   26
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC26_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC25_SHIFT   25
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC25_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC24_SHIFT   24
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC24_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC23_SHIFT   23
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC23_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC22_SHIFT   22
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC22_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC21_SHIFT   21
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC21_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC20_SHIFT   20
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC20_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC19_SHIFT   19
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC19_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC18_SHIFT   18
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC18_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC17_SHIFT   17
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC17_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC16_SHIFT   16
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC16_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC15_SHIFT   15
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC15_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC14_SHIFT   14
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC14_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC13_SHIFT   13
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC13_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC12_SHIFT   12
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC12_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC11_SHIFT   11
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC11_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC10_SHIFT   10
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC10_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC9_SHIFT   9
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC9_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC8_SHIFT   8
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC8_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC7_SHIFT   7
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC7_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC6_SHIFT   6
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC6_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC5_SHIFT   5
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC5_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC4_SHIFT   4
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC4_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC3_SHIFT   3
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC3_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC2_SHIFT   2
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC2_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC1_SHIFT   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC1_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP3_IRQ_STATUS_SRC0_SHIFT   0
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC0_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_STATUS_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP3_IRQ_MASK
 */
#define LPD_SLCR_GICP3_IRQ_MASK    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008040U) )

#define LPD_SLCR_GICP3_IRQ_MASK_SRC31_SHIFT   31
#define LPD_SLCR_GICP3_IRQ_MASK_SRC31_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC30_SHIFT   30
#define LPD_SLCR_GICP3_IRQ_MASK_SRC30_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC29_SHIFT   29
#define LPD_SLCR_GICP3_IRQ_MASK_SRC29_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC28_SHIFT   28
#define LPD_SLCR_GICP3_IRQ_MASK_SRC28_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC27_SHIFT   27
#define LPD_SLCR_GICP3_IRQ_MASK_SRC27_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC26_SHIFT   26
#define LPD_SLCR_GICP3_IRQ_MASK_SRC26_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC25_SHIFT   25
#define LPD_SLCR_GICP3_IRQ_MASK_SRC25_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC24_SHIFT   24
#define LPD_SLCR_GICP3_IRQ_MASK_SRC24_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC23_SHIFT   23
#define LPD_SLCR_GICP3_IRQ_MASK_SRC23_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC22_SHIFT   22
#define LPD_SLCR_GICP3_IRQ_MASK_SRC22_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC21_SHIFT   21
#define LPD_SLCR_GICP3_IRQ_MASK_SRC21_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC20_SHIFT   20
#define LPD_SLCR_GICP3_IRQ_MASK_SRC20_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC19_SHIFT   19
#define LPD_SLCR_GICP3_IRQ_MASK_SRC19_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC18_SHIFT   18
#define LPD_SLCR_GICP3_IRQ_MASK_SRC18_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC17_SHIFT   17
#define LPD_SLCR_GICP3_IRQ_MASK_SRC17_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC16_SHIFT   16
#define LPD_SLCR_GICP3_IRQ_MASK_SRC16_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC15_SHIFT   15
#define LPD_SLCR_GICP3_IRQ_MASK_SRC15_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC14_SHIFT   14
#define LPD_SLCR_GICP3_IRQ_MASK_SRC14_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC13_SHIFT   13
#define LPD_SLCR_GICP3_IRQ_MASK_SRC13_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC12_SHIFT   12
#define LPD_SLCR_GICP3_IRQ_MASK_SRC12_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC11_SHIFT   11
#define LPD_SLCR_GICP3_IRQ_MASK_SRC11_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC10_SHIFT   10
#define LPD_SLCR_GICP3_IRQ_MASK_SRC10_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC9_SHIFT   9
#define LPD_SLCR_GICP3_IRQ_MASK_SRC9_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC8_SHIFT   8
#define LPD_SLCR_GICP3_IRQ_MASK_SRC8_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC7_SHIFT   7
#define LPD_SLCR_GICP3_IRQ_MASK_SRC7_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC6_SHIFT   6
#define LPD_SLCR_GICP3_IRQ_MASK_SRC6_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC5_SHIFT   5
#define LPD_SLCR_GICP3_IRQ_MASK_SRC5_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC4_SHIFT   4
#define LPD_SLCR_GICP3_IRQ_MASK_SRC4_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC3_SHIFT   3
#define LPD_SLCR_GICP3_IRQ_MASK_SRC3_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC2_SHIFT   2
#define LPD_SLCR_GICP3_IRQ_MASK_SRC2_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC1_SHIFT   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC1_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP3_IRQ_MASK_SRC0_SHIFT   0
#define LPD_SLCR_GICP3_IRQ_MASK_SRC0_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_MASK_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP3_IRQ_ENABLE
 */
#define LPD_SLCR_GICP3_IRQ_ENABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008044U) )

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_ENABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP3_IRQ_DISABLE
 */
#define LPD_SLCR_GICP3_IRQ_DISABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008048U) )

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_DISABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP3_IRQ_TRIGGER
 */
#define LPD_SLCR_GICP3_IRQ_TRIGGER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000804CU) )

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC31_SHIFT   31
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC31_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC30_SHIFT   30
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC30_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC29_SHIFT   29
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC29_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC28_SHIFT   28
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC28_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC27_SHIFT   27
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC27_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC26_SHIFT   26
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC26_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC25_SHIFT   25
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC25_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC24_SHIFT   24
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC24_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC23_SHIFT   23
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC23_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC22_SHIFT   22
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC22_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC21_SHIFT   21
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC21_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC20_SHIFT   20
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC20_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC19_SHIFT   19
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC19_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC18_SHIFT   18
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC18_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC17_SHIFT   17
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC17_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC16_SHIFT   16
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC16_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC15_SHIFT   15
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC15_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC14_SHIFT   14
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC14_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC13_SHIFT   13
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC13_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC12_SHIFT   12
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC12_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC11_SHIFT   11
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC11_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC10_SHIFT   10
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC10_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC9_SHIFT   9
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC9_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC8_SHIFT   8
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC8_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC7_SHIFT   7
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC7_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC6_SHIFT   6
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC6_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC5_SHIFT   5
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC5_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC4_SHIFT   4
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC4_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC3_SHIFT   3
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC3_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC2_SHIFT   2
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC2_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC1_SHIFT   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC1_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC0_SHIFT   0
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC0_WIDTH   1
#define LPD_SLCR_GICP3_IRQ_TRIGGER_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP4_IRQ_STATUS
 */
#define LPD_SLCR_GICP4_IRQ_STATUS    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008050U) )

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC31_SHIFT   31
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC31_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC30_SHIFT   30
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC30_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC29_SHIFT   29
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC29_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC28_SHIFT   28
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC28_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC27_SHIFT   27
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC27_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC26_SHIFT   26
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC26_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC25_SHIFT   25
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC25_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC24_SHIFT   24
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC24_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC23_SHIFT   23
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC23_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC22_SHIFT   22
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC22_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC21_SHIFT   21
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC21_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC20_SHIFT   20
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC20_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC19_SHIFT   19
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC19_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC18_SHIFT   18
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC18_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC17_SHIFT   17
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC17_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC16_SHIFT   16
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC16_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC15_SHIFT   15
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC15_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC14_SHIFT   14
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC14_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC13_SHIFT   13
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC13_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC12_SHIFT   12
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC12_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC11_SHIFT   11
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC11_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC10_SHIFT   10
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC10_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC9_SHIFT   9
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC9_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC8_SHIFT   8
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC8_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC7_SHIFT   7
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC7_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC6_SHIFT   6
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC6_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC5_SHIFT   5
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC5_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC4_SHIFT   4
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC4_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC3_SHIFT   3
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC3_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC2_SHIFT   2
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC2_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC1_SHIFT   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC1_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP4_IRQ_STATUS_SRC0_SHIFT   0
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC0_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_STATUS_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP4_IRQ_MASK
 */
#define LPD_SLCR_GICP4_IRQ_MASK    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008054U) )

#define LPD_SLCR_GICP4_IRQ_MASK_SRC31_SHIFT   31
#define LPD_SLCR_GICP4_IRQ_MASK_SRC31_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC30_SHIFT   30
#define LPD_SLCR_GICP4_IRQ_MASK_SRC30_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC29_SHIFT   29
#define LPD_SLCR_GICP4_IRQ_MASK_SRC29_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC28_SHIFT   28
#define LPD_SLCR_GICP4_IRQ_MASK_SRC28_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC27_SHIFT   27
#define LPD_SLCR_GICP4_IRQ_MASK_SRC27_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC26_SHIFT   26
#define LPD_SLCR_GICP4_IRQ_MASK_SRC26_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC25_SHIFT   25
#define LPD_SLCR_GICP4_IRQ_MASK_SRC25_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC24_SHIFT   24
#define LPD_SLCR_GICP4_IRQ_MASK_SRC24_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC23_SHIFT   23
#define LPD_SLCR_GICP4_IRQ_MASK_SRC23_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC22_SHIFT   22
#define LPD_SLCR_GICP4_IRQ_MASK_SRC22_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC21_SHIFT   21
#define LPD_SLCR_GICP4_IRQ_MASK_SRC21_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC20_SHIFT   20
#define LPD_SLCR_GICP4_IRQ_MASK_SRC20_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC19_SHIFT   19
#define LPD_SLCR_GICP4_IRQ_MASK_SRC19_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC18_SHIFT   18
#define LPD_SLCR_GICP4_IRQ_MASK_SRC18_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC17_SHIFT   17
#define LPD_SLCR_GICP4_IRQ_MASK_SRC17_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC16_SHIFT   16
#define LPD_SLCR_GICP4_IRQ_MASK_SRC16_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC15_SHIFT   15
#define LPD_SLCR_GICP4_IRQ_MASK_SRC15_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC14_SHIFT   14
#define LPD_SLCR_GICP4_IRQ_MASK_SRC14_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC13_SHIFT   13
#define LPD_SLCR_GICP4_IRQ_MASK_SRC13_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC12_SHIFT   12
#define LPD_SLCR_GICP4_IRQ_MASK_SRC12_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC11_SHIFT   11
#define LPD_SLCR_GICP4_IRQ_MASK_SRC11_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC10_SHIFT   10
#define LPD_SLCR_GICP4_IRQ_MASK_SRC10_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC9_SHIFT   9
#define LPD_SLCR_GICP4_IRQ_MASK_SRC9_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC8_SHIFT   8
#define LPD_SLCR_GICP4_IRQ_MASK_SRC8_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC7_SHIFT   7
#define LPD_SLCR_GICP4_IRQ_MASK_SRC7_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC6_SHIFT   6
#define LPD_SLCR_GICP4_IRQ_MASK_SRC6_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC5_SHIFT   5
#define LPD_SLCR_GICP4_IRQ_MASK_SRC5_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC4_SHIFT   4
#define LPD_SLCR_GICP4_IRQ_MASK_SRC4_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC3_SHIFT   3
#define LPD_SLCR_GICP4_IRQ_MASK_SRC3_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC2_SHIFT   2
#define LPD_SLCR_GICP4_IRQ_MASK_SRC2_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC1_SHIFT   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC1_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP4_IRQ_MASK_SRC0_SHIFT   0
#define LPD_SLCR_GICP4_IRQ_MASK_SRC0_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_MASK_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP4_IRQ_ENABLE
 */
#define LPD_SLCR_GICP4_IRQ_ENABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008058U) )

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_ENABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP4_IRQ_DISABLE
 */
#define LPD_SLCR_GICP4_IRQ_DISABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000805CU) )

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_DISABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP4_IRQ_TRIGGER
 */
#define LPD_SLCR_GICP4_IRQ_TRIGGER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008060U) )

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC31_SHIFT   31
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC31_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC30_SHIFT   30
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC30_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC29_SHIFT   29
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC29_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC28_SHIFT   28
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC28_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC27_SHIFT   27
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC27_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC26_SHIFT   26
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC26_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC25_SHIFT   25
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC25_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC24_SHIFT   24
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC24_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC23_SHIFT   23
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC23_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC22_SHIFT   22
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC22_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC21_SHIFT   21
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC21_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC20_SHIFT   20
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC20_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC19_SHIFT   19
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC19_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC18_SHIFT   18
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC18_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC17_SHIFT   17
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC17_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC16_SHIFT   16
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC16_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC15_SHIFT   15
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC15_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC14_SHIFT   14
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC14_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC13_SHIFT   13
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC13_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC12_SHIFT   12
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC12_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC11_SHIFT   11
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC11_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC10_SHIFT   10
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC10_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC9_SHIFT   9
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC9_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC8_SHIFT   8
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC8_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC7_SHIFT   7
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC7_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC6_SHIFT   6
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC6_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC5_SHIFT   5
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC5_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC4_SHIFT   4
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC4_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC3_SHIFT   3
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC3_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC2_SHIFT   2
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC2_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC1_SHIFT   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC1_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC0_SHIFT   0
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC0_WIDTH   1
#define LPD_SLCR_GICP4_IRQ_TRIGGER_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP5_IRQ_STATUS
 */
#define LPD_SLCR_GICP5_IRQ_STATUS    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008064U) )

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC31_SHIFT   31
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC31_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC30_SHIFT   30
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC30_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC29_SHIFT   29
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC29_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC28_SHIFT   28
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC28_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC27_SHIFT   27
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC27_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC26_SHIFT   26
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC26_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC25_SHIFT   25
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC25_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC24_SHIFT   24
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC24_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC23_SHIFT   23
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC23_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC22_SHIFT   22
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC22_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC21_SHIFT   21
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC21_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC20_SHIFT   20
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC20_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC19_SHIFT   19
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC19_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC18_SHIFT   18
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC18_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC17_SHIFT   17
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC17_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC16_SHIFT   16
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC16_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC15_SHIFT   15
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC15_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC14_SHIFT   14
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC14_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC13_SHIFT   13
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC13_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC12_SHIFT   12
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC12_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC11_SHIFT   11
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC11_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC10_SHIFT   10
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC10_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC9_SHIFT   9
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC9_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC8_SHIFT   8
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC8_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC7_SHIFT   7
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC7_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC6_SHIFT   6
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC6_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC5_SHIFT   5
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC5_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC4_SHIFT   4
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC4_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC3_SHIFT   3
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC3_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC2_SHIFT   2
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC2_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC1_SHIFT   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC1_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP5_IRQ_STATUS_SRC0_SHIFT   0
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC0_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_STATUS_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP5_IRQ_MASK
 */
#define LPD_SLCR_GICP5_IRQ_MASK    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008068U) )

#define LPD_SLCR_GICP5_IRQ_MASK_SRC31_SHIFT   31
#define LPD_SLCR_GICP5_IRQ_MASK_SRC31_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC30_SHIFT   30
#define LPD_SLCR_GICP5_IRQ_MASK_SRC30_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC29_SHIFT   29
#define LPD_SLCR_GICP5_IRQ_MASK_SRC29_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC28_SHIFT   28
#define LPD_SLCR_GICP5_IRQ_MASK_SRC28_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC27_SHIFT   27
#define LPD_SLCR_GICP5_IRQ_MASK_SRC27_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC26_SHIFT   26
#define LPD_SLCR_GICP5_IRQ_MASK_SRC26_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC25_SHIFT   25
#define LPD_SLCR_GICP5_IRQ_MASK_SRC25_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC24_SHIFT   24
#define LPD_SLCR_GICP5_IRQ_MASK_SRC24_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC23_SHIFT   23
#define LPD_SLCR_GICP5_IRQ_MASK_SRC23_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC22_SHIFT   22
#define LPD_SLCR_GICP5_IRQ_MASK_SRC22_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC21_SHIFT   21
#define LPD_SLCR_GICP5_IRQ_MASK_SRC21_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC20_SHIFT   20
#define LPD_SLCR_GICP5_IRQ_MASK_SRC20_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC19_SHIFT   19
#define LPD_SLCR_GICP5_IRQ_MASK_SRC19_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC18_SHIFT   18
#define LPD_SLCR_GICP5_IRQ_MASK_SRC18_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC17_SHIFT   17
#define LPD_SLCR_GICP5_IRQ_MASK_SRC17_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC16_SHIFT   16
#define LPD_SLCR_GICP5_IRQ_MASK_SRC16_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC15_SHIFT   15
#define LPD_SLCR_GICP5_IRQ_MASK_SRC15_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC14_SHIFT   14
#define LPD_SLCR_GICP5_IRQ_MASK_SRC14_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC13_SHIFT   13
#define LPD_SLCR_GICP5_IRQ_MASK_SRC13_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC12_SHIFT   12
#define LPD_SLCR_GICP5_IRQ_MASK_SRC12_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC11_SHIFT   11
#define LPD_SLCR_GICP5_IRQ_MASK_SRC11_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC10_SHIFT   10
#define LPD_SLCR_GICP5_IRQ_MASK_SRC10_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC9_SHIFT   9
#define LPD_SLCR_GICP5_IRQ_MASK_SRC9_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC8_SHIFT   8
#define LPD_SLCR_GICP5_IRQ_MASK_SRC8_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC7_SHIFT   7
#define LPD_SLCR_GICP5_IRQ_MASK_SRC7_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC6_SHIFT   6
#define LPD_SLCR_GICP5_IRQ_MASK_SRC6_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC5_SHIFT   5
#define LPD_SLCR_GICP5_IRQ_MASK_SRC5_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC4_SHIFT   4
#define LPD_SLCR_GICP5_IRQ_MASK_SRC4_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC3_SHIFT   3
#define LPD_SLCR_GICP5_IRQ_MASK_SRC3_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC2_SHIFT   2
#define LPD_SLCR_GICP5_IRQ_MASK_SRC2_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC1_SHIFT   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC1_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP5_IRQ_MASK_SRC0_SHIFT   0
#define LPD_SLCR_GICP5_IRQ_MASK_SRC0_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_MASK_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP5_IRQ_ENABLE
 */
#define LPD_SLCR_GICP5_IRQ_ENABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000806CU) )

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_ENABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP5_IRQ_DISABLE
 */
#define LPD_SLCR_GICP5_IRQ_DISABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008070U) )

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_DISABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP5_IRQ_TRIGGER
 */
#define LPD_SLCR_GICP5_IRQ_TRIGGER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008074U) )

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC31_SHIFT   31
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC31_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC30_SHIFT   30
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC30_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC29_SHIFT   29
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC29_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC28_SHIFT   28
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC28_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC27_SHIFT   27
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC27_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC26_SHIFT   26
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC26_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC25_SHIFT   25
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC25_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC24_SHIFT   24
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC24_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC23_SHIFT   23
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC23_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC22_SHIFT   22
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC22_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC21_SHIFT   21
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC21_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC20_SHIFT   20
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC20_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC19_SHIFT   19
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC19_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC18_SHIFT   18
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC18_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC17_SHIFT   17
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC17_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC16_SHIFT   16
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC16_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC15_SHIFT   15
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC15_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC14_SHIFT   14
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC14_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC13_SHIFT   13
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC13_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC12_SHIFT   12
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC12_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC11_SHIFT   11
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC11_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC10_SHIFT   10
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC10_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC9_SHIFT   9
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC9_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC8_SHIFT   8
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC8_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC7_SHIFT   7
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC7_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC6_SHIFT   6
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC6_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC5_SHIFT   5
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC5_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC4_SHIFT   4
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC4_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC3_SHIFT   3
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC3_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC2_SHIFT   2
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC2_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC1_SHIFT   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC1_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC0_SHIFT   0
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC0_WIDTH   1
#define LPD_SLCR_GICP5_IRQ_TRIGGER_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP6_IRQ_STATUS
 */
#define LPD_SLCR_GICP6_IRQ_STATUS    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008078U) )

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC31_SHIFT   31
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC31_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC30_SHIFT   30
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC30_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC29_SHIFT   29
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC29_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC28_SHIFT   28
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC28_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC27_SHIFT   27
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC27_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC26_SHIFT   26
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC26_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC25_SHIFT   25
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC25_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC24_SHIFT   24
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC24_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC23_SHIFT   23
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC23_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC22_SHIFT   22
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC22_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC21_SHIFT   21
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC21_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC20_SHIFT   20
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC20_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC19_SHIFT   19
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC19_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC18_SHIFT   18
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC18_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC17_SHIFT   17
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC17_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC16_SHIFT   16
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC16_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC15_SHIFT   15
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC15_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC14_SHIFT   14
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC14_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC13_SHIFT   13
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC13_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC12_SHIFT   12
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC12_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC11_SHIFT   11
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC11_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC10_SHIFT   10
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC10_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC9_SHIFT   9
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC9_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC8_SHIFT   8
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC8_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC7_SHIFT   7
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC7_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC6_SHIFT   6
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC6_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC5_SHIFT   5
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC5_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC4_SHIFT   4
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC4_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC3_SHIFT   3
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC3_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC2_SHIFT   2
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC2_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC1_SHIFT   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC1_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP6_IRQ_STATUS_SRC0_SHIFT   0
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC0_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_STATUS_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP6_IRQ_MASK
 */
#define LPD_SLCR_GICP6_IRQ_MASK    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000807CU) )

#define LPD_SLCR_GICP6_IRQ_MASK_SRC31_SHIFT   31
#define LPD_SLCR_GICP6_IRQ_MASK_SRC31_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC30_SHIFT   30
#define LPD_SLCR_GICP6_IRQ_MASK_SRC30_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC29_SHIFT   29
#define LPD_SLCR_GICP6_IRQ_MASK_SRC29_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC28_SHIFT   28
#define LPD_SLCR_GICP6_IRQ_MASK_SRC28_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC27_SHIFT   27
#define LPD_SLCR_GICP6_IRQ_MASK_SRC27_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC26_SHIFT   26
#define LPD_SLCR_GICP6_IRQ_MASK_SRC26_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC25_SHIFT   25
#define LPD_SLCR_GICP6_IRQ_MASK_SRC25_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC24_SHIFT   24
#define LPD_SLCR_GICP6_IRQ_MASK_SRC24_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC23_SHIFT   23
#define LPD_SLCR_GICP6_IRQ_MASK_SRC23_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC22_SHIFT   22
#define LPD_SLCR_GICP6_IRQ_MASK_SRC22_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC21_SHIFT   21
#define LPD_SLCR_GICP6_IRQ_MASK_SRC21_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC20_SHIFT   20
#define LPD_SLCR_GICP6_IRQ_MASK_SRC20_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC19_SHIFT   19
#define LPD_SLCR_GICP6_IRQ_MASK_SRC19_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC18_SHIFT   18
#define LPD_SLCR_GICP6_IRQ_MASK_SRC18_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC17_SHIFT   17
#define LPD_SLCR_GICP6_IRQ_MASK_SRC17_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC16_SHIFT   16
#define LPD_SLCR_GICP6_IRQ_MASK_SRC16_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC15_SHIFT   15
#define LPD_SLCR_GICP6_IRQ_MASK_SRC15_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC14_SHIFT   14
#define LPD_SLCR_GICP6_IRQ_MASK_SRC14_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC13_SHIFT   13
#define LPD_SLCR_GICP6_IRQ_MASK_SRC13_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC12_SHIFT   12
#define LPD_SLCR_GICP6_IRQ_MASK_SRC12_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC11_SHIFT   11
#define LPD_SLCR_GICP6_IRQ_MASK_SRC11_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC10_SHIFT   10
#define LPD_SLCR_GICP6_IRQ_MASK_SRC10_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC9_SHIFT   9
#define LPD_SLCR_GICP6_IRQ_MASK_SRC9_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC8_SHIFT   8
#define LPD_SLCR_GICP6_IRQ_MASK_SRC8_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC7_SHIFT   7
#define LPD_SLCR_GICP6_IRQ_MASK_SRC7_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC6_SHIFT   6
#define LPD_SLCR_GICP6_IRQ_MASK_SRC6_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC5_SHIFT   5
#define LPD_SLCR_GICP6_IRQ_MASK_SRC5_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC4_SHIFT   4
#define LPD_SLCR_GICP6_IRQ_MASK_SRC4_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC3_SHIFT   3
#define LPD_SLCR_GICP6_IRQ_MASK_SRC3_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC2_SHIFT   2
#define LPD_SLCR_GICP6_IRQ_MASK_SRC2_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC1_SHIFT   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC1_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP6_IRQ_MASK_SRC0_SHIFT   0
#define LPD_SLCR_GICP6_IRQ_MASK_SRC0_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_MASK_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP6_IRQ_ENABLE
 */
#define LPD_SLCR_GICP6_IRQ_ENABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008080U) )

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_ENABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP6_IRQ_DISABLE
 */
#define LPD_SLCR_GICP6_IRQ_DISABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008084U) )

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_DISABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP6_IRQ_TRIGGER
 */
#define LPD_SLCR_GICP6_IRQ_TRIGGER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008088U) )

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC31_SHIFT   31
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC31_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC30_SHIFT   30
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC30_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC29_SHIFT   29
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC29_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC28_SHIFT   28
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC28_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC27_SHIFT   27
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC27_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC26_SHIFT   26
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC26_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC25_SHIFT   25
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC25_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC24_SHIFT   24
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC24_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC23_SHIFT   23
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC23_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC22_SHIFT   22
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC22_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC21_SHIFT   21
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC21_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC20_SHIFT   20
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC20_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC19_SHIFT   19
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC19_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC18_SHIFT   18
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC18_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC17_SHIFT   17
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC17_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC16_SHIFT   16
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC16_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC15_SHIFT   15
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC15_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC14_SHIFT   14
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC14_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC13_SHIFT   13
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC13_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC12_SHIFT   12
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC12_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC11_SHIFT   11
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC11_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC10_SHIFT   10
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC10_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC9_SHIFT   9
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC9_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC8_SHIFT   8
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC8_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC7_SHIFT   7
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC7_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC6_SHIFT   6
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC6_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC5_SHIFT   5
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC5_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC4_SHIFT   4
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC4_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC3_SHIFT   3
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC3_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC2_SHIFT   2
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC2_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC1_SHIFT   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC1_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC0_SHIFT   0
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC0_WIDTH   1
#define LPD_SLCR_GICP6_IRQ_TRIGGER_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP7_IRQ_STATUS
 */
#define LPD_SLCR_GICP7_IRQ_STATUS    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000808CU) )

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC31_SHIFT   31
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC31_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC30_SHIFT   30
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC30_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC29_SHIFT   29
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC29_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC28_SHIFT   28
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC28_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC27_SHIFT   27
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC27_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC26_SHIFT   26
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC26_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC25_SHIFT   25
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC25_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC24_SHIFT   24
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC24_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC23_SHIFT   23
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC23_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC22_SHIFT   22
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC22_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC21_SHIFT   21
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC21_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC20_SHIFT   20
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC20_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC19_SHIFT   19
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC19_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC18_SHIFT   18
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC18_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC17_SHIFT   17
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC17_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC16_SHIFT   16
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC16_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC15_SHIFT   15
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC15_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC14_SHIFT   14
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC14_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC13_SHIFT   13
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC13_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC12_SHIFT   12
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC12_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC11_SHIFT   11
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC11_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC10_SHIFT   10
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC10_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC9_SHIFT   9
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC9_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC8_SHIFT   8
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC8_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC7_SHIFT   7
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC7_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC6_SHIFT   6
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC6_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC5_SHIFT   5
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC5_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC4_SHIFT   4
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC4_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC3_SHIFT   3
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC3_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC2_SHIFT   2
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC2_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC1_SHIFT   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC1_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP7_IRQ_STATUS_SRC0_SHIFT   0
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC0_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_STATUS_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP7_IRQ_MASK
 */
#define LPD_SLCR_GICP7_IRQ_MASK    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008090U) )

#define LPD_SLCR_GICP7_IRQ_MASK_SRC31_SHIFT   31
#define LPD_SLCR_GICP7_IRQ_MASK_SRC31_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC30_SHIFT   30
#define LPD_SLCR_GICP7_IRQ_MASK_SRC30_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC29_SHIFT   29
#define LPD_SLCR_GICP7_IRQ_MASK_SRC29_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC28_SHIFT   28
#define LPD_SLCR_GICP7_IRQ_MASK_SRC28_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC27_SHIFT   27
#define LPD_SLCR_GICP7_IRQ_MASK_SRC27_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC26_SHIFT   26
#define LPD_SLCR_GICP7_IRQ_MASK_SRC26_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC25_SHIFT   25
#define LPD_SLCR_GICP7_IRQ_MASK_SRC25_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC24_SHIFT   24
#define LPD_SLCR_GICP7_IRQ_MASK_SRC24_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC23_SHIFT   23
#define LPD_SLCR_GICP7_IRQ_MASK_SRC23_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC22_SHIFT   22
#define LPD_SLCR_GICP7_IRQ_MASK_SRC22_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC21_SHIFT   21
#define LPD_SLCR_GICP7_IRQ_MASK_SRC21_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC20_SHIFT   20
#define LPD_SLCR_GICP7_IRQ_MASK_SRC20_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC19_SHIFT   19
#define LPD_SLCR_GICP7_IRQ_MASK_SRC19_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC18_SHIFT   18
#define LPD_SLCR_GICP7_IRQ_MASK_SRC18_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC17_SHIFT   17
#define LPD_SLCR_GICP7_IRQ_MASK_SRC17_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC16_SHIFT   16
#define LPD_SLCR_GICP7_IRQ_MASK_SRC16_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC15_SHIFT   15
#define LPD_SLCR_GICP7_IRQ_MASK_SRC15_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC14_SHIFT   14
#define LPD_SLCR_GICP7_IRQ_MASK_SRC14_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC13_SHIFT   13
#define LPD_SLCR_GICP7_IRQ_MASK_SRC13_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC12_SHIFT   12
#define LPD_SLCR_GICP7_IRQ_MASK_SRC12_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC11_SHIFT   11
#define LPD_SLCR_GICP7_IRQ_MASK_SRC11_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC10_SHIFT   10
#define LPD_SLCR_GICP7_IRQ_MASK_SRC10_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC9_SHIFT   9
#define LPD_SLCR_GICP7_IRQ_MASK_SRC9_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC8_SHIFT   8
#define LPD_SLCR_GICP7_IRQ_MASK_SRC8_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC7_SHIFT   7
#define LPD_SLCR_GICP7_IRQ_MASK_SRC7_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC6_SHIFT   6
#define LPD_SLCR_GICP7_IRQ_MASK_SRC6_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC5_SHIFT   5
#define LPD_SLCR_GICP7_IRQ_MASK_SRC5_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC4_SHIFT   4
#define LPD_SLCR_GICP7_IRQ_MASK_SRC4_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC3_SHIFT   3
#define LPD_SLCR_GICP7_IRQ_MASK_SRC3_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC2_SHIFT   2
#define LPD_SLCR_GICP7_IRQ_MASK_SRC2_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC1_SHIFT   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC1_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP7_IRQ_MASK_SRC0_SHIFT   0
#define LPD_SLCR_GICP7_IRQ_MASK_SRC0_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_MASK_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP7_IRQ_ENABLE
 */
#define LPD_SLCR_GICP7_IRQ_ENABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008094U) )

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_ENABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP7_IRQ_DISABLE
 */
#define LPD_SLCR_GICP7_IRQ_DISABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00008098U) )

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC31_SHIFT   31
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC31_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC30_SHIFT   30
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC30_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC29_SHIFT   29
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC29_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC28_SHIFT   28
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC28_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC27_SHIFT   27
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC27_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC26_SHIFT   26
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC26_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC25_SHIFT   25
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC25_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC24_SHIFT   24
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC24_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC23_SHIFT   23
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC23_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC22_SHIFT   22
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC22_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC21_SHIFT   21
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC21_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC20_SHIFT   20
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC20_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC19_SHIFT   19
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC19_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC18_SHIFT   18
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC18_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC17_SHIFT   17
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC17_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC16_SHIFT   16
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC16_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC15_SHIFT   15
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC15_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC14_SHIFT   14
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC14_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC13_SHIFT   13
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC13_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC12_SHIFT   12
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC12_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC11_SHIFT   11
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC11_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC10_SHIFT   10
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC10_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC9_SHIFT   9
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC9_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC8_SHIFT   8
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC8_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_DISABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP7_IRQ_TRIGGER
 */
#define LPD_SLCR_GICP7_IRQ_TRIGGER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000809CU) )

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC31_SHIFT   31
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC31_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC31_MASK    ((u32)0X80000000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC30_SHIFT   30
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC30_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC30_MASK    ((u32)0X40000000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC29_SHIFT   29
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC29_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC29_MASK    ((u32)0X20000000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC28_SHIFT   28
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC28_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC28_MASK    ((u32)0X10000000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC27_SHIFT   27
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC27_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC27_MASK    ((u32)0X08000000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC26_SHIFT   26
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC26_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC26_MASK    ((u32)0X04000000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC25_SHIFT   25
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC25_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC25_MASK    ((u32)0X02000000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC24_SHIFT   24
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC24_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC24_MASK    ((u32)0X01000000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC23_SHIFT   23
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC23_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC23_MASK    ((u32)0X00800000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC22_SHIFT   22
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC22_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC22_MASK    ((u32)0X00400000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC21_SHIFT   21
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC21_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC21_MASK    ((u32)0X00200000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC20_SHIFT   20
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC20_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC20_MASK    ((u32)0X00100000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC19_SHIFT   19
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC19_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC19_MASK    ((u32)0X00080000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC18_SHIFT   18
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC18_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC18_MASK    ((u32)0X00040000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC17_SHIFT   17
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC17_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC17_MASK    ((u32)0X00020000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC16_SHIFT   16
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC16_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC16_MASK    ((u32)0X00010000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC15_SHIFT   15
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC15_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC15_MASK    ((u32)0X00008000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC14_SHIFT   14
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC14_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC14_MASK    ((u32)0X00004000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC13_SHIFT   13
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC13_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC13_MASK    ((u32)0X00002000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC12_SHIFT   12
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC12_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC12_MASK    ((u32)0X00001000U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC11_SHIFT   11
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC11_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC11_MASK    ((u32)0X00000800U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC10_SHIFT   10
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC10_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC10_MASK    ((u32)0X00000400U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC9_SHIFT   9
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC9_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC9_MASK    ((u32)0X00000200U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC8_SHIFT   8
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC8_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC8_MASK    ((u32)0X00000100U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC7_SHIFT   7
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC7_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC6_SHIFT   6
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC6_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC5_SHIFT   5
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC5_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC4_SHIFT   4
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC4_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC3_SHIFT   3
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC3_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC2_SHIFT   2
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC2_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC1_SHIFT   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC1_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC0_SHIFT   0
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC0_WIDTH   1
#define LPD_SLCR_GICP7_IRQ_TRIGGER_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP_PMU_IRQ_STATUS
 */
#define LPD_SLCR_GICP_PMU_IRQ_STATUS    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X000080A0U) )

#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC7_SHIFT   7
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC7_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC6_SHIFT   6
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC6_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC5_SHIFT   5
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC5_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC4_SHIFT   4
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC4_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC3_SHIFT   3
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC3_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC2_SHIFT   2
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC2_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC1_SHIFT   1
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC1_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC0_SHIFT   0
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC0_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_STATUS_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP_PMU_IRQ_MASK
 */
#define LPD_SLCR_GICP_PMU_IRQ_MASK    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X000080A4U) )

#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC7_SHIFT   7
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC7_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC6_SHIFT   6
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC6_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC5_SHIFT   5
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC5_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC4_SHIFT   4
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC4_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC3_SHIFT   3
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC3_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC2_SHIFT   2
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC2_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC1_SHIFT   1
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC1_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC0_SHIFT   0
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC0_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_MASK_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP_PMU_IRQ_ENABLE
 */
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X000080A8U) )

#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_ENABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP_PMU_IRQ_DISABLE
 */
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X000080ACU) )

#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC7_SHIFT   7
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC7_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC6_SHIFT   6
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC6_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC5_SHIFT   5
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC5_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC4_SHIFT   4
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC4_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC3_SHIFT   3
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC3_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC2_SHIFT   2
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC2_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC1_SHIFT   1
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC1_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC0_SHIFT   0
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC0_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_DISABLE_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_GICP_PMU_IRQ_TRIGGER
 */
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X000080B0U) )

#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC7_SHIFT   7
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC7_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC7_MASK    ((u32)0X00000080U)

#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC6_SHIFT   6
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC6_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC6_MASK    ((u32)0X00000040U)

#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC5_SHIFT   5
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC5_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC4_SHIFT   4
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC4_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC3_SHIFT   3
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC3_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC2_SHIFT   2
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC2_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC1_SHIFT   1
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC1_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC0_SHIFT   0
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC0_WIDTH   1
#define LPD_SLCR_GICP_PMU_IRQ_TRIGGER_SRC0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_AFI_FS
 */
#define LPD_SLCR_AFI_FS    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X00009000U) )

#define LPD_SLCR_AFI_FS_DW_SS2_SEL_SHIFT   8
#define LPD_SLCR_AFI_FS_DW_SS2_SEL_WIDTH   2
#define LPD_SLCR_AFI_FS_DW_SS2_SEL_MASK    ((u32)0X00000300U)

/**
 * Register: LPD_SLCR_LPD_CCI
 */
#define LPD_SLCR_LPD_CCI    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000A000U) )

#define LPD_SLCR_LPD_CCI_SPARE_SHIFT   28
#define LPD_SLCR_LPD_CCI_SPARE_WIDTH   4
#define LPD_SLCR_LPD_CCI_SPARE_MASK    ((u32)0XF0000000U)

#define LPD_SLCR_LPD_CCI_QVNVNETS4_SHIFT   27
#define LPD_SLCR_LPD_CCI_QVNVNETS4_WIDTH   1
#define LPD_SLCR_LPD_CCI_QVNVNETS4_MASK    ((u32)0X08000000U)

#define LPD_SLCR_LPD_CCI_QVNVNETS3_SHIFT   26
#define LPD_SLCR_LPD_CCI_QVNVNETS3_WIDTH   1
#define LPD_SLCR_LPD_CCI_QVNVNETS3_MASK    ((u32)0X04000000U)

#define LPD_SLCR_LPD_CCI_QVNVNETS2_SHIFT   25
#define LPD_SLCR_LPD_CCI_QVNVNETS2_WIDTH   1
#define LPD_SLCR_LPD_CCI_QVNVNETS2_MASK    ((u32)0X02000000U)

#define LPD_SLCR_LPD_CCI_QVNVNETS1_SHIFT   24
#define LPD_SLCR_LPD_CCI_QVNVNETS1_WIDTH   1
#define LPD_SLCR_LPD_CCI_QVNVNETS1_MASK    ((u32)0X01000000U)

#define LPD_SLCR_LPD_CCI_QVNVNETS0_SHIFT   23
#define LPD_SLCR_LPD_CCI_QVNVNETS0_WIDTH   1
#define LPD_SLCR_LPD_CCI_QVNVNETS0_MASK    ((u32)0X00800000U)

#define LPD_SLCR_LPD_CCI_QOSOVERRIDE_SHIFT   18
#define LPD_SLCR_LPD_CCI_QOSOVERRIDE_WIDTH   5
#define LPD_SLCR_LPD_CCI_QOSOVERRIDE_MASK    ((u32)0X007C0000U)

#define LPD_SLCR_LPD_CCI_QVNENABLE_M2_SHIFT   17
#define LPD_SLCR_LPD_CCI_QVNENABLE_M2_WIDTH   1
#define LPD_SLCR_LPD_CCI_QVNENABLE_M2_MASK    ((u32)0X00020000U)

#define LPD_SLCR_LPD_CCI_QVNENABLE_M1_SHIFT   16
#define LPD_SLCR_LPD_CCI_QVNENABLE_M1_WIDTH   1
#define LPD_SLCR_LPD_CCI_QVNENABLE_M1_MASK    ((u32)0X00010000U)

#define LPD_SLCR_LPD_CCI_STRIPING_GRANULE_SHIFT   13
#define LPD_SLCR_LPD_CCI_STRIPING_GRANULE_WIDTH   3
#define LPD_SLCR_LPD_CCI_STRIPING_GRANULE_MASK    ((u32)0X0000E000U)

#define LPD_SLCR_LPD_CCI_ACCHANNELEN4_SHIFT   12
#define LPD_SLCR_LPD_CCI_ACCHANNELEN4_WIDTH   1
#define LPD_SLCR_LPD_CCI_ACCHANNELEN4_MASK    ((u32)0X00001000U)

#define LPD_SLCR_LPD_CCI_ACCHANNELEN3_SHIFT   11
#define LPD_SLCR_LPD_CCI_ACCHANNELEN3_WIDTH   1
#define LPD_SLCR_LPD_CCI_ACCHANNELEN3_MASK    ((u32)0X00000800U)

#define LPD_SLCR_LPD_CCI_ACCHANNELEN0_SHIFT   10
#define LPD_SLCR_LPD_CCI_ACCHANNELEN0_WIDTH   1
#define LPD_SLCR_LPD_CCI_ACCHANNELEN0_MASK    ((u32)0X00000400U)

#define LPD_SLCR_LPD_CCI_ECOREVNUM_SHIFT   6
#define LPD_SLCR_LPD_CCI_ECOREVNUM_WIDTH   4
#define LPD_SLCR_LPD_CCI_ECOREVNUM_MASK    ((u32)0X000003C0U)

#define LPD_SLCR_LPD_CCI_ASA2_SHIFT   5
#define LPD_SLCR_LPD_CCI_ASA2_WIDTH   1
#define LPD_SLCR_LPD_CCI_ASA2_MASK    ((u32)0X00000020U)

#define LPD_SLCR_LPD_CCI_ASA1_SHIFT   4
#define LPD_SLCR_LPD_CCI_ASA1_WIDTH   1
#define LPD_SLCR_LPD_CCI_ASA1_MASK    ((u32)0X00000010U)

#define LPD_SLCR_LPD_CCI_ASA0_SHIFT   3
#define LPD_SLCR_LPD_CCI_ASA0_WIDTH   1
#define LPD_SLCR_LPD_CCI_ASA0_MASK    ((u32)0X00000008U)

#define LPD_SLCR_LPD_CCI_OWO2_SHIFT   2
#define LPD_SLCR_LPD_CCI_OWO2_WIDTH   1
#define LPD_SLCR_LPD_CCI_OWO2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_LPD_CCI_OWO1_SHIFT   1
#define LPD_SLCR_LPD_CCI_OWO1_WIDTH   1
#define LPD_SLCR_LPD_CCI_OWO1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_LPD_CCI_OWO0_SHIFT   0
#define LPD_SLCR_LPD_CCI_OWO0_WIDTH   1
#define LPD_SLCR_LPD_CCI_OWO0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_LPD_CCI_ADDRMAP
 */
#define LPD_SLCR_LPD_CCI_ADDRMAP    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000A004U) )

#define LPD_SLCR_LPD_CCI_ADDRMAP_15_SHIFT   30
#define LPD_SLCR_LPD_CCI_ADDRMAP_15_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_15_MASK    ((u32)0XC0000000U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_14_SHIFT   28
#define LPD_SLCR_LPD_CCI_ADDRMAP_14_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_14_MASK    ((u32)0X30000000U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_13_SHIFT   26
#define LPD_SLCR_LPD_CCI_ADDRMAP_13_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_13_MASK    ((u32)0X0C000000U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_12_SHIFT   24
#define LPD_SLCR_LPD_CCI_ADDRMAP_12_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_12_MASK    ((u32)0X03000000U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_11_SHIFT   22
#define LPD_SLCR_LPD_CCI_ADDRMAP_11_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_11_MASK    ((u32)0X00C00000U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_10_SHIFT   20
#define LPD_SLCR_LPD_CCI_ADDRMAP_10_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_10_MASK    ((u32)0X00300000U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_9_SHIFT   18
#define LPD_SLCR_LPD_CCI_ADDRMAP_9_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_9_MASK    ((u32)0X000C0000U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_8_SHIFT   16
#define LPD_SLCR_LPD_CCI_ADDRMAP_8_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_8_MASK    ((u32)0X00030000U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_7_SHIFT   14
#define LPD_SLCR_LPD_CCI_ADDRMAP_7_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_7_MASK    ((u32)0X0000C000U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_6_SHIFT   12
#define LPD_SLCR_LPD_CCI_ADDRMAP_6_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_6_MASK    ((u32)0X00003000U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_5_SHIFT   10
#define LPD_SLCR_LPD_CCI_ADDRMAP_5_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_5_MASK    ((u32)0X00000C00U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_4_SHIFT   8
#define LPD_SLCR_LPD_CCI_ADDRMAP_4_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_4_MASK    ((u32)0X00000300U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_3_SHIFT   6
#define LPD_SLCR_LPD_CCI_ADDRMAP_3_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_3_MASK    ((u32)0X000000C0U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_2_SHIFT   4
#define LPD_SLCR_LPD_CCI_ADDRMAP_2_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_2_MASK    ((u32)0X00000030U)

#define LPD_SLCR_LPD_CCI_ADDRMAP_1_SHIFT   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_1_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_1_MASK    ((u32)0X0000000CU)

#define LPD_SLCR_LPD_CCI_ADDRMAP_0_SHIFT   0
#define LPD_SLCR_LPD_CCI_ADDRMAP_0_WIDTH   2
#define LPD_SLCR_LPD_CCI_ADDRMAP_0_MASK    ((u32)0X00000003U)

/**
 * Register: LPD_SLCR_LPD_CCI_QVNPREALLOC
 */
#define LPD_SLCR_LPD_CCI_QVNPREALLOC    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000A008U) )

#define LPD_SLCR_LPD_CCI_QVNPREALLOC_WM2_SHIFT   20
#define LPD_SLCR_LPD_CCI_QVNPREALLOC_WM2_WIDTH   4
#define LPD_SLCR_LPD_CCI_QVNPREALLOC_WM2_MASK    ((u32)0X00F00000U)

#define LPD_SLCR_LPD_CCI_QVNPREALLOC_WM1_SHIFT   16
#define LPD_SLCR_LPD_CCI_QVNPREALLOC_WM1_WIDTH   4
#define LPD_SLCR_LPD_CCI_QVNPREALLOC_WM1_MASK    ((u32)0X000F0000U)

#define LPD_SLCR_LPD_CCI_QVNPREALLOC_RM2_SHIFT   8
#define LPD_SLCR_LPD_CCI_QVNPREALLOC_RM2_WIDTH   4
#define LPD_SLCR_LPD_CCI_QVNPREALLOC_RM2_MASK    ((u32)0X00000F00U)

#define LPD_SLCR_LPD_CCI_QVNPREALLOC_RM1_SHIFT   4
#define LPD_SLCR_LPD_CCI_QVNPREALLOC_RM1_WIDTH   4
#define LPD_SLCR_LPD_CCI_QVNPREALLOC_RM1_MASK    ((u32)0X000000F0U)

/**
 * Register: LPD_SLCR_LPD_SMMU
 */
#define LPD_SLCR_LPD_SMMU    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000A020U) )

#define LPD_SLCR_LPD_SMMU_INTEG_SEC_OVERRIDE_SHIFT   7
#define LPD_SLCR_LPD_SMMU_INTEG_SEC_OVERRIDE_WIDTH   1
#define LPD_SLCR_LPD_SMMU_INTEG_SEC_OVERRIDE_MASK    ((u32)0X00000080U)

#define LPD_SLCR_LPD_SMMU_CTTW_SHIFT   6
#define LPD_SLCR_LPD_SMMU_CTTW_WIDTH   1
#define LPD_SLCR_LPD_SMMU_CTTW_MASK    ((u32)0X00000040U)

#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU5_SHIFT   5
#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU5_WIDTH   1
#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU5_MASK    ((u32)0X00000020U)

#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU4_SHIFT   4
#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU4_WIDTH   1
#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU4_MASK    ((u32)0X00000010U)

#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU3_SHIFT   3
#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU3_WIDTH   1
#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU3_MASK    ((u32)0X00000008U)

#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU2_SHIFT   2
#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU2_WIDTH   1
#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU2_MASK    ((u32)0X00000004U)

#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU1_SHIFT   1
#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU1_WIDTH   1
#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU1_MASK    ((u32)0X00000002U)

#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU0_SHIFT   0
#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU0_WIDTH   1
#define LPD_SLCR_LPD_SMMU_SYSBARDISABLE_TBU0_MASK    ((u32)0X00000001U)

/**
 * Register: LPD_SLCR_LPD_APU
 */
#define LPD_SLCR_LPD_APU    ( ( LPD_SLCR_BASEADDR ) + ((u32)0X0000A040U) )

#define LPD_SLCR_LPD_APU_BRDC_BARRIER_SHIFT   3
#define LPD_SLCR_LPD_APU_BRDC_BARRIER_WIDTH   1
#define LPD_SLCR_LPD_APU_BRDC_BARRIER_MASK    ((u32)0X00000008U)

#define LPD_SLCR_LPD_APU_BRDC_CMNT_SHIFT   2
#define LPD_SLCR_LPD_APU_BRDC_CMNT_WIDTH   1
#define LPD_SLCR_LPD_APU_BRDC_CMNT_MASK    ((u32)0X00000004U)

#define LPD_SLCR_LPD_APU_BRDC_INNER_SHIFT   1U
#define LPD_SLCR_LPD_APU_BRDC_INNER_WIDTH   1
#define LPD_SLCR_LPD_APU_BRDC_INNER_MASK    ((u32)0X00000002U)

#define LPD_SLCR_LPD_APU_BRDC_OUTER_SHIFT   0
#define LPD_SLCR_LPD_APU_BRDC_OUTER_WIDTH   1
#define LPD_SLCR_LPD_APU_BRDC_OUTER_MASK    ((u32)0X00000001U)

#ifdef __cplusplus
}
#endif


#endif /* _LPD_SLCR_H_ */
