/******************************************************************************
* Copyright (c) 2021 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


#ifndef IOU_SLCR_H_
#define IOU_SLCR_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * IOU_SLCR Base Address
 */
#define IOU_SLCR_BASEADDR	((u32)0xFF180000U)

/**
 * Register: SDIO_CLK_CTRL
 */
#define SDIO_CLK_CTRL		( ( IOU_SLCR_BASEADDR ) + ((u32)0X0000030CU) )

#define SDIO0_RX_SRC_SEL_SHIFT		0U
#define SDIO0_RX_SRC_SEL_MASK		((u32)0X00000003U)
#define SDIO0_FBCLK_SEL_SHIFT		2U
#define SDIO0_FBCLK_SEL_MASK		((u32)0X00000004U)
#define SDIO1_RX_SRC_SEL_SHIFT		17U
#define SDIO1_RX_SRC_SEL_MASK		((u32)0X00020000U)
#define SDIO1_FBCLK_SEL_SHIFT		18U
#define SDIO1_FBCLK_SEL_MASK		((u32)0X00040000U)

/**
 * Register: CTRL_REG_SD
 */
#define CTRL_REG_SD		( ( IOU_SLCR_BASEADDR ) + ((u32)0X00000310U) )
#define SD0_EMMC_SEL_SHIFT		0U
#define SD0_EMMC_SEL_MASK		((u32)0X00000001U)
#define SD1_EMMC_SEL_SHIFT		15U
#define SD1_EMMC_SEL_MASK		((u32)0X00008000U)

/**
 * Register: SD_CONFIG_REG1
 */
#define SD_CONFIG_REG1		( ( IOU_SLCR_BASEADDR ) + ((u32)0X0000031CU) )
#define SD0_TUNIGCOUNT_SHIFT		1U
#define SD0_TUNIGCOUNT_MASK		((u32)0X0000007EU)
#define SD0_BASECLK_SHIFT		7U
#define SD0_BASECLK_MASK		((u32)0X00007F80U)
#define SD1_TUNIGCOUNT_SHIFT		17U
#define SD1_TUNIGCOUNT_MASK		((u32)0X007E0000U)
#define SD1_BASECLK_SHIFT		23U
#define SD1_BASECLK_MASK		((u32)0X7F800000U)

/**
 * Register: SD_CONFIG_REG2
 */
#define SD_CONFIG_REG2		( ( IOU_SLCR_BASEADDR ) + ((u32)0X00000320U) )
#define SD0_8BIT_SHIFT			2U
#define SD0_8BIT_MASK			((u32)0X00000004U)
#define SD0_3P0V_SHIFT			8U
#define SD0_3P0V_MASK			((u32)0X00000100U)
#define SD0_SLOTTYPE_SHIFT		12U
#define SD0_SLOTTYPE_MASK		((u32)0X00003000U)
#define SD1_8BIT_SHIFT			18U
#define SD1_8BIT_MASK			((u32)0X00040000U)
#define SD1_3P0V_SHIFT			24U
#define SD1_3P0V_MASK			((u32)0X01000000U)
#define SD1_SLOTTYPE_SHIFT		28U
#define SD1_SLOTTYPE_MASK		((u32)0x30000000U)

/**
 * Register: SD_CONFIG_REG3
 */
#define SD_CONFIG_REG3		( ( IOU_SLCR_BASEADDR ) + ((u32)0X00000324U) )
#define SD0_RETUNETMR_SHIFT		6U
#define SD0_RETUNETMR_MASK		((u32)0x000003C0U)
#define SD1_RETUNETMR_SHIFT		22U
#define SD1_RETUNETMR_MASK		((u32)0x03C00000U)

/**
 * Register: SD_DLL_CTRL
 */
#define SD_DLL_CTRL		( ( IOU_SLCR_BASEADDR ) + ((u32)0X00000358U) )
#define SD0_DLL_RST_DIS_SHIFT		3U
#define SD0_DLL_RST_DIS_MASK		((u32)0x00000008U)
#define SD1_DLL_RST_DIS_SHIFT		19U
#define SD1_DLL_RST_DIS_MASK		((u32)0x00080000U)

/**
 * Register: GEM_CLK_CTRL
 */
#define GEM_CLK_CTRL		( ( IOU_SLCR_BASEADDR ) + ((u32)0X00000308U) )
#define GEM0_SGMII_MODE_SHIFT		2U
#define GEM0_SGMII_MODE_MASK		((u32)0x00000004U)
#define GEM1_SGMII_MODE_SHIFT		7U
#define GEM1_SGMII_MODE_MASK		((u32)0x00000080U)
#define GEM2_SGMII_MODE_SHIFT		12U
#define GEM2_SGMII_MODE_MASK		((u32)0x00001000U)
#define GEM3_SGMII_MODE_SHIFT		17U
#define GEM3_SGMII_MODE_MASK		((u32)0x00020000U)

/**
 * Register: IOU_COHERENT_CTRL
 */
#define IOU_COHERENT_CTRL	( ( IOU_SLCR_BASEADDR ) + ((u32)0X00000400U) )
#define GEM0_AXI_COH_SHIFT		0U
#define GEM0_AXI_COH_MASK		((u32)0x0000000FU)
#define GEM1_AXI_COH_SHIFT		4U
#define GEM1_AXI_COH_MASK		((u32)0x000000F0U)
#define GEM2_AXI_COH_SHIFT		8U
#define GEM2_AXI_COH_MASK		((u32)0x00000F00U)
#define GEM3_AXI_COH_SHIFT		12U
#define GEM3_AXI_COH_MASK		((u32)0x0000F000U)
#define SD0_AXI_COH_SHIFT		16U
#define SD0_AXI_COH_MASK		((u32)0x000F0000U)
#define SD1_AXI_COH_SHIFT		20U
#define SD1_AXI_COH_MASK		((u32)0x00F00000U)

/**
 * Register: IOU_INTERCONNECT_ROUTE
 */
#define IOU_INTERCONNECT_ROUTE	( ( IOU_SLCR_BASEADDR ) + ((u32)0X00000408U) )
#define GEM0_INTERCONNECT_ROUTE_SHIFT		0U
#define GEM0_INTERCONNECT_ROUTE_MASK		((u32)0x00000001U)
#define GEM1_INTERCONNECT_ROUTE_SHIFT		1U
#define GEM1_INTERCONNECT_ROUTE_MASK		((u32)0x00000002U)
#define GEM2_INTERCONNECT_ROUTE_SHIFT		2U
#define GEM2_INTERCONNECT_ROUTE_MASK		((u32)0x00000004U)
#define GEM3_INTERCONNECT_ROUTE_SHIFT		3U
#define GEM3_INTERCONNECT_ROUTE_MASK		((u32)0x00000008U)
#define SD0_INTERCONNECT_ROUTE_SHIFT		4U
#define SD0_INTERCONNECT_ROUTE_MASK		((u32)0x00000010U)
#define SD1_INTERCONNECT_ROUTE_SHIFT		5U
#define SD1_INTERCONNECT_ROUTE_MASK		((u32)0x00000020U)

#ifdef __cplusplus
}
#endif


#endif /* _IOU_SLCR_H_ */
