/*
* Copyright (c) 2016 - 2020 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
 */


#ifndef EFUSE_H_
#define EFUSE_H_

#ifdef __cplusplus
extern "C" {
#endif

/* EFUSE Base Address */
#define EFUSE_BASEADDR      0XFFCC0000U

 /* Register: EFUSE_IPDISABLE */
#define EFUSE_IPDISABLE    ( ( EFUSE_BASEADDR ) + 0X00001018U )

#define EFUSE_IPDISABLE_GPU_DIS_SHIFT   5U
#define EFUSE_IPDISABLE_GPU_DIS_WIDTH   1U
#define EFUSE_IPDISABLE_GPU_DIS_MASK    0X00000020U

#define EFUSE_IPDISABLE_APU3_DIS_SHIFT   3U
#define EFUSE_IPDISABLE_APU3_DIS_WIDTH   1U
#define EFUSE_IPDISABLE_APU3_DIS_MASK    0X00000008U

#define EFUSE_IPDISABLE_APU2_DIS_SHIFT   2U
#define EFUSE_IPDISABLE_APU2_DIS_WIDTH   1U
#define EFUSE_IPDISABLE_APU2_DIS_MASK    0X00000004U

#define EFUSE_IPDISABLE_APU1_DIS_SHIFT   1U
#define EFUSE_IPDISABLE_APU1_DIS_WIDTH   1U
#define EFUSE_IPDISABLE_APU1_DIS_MASK    0X00000002U

#define EFUSE_IPDISABLE_APU0_DIS_SHIFT   0U
#define EFUSE_IPDISABLE_APU0_DIS_WIDTH   1U
#define EFUSE_IPDISABLE_APU0_DIS_MASK    0X00000001U

#define EFUSE_IPDISABLE_VERSION		0x1FFU

#ifdef __cplusplus
}
#endif


#endif /* _EFUSE_H_ */
