/******************************************************************************
* Copyright (c) 2015 - 2020 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


#ifndef CRL_APB_H_
#define CRL_APB_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * CRL_APB Base Address
 */
#define CRL_APB_BASEADDR      ((u32)0XFF5E0000U)

/**
 * Register: CRL_APB_ERR_CTRL
 */
#define CRL_APB_ERR_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000000U) )

#define CRL_APB_ERR_CTRL_SLVERR_ENABLE_SHIFT   0
#define CRL_APB_ERR_CTRL_SLVERR_ENABLE_WIDTH   1
#define CRL_APB_ERR_CTRL_SLVERR_ENABLE_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_IR_STATUS
 */
#define CRL_APB_IR_STATUS    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000004U) )

#define CRL_APB_IR_STATUS_ADDR_DECODE_ERR_SHIFT   0
#define CRL_APB_IR_STATUS_ADDR_DECODE_ERR_WIDTH   1
#define CRL_APB_IR_STATUS_ADDR_DECODE_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_IR_MASK
 */
#define CRL_APB_IR_MASK    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000008U) )

#define CRL_APB_IR_MASK_ADDR_DECODE_ERR_SHIFT   0
#define CRL_APB_IR_MASK_ADDR_DECODE_ERR_WIDTH   1
#define CRL_APB_IR_MASK_ADDR_DECODE_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_IR_ENABLE
 */
#define CRL_APB_IR_ENABLE    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000000CU) )

#define CRL_APB_IR_ENABLE_ADDR_DECODE_ERR_SHIFT   0
#define CRL_APB_IR_ENABLE_ADDR_DECODE_ERR_WIDTH   1
#define CRL_APB_IR_ENABLE_ADDR_DECODE_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_IR_DISABLE
 */
#define CRL_APB_IR_DISABLE    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000010U) )

#define CRL_APB_IR_DISABLE_ADDR_DECODE_ERR_SHIFT   0
#define CRL_APB_IR_DISABLE_ADDR_DECODE_ERR_WIDTH   1
#define CRL_APB_IR_DISABLE_ADDR_DECODE_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CRL_ECO
 */
#define CRL_APB_CRL_ECO    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000018U) )

#define CRL_APB_CRL_ECO_REG_SHIFT   0
#define CRL_APB_CRL_ECO_REG_WIDTH   32
#define CRL_APB_CRL_ECO_REG_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CRL_WPROT
 */
#define CRL_APB_CRL_WPROT    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000001CU) )

#define CRL_APB_CRL_WPROT_ACTIVE_SHIFT   0
#define CRL_APB_CRL_WPROT_ACTIVE_WIDTH   1
#define CRL_APB_CRL_WPROT_ACTIVE_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_IOPLL_CTRL
 */
#define CRL_APB_IOPLL_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000020U) )

#define CRL_APB_IOPLL_CTRL_POST_SRC_SHIFT   24
#define CRL_APB_IOPLL_CTRL_POST_SRC_WIDTH   3
#define CRL_APB_IOPLL_CTRL_POST_SRC_MASK    ((u32)0X07000000U)

#define CRL_APB_IOPLL_CTRL_PRE_SRC_SHIFT   20
#define CRL_APB_IOPLL_CTRL_PRE_SRC_WIDTH   3
#define CRL_APB_IOPLL_CTRL_PRE_SRC_MASK    ((u32)0X00700000U)

#define CRL_APB_IOPLL_CTRL_CLKOUTDIV_SHIFT   17
#define CRL_APB_IOPLL_CTRL_CLKOUTDIV_WIDTH   1
#define CRL_APB_IOPLL_CTRL_CLKOUTDIV_MASK    ((u32)0X00020000U)

#define CRL_APB_IOPLL_CTRL_DIV2_SHIFT   16
#define CRL_APB_IOPLL_CTRL_DIV2_WIDTH   1
#define CRL_APB_IOPLL_CTRL_DIV2_MASK    ((u32)0X00010000U)

#define CRL_APB_IOPLL_CTRL_FBDIV_SHIFT   8
#define CRL_APB_IOPLL_CTRL_FBDIV_WIDTH   7
#define CRL_APB_IOPLL_CTRL_FBDIV_MASK    ((u32)0X00007F00U)

#define CRL_APB_IOPLL_CTRL_BYPASS_SHIFT   3
#define CRL_APB_IOPLL_CTRL_BYPASS_WIDTH   1
#define CRL_APB_IOPLL_CTRL_BYPASS_MASK    ((u32)0X00000008U)

#define CRL_APB_IOPLL_CTRL_RESET_SHIFT   0
#define CRL_APB_IOPLL_CTRL_RESET_WIDTH   1
#define CRL_APB_IOPLL_CTRL_RESET_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_IOPLL_CFG
 */
#define CRL_APB_IOPLL_CFG    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000024U) )

#define CRL_APB_IOPLL_CFG_LOCK_DLY_SHIFT   25
#define CRL_APB_IOPLL_CFG_LOCK_DLY_WIDTH   7
#define CRL_APB_IOPLL_CFG_LOCK_DLY_MASK    ((u32)0XFE000000U)

#define CRL_APB_IOPLL_CFG_LOCK_CNT_SHIFT   13
#define CRL_APB_IOPLL_CFG_LOCK_CNT_WIDTH   10
#define CRL_APB_IOPLL_CFG_LOCK_CNT_MASK    ((u32)0X007FE000U)

#define CRL_APB_IOPLL_CFG_LFHF_SHIFT   10
#define CRL_APB_IOPLL_CFG_LFHF_WIDTH   2
#define CRL_APB_IOPLL_CFG_LFHF_MASK    ((u32)0X00000C00U)

#define CRL_APB_IOPLL_CFG_CP_SHIFT   5
#define CRL_APB_IOPLL_CFG_CP_WIDTH   4
#define CRL_APB_IOPLL_CFG_CP_MASK    ((u32)0X000001E0U)

#define CRL_APB_IOPLL_CFG_RES_SHIFT   0
#define CRL_APB_IOPLL_CFG_RES_WIDTH   4
#define CRL_APB_IOPLL_CFG_RES_MASK    ((u32)0X0000000FU)

/**
 * Register: CRL_APB_IOPLL_FRAC_CFG
 */
#define CRL_APB_IOPLL_FRAC_CFG    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000028U) )

#define CRL_APB_IOPLL_FRAC_CFG_ENABLED_SHIFT   31
#define CRL_APB_IOPLL_FRAC_CFG_ENABLED_WIDTH   1
#define CRL_APB_IOPLL_FRAC_CFG_ENABLED_MASK    ((u32)0X80000000U)

#define CRL_APB_IOPLL_FRAC_CFG_SEED_SHIFT   22
#define CRL_APB_IOPLL_FRAC_CFG_SEED_WIDTH   3
#define CRL_APB_IOPLL_FRAC_CFG_SEED_MASK    ((u32)0X01C00000U)

#define CRL_APB_IOPLL_FRAC_CFG_ALGRTHM_SHIFT   19
#define CRL_APB_IOPLL_FRAC_CFG_ALGRTHM_WIDTH   1
#define CRL_APB_IOPLL_FRAC_CFG_ALGRTHM_MASK    ((u32)0X00080000U)

#define CRL_APB_IOPLL_FRAC_CFG_ORDER_SHIFT   18
#define CRL_APB_IOPLL_FRAC_CFG_ORDER_WIDTH   1
#define CRL_APB_IOPLL_FRAC_CFG_ORDER_MASK    ((u32)0X00040000U)

#define CRL_APB_IOPLL_FRAC_CFG_DATA_SHIFT   0
#define CRL_APB_IOPLL_FRAC_CFG_DATA_WIDTH   16
#define CRL_APB_IOPLL_FRAC_CFG_DATA_MASK    ((u32)0X0000FFFFU)

/**
 * Register: CRL_APB_RPLL_CTRL
 */
#define CRL_APB_RPLL_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000030U) )

#define CRL_APB_RPLL_CTRL_POST_SRC_SHIFT   24
#define CRL_APB_RPLL_CTRL_POST_SRC_WIDTH   3
#define CRL_APB_RPLL_CTRL_POST_SRC_MASK    ((u32)0X07000000U)

#define CRL_APB_RPLL_CTRL_PRE_SRC_SHIFT   20
#define CRL_APB_RPLL_CTRL_PRE_SRC_WIDTH   3
#define CRL_APB_RPLL_CTRL_PRE_SRC_MASK    ((u32)0X00700000U)

#define CRL_APB_RPLL_CTRL_CLKOUTDIV_SHIFT   17
#define CRL_APB_RPLL_CTRL_CLKOUTDIV_WIDTH   1
#define CRL_APB_RPLL_CTRL_CLKOUTDIV_MASK    ((u32)0X00020000U)

#define CRL_APB_RPLL_CTRL_DIV2_SHIFT   16
#define CRL_APB_RPLL_CTRL_DIV2_WIDTH   1
#define CRL_APB_RPLL_CTRL_DIV2_MASK    ((u32)0X00010000U)

#define CRL_APB_RPLL_CTRL_FBDIV_SHIFT   8
#define CRL_APB_RPLL_CTRL_FBDIV_WIDTH   7
#define CRL_APB_RPLL_CTRL_FBDIV_MASK    ((u32)0X00007F00U)

#define CRL_APB_RPLL_CTRL_BYPASS_SHIFT   3
#define CRL_APB_RPLL_CTRL_BYPASS_WIDTH   1
#define CRL_APB_RPLL_CTRL_BYPASS_MASK    ((u32)0X00000008U)

#define CRL_APB_RPLL_CTRL_RESET_SHIFT   0
#define CRL_APB_RPLL_CTRL_RESET_WIDTH   1
#define CRL_APB_RPLL_CTRL_RESET_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_RPLL_CFG
 */
#define CRL_APB_RPLL_CFG    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000034U) )

#define CRL_APB_RPLL_CFG_LOCK_DLY_SHIFT   25
#define CRL_APB_RPLL_CFG_LOCK_DLY_WIDTH   7
#define CRL_APB_RPLL_CFG_LOCK_DLY_MASK    ((u32)0XFE000000U)

#define CRL_APB_RPLL_CFG_LOCK_CNT_SHIFT   13
#define CRL_APB_RPLL_CFG_LOCK_CNT_WIDTH   10
#define CRL_APB_RPLL_CFG_LOCK_CNT_MASK    ((u32)0X007FE000U)

#define CRL_APB_RPLL_CFG_LFHF_SHIFT   10
#define CRL_APB_RPLL_CFG_LFHF_WIDTH   2
#define CRL_APB_RPLL_CFG_LFHF_MASK    ((u32)0X00000C00U)

#define CRL_APB_RPLL_CFG_CP_SHIFT   5
#define CRL_APB_RPLL_CFG_CP_WIDTH   4
#define CRL_APB_RPLL_CFG_CP_MASK    ((u32)0X000001E0U)

#define CRL_APB_RPLL_CFG_RES_SHIFT   0
#define CRL_APB_RPLL_CFG_RES_WIDTH   4
#define CRL_APB_RPLL_CFG_RES_MASK    ((u32)0X0000000FU)

/**
 * Register: CRL_APB_RPLL_FRAC_CFG
 */
#define CRL_APB_RPLL_FRAC_CFG    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000038U) )

#define CRL_APB_RPLL_FRAC_CFG_ENABLED_SHIFT   31
#define CRL_APB_RPLL_FRAC_CFG_ENABLED_WIDTH   1
#define CRL_APB_RPLL_FRAC_CFG_ENABLED_MASK    ((u32)0X80000000U)

#define CRL_APB_RPLL_FRAC_CFG_SEED_SHIFT   22
#define CRL_APB_RPLL_FRAC_CFG_SEED_WIDTH   3
#define CRL_APB_RPLL_FRAC_CFG_SEED_MASK    ((u32)0X01C00000U)

#define CRL_APB_RPLL_FRAC_CFG_ALGRTHM_SHIFT   19
#define CRL_APB_RPLL_FRAC_CFG_ALGRTHM_WIDTH   1
#define CRL_APB_RPLL_FRAC_CFG_ALGRTHM_MASK    ((u32)0X00080000U)

#define CRL_APB_RPLL_FRAC_CFG_ORDER_SHIFT   18
#define CRL_APB_RPLL_FRAC_CFG_ORDER_WIDTH   1
#define CRL_APB_RPLL_FRAC_CFG_ORDER_MASK    ((u32)0X00040000U)

#define CRL_APB_RPLL_FRAC_CFG_DATA_SHIFT   0
#define CRL_APB_RPLL_FRAC_CFG_DATA_WIDTH   16
#define CRL_APB_RPLL_FRAC_CFG_DATA_MASK    ((u32)0X0000FFFFU)

/**
 * Register: CRL_APB_PLL_STATUS
 */
#define CRL_APB_PLL_STATUS    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000040U) )

#define CRL_APB_PLL_STATUS_RPLL_STABLE_SHIFT   4
#define CRL_APB_PLL_STATUS_RPLL_STABLE_WIDTH   1
#define CRL_APB_PLL_STATUS_RPLL_STABLE_MASK    ((u32)0X00000010U)

#define CRL_APB_PLL_STATUS_IOPLL_STABLE_SHIFT   3
#define CRL_APB_PLL_STATUS_IOPLL_STABLE_WIDTH   1
#define CRL_APB_PLL_STATUS_IOPLL_STABLE_MASK    ((u32)0X00000008U)

#define CRL_APB_PLL_STATUS_RPLL_LOCK_SHIFT   1
#define CRL_APB_PLL_STATUS_RPLL_LOCK_WIDTH   1
#define CRL_APB_PLL_STATUS_RPLL_LOCK_MASK    ((u32)0X00000002U)

#define CRL_APB_PLL_STATUS_IOPLL_LOCK_SHIFT   0
#define CRL_APB_PLL_STATUS_IOPLL_LOCK_WIDTH   1
#define CRL_APB_PLL_STATUS_IOPLL_LOCK_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_IOPLL_TO_FPD_CTRL
 */
#define CRL_APB_IOPLL_TO_FPD_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000044U) )

#define CRL_APB_IOPLL_TO_FPD_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_IOPLL_TO_FPD_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_IOPLL_TO_FPD_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

/**
 * Register: CRL_APB_RPLL_TO_FPD_CTRL
 */
#define CRL_APB_RPLL_TO_FPD_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000048U) )

#define CRL_APB_RPLL_TO_FPD_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_RPLL_TO_FPD_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_RPLL_TO_FPD_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

/**
 * Register: CRL_APB_USB3_DUAL_REF_CTRL
 */
#define CRL_APB_USB3_DUAL_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000004CU) )

#define CRL_APB_USB3_DUAL_REF_CTRL_CLKACT_SHIFT   25
#define CRL_APB_USB3_DUAL_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_USB3_DUAL_REF_CTRL_CLKACT_MASK    ((u32)0X02000000U)

#define CRL_APB_USB3_DUAL_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_USB3_DUAL_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_USB3_DUAL_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_USB3_DUAL_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_USB3_DUAL_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_USB3_DUAL_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_USB3_DUAL_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_USB3_DUAL_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_USB3_DUAL_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_GEM0_REF_CTRL
 */
#define CRL_APB_GEM0_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000050U) )

#define CRL_APB_GEM0_REF_CTRL_RX_CLKACT_SHIFT   26
#define CRL_APB_GEM0_REF_CTRL_RX_CLKACT_WIDTH   1
#define CRL_APB_GEM0_REF_CTRL_RX_CLKACT_MASK    ((u32)0X04000000U)

#define CRL_APB_GEM0_REF_CTRL_CLKACT_SHIFT   25
#define CRL_APB_GEM0_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_GEM0_REF_CTRL_CLKACT_MASK    ((u32)0X02000000U)

#define CRL_APB_GEM0_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_GEM0_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_GEM0_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_GEM0_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_GEM0_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_GEM0_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_GEM0_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_GEM0_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_GEM0_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_GEM1_REF_CTRL
 */
#define CRL_APB_GEM1_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000054U) )

#define CRL_APB_GEM1_REF_CTRL_RX_CLKACT_SHIFT   26
#define CRL_APB_GEM1_REF_CTRL_RX_CLKACT_WIDTH   1
#define CRL_APB_GEM1_REF_CTRL_RX_CLKACT_MASK    ((u32)0X04000000U)

#define CRL_APB_GEM1_REF_CTRL_CLKACT_SHIFT   25
#define CRL_APB_GEM1_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_GEM1_REF_CTRL_CLKACT_MASK    ((u32)0X02000000U)

#define CRL_APB_GEM1_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_GEM1_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_GEM1_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_GEM1_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_GEM1_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_GEM1_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_GEM1_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_GEM1_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_GEM1_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_GEM2_REF_CTRL
 */
#define CRL_APB_GEM2_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000058U) )

#define CRL_APB_GEM2_REF_CTRL_RX_CLKACT_SHIFT   26
#define CRL_APB_GEM2_REF_CTRL_RX_CLKACT_WIDTH   1
#define CRL_APB_GEM2_REF_CTRL_RX_CLKACT_MASK    ((u32)0X04000000U)

#define CRL_APB_GEM2_REF_CTRL_CLKACT_SHIFT   25
#define CRL_APB_GEM2_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_GEM2_REF_CTRL_CLKACT_MASK    ((u32)0X02000000U)

#define CRL_APB_GEM2_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_GEM2_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_GEM2_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_GEM2_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_GEM2_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_GEM2_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_GEM2_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_GEM2_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_GEM2_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_GEM3_REF_CTRL
 */
#define CRL_APB_GEM3_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000005CU) )

#define CRL_APB_GEM3_REF_CTRL_RX_CLKACT_SHIFT   26
#define CRL_APB_GEM3_REF_CTRL_RX_CLKACT_WIDTH   1
#define CRL_APB_GEM3_REF_CTRL_RX_CLKACT_MASK    ((u32)0X04000000U)

#define CRL_APB_GEM3_REF_CTRL_CLKACT_SHIFT   25
#define CRL_APB_GEM3_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_GEM3_REF_CTRL_CLKACT_MASK    ((u32)0X02000000U)

#define CRL_APB_GEM3_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_GEM3_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_GEM3_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_GEM3_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_GEM3_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_GEM3_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_GEM3_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_GEM3_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_GEM3_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_USB0_BUS_REF_CTRL
 */
#define CRL_APB_USB0_BUS_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000060U) )

#define CRL_APB_USB0_BUS_REF_CTRL_CLKACT_SHIFT   25
#define CRL_APB_USB0_BUS_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_USB0_BUS_REF_CTRL_CLKACT_MASK    ((u32)0X02000000U)

#define CRL_APB_USB0_BUS_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_USB0_BUS_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_USB0_BUS_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_USB0_BUS_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_USB0_BUS_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_USB0_BUS_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_USB0_BUS_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_USB0_BUS_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_USB0_BUS_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_USB1_BUS_REF_CTRL
 */
#define CRL_APB_USB1_BUS_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000064U) )

#define CRL_APB_USB1_BUS_REF_CTRL_CLKACT_SHIFT   25
#define CRL_APB_USB1_BUS_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_USB1_BUS_REF_CTRL_CLKACT_MASK    ((u32)0X02000000U)

#define CRL_APB_USB1_BUS_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_USB1_BUS_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_USB1_BUS_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_USB1_BUS_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_USB1_BUS_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_USB1_BUS_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_USB1_BUS_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_USB1_BUS_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_USB1_BUS_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_QSPI_REF_CTRL
 */
#define CRL_APB_QSPI_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000068U) )

#define CRL_APB_QSPI_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_QSPI_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_QSPI_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_QSPI_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_QSPI_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_QSPI_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_QSPI_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_QSPI_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_QSPI_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_QSPI_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_QSPI_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_QSPI_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_SDIO0_REF_CTRL
 */
#define CRL_APB_SDIO0_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000006CU) )

#define CRL_APB_SDIO0_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_SDIO0_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_SDIO0_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_SDIO0_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_SDIO0_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_SDIO0_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_SDIO0_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_SDIO0_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_SDIO0_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_SDIO0_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_SDIO0_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_SDIO0_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_SDIO1_REF_CTRL
 */
#define CRL_APB_SDIO1_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000070U) )

#define CRL_APB_SDIO1_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_SDIO1_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_SDIO1_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_SDIO1_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_SDIO1_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_SDIO1_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_SDIO1_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_SDIO1_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_SDIO1_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_SDIO1_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_SDIO1_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_SDIO1_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_UART0_REF_CTRL
 */
#define CRL_APB_UART0_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000074U) )

#define CRL_APB_UART0_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_UART0_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_UART0_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_UART0_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_UART0_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_UART0_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_UART0_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_UART0_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_UART0_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_UART0_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_UART0_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_UART0_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_UART1_REF_CTRL
 */
#define CRL_APB_UART1_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000078U) )

#define CRL_APB_UART1_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_UART1_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_UART1_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_UART1_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_UART1_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_UART1_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_UART1_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_UART1_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_UART1_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_UART1_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_UART1_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_UART1_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_SPI0_REF_CTRL
 */
#define CRL_APB_SPI0_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000007CU) )

#define CRL_APB_SPI0_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_SPI0_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_SPI0_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_SPI0_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_SPI0_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_SPI0_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_SPI0_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_SPI0_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_SPI0_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_SPI0_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_SPI0_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_SPI0_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_SPI1_REF_CTRL
 */
#define CRL_APB_SPI1_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000080U) )

#define CRL_APB_SPI1_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_SPI1_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_SPI1_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_SPI1_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_SPI1_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_SPI1_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_SPI1_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_SPI1_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_SPI1_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_SPI1_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_SPI1_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_SPI1_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_CAN0_REF_CTRL
 */
#define CRL_APB_CAN0_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000084U) )

#define CRL_APB_CAN0_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_CAN0_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_CAN0_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_CAN0_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_CAN0_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_CAN0_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_CAN0_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_CAN0_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_CAN0_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_CAN0_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_CAN0_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_CAN0_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_CAN1_REF_CTRL
 */
#define CRL_APB_CAN1_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000088U) )

#define CRL_APB_CAN1_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_CAN1_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_CAN1_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_CAN1_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_CAN1_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_CAN1_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_CAN1_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_CAN1_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_CAN1_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_CAN1_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_CAN1_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_CAN1_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_CPU_R5_CTRL
 */
#define CRL_APB_CPU_R5_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000090U) )

#define CRL_APB_CPU_R5_CTRL_CLKACT_CORE_SHIFT   25
#define CRL_APB_CPU_R5_CTRL_CLKACT_CORE_WIDTH   1
#define CRL_APB_CPU_R5_CTRL_CLKACT_CORE_MASK    ((u32)0X02000000U)

#define CRL_APB_CPU_R5_CTRL_CLKACT_SHIFT   24
#define CRL_APB_CPU_R5_CTRL_CLKACT_WIDTH   1
#define CRL_APB_CPU_R5_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_CPU_R5_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_CPU_R5_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_CPU_R5_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_CPU_R5_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_CPU_R5_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_CPU_R5_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_IOU_SWITCH_CTRL
 */
#define CRL_APB_IOU_SWITCH_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000009CU) )

#define CRL_APB_IOU_SWITCH_CTRL_CLKACT_SHIFT   24
#define CRL_APB_IOU_SWITCH_CTRL_CLKACT_WIDTH   1
#define CRL_APB_IOU_SWITCH_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_IOU_SWITCH_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_IOU_SWITCH_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_IOU_SWITCH_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_IOU_SWITCH_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_IOU_SWITCH_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_IOU_SWITCH_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_CSU_PLL_CTRL
 */
#define CRL_APB_CSU_PLL_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000A0U) )

#define CRL_APB_CSU_PLL_CTRL_CLKACT_SHIFT   24
#define CRL_APB_CSU_PLL_CTRL_CLKACT_WIDTH   1
#define CRL_APB_CSU_PLL_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_CSU_PLL_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_CSU_PLL_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_CSU_PLL_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_CSU_PLL_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_CSU_PLL_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_CSU_PLL_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_PCAP_CTRL
 */
#define CRL_APB_PCAP_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000A4U) )

#define CRL_APB_PCAP_CTRL_CLKACT_SHIFT   24
#define CRL_APB_PCAP_CTRL_CLKACT_WIDTH   1
#define CRL_APB_PCAP_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_PCAP_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_PCAP_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_PCAP_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_PCAP_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_PCAP_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_PCAP_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_LPD_SWITCH_CTRL
 */
#define CRL_APB_LPD_SWITCH_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000A8U) )

#define CRL_APB_LPD_SWITCH_CTRL_CLKACT_SHIFT   24
#define CRL_APB_LPD_SWITCH_CTRL_CLKACT_WIDTH   1
#define CRL_APB_LPD_SWITCH_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_LPD_SWITCH_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_LPD_SWITCH_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_LPD_SWITCH_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_LPD_SWITCH_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_LPD_SWITCH_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_LPD_SWITCH_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_LPD_LSBUS_CTRL
 */
#define CRL_APB_LPD_LSBUS_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000ACU) )

#define CRL_APB_LPD_LSBUS_CTRL_CLKACT_SHIFT   24
#define CRL_APB_LPD_LSBUS_CTRL_CLKACT_WIDTH   1
#define CRL_APB_LPD_LSBUS_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_LPD_LSBUS_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_LPD_LSBUS_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_LPD_LSBUS_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_LPD_LSBUS_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_LPD_LSBUS_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_LPD_LSBUS_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_DBG_LPD_CTRL
 */
#define CRL_APB_DBG_LPD_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000B0U) )

#define CRL_APB_DBG_LPD_CTRL_CLKACT_SHIFT   24
#define CRL_APB_DBG_LPD_CTRL_CLKACT_WIDTH   1
#define CRL_APB_DBG_LPD_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_DBG_LPD_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_DBG_LPD_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_DBG_LPD_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_DBG_LPD_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_DBG_LPD_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_DBG_LPD_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_NAND_REF_CTRL
 */
#define CRL_APB_NAND_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000B4U) )

#define CRL_APB_NAND_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_NAND_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_NAND_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_NAND_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_NAND_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_NAND_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_NAND_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_NAND_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_NAND_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_NAND_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_NAND_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_NAND_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_ADMA_REF_CTRL
 */
#define CRL_APB_ADMA_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000B8U) )

#define CRL_APB_ADMA_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_ADMA_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_ADMA_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_ADMA_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_ADMA_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_ADMA_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_ADMA_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_ADMA_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_ADMA_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_PL0_REF_CTRL
 */
#define CRL_APB_PL0_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000C0U) )

#define CRL_APB_PL0_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_PL0_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_PL0_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_PL0_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_PL0_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_PL0_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_PL0_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_PL0_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_PL0_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_PL0_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_PL0_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_PL0_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_PL1_REF_CTRL
 */
#define CRL_APB_PL1_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000C4U) )

#define CRL_APB_PL1_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_PL1_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_PL1_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_PL1_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_PL1_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_PL1_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_PL1_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_PL1_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_PL1_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_PL1_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_PL1_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_PL1_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_PL2_REF_CTRL
 */
#define CRL_APB_PL2_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000C8U) )

#define CRL_APB_PL2_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_PL2_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_PL2_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_PL2_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_PL2_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_PL2_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_PL2_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_PL2_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_PL2_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_PL2_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_PL2_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_PL2_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_PL3_REF_CTRL
 */
#define CRL_APB_PL3_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000CCU) )

#define CRL_APB_PL3_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_PL3_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_PL3_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_PL3_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_PL3_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_PL3_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_PL3_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_PL3_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_PL3_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_PL3_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_PL3_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_PL3_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_PL0_THR_CTRL
 */
#define CRL_APB_PL0_THR_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000D0U) )

#define CRL_APB_PL0_THR_CTRL_CURR_VAL_SHIFT   16
#define CRL_APB_PL0_THR_CTRL_CURR_VAL_WIDTH   16
#define CRL_APB_PL0_THR_CTRL_CURR_VAL_MASK    ((u32)0XFFFF0000U)

#define CRL_APB_PL0_THR_CTRL_RUNNING_SHIFT   15
#define CRL_APB_PL0_THR_CTRL_RUNNING_WIDTH   1
#define CRL_APB_PL0_THR_CTRL_RUNNING_MASK    ((u32)0X00008000U)

#define CRL_APB_PL0_THR_CTRL_CPU_START_SHIFT   1
#define CRL_APB_PL0_THR_CTRL_CPU_START_WIDTH   1
#define CRL_APB_PL0_THR_CTRL_CPU_START_MASK    ((u32)0X00000002U)

#define CRL_APB_PL0_THR_CTRL_CNT_RST_SHIFT   0
#define CRL_APB_PL0_THR_CTRL_CNT_RST_WIDTH   1
#define CRL_APB_PL0_THR_CTRL_CNT_RST_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_PL0_THR_CNT
 */
#define CRL_APB_PL0_THR_CNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000D4U) )

#define CRL_APB_PL0_THR_CNT_LAST_CNT_SHIFT   0
#define CRL_APB_PL0_THR_CNT_LAST_CNT_WIDTH   16
#define CRL_APB_PL0_THR_CNT_LAST_CNT_MASK    ((u32)0X0000FFFFU)

/**
 * Register: CRL_APB_PL1_THR_CTRL
 */
#define CRL_APB_PL1_THR_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000D8U) )

#define CRL_APB_PL1_THR_CTRL_CURR_VAL_SHIFT   16
#define CRL_APB_PL1_THR_CTRL_CURR_VAL_WIDTH   16
#define CRL_APB_PL1_THR_CTRL_CURR_VAL_MASK    ((u32)0XFFFF0000U)

#define CRL_APB_PL1_THR_CTRL_RUNNING_SHIFT   15
#define CRL_APB_PL1_THR_CTRL_RUNNING_WIDTH   1
#define CRL_APB_PL1_THR_CTRL_RUNNING_MASK    ((u32)0X00008000U)

#define CRL_APB_PL1_THR_CTRL_CPU_START_SHIFT   1
#define CRL_APB_PL1_THR_CTRL_CPU_START_WIDTH   1
#define CRL_APB_PL1_THR_CTRL_CPU_START_MASK    ((u32)0X00000002U)

#define CRL_APB_PL1_THR_CTRL_CNT_RST_SHIFT   0
#define CRL_APB_PL1_THR_CTRL_CNT_RST_WIDTH   1
#define CRL_APB_PL1_THR_CTRL_CNT_RST_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_PL1_THR_CNT
 */
#define CRL_APB_PL1_THR_CNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000DCU) )

#define CRL_APB_PL1_THR_CNT_LAST_CNT_SHIFT   0
#define CRL_APB_PL1_THR_CNT_LAST_CNT_WIDTH   16
#define CRL_APB_PL1_THR_CNT_LAST_CNT_MASK    ((u32)0X0000FFFFU)

/**
 * Register: CRL_APB_PL2_THR_CTRL
 */
#define CRL_APB_PL2_THR_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000E0U) )

#define CRL_APB_PL2_THR_CTRL_CURR_VAL_SHIFT   16
#define CRL_APB_PL2_THR_CTRL_CURR_VAL_WIDTH   16
#define CRL_APB_PL2_THR_CTRL_CURR_VAL_MASK    ((u32)0XFFFF0000U)

#define CRL_APB_PL2_THR_CTRL_RUNNING_SHIFT   15
#define CRL_APB_PL2_THR_CTRL_RUNNING_WIDTH   1
#define CRL_APB_PL2_THR_CTRL_RUNNING_MASK    ((u32)0X00008000U)

#define CRL_APB_PL2_THR_CTRL_CPU_START_SHIFT   1
#define CRL_APB_PL2_THR_CTRL_CPU_START_WIDTH   1
#define CRL_APB_PL2_THR_CTRL_CPU_START_MASK    ((u32)0X00000002U)

#define CRL_APB_PL2_THR_CTRL_CNT_RST_SHIFT   0
#define CRL_APB_PL2_THR_CTRL_CNT_RST_WIDTH   1
#define CRL_APB_PL2_THR_CTRL_CNT_RST_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_PL2_THR_CNT
 */
#define CRL_APB_PL2_THR_CNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000E4U) )

#define CRL_APB_PL2_THR_CNT_LAST_CNT_SHIFT   0
#define CRL_APB_PL2_THR_CNT_LAST_CNT_WIDTH   16
#define CRL_APB_PL2_THR_CNT_LAST_CNT_MASK    ((u32)0X0000FFFFU)

/**
 * Register: CRL_APB_PL3_THR_CTRL
 */
#define CRL_APB_PL3_THR_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000E8U) )

#define CRL_APB_PL3_THR_CTRL_CURR_VAL_SHIFT   16
#define CRL_APB_PL3_THR_CTRL_CURR_VAL_WIDTH   16
#define CRL_APB_PL3_THR_CTRL_CURR_VAL_MASK    ((u32)0XFFFF0000U)

#define CRL_APB_PL3_THR_CTRL_RUNNING_SHIFT   15
#define CRL_APB_PL3_THR_CTRL_RUNNING_WIDTH   1
#define CRL_APB_PL3_THR_CTRL_RUNNING_MASK    ((u32)0X00008000U)

#define CRL_APB_PL3_THR_CTRL_CPU_START_SHIFT   1
#define CRL_APB_PL3_THR_CTRL_CPU_START_WIDTH   1
#define CRL_APB_PL3_THR_CTRL_CPU_START_MASK    ((u32)0X00000002U)

#define CRL_APB_PL3_THR_CTRL_CNT_RST_SHIFT   0
#define CRL_APB_PL3_THR_CTRL_CNT_RST_WIDTH   1
#define CRL_APB_PL3_THR_CTRL_CNT_RST_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_PL3_THR_CNT
 */
#define CRL_APB_PL3_THR_CNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X000000FCU) )

#define CRL_APB_PL3_THR_CNT_LAST_CNT_SHIFT   0
#define CRL_APB_PL3_THR_CNT_LAST_CNT_WIDTH   16
#define CRL_APB_PL3_THR_CNT_LAST_CNT_MASK    ((u32)0X0000FFFFU)

/**
 * Register: CRL_APB_GEM_TSU_REF_CTRL
 */
#define CRL_APB_GEM_TSU_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000100U) )

#define CRL_APB_GEM_TSU_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_GEM_TSU_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_GEM_TSU_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_GEM_TSU_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_GEM_TSU_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_GEM_TSU_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_GEM_TSU_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_GEM_TSU_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_GEM_TSU_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_GEM_TSU_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_GEM_TSU_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_GEM_TSU_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_DLL_REF_CTRL
 */
#define CRL_APB_DLL_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000104U) )

#define CRL_APB_DLL_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_DLL_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_DLL_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_AMS_REF_CTRL
 */
#define CRL_APB_AMS_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000108U) )

#define CRL_APB_AMS_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_AMS_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_AMS_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_AMS_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_AMS_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_AMS_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_AMS_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_AMS_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_AMS_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_AMS_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_AMS_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_AMS_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_I2C0_REF_CTRL
 */
#define CRL_APB_I2C0_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000120U) )

#define CRL_APB_I2C0_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_I2C0_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_I2C0_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_I2C0_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_I2C0_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_I2C0_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_I2C0_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_I2C0_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_I2C0_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_I2C0_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_I2C0_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_I2C0_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_I2C1_REF_CTRL
 */
#define CRL_APB_I2C1_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000124U) )

#define CRL_APB_I2C1_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_I2C1_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_I2C1_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_I2C1_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_I2C1_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_I2C1_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_I2C1_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_I2C1_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_I2C1_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_I2C1_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_I2C1_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_I2C1_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_TIMESTAMP_REF_CTRL
 */
#define CRL_APB_TIMESTAMP_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000128U) )

#define CRL_APB_TIMESTAMP_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_TIMESTAMP_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_TIMESTAMP_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_TIMESTAMP_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_TIMESTAMP_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_TIMESTAMP_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_TIMESTAMP_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_TIMESTAMP_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_TIMESTAMP_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_SAFTEY_CHK
 */
#define CRL_APB_SAFTEY_CHK    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000130U) )

#define CRL_APB_SAFTEY_CHK_CHK_VAL_SHIFT   0
#define CRL_APB_SAFTEY_CHK_CHK_VAL_WIDTH   32
#define CRL_APB_SAFTEY_CHK_CHK_VAL_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CLKMON_STATUS
 */
#define CRL_APB_CLKMON_STATUS    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000140U) )

#define CRL_APB_CLKMON_STATUS_CNTA7_OVER_ERR_SHIFT   15
#define CRL_APB_CLKMON_STATUS_CNTA7_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_CNTA7_OVER_ERR_MASK    ((u32)0X00008000U)

#define CRL_APB_CLKMON_STATUS_MON7_ERR_SHIFT   14
#define CRL_APB_CLKMON_STATUS_MON7_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_MON7_ERR_MASK    ((u32)0X00004000U)

#define CRL_APB_CLKMON_STATUS_CNTA6_OVER_ERR_SHIFT   13
#define CRL_APB_CLKMON_STATUS_CNTA6_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_CNTA6_OVER_ERR_MASK    ((u32)0X00002000U)

#define CRL_APB_CLKMON_STATUS_MON6_ERR_SHIFT   12
#define CRL_APB_CLKMON_STATUS_MON6_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_MON6_ERR_MASK    ((u32)0X00001000U)

#define CRL_APB_CLKMON_STATUS_CNTA5_OVER_ERR_SHIFT   11
#define CRL_APB_CLKMON_STATUS_CNTA5_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_CNTA5_OVER_ERR_MASK    ((u32)0X00000800U)

#define CRL_APB_CLKMON_STATUS_MON5_ERR_SHIFT   10
#define CRL_APB_CLKMON_STATUS_MON5_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_MON5_ERR_MASK    ((u32)0X00000400U)

#define CRL_APB_CLKMON_STATUS_CNTA4_OVER_ERR_SHIFT   9
#define CRL_APB_CLKMON_STATUS_CNTA4_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_CNTA4_OVER_ERR_MASK    ((u32)0X00000200U)

#define CRL_APB_CLKMON_STATUS_MON4_ERR_SHIFT   8
#define CRL_APB_CLKMON_STATUS_MON4_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_MON4_ERR_MASK    ((u32)0X00000100U)

#define CRL_APB_CLKMON_STATUS_CNTA3_OVER_ERR_SHIFT   7
#define CRL_APB_CLKMON_STATUS_CNTA3_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_CNTA3_OVER_ERR_MASK    ((u32)0X00000080U)

#define CRL_APB_CLKMON_STATUS_MON3_ERR_SHIFT   6
#define CRL_APB_CLKMON_STATUS_MON3_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_MON3_ERR_MASK    ((u32)0X00000040U)

#define CRL_APB_CLKMON_STATUS_CNTA2_OVER_ERR_SHIFT   5
#define CRL_APB_CLKMON_STATUS_CNTA2_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_CNTA2_OVER_ERR_MASK    ((u32)0X00000020U)

#define CRL_APB_CLKMON_STATUS_MON2_ERR_SHIFT   4
#define CRL_APB_CLKMON_STATUS_MON2_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_MON2_ERR_MASK    ((u32)0X00000010U)

#define CRL_APB_CLKMON_STATUS_CNTA1_OVER_ERR_SHIFT   3
#define CRL_APB_CLKMON_STATUS_CNTA1_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_CNTA1_OVER_ERR_MASK    ((u32)0X00000008U)

#define CRL_APB_CLKMON_STATUS_MON1_ERR_SHIFT   2
#define CRL_APB_CLKMON_STATUS_MON1_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_MON1_ERR_MASK    ((u32)0X00000004U)

#define CRL_APB_CLKMON_STATUS_CNTA0_OVER_ERR_SHIFT   1
#define CRL_APB_CLKMON_STATUS_CNTA0_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_CNTA0_OVER_ERR_MASK    ((u32)0X00000002U)

#define CRL_APB_CLKMON_STATUS_MON0_ERR_SHIFT   0
#define CRL_APB_CLKMON_STATUS_MON0_ERR_WIDTH   1
#define CRL_APB_CLKMON_STATUS_MON0_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CLKMON_MASK
 */
#define CRL_APB_CLKMON_MASK    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000144U) )

#define CRL_APB_CLKMON_MASK_CNTA7_OVER_ERR_SHIFT   15
#define CRL_APB_CLKMON_MASK_CNTA7_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_CNTA7_OVER_ERR_MASK    ((u32)0X00008000U)

#define CRL_APB_CLKMON_MASK_MON7_ERR_SHIFT   14
#define CRL_APB_CLKMON_MASK_MON7_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_MON7_ERR_MASK    ((u32)0X00004000U)

#define CRL_APB_CLKMON_MASK_CNTA6_OVER_ERR_SHIFT   13
#define CRL_APB_CLKMON_MASK_CNTA6_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_CNTA6_OVER_ERR_MASK    ((u32)0X00002000U)

#define CRL_APB_CLKMON_MASK_MON6_ERR_SHIFT   12
#define CRL_APB_CLKMON_MASK_MON6_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_MON6_ERR_MASK    ((u32)0X00001000U)

#define CRL_APB_CLKMON_MASK_CNTA5_OVER_ERR_SHIFT   11
#define CRL_APB_CLKMON_MASK_CNTA5_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_CNTA5_OVER_ERR_MASK    ((u32)0X00000800U)

#define CRL_APB_CLKMON_MASK_MON5_ERR_SHIFT   10
#define CRL_APB_CLKMON_MASK_MON5_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_MON5_ERR_MASK    ((u32)0X00000400U)

#define CRL_APB_CLKMON_MASK_CNTA4_OVER_ERR_SHIFT   9
#define CRL_APB_CLKMON_MASK_CNTA4_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_CNTA4_OVER_ERR_MASK    ((u32)0X00000200U)

#define CRL_APB_CLKMON_MASK_MON4_ERR_SHIFT   8
#define CRL_APB_CLKMON_MASK_MON4_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_MON4_ERR_MASK    ((u32)0X00000100U)

#define CRL_APB_CLKMON_MASK_CNTA3_OVER_ERR_SHIFT   7
#define CRL_APB_CLKMON_MASK_CNTA3_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_CNTA3_OVER_ERR_MASK    ((u32)0X00000080U)

#define CRL_APB_CLKMON_MASK_MON3_ERR_SHIFT   6
#define CRL_APB_CLKMON_MASK_MON3_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_MON3_ERR_MASK    ((u32)0X00000040U)

#define CRL_APB_CLKMON_MASK_CNTA2_OVER_ERR_SHIFT   5
#define CRL_APB_CLKMON_MASK_CNTA2_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_CNTA2_OVER_ERR_MASK    ((u32)0X00000020U)

#define CRL_APB_CLKMON_MASK_MON2_ERR_SHIFT   4
#define CRL_APB_CLKMON_MASK_MON2_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_MON2_ERR_MASK    ((u32)0X00000010U)

#define CRL_APB_CLKMON_MASK_CNTA1_OVER_ERR_SHIFT   3
#define CRL_APB_CLKMON_MASK_CNTA1_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_CNTA1_OVER_ERR_MASK    ((u32)0X00000008U)

#define CRL_APB_CLKMON_MASK_MON1_ERR_SHIFT   2
#define CRL_APB_CLKMON_MASK_MON1_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_MON1_ERR_MASK    ((u32)0X00000004U)

#define CRL_APB_CLKMON_MASK_CNTA0_OVER_ERR_SHIFT   1
#define CRL_APB_CLKMON_MASK_CNTA0_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_CNTA0_OVER_ERR_MASK    ((u32)0X00000002U)

#define CRL_APB_CLKMON_MASK_MON0_ERR_SHIFT   0
#define CRL_APB_CLKMON_MASK_MON0_ERR_WIDTH   1
#define CRL_APB_CLKMON_MASK_MON0_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CLKMON_ENABLE
 */
#define CRL_APB_CLKMON_ENABLE    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000148U) )

#define CRL_APB_CLKMON_ENABLE_CNTA7_OVER_ERR_SHIFT   15
#define CRL_APB_CLKMON_ENABLE_CNTA7_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_CNTA7_OVER_ERR_MASK    ((u32)0X00008000U)

#define CRL_APB_CLKMON_ENABLE_MON7_ERR_SHIFT   14
#define CRL_APB_CLKMON_ENABLE_MON7_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_MON7_ERR_MASK    ((u32)0X00004000U)

#define CRL_APB_CLKMON_ENABLE_CNTA6_OVER_ERR_SHIFT   13
#define CRL_APB_CLKMON_ENABLE_CNTA6_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_CNTA6_OVER_ERR_MASK    ((u32)0X00002000U)

#define CRL_APB_CLKMON_ENABLE_MON6_ERR_SHIFT   12
#define CRL_APB_CLKMON_ENABLE_MON6_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_MON6_ERR_MASK    ((u32)0X00001000U)

#define CRL_APB_CLKMON_ENABLE_CNTA5_OVER_ERR_SHIFT   11
#define CRL_APB_CLKMON_ENABLE_CNTA5_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_CNTA5_OVER_ERR_MASK    ((u32)0X00000800U)

#define CRL_APB_CLKMON_ENABLE_MON5_ERR_SHIFT   10
#define CRL_APB_CLKMON_ENABLE_MON5_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_MON5_ERR_MASK    ((u32)0X00000400U)

#define CRL_APB_CLKMON_ENABLE_CNTA4_OVER_ERR_SHIFT   9
#define CRL_APB_CLKMON_ENABLE_CNTA4_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_CNTA4_OVER_ERR_MASK    ((u32)0X00000200U)

#define CRL_APB_CLKMON_ENABLE_MON4_ERR_SHIFT   8
#define CRL_APB_CLKMON_ENABLE_MON4_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_MON4_ERR_MASK    ((u32)0X00000100U)

#define CRL_APB_CLKMON_ENABLE_CNTA3_OVER_ERR_SHIFT   7
#define CRL_APB_CLKMON_ENABLE_CNTA3_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_CNTA3_OVER_ERR_MASK    ((u32)0X00000080U)

#define CRL_APB_CLKMON_ENABLE_MON3_ERR_SHIFT   6
#define CRL_APB_CLKMON_ENABLE_MON3_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_MON3_ERR_MASK    ((u32)0X00000040U)

#define CRL_APB_CLKMON_ENABLE_CNTA2_OVER_ERR_SHIFT   5
#define CRL_APB_CLKMON_ENABLE_CNTA2_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_CNTA2_OVER_ERR_MASK    ((u32)0X00000020U)

#define CRL_APB_CLKMON_ENABLE_MON2_ERR_SHIFT   4
#define CRL_APB_CLKMON_ENABLE_MON2_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_MON2_ERR_MASK    ((u32)0X00000010U)

#define CRL_APB_CLKMON_ENABLE_CNTA1_OVER_ERR_SHIFT   3
#define CRL_APB_CLKMON_ENABLE_CNTA1_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_CNTA1_OVER_ERR_MASK    ((u32)0X00000008U)

#define CRL_APB_CLKMON_ENABLE_MON1_ERR_SHIFT   2
#define CRL_APB_CLKMON_ENABLE_MON1_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_MON1_ERR_MASK    ((u32)0X00000004U)

#define CRL_APB_CLKMON_ENABLE_CNTA0_OVER_ERR_SHIFT   1
#define CRL_APB_CLKMON_ENABLE_CNTA0_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_CNTA0_OVER_ERR_MASK    ((u32)0X00000002U)

#define CRL_APB_CLKMON_ENABLE_MON0_ERR_SHIFT   0
#define CRL_APB_CLKMON_ENABLE_MON0_ERR_WIDTH   1
#define CRL_APB_CLKMON_ENABLE_MON0_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CLKMON_DISABLE
 */
#define CRL_APB_CLKMON_DISABLE    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000014CU) )

#define CRL_APB_CLKMON_DISABLE_CNTA7_OVER_ERR_SHIFT   15
#define CRL_APB_CLKMON_DISABLE_CNTA7_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_CNTA7_OVER_ERR_MASK    ((u32)0X00008000U)

#define CRL_APB_CLKMON_DISABLE_MON7_ERR_SHIFT   14
#define CRL_APB_CLKMON_DISABLE_MON7_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_MON7_ERR_MASK    ((u32)0X00004000U)

#define CRL_APB_CLKMON_DISABLE_CNTA6_OVER_ERR_SHIFT   13
#define CRL_APB_CLKMON_DISABLE_CNTA6_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_CNTA6_OVER_ERR_MASK    ((u32)0X00002000U)

#define CRL_APB_CLKMON_DISABLE_MON6_ERR_SHIFT   12
#define CRL_APB_CLKMON_DISABLE_MON6_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_MON6_ERR_MASK    ((u32)0X00001000U)

#define CRL_APB_CLKMON_DISABLE_CNTA5_OVER_ERR_SHIFT   11
#define CRL_APB_CLKMON_DISABLE_CNTA5_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_CNTA5_OVER_ERR_MASK    ((u32)0X00000800U)

#define CRL_APB_CLKMON_DISABLE_MON5_ERR_SHIFT   10
#define CRL_APB_CLKMON_DISABLE_MON5_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_MON5_ERR_MASK    ((u32)0X00000400U)

#define CRL_APB_CLKMON_DISABLE_CNTA4_OVER_ERR_SHIFT   9
#define CRL_APB_CLKMON_DISABLE_CNTA4_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_CNTA4_OVER_ERR_MASK    ((u32)0X00000200U)

#define CRL_APB_CLKMON_DISABLE_MON4_ERR_SHIFT   8
#define CRL_APB_CLKMON_DISABLE_MON4_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_MON4_ERR_MASK    ((u32)0X00000100U)

#define CRL_APB_CLKMON_DISABLE_CNTA3_OVER_ERR_SHIFT   7
#define CRL_APB_CLKMON_DISABLE_CNTA3_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_CNTA3_OVER_ERR_MASK    ((u32)0X00000080U)

#define CRL_APB_CLKMON_DISABLE_MON3_ERR_SHIFT   6
#define CRL_APB_CLKMON_DISABLE_MON3_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_MON3_ERR_MASK    ((u32)0X00000040U)

#define CRL_APB_CLKMON_DISABLE_CNTA2_OVER_ERR_SHIFT   5
#define CRL_APB_CLKMON_DISABLE_CNTA2_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_CNTA2_OVER_ERR_MASK    ((u32)0X00000020U)

#define CRL_APB_CLKMON_DISABLE_MON2_ERR_SHIFT   4
#define CRL_APB_CLKMON_DISABLE_MON2_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_MON2_ERR_MASK    ((u32)0X00000010U)

#define CRL_APB_CLKMON_DISABLE_CNTA1_OVER_ERR_SHIFT   3
#define CRL_APB_CLKMON_DISABLE_CNTA1_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_CNTA1_OVER_ERR_MASK    ((u32)0X00000008U)

#define CRL_APB_CLKMON_DISABLE_MON1_ERR_SHIFT   2
#define CRL_APB_CLKMON_DISABLE_MON1_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_MON1_ERR_MASK    ((u32)0X00000004U)

#define CRL_APB_CLKMON_DISABLE_CNTA0_OVER_ERR_SHIFT   1
#define CRL_APB_CLKMON_DISABLE_CNTA0_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_CNTA0_OVER_ERR_MASK    ((u32)0X00000002U)

#define CRL_APB_CLKMON_DISABLE_MON0_ERR_SHIFT   0
#define CRL_APB_CLKMON_DISABLE_MON0_ERR_WIDTH   1
#define CRL_APB_CLKMON_DISABLE_MON0_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CLKMON_TRIGGER
 */
#define CRL_APB_CLKMON_TRIGGER    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000150U) )

#define CRL_APB_CLKMON_TRIGGER_CNTA7_OVER_ERR_SHIFT   15
#define CRL_APB_CLKMON_TRIGGER_CNTA7_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_CNTA7_OVER_ERR_MASK    ((u32)0X00008000U)

#define CRL_APB_CLKMON_TRIGGER_MON7_ERR_SHIFT   14
#define CRL_APB_CLKMON_TRIGGER_MON7_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_MON7_ERR_MASK    ((u32)0X00004000U)

#define CRL_APB_CLKMON_TRIGGER_CNTA6_OVER_ERR_SHIFT   13
#define CRL_APB_CLKMON_TRIGGER_CNTA6_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_CNTA6_OVER_ERR_MASK    ((u32)0X00002000U)

#define CRL_APB_CLKMON_TRIGGER_MON6_ERR_SHIFT   12
#define CRL_APB_CLKMON_TRIGGER_MON6_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_MON6_ERR_MASK    ((u32)0X00001000U)

#define CRL_APB_CLKMON_TRIGGER_CNTA5_OVER_ERR_SHIFT   11
#define CRL_APB_CLKMON_TRIGGER_CNTA5_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_CNTA5_OVER_ERR_MASK    ((u32)0X00000800U)

#define CRL_APB_CLKMON_TRIGGER_MON5_ERR_SHIFT   10
#define CRL_APB_CLKMON_TRIGGER_MON5_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_MON5_ERR_MASK    ((u32)0X00000400U)

#define CRL_APB_CLKMON_TRIGGER_CNTA4_OVER_ERR_SHIFT   9
#define CRL_APB_CLKMON_TRIGGER_CNTA4_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_CNTA4_OVER_ERR_MASK    ((u32)0X00000200U)

#define CRL_APB_CLKMON_TRIGGER_MON4_ERR_SHIFT   8
#define CRL_APB_CLKMON_TRIGGER_MON4_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_MON4_ERR_MASK    ((u32)0X00000100U)

#define CRL_APB_CLKMON_TRIGGER_CNTA3_OVER_ERR_SHIFT   7
#define CRL_APB_CLKMON_TRIGGER_CNTA3_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_CNTA3_OVER_ERR_MASK    ((u32)0X00000080U)

#define CRL_APB_CLKMON_TRIGGER_MON3_ERR_SHIFT   6
#define CRL_APB_CLKMON_TRIGGER_MON3_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_MON3_ERR_MASK    ((u32)0X00000040U)

#define CRL_APB_CLKMON_TRIGGER_CNTA2_OVER_ERR_SHIFT   5
#define CRL_APB_CLKMON_TRIGGER_CNTA2_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_CNTA2_OVER_ERR_MASK    ((u32)0X00000020U)

#define CRL_APB_CLKMON_TRIGGER_MON2_ERR_SHIFT   4
#define CRL_APB_CLKMON_TRIGGER_MON2_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_MON2_ERR_MASK    ((u32)0X00000010U)

#define CRL_APB_CLKMON_TRIGGER_CNTA1_OVER_ERR_SHIFT   3
#define CRL_APB_CLKMON_TRIGGER_CNTA1_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_CNTA1_OVER_ERR_MASK    ((u32)0X00000008U)

#define CRL_APB_CLKMON_TRIGGER_MON1_ERR_SHIFT   2
#define CRL_APB_CLKMON_TRIGGER_MON1_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_MON1_ERR_MASK    ((u32)0X00000004U)

#define CRL_APB_CLKMON_TRIGGER_CNTA0_OVER_ERR_SHIFT   1
#define CRL_APB_CLKMON_TRIGGER_CNTA0_OVER_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_CNTA0_OVER_ERR_MASK    ((u32)0X00000002U)

#define CRL_APB_CLKMON_TRIGGER_MON0_ERR_SHIFT   0
#define CRL_APB_CLKMON_TRIGGER_MON0_ERR_WIDTH   1
#define CRL_APB_CLKMON_TRIGGER_MON0_ERR_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CHKR0_CLKA_UPPER
 */
#define CRL_APB_CHKR0_CLKA_UPPER    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000160U) )

#define CRL_APB_CHKR0_CLKA_UPPER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR0_CLKA_UPPER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR0_CLKA_UPPER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR0_CLKA_LOWER
 */
#define CRL_APB_CHKR0_CLKA_LOWER    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000164U) )

#define CRL_APB_CHKR0_CLKA_LOWER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR0_CLKA_LOWER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR0_CLKA_LOWER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR0_CLKB_CNT
 */
#define CRL_APB_CHKR0_CLKB_CNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000168U) )

#define CRL_APB_CHKR0_CLKB_CNT_VALUE_SHIFT   0
#define CRL_APB_CHKR0_CLKB_CNT_VALUE_WIDTH   32
#define CRL_APB_CHKR0_CLKB_CNT_VALUE_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR0_CTRL
 */
#define CRL_APB_CHKR0_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000016CU) )

#define CRL_APB_CHKR0_CTRL_START_SINGLE_SHIFT   8
#define CRL_APB_CHKR0_CTRL_START_SINGLE_WIDTH   1
#define CRL_APB_CHKR0_CTRL_START_SINGLE_MASK    ((u32)0X00000100U)

#define CRL_APB_CHKR0_CTRL_START_CONTINUOUS_SHIFT   7
#define CRL_APB_CHKR0_CTRL_START_CONTINUOUS_WIDTH   1
#define CRL_APB_CHKR0_CTRL_START_CONTINUOUS_MASK    ((u32)0X00000080U)

#define CRL_APB_CHKR0_CTRL_CLKB_MUX_CTRL_SHIFT   5
#define CRL_APB_CHKR0_CTRL_CLKB_MUX_CTRL_WIDTH   1
#define CRL_APB_CHKR0_CTRL_CLKB_MUX_CTRL_MASK    ((u32)0X00000020U)

#define CRL_APB_CHKR0_CTRL_CLKA_MUX_CTRL_SHIFT   1
#define CRL_APB_CHKR0_CTRL_CLKA_MUX_CTRL_WIDTH   3
#define CRL_APB_CHKR0_CTRL_CLKA_MUX_CTRL_MASK    ((u32)0X0000000EU)

#define CRL_APB_CHKR0_CTRL_ENABLE_SHIFT   0
#define CRL_APB_CHKR0_CTRL_ENABLE_WIDTH   1
#define CRL_APB_CHKR0_CTRL_ENABLE_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CHKR1_CLKA_UPPER
 */
#define CRL_APB_CHKR1_CLKA_UPPER    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000170U) )

#define CRL_APB_CHKR1_CLKA_UPPER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR1_CLKA_UPPER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR1_CLKA_UPPER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR1_CLKA_LOWER
 */
#define CRL_APB_CHKR1_CLKA_LOWER    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000174U) )

#define CRL_APB_CHKR1_CLKA_LOWER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR1_CLKA_LOWER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR1_CLKA_LOWER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR1_CLKB_CNT
 */
#define CRL_APB_CHKR1_CLKB_CNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000178U) )

#define CRL_APB_CHKR1_CLKB_CNT_VALUE_SHIFT   0
#define CRL_APB_CHKR1_CLKB_CNT_VALUE_WIDTH   32
#define CRL_APB_CHKR1_CLKB_CNT_VALUE_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR1_CTRL
 */
#define CRL_APB_CHKR1_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000017CU) )

#define CRL_APB_CHKR1_CTRL_START_SINGLE_SHIFT   8
#define CRL_APB_CHKR1_CTRL_START_SINGLE_WIDTH   1
#define CRL_APB_CHKR1_CTRL_START_SINGLE_MASK    ((u32)0X00000100U)

#define CRL_APB_CHKR1_CTRL_START_CONTINUOUS_SHIFT   7
#define CRL_APB_CHKR1_CTRL_START_CONTINUOUS_WIDTH   1
#define CRL_APB_CHKR1_CTRL_START_CONTINUOUS_MASK    ((u32)0X00000080U)

#define CRL_APB_CHKR1_CTRL_CLKB_MUX_CTRL_SHIFT   5
#define CRL_APB_CHKR1_CTRL_CLKB_MUX_CTRL_WIDTH   1
#define CRL_APB_CHKR1_CTRL_CLKB_MUX_CTRL_MASK    ((u32)0X00000020U)

#define CRL_APB_CHKR1_CTRL_CLKA_MUX_CTRL_SHIFT   1
#define CRL_APB_CHKR1_CTRL_CLKA_MUX_CTRL_WIDTH   3
#define CRL_APB_CHKR1_CTRL_CLKA_MUX_CTRL_MASK    ((u32)0X0000000EU)

#define CRL_APB_CHKR1_CTRL_ENABLE_SHIFT   0
#define CRL_APB_CHKR1_CTRL_ENABLE_WIDTH   1
#define CRL_APB_CHKR1_CTRL_ENABLE_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CHKR2_CLKA_UPPER
 */
#define CRL_APB_CHKR2_CLKA_UPPER    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000180U) )

#define CRL_APB_CHKR2_CLKA_UPPER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR2_CLKA_UPPER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR2_CLKA_UPPER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR2_CLKA_LOWER
 */
#define CRL_APB_CHKR2_CLKA_LOWER    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000184U) )

#define CRL_APB_CHKR2_CLKA_LOWER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR2_CLKA_LOWER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR2_CLKA_LOWER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR2_CLKB_CNT
 */
#define CRL_APB_CHKR2_CLKB_CNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000188U) )

#define CRL_APB_CHKR2_CLKB_CNT_VALUE_SHIFT   0
#define CRL_APB_CHKR2_CLKB_CNT_VALUE_WIDTH   32
#define CRL_APB_CHKR2_CLKB_CNT_VALUE_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR2_CTRL
 */
#define CRL_APB_CHKR2_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000018CU) )

#define CRL_APB_CHKR2_CTRL_START_SINGLE_SHIFT   8
#define CRL_APB_CHKR2_CTRL_START_SINGLE_WIDTH   1
#define CRL_APB_CHKR2_CTRL_START_SINGLE_MASK    ((u32)0X00000100U)

#define CRL_APB_CHKR2_CTRL_START_CONTINUOUS_SHIFT   7
#define CRL_APB_CHKR2_CTRL_START_CONTINUOUS_WIDTH   1
#define CRL_APB_CHKR2_CTRL_START_CONTINUOUS_MASK    ((u32)0X00000080U)

#define CRL_APB_CHKR2_CTRL_CLKB_MUX_CTRL_SHIFT   5
#define CRL_APB_CHKR2_CTRL_CLKB_MUX_CTRL_WIDTH   1
#define CRL_APB_CHKR2_CTRL_CLKB_MUX_CTRL_MASK    ((u32)0X00000020U)

#define CRL_APB_CHKR2_CTRL_CLKA_MUX_CTRL_SHIFT   1
#define CRL_APB_CHKR2_CTRL_CLKA_MUX_CTRL_WIDTH   3
#define CRL_APB_CHKR2_CTRL_CLKA_MUX_CTRL_MASK    ((u32)0X0000000EU)

#define CRL_APB_CHKR2_CTRL_ENABLE_SHIFT   0
#define CRL_APB_CHKR2_CTRL_ENABLE_WIDTH   1
#define CRL_APB_CHKR2_CTRL_ENABLE_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CHKR3_CLKA_UPPER
 */
#define CRL_APB_CHKR3_CLKA_UPPER    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000190U) )

#define CRL_APB_CHKR3_CLKA_UPPER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR3_CLKA_UPPER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR3_CLKA_UPPER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR3_CLKA_LOWER
 */
#define CRL_APB_CHKR3_CLKA_LOWER    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000194U) )

#define CRL_APB_CHKR3_CLKA_LOWER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR3_CLKA_LOWER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR3_CLKA_LOWER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR3_CLKB_CNT
 */
#define CRL_APB_CHKR3_CLKB_CNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000198U) )

#define CRL_APB_CHKR3_CLKB_CNT_VALUE_SHIFT   0
#define CRL_APB_CHKR3_CLKB_CNT_VALUE_WIDTH   32
#define CRL_APB_CHKR3_CLKB_CNT_VALUE_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR3_CTRL
 */
#define CRL_APB_CHKR3_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000019CU) )

#define CRL_APB_CHKR3_CTRL_START_SINGLE_SHIFT   8
#define CRL_APB_CHKR3_CTRL_START_SINGLE_WIDTH   1
#define CRL_APB_CHKR3_CTRL_START_SINGLE_MASK    ((u32)0X00000100U)

#define CRL_APB_CHKR3_CTRL_START_CONTINUOUS_SHIFT   7
#define CRL_APB_CHKR3_CTRL_START_CONTINUOUS_WIDTH   1
#define CRL_APB_CHKR3_CTRL_START_CONTINUOUS_MASK    ((u32)0X00000080U)

#define CRL_APB_CHKR3_CTRL_CLKB_MUX_CTRL_SHIFT   5
#define CRL_APB_CHKR3_CTRL_CLKB_MUX_CTRL_WIDTH   1
#define CRL_APB_CHKR3_CTRL_CLKB_MUX_CTRL_MASK    ((u32)0X00000020U)

#define CRL_APB_CHKR3_CTRL_CLKA_MUX_CTRL_SHIFT   1
#define CRL_APB_CHKR3_CTRL_CLKA_MUX_CTRL_WIDTH   3
#define CRL_APB_CHKR3_CTRL_CLKA_MUX_CTRL_MASK    ((u32)0X0000000EU)

#define CRL_APB_CHKR3_CTRL_ENABLE_SHIFT   0
#define CRL_APB_CHKR3_CTRL_ENABLE_WIDTH   1
#define CRL_APB_CHKR3_CTRL_ENABLE_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CHKR4_CLKA_UPPER
 */
#define CRL_APB_CHKR4_CLKA_UPPER    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001A0U) )

#define CRL_APB_CHKR4_CLKA_UPPER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR4_CLKA_UPPER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR4_CLKA_UPPER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR4_CLKA_LOWER
 */
#define CRL_APB_CHKR4_CLKA_LOWER    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001A4U) )

#define CRL_APB_CHKR4_CLKA_LOWER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR4_CLKA_LOWER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR4_CLKA_LOWER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR4_CLKB_CNT
 */
#define CRL_APB_CHKR4_CLKB_CNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001A8U) )

#define CRL_APB_CHKR4_CLKB_CNT_VALUE_SHIFT   0
#define CRL_APB_CHKR4_CLKB_CNT_VALUE_WIDTH   32
#define CRL_APB_CHKR4_CLKB_CNT_VALUE_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR4_CTRL
 */
#define CRL_APB_CHKR4_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001ACU) )

#define CRL_APB_CHKR4_CTRL_START_SINGLE_SHIFT   8
#define CRL_APB_CHKR4_CTRL_START_SINGLE_WIDTH   1
#define CRL_APB_CHKR4_CTRL_START_SINGLE_MASK    ((u32)0X00000100U)

#define CRL_APB_CHKR4_CTRL_START_CONTINUOUS_SHIFT   7
#define CRL_APB_CHKR4_CTRL_START_CONTINUOUS_WIDTH   1
#define CRL_APB_CHKR4_CTRL_START_CONTINUOUS_MASK    ((u32)0X00000080U)

#define CRL_APB_CHKR4_CTRL_CLKB_MUX_CTRL_SHIFT   5
#define CRL_APB_CHKR4_CTRL_CLKB_MUX_CTRL_WIDTH   1
#define CRL_APB_CHKR4_CTRL_CLKB_MUX_CTRL_MASK    ((u32)0X00000020U)

#define CRL_APB_CHKR4_CTRL_CLKA_MUX_CTRL_SHIFT   1
#define CRL_APB_CHKR4_CTRL_CLKA_MUX_CTRL_WIDTH   3
#define CRL_APB_CHKR4_CTRL_CLKA_MUX_CTRL_MASK    ((u32)0X0000000EU)

#define CRL_APB_CHKR4_CTRL_ENABLE_SHIFT   0
#define CRL_APB_CHKR4_CTRL_ENABLE_WIDTH   1
#define CRL_APB_CHKR4_CTRL_ENABLE_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CHKR5_CLKA_UPPER
 */
#define CRL_APB_CHKR5_CLKA_UPPER    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001B0U) )

#define CRL_APB_CHKR5_CLKA_UPPER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR5_CLKA_UPPER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR5_CLKA_UPPER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR5_CLKA_LOWER
 */
#define CRL_APB_CHKR5_CLKA_LOWER    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001B4U) )

#define CRL_APB_CHKR5_CLKA_LOWER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR5_CLKA_LOWER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR5_CLKA_LOWER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR5_CLKB_CNT
 */
#define CRL_APB_CHKR5_CLKB_CNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001B8U) )

#define CRL_APB_CHKR5_CLKB_CNT_VALUE_SHIFT   0
#define CRL_APB_CHKR5_CLKB_CNT_VALUE_WIDTH   32
#define CRL_APB_CHKR5_CLKB_CNT_VALUE_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR5_CTRL
 */
#define CRL_APB_CHKR5_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001BCU) )

#define CRL_APB_CHKR5_CTRL_START_SINGLE_SHIFT   8
#define CRL_APB_CHKR5_CTRL_START_SINGLE_WIDTH   1
#define CRL_APB_CHKR5_CTRL_START_SINGLE_MASK    ((u32)0X00000100U)

#define CRL_APB_CHKR5_CTRL_START_CONTINUOUS_SHIFT   7
#define CRL_APB_CHKR5_CTRL_START_CONTINUOUS_WIDTH   1
#define CRL_APB_CHKR5_CTRL_START_CONTINUOUS_MASK    ((u32)0X00000080U)

#define CRL_APB_CHKR5_CTRL_CLKB_MUX_CTRL_SHIFT   5
#define CRL_APB_CHKR5_CTRL_CLKB_MUX_CTRL_WIDTH   1
#define CRL_APB_CHKR5_CTRL_CLKB_MUX_CTRL_MASK    ((u32)0X00000020U)

#define CRL_APB_CHKR5_CTRL_CLKA_MUX_CTRL_SHIFT   1
#define CRL_APB_CHKR5_CTRL_CLKA_MUX_CTRL_WIDTH   3
#define CRL_APB_CHKR5_CTRL_CLKA_MUX_CTRL_MASK    ((u32)0X0000000EU)

#define CRL_APB_CHKR5_CTRL_ENABLE_SHIFT   0
#define CRL_APB_CHKR5_CTRL_ENABLE_WIDTH   1
#define CRL_APB_CHKR5_CTRL_ENABLE_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CHKR6_CLKA_UPPER
 */
#define CRL_APB_CHKR6_CLKA_UPPER    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001C0U) )

#define CRL_APB_CHKR6_CLKA_UPPER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR6_CLKA_UPPER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR6_CLKA_UPPER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR6_CLKA_LOWER
 */
#define CRL_APB_CHKR6_CLKA_LOWER    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001C4U) )

#define CRL_APB_CHKR6_CLKA_LOWER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR6_CLKA_LOWER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR6_CLKA_LOWER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR6_CLKB_CNT
 */
#define CRL_APB_CHKR6_CLKB_CNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001C8U) )

#define CRL_APB_CHKR6_CLKB_CNT_VALUE_SHIFT   0
#define CRL_APB_CHKR6_CLKB_CNT_VALUE_WIDTH   32
#define CRL_APB_CHKR6_CLKB_CNT_VALUE_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR6_CTRL
 */
#define CRL_APB_CHKR6_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001CCU) )

#define CRL_APB_CHKR6_CTRL_START_SINGLE_SHIFT   8
#define CRL_APB_CHKR6_CTRL_START_SINGLE_WIDTH   1
#define CRL_APB_CHKR6_CTRL_START_SINGLE_MASK    ((u32)0X00000100U)

#define CRL_APB_CHKR6_CTRL_START_CONTINUOUS_SHIFT   7
#define CRL_APB_CHKR6_CTRL_START_CONTINUOUS_WIDTH   1
#define CRL_APB_CHKR6_CTRL_START_CONTINUOUS_MASK    ((u32)0X00000080U)

#define CRL_APB_CHKR6_CTRL_CLKB_MUX_CTRL_SHIFT   5
#define CRL_APB_CHKR6_CTRL_CLKB_MUX_CTRL_WIDTH   1
#define CRL_APB_CHKR6_CTRL_CLKB_MUX_CTRL_MASK    ((u32)0X00000020U)

#define CRL_APB_CHKR6_CTRL_CLKA_MUX_CTRL_SHIFT   1
#define CRL_APB_CHKR6_CTRL_CLKA_MUX_CTRL_WIDTH   3
#define CRL_APB_CHKR6_CTRL_CLKA_MUX_CTRL_MASK    ((u32)0X0000000EU)

#define CRL_APB_CHKR6_CTRL_ENABLE_SHIFT   0
#define CRL_APB_CHKR6_CTRL_ENABLE_WIDTH   1
#define CRL_APB_CHKR6_CTRL_ENABLE_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_CHKR7_CLKA_UPPER
 */
#define CRL_APB_CHKR7_CLKA_UPPER    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001D0U) )

#define CRL_APB_CHKR7_CLKA_UPPER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR7_CLKA_UPPER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR7_CLKA_UPPER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR7_CLKA_LOWER
 */
#define CRL_APB_CHKR7_CLKA_LOWER    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001D4U) )

#define CRL_APB_CHKR7_CLKA_LOWER_THRSHLD_SHIFT   0
#define CRL_APB_CHKR7_CLKA_LOWER_THRSHLD_WIDTH   32
#define CRL_APB_CHKR7_CLKA_LOWER_THRSHLD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR7_CLKB_CNT
 */
#define CRL_APB_CHKR7_CLKB_CNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001D8U) )

#define CRL_APB_CHKR7_CLKB_CNT_VALUE_SHIFT   0
#define CRL_APB_CHKR7_CLKB_CNT_VALUE_WIDTH   32
#define CRL_APB_CHKR7_CLKB_CNT_VALUE_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_CHKR7_CTRL
 */
#define CRL_APB_CHKR7_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001DCU) )

#define CRL_APB_CHKR7_CTRL_START_SINGLE_SHIFT   8
#define CRL_APB_CHKR7_CTRL_START_SINGLE_WIDTH   1
#define CRL_APB_CHKR7_CTRL_START_SINGLE_MASK    ((u32)0X00000100U)

#define CRL_APB_CHKR7_CTRL_START_CONTINUOUS_SHIFT   7
#define CRL_APB_CHKR7_CTRL_START_CONTINUOUS_WIDTH   1
#define CRL_APB_CHKR7_CTRL_START_CONTINUOUS_MASK    ((u32)0X00000080U)

#define CRL_APB_CHKR7_CTRL_CLKB_MUX_CTRL_SHIFT   5
#define CRL_APB_CHKR7_CTRL_CLKB_MUX_CTRL_WIDTH   1
#define CRL_APB_CHKR7_CTRL_CLKB_MUX_CTRL_MASK    ((u32)0X00000020U)

#define CRL_APB_CHKR7_CTRL_CLKA_MUX_CTRL_SHIFT   1
#define CRL_APB_CHKR7_CTRL_CLKA_MUX_CTRL_WIDTH   3
#define CRL_APB_CHKR7_CTRL_CLKA_MUX_CTRL_MASK    ((u32)0X0000000EU)

#define CRL_APB_CHKR7_CTRL_ENABLE_SHIFT   0
#define CRL_APB_CHKR7_CTRL_ENABLE_WIDTH   1
#define CRL_APB_CHKR7_CTRL_ENABLE_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_PICDEBUG_TEMP_CTRL
 */
#define CRL_APB_PICDEBUG_TEMP_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001E0U) )

#define CRL_APB_PICDEBUG_TEMP_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_PICDEBUG_TEMP_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_PICDEBUG_TEMP_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_PICDEBUG_REF_CTRL
 */
#define CRL_APB_PICDEBUG_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001E4U) )

#define CRL_APB_PICDEBUG_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_PICDEBUG_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_PICDEBUG_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_PICDEBUG_REF_CTRL_DIVISOR1_SHIFT   16
#define CRL_APB_PICDEBUG_REF_CTRL_DIVISOR1_WIDTH   6
#define CRL_APB_PICDEBUG_REF_CTRL_DIVISOR1_MASK    ((u32)0X003F0000U)

#define CRL_APB_PICDEBUG_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_PICDEBUG_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_PICDEBUG_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_PICDEBUG_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_PICDEBUG_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_PICDEBUG_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_PICDEBUG_CTRL
 */
#define CRL_APB_PICDEBUG_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001E8U) )

#define CRL_APB_PICDEBUG_CTRL_START_SHIFT   4
#define CRL_APB_PICDEBUG_CTRL_START_WIDTH   1
#define CRL_APB_PICDEBUG_CTRL_START_MASK    ((u32)0X00000010U)

#define CRL_APB_PICDEBUG_CTRL_TRIGGER_SEL_SHIFT   2
#define CRL_APB_PICDEBUG_CTRL_TRIGGER_SEL_WIDTH   2
#define CRL_APB_PICDEBUG_CTRL_TRIGGER_SEL_MASK    ((u32)0X0000000CU)

#define CRL_APB_PICDEBUG_CTRL_CNT_LOAD_SHIFT   1
#define CRL_APB_PICDEBUG_CTRL_CNT_LOAD_WIDTH   1
#define CRL_APB_PICDEBUG_CTRL_CNT_LOAD_MASK    ((u32)0X00000002U)

#define CRL_APB_PICDEBUG_CTRL_TRIGGER_EN_SHIFT   0
#define CRL_APB_PICDEBUG_CTRL_TRIGGER_EN_WIDTH   1
#define CRL_APB_PICDEBUG_CTRL_TRIGGER_EN_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_PICDEBUG_LCNT
 */
#define CRL_APB_PICDEBUG_LCNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001ECU) )

#define CRL_APB_PICDEBUG_LCNT_VALUE_SHIFT   0
#define CRL_APB_PICDEBUG_LCNT_VALUE_WIDTH   32
#define CRL_APB_PICDEBUG_LCNT_VALUE_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: CRL_APB_PICDEBUG_UCNT
 */
#define CRL_APB_PICDEBUG_UCNT    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001F0U) )

#define CRL_APB_PICDEBUG_UCNT_VALUE_SHIFT   0
#define CRL_APB_PICDEBUG_UCNT_VALUE_WIDTH   16
#define CRL_APB_PICDEBUG_UCNT_VALUE_MASK    ((u32)0X0000FFFFU)

/**
 * Register: CRL_APB_USB3_DUAL_SCAN_CTRL
 */
#define CRL_APB_USB3_DUAL_SCAN_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001F4U) )

#define CRL_APB_USB3_DUAL_SCAN_CTRL_CLKACT_SHIFT   24
#define CRL_APB_USB3_DUAL_SCAN_CTRL_CLKACT_WIDTH   1
#define CRL_APB_USB3_DUAL_SCAN_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_USB3_DUAL_SCAN_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_USB3_DUAL_SCAN_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_USB3_DUAL_SCAN_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_USB3_DUAL_SCAN_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_USB3_DUAL_SCAN_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_USB3_DUAL_SCAN_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_DFT_OSC_REF_CTRL
 */
#define CRL_APB_DFT_OSC_REF_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X000001F8U) )

#define CRL_APB_DFT_OSC_REF_CTRL_CLKACT_SHIFT   24
#define CRL_APB_DFT_OSC_REF_CTRL_CLKACT_WIDTH   1
#define CRL_APB_DFT_OSC_REF_CTRL_CLKACT_MASK    ((u32)0X01000000U)

#define CRL_APB_DFT_OSC_REF_CTRL_DIVISOR0_SHIFT   8
#define CRL_APB_DFT_OSC_REF_CTRL_DIVISOR0_WIDTH   6
#define CRL_APB_DFT_OSC_REF_CTRL_DIVISOR0_MASK    ((u32)0X00003F00U)

#define CRL_APB_DFT_OSC_REF_CTRL_SRCSEL_SHIFT   0
#define CRL_APB_DFT_OSC_REF_CTRL_SRCSEL_WIDTH   3
#define CRL_APB_DFT_OSC_REF_CTRL_SRCSEL_MASK    ((u32)0X00000007U)

/**
 * Register: CRL_APB_BOOT_MODE_USER
 */
#define CRL_APB_BOOT_MODE_USER    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000200U) )

#define CRL_APB_BOOT_MODE_USER_ALT_BOOT_MODE_SHIFT   12
#define CRL_APB_BOOT_MODE_USER_ALT_BOOT_MODE_WIDTH   4
#define CRL_APB_BOOT_MODE_USER_ALT_BOOT_MODE_MASK    ((u32)0X0000F000U)

#define CRL_APB_BOOT_MODE_USER_USE_ALT_SHIFT   8
#define CRL_APB_BOOT_MODE_USER_USE_ALT_WIDTH   1
#define CRL_APB_BOOT_MODE_USER_USE_ALT_MASK    ((u32)0X00000100U)

#define CRL_APB_BOOT_MODE_USER_BOOT_MODE_SHIFT   0
#define CRL_APB_BOOT_MODE_USER_BOOT_MODE_WIDTH   4
#define CRL_APB_BOOT_MODE_USER_BOOT_MODE_MASK    ((u32)0X0000000FU)

/**
 * Register: CRL_APB_BOOT_MODE_POR
 */
#define CRL_APB_BOOT_MODE_POR    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000204U) )

#define CRL_APB_BOOT_MODE_POR_BOOT_MODE2_SHIFT   8
#define CRL_APB_BOOT_MODE_POR_BOOT_MODE2_WIDTH   4
#define CRL_APB_BOOT_MODE_POR_BOOT_MODE2_MASK    ((u32)0X00000F00U)

#define CRL_APB_BOOT_MODE_POR_BOOT_MODE1_SHIFT   4
#define CRL_APB_BOOT_MODE_POR_BOOT_MODE1_WIDTH   4
#define CRL_APB_BOOT_MODE_POR_BOOT_MODE1_MASK    ((u32)0X000000F0U)

#define CRL_APB_BOOT_MODE_POR_BOOT_MODE0_SHIFT   0
#define CRL_APB_BOOT_MODE_POR_BOOT_MODE0_WIDTH   4
#define CRL_APB_BOOT_MODE_POR_BOOT_MODE0_MASK    ((u32)0X0000000FU)

/**
 * Register: CRL_APB_MIMIC_RST
 */
#define CRL_APB_MIMIC_RST    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000214U) )

#define CRL_APB_MIMIC_RST_PSONLY_SHIFT   5
#define CRL_APB_MIMIC_RST_PSONLY_WIDTH   1
#define CRL_APB_MIMIC_RST_PSONLY_MASK    ((u32)0X00000020U)

#define CRL_APB_MIMIC_RST_DEBUG_ONLY_SHIFT   4
#define CRL_APB_MIMIC_RST_DEBUG_ONLY_WIDTH   1
#define CRL_APB_MIMIC_RST_DEBUG_ONLY_MASK    ((u32)0X00000010U)

#define CRL_APB_MIMIC_RST_DEBUG_SYS_SHIFT   3
#define CRL_APB_MIMIC_RST_DEBUG_SYS_WIDTH   1
#define CRL_APB_MIMIC_RST_DEBUG_SYS_MASK    ((u32)0X00000008U)

#define CRL_APB_MIMIC_RST_SOFT_SHIFT   2
#define CRL_APB_MIMIC_RST_SOFT_WIDTH   1
#define CRL_APB_MIMIC_RST_SOFT_MASK    ((u32)0X00000004U)

#define CRL_APB_MIMIC_RST_SRST_SHIFT   1
#define CRL_APB_MIMIC_RST_SRST_WIDTH   1
#define CRL_APB_MIMIC_RST_SRST_MASK    ((u32)0X00000002U)

#define CRL_APB_MIMIC_RST_PMU_SYS_SHIFT   0
#define CRL_APB_MIMIC_RST_PMU_SYS_WIDTH   1
#define CRL_APB_MIMIC_RST_PMU_SYS_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_RESET_CTRL
 */
#define CRL_APB_RESET_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000218U) )

#define CRL_APB_RESET_CTRL_SOFT_RESET_SHIFT   4
#define CRL_APB_RESET_CTRL_SOFT_RESET_WIDTH   1
#define CRL_APB_RESET_CTRL_SOFT_RESET_MASK    ((u32)0X00000010U)

#define CRL_APB_RESET_CTRL_SRST_DIS_SHIFT   0
#define CRL_APB_RESET_CTRL_SRST_DIS_WIDTH   1
#define CRL_APB_RESET_CTRL_SRST_DIS_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_BLOCKONLY_RST
 */
#define CRL_APB_BLOCKONLY_RST    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000021CU) )

#define CRL_APB_BLOCKONLY_RST_MIMIC_SHIFT   3
#define CRL_APB_BLOCKONLY_RST_MIMIC_WIDTH   1
#define CRL_APB_BLOCKONLY_RST_MIMIC_MASK    ((u32)0X00000008U)

#define CRL_APB_BLOCKONLY_RST_DEBUG_ONLY_SHIFT   0
#define CRL_APB_BLOCKONLY_RST_DEBUG_ONLY_WIDTH   1
#define CRL_APB_BLOCKONLY_RST_DEBUG_ONLY_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_RESET_REASON
 */
#define CRL_APB_RESET_REASON    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000220U) )

#define CRL_APB_RESET_REASON_MIMIC_SHIFT   15
#define CRL_APB_RESET_REASON_MIMIC_WIDTH   1
#define CRL_APB_RESET_REASON_MIMIC_MASK    ((u32)0X00008000U)

#define CRL_APB_RESET_REASON_DEBUG_SYS_SHIFT   6
#define CRL_APB_RESET_REASON_DEBUG_SYS_WIDTH   1
#define CRL_APB_RESET_REASON_DEBUG_SYS_MASK    ((u32)0X00000040U)

#define CRL_APB_RESET_REASON_SOFT_SHIFT   5
#define CRL_APB_RESET_REASON_SOFT_WIDTH   1
#define CRL_APB_RESET_REASON_SOFT_MASK    ((u32)0X00000020U)

#define CRL_APB_RESET_REASON_SRST_SHIFT   4
#define CRL_APB_RESET_REASON_SRST_WIDTH   1
#define CRL_APB_RESET_REASON_SRST_MASK    ((u32)0X00000010U)

#define CRL_APB_RESET_REASON_PSONLY_RESET_REQ_SHIFT   3
#define CRL_APB_RESET_REASON_PSONLY_RESET_REQ_WIDTH   1
#define CRL_APB_RESET_REASON_PSONLY_RESET_REQ_MASK    ((u32)0X00000008U)

#define CRL_APB_RESET_REASON_PMU_SYS_RESET_SHIFT   2
#define CRL_APB_RESET_REASON_PMU_SYS_RESET_WIDTH   1
#define CRL_APB_RESET_REASON_PMU_SYS_RESET_MASK    ((u32)0X00000004U)

#define CRL_APB_RESET_REASON_INTERNAL_POR_SHIFT   1
#define CRL_APB_RESET_REASON_INTERNAL_POR_WIDTH   1
#define CRL_APB_RESET_REASON_INTERNAL_POR_MASK    ((u32)0X00000002U)

#define CRL_APB_RESET_REASON_EXTERNAL_POR_SHIFT   0
#define CRL_APB_RESET_REASON_EXTERNAL_POR_WIDTH   1
#define CRL_APB_RESET_REASON_EXTERNAL_POR_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_RST_LPD_IOU0
 */
#define CRL_APB_RST_LPD_IOU0    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000230U) )

#define CRL_APB_RST_LPD_IOU0_GEM3_RESET_SHIFT   3
#define CRL_APB_RST_LPD_IOU0_GEM3_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU0_GEM3_RESET_MASK    ((u32)0X00000008U)

#define CRL_APB_RST_LPD_IOU0_GEM2_RESET_SHIFT   2
#define CRL_APB_RST_LPD_IOU0_GEM2_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU0_GEM2_RESET_MASK    ((u32)0X00000004U)

#define CRL_APB_RST_LPD_IOU0_GEM1_RESET_SHIFT   1
#define CRL_APB_RST_LPD_IOU0_GEM1_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU0_GEM1_RESET_MASK    ((u32)0X00000002U)

#define CRL_APB_RST_LPD_IOU0_GEM0_RESET_SHIFT   0
#define CRL_APB_RST_LPD_IOU0_GEM0_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU0_GEM0_RESET_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_RST_LPD_IOU1
 */
#define CRL_APB_RST_LPD_IOU1    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000234U) )

/**
 * Register: CRL_APB_RST_LPD_IOU2
 */
#define CRL_APB_RST_LPD_IOU2    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000238U) )

#define CRL_APB_RST_LPD_IOU2_TIMESTAMP_RESET_SHIFT   20
#define CRL_APB_RST_LPD_IOU2_TIMESTAMP_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_TIMESTAMP_RESET_MASK    ((u32)0X00100000U)

#define CRL_APB_RST_LPD_IOU2_IOU_CC_RESET_SHIFT   19
#define CRL_APB_RST_LPD_IOU2_IOU_CC_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_IOU_CC_RESET_MASK    ((u32)0X00080000U)

#define CRL_APB_RST_LPD_IOU2_GPIO_RESET_SHIFT   18
#define CRL_APB_RST_LPD_IOU2_GPIO_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_GPIO_RESET_MASK    ((u32)0X00040000U)

#define CRL_APB_RST_LPD_IOU2_ADMA_RESET_SHIFT   17
#define CRL_APB_RST_LPD_IOU2_ADMA_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_ADMA_RESET_MASK    ((u32)0X00020000U)

#define CRL_APB_RST_LPD_IOU2_NAND_RESET_SHIFT   16
#define CRL_APB_RST_LPD_IOU2_NAND_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_NAND_RESET_MASK    ((u32)0X00010000U)

#define CRL_APB_RST_LPD_IOU2_SWDT_RESET_SHIFT   15
#define CRL_APB_RST_LPD_IOU2_SWDT_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_SWDT_RESET_MASK    ((u32)0X00008000U)

#define CRL_APB_RST_LPD_IOU2_TTC3_RESET_SHIFT   14
#define CRL_APB_RST_LPD_IOU2_TTC3_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_TTC3_RESET_MASK    ((u32)0X00004000U)

#define CRL_APB_RST_LPD_IOU2_TTC2_RESET_SHIFT   13
#define CRL_APB_RST_LPD_IOU2_TTC2_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_TTC2_RESET_MASK    ((u32)0X00002000U)

#define CRL_APB_RST_LPD_IOU2_TTC1_RESET_SHIFT   12
#define CRL_APB_RST_LPD_IOU2_TTC1_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_TTC1_RESET_MASK    ((u32)0X00001000U)

#define CRL_APB_RST_LPD_IOU2_TTC0_RESET_SHIFT   11
#define CRL_APB_RST_LPD_IOU2_TTC0_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_TTC0_RESET_MASK    ((u32)0X00000800U)

#define CRL_APB_RST_LPD_IOU2_I2C1_RESET_SHIFT   10
#define CRL_APB_RST_LPD_IOU2_I2C1_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_I2C1_RESET_MASK    ((u32)0X00000400U)

#define CRL_APB_RST_LPD_IOU2_I2C0_RESET_SHIFT   9
#define CRL_APB_RST_LPD_IOU2_I2C0_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_I2C0_RESET_MASK    ((u32)0X00000200U)

#define CRL_APB_RST_LPD_IOU2_CAN1_RESET_SHIFT   8
#define CRL_APB_RST_LPD_IOU2_CAN1_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_CAN1_RESET_MASK    ((u32)0X00000100U)

#define CRL_APB_RST_LPD_IOU2_CAN0_RESET_SHIFT   7
#define CRL_APB_RST_LPD_IOU2_CAN0_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_CAN0_RESET_MASK    ((u32)0X00000080U)

#define CRL_APB_RST_LPD_IOU2_SDIO1_RESET_SHIFT   6
#define CRL_APB_RST_LPD_IOU2_SDIO1_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_SDIO1_RESET_MASK    ((u32)0X00000040U)

#define CRL_APB_RST_LPD_IOU2_SDIO0_RESET_SHIFT   5
#define CRL_APB_RST_LPD_IOU2_SDIO0_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_SDIO0_RESET_MASK    ((u32)0X00000020U)

#define CRL_APB_RST_LPD_IOU2_SPI1_RESET_SHIFT   4
#define CRL_APB_RST_LPD_IOU2_SPI1_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_SPI1_RESET_MASK    ((u32)0X00000010U)

#define CRL_APB_RST_LPD_IOU2_SPI0_RESET_SHIFT   3
#define CRL_APB_RST_LPD_IOU2_SPI0_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_SPI0_RESET_MASK    ((u32)0X00000008U)

#define CRL_APB_RST_LPD_IOU2_UART1_RESET_SHIFT   2
#define CRL_APB_RST_LPD_IOU2_UART1_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_UART1_RESET_MASK    ((u32)0X00000004U)

#define CRL_APB_RST_LPD_IOU2_UART0_RESET_SHIFT   1
#define CRL_APB_RST_LPD_IOU2_UART0_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_UART0_RESET_MASK    ((u32)0X00000002U)

#define CRL_APB_RST_LPD_IOU2_QSPI_RESET_SHIFT   0
#define CRL_APB_RST_LPD_IOU2_QSPI_RESET_WIDTH   1
#define CRL_APB_RST_LPD_IOU2_QSPI_RESET_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_RST_LPD_TOP
 */
#define CRL_APB_RST_LPD_TOP    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000023CU) )

#define CRL_APB_RST_LPD_TOP_FPD_RESET_SHIFT   23
#define CRL_APB_RST_LPD_TOP_FPD_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_FPD_RESET_MASK    ((u32)0X00800000U)

#define CRL_APB_RST_LPD_TOP_LPD_SWDT_RESET_SHIFT   20
#define CRL_APB_RST_LPD_TOP_LPD_SWDT_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_LPD_SWDT_RESET_MASK    ((u32)0X00100000U)

#define CRL_APB_RST_LPD_TOP_AFI_FM6_RESET_SHIFT   19
#define CRL_APB_RST_LPD_TOP_AFI_FM6_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_AFI_FM6_RESET_MASK    ((u32)0X00080000U)

#define CRL_APB_RST_LPD_TOP_SYSMON_RESET_SHIFT   17
#define CRL_APB_RST_LPD_TOP_SYSMON_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_SYSMON_RESET_MASK    ((u32)0X00020000U)

#define CRL_APB_RST_LPD_TOP_RTC_RESET_SHIFT   16
#define CRL_APB_RST_LPD_TOP_RTC_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_RTC_RESET_MASK    ((u32)0X00010000U)

#define CRL_APB_RST_LPD_TOP_APM_RESET_SHIFT   15
#define CRL_APB_RST_LPD_TOP_APM_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_APM_RESET_MASK    ((u32)0X00008000U)

#define CRL_APB_RST_LPD_TOP_IPI_RESET_SHIFT   14
#define CRL_APB_RST_LPD_TOP_IPI_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_IPI_RESET_MASK    ((u32)0X00004000U)

#define CRL_APB_RST_LPD_TOP_USB1_APB_RESET_SHIFT   11
#define CRL_APB_RST_LPD_TOP_USB1_APB_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_USB1_APB_RESET_MASK    ((u32)0X00000800U)

#define CRL_APB_RST_LPD_TOP_USB0_APB_RESET_SHIFT   10
#define CRL_APB_RST_LPD_TOP_USB0_APB_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_USB0_APB_RESET_MASK    ((u32)0X00000400U)

#define CRL_APB_RST_LPD_TOP_USB1_HIBERRESET_SHIFT   9
#define CRL_APB_RST_LPD_TOP_USB1_HIBERRESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_USB1_HIBERRESET_MASK    ((u32)0X00000200U)

#define CRL_APB_RST_LPD_TOP_USB0_HIBERRESET_SHIFT   8
#define CRL_APB_RST_LPD_TOP_USB0_HIBERRESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_USB0_HIBERRESET_MASK    ((u32)0X00000100U)

#define CRL_APB_RST_LPD_TOP_USB1_CORERESET_SHIFT   7
#define CRL_APB_RST_LPD_TOP_USB1_CORERESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_USB1_CORERESET_MASK    ((u32)0X00000080U)

#define CRL_APB_RST_LPD_TOP_USB0_CORERESET_SHIFT   6
#define CRL_APB_RST_LPD_TOP_USB0_CORERESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_USB0_CORERESET_MASK    ((u32)0X00000040U)

#define CRL_APB_RST_LPD_TOP_RPU_PGE_RESET_SHIFT   4
#define CRL_APB_RST_LPD_TOP_RPU_PGE_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_RPU_PGE_RESET_MASK    ((u32)0X00000010U)

#define CRL_APB_RST_LPD_TOP_OCM_RESET_SHIFT   3
#define CRL_APB_RST_LPD_TOP_OCM_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_OCM_RESET_MASK    ((u32)0X00000008U)

#define CRL_APB_RST_LPD_TOP_RPU_AMBA_RESET_SHIFT   2
#define CRL_APB_RST_LPD_TOP_RPU_AMBA_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_RPU_AMBA_RESET_MASK    ((u32)0X00000004U)

#define CRL_APB_RST_LPD_TOP_RPU_R51_RESET_SHIFT   1
#define CRL_APB_RST_LPD_TOP_RPU_R51_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_RPU_R51_RESET_MASK    ((u32)0X00000002U)

#define CRL_APB_RST_LPD_TOP_RPU_R50_RESET_SHIFT   0
#define CRL_APB_RST_LPD_TOP_RPU_R50_RESET_WIDTH   1
#define CRL_APB_RST_LPD_TOP_RPU_R50_RESET_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_RST_LPD_DBG
 */
#define CRL_APB_RST_LPD_DBG    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000240U) )

#define CRL_APB_RST_LPD_DBG_DBG_ACK_SHIFT   15
#define CRL_APB_RST_LPD_DBG_DBG_ACK_WIDTH   1
#define CRL_APB_RST_LPD_DBG_DBG_ACK_MASK    ((u32)0X00008000U)

#define CRL_APB_RST_LPD_DBG_RPU_DBG1_RESET_SHIFT   5
#define CRL_APB_RST_LPD_DBG_RPU_DBG1_RESET_WIDTH   1
#define CRL_APB_RST_LPD_DBG_RPU_DBG1_RESET_MASK    ((u32)0X00000020U)

#define CRL_APB_RST_LPD_DBG_RPU_DBG0_RESET_SHIFT   4
#define CRL_APB_RST_LPD_DBG_RPU_DBG0_RESET_WIDTH   1
#define CRL_APB_RST_LPD_DBG_RPU_DBG0_RESET_MASK    ((u32)0X00000010U)

#define CRL_APB_RST_LPD_DBG_DBG_LPD_RESET_SHIFT   1
#define CRL_APB_RST_LPD_DBG_DBG_LPD_RESET_WIDTH   1
#define CRL_APB_RST_LPD_DBG_DBG_LPD_RESET_MASK    ((u32)0X00000002U)

#define CRL_APB_RST_LPD_DBG_DBG_FPD_RESET_SHIFT   0
#define CRL_APB_RST_LPD_DBG_DBG_FPD_RESET_WIDTH   1
#define CRL_APB_RST_LPD_DBG_DBG_FPD_RESET_MASK    ((u32)0X00000001U)

/**
 * Register: CRL_APB_BOOT_PIN_CTRL
 */
#define CRL_APB_BOOT_PIN_CTRL    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000250U) )

#define CRL_APB_BOOT_PIN_CTRL_OUT_VAL_SHIFT   8
#define CRL_APB_BOOT_PIN_CTRL_OUT_VAL_WIDTH   4
#define CRL_APB_BOOT_PIN_CTRL_OUT_VAL_MASK    ((u32)0X00000F00U)

#define CRL_APB_BOOT_PIN_CTRL_IN_VAL_SHIFT   4
#define CRL_APB_BOOT_PIN_CTRL_IN_VAL_WIDTH   4
#define CRL_APB_BOOT_PIN_CTRL_IN_VAL_MASK    ((u32)0X000000F0U)

#define CRL_APB_BOOT_PIN_CTRL_OUT_EN_SHIFT   0
#define CRL_APB_BOOT_PIN_CTRL_OUT_EN_WIDTH   4
#define CRL_APB_BOOT_PIN_CTRL_OUT_EN_MASK    ((u32)0X0000000FU)

/**
 * Register: CRL_APB_DED_IOB_CTRL0
 */
#define CRL_APB_DED_IOB_CTRL0    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000254U) )

#define CRL_APB_DED_IOB_CTRL0_DRIVE0_SHIFT   0
#define CRL_APB_DED_IOB_CTRL0_DRIVE0_WIDTH   4
#define CRL_APB_DED_IOB_CTRL0_DRIVE0_MASK    ((u32)0X0000000FU)

/**
 * Register: CRL_APB_DED_IOB_CTRL1
 */
#define CRL_APB_DED_IOB_CTRL1    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000258U) )

#define CRL_APB_DED_IOB_CTRL1_DRIVE1_SHIFT   0
#define CRL_APB_DED_IOB_CTRL1_DRIVE1_WIDTH   4
#define CRL_APB_DED_IOB_CTRL1_DRIVE1_MASK    ((u32)0X0000000FU)

/**
 * Register: CRL_APB_DED_IOB_CTRL2
 */
#define CRL_APB_DED_IOB_CTRL2    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000025CU) )

#define CRL_APB_DED_IOB_CTRL2_SCHMITT_CMOS_N_SHIFT   0
#define CRL_APB_DED_IOB_CTRL2_SCHMITT_CMOS_N_WIDTH   4
#define CRL_APB_DED_IOB_CTRL2_SCHMITT_CMOS_N_MASK    ((u32)0X0000000FU)

/**
 * Register: CRL_APB_DED_IOB_CTRL3
 */
#define CRL_APB_DED_IOB_CTRL3    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000260U) )

#define CRL_APB_DED_IOB_CTRL3_PULL_HIGH_LOW_N_SHIFT   0
#define CRL_APB_DED_IOB_CTRL3_PULL_HIGH_LOW_N_WIDTH   4
#define CRL_APB_DED_IOB_CTRL3_PULL_HIGH_LOW_N_MASK    ((u32)0X0000000FU)

/**
 * Register: CRL_APB_DED_IOB_CTRL4
 */
#define CRL_APB_DED_IOB_CTRL4    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000264U) )

#define CRL_APB_DED_IOB_CTRL4_PULL_ENABLE_SHIFT   0
#define CRL_APB_DED_IOB_CTRL4_PULL_ENABLE_WIDTH   4
#define CRL_APB_DED_IOB_CTRL4_PULL_ENABLE_MASK    ((u32)0X0000000FU)

/**
 * Register: CRL_APB_DED_IOB_CTRL5
 */
#define CRL_APB_DED_IOB_CTRL5    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000268U) )

#define CRL_APB_DED_IOB_CTRL5_SLOW_FAST_SLEW_N_SHIFT   0
#define CRL_APB_DED_IOB_CTRL5_SLOW_FAST_SLEW_N_WIDTH   4
#define CRL_APB_DED_IOB_CTRL5_SLOW_FAST_SLEW_N_MASK    ((u32)0X0000000FU)

/**
 * Register: CRL_APB_BANK3_CTRL0
 */
#define CRL_APB_BANK3_CTRL0    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000270U) )

#define CRL_APB_BANK3_CTRL0_DRIVE0_SHIFT   0
#define CRL_APB_BANK3_CTRL0_DRIVE0_WIDTH   10
#define CRL_APB_BANK3_CTRL0_DRIVE0_MASK    ((u32)0X000003FFU)

/**
 * Register: CRL_APB_BANK3_CTRL1
 */
#define CRL_APB_BANK3_CTRL1    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000274U) )

#define CRL_APB_BANK3_CTRL1_DRIVE1_SHIFT   0
#define CRL_APB_BANK3_CTRL1_DRIVE1_WIDTH   10
#define CRL_APB_BANK3_CTRL1_DRIVE1_MASK    ((u32)0X000003FFU)

/**
 * Register: CRL_APB_BANK3_CTRL2
 */
#define CRL_APB_BANK3_CTRL2    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000278U) )

#define CRL_APB_BANK3_CTRL2_SCHMITT_CMOS_N_SHIFT   0
#define CRL_APB_BANK3_CTRL2_SCHMITT_CMOS_N_WIDTH   10
#define CRL_APB_BANK3_CTRL2_SCHMITT_CMOS_N_MASK    ((u32)0X000003FFU)

/**
 * Register: CRL_APB_BANK3_CTRL3
 */
#define CRL_APB_BANK3_CTRL3    ( ( CRL_APB_BASEADDR ) + ((u32)0X0000027CU) )

#define CRL_APB_BANK3_CTRL3_PULL_HIGH_LOW_N_SHIFT   0
#define CRL_APB_BANK3_CTRL3_PULL_HIGH_LOW_N_WIDTH   10
#define CRL_APB_BANK3_CTRL3_PULL_HIGH_LOW_N_MASK    ((u32)0X000003FFU)

/**
 * Register: CRL_APB_BANK3_CTRL4
 */
#define CRL_APB_BANK3_CTRL4    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000280U) )

#define CRL_APB_BANK3_CTRL4_PULL_ENABLE_SHIFT   0
#define CRL_APB_BANK3_CTRL4_PULL_ENABLE_WIDTH   10
#define CRL_APB_BANK3_CTRL4_PULL_ENABLE_MASK    ((u32)0X000003FFU)

/**
 * Register: CRL_APB_BANK3_CTRL5
 */
#define CRL_APB_BANK3_CTRL5    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000284U) )

#define CRL_APB_BANK3_CTRL5_SLOW_FAST_SLEW_N_SHIFT   0
#define CRL_APB_BANK3_CTRL5_SLOW_FAST_SLEW_N_WIDTH   10
#define CRL_APB_BANK3_CTRL5_SLOW_FAST_SLEW_N_MASK    ((u32)0X000003FFU)

/**
 * Register: CRL_APB_BANK3_STATUS
 */
#define CRL_APB_BANK3_STATUS    ( ( CRL_APB_BASEADDR ) + ((u32)0X00000288U) )

#define CRL_APB_BANK3_STATUS_VMODE_1P8_3P3_N_SHIFT   0
#define CRL_APB_BANK3_STATUS_VMODE_1P8_3P3_N_WIDTH   1
#define CRL_APB_BANK3_STATUS_VMODE_1P8_3P3_N_MASK    ((u32)0X00000001U)

#ifdef __cplusplus
}
#endif


#endif /* _CRL_APB_H_ */
