/******************************************************************************
* Copyright (c) 2018 - 2022 Xilinx, Inc.  All rights reserved.
* Copyright (c) 2022 - 2024 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************/
/**
*
* @file psm_global.h
*
* This file contains PSM Global definitions used by PSM Firmware
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver	Who		Date		Changes
* ---- ---- -------- ------------------------------
* 1.00  ma   04/09/2018 Initial release
*
* </pre>
*
* @note
*
******************************************************************************/

#ifndef XPSMFW_PSM_GLOBAL_H_
#define XPSMFW_PSM_GLOBAL_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @defgroup psm_global_module Versal PSM Global register definitions
 * @{
 */
/**
 * PSM Global base address
 */
#define PSM_GLOBAL_BASEADDR		((u32)0xFFC90000U)

/**
 * @name PSM Global GIC interrupt registers
 * @ingroup psm_global_module
 * @{
 */
/**
 * PSM Global GIC interrupt register
 */
#define PSM_GLOBAL_GICP_PSM_IRQ_STATUS 	( ( PSM_GLOBAL_BASEADDR ) + ((u32)0x000020A0U) )
#define PSM_GLOBAL_GICP_PSM_IRQ_MASK	( ( PSM_GLOBAL_BASEADDR ) + ((u32)0x000020A4U) )
#define PSM_GLOBAL_GICP_PSM_IRQ_EN		( ( PSM_GLOBAL_BASEADDR ) + ((u32)0x000020A8U) )
#define PSM_GLOBAL_GICP_PSM_IRQ_DIS		( ( PSM_GLOBAL_BASEADDR ) + ((u32)0x000020ACU) )
#define PSM_GLOBAL_GICP0_IRQ_STATUS	( ( PSM_GLOBAL_BASEADDR ) + ((u32)0x00002000U) )
#define PSM_GLOBAL_GICP2_IRQ_STATUS ( ( PSM_GLOBAL_BASEADDR ) + ((u32)0x00002028U) )
#define PSM_GLOBAL_GICP2_IRQ_MASK	( ( PSM_GLOBAL_BASEADDR ) + ((u32)0x0000202CU) )
#define PSM_GLOBAL_GICP2_INT_EN		( ( PSM_GLOBAL_BASEADDR ) + ((u32)0x00002030U) )
#define PSM_GLOBAL_GICP2_INT_DIS	( ( PSM_GLOBAL_BASEADDR ) + ((u32)0x00002034U) )
/** @} */

/**
 * @name PSM Global GIC interrupt register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * PSM Global GIC interrupt register operation
 */
#define PSM_GLOBAL_GICP_GICP2_MASK	((u32)0x4U)

#define PSM_GLOBAL_GICP0_IRQ_STATUS_IPI_PSM_SHIFT	29U
#define PSM_GLOBAL_GICP0_IRQ_STATUS_IPI_PSM_WIDTH	1U
#define PSM_GLOBAL_GICP0_IRQ_STATUS_IPI_PSM_MASK	((u32)0x20000000U)

#define PSM_GLOBAL_GICP2_IRQ_STATUS_CPM_UNCORR_ERR_SHIFT	11U
#define PSM_GLOBAL_GICP2_IRQ_STATUS_CPM_UNCORR_ERR_WIDTH	0x1U
#define PSM_GLOBAL_GICP2_IRQ_STATUS_CPM_UNCORR_ERR_MASK		((u32)0x800U)
#define PSM_GLOBAL_GICP2_IRQ_STATUS_CPM_CORR_ERR_SHIFT		0x9U
#define PSM_GLOBAL_GICP2_IRQ_STATUS_CPM_CORR_ERR_WIDTH		0x1U
#define PSM_GLOBAL_GICP2_IRQ_STATUS_CPM_CORR_ERR_MASK		((u32)0x200U)
#define PSM_GLOBAL_GICP2_IRQ_STATUS_CPM_MISC_SHIFT		0x8U
#define PSM_GLOBAL_GICP2_IRQ_STATUS_CPM_MISC_WIDTH		0x1U
#define PSM_GLOBAL_GICP2_IRQ_STATUS_CPM_MISC_MASK		((u32)0x100U)
#define PSM_GLOBAL_GICP2_IRQ_STATUS_PL_MASK			((u32)0x100000U)
/** @} */

/**
 * PSM_GLOBAL_REG Base Address
 */
#define PSM_GLOBAL_REG_BASEADDR      0XFFC90000U

/**
 * @name PSM Global Power registers
 * @ingroup psm_global_module
 * @{
 */
/**
 * PSM Global Power register
 */
#define PSM_GLOBAL_REG_GLOBAL_CNTRL			( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000000U )
#define PSM_GLOBAL_REG_APU_PWR_STATUS_INIT    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000008U )
/** @} */

/**
 * @name PSM Global Power Status register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * PSM Global Power status register operation
 */
#define	PSM_GLOBAL_REG_GLOBAL_CNTRL_FW_IS_PRESENT_MASK	0X00000010U

#define PSM_GLOBAL_REG_APU_PWR_STATUS_INIT_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_APU_PWR_STATUS_INIT_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_APU_PWR_STATUS_INIT_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_APU_PWR_STATUS_INIT_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_APU_PWR_STATUS_INIT_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_APU_PWR_STATUS_INIT_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_PWR_STATE
 */
#define PSM_GLOBAL_REG_PWR_STATE    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000100U )

/**
 * @name PSM Global Power State register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * PSM Global Power state register operation
 */
#define PSM_GLOBAL_REG_PWR_STATE_FP_SHIFT   22U
#define PSM_GLOBAL_REG_PWR_STATE_FP_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_FP_MASK    0X00400000U

#define PSM_GLOBAL_REG_PWR_STATE_GEM0_SHIFT   21U
#define PSM_GLOBAL_REG_PWR_STATE_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_GEM0_MASK    0X00200000U

#define PSM_GLOBAL_REG_PWR_STATE_GEM1_SHIFT   20U
#define PSM_GLOBAL_REG_PWR_STATE_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_GEM1_MASK    0X00100000U

#define PSM_GLOBAL_REG_PWR_STATE_OCM_BANK3_SHIFT   19U
#define PSM_GLOBAL_REG_PWR_STATE_OCM_BANK3_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_OCM_BANK3_MASK    0X00080000U

#define PSM_GLOBAL_REG_PWR_STATE_OCM_BANK2_SHIFT   18U
#define PSM_GLOBAL_REG_PWR_STATE_OCM_BANK2_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_OCM_BANK2_MASK    0X00040000U

#define PSM_GLOBAL_REG_PWR_STATE_OCM_BANK1_SHIFT   17U
#define PSM_GLOBAL_REG_PWR_STATE_OCM_BANK1_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_OCM_BANK1_MASK    0X00020000U

#define PSM_GLOBAL_REG_PWR_STATE_OCM_BANK0_SHIFT   16U
#define PSM_GLOBAL_REG_PWR_STATE_OCM_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_OCM_BANK0_MASK    0X00010000U

#define PSM_GLOBAL_REG_PWR_STATE_TCM1B_SHIFT   15U
#define PSM_GLOBAL_REG_PWR_STATE_TCM1B_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_TCM1B_MASK    0X00008000U

#define PSM_GLOBAL_REG_PWR_STATE_TCM1A_SHIFT   14U
#define PSM_GLOBAL_REG_PWR_STATE_TCM1A_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_TCM1A_MASK    0X00004000U

#define PSM_GLOBAL_REG_PWR_STATE_TCM0B_SHIFT   13U
#define PSM_GLOBAL_REG_PWR_STATE_TCM0B_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_TCM0B_MASK    0X00002000U

#define PSM_GLOBAL_REG_PWR_STATE_TCM0A_SHIFT   12U
#define PSM_GLOBAL_REG_PWR_STATE_TCM0A_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_TCM0A_MASK    0X00001000U

#define PSM_GLOBAL_REG_PWR_STATE_R5_1_SHIFT   11U
#define PSM_GLOBAL_REG_PWR_STATE_R5_1_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_R5_1_MASK    0X00000800U

#define PSM_GLOBAL_REG_PWR_STATE_R5_0_SHIFT   10U
#define PSM_GLOBAL_REG_PWR_STATE_R5_0_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_R5_0_MASK    0X00000400U

#define PSM_GLOBAL_REG_PWR_STATE_L2_BANK0_SHIFT   7U
#define PSM_GLOBAL_REG_PWR_STATE_L2_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_L2_BANK0_MASK    0X00000080U

#define PSM_GLOBAL_REG_PWR_STATE_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_PWR_STATE_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_PWR_STATE_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_PWR_STATE_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_STATE_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_PWRUP_STATUS
 */
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000110U )

/**
 * @name Power-up Request Status register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power-up Request Status register operation
 */
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_FP_SHIFT   22U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_FP_MASK    0X00400000U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_GEM0_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_GEM0_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_GEM1_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_GEM1_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_OCM_BANK3_SHIFT   19U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_OCM_BANK3_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_OCM_BANK3_MASK    0X00080000U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_OCM_BANK2_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_OCM_BANK2_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_OCM_BANK2_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_OCM_BANK1_SHIFT   17U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_OCM_BANK1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_OCM_BANK1_MASK    0X00020000U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_OCM_BANK0_SHIFT   16U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_OCM_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_OCM_BANK0_MASK    0X00010000U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_TCM1B_SHIFT   15U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_TCM1B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_TCM1B_MASK    0X00008000U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_TCM1A_SHIFT   14U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_TCM1A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_TCM1A_MASK    0X00004000U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_TCM0B_SHIFT   13U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_TCM0B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_TCM0B_MASK    0X00002000U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_TCM0A_SHIFT   12U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_TCM0A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_TCM0A_MASK    0X00001000U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_RPU_SHIFT   10U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_RPU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_RPU_MASK    0X00000400U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_L2_BANK0_SHIFT   7U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_L2_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_L2_BANK0_MASK    0X00000080U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_STATUS_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_PWRUP_INT_MASKU
 */
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000114U )

/**
 * @name Power-up Request Interrupt Mask Register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power-up Request Interrupt Mask Register operation
 */
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_FP_SHIFT   22U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_FP_MASK    0X00400000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_GEM0_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_GEM0_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_GEM1_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_GEM1_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_OCM_BANK3_SHIFT   19U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_OCM_BANK3_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_OCM_BANK3_MASK    0X00080000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_OCM_BANK2_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_OCM_BANK2_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_OCM_BANK2_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_OCM_BANK1_SHIFT   17U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_OCM_BANK1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_OCM_BANK1_MASK    0X00020000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_OCM_BANK0_SHIFT   16U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_OCM_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_OCM_BANK0_MASK    0X00010000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_TCM1B_SHIFT   15U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_TCM1B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_TCM1B_MASK    0X00008000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_TCM1A_SHIFT   14U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_TCM1A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_TCM1A_MASK    0X00004000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_TCM0B_SHIFT   13U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_TCM0B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_TCM0B_MASK    0X00002000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_TCM0A_SHIFT   12U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_TCM0A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_TCM0A_MASK    0X00001000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_RPU_SHIFT   10U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_RPU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_RPU_MASK    0X00000400U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_L2_BANK0_SHIFT   7U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_L2_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_L2_BANK0_MASK    0X00000080U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_MASK_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_PWRUP_INT_EN
 */
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000118U )

/**
 * @name Power-up Request Interrupt Enable register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power-up Request Interrupt Enable register operation
 */
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_FP_SHIFT   22U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_FP_MASK    0X00400000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_GEM0_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_GEM0_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_GEM1_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_GEM1_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_OCM_BANK3_SHIFT   19U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_OCM_BANK3_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_OCM_BANK3_MASK    0X00080000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_OCM_BANK2_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_OCM_BANK2_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_OCM_BANK2_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_OCM_BANK1_SHIFT   17U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_OCM_BANK1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_OCM_BANK1_MASK    0X00020000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_OCM_BANK0_SHIFT   16U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_OCM_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_OCM_BANK0_MASK    0X00010000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_TCM1B_SHIFT   15U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_TCM1B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_TCM1B_MASK    0X00008000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_TCM1A_SHIFT   14U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_TCM1A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_TCM1A_MASK    0X00004000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_TCM0B_SHIFT   13U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_TCM0B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_TCM0B_MASK    0X00002000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_TCM0A_SHIFT   12U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_TCM0A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_TCM0A_MASK    0X00001000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_RPU_SHIFT   10U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_RPU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_RPU_MASK    0X00000400U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_L2_BANK0_SHIFT   7U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_L2_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_L2_BANK0_MASK    0X00000080U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_EN_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS
 */
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X0000011CU )

/**
 * @name Power-up Request Interrupt Disable register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power-up Request Interrupt Disable register operation
 */
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_FP_SHIFT   22U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_FP_MASK    0X00400000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_GEM0_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_GEM0_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_GEM1_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_GEM1_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_OCM_BANK3_SHIFT   19U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_OCM_BANK3_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_OCM_BANK3_MASK    0X00080000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_OCM_BANK2_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_OCM_BANK2_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_OCM_BANK2_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_OCM_BANK1_SHIFT   17U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_OCM_BANK1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_OCM_BANK1_MASK    0X00020000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_OCM_BANK0_SHIFT   16U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_OCM_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_OCM_BANK0_MASK    0X00010000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_TCM1B_SHIFT   15U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_TCM1B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_TCM1B_MASK    0X00008000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_TCM1A_SHIFT   14U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_TCM1A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_TCM1A_MASK    0X00004000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_TCM0B_SHIFT   13U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_TCM0B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_TCM0B_MASK    0X00002000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_TCM0A_SHIFT   12U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_TCM0A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_TCM0A_MASK    0X00001000U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_RPU_SHIFT   10U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_RPU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_RPU_MASK    0X00000400U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_L2_BANK0_SHIFT   7U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_L2_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_L2_BANK0_MASK    0X00000080U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_INT_DIS_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_PWRUP_TRIG
 */
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000120U )

/**
 * @name Power-up Request Interrupt Trigger register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power-up Request Interrupt Trigger register operation
 */
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_FP_SHIFT   22U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_FP_MASK    0X00400000U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_GEM0_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_GEM0_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_GEM1_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_GEM1_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_OCM_BANK3_SHIFT   19U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_OCM_BANK3_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_OCM_BANK3_MASK    0X00080000U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_OCM_BANK2_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_OCM_BANK2_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_OCM_BANK2_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_OCM_BANK1_SHIFT   17U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_OCM_BANK1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_OCM_BANK1_MASK    0X00020000U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_OCM_BANK0_SHIFT   16U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_OCM_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_OCM_BANK0_MASK    0X00010000U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_TCM1B_SHIFT   15U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_TCM1B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_TCM1B_MASK    0X00008000U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_TCM1A_SHIFT   14U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_TCM1A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_TCM1A_MASK    0X00004000U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_TCM0B_SHIFT   13U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_TCM0B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_TCM0B_MASK    0X00002000U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_TCM0A_SHIFT   12U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_TCM0A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_TCM0A_MASK    0X00001000U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_RPU_SHIFT   10U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_RPU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_RPU_MASK    0X00000400U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_L2_BANK0_SHIFT   7U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_L2_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_L2_BANK0_MASK    0X00000080U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRUP_TRIG_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_PWRDWN_STATUS
 */
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000210U )

/**
 * @name Power-down Request Status register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power-down Request Status register operation
 */
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_FP_SHIFT   22U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_FP_MASK    0X00400000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_GEM0_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_GEM0_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_GEM1_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_GEM1_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_OCM_BANK3_SHIFT   19U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_OCM_BANK3_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_OCM_BANK3_MASK    0X00080000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_OCM_BANK2_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_OCM_BANK2_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_OCM_BANK2_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_OCM_BANK1_SHIFT   17U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_OCM_BANK1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_OCM_BANK1_MASK    0X00020000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_OCM_BANK0_SHIFT   16U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_OCM_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_OCM_BANK0_MASK    0X00010000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_TCM1B_SHIFT   15U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_TCM1B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_TCM1B_MASK    0X00008000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_TCM1A_SHIFT   14U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_TCM1A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_TCM1A_MASK    0X00004000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_TCM0B_SHIFT   13U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_TCM0B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_TCM0B_MASK    0X00002000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_TCM0A_SHIFT   12U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_TCM0A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_TCM0A_MASK    0X00001000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_RPU_SHIFT   10U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_RPU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_RPU_MASK    0X00000400U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_L2_BANK0_SHIFT   7U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_L2_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_L2_BANK0_MASK    0X00000080U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_STATUS_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASKU
 */
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000214U )

/**
 * @name Power-down Request Interrupt Mask register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power-down Request Interrupt Mask register operation
 */
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_FP_SHIFT   22U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_FP_MASK    0X00400000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_GEM0_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_GEM0_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_GEM1_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_GEM1_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_OCM_BANK3_SHIFT   19U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_OCM_BANK3_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_OCM_BANK3_MASK    0X00080000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_OCM_BANK2_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_OCM_BANK2_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_OCM_BANK2_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_OCM_BANK1_SHIFT   17U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_OCM_BANK1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_OCM_BANK1_MASK    0X00020000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_OCM_BANK0_SHIFT   16U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_OCM_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_OCM_BANK0_MASK    0X00010000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_TCM1B_SHIFT   15U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_TCM1B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_TCM1B_MASK    0X00008000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_TCM1A_SHIFT   14U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_TCM1A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_TCM1A_MASK    0X00004000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_TCM0B_SHIFT   13U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_TCM0B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_TCM0B_MASK    0X00002000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_TCM0A_SHIFT   12U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_TCM0A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_TCM0A_MASK    0X00001000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_RPU_SHIFT   10U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_RPU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_RPU_MASK    0X00000400U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_L2_BANK0_SHIFT   7U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_L2_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_L2_BANK0_MASK    0X00000080U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_MASK_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN
 */
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000218U )

/**
 * @name Power-down Request Interrupt Enable register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power-down Request Interrupt Enable register operation
 */
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_FP_SHIFT   22U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_FP_MASK    0X00400000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_GEM0_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_GEM0_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_GEM1_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_GEM1_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_OCM_BANK3_SHIFT   19U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_OCM_BANK3_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_OCM_BANK3_MASK    0X00080000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_OCM_BANK2_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_OCM_BANK2_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_OCM_BANK2_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_OCM_BANK1_SHIFT   17U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_OCM_BANK1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_OCM_BANK1_MASK    0X00020000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_OCM_BANK0_SHIFT   16U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_OCM_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_OCM_BANK0_MASK    0X00010000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_TCM1B_SHIFT   15U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_TCM1B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_TCM1B_MASK    0X00008000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_TCM1A_SHIFT   14U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_TCM1A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_TCM1A_MASK    0X00004000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_TCM0B_SHIFT   13U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_TCM0B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_TCM0B_MASK    0X00002000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_TCM0A_SHIFT   12U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_TCM0A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_TCM0A_MASK    0X00001000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_RPU_SHIFT   10U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_RPU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_RPU_MASK    0X00000400U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_L2_BANK0_SHIFT   7U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_L2_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_L2_BANK0_MASK    0X00000080U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_EN_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS
 */
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X0000021CU )

/**
 * @name Power-down Request Interrupt Disable register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power-down Request Interrupt Disable register operation
 */
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_FP_SHIFT   22U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_FP_MASK    0X00400000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_GEM0_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_GEM0_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_GEM1_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_GEM1_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_OCM_BANK3_SHIFT   19U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_OCM_BANK3_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_OCM_BANK3_MASK    0X00080000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_OCM_BANK2_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_OCM_BANK2_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_OCM_BANK2_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_OCM_BANK1_SHIFT   17U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_OCM_BANK1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_OCM_BANK1_MASK    0X00020000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_OCM_BANK0_SHIFT   16U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_OCM_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_OCM_BANK0_MASK    0X00010000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_TCM1B_SHIFT   15U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_TCM1B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_TCM1B_MASK    0X00008000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_TCM1A_SHIFT   14U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_TCM1A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_TCM1A_MASK    0X00004000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_TCM0B_SHIFT   13U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_TCM0B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_TCM0B_MASK    0X00002000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_TCM0A_SHIFT   12U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_TCM0A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_TCM0A_MASK    0X00001000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_RPU_SHIFT   10U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_RPU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_RPU_MASK    0X00000400U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_L2_BANK0_SHIFT   7U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_L2_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_L2_BANK0_MASK    0X00000080U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_INT_DIS_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_PWRDWN_TRIG
 */
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000220U )

/**
 * @name Power-down Request Interrupt Trigger register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power-down Request Interrupt Trigger register operation
 */
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_FP_SHIFT   22U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_FP_MASK    0X00400000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_GEM0_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_GEM0_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_GEM1_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_GEM1_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_OCM_BANK3_SHIFT   19U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_OCM_BANK3_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_OCM_BANK3_MASK    0X00080000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_OCM_BANK2_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_OCM_BANK2_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_OCM_BANK2_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_OCM_BANK1_SHIFT   17U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_OCM_BANK1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_OCM_BANK1_MASK    0X00020000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_OCM_BANK0_SHIFT   16U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_OCM_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_OCM_BANK0_MASK    0X00010000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_TCM1B_SHIFT   15U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_TCM1B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_TCM1B_MASK    0X00008000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_TCM1A_SHIFT   14U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_TCM1A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_TCM1A_MASK    0X00004000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_TCM0B_SHIFT   13U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_TCM0B_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_TCM0B_MASK    0X00002000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_TCM0A_SHIFT   12U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_TCM0A_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_TCM0A_MASK    0X00001000U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_RPU_SHIFT   10U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_RPU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_RPU_MASK    0X00000400U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_L2_BANK0_SHIFT   7U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_L2_BANK0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_L2_BANK0_MASK    0X00000080U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_PWRDWN_TRIG_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_SWRST_STATUS
 */
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000410U )

/**
 * @name PSM Reset Request status register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * PSM Reset Request status register operation
 */
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_FP_SHIFT   30U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_FP_WIDTH   1U

#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_LP_SHIFT   29U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_LP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_LP_MASK    0X20000000U

#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_PS_ONLY_SHIFT   28U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_PS_ONLY_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_PS_ONLY_MASK    0X10000000U

#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_IOU_SHIFT   27U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_IOU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_IOU_MASK    0X08000000U

#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_USB0_SHIFT   24U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_USB0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_USB0_MASK    0X01000000U

#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_GEM1_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_GEM1_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_GEM0_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_GEM0_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_LS_R5_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_LS_R5_WIDTH   1U

#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_APU_SHIFT   4U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_APU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_APU_MASK    0X00000010U

#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_STATUS_ACPU0_MASK    0X00000001U
/** @} */

/**
 * @name PSM Reset Request interrupt mask registers
 * @ingroup psm_global_module
 * @{
 */
/**
 * PSM Reset Request interrupt mask register
 */
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_FP_SHIFT   30U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_FP_MASK    0X40000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_LP_SHIFT   29U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_LP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_LP_MASK    0X20000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_PS_ONLY_SHIFT   28U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_PS_ONLY_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_PS_ONLY_MASK    0X10000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_IOU_SHIFT   27U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_IOU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_IOU_MASK    0X08000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_USB0_SHIFT   24U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_USB0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_USB0_MASK    0X01000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_GEM1_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_GEM1_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_GEM0_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_GEM0_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_LS_R5_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_LS_R5_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_LS_R5_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_APU_SHIFT   4U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_APU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_APU_MASK    0X00000010U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_MASK_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_SWRST_INT_EN
 */
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000418U )

/**
 * @name PSM Reset Request interrupt enable register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * PSM Reset Request interrupt enable register operation
 */
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_FP_SHIFT   30U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_FP_MASK    0X40000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_LP_SHIFT   29U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_LP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_LP_MASK    0X20000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_PS_ONLY_SHIFT   28U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_PS_ONLY_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_PS_ONLY_MASK    0X10000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_IOU_SHIFT   27U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_IOU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_IOU_MASK    0X08000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_USB0_SHIFT   24U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_USB0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_USB0_MASK    0X01000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_GEM1_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_GEM1_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_GEM0_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_GEM0_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_LS_R5_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_LS_R5_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_LS_R5_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_APU_SHIFT   4U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_APU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_APU_MASK    0X00000010U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_EN_ACPU0_MASK    0X00000001U
/** @} */

/**
 * @name PSM Reset Request interrupt disable register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * PSM Reset Request interrupt disable register operation
 */
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_FP_SHIFT   30U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_FP_MASK    0X40000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_LP_SHIFT   29U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_LP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_LP_MASK    0X20000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_PS_ONLY_SHIFT   28U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_PS_ONLY_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_PS_ONLY_MASK    0X10000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_IOU_SHIFT   27U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_IOU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_IOU_MASK    0X08000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_USB0_SHIFT   24U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_USB0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_USB0_MASK    0X01000000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_GEM1_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_GEM1_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_GEM0_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_GEM0_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_LS_R5_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_LS_R5_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_LS_R5_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_APU_SHIFT   4U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_APU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_APU_MASK    0X00000010U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_INT_DIS_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_REQ_SWRST_TRIG
 */
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000420U )

/**
 * @name PSM Reset Request interrupt trigger register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * PSM Reset Request interrupt trigger register operation
 */
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_FP_SHIFT   30U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_FP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_FP_MASK    0X40000000U

#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_LP_SHIFT   29U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_LP_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_LP_MASK    0X20000000U

#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_PS_ONLY_SHIFT   28U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_PS_ONLY_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_PS_ONLY_MASK    0X10000000U

#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_IOU_SHIFT   27U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_IOU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_IOU_MASK    0X08000000U

#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_USB0_SHIFT   24U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_USB0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_USB0_MASK    0X01000000U

#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_GEM1_SHIFT   21U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_GEM1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_GEM1_MASK    0X00200000U

#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_GEM0_SHIFT   20U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_GEM0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_GEM0_MASK    0X00100000U

#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_LS_R5_SHIFT   18U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_LS_R5_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_LS_R5_MASK    0X00040000U

#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_APU_SHIFT   4U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_APU_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_APU_MASK    0X00000010U

#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_REQ_SWRST_TRIG_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS
 */
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000700U )

/**
 * @name Wake-up Request interrupt status register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Wake-up Request interrupt status register operation
 */
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_INTFPD_SHIFT   27U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_INTFPD_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_INTFPD_MASK    0X08000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_INTLPD_SHIFT   26U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_INTLPD_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_INTLPD_MASK    0X04000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_FPD_DBG_SHIFT   25U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_FPD_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_FPD_DBG_MASK    0X02000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_R5S_DBG_SHIFT   24U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_R5S_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_R5S_DBG_MASK    0X01000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU1_DBG_SHIFT   21U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU1_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU1_DBG_MASK    0X00200000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU0_DBG_SHIFT   20U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU0_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU0_DBG_MASK    0X00100000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU1_CORESIGHT_SHIFT   17U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU1_CORESIGHT_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU1_CORESIGHT_MASK    0X00020000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU0_CORESIGHT_SHIFT   16U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU0_CORESIGHT_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU0_CORESIGHT_MASK    0X00010000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO5_SHIFT   15U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO5_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO5_MASK    0X00008000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO4_SHIFT   14U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO4_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO4_MASK    0X00004000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO3_SHIFT   13U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO3_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO3_MASK    0X00002000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO2_SHIFT   12U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO2_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO2_MASK    0X00001000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO1_SHIFT   11U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO1_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO1_MASK    0X00000800U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO0_SHIFT   10U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_MIO0_MASK    0X00000400U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_USB0_SHIFT   6U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_USB0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_USB0_MASK    0X00000040U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_R51_SHIFT   5U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_R51_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_R51_MASK    0X00000020U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_R50_SHIFT   4U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_R50_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_R50_MASK    0X00000010U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_STATUS_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_WAKEUP_IRQ_MASKU
 */
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000704U )

/**
 * @name Wake-up Request interrupt mask register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Wake-up Request interrupt mask register operation
 */
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_INTFPD_SHIFT   27U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_INTFPD_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_INTFPD_MASK    0X08000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_INTLPD_SHIFT   26U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_INTLPD_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_INTLPD_MASK    0X04000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_FPD_DBG_SHIFT   25U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_FPD_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_FPD_DBG_MASK    0X02000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_R5S_DBG_SHIFT   24U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_R5S_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_R5S_DBG_MASK    0X01000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU1_DBG_SHIFT   21U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU1_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU1_DBG_MASK    0X00200000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU0_DBG_SHIFT   20U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU0_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU0_DBG_MASK    0X00100000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU1_CORESIGHT_SHIFT   17U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU1_CORESIGHT_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU1_CORESIGHT_MASK    0X00020000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU0_CORESIGHT_SHIFT   16U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU0_CORESIGHT_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU0_CORESIGHT_MASK    0X00010000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO5_SHIFT   15U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO5_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO5_MASK    0X00008000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO4_SHIFT   14U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO4_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO4_MASK    0X00004000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO3_SHIFT   13U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO3_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO3_MASK    0X00002000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO2_SHIFT   12U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO2_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO2_MASK    0X00001000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO1_SHIFT   11U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO1_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO1_MASK    0X00000800U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO0_SHIFT   10U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_MIO0_MASK    0X00000400U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_USB0_SHIFT   6U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_USB0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_USB0_MASK    0X00000040U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_R51_SHIFT   5U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_R51_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_R51_MASK    0X00000020U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_R50_SHIFT   4U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_R50_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_R50_MASK    0X00000010U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_MASK_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_WAKEUP_IRQ_EN
 */
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000708U )

/**
 * @name Wake-up Request interrupt enable register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Wake-up Request interrupt enable register operation
 */
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_INTFPD_SHIFT   27U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_INTFPD_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_INTFPD_MASK    0X08000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_INTLPD_SHIFT   26U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_INTLPD_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_INTLPD_MASK    0X04000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_FPD_DBG_SHIFT   25U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_FPD_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_FPD_DBG_MASK    0X02000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_R5S_DBG_SHIFT   24U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_R5S_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_R5S_DBG_MASK    0X01000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU1_DBG_SHIFT   21U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU1_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU1_DBG_MASK    0X00200000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU0_DBG_SHIFT   20U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU0_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU0_DBG_MASK    0X00100000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU1_CORESIGHT_SHIFT   17U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU1_CORESIGHT_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU1_CORESIGHT_MASK    0X00020000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU0_CORESIGHT_SHIFT   16U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU0_CORESIGHT_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU0_CORESIGHT_MASK    0X00010000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO5_SHIFT   15U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO5_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO5_MASK    0X00008000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO4_SHIFT   14U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO4_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO4_MASK    0X00004000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO3_SHIFT   13U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO3_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO3_MASK    0X00002000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO2_SHIFT   12U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO2_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO2_MASK    0X00001000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO1_SHIFT   11U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO1_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO1_MASK    0X00000800U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO0_SHIFT   10U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_MIO0_MASK    0X00000400U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_USB0_SHIFT   6U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_USB0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_USB0_MASK    0X00000040U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_R51_SHIFT   5U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_R51_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_R51_MASK    0X00000020U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_R50_SHIFT   4U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_R50_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_R50_MASK    0X00000010U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_EN_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_WAKEUP_IRQ_DIS
 */
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X0000070CU )

/**
 * @name Wake-up Request interrupt disable register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Wake-up Request interrupt disable register operation
 */
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_INTFPD_SHIFT   27U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_INTFPD_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_INTFPD_MASK    0X08000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_INTLPD_SHIFT   26U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_INTLPD_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_INTLPD_MASK    0X04000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_FPD_DBG_SHIFT   25U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_FPD_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_FPD_DBG_MASK    0X02000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_R5S_DBG_SHIFT   24U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_R5S_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_R5S_DBG_MASK    0X01000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU1_DBG_SHIFT   21U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU1_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU1_DBG_MASK    0X00200000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU0_DBG_SHIFT   20U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU0_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU0_DBG_MASK    0X00100000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU1_CORESIGHT_SHIFT   17U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU1_CORESIGHT_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU1_CORESIGHT_MASK    0X00020000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU0_CORESIGHT_SHIFT   16U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU0_CORESIGHT_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU0_CORESIGHT_MASK    0X00010000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO5_SHIFT   15U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO5_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO5_MASK    0X00008000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO4_SHIFT   14U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO4_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO4_MASK    0X00004000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO3_SHIFT   13U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO3_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO3_MASK    0X00002000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO2_SHIFT   12U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO2_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO2_MASK    0X00001000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO1_SHIFT   11U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO1_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO1_MASK    0X00000800U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO0_SHIFT   10U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_MIO0_MASK    0X00000400U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_USB0_SHIFT   6U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_USB0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_USB0_MASK    0X00000040U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_R51_SHIFT   5U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_R51_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_R51_MASK    0X00000020U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_R50_SHIFT   4U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_R50_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_R50_MASK    0X00000010U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_DIS_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG
 */
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000710U )

/**
 * @name Wake-up Request interrupt trigger register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Wake-up Request interrupt trigger register operation
 */
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_INTFPD_SHIFT   27U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_INTFPD_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_INTFPD_MASK    0X08000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_INTLPD_SHIFT   26U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_INTLPD_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_INTLPD_MASK    0X04000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_FPD_DBG_SHIFT   25U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_FPD_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_FPD_DBG_MASK    0X02000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_R5S_DBG_SHIFT   24U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_R5S_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_R5S_DBG_MASK    0X01000000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU1_DBG_SHIFT   21U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU1_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU1_DBG_MASK    0X00200000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU0_DBG_SHIFT   20U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU0_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU0_DBG_MASK    0X00100000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU1_CORESIGHT_SHIFT   17U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU1_CORESIGHT_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU1_CORESIGHT_MASK    0X00020000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU0_CORESIGHT_SHIFT   16U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU0_CORESIGHT_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU0_CORESIGHT_MASK    0X00010000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO5_SHIFT   15U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO5_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO5_MASK    0X00008000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO4_SHIFT   14U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO4_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO4_MASK    0X00004000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO3_SHIFT   13U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO3_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO3_MASK    0X00002000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO2_SHIFT   12U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO2_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO2_MASK    0X00001000U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO1_SHIFT   11U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO1_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO1_MASK    0X00000800U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO0_SHIFT   10U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_MIO0_MASK    0X00000400U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_USB0_SHIFT   6U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_USB0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_USB0_MASK    0X00000040U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_R51_SHIFT   5U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_R51_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_R51_MASK    0X00000020U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_R50_SHIFT   4U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_R50_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_R50_MASK    0X00000010U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_WAKEUP_IRQ_TRIG_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS
 */
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000714U )

/**
 * @name Power Control Request interrupt status register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power Control Request interrupt status register operation
 */
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_FPD_SUPPLY_SHIFT   24U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_FPD_SUPPLY_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_FPD_SUPPLY_MASK    0X01000000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_APU1_DBG_RST_SHIFT   21U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_APU1_DBG_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_APU1_DBG_RST_MASK    0X00200000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_APU0_DBG_RST_SHIFT   20U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_APU0_DBG_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_APU0_DBG_RST_MASK    0X00100000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_APU1_RST_SHIFT   17U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_APU1_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_APU1_RST_MASK    0X00020000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_APU0_RST_SHIFT   16U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_APU0_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_APU0_RST_MASK    0X00010000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_RPU0_DBG_SHIFT   8U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_RPU0_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_RPU0_DBG_MASK    0X00000100U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_R51_SHIFT   5U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_R51_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_R51_MASK    0X00000020U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_R50_SHIFT   4U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_R50_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_R50_MASK    0X00000010U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_STATUS_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASKU
 */
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000718U )

/**
 * @name Power Control Request interrupt status register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power Control Request interrupt status register operation
 */
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_FPD_SUPPLY_SHIFT   24U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_FPD_SUPPLY_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_FPD_SUPPLY_MASK    0X01000000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_APU1_DBG_RST_SHIFT   21U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_APU1_DBG_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_APU1_DBG_RST_MASK    0X00200000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_APU0_DBG_RST_SHIFT   20U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_APU0_DBG_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_APU0_DBG_RST_MASK    0X00100000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_APU1_RST_SHIFT   17U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_APU1_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_APU1_RST_MASK    0X00020000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_APU0_RST_SHIFT   16U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_APU0_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_APU0_RST_MASK    0X00010000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_RPU0_DBG_SHIFT   8U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_RPU0_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_RPU0_DBG_MASK    0X00000100U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_R51_SHIFT   5U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_R51_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_R51_MASK    0X00000020U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_R50_SHIFT   4U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_R50_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_R50_MASK    0X00000010U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_MASK_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN
 */
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X0000071CU )

/**
 * @name Power Control Request interrupt enable register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power Control Request interrupt enable register operation
 */
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_FPD_SUPPLY_SHIFT   24U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_FPD_SUPPLY_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_FPD_SUPPLY_MASK    0X01000000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_APU1_DBG_RST_SHIFT   21U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_APU1_DBG_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_APU1_DBG_RST_MASK    0X00200000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_APU0_DBG_RST_SHIFT   20U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_APU0_DBG_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_APU0_DBG_RST_MASK    0X00100000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_APU1_RST_SHIFT   17U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_APU1_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_APU1_RST_MASK    0X00020000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_APU0_RST_SHIFT   16U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_APU0_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_APU0_RST_MASK    0X00010000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_RPU0_DBG_SHIFT   8U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_RPU0_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_RPU0_DBG_MASK    0X00000100U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_R51_SHIFT   5U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_R51_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_R51_MASK    0X00000020U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_R50_SHIFT   4U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_R50_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_R50_MASK    0X00000010U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_EN_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS
 */
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000720U )

/**
 * @name Power Control Request interrupt disable register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power Control Request interrupt disable register operation
 */
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_FPD_SUPPLY_SHIFT   24U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_FPD_SUPPLY_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_FPD_SUPPLY_MASK    0X01000000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_APU1_DBG_RST_SHIFT   21U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_APU1_DBG_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_APU1_DBG_RST_MASK    0X00200000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_APU0_DBG_RST_SHIFT   20U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_APU0_DBG_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_APU0_DBG_RST_MASK    0X00100000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_APU1_RST_SHIFT   17U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_APU1_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_APU1_RST_MASK    0X00020000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_APU0_RST_SHIFT   16U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_APU0_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_APU0_RST_MASK    0X00010000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_RPU0_DBG_SHIFT   8U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_RPU0_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_RPU0_DBG_MASK    0X00000100U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_R51_SHIFT   5U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_R51_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_R51_MASK    0X00000020U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_R50_SHIFT   4U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_R50_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_R50_MASK    0X00000010U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_DIS_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG
 */
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000724U )

/**
 * @name Power Control Request interrupt trigger register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * Power Control Request interrupt trigger register operation
 */
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_FPD_SUPPLY_SHIFT   24U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_FPD_SUPPLY_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_FPD_SUPPLY_MASK    0X01000000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_APU1_DBG_RST_SHIFT   21U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_APU1_DBG_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_APU1_DBG_RST_MASK    0X00200000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_APU0_DBG_RST_SHIFT   20U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_APU0_DBG_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_APU0_DBG_RST_MASK    0X00100000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_APU1_RST_SHIFT   17U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_APU1_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_APU1_RST_MASK    0X00020000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_APU0_RST_SHIFT   16U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_APU0_RST_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_APU0_RST_MASK    0X00010000U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_RPU0_DBG_SHIFT   8U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_RPU0_DBG_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_RPU0_DBG_MASK    0X00000100U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_R51_SHIFT   5U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_R51_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_R51_MASK    0X00000020U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_R50_SHIFT   4U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_R50_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_R50_MASK    0X00000010U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_ACPU1_SHIFT   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_ACPU1_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_ACPU1_MASK    0X00000002U

#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_ACPU0_SHIFT   0U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_ACPU0_WIDTH   1U
#define PSM_GLOBAL_REG_PWR_CTRL_IRQ_TRIG_ACPU0_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_MBIST_RSTN
 */
#define PSM_GLOBAL_REG_MBIST_RSTN    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000900U )

/**
 * @name MBIST memory reset control register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * MBIST memory reset control register operation
 */
#define PSM_GLOBAL_REG_MBIST_RSTN_INT_FPD_SHIFT   4U
#define PSM_GLOBAL_REG_MBIST_RSTN_INT_FPD_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_RSTN_INT_FPD_MASK    0X00000010U

#define PSM_GLOBAL_REG_MBIST_RSTN_CCI_SHIFT   3U
#define PSM_GLOBAL_REG_MBIST_RSTN_CCI_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_RSTN_CCI_MASK    0X00000008U

#define PSM_GLOBAL_REG_MBIST_RSTN_CPU1_SHIFT   2U
#define PSM_GLOBAL_REG_MBIST_RSTN_CPU1_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_RSTN_CPU1_MASK    0X00000004U

#define PSM_GLOBAL_REG_MBIST_RSTN_CPU0_SHIFT   1U
#define PSM_GLOBAL_REG_MBIST_RSTN_CPU0_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_RSTN_CPU0_MASK    0X00000002U

#define PSM_GLOBAL_REG_MBIST_RSTN_APU_SHIFT   0U
#define PSM_GLOBAL_REG_MBIST_RSTN_APU_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_RSTN_APU_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_MBIST_PG_EN
 */
#define PSM_GLOBAL_REG_MBIST_PG_EN    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000904U )

/**
 * @name MBIST memory PG_EN signals control register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * MBIST memory PG_EN signals control register operation
 */
#define PSM_GLOBAL_REG_MBIST_PG_EN_INT_FPD_SHIFT   4U
#define PSM_GLOBAL_REG_MBIST_PG_EN_INT_FPD_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_PG_EN_INT_FPD_MASK    0X00000010U

#define PSM_GLOBAL_REG_MBIST_PG_EN_CCI_SHIFT   3U
#define PSM_GLOBAL_REG_MBIST_PG_EN_CCI_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_PG_EN_CCI_MASK    0X00000008U

#define PSM_GLOBAL_REG_MBIST_PG_EN_CPU1_SHIFT   2U
#define PSM_GLOBAL_REG_MBIST_PG_EN_CPU1_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_PG_EN_CPU1_MASK    0X00000004U

#define PSM_GLOBAL_REG_MBIST_PG_EN_CPU0_SHIFT   1U
#define PSM_GLOBAL_REG_MBIST_PG_EN_CPU0_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_PG_EN_CPU0_MASK    0X00000002U

#define PSM_GLOBAL_REG_MBIST_PG_EN_APU_SHIFT   0U
#define PSM_GLOBAL_REG_MBIST_PG_EN_APU_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_PG_EN_APU_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_MBIST_SETUP
 */
#define PSM_GLOBAL_REG_MBIST_SETUP    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000908U )

/**
 * @name MBIST memory SETUP_1 signal control register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * MBIST memory SETUP_1 signal control register operation
 */
#define PSM_GLOBAL_REG_MBIST_SETUP_INT_FPD_SHIFT   4U
#define PSM_GLOBAL_REG_MBIST_SETUP_INT_FPD_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_SETUP_INT_FPD_MASK    0X00000010U

#define PSM_GLOBAL_REG_MBIST_SETUP_CCI_SHIFT   3U
#define PSM_GLOBAL_REG_MBIST_SETUP_CCI_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_SETUP_CCI_MASK    0X00000008U

#define PSM_GLOBAL_REG_MBIST_SETUP_CPU1_SHIFT   2U
#define PSM_GLOBAL_REG_MBIST_SETUP_CPU1_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_SETUP_CPU1_MASK    0X00000004U

#define PSM_GLOBAL_REG_MBIST_SETUP_CPU0_SHIFT   1U
#define PSM_GLOBAL_REG_MBIST_SETUP_CPU0_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_SETUP_CPU0_MASK    0X00000002U

#define PSM_GLOBAL_REG_MBIST_SETUP_APU_SHIFT   0U
#define PSM_GLOBAL_REG_MBIST_SETUP_APU_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_SETUP_APU_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_MBIST_DONE
 */
#define PSM_GLOBAL_REG_MBIST_DONE    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000910U )

/**
 * @name MBIST memory DONE status register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * MBIST memory DONE status register operation
 */
#define PSM_GLOBAL_REG_MBIST_DONE_INT_FPD_SHIFT   4U
#define PSM_GLOBAL_REG_MBIST_DONE_INT_FPD_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_DONE_INT_FPD_MASK    0X00000010U

#define PSM_GLOBAL_REG_MBIST_DONE_CCI_SHIFT   3U
#define PSM_GLOBAL_REG_MBIST_DONE_CCI_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_DONE_CCI_MASK    0X00000008U

#define PSM_GLOBAL_REG_MBIST_DONE_CPU1_SHIFT   2U
#define PSM_GLOBAL_REG_MBIST_DONE_CPU1_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_DONE_CPU1_MASK    0X00000004U

#define PSM_GLOBAL_REG_MBIST_DONE_CPU0_SHIFT   1U
#define PSM_GLOBAL_REG_MBIST_DONE_CPU0_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_DONE_CPU0_MASK    0X00000002U

#define PSM_GLOBAL_REG_MBIST_DONE_APU_SHIFT   0U
#define PSM_GLOBAL_REG_MBIST_DONE_APU_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_DONE_APU_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_MBIST_GO
 */
#define PSM_GLOBAL_REG_MBIST_GO    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00000914U )

/**
 * @name MBIST memory GO status register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * MBIST memory GO status register operation
 */
#define PSM_GLOBAL_REG_MBIST_GO_INT_FPD_SHIFT   4U
#define PSM_GLOBAL_REG_MBIST_GO_INT_FPD_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_GO_INT_FPD_MASK    0X00000010U

#define PSM_GLOBAL_REG_MBIST_GO_CCI_SHIFT   3U
#define PSM_GLOBAL_REG_MBIST_GO_CCI_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_GO_CCI_MASK    0X00000008U

#define PSM_GLOBAL_REG_MBIST_GO_CPU1_SHIFT   2U
#define PSM_GLOBAL_REG_MBIST_GO_CPU1_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_GO_CPU1_MASK    0X00000004U

#define PSM_GLOBAL_REG_MBIST_GO_CPU0_SHIFT   1U
#define PSM_GLOBAL_REG_MBIST_GO_CPU0_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_GO_CPU0_MASK    0X00000002U

#define PSM_GLOBAL_REG_MBIST_GO_APU_SHIFT   0U
#define PSM_GLOBAL_REG_MBIST_GO_APU_WIDTH   1U
#define PSM_GLOBAL_REG_MBIST_GO_APU_MASK    0X00000001U
/** @} */

/**
 * Register: PSM_GLOBAL_REG_ERR1_TRIG
 */
#define PSM_GLOBAL_REG_ERR1_TRIG    ( ( PSM_GLOBAL_REG_BASEADDR ) + 0X00001010U )

/**
 * @name PSM Error Trigger register operations
 * @ingroup psm_global_module
 * @{
 */
/**
 * PSM Error Trigger register operation
 */
#define PSM_GLOBAL_REG_ERR1_TRIG_PSM_B_NCR_SHIFT  	(3U)
#define PSM_GLOBAL_REG_ERR1_TRIG_PSM_B_NCR_WIDTH	(1U)
#define PSM_GLOBAL_REG_ERR1_TRIG_PSM_B_NCR_MASK		(0X00000008U)
/** @} */
/** @} */

#ifdef __cplusplus
}
#endif

#endif /* XPSMFW_PSM_GLOBAL_H_ */
