/******************************************************************************
* Copyright (c) 2020 - 2021 Xilinx, Inc. All rights reserved.
* Copyright (c) 2022 - 2024 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/****************************************************************************/
/**
*
* @file psu_init.c
*
* This file is automatically generated
*
*****************************************************************************/

#include <xil_io.h>
#include <sleep.h>
#include "psu_init.h"
#include "xis_config.h"

static int Mask_Poll(u32 Address, u32 Mask);

static void PSU_Mask_Write(u32 Offset, u32 Mask, u32 Val)
{
	u32 RegVal = 0x0U;

	RegVal = Xil_In32(Offset);
	RegVal &= ~(Mask);
	RegVal |= (Val & Mask);
	Xil_Out32(Offset, RegVal);
}

static int Psu_Pll_Init_Data(void)
{
	int Status = XST_FAILURE;

/*##################################################################### */

    /*
    * IOPLL INIT
    */
    /*
    * Register : IOPLL_CFG @ 0XFF5E0024

    * PLL loop filter resistor control
    *  PSU_CRL_APB_IOPLL_CFG_RES                                   0x2

    * PLL charge pump control
    *  PSU_CRL_APB_IOPLL_CFG_CP                                    0x3

    * PLL loop filter high frequency capacitor control
    *  PSU_CRL_APB_IOPLL_CFG_LFHF                                  0x3

    * Lock circuit counter setting
    *  PSU_CRL_APB_IOPLL_CFG_LOCK_CNT                              0x271

    * Lock circuit configuration settings for lock windowsize
    *  PSU_CRL_APB_IOPLL_CFG_LOCK_DLY                              0x3f

    * Helper data. Values are to be looked up in a table from Data Sheet
    * (OFFSET, MASK, VALUE)      (0XFF5E0024, 0xFE7FEDEFU ,0x7E4E2C62U)
    */
	PSU_Mask_Write(CRL_APB_IOPLL_CFG_OFFSET, 0xFE7FEDEFU, 0x7E4E2C62U);
/*##################################################################### */

    /*
    * UPDATE FB_DIV
    */
    /*
    * Register : IOPLL_CTRL @ 0XFF5E0020

    * Mux select for determining which clock feeds this PLL. 0XX pss_ref_clk i
    * s the source 100 video clk is the source 101 pss_alt_ref_clk is the sour
    * ce 110 aux_refclk[X] is the source 111 gt_crx_ref_clk is the source
    *  PSU_CRL_APB_IOPLL_CTRL_PRE_SRC                              0x0

    * The integer portion of the feedback divider to the PLL
    *  PSU_CRL_APB_IOPLL_CTRL_FBDIV                                0x3c

    * This turns on the divide by 2 that is inside of the PLL. This does not c
    * hange the VCO frequency, just the output frequency
    *  PSU_CRL_APB_IOPLL_CTRL_DIV2                                 0x1

    * PLL Basic Control
    * (OFFSET, MASK, VALUE)      (0XFF5E0020, 0x00717F00U ,0x00013C00U)
    */
	PSU_Mask_Write(CRL_APB_IOPLL_CTRL_OFFSET, 0x00717F00U, 0x00013C00U);
/*##################################################################### */

    /*
    * BY PASS PLL
    */
    /*
    * Register : IOPLL_CTRL @ 0XFF5E0020

    * Bypasses the PLL clock. The usable clock will be determined from the POS
    * T_SRC field. (This signal may only be toggled after 4 cycles of the old
    * clock and 4 cycles of the new clock. This is not usually an issue, but d
    * esigners must be aware.)
    *  PSU_CRL_APB_IOPLL_CTRL_BYPASS                               1

    * PLL Basic Control
    * (OFFSET, MASK, VALUE)      (0XFF5E0020, 0x00000008U ,0x00000008U)
    */
	PSU_Mask_Write(CRL_APB_IOPLL_CTRL_OFFSET, 0x00000008U, 0x00000008U);
/*##################################################################### */

    /*
    * ASSERT RESET
    */
    /*
    * Register : IOPLL_CTRL @ 0XFF5E0020

    * Asserts Reset to the PLL. When asserting reset, the PLL must already be
    * in BYPASS.
    *  PSU_CRL_APB_IOPLL_CTRL_RESET                                1

    * PLL Basic Control
    * (OFFSET, MASK, VALUE)      (0XFF5E0020, 0x00000001U ,0x00000001U)
    */
	PSU_Mask_Write(CRL_APB_IOPLL_CTRL_OFFSET, 0x00000001U, 0x00000001U);
/*##################################################################### */

    /*
    * DEASSERT RESET
    */
    /*
    * Register : IOPLL_CTRL @ 0XFF5E0020

    * Asserts Reset to the PLL. When asserting reset, the PLL must already be
    * in BYPASS.
    *  PSU_CRL_APB_IOPLL_CTRL_RESET                                0

    * PLL Basic Control
    * (OFFSET, MASK, VALUE)      (0XFF5E0020, 0x00000001U ,0x00000000U)
    */
	PSU_Mask_Write(CRL_APB_IOPLL_CTRL_OFFSET, 0x00000001U, 0x00000000U);
/*##################################################################### */

    /*
    * CHECK PLL STATUS
    */
    /*
    * Register : PLL_STATUS @ 0XFF5E0040

    * IOPLL is locked
    *  PSU_CRL_APB_PLL_STATUS_IOPLL_LOCK                           1
    * (OFFSET, MASK, VALUE)      (0XFF5E0040, 0x00000001U ,0x00000001U)
	*/
	Mask_Poll(CRL_APB_PLL_STATUS_OFFSET, 0x00000001U);
/*##################################################################### */

    /*
    * REMOVE PLL BY PASS
    */
    /*
    * Register : IOPLL_CTRL @ 0XFF5E0020

    * Bypasses the PLL clock. The usable clock will be determined from the POS
    * T_SRC field. (This signal may only be toggled after 4 cycles of the old
    * clock and 4 cycles of the new clock. This is not usually an issue, but d
    * esigners must be aware.)
    *  PSU_CRL_APB_IOPLL_CTRL_BYPASS                               0

    * PLL Basic Control
    * (OFFSET, MASK, VALUE)      (0XFF5E0020, 0x00000008U ,0x00000000U)
    */
	PSU_Mask_Write(CRL_APB_IOPLL_CTRL_OFFSET, 0x00000008U, 0x00000000U);
/*##################################################################### */

   /*
    * APU_PLL INIT
    */
    /*
    * Register : APLL_CFG @ 0XFD1A0024
    * PLL loop filter resistor control
    *  PSU_CRF_APB_APLL_CFG_RES                                    0x2
    * PLL charge pump control
    *  PSU_CRF_APB_APLL_CFG_CP                                     0x3
    * PLL loop filter high frequency capacitor control
    *  PSU_CRF_APB_APLL_CFG_LFHF                                   0x3
    * Lock circuit counter setting
    *  PSU_CRF_APB_APLL_CFG_LOCK_CNT                               0x258
    * Lock circuit configuration settings for lock windowsize
    *  PSU_CRF_APB_APLL_CFG_LOCK_DLY                               0x3f
    * Helper data. Values are to be looked up in a table from Data Sheet
    * (OFFSET, MASK, VALUE)      (0XFD1A0024, 0xFE7FEDEFU ,0x7E4B0C62U)
    */
	PSU_Mask_Write(CRF_APB_APLL_CFG_OFFSET, 0xFE7FEDEFU, 0x7E4B0C62U);
/*##################################################################### */

    /*
    * UPDATE FB_DIV
    */
    /*
    * Register : APLL_CTRL @ 0XFD1A0020
    * Mux select for determining which clock feeds this PLL. 0XX pss_ref_clk i
    * s the source 100 video clk is the source 101 pss_alt_ref_clk is the sour
    * ce 110 aux_refclk[X] is the source 111 gt_crx_ref_clk is the source
    *  PSU_CRF_APB_APLL_CTRL_PRE_SRC                               0x0
    * The integer portion of the feedback divider to the PLL
    *  PSU_CRF_APB_APLL_CTRL_FBDIV                                 0x50

    * This turns on the divide by 2 that is inside of the PLL. This does not c
    * hange the VCO frequency, just the output frequency
    *  PSU_CRF_APB_APLL_CTRL_DIV2                                  0x1
    * PLL Basic Control
    * (OFFSET, MASK, VALUE)      (0XFD1A0020, 0x00717F00U ,0x00015000U)
    */
	PSU_Mask_Write(CRF_APB_APLL_CTRL_OFFSET, 0x00717F00U, 0x00015000U);
/*##################################################################### */

    /*
    * BY PASS PLL
    */
    /*
    * Register : APLL_CTRL @ 0XFD1A0020
    * Bypasses the PLL clock. The usable clock will be determined from the POS
    * T_SRC field. (This signal may only be toggled after 4 cycles of the old
    * clock and 4 cycles of the new clock. This is not usually an issue, but d
    * esigners must be aware.)
    *  PSU_CRF_APB_APLL_CTRL_BYPASS                                1
    * PLL Basic Control
    * (OFFSET, MASK, VALUE)      (0XFD1A0020, 0x00000008U ,0x00000008U)
    */
	PSU_Mask_Write(CRF_APB_APLL_CTRL_OFFSET, 0x00000008U, 0x00000008U);
/*##################################################################### */

    /*
    * ASSERT RESET
    */
    /*
    * Register : APLL_CTRL @ 0XFD1A0020
    * Asserts Reset to the PLL. When asserting reset, the PLL must already be
    * in BYPASS.
    *  PSU_CRF_APB_APLL_CTRL_RESET                                 1
    * PLL Basic Control
    * (OFFSET, MASK, VALUE)      (0XFD1A0020, 0x00000001U ,0x00000001U)
    */
	PSU_Mask_Write(CRF_APB_APLL_CTRL_OFFSET, 0x00000001U, 0x00000001U);
/*##################################################################### */

    /*
    * DEASSERT RESET
    */
    /*
    * Register : APLL_CTRL @ 0XFD1A0020
    * Asserts Reset to the PLL. When asserting reset, the PLL must already be
    * in BYPASS.
    *  PSU_CRF_APB_APLL_CTRL_RESET                                 0
    * PLL Basic Control
    * (OFFSET, MASK, VALUE)      (0XFD1A0020, 0x00000001U ,0x00000000U)
    */
	PSU_Mask_Write(CRF_APB_APLL_CTRL_OFFSET, 0x00000001U, 0x00000000U);
/*##################################################################### */

    /*
    * CHECK PLL STATUS
    */
    /*
    * Register : PLL_STATUS @ 0XFD1A0044
    * APLL is locked
    *  PSU_CRF_APB_PLL_STATUS_APLL_LOCK                            1
    * (OFFSET, MASK, VALUE)      (0XFD1A0044, 0x00000001U ,0x00000001U)
    */
	Mask_Poll(CRF_APB_PLL_STATUS_OFFSET, 0x00000001U);

/*##################################################################### */

    /*
    * REMOVE PLL BY PASS
    */
    /*
    * Register : APLL_CTRL @ 0XFD1A0020
    * Bypasses the PLL clock. The usable clock will be determined from the POS
    * T_SRC field. (This signal may only be toggled after 4 cycles of the old
    * clock and 4 cycles of the new clock. This is not usually an issue, but d
    * esigners must be aware.)
    *  PSU_CRF_APB_APLL_CTRL_BYPASS                                0
    * PLL Basic Control
    * (OFFSET, MASK, VALUE)      (0XFD1A0020, 0x00000008U ,0x00000000U)
    */
	PSU_Mask_Write(CRF_APB_APLL_CTRL_OFFSET, 0x00000008U, 0x00000000U);

	Status = XST_SUCCESS;

	return Status;
}

static int Psu_Clock_Init_Data(void)
{
	int Status = XST_FAILURE;

    /*
    * CLOCK CONTROL SLCR REGISTER
    */
/*##################################################################### */

#ifdef XIS_GET_BOARD_PARAMS
    /*
    * Register : I2C1_REF_CTRL @ 0XFF5E0124

    * Clock active signal. Switch to 0 to disable the clock
    *  PSU_CRL_APB_I2C1_REF_CTRL_CLKACT                            0x1

    * 6 bit divider
    *  PSU_CRL_APB_I2C1_REF_CTRL_DIVISOR1                          0x1

    * 6 bit divider
    *  PSU_CRL_APB_I2C1_REF_CTRL_DIVISOR0                          0xa

    * 000 = IOPLL; 010 = RPLL; 011 = DPLL; (This signal may only be toggled af
    * ter 4 cycles of the old clock and 4 cycles of the new clock. This is not
    *  usually an issue, but designers must be aware.)
    *  PSU_CRL_APB_I2C1_REF_CTRL_SRCSEL                            0x0

    * This register controls this reference clock
    * (OFFSET, MASK, VALUE)      (0XFF5E0124, 0x013F3F07U ,0x01010F00U)
    */
	PSU_Mask_Write(CRL_APB_I2C1_REF_CTRL_OFFSET,
		0x013F3F07U, 0x01010A00U);
#endif
/*##################################################################### */

#ifdef XIS_UART_ENABLE
    /*
    * Register : UART0_REF_CTRL @ 0XFF5E0074

    * Clock active signal. Switch to 0 to disable the clock
    *  PSU_CRL_APB_UART0_REF_CTRL_CLKACT                           0x1

    * 6 bit divider
    *  PSU_CRL_APB_UART0_REF_CTRL_DIVISOR1                         0x1

    * 6 bit divider
    *  PSU_CRL_APB_UART0_REF_CTRL_DIVISOR0                         0xa

    * 000 = IOPLL; 010 = RPLL; 011 = DPLL; (This signal may only be toggled af
    * ter 4 cycles of the old clock and 4 cycles of the new clock. This is not
    *  usually an issue, but designers must be aware.)
    *  PSU_CRL_APB_UART0_REF_CTRL_SRCSEL                           0x0

    * This register controls this reference clock
    * (OFFSET, MASK, VALUE)      (0XFF5E0074, 0x013F3F07U ,0x01010A00U)
    */
	PSU_Mask_Write(CRL_APB_UART0_REF_CTRL_OFFSET,
		0x013F3F07U, 0x01010A00U);

    /*
    * Register : UART1_REF_CTRL @ 0XFF5E0078

    * Clock active signal. Switch to 0 to disable the clock
    *  PSU_CRL_APB_UART1_REF_CTRL_CLKACT                           0x1

    * 6 bit divider
    *  PSU_CRL_APB_UART1_REF_CTRL_DIVISOR1                         0x1

    * 6 bit divider
    *  PSU_CRL_APB_UART1_REF_CTRL_DIVISOR0                         0xa

    * 000 = IOPLL; 010 = RPLL; 011 = DPLL; (This signal may only be toggled af
    * ter 4 cycles of the old clock and 4 cycles of the new clock. This is not
    *  usually an issue, but designers must be aware.)
    *  PSU_CRL_APB_UART1_REF_CTRL_SRCSEL                           0x0

    * This register controls this reference clock
    * (OFFSET, MASK, VALUE)      (0XFF5E0078, 0x013F3F07U ,0x01010A00U)
    */
	PSU_Mask_Write(CRL_APB_UART1_REF_CTRL_OFFSET,
		0x013F3F07U, 0x01010A00U);
#endif
/*##################################################################### */

#ifdef XIS_UPDATE_A_B_MECHANISM
    /*
    * Register : QSPI_REF_CTRL @ 0XFF5E0068

    * Clock active signal. Switch to 0 to disable the clock
    *  PSU_CRL_APB_QSPI_REF_CTRL_CLKACT                            0x1

    * 6 bit divider
    *  PSU_CRL_APB_QSPI_REF_CTRL_DIVISOR1                          0x1

    * 6 bit divider
    *  PSU_CRL_APB_QSPI_REF_CTRL_DIVISOR0                          0x8

    * 000 = IOPLL; 010 = RPLL; 011 = DPLL; (This signal may only be toggled af
    * ter 4 cycles of the old clock and 4 cycles of the new clock. This is not
    *  usually an issue, but designers must be aware.)
    *  PSU_CRL_APB_QSPI_REF_CTRL_SRCSEL                            0x0

    * This register controls this reference clock
    * (OFFSET, MASK, VALUE)      (0XFF5E0068, 0x013F3F07U ,0x01010C00U)
    */
	PSU_Mask_Write(CRL_APB_QSPI_REF_CTRL_OFFSET,
		0x013F3F07U, 0x01010800U);
#endif

/*##################################################################### */

    /*
    * Register : TIMESTAMP_REF_CTRL @ 0XFF5E0128

    * 6 bit divider
    *  PSU_CRL_APB_TIMESTAMP_REF_CTRL_DIVISOR0                     0xf

    * 1XX = pss_ref_clk; 000 = IOPLL; 010 = RPLL; 011 = DPLL; (This signal may
    *  only be toggled after 4 cycles of the old clock and 4 cycles of the new
    *  clock. This is not usually an issue, but designers must be aware.)
    *  PSU_CRL_APB_TIMESTAMP_REF_CTRL_SRCSEL                       0x0

    * Clock active signal. Switch to 0 to disable the clock
    *  PSU_CRL_APB_TIMESTAMP_REF_CTRL_CLKACT                       0x1

    * This register controls this reference clock
    * (OFFSET, MASK, VALUE)      (0XFF5E0128, 0x01003F07U ,0x01000F00U)
    */

	PSU_Mask_Write(CRL_APB_TIMESTAMP_REF_CTRL_OFFSET,
		0x01003F07U, 0x01000A00U);

	Status = XST_SUCCESS;

	return Status;
}

static int Psu_Mio_Init_Data(void)
{
	int Status = XST_FAILURE;

#ifdef XIS_UPDATE_A_B_MECHANISM
    /*
    * MIO PROGRAMMING
    */
    /*
    * Register : MIO_PIN_0 @ 0XFF180000

    * Level 0 Mux Select 0= Level 1 Mux Output 1= qspi, Output, qspi_sclk_out-
    *  (QSPI Clock)
    *  PSU_IOU_SLCR_MIO_PIN_0_L0_SEL                               1

    * Level 1 Mux Select 0= Level 2 Mux Output 1= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_0_L1_SEL                               0

    * Level 2 Mux Select 0= Level 3 Mux Output 1= Not Used 2= test_scan, Input
    * , test_scan_in[0]- (Test Scan Port) = test_scan, Output, test_scan_out[0
    * ]- (Test Scan Port) 3= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_0_L2_SEL                               0

    * Level 3 Mux Select 0= gpio0, Input, gpio_0_pin_in[0]- (GPIO bank 0) 0= g
    * pio0, Output, gpio_0_pin_out[0]- (GPIO bank 0) 1= can1, Output, can1_phy
    * _RX- (Can RX signal) 2= i2c1, Input, i2c1_scl_input- (SCL signal) 2= i2c
    * 1, Output, i2c1_scl_out- (SCL signal) 3= pjtag, Input, pjtag_tck- (PJTAG
    *  TCK) 4= spi0, Input, spi0_sclk_in- (SPI Clock) 4= spi0, Output, spi0_sc
    * lk_out- (SPI Clock) 5= ttc3, Input, ttc3_clk_in- (TTC Clock) 6= ua1, Out
    * put, ua1_RXd- (UART transmitter serial output) 7= trace, Output, trace_c
    * lk- (Trace Port Clock)
    *  PSU_IOU_SLCR_MIO_PIN_0_L3_SEL                               0

    * Configures MIO Pin 0 peripheral interface mapping. S
    * (OFFSET, MASK, VALUE)      (0XFF180000, 0x000000FEU ,0x00000002U)
    */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_0_OFFSET, 0x000000FEU, 0x00000002U);
/*##################################################################### */

    /*
    * Register : MIO_PIN_1 @ 0XFF180004

    * Level 0 Mux Select 0= Level 1 Mux Output 1= qspi, Input, qspi_mi_mi1- (Q
    * SPI Databus) 1= qspi, Output, qspi_so_mo1- (QSPI Databus)
    *  PSU_IOU_SLCR_MIO_PIN_1_L0_SEL                               1

    * Level 1 Mux Select 0= Level 2 Mux Output 1= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_1_L1_SEL                               0

    * Level 2 Mux Select 0= Level 3 Mux Output 1= Not Used 2= test_scan, Input
    * , test_scan_in[1]- (Test Scan Port) = test_scan, Output, test_scan_out[1
    * ]- (Test Scan Port) 3= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_1_L2_SEL                               0

    * Level 3 Mux Select 0= gpio0, Input, gpio_0_pin_in[1]- (GPIO bank 0) 0= g
    * pio0, Output, gpio_0_pin_out[1]- (GPIO bank 0) 1= can1, Input, can1_phy_
    * rx- (Can RX signal) 2= i2c1, Input, i2c1_sda_input- (SDA signal) 2= i2c1
    * , Output, i2c1_sda_out- (SDA signal) 3= pjtag, Input, pjtag_tdi- (PJTAG
    * TDI) 4= spi0, Output, spi0_n_ss_out[2]- (SPI Master Selects) 5= ttc3, Ou
    * tput, ttc3_wave_out- (TTC Waveform Clock) 6= ua1, Input, ua1_rxd- (UART
    * receiver serial input) 7= trace, Output, trace_ctl- (Trace Port Control
    * Signal)
    *  PSU_IOU_SLCR_MIO_PIN_1_L3_SEL                               0

    * Configures MIO Pin 1 peripheral interface mapping
    * (OFFSET, MASK, VALUE)      (0XFF180004, 0x000000FEU ,0x00000002U)
    */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_1_OFFSET, 0x000000FEU, 0x00000002U);
/*##################################################################### */

    /*
    * Register : MIO_PIN_2 @ 0XFF180008

    * Level 0 Mux Select 0= Level 1 Mux Output 1= qspi, Input, qspi_mi2- (QSPI
    *  Databus) 1= qspi, Output, qspi_mo2- (QSPI Databus)
    *  PSU_IOU_SLCR_MIO_PIN_2_L0_SEL                               1

    * Level 1 Mux Select 0= Level 2 Mux Output 1= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_2_L1_SEL                               0

    * Level 2 Mux Select 0= Level 3 Mux Output 1= Not Used 2= test_scan, Input
    * , test_scan_in[2]- (Test Scan Port) = test_scan, Output, test_scan_out[2
    * ]- (Test Scan Port) 3= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_2_L2_SEL                               0

    * Level 3 Mux Select 0= gpio0, Input, gpio_0_pin_in[2]- (GPIO bank 0) 0= g
    * pio0, Output, gpio_0_pin_out[2]- (GPIO bank 0) 1= can0, Input, can0_phy_
    * rx- (Can RX signal) 2= i2c0, Input, i2c0_scl_input- (SCL signal) 2= i2c0
    * , Output, i2c0_scl_out- (SCL signal) 3= pjtag, Output, pjtag_tdo- (PJTAG
    *  TDO) 4= spi0, Output, spi0_n_ss_out[1]- (SPI Master Selects) 5= ttc2, I
    * nput, ttc2_clk_in- (TTC Clock) 6= ua0, Input, ua0_rxd- (UART receiver se
    * rial input) 7= trace, Output, tracedq[0]- (Trace Port Databus)
    *  PSU_IOU_SLCR_MIO_PIN_2_L3_SEL                               0

    * Configures MIO Pin 2 peripheral interface mapping
    * (OFFSET, MASK, VALUE)      (0XFF180008, 0x000000FEU ,0x00000002U)
    */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_2_OFFSET, 0x000000FEU, 0x00000002U);
/*##################################################################### */

    /*
    * Register : MIO_PIN_3 @ 0XFF18000C

    * Level 0 Mux Select 0= Level 1 Mux Output 1= qspi, Input, qspi_mi3- (QSPI
    *  Databus) 1= qspi, Output, qspi_mo3- (QSPI Databus)
    *  PSU_IOU_SLCR_MIO_PIN_3_L0_SEL                               1

    * Level 1 Mux Select 0= Level 2 Mux Output 1= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_3_L1_SEL                               0

    * Level 2 Mux Select 0= Level 3 Mux Output 1= Not Used 2= test_scan, Input
    * , test_scan_in[3]- (Test Scan Port) = test_scan, Output, test_scan_out[3
    * ]- (Test Scan Port) 3= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_3_L2_SEL                               0

    * Level 3 Mux Select 0= gpio0, Input, gpio_0_pin_in[3]- (GPIO bank 0) 0= g
    * pio0, Output, gpio_0_pin_out[3]- (GPIO bank 0) 1= can0, Output, can0_phy
    * _RX- (Can RX signal) 2= i2c0, Input, i2c0_sda_input- (SDA signal) 2= i2c
    * 0, Output, i2c0_sda_out- (SDA signal) 3= pjtag, Input, pjtag_tms- (PJTAG
    *  TMS) 4= spi0, Input, spi0_n_ss_in- (SPI Master Selects) 4= spi0, Output
    * , spi0_n_ss_out[0]- (SPI Master Selects) 5= ttc2, Output, ttc2_wave_out-
    *  (TTC Waveform Clock) 6= ua0, Output, ua0_RXd- (UART transmitter serial
    * output) 7= trace, Output, tracedq[1]- (Trace Port Databus)
    *  PSU_IOU_SLCR_MIO_PIN_3_L3_SEL                               0

    * Configures MIO Pin 3 peripheral interface mapping
    * (OFFSET, MASK, VALUE)      (0XFF18000C, 0x000000FEU ,0x00000002U)
    */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_3_OFFSET, 0x000000FEU, 0x00000002U);
/*##################################################################### */

    /*
    * Register : MIO_PIN_4 @ 0XFF180010

    * Level 0 Mux Select 0= Level 1 Mux Output 1= qspi, Output, qspi_mo_mo0- (
    * QSPI Databus) 1= qspi, Input, qspi_si_mi0- (QSPI Databus)
    *  PSU_IOU_SLCR_MIO_PIN_4_L0_SEL                               1

    * Level 1 Mux Select 0= Level 2 Mux Output 1= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_4_L1_SEL                               0

    * Level 2 Mux Select 0= Level 3 Mux Output 1= Not Used 2= test_scan, Input
    * , test_scan_in[4]- (Test Scan Port) = test_scan, Output, test_scan_out[4
    * ]- (Test Scan Port) 3= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_4_L2_SEL                               0

    * Level 3 Mux Select 0= gpio0, Input, gpio_0_pin_in[4]- (GPIO bank 0) 0= g
    * pio0, Output, gpio_0_pin_out[4]- (GPIO bank 0) 1= can1, Output, can1_phy
    * _RX- (Can RX signal) 2= i2c1, Input, i2c1_scl_input- (SCL signal) 2= i2c
    * 1, Output, i2c1_scl_out- (SCL signal) 3= swdt1, Input, swdt1_clk_in- (Wa
    * tch Dog Timer Input clock) 4= spi0, Input, spi0_mi- (MISO signal) 4= spi
    * 0, Output, spi0_so- (MISO signal) 5= ttc1, Input, ttc1_clk_in- (TTC Cloc
    * k) 6= ua1, Output, ua1_RXd- (UART transmitter serial output) 7= trace, O
    * utput, tracedq[2]- (Trace Port Databus)
    *  PSU_IOU_SLCR_MIO_PIN_4_L3_SEL                               0

    * Configures MIO Pin 4 peripheral interface mapping
    * (OFFSET, MASK, VALUE)      (0XFF180010, 0x000000FEU ,0x00000002U)
    */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_4_OFFSET, 0x000000FEU, 0x00000002U);
/*##################################################################### */

    /*
    * Register : MIO_PIN_5 @ 0XFF180014

    * Level 0 Mux Select 0= Level 1 Mux Output 1= qspi, Output, qspi_n_ss_out-
    *  (QSPI Slave Select)
    *  PSU_IOU_SLCR_MIO_PIN_5_L0_SEL                               1

    * Level 1 Mux Select 0= Level 2 Mux Output 1= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_5_L1_SEL                               0

    * Level 2 Mux Select 0= Level 3 Mux Output 1= Not Used 2= test_scan, Input
    * , test_scan_in[5]- (Test Scan Port) = test_scan, Output, test_scan_out[5
    * ]- (Test Scan Port) 3= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_5_L2_SEL                               0

    * Level 3 Mux Select 0= gpio0, Input, gpio_0_pin_in[5]- (GPIO bank 0) 0= g
    * pio0, Output, gpio_0_pin_out[5]- (GPIO bank 0) 1= can1, Input, can1_phy_
    * rx- (Can RX signal) 2= i2c1, Input, i2c1_sda_input- (SDA signal) 2= i2c1
    * , Output, i2c1_sda_out- (SDA signal) 3= swdt1, Output, swdt1_rst_out- (W
    * atch Dog Timer Output clock) 4= spi0, Output, spi0_mo- (MOSI signal) 4=
    * spi0, Input, spi0_si- (MOSI signal) 5= ttc1, Output, ttc1_wave_out- (TTC
    *  Waveform Clock) 6= ua1, Input, ua1_rxd- (UART receiver serial input) 7=
    *  trace, Output, tracedq[3]- (Trace Port Databus)
    *  PSU_IOU_SLCR_MIO_PIN_5_L3_SEL                               0

    * Configures MIO Pin 5 peripheral interface mapping
    * (OFFSET, MASK, VALUE)      (0XFF180014, 0x000000FEU ,0x00000002U)
    */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_5_OFFSET, 0x000000FEU, 0x00000002U);
/*##################################################################### */

    /*
    * Register : MIO_PIN_12 @ 0XFF180030

    * Level 0 Mux Select 0= Level 1 Mux Output 1= qspi, Output, qspi_sclk_out_
    * upper- (QSPI Upper Clock)
    *  PSU_IOU_SLCR_MIO_PIN_12_L0_SEL                              1

    * Level 1 Mux Select 0= Level 2 Mux Output 1= nand, Input, nfc_dqs_in- (NA
    * ND Strobe) 1= nand, Output, nfc_dqs_out- (NAND Strobe)
    *  PSU_IOU_SLCR_MIO_PIN_12_L1_SEL                              0

    * Level 2 Mux Select 0= Level 3 Mux Output 1= Not Used 2= test_scan, Input
    * , test_scan_in[12]- (Test Scan Port) = test_scan, Output, test_scan_out[
    * 12]- (Test Scan Port) 3= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_12_L2_SEL                              0

    * Level 3 Mux Select 0= gpio0, Input, gpio_0_pin_in[12]- (GPIO bank 0) 0=
    * gpio0, Output, gpio_0_pin_out[12]- (GPIO bank 0) 1= can1, Output, can1_p
    * hy_RX- (Can RX signal) 2= i2c1, Input, i2c1_scl_input- (SCL signal) 2= i
    * 2c1, Output, i2c1_scl_out- (SCL signal) 3= pjtag, Input, pjtag_tck- (PJT
    * AG TCK) 4= spi0, Input, spi0_sclk_in- (SPI Clock) 4= spi0, Output, spi0_
    * sclk_out- (SPI Clock) 5= ttc1, Input, ttc1_clk_in- (TTC Clock) 6= ua1, O
    * utput, ua1_RXd- (UART transmitter serial output) 7= trace, Output, trace
    * dq[10]- (Trace Port Databus)
    *  PSU_IOU_SLCR_MIO_PIN_12_L3_SEL                              0

    * Configures MIO Pin 12 peripheral interface mapping
    * (OFFSET, MASK, VALUE)      (0XFF180030, 0x000000FEU ,0x00000000U)
    */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_12_OFFSET, 0x000000FEU, 0x00000000U);
#endif
/*##################################################################### */

#ifdef XIS_GET_BOARD_PARAMS
    /*
    * Register : MIO_PIN_16 @ 0XFF180040

    * Level 0 Mux Select 0= Level 1 Mux Output 1= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_16_L0_SEL                              0

    * Level 1 Mux Select 0= Level 2 Mux Output 1= nand, Input, nfc_dq_in[0]- (
    * NAND Data Bus) 1= nand, Output, nfc_dq_out[0]- (NAND Data Bus)
    *  PSU_IOU_SLCR_MIO_PIN_16_L1_SEL                              0

    * Level 2 Mux Select 0= Level 3 Mux Output 1= sd0, Input, sd0_data_in[3]-
    * (8-bit Data bus) = sd0, Output, sdio0_data_out[3]- (8-bit Data bus) 2= t
    * est_scan, Input, test_scan_in[16]- (Test Scan Port) = test_scan, Output,
    *  test_scan_out[16]- (Test Scan Port) 3= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_16_L2_SEL                              0

    * Level 3 Mux Select 0= gpio0, Input, gpio_0_pin_in[16]- (GPIO bank 0) 0=
    * gpio0, Output, gpio_0_pin_out[16]- (GPIO bank 0) 1= can1, Output, can1_p
    * hy_RX- (Can RX signal) 2= i2c1, Input, i2c1_scl_input- (SCL signal) 2= i
    * 2c1, Output, i2c1_scl_out- (SCL signal) 3= swdt1, Input, swdt1_clk_in- (
    * Watch Dog Timer Input clock) 4= spi0, Input, spi0_mi- (MISO signal) 4= s
    * pi0, Output, spi0_so- (MISO signal) 5= ttc3, Input, ttc3_clk_in- (TTC Cl
    * ock) 6= ua1, Output, ua1_RXd- (UART transmitter serial output) 7= trace,
    *  Output, tracedq[14]- (Trace Port Databus)
    *  PSU_IOU_SLCR_MIO_PIN_16_L3_SEL                              2

    * Configures MIO Pin 16 peripheral interface mapping
    * (OFFSET, MASK, VALUE)      (0XFF180040, 0x000000FEU ,0x00000040U)
    */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_16_OFFSET, 0x000000FEU, 0x00000040U);
/*##################################################################### */

    /*
    * Register : MIO_PIN_17 @ 0XFF180044

    * Level 0 Mux Select 0= Level 1 Mux Output 1= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_17_L0_SEL                              0

    * Level 1 Mux Select 0= Level 2 Mux Output 1= nand, Input, nfc_dq_in[1]- (
    * NAND Data Bus) 1= nand, Output, nfc_dq_out[1]- (NAND Data Bus)
    *  PSU_IOU_SLCR_MIO_PIN_17_L1_SEL                              0

    * Level 2 Mux Select 0= Level 3 Mux Output 1= sd0, Input, sd0_data_in[4]-
    * (8-bit Data bus) = sd0, Output, sdio0_data_out[4]- (8-bit Data bus) 2= t
    * est_scan, Input, test_scan_in[17]- (Test Scan Port) = test_scan, Output,
    *  test_scan_out[17]- (Test Scan Port) 3= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_17_L2_SEL                              0

    * Level 3 Mux Select 0= gpio0, Input, gpio_0_pin_in[17]- (GPIO bank 0) 0=
    * gpio0, Output, gpio_0_pin_out[17]- (GPIO bank 0) 1= can1, Input, can1_ph
    * y_rx- (Can RX signal) 2= i2c1, Input, i2c1_sda_input- (SDA signal) 2= i2
    * c1, Output, i2c1_sda_out- (SDA signal) 3= swdt1, Output, swdt1_rst_out-
    * (Watch Dog Timer Output clock) 4= spi0, Output, spi0_mo- (MOSI signal) 4
    * = spi0, Input, spi0_si- (MOSI signal) 5= ttc3, Output, ttc3_wave_out- (T
    * TC Waveform Clock) 6= ua1, Input, ua1_rxd- (UART receiver serial input)
    * 7= trace, Output, tracedq[15]- (Trace Port Databus)
    *  PSU_IOU_SLCR_MIO_PIN_17_L3_SEL                              2

    * Configures MIO Pin 17 peripheral interface mapping
    * (OFFSET, MASK, VALUE)      (0XFF180044, 0x000000FEU ,0x00000040U)
    */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_17_OFFSET, 0x000000FEU, 0x00000040U);
#endif
/*##################################################################### */

#ifdef XIS_UART_ENABLE

#ifdef XIS_GET_BOARD_PARAMS
    /*
    * Register : MIO_PIN_18 @ 0XFF180048

    * Level 0 Mux Select 0= Level 1 Mux Output 1= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_18_L0_SEL                              0

    * Level 1 Mux Select 0= Level 2 Mux Output 1= nand, Input, nfc_dq_in[2]- (
    * NAND Data Bus) 1= nand, Output, nfc_dq_out[2]- (NAND Data Bus)
    *  PSU_IOU_SLCR_MIO_PIN_18_L1_SEL                              0

    * Level 2 Mux Select 0= Level 3 Mux Output 1= sd0, Input, sd0_data_in[5]-
    * (8-bit Data bus) = sd0, Output, sdio0_data_out[5]- (8-bit Data bus) 2= t
    * est_scan, Input, test_scan_in[18]- (Test Scan Port) = test_scan, Output,
    *  test_scan_out[18]- (Test Scan Port) 3= csu, Input, csu_ext_tamper- (CSU
    *  Ext Tamper)
    *  PSU_IOU_SLCR_MIO_PIN_18_L2_SEL                              0

    * Level 3 Mux Select 0= gpio0, Input, gpio_0_pin_in[18]- (GPIO bank 0) 0=
    * gpio0, Output, gpio_0_pin_out[18]- (GPIO bank 0) 1= can0, Input, can0_ph
    * y_rx- (Can RX signal) 2= i2c0, Input, i2c0_scl_input- (SCL signal) 2= i2
    * c0, Output, i2c0_scl_out- (SCL signal) 3= swdt0, Input, swdt0_clk_in- (W
    * atch Dog Timer Input clock) 4= spi1, Input, spi1_mi- (MISO signal) 4= sp
    * i1, Output, spi1_so- (MISO signal) 5= ttc2, Input, ttc2_clk_in- (TTC Clo
    * ck) 6= ua0, Input, ua0_rxd- (UART receiver serial input) 7= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_18_L3_SEL                              6

    * Configures MIO Pin 18 peripheral interface mapping
    * (OFFSET, MASK, VALUE)      (0XFF180048, 0x000000FEU ,0x000000C0U)
    */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_18_OFFSET, 0x000000FEU, 0x000000C0U);
/*##################################################################### */

    /*
    * Register : MIO_PIN_19 @ 0XFF18004C

    * Level 0 Mux Select 0= Level 1 Mux Output 1= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_19_L0_SEL                              0

    * Level 1 Mux Select 0= Level 2 Mux Output 1= nand, Input, nfc_dq_in[3]- (
    * NAND Data Bus) 1= nand, Output, nfc_dq_out[3]- (NAND Data Bus)
    *  PSU_IOU_SLCR_MIO_PIN_19_L1_SEL                              0

    * Level 2 Mux Select 0= Level 3 Mux Output 1= sd0, Input, sd0_data_in[6]-
    * (8-bit Data bus) = sd0, Output, sdio0_data_out[6]- (8-bit Data bus) 2= t
    * est_scan, Input, test_scan_in[19]- (Test Scan Port) = test_scan, Output,
    *  test_scan_out[19]- (Test Scan Port) 3= csu, Input, csu_ext_tamper- (CSU
    *  Ext Tamper)
    *  PSU_IOU_SLCR_MIO_PIN_19_L2_SEL                              0

    * Level 3 Mux Select 0= gpio0, Input, gpio_0_pin_in[19]- (GPIO bank 0) 0=
    * gpio0, Output, gpio_0_pin_out[19]- (GPIO bank 0) 1= can0, Output, can0_p
    * hy_RX- (Can RX signal) 2= i2c0, Input, i2c0_sda_input- (SDA signal) 2= i
    * 2c0, Output, i2c0_sda_out- (SDA signal) 3= swdt0, Output, swdt0_rst_out-
    *  (Watch Dog Timer Output clock) 4= spi1, Output, spi1_n_ss_out[2]- (SPI
    * Master Selects) 5= ttc2, Output, ttc2_wave_out- (TTC Waveform Clock) 6=
    * ua0, Output, ua0_RXd- (UART transmitter serial output) 7= Not Used
    *  PSU_IOU_SLCR_MIO_PIN_19_L3_SEL                              6

    * Configures MIO Pin 19 peripheral interface mapping
    * (OFFSET, MASK, VALUE)      (0XFF18004C, 0x000000FEU ,0x000000C0U)
    */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_19_OFFSET, 0x000000FEU, 0x000000C0U);
#else
/*##################################################################### */

    /*
	 * Register : MIO_PIN_36 @ 0XFF180090
	 * Level 0 Mux Select 0= Level 1 Mux Output 1= gem0, Output, gem0_rgmii_RX_
	 * clk- (RX RGMII clock)
	 *  PSU_IOU_SLCR_MIO_PIN_36_L0_SEL                              0
	 *
	 * Level 1 Mux Select 0= Level 2 Mux Output 1= PCIe Reset input
	 *  PSU_IOU_SLCR_MIO_PIN_36_L1_SEL                              0
	 *
	 * Level 2 Mux Select 0= Level 3 Mux Output 1= PMU GPO1 [4] output
	 *  2= Scan Test [36] input/output 3 = DisplayPort Aux output Enable output
	 *  PSU_IOU_SLCR_MIO_PIN_36_L2_SEL                              0
	 *
	 * Level 3 Mux Select 0= gpio1, Input, gpio_1_pin_in[36]- (GPIO bank 1) 0=
	 * gpio1, Output, gpio_1_pin_out[36]- (GPIO bank 1) 1= can0, Input, can1_ph
	 * y_tx- (Can TX signal) 2= i2c1, Input, i2c1_scl_input- (SCL signal) 2= i2
	 * c1, Output, i2c1_scl_out- (SCL signal) 3= FPD SWDT clock output
	 *  4= SPI1 MISO input/output
	 *  5= ttc1, Input, ttc1_clk_in- (TTC Clock) 6= ua1, In
	 * put, ua1_txd- (UART transmitter serial input) 7= trace, Output, trace_clk-
	 * (Trace Port Clock)
	 *  PSU_IOU_SLCR_MIO_PIN_36_L3_SEL                              0
	 *
	 * Configures MIO Pin 36 peripheral interface mapping
	 * (OFFSET, MASK, VALUE)      (0XFF180090, 0x000000FEU ,0x000000C0U)
	 */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_36_OFFSET, 0x000000FEU, 0x000000C0U);
/*##################################################################### */

    /*
	 * Register : MIO_PIN_37 @ 0XFF180094
	 * Level 0 Mux Select 0= Level 1 Mux Output 1= gem0, Output, gem0_rgmii_RX_
	 * clk- (RX RGMII clock)
	 *  PSU_IOU_SLCR_MIO_PIN_37_L0_SEL                              0
	 *
	 * Level 1 Mux Select 0= Level 2 Mux Output 1= PCIe Reset input
	 *  PSU_IOU_SLCR_MIO_PIN_37_L1_SEL                              0
	 *
	 * Level 2 Mux Select 0= Level 3 Mux Output 1= PMU GPO1 [5] output
	 *  2= Scan Test [37] input/output 3 = DisplayPort Aux output Data input
	 *  PSU_IOU_SLCR_MIO_PIN_37_L2_SEL                              0
	 *
	 * Level 3 Mux Select 0= gpio1, Input, gpio_1_pin_in[37]- (GPIO bank 1) 0=
	 * gpio1, Output, gpio_1_pin_out[37]- (GPIO bank 1) 1= can0, Input, can1_ph
	 * y_rx- (Can RX signal) 2= i2c1, Input, i2c1_sda_input- (SDA signal) 2= i2
	 * c1, Output, i2c1_sda_out- (SDA signal) 3= FPD SWDT reset output
	 *  4= SPI1 MISO input/output
	 *  5= ttc1, Input, ttc1_clk_in- (TTC Clock) 6= ua1, In
	 * put, ua1_rxd- (UART receiver serial input) 7= trace, Output, trace_clk-
	 * (Trace Port Clock)
	 *  PSU_IOU_SLCR_MIO_PIN_37_L3_SEL                              0
	 *
	 * Configures MIO Pin 37 peripheral interface mapping
	 * (OFFSET, MASK, VALUE)      (0XFF180094, 0x000000FEU ,0x000000C0U)
	 */
	PSU_Mask_Write(IOU_SLCR_MIO_PIN_37_OFFSET, 0x000000FEU, 0x000000C0U);
#endif

#endif
/*##################################################################### */

#ifdef XIS_UPDATE_A_B_MECHANISM
    /*
    * Register : MIO_MST_TRI0 @ 0XFF180204

    * Master Tri-state Enable for pin 0, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_00_TRI                        0

    * Master Tri-state Enable for pin 1, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_01_TRI                        0

    * Master Tri-state Enable for pin 2, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_02_TRI                        0

    * Master Tri-state Enable for pin 3, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_03_TRI                        0

    * Master Tri-state Enable for pin 4, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_04_TRI                        0

    * Master Tri-state Enable for pin 5, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_05_TRI                        0

    * Master Tri-state Enable for pin 12, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_12_TRI                        0
    */
	PSU_Mask_Write(IOU_SLCR_MIO_MST_TRI0_OFFSET,
			0x0000103FU, 0xFFFFEFC0U);
#endif

    /*
    * Master Tri-state Enable for pin 13, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_13_TRI                        1

    * Master Tri-state Enable for pin 14, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_14_TRI                        1

    * Master Tri-state Enable for pin 15, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_15_TRI                        1
    * Master Tri-state Enable for pin 16, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_16_TRI                        0

    * Master Tri-state Enable for pin 17, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_17_TRI                        0
    */
#ifdef XIS_GET_BOARD_PARAMS
	PSU_Mask_Write(IOU_SLCR_MIO_MST_TRI0_OFFSET,
			0x00030000U, 0xFFFCFFFFU);
#endif

    /*
    * Master Tri-state Enable for pin 18, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_18_TRI                        0

    * Master Tri-state Enable for pin 19, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_19_TRI                        0

    * Master Tri-state Enable for pin 20, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_20_TRI                        1

    * Master Tri-state Enable for pin 21, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_21_TRI                        1

    * Master Tri-state Enable for pin 22, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_22_TRI                        1

    * Master Tri-state Enable for pin 23, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_23_TRI                        1

    * Master Tri-state Enable for pin 24, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_24_TRI                        1

    * Master Tri-state Enable for pin 25, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_25_TRI                        1

    * Master Tri-state Enable for pin 26, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_26_TRI                        1

    * Master Tri-state Enable for pin 27, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_27_TRI                        1

    * Master Tri-state Enable for pin 28, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_28_TRI                        1

    * Master Tri-state Enable for pin 29, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_29_TRI                        1

    * Master Tri-state Enable for pin 30, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_30_TRI                        1

    * Master Tri-state Enable for pin 31, active high
    *  PSU_IOU_SLCR_MIO_MST_TRI0_PIN_31_TRI                        1

    * MIO pin Tri-state Enables, 31:0
    * (OFFSET, MASK, VALUE)      (0XFF180204, 0x000F1FFFU ,0xFFF0E000U)
    */
#ifdef XIS_UART_ENABLE
#ifdef XIS_GET_BOARD_PARAMS

	PSU_Mask_Write(IOU_SLCR_MIO_MST_TRI0_OFFSET,
			0x000C0000U, 0xFFF3FFFFU);
#else
	PSU_Mask_Write(IOU_SLCR_MIO_MST_TRI1_OFFSET,
			0x00000030U, 0xFFFFFFCFU);
#endif

#endif

	Status = XST_SUCCESS;

	return Status;
}

static int Psu_Peripherals_Init_Data(void)
{
	int Status = XST_FAILURE;

/*##################################################################### */
    /*
    * RESET BLOCK
    */
    /*
    * TIMESTAMP
    */
    /*
    * Register : RST_LPD_IOU2 @ 0XFF5E0238

    * Block level reset
    *  PSU_CRL_APB_RST_LPD_IOU2_TIMESTAMP_RESET                    0

    * Block level reset
    *  PSU_CRL_APB_RST_LPD_IOU2_IOU_CC_RESET                       0

    * Block level reset
    *  PSU_CRL_APB_RST_LPD_IOU2_ADMA_RESET                         0

    * Software control register for the IOU block. Each bit will cause a singl
    * erperipheral or part of the peripheral to be reset.
    * (OFFSET, MASK, VALUE)      (0XFF5E0238, 0x001A0000U ,0x00000000U)
    */
	PSU_Mask_Write(CRL_APB_RST_LPD_IOU2_OFFSET,
		0x001E0005U, 0x00000000U);

/*##################################################################### */

#ifdef XIS_UART_ENABLE
    /*
    * UART
    */
    /*
    * Register : RST_LPD_IOU2 @ 0XFF5E0238

    * Block level reset
    *  PSU_CRL_APB_RST_LPD_IOU2_UART0_RESET                        0

    * Block level reset
    *  PSU_CRL_APB_RST_LPD_IOU2_UART1_RESET                        0

    * Software control register for the IOU block. Each bit will cause a singl
    * erperipheral or part of the peripheral to be reset.
    * (OFFSET, MASK, VALUE)      (0XFF5E0238, 0x00000006U ,0x00000000U)
    */
	PSU_Mask_Write(CRL_APB_RST_LPD_IOU2_OFFSET,
		0x00000006U, 0x00000000U);
#endif
/*##################################################################### */

    /*
    * QSPI
    */
    /*
    * Register : RST_LPD_IOU2 @ 0XFF5E0238

    * Block level reset
    *  PSU_CRL_APB_RST_LPD_IOU2_QSPI_RESET                         0

    * Software control register for the IOU block. Each bit will cause a singl
    * erperipheral or part of the peripheral to be reset.
    * (OFFSET, MASK, VALUE)      (0XFF5E0238, 0x00040001U ,0x00000000U)
    */
	PSU_Mask_Write(CRL_APB_RST_LPD_IOU2_OFFSET,
		0x00040001U, 0x00000000U);
/*##################################################################### */

#ifdef XIS_GET_BOARD_PARAMS
    /*
    * I2C
    */
    /*
    * Register : RST_LPD_IOU2 @ 0XFF5E0238

    * Block level reset
    *  PSU_CRL_APB_RST_LPD_IOU2_I2C0_RESET                         0

    * Block level reset
    *  PSU_CRL_APB_RST_LPD_IOU2_I2C1_RESET                         0

    * Software control register for the IOU block. Each bit will cause a singl
    * erperipheral or part of the peripheral to be reset.
    * (OFFSET, MASK, VALUE)      (0XFF5E0238, 0x00000600U ,0x00000000U)
    */
	PSU_Mask_Write(CRL_APB_RST_LPD_IOU2_OFFSET,
		0x00000600U, 0x00000000U);
#endif
/*##################################################################### */

#ifdef XIS_UPDATE_A_B_MECHANISM
    /*
    * QSPI TAP DELAY
    */
    /*
    * Register : IOU_TAPDLY_BYPASS @ 0XFF180390

    * 0: Do not by pass the tap delays on the Rx clock signal of LQSPI 1: Bypa
    * ss the Tap delay on the Rx clock signal of LQSPI
    *  PSU_IOU_SLCR_IOU_TAPDLY_BYPASS_LQSPI_RX                     1

    * IOU tap delay bypass for the LQSPI and NAND controllers
    * (OFFSET, MASK, VALUE)      (0XFF180390, 0x00000004U ,0x00000004U)
    */
	PSU_Mask_Write(IOU_SLCR_IOU_TAPDLY_BYPASS_OFFSET,
		0x00000004U, 0x00000004U);
/*##################################################################### */

    /*
    * QSPI TZ
    */
    /*
    * Register : IOU_AXI_WPRTCN @ 0XFF240000

    * AXI protection [0] = '0' : Normal access [0] = '1' : Previleged access [
    * 1] = '0' : Secure access [1] = '1' : No secure access [2] = '0' : Data a
    * ccess [2] = '1'' : Instruction access
    *  PSU_IOU_SECURE_SLCR_IOU_AXI_WPRTCN_QSPI_AXI_AWPROT          2

    * AXI write protection type selection
    * (OFFSET, MASK, VALUE)      (0XFF240000, 0x0E000000U ,0x04000000U)
    */
	PSU_Mask_Write(IOU_SECURE_SLCR_IOU_AXI_WPRTCN_OFFSET,
		0x0E000000U, 0x04000000U);
#endif

	Status = XST_SUCCESS;

	return Status;
}

static int Mask_Poll(u32 Address, u32 Mask)
{
	int Status = XST_FAILURE;
	volatile u32 *Addr = (volatile u32 *)(unsigned long) Address;
	u32 PollTime = 0U;

	while (((*Addr & Mask) == 0U)) {
		if (PollTime == PSU_MASK_POLL_TIME)
			break;
		PollTime++;
	}

	if (PollTime < PSU_MASK_POLL_TIME) {
		Status = XST_SUCCESS;
	}

	return Status;
}

int Psu_Init(void)
{
	int Status = XST_FAILURE;

	Status &= Psu_Mio_Init_Data();
	Status |= Psu_Pll_Init_Data();
	Status |= Psu_Clock_Init_Data();
	Status |= Psu_Peripherals_Init_Data();

	return Status;
}
