/******************************************************************************
* Copyright (c) 2022 Xilinx, Inc.  All rights reserved.
* Copyright (c) 2023-2024 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************/
/**
* @file xparameters_ps.h
*
* This file contains the address definitions for the hard peripherals
* available in VERSAL NET
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who     Date     Changes
* ----- ------- -------- ---------------------------------------------------
* 8.0 	mus     11/26/21 First release
* 8.0   dp      07/11/22 Add TTC interrupt Id macros thats needed for
*                        interrupt wrapper.
* 8.0	sb	05/10/23 Add Interrupt Id's for WWDT.
* 9.0   dp      05/19/23 Update Interrupt IDs for USB
* 9.1   dp      01/12/24 Update GIC base address
* 9.2   asa     09/11/23 Fix link error for redefinion of ARMR5
*
* </pre>
*
* @note
*
* None.
*
******************************************************************************/

#ifndef _XPARAMETERS_PS_H_
#define _XPARAMETERS_PS_H_

/**
 *@cond nocomments
 */

#ifdef __cplusplus
extern "C" {
#endif

#if !defined(VERSAL_NET)
#define VERSAL_NET
#endif

#if !defined (__aarch64__)
#if !defined(ARMR52)
#define ARMR52
#if !defined(ARMR5)
#define ARMR5
#endif
#endif
#endif

/************************** Constant Definitions *****************************/

/*
 * This block contains constant declarations for the peripherals
 * within the hardblock
 */

/* Canonical definitions for DDR MEMORY */
#define XPAR_DDR_MEM_BASEADDR		0x00000000U
#define XPAR_DDR_MEM_HIGHADDR		0x3FFFFFFFU

/* Canonical definitions for Interrupts  */
#define XPAR_XUARTPS_0_INTR		XPS_UART0_INT_ID
#define XPAR_XUARTPS_1_INTR		XPS_UART1_INT_ID
#define XPAR_XIICPS_0_INTR		XPS_I2C0_INT_ID
#define XPAR_XIICPS_1_INTR		XPS_I2C1_INT_ID
#define XPAR_XSPIPS_0_INTR		XPS_SPI0_INT_ID
#define XPAR_XSPIPS_1_INTR		XPS_SPI1_INT_ID
#define XPAR_XCANPS_0_INTR		XPS_CAN0_INT_ID
#define XPAR_XCANPS_1_INTR		XPS_CAN1_INT_ID
#define XPAR_XGWDT_0_INTR		XPS_LPD_GWDT_0_INT_ID
#define XPAR_XGWDT_0_RST_INTR		XPS_LPD_GWDT_0_RST_INT_ID
#define XPAR_XWWDT_0_INTR		XPS_LPD_WWDT_0_INT_ID
#define XPAR_XWWDT_0_RST_PEND_INTR	XPS_LPD_WWDT_0_RST_PEND_INT_ID
#define XPAR_XGWDT_1_INTR		XPS_LPD_GWDT_1_INT_ID
#define XPAR_XGWDT_1_RST_INTR		XPS_LPD_GWDT_1_RST_INT_ID
#define XPAR_XWWDT_1_INTR		XPS_LPD_WWDT_1_INT_ID
#define XPAR_XWWDT_1_RST_PEND_INTR	XPS_LPD_WWDT_1_RST_PEND_INT_ID
#define XPAR_XGWDT_2_INTR		XPS_FPD_GWDT_2_INT_ID
#define XPAR_XGWDT_2_RST_INTR		XPS_FPD_GWDT_2_RST_INT_ID
#define XPAR_XWWDT_2_INTR		XPS_FPD_WWDT_2_INT_ID
#define XPAR_XWWDT_2_RST_PEND_INTR	XPS_FPD_WWDT_2_RST_PEND_INT_ID
#define XPAR_XGWDT_3_INTR		XPS_FPD_GWDT_3_INT_ID
#define XPAR_XGWDT_3_RST_INTR		XPS_FPD_GWDT_3_RST_INT_ID
#define XPAR_XWWDT_3_INTR		XPS_FPD_WWDT_3_INT_ID
#define XPAR_XWWDT_3_RST_PEND_INTR	XPS_FPD_WWDT_3_RST_PEND_INT_ID
#define XPAR_XGWDT_4_INTR		XPS_FPD_GWDT_4_INT_ID
#define XPAR_XGWDT_4_RST_INTR		XPS_FPD_GWDT_4_RST_INT_ID
#define XPAR_XWWDT_4_INTR		XPS_FPD_WWDT_4_INT_ID
#define XPAR_XWWDT_4_RST_PEND_INTR	XPS_FPD_WWDT_4_RST_PEND_INT_ID
#define XPAR_XGWDT_5_INTR		XPS_FPD_GWDT_5_INT_ID
#define XPAR_XGWDT_5_RST_INTR		XPS_FPD_GWDT_5_RST_INT_ID
#define XPAR_XWWDT_5_INTR		XPS_FPD_WWDT_5_INT_ID
#define XPAR_XWWDT_5_RST_PEND_INTR	XPS_FPD_WWDT_5_RST_PEND_INT_ID
#define XPAR_XGWDT_6_INTR		XPS_PMC_GWDT_6_INT_ID
#define XPAR_XGWDT_6_RST_INTR		XPS_PMC_GWDT_6_RST_INT_ID
#define XPAR_XWWDT_6_INTR		XPS_PMC_WWDT_6_INT_ID
#define XPAR_XWWDT_6_RST_PEND_INTR	XPS_PMC_WWDT_6_RST_PEND_INT_ID
#define XPAR_XGPIOPS_0_INTR		XPS_GPIO_INT_ID
#define XPAR_XEMACPS_0_INTR		XPS_GEM0_INT_ID
#define XPAR_XEMACPS_0_WAKE_INTR	XPS_GEM0_WAKE_INT_ID
#define XPAR_XEMACPS_1_INTR		XPS_GEM1_INT_ID
#define XPAR_XEMACPS_1_WAKE_INTR	XPS_GEM1_WAKE_INT_ID
#define XPAR_XSDIOPS_0_INTR		XPS_SDIO0_INT_ID
#define XPAR_XQSPIPS_0_INTR		XPS_QSPI_INT_ID
#define XPAR_XSDIOPS_1_INTR		XPS_SDIO1_INT_ID
#define XPAR_XDCFG_0_INTR		XPS_DVC_INT_ID
#define XPAR_XTTCPS_0_INTR		XPS_TTC0_0_INT_ID
#define XPAR_XTTCPS_1_INTR		XPS_TTC0_1_INT_ID
#define XPAR_XTTCPS_2_INTR		XPS_TTC0_2_INT_ID
#define XPAR_XTTCPS_3_INTR		XPS_TTC1_0_INT_ID
#define XPAR_XTTCPS_4_INTR		XPS_TTC1_1_INT_ID
#define XPAR_XTTCPS_5_INTR		XPS_TTC1_2_INT_ID
#define XPAR_XTTCPS_6_INTR		XPS_TTC2_0_INT_ID
#define XPAR_XTTCPS_7_INTR		XPS_TTC2_1_INT_ID
#define XPAR_XTTCPS_8_INTR		XPS_TTC2_2_INT_ID
#define XPAR_XTTCPS_9_INTR		XPS_TTC3_0_INT_ID
#define XPAR_XTTCPS_10_INTR		XPS_TTC3_1_INT_ID
#define XPAR_XTTCPS_11_INTR		XPS_TTC3_2_INT_ID
#define XPAR_XNANDPS8_0_INTR        	XPS_NAND_INT_ID
#define XPAR_XADMAPS_0_INTR 		XPS_ADMA_CH0_INT_ID
#define XPAR_XADMAPS_1_INTR 		XPS_ADMA_CH1_INT_ID
#define XPAR_XADMAPS_2_INTR		XPS_ADMA_CH2_INT_ID
#define XPAR_XADMAPS_3_INTR 		XPS_ADMA_CH3_INT_ID
#define XPAR_XADMAPS_4_INTR		XPS_ADMA_CH4_INT_ID
#define XPAR_XADMAPS_5_INTR 		XPS_ADMA_CH5_INT_ID
#define XPAR_XADMAPS_6_INTR 		XPS_ADMA_CH6_INT_ID
#define XPAR_XADMAPS_7_INTR 		XPS_ADMA_CH7_INT_ID
#define XPAR_XUSBPS_0_INTR       XPS_USB3_0_ENDPT_INT_ID
#define XPAR_XUSBPS_0_WAKE_INTR  XPS_USB3_0_WAKE_INT_ID
#define XPAR_PSXL_ADMA_0_INTR 		XPS_ADMA_CH0_INT_ID
#define XPAR_PSXL_ADMA_1_INTR 		XPS_ADMA_CH1_INT_ID
#define XPAR_PSXL_ADMA_2_INTR		XPS_ADMA_CH2_INT_ID
#define XPAR_PSXL_ADMA_3_INTR 		XPS_ADMA_CH3_INT_ID
#define XPAR_PSXL_ADMA_4_INTR		XPS_ADMA_CH4_INT_ID
#define XPAR_PSXL_ADMA_5_INTR 		XPS_ADMA_CH5_INT_ID
#define XPAR_PSXL_ADMA_6_INTR 		XPS_ADMA_CH6_INT_ID
#define XPAR_PSXL_ADMA_7_INTR 		XPS_ADMA_CH7_INT_ID
#define XPAR_PSXL_PMC_GPIO_INTR		XPMC_GPIO_INT_ID
#define XPAR_PSXL_PMC_I2C_INTR		XPMC_I2C_INT_ID
#define XPAR_PSXL_PMC_DMA_0_INTR		XPS_PMCDMA0_INT_ID
#define XPAR_PSXL_PMC_DMA_1_INTR		XPS_PMCDMA1_INT_ID
#define XPAR_PSVXL_I3C_0_INTR             XPS_I2C0_INT_ID
#define XPAR_PSVXL_I3C_1_INTR             XPS_I2C1_INT_ID

#define XPAR_PSX_ADMA_0_INTR 		XPS_ADMA_CH0_INT_ID
#define XPAR_PSX_ADMA_1_INTR 		XPS_ADMA_CH1_INT_ID
#define XPAR_PSX_ADMA_2_INTR		XPS_ADMA_CH2_INT_ID
#define XPAR_PSX_ADMA_3_INTR 		XPS_ADMA_CH3_INT_ID
#define XPAR_PSX_ADMA_4_INTR		XPS_ADMA_CH4_INT_ID
#define XPAR_PSX_ADMA_5_INTR 		XPS_ADMA_CH5_INT_ID
#define XPAR_PSX_ADMA_6_INTR 		XPS_ADMA_CH6_INT_ID
#define XPAR_PSX_ADMA_7_INTR 		XPS_ADMA_CH7_INT_ID
#define XPAR_PSX_PMC_GPIO_INTR		XPMC_GPIO_INT_ID
#define XPAR_PSX_PMC_I2C_INTR		XPMC_I2C_INT_ID
#define XPAR_PSX_PMC_DMA_0_INTR		XPS_PMCDMA0_INT_ID
#define XPAR_PSX_PMC_DMA_1_INTR		XPS_PMCDMA1_INT_ID

/* Canonical definitions for SCU GIC */
#define XPAR_SCUGIC_NUM_INSTANCES	1U
#define XPAR_SCUGIC_SINGLE_DEVICE_ID	0U
#define XPAR_SCUGIC_DIST_BASEADDR   0xE2000000
#define XPAR_SCUGIC_ACK_BEFORE		0U

#define XPAR_CPU_CORTEXR5_CORE_CLOCK_FREQ_HZ    XPAR_CPU_CORTEXR5_0_CPU_CLK_FREQ_HZ

/*
 * This block contains constant declarations for the peripherals
 * within the hardblock. These have been put for backwards compatibility
 */

#define XPS_SYS_CTRL_BASEADDR		0xF1060000U
#define XPS_CRP_BASEADDRESS		0xF1260000U
#define XPS_PMC_GLOBAL_BASEADDRESS	0xF1110000U


/* Shared Peripheral Interrupts (SPI) */
/* Updated Interrupt-IDs */
#define XPS_GPIO_INT_ID			(20U + 32U)
#define XPS_I2C0_INT_ID			(21U + 32U)
#define XPS_I2C1_INT_ID			(22U + 32U)
#define XPS_SPI0_INT_ID			(23U + 32U)
#define XPS_SPI1_INT_ID			(24U + 32U)
#define XPS_UART0_INT_ID		(25U + 32U)
#define XPS_UART1_INT_ID		(26U + 32U)
#define XPS_CAN0_INT_ID			(27U + 32U)
#define XPS_CAN1_INT_ID			(28U + 32U)
#define XPS_USB3_0_ENDPT_INT_ID		(29U + 32U)
#define XPS_GEM0_INT_ID			(39U + 32U)
#define XPS_GEM0_WAKE_INT_ID		(40U + 32U)
#define XPS_GEM1_INT_ID			(41U + 32U)
#define XPS_GEM1_WAKE_INT_ID		(42U + 32U)
#define XPS_TTC0_0_INT_ID		(43U + 32U)
#define XPS_TTC0_1_INT_ID		(44U + 32U)
#define XPS_TTC0_2_INT_ID 		(45U + 32U)
#define XPS_TTC1_0_INT_ID		(46U + 32U)
#define XPS_TTC1_1_INT_ID		(47U + 32U)
#define XPS_TTC1_2_INT_ID		(48U + 32U)
#define XPS_TTC2_0_INT_ID		(49U + 32U)
#define XPS_TTC2_1_INT_ID		(50U + 32U)
#define XPS_TTC2_2_INT_ID		(51U + 32U)
#define XPS_TTC3_0_INT_ID		(52U + 32U)
#define XPS_TTC3_1_INT_ID		(53U + 32U)
#define XPS_TTC3_2_INT_ID		(54U + 32U)
#define XPS_ADMA_CH0_INT_ID		(72U + 32U)
#define XPS_ADMA_CH1_INT_ID		(73U + 32U)
#define XPS_ADMA_CH2_INT_ID		(74U + 32U)
#define XPS_ADMA_CH3_INT_ID		(75U + 32U)
#define XPS_ADMA_CH4_INT_ID		(76U + 32U)
#define XPS_ADMA_CH5_INT_ID		(77U + 32U)
#define XPS_ADMA_CH6_INT_ID		(78U + 32U)
#define XPS_ADMA_CH7_INT_ID		(79U + 32U)
//#define XPS_XMPU_LPD_INT_ID		(68U + 32U)
#define XPS_USB3_0_WAKE_INT_ID		(98U + 32U)
//#define XPS_XMPU_FPD_INT_ID		(102U + 32U)
//#define XPS_FPD_CCI_INT_ID		(106U + 32U)
//#define XPS_FPD_SMMU_INT_ID		(107U + 32U)
#define XPMC_GPIO_INT_ID		(180U + 32U)
#define XPMC_I2C_INT_ID		(181U + 32U)
#define XPS_OSPI_INT_ID			(182U + 32U)
#define XPS_QSPI_INT_ID			(183U + 32U)
#define XPS_SDIO0_INT_ID		(184U + 32U)
#define XPS_SDIO0_WAKE_INT_ID		(185U + 32U)
#define XPS_SDIO1_INT_ID		(186U + 32U)
#define XPS_SDIO1_WAKE_INT_ID		(187U + 32U)
#define XPS_PMCDMA0_INT_ID		(190U + 32U)
#define XPS_PMCDMA1_INT_ID		(191U + 32U)
#define XPS_RTC_ALARM_INT_ID		(200U + 32U)
#define XPS_RTC_SEC_INT_ID		(201U + 32U)
#define XPS_LPD_GWDT_0_INT_ID		(86U + 32U)
#define XPS_LPD_GWDT_0_RST_INT_ID	(87U + 32U)
#define XPS_LPD_WWDT_0_INT_ID		(82U + 32U)
#define XPS_LPD_WWDT_0_RST_PEND_INT_ID	(84U + 32U)
#define XPS_LPD_GWDT_1_INT_ID		(88U + 32U)
#define XPS_LPD_GWDT_1_RST_INT_ID	(89U + 32U)
#define XPS_LPD_WWDT_1_INT_ID		(83U + 32U)
#define XPS_LPD_WWDT_1_RST_PEND_INT_ID	(85U + 32U)
#define XPS_FPD_GWDT_2_INT_ID		(141U + 32U)
#define XPS_FPD_GWDT_2_RST_INT_ID	(142U + 32U)
#define XPS_FPD_WWDT_2_INT_ID		(139U + 32U)
#define XPS_FPD_WWDT_2_RST_PEND_INT_ID	(140U + 32U)
#define XPS_FPD_GWDT_3_INT_ID		(145U + 32U)
#define XPS_FPD_GWDT_3_RST_INT_ID	(146U + 32U)
#define XPS_FPD_WWDT_3_INT_ID		(143U + 32U)
#define XPS_FPD_WWDT_3_RST_PEND_INT_ID	(144U + 32U)
#define XPS_FPD_GWDT_4_INT_ID		(149U + 32U)
#define XPS_FPD_GWDT_4_RST_INT_ID	(150U + 32U)
#define XPS_FPD_WWDT_4_INT_ID		(147U + 32U)
#define XPS_FPD_WWDT_4_RST_PEND_INT_ID	(148U + 32U)
#define XPS_FPD_GWDT_5_INT_ID		(166U + 32U)
#define XPS_FPD_GWDT_5_RST_INT_ID	(167U + 32U)
#define XPS_FPD_WWDT_5_INT_ID		(164U + 32U)
#define XPS_FPD_WWDT_5_RST_PEND_INT_ID	(165U + 32U)
#define XPS_PMC_GWDT_6_INT_ID		(219U + 32U)
#define XPS_PMC_GWDT_6_RST_INT_ID	(220U + 32U)
#define XPS_PMC_WWDT_6_INT_ID		(217U + 32U)
#define XPS_PMC_WWDT_6_RST_PEND_INT_ID	(218U + 32U)

/* REDEFINES for TEST APP */
#define XPAR_PSXL_SBSAUART_0_INTR        XPS_UART0_INT_ID
#define XPAR_PSXL_SBSAUART_1_INTR        XPS_UART1_INT_ID
#define XPAR_PSXL_USB_0_INTR		XPS_USB0_INT_ID
#define XPAR_PSXL_USB_1_INTR		XPS_USB1_INT_ID
#define XPAR_PSXL_I2C_0_INTR		XPS_I2C0_INT_ID
#define XPAR_PSXL_I2C_1_INTR		XPS_I2C1_INT_ID
#define XPAR_PSXL_SPI_0_INTR		XPS_SPI0_INT_ID
#define XPAR_PSXL_SPI_1_INTR		XPS_SPI1_INT_ID
#define XPAR_PSXL_CANFD_0_INTR		XPS_CAN0_INT_ID
#define XPAR_PSXL_CANFD_1_INTR		XPS_CAN1_INT_ID
#define XPAR_PSXL_GWDT_0_INTR		XPS_LPD_GWDT_0_INT_ID
#define XPAR_PSXL_GWDT_0_RST_INTR	XPS_LPD_GWDT_0_RST_INT_ID
#define XPAR_PSXL_WWDT_0_INTR		XPS_LPD_WWDT_0_INT_ID
#define XPAR_PSXL_WWDT_0_RST_PEND_INTR	XPS_LPD_WWDT_0_RST_PEND_INT_ID
#define XPAR_PSXL_GWDT_1_INTR		XPS_FPD_GWDT_1_INT_ID
#define XPAR_PSXL_GWDT_1_RST_INTR	XPS_FPD_GWDT_1_RST_INT_ID
#define XPAR_PSXL_WWDT_1_INTR		XPS_FPD_WWDT_1_INT_ID
#define XPAR_PSXL_WWDT_1_RST_PEND_INTR	XPS_FPD_WWDT_1_RST_PEND_INT_ID
#define XPAR_PSXL_GPIO_0_INTR		XPS_GPIO_INT_ID
#define XPAR_PSXL_ETHERNET_0_INTR	XPS_GEM0_INT_ID
#define XPAR_PSXL_ETHERNET_0_WAKE_INTR   XPS_GEM0_WAKE_INT_ID
#define XPAR_PSXL_ETHERNET_1_INTR	XPS_GEM1_INT_ID
#define XPAR_PSXL_ETHERNET_1_WAKE_INTR   XPS_GEM1_WAKE_INT_ID
#define XPAR_PSXL_ETHERNET_2_INTR	XPS_GEM2_INT_ID
#define XPAR_PSXL_ETHERNET_2_WAKE_INTR   XPS_GEM2_WAKE_INT_ID
#define XPAR_PSXL_ETHERNET_3_INTR	XPS_GEM3_INT_ID
#define XPAR_PSXL_ETHERNET_3_WAKE_INTR   XPS_GEM3_WAKE_INT_ID
#define XPAR_PSXL_QSPI_0_INTR		XPS_QSPI_INT_ID
//#define XPAR_PSV_XADC_0_INTR		XPS_SYSMON_INT_ID
#define XPAR_PSXL_TTC_0_INTR		XPS_TTC0_0_INT_ID
#define XPAR_PSXL_TTC_1_INTR		XPS_TTC0_1_INT_ID
#define XPAR_PSXL_TTC_2_INTR		XPS_TTC0_2_INT_ID
#define XPAR_PSXL_TTC_3_INTR		XPS_TTC1_0_INT_ID
#define XPAR_PSXL_TTC_4_INTR		XPS_TTC1_1_INT_ID
#define XPAR_PSXL_TTC_5_INTR		XPS_TTC1_2_INT_ID
#define XPAR_PSXL_TTC_6_INTR		XPS_TTC2_0_INT_ID
#define XPAR_PSXL_TTC_7_INTR		XPS_TTC2_1_INT_ID
#define XPAR_PSXL_TTC_8_INTR		XPS_TTC2_2_INT_ID
#define XPAR_PSXL_TTC_9_INTR		XPS_TTC3_0_INT_ID
#define XPAR_PSXL_TTC_10_INTR		XPS_TTC3_1_INT_ID
#define XPAR_PSXL_TTC_11_INTR		XPS_TTC3_2_INT_ID
//#define XPAR_PSV_AMS_INTR		XPS_AMS_INT_ID

#define XPAR_PSX_SBSAUART_0_INTR        XPS_UART0_INT_ID
#define XPAR_PSX_SBSAUART_1_INTR        XPS_UART1_INT_ID
#define XPAR_PSX_USB_0_INTR		XPS_USB0_INT_ID
#define XPAR_PSX_USB_1_INTR		XPS_USB1_INT_ID
#define XPAR_PSX_I2C_0_INTR		XPS_I2C0_INT_ID
#define XPAR_PSX_I2C_1_INTR		XPS_I2C1_INT_ID
#define XPAR_PSX_SPI_0_INTR		XPS_SPI0_INT_ID
#define XPAR_PSX_SPI_1_INTR		XPS_SPI1_INT_ID
#define XPAR_PSX_CANFD_0_INTR		XPS_CAN0_INT_ID
#define XPAR_PSX_CANFD_1_INTR		XPS_CAN1_INT_ID
#define XPAR_PSX_GWDT_0_INTR		XPS_LPD_GWDT_0_INT_ID
#define XPAR_PSX_GWDT_0_RST_INTR	XPS_LPD_GWDT_0_RST_INT_ID
#define XPAR_PSX_WWDT_0_INTR		XPS_LPD_WWDT_0_INT_ID
#define XPAR_PSX_WWDT_0_RST_PEND_INTR	XPS_LPD_WWDT_0_RST_PEND_INT_ID
#define XPAR_PSX_GWDT_1_INTR		XPS_FPD_GWDT_1_INT_ID
#define XPAR_PSX_GWDT_1_RST_INTR	XPS_FPD_GWDT_1_RST_INT_ID
#define XPAR_PSX_WWDT_1_INTR		XPS_FPD_WWDT_1_INT_ID
#define XPAR_PSX_WWDT_1_RST_PEND_INTR	XPS_FPD_WWDT_1_RST_PEND_INT_ID
#define XPAR_PSX_GPIO_0_INTR		XPS_GPIO_INT_ID
#define XPAR_PSX_ETHERNET_0_INTR	XPS_GEM0_INT_ID
#define XPAR_PSX_ETHERNET_0_WAKE_INTR   XPS_GEM0_WAKE_INT_ID
#define XPAR_PSX_ETHERNET_1_INTR	XPS_GEM1_INT_ID
#define XPAR_PSX_ETHERNET_1_WAKE_INTR   XPS_GEM1_WAKE_INT_ID
#define XPAR_PSX_ETHERNET_2_INTR	XPS_GEM2_INT_ID
#define XPAR_PSX_ETHERNET_2_WAKE_INTR   XPS_GEM2_WAKE_INT_ID
#define XPAR_PSX_ETHERNET_3_INTR	XPS_GEM3_INT_ID
#define XPAR_PSX_ETHERNET_3_WAKE_INTR   XPS_GEM3_WAKE_INT_ID
#define XPAR_PSX_QSPI_0_INTR		XPS_QSPI_INT_ID
#define XPAR_PSX_TTC_0_INTR		XPS_TTC0_0_INT_ID
#define XPAR_PSX_TTC_1_INTR		XPS_TTC0_1_INT_ID
#define XPAR_PSX_TTC_2_INTR		XPS_TTC0_2_INT_ID
#define XPAR_PSX_TTC_3_INTR		XPS_TTC1_0_INT_ID
#define XPAR_PSX_TTC_4_INTR		XPS_TTC1_1_INT_ID
#define XPAR_PSX_TTC_5_INTR		XPS_TTC1_2_INT_ID
#define XPAR_PSX_TTC_6_INTR		XPS_TTC2_0_INT_ID
#define XPAR_PSX_TTC_7_INTR		XPS_TTC2_1_INT_ID
#define XPAR_PSX_TTC_8_INTR		XPS_TTC2_2_INT_ID
#define XPAR_PSX_TTC_9_INTR		XPS_TTC3_0_INT_ID
#define XPAR_PSX_TTC_10_INTR		XPS_TTC3_1_INT_ID
#define XPAR_PSX_TTC_11_INTR		XPS_TTC3_2_INT_ID
#define XPAR_XRTCPSU_ALARM_INTR		XPS_RTC_ALARM_INT_ID
#define XPAR_XRTCPSU_SECONDS_INTR	XPS_RTC_SEC_INT_ID

/*
#define XPAR_XADCPS_NUM_INSTANCES 1U
#define XPAR_XADCPS_0_DEVICE_ID   0U
#define XPAR_XADCPS_0_BASEADDR	  (0xF8007000U)
#define XPAR_XADCPS_INT_ID		XPS_SYSMON_INT_ID
*/

/* For backwards compatibility */
#define XPAR_XUARTPS_0_CLOCK_HZ		XPAR_XUARTPS_0_UART_CLK_FREQ_HZ
#define XPAR_XUARTPS_1_CLOCK_HZ		XPAR_XUARTPS_1_UART_CLK_FREQ_HZ
#define XPAR_XTTCPS_0_CLOCK_HZ		XPAR_XTTCPS_0_TTC_CLK_FREQ_HZ
#define XPAR_XTTCPS_1_CLOCK_HZ		XPAR_XTTCPS_1_TTC_CLK_FREQ_HZ
#define XPAR_XTTCPS_2_CLOCK_HZ		XPAR_XTTCPS_2_TTC_CLK_FREQ_HZ
#define XPAR_XTTCPS_3_CLOCK_HZ		XPAR_XTTCPS_3_TTC_CLK_FREQ_HZ
#define XPAR_XTTCPS_4_CLOCK_HZ		XPAR_XTTCPS_4_TTC_CLK_FREQ_HZ
#define XPAR_XTTCPS_5_CLOCK_HZ		XPAR_XTTCPS_5_TTC_CLK_FREQ_HZ
#define XPAR_XIICPS_0_CLOCK_HZ		XPAR_XIICPS_0_I2C_CLK_FREQ_HZ
#define XPAR_XIICPS_1_CLOCK_HZ		XPAR_XIICPS_1_I2C_CLK_FREQ_HZ

#define XPAR_XQSPIPS_0_CLOCK_HZ		XPAR_XQSPIPS_0_QSPI_CLK_FREQ_HZ

/*
 * Defines for interrupt wrapper API
 * For more details about usage please refer xinterrupt_wrap.h
 * Here Bits[11:0] represents interrupt id
 * Bits[15:12] represents interrupt trigger type and level flags
 */
#define XPAR_PSXL_USB_0_INTERRUPT_ID        0x401DU
#define XPAR_PSXL_USB_1_INTERRUPT_ID        0x4022U
#define XPAR_PSXL_TTC_0_INTERRUPT_ID        0x402BU
#define XPAR_PSXL_TTC_1_INTERRUPT_ID        0x402CU
#define XPAR_PSXL_TTC_2_INTERRUPT_ID        0x402DU
#define XPAR_PSXL_TTC_3_INTERRUPT_ID        0x402EU
#define XPAR_PSXL_TTC_4_INTERRUPT_ID        0x402FU
#define XPAR_PSXL_TTC_5_INTERRUPT_ID        0x4030U
#define XPAR_PSXL_TTC_6_INTERRUPT_ID        0x4031U
#define XPAR_PSXL_TTC_7_INTERRUPT_ID        0x4032U
#define XPAR_PSXL_TTC_8_INTERRUPT_ID        0x4033U
#define XPAR_PSXL_TTC_9_INTERRUPT_ID        0x4034U
#define XPAR_PSXL_TTC_10_INTERRUPT_ID       0x4035U
#define XPAR_PSXL_TTC_11_INTERRUPT_ID       0x4036U

#define XPAR_PSX_TTC_0_INTERRUPT_ID        0x402BU
#define XPAR_PSX_TTC_1_INTERRUPT_ID        0x402CU
#define XPAR_PSX_TTC_2_INTERRUPT_ID        0x402DU
#define XPAR_PSX_TTC_3_INTERRUPT_ID        0x402EU
#define XPAR_PSX_TTC_4_INTERRUPT_ID        0x402FU
#define XPAR_PSX_TTC_5_INTERRUPT_ID        0x4030U
#define XPAR_PSX_TTC_6_INTERRUPT_ID        0x4031U
#define XPAR_PSX_TTC_7_INTERRUPT_ID        0x4032U
#define XPAR_PSX_TTC_8_INTERRUPT_ID        0x4033U
#define XPAR_PSX_TTC_9_INTERRUPT_ID        0x4034U
#define XPAR_PSX_TTC_10_INTERRUPT_ID       0x4035U
#define XPAR_PSX_TTC_11_INTERRUPT_ID       0x4036U

#ifdef __cplusplus
}
#endif

/**
 *@endcond
 */

#endif /* protection macro */
