# Copyright (C) 2023-2025 Advanced Micro Devices, Inc.  All rights reserved.
# SPDX-License-Identifier: MIT
set( CMAKE_TRY_COMPILE_TARGET_TYPE "STATIC_LIBRARY" )
set( CMAKE_EXPORT_COMPILE_COMMANDS ON)
set( CMAKE_TRY_COMPILE_PLATFORM_VARIABLES CMAKE_LIBRARY_PATH)
set( CMAKE_INSTALL_MESSAGE LAZY)
set( CMAKE_C_COMPILER riscv64-unknown-elf-gcc )
set( CMAKE_CXX_COMPILER riscv64-unknown-elf-g++ )
set( CMAKE_C_COMPILER_LAUNCHER  )
set( CMAKE_CXX_COMPILER_LAUNCHER  )
set( CMAKE_ASM_COMPILER riscv64-unknown-elf-gcc )
set( CMAKE_AR riscv64-unknown-elf-ar CACHE FILEPATH "Archiver" )
set( CMAKE_SIZE mb-size CACHE FILEPATH "Size" )
set( CMAKE_SYSTEM_PROCESSOR "microblaze_riscv" )
set( CMAKE_SYSTEM_NAME "Generic" )
set( CMAKE_HW_FLAGS "" )
set( CMAKE_BSP_HW_LINK_FLAGS "" )
set( CMAKE_COMPILER_LIB_PATH "" )
set( CMAKE_SPECS_FILE "$ENV{ESW_REPO}/scripts/specs/microblaze/Xilinx.spec" CACHE STRING "Specs file path for using CMAKE toolchain files" )
set( TOOLCHAIN_C_FLAGS "  ${CMAKE_HW_FLAGS} -DSDT" CACHE STRING "CFLAGS" )
set( TOOLCHAIN_CXX_FLAGS "  ${CMAKE_HW_FLAGS} -DSDT" CACHE STRING "CXXFLAGS" )
set( TOOLCHAIN_ASM_FLAGS "  ${CMAKE_HW_FLAGS} -DSDT" CACHE STRING "ASM FLAGS" )
set( TOOLCHAIN_DEP_FLAGS " -MMD -MP" CACHE STRING "Flags used by compiler to generate dependency files")
set( TOOLCHAIN_EXTRA_C_FLAGS " -O2 -g -ffunction-sections -fdata-sections -Wall -Wextra -fno-tree-loop-distribute-patterns" CACHE STRING "Extra CFLAGS")
set( APPLICATION_SPECIFIC_FLAGS ""  CACHE STRING "Extra Application specific Flags")
set( CMAKE_C_LINK_FLAGS " -Wl,--gc-sections ${CMAKE_BSP_HW_LINK_FLAGS}" CACHE STRING "LDFLAGS")
set( CMAKE_CXX_LINK_FLAGS " -Wl,--gc-sections ${CMAKE_BSP_HW_LINK_FLAGS}" CACHE STRING "LDFLAGS")
set( CMAKE_C_FLAGS_RELEASE "-DNDEBUG" CACHE STRING "Additional CFLAGS for release" )
set( CMAKE_CXX_FLAGS_RELEASE "-DNDEBUG" CACHE STRING "Additional CXXFLAGS for release" )
set( CMAKE_ASM_FLAGS_RELEASE "-DNDEBUG" CACHE STRING "Additional ASM FLAGS for release" )
set( CMAKE_C_FLAGS "${TOOLCHAIN_C_FLAGS} ${TOOLCHAIN_DEP_FLAGS} ${APPLICATION_SPECIFIC_FLAGS} -specs=${CMAKE_SPECS_FILE} -I${CMAKE_INCLUDE_PATH}" CACHE STRING "CFLAGS")
set( CMAKE_CXX_FLAGS "${TOOLCHAIN_CXX_FLAGS} ${TOOLCHAIN_DEP_FLAGS} ${APPLICATION_SPECIFIC_FLAGS} -specs=${CMAKE_SPECS_FILE} -I${CMAKE_INCLUDE_PATH}" CACHE STRING "CXXFLAGS")
set( CMAKE_ASM_FLAGS "${TOOLCHAIN_ASM_FLAGS} ${TOOLCHAIN_DEP_FLAGS} ${APPLICATION_SPECIFIC_FLAGS} -specs=${CMAKE_SPECS_FILE} -I${CMAKE_INCLUDE_PATH}" CACHE STRING "ASMFLAGS")
set(CMAKE_EXE_LINKER_FLAGS "" CACHE STRING "Linker flags")
set(CMAKE_MODULE_LINKER_FLAGS "" CACHE STRING "Module Linker flags")
set(CMAKE_SHARED_LINKER_FLAGS "" CACHE STRING "Shared Linker flags")
