/******************************************************************************
* Copyright 2024 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************/
/**
*
* @file xdsi2rx_sinit.c
* @addtogroup dsi Overview
* @{
*
* Look up the hardware settings using Base Address. The hardware setting is inside
* the configuration table in xdsi2rx_g.c, generated by yaml and DT or
* manually by the user.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver  Who   Date     Changes
* ---- ----  -------- -------------------------------------------------------
* 1.0  Kunal 18/04/24 First release
* </pre>
*
******************************************************************************/

/***************************** Include Files *********************************/
#include "xparameters.h"
#include "xdsi2rx.h"

/************************** Function Definitions ******************************/

/*****************************************************************************/
/**
 * Look up the hardware configuration for a device instance
 *
 * @param	BaseAddress is the unique device ID of the device to lookup for
 *
 * @return	The reference to the configuration record in the configuration
 * 		table (in xdsi2rx_g.c) corresponding to the BaseAddress or if
 *		not found, a NULL pointer is returned.
 *
 * @note	None
 *
 *****************************************************************************/
XDsi2Rx_Config *XDsi2Rx_LookupConfig(UINTPTR BaseAddress)
{
	extern XDsi2Rx_Config XDsi2Rx_ConfigTable[];
	XDsi2Rx_Config *CfgPtr = NULL;
	u32 Index;

	for (Index = 0; XDsi2Rx_ConfigTable[Index].Name != NULL; Index++) {
		if ((XDsi2Rx_ConfigTable[Index].BaseAddr == BaseAddress) || !BaseAddress) {
			CfgPtr = &XDsi2Rx_ConfigTable[Index];
			break;
		}
	}

	return CfgPtr;
}
/** @} */
