/******************************************************************************
* Copyright (C) 2021-2022 Xilinx, Inc. All rights reserved.
* Copyright (C) 2022-2023 Advanced Micro Devices, Inc. All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************/
/**
*
* @file xdfeprach_hw.h
* @addtogroup dfeprach Overview
* @{
* @cond nocomments
* Contains the register definitions for xdfeprach. This is
* created to be used initially while waiting for IP.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who    Date     Changes
* ----- ---    -------- -----------------------------------------------
* 1.0   dc     03/08/21 Initial version
*       dc     04/21/21 Update due to restructured registers
*       dc     05/08/21 Update to common trigger
*       dc     05/18/21 Handling RachUpdate trigger
* 1.1   dc     06/30/21 Doxygen documentation update
*       dc     07/13/21 Update to common latency requirements
* 1.2   dc     10/29/21 Update doxygen comments
*       dc     11/01/21 Add multi AddCC, RemoveCC and UpdateCC
* 1.3   dc     01/31/22 Add CORE_SETTINGS register
* 1.4   dc     08/18/22 Update register fields
* 1.5   dc     12/14/22 Update multiband register arithmetic
*       dc     01/02/23 Multiband registers update
* 1.6   dc     08/06/23 Support dynamic and static modes of operation
* 1.7   dc     11/29/23 Add continuous scheduling
*
* </pre>
*
******************************************************************************/
#ifndef XDFEPRACH_HW_H_
#define XDFEPRACH_HW_H_

#ifdef __cplusplus
extern "C" {
#endif

/**************************** Definitions *******************************/
/* CORE functionality */
#define XDFEPRACH_VERSION_OFFSET 0x00U /**< Register offset */
#define XDFEPRACH_VERSION_PATCH_WIDTH 8U
#define XDFEPRACH_VERSION_PATCH_OFFSET 0U
#define XDFEPRACH_VERSION_REVISION_WIDTH 8U
#define XDFEPRACH_VERSION_REVISION_OFFSET 8U
#define XDFEPRACH_VERSION_MINOR_WIDTH 8U
#define XDFEPRACH_VERSION_MINOR_OFFSET 16U
#define XDFEPRACH_VERSION_MAJOR_WIDTH 8U
#define XDFEPRACH_VERSION_MAJOR_OFFSET 24U

#define XDFEPRACH_RESET_OFFSET 0x04U /**< Register offset */
#define XDFEPRACH_RESET_OFF 0x00U
#define XDFEPRACH_RESET_ON 0x01U

#define XDFEPRACH_MODEL_PARAM_OFFSET 0x08U /**< Register offset */
#define XDFEPRACH_MODEL_PARAM_NUM_ANTENNA0_WIDTH 4U
#define XDFEPRACH_MODEL_PARAM_NUM_ANTENNA0_OFFSET 0U
#define XDFEPRACH_MODEL_PARAM_NUM_CC_PER_ANTENNA0_WIDTH 5U
#define XDFEPRACH_MODEL_PARAM_NUM_CC_PER_ANTENNA0_OFFSET 4U
#define XDFEPRACH_MODEL_PARAM_NUM_SLOT_CHANNELS0_WIDTH 3U
#define XDFEPRACH_MODEL_PARAM_NUM_SLOT_CHANNELS0_OFFSET 9U
#define XDFEPRACH_MODEL_PARAM_NUM_SLOTS0_WIDTH 4U
#define XDFEPRACH_MODEL_PARAM_NUM_SLOTS0_OFFSET 12U
#define XDFEPRACH_MODEL_PARAM_NUM_RACH_CHANNELS_WIDTH 5U
#define XDFEPRACH_MODEL_PARAM_NUM_RACH_CHANNELS_OFFSET 16U
#define XDFEPRACH_MODEL_PARAM_NUM_RACH_LANES_WIDTH 2U
#define XDFEPRACH_MODEL_PARAM_NUM_RACH_LANES_OFFSET 24U
#define XDFEPRACH_MODEL_PARAM_HAS_CONTINUOUS_SCHED_WIDTH 1U
#define XDFEPRACH_MODEL_PARAM_HAS_CONTINUOUS_SCHED_OFFSET 27U
#define XDFEPRACH_MODEL_PARAM_HAS_CONTINUOUS_SCHED_OFF 0U
#define XDFEPRACH_MODEL_PARAM_HAS_CONTINUOUS_SCHED_ON 1U
#define XDFEPRACH_MODEL_PARAM_HAS_AXIS_CTRL_WIDTH 1U
#define XDFEPRACH_MODEL_PARAM_HAS_AXIS_CTRL_OFFSET 28U
#define XDFEPRACH_MODEL_PARAM_HAS_AXIS_CTRL_OFF 0U
#define XDFEPRACH_MODEL_PARAM_HAS_AXIS_CTRL_ON 1U
#define XDFEPRACH_MODEL_PARAM_HAS_IRQ_WIDTH 1U
#define XDFEPRACH_MODEL_PARAM_HAS_IRQ_OFFSET 29U
#define XDFEPRACH_MODEL_PARAM_NUM_BANDS_WIDTH 2U
#define XDFEPRACH_MODEL_PARAM_NUM_BANDS_OFFSET 30U

#define XDFEPRACH_MODEL_PARAM1_OFFSET 0x0CU /**< Register offset */
#define XDFEPRACH_MODEL_PARAM1_NUM_ANTENNA1_WIDTH 4U
#define XDFEPRACH_MODEL_PARAM1_NUM_ANTENNA1_OFFSET 0U
#define XDFEPRACH_MODEL_PARAM1_NUM_CC_PER_ANTENNA1_WIDTH 5U
#define XDFEPRACH_MODEL_PARAM1_NUM_CC_PER_ANTENNA1_OFFSET 4U
#define XDFEPRACH_MODEL_PARAM1_NUM_SLOT_CHANNELS1_WIDTH 3U
#define XDFEPRACH_MODEL_PARAM1_NUM_SLOT_CHANNELS1_OFFSET 9U
#define XDFEPRACH_MODEL_PARAM1_NUM_SLOTS1_WIDTH 4U
#define XDFEPRACH_MODEL_PARAM1_NUM_SLOTS1_OFFSET 12U
#define XDFEPRACH_MODEL_PARAM1_NUM_ANTENNA2_WIDTH 4U
#define XDFEPRACH_MODEL_PARAM1_NUM_ANTENNA2_OFFSET 16U
#define XDFEPRACH_MODEL_PARAM1_NUM_CC_PER_ANTENNA2_WIDTH 5U
#define XDFEPRACH_MODEL_PARAM1_NUM_CC_PER_ANTENNA2_OFFSET 20U
#define XDFEPRACH_MODEL_PARAM1_NUM_SLOT_CHANNELS2_WIDTH 3U
#define XDFEPRACH_MODEL_PARAM1_NUM_SLOT_CHANNELS2_OFFSET 25U
#define XDFEPRACH_MODEL_PARAM1_NUM_SLOTS2_WIDTH 4U
#define XDFEPRACH_MODEL_PARAM1_NUM_SLOTS2_OFFSET 28U

#define XDFEPRACH_MODEL_PARAM_NUM_ANTENNA_MIN 1U
#define XDFEPRACH_MODEL_PARAM_NUM_ANTENNA_MAX 8U
#define XDFEPRACH_MODEL_PARAM1_NUM_CC_PER_ANTENNA_MIN 1U
#define XDFEPRACH_MODEL_PARAM1_NUM_CC_PER_ANTENNA_MAX 16U
#define XDFEPRACH_MODEL_PARAM1_NUM_SLOT_CHANNELS_MIN 1U
#define XDFEPRACH_MODEL_PARAM1_NUM_SLOT_CHANNELS_MAX 4U
#define XDFEPRACH_MODEL_PARAM1_NUM_SLOTS_MIN 1U
#define XDFEPRACH_MODEL_PARAM1_NUM_SLOTS_MAX 8U
#define XDFEPRACH_MODEL_PARAM_NUM_RACH_CHANNELS_MIN 1U
#define XDFEPRACH_MODEL_PARAM_NUM_RACH_CHANNELS_MAX 16U
#define XDFEPRACH_MODEL_PARAM_NUM_RACH_LANES_MIN 1U
#define XDFEPRACH_MODEL_PARAM_NUM_RACH_LANES_MAX 2U
#define XDFEPRACH_MODEL_PARAM_NUM_BANDS_MIN 1U
#define XDFEPRACH_MODEL_PARAM_NUM_BANDS_MAX 3U

/* State */
#define XDFEPRACH_STATE_OPERATIONAL_OFFSET 0x10U /**< Register offset */
#define XDFEPRACH_STATE_NOT_OPERATIONAL 0U
#define XDFEPRACH_STATE_IS_OPERATIONAL 1U
#define XDFEPRACH_STATE_LOW_POWER_OFFSET 0x14U /**< Register offset */

/* Triggers */
#define XDFEPRACH_TRIGGERS_ACTIVATE_OFFSET 0x20U /**< Register offset */
#define XDFEPRACH_TRIGGERS_LOW_POWER_OFFSET 0x24U /**< Register offset */
#define XDFEPRACH_TRIGGERS_RACH_UPDATE_OFFSET 0x2CU /**< Register offset */
#define XDFEPRACH_TRIGGERS_FRAME_INIT_OFFSET(BAND_ID)                          \
	(0x30U + (BAND_ID)*4) /**< Register offset */
/* Bit fields */
#define XDFEPRACH_TRIGGERS_TRIGGER_ENABLE_WIDTH 1U
#define XDFEPRACH_TRIGGERS_TRIGGER_ENABLE_OFFSET 0U
#define XDFEPRACH_TRIGGERS_TRIGGER_ENABLE_DISABLED 0U
#define XDFEPRACH_TRIGGERS_TRIGGER_ENABLE_ENABLED 1U
#define XDFEPRACH_TRIGGERS_MODE_WIDTH 2U
#define XDFEPRACH_TRIGGERS_MODE_OFFSET 4U
#define XDFEPRACH_TRIGGERS_MODE_IMMEDIATE 0U
#define XDFEPRACH_TRIGGERS_MODE_TUSER_SINGLE_SHOT 1U
#define XDFEPRACH_TRIGGERS_MODE_TUSER_CONTINUOUS 2U
#define XDFEPRACH_TRIGGERS_MODE_RESERVED 3U
#define XDFEPRACH_TRIGGERS_TUSER_EDGE_LEVEL_WIDTH 2U
#define XDFEPRACH_TRIGGERS_TUSER_EDGE_LEVEL_OFFSET 8U
#define XDFEPRACH_TRIGGERS_TUSER_EDGE_LEVEL_LOW 0U
#define XDFEPRACH_TRIGGERS_TUSER_EDGE_LEVEL_HIGH 1U
#define XDFEPRACH_TRIGGERS_TUSER_EDGE_LEVEL_FALING 2U
#define XDFEPRACH_TRIGGERS_TUSER_EDGE_LEVEL_RISING 3U
#define XDFEPRACH_TRIGGERS_STATE_OUTPUT_WIDTH 1U
#define XDFEPRACH_TRIGGERS_STATE_OUTPUT_OFFSET 12U
#define XDFEPRACH_TRIGGERS_STATE_OUTPUT_DISABLED 0U
#define XDFEPRACH_TRIGGERS_STATE_OUTPUT_ENABLED 1U
#define XDFEPRACH_TRIGGERS_TUSER_BIT_WIDTH 8U
#define XDFEPRACH_TRIGGERS_TUSER_BIT_OFFSET 16U

/* IRQ status */
#define XDFEPRACH_ISR 0x40U /**< Register offset */
#define XDFEPRACH_ISR_HAS_NOT_OCCURRED 0U
#define XDFEPRACH_ISR_OCCURRED 1U
#define XDFEPRACH_IER 0x44U /**< Register offset */
#define XDFEPRACH_IER_NO_CHANGE 0U
#define XDFEPRACH_IER_SET_BIT 1U
#define XDFEPRACH_IDR 0x48U /**< Register offset */
#define XDFEPRACH_IDR_NO_CHANGE 0U
#define XDFEPRACH_IDR_RESET_BIT 1U
#define XDFEPRACH_IMR 0x4CU /**< Register offset */
#define XDFEPRACH_IMR_INTERRUPT 0U
#define XDFEPRACH_IMR_NO_INTERRUPT 1U
#define XDFEPRACH_RACH_UPDATE_TRIGGERED_WIDTH 1U
#define XDFEPRACH_RACH_UPDATE_TRIGGERED_OFFSET 0U
#define XDFEPRACH_RACH_UPDATE_TRIGGERED_LOW 0U
#define XDFEPRACH_RACH_UPDATE_TRIGGERED_HIGH 1U
#define XDFEPRACH_FRAME_INIT_TRIGGERED_WIDTH 1U
#define XDFEPRACH_FRAME_INIT_TRIGGERED_OFFSET(BAND_ID) (1U + (BAND_ID))
#define XDFEPRACH_FRAME_INIT_TRIGGERED_LOW 0U
#define XDFEPRACH_FRAME_INIT_TRIGGERED_HIGH 1U
#define XDFEPRACH_FRAME_ERROR_WIDTH 1U
#define XDFEPRACH_FRAME_ERROR_OFFSET(BAND_ID) (4U + (BAND_ID))
#define XDFEPRACH_FRAME_ERROR_LOW 0U
#define XDFEPRACH_FRAME_ERROR_HIGH 1U
#define XDFEPRACH_CC_SEQUENCE_ERROR_WIDTH 1U
#define XDFEPRACH_CC_SEQUENCE_ERROR_OFFSET(BAND_ID) (7U + (BAND_ID))
#define XDFEPRACH_CC_SEQUENCE_ERROR_LOW 0U
#define XDFEPRACH_CC_SEQUENCE_ERROR_HIGH 1U
#define XDFEPRACH_DECIMATOR_OVERFLOW_WIDTH 1U
#define XDFEPRACH_DECIMATOR_OVERFLOW_OFFSET 10U
#define XDFEPRACH_MIXER_OVERFLOW_WIDTH 1U
#define XDFEPRACH_MIXER_OVERFLOW_OFFSET 11U
#define XDFEPRACH_DECIMATOR_OVERRUN_WIDTH 1U
#define XDFEPRACH_DECIMATOR_OVERRUN_OFFSET 12U
#define XDFEPRACH_SELECTOR_OVERRUN_WIDTH 1U
#define XDFEPRACH_SELECTOR_OVERRUN_OFFSET 13U
#define XDFEPRACH_IRQ_FLAGS_MASK 0x3FFFU

/* Latency */
#define XDFEPRACH_DELAY_OFFSET(BAND_ID)                                        \
	(0x80U + (BAND_ID)*8U) /**< Register offset */
#define XDFEPRACH_LATENCY_OFFSET(BAND_ID)                                      \
	(0x84U + (BAND_ID)*8U) /**< Register offset */
#define XDFEPRACH_DELAY_VALUE_WIDTH 12U
#define XDFEPRACH_DELAY_VALUE_OFFSET 0U
#define XDFEPRACH_LATENCY_VALUE_WIDTH 12U
#define XDFEPRACH_LATENCY_VALUE_OFFSET 0U

/* Core settings */
#define XDFEPRACH_CORE_SETTINGS 0x98U /**< Register offset */
#define XDFEPRACH_USE_FREQ_OFFSET_WIDTH 1U
#define XDFEPRACH_USE_FREQ_OFFSET_OFFSET 0U
#define XDFEPRACH_USE_FREQ_OFFSET_ENABLE 1U
#define XDFEPRACH_USE_FREQ_OFFSET_DISABLE 0U
#define XDFEPRACH_USE_FRAME_ID_WIDTH 1U
#define XDFEPRACH_USE_FRAME_ID_OFFSET 1U
#define XDFEPRACH_USE_FRAME_ID_ENABLE 1U
#define XDFEPRACH_USE_FRAME_ID_DISABLE 0U

/* RACH configuration */

/* CC sequence length */
#define XDFEPRACH_CC_SEQUENCE_LENGTH_CURRENT(BAND_ID)                          \
	(0x100U + (BAND_ID)*8U) /**< Register offset */
#define XDFEPRACH_CC_SEQUENCE_LENGTH_NEXT(BAND_ID)                             \
	(0x104U + (BAND_ID)*8U) /**< Register offset */
#define XDFEPRACH_CC_SEQUENCE_LENGTH_WIDTH 0x4U
#define XDFEPRACH_CC_SEQUENCE_LENGTH_OFFSET 0x0U

/* CC sequence */
#define XDFEPRACH_CC_SEQUENCE_CURRENT(BAND_ID, ITEM_ID)                        \
	(0x180U + (BAND_ID)*0x100U + (ITEM_ID << 2)) /**< Register offset */
#define XDFEPRACH_CC_SEQUENCE_NEXT(BAND_ID, ITEM_ID)                           \
	(0x1C0U + (BAND_ID)*0x100U + (ITEM_ID << 2)) /**< Register offset */
#define XDFEPRACH_CCID_WIDTH 0x4U
#define XDFEPRACH_CCID_OFFSET 0x0U

/* CC mapping */
#define XDFEPRACH_CC_MAPPING_CURRENT(BAND_ID, ITEM_ID)                         \
	(0x200U + (BAND_ID)*0x100U + (ITEM_ID << 2)) /**< Register offset */
#define XDFEPRACH_CC_MAPPING_NEXT(BAND_ID, ITEM_ID)                            \
	(0x240U + (BAND_ID)*0x100U + (ITEM_ID << 2)) /**< Register offset */
#define XDFEPRACH_CC_MAPPING_ENABLE_WIDTH 1U
#define XDFEPRACH_CC_MAPPING_ENABLE_OFFSET 0U
#define XDFEPRACH_CC_MAPPING_DISABLED 0U
#define XDFEPRACH_CC_MAPPING_ENABLED 1U
#define XDFEPRACH_CC_MAPPING_SCS_WIDTH 4U
#define XDFEPRACH_CC_MAPPING_SCS_OFFSET 8U
#define XDFEPRACH_CC_MAPPING_SCS_15KHZ 0U
#define XDFEPRACH_CC_MAPPING_SCS_30KHZ 1U
#define XDFEPRACH_CC_MAPPING_SCS_60KHZ 2U
#define XDFEPRACH_CC_MAPPING_SCS_120KHZ 3U
#define XDFEPRACH_CC_MAPPING_SCS_240KHZ 4U
#define XDFEPRACH_CC_MAPPING_DECIMATION_RATE_WIDTH 2U
#define XDFEPRACH_CC_MAPPING_DECIMATION_RATE_OFFSET 12U
#define XDFEPRACH_CC_MAPPING_DECIMATION_RATE_1X 0U
#define XDFEPRACH_CC_MAPPING_DECIMATION_RATE_2X 1U
#define XDFEPRACH_CC_MAPPING_DECIMATION_RATE_4X 2U
#define XDFEPRACH_CC_MAPPING_DECIMATION_RATE_8X 3U

/* RCID mapping */
/* RCID mapping channel */
#define XDFEPRACH_RCID_MAPPING_CHANNEL_CURRENT 0x480U /**< Register offset */
#define XDFEPRACH_RCID_MAPPING_CHANNEL_NEXT 0x4C0U /**< Register offset */
#define XDFEPRACH_RCID_MAPPING_CHANNEL_ENABLE_WIDTH 1U
#define XDFEPRACH_RCID_MAPPING_CHANNEL_ENABLE_OFFSET 0U
#define XDFEPRACH_RCID_MAPPING_CHANNEL_NOT_ENABLED 0U
#define XDFEPRACH_RCID_MAPPING_CHANNEL_ENABLED 1U
#define XDFEPRACH_RCID_MAPPING_CHANNEL_RACH_CHANNEL_WIDTH 4U
#define XDFEPRACH_RCID_MAPPING_CHANNEL_RACH_CHANNEL_OFFSET 8U

/* RCID mapping source */
#define XDFEPRACH_RCID_MAPPING_SOURCE_CURRENT 0x500U /**< Register offset */
#define XDFEPRACH_RCID_MAPPING_SOURCE_NEXT 0x540U /**< Register offset */
#define XDFEPRACH_RCID_MAPPING_SOURCE_CCID_WIDTH 4U
#define XDFEPRACH_RCID_MAPPING_SOURCE_CCID_OFFSET 0U
#define XDFEPRACH_RCID_MAPPING_SOURCE_BAND_WIDTH 2U
#define XDFEPRACH_RCID_MAPPING_SOURCE_BAND_OFFSET 4U

/* RCID schedule */
#define XDFEPRACH_RCID_SCHEDULE_STATIC_SCHEDULE 0x580U /**< Register offset */
#define XDFEPRACH_RCID_SCHEDULE_STATIC_SCHEDULE_OFF 0U
#define XDFEPRACH_RCID_SCHEDULE_STATIC_SCHEDULE_ON 1U
/* Location */
#define XDFEPRACH_RCID_SCHEDULE_LOCATION_CURRENT 0x600U /**< Register offset */
#define XDFEPRACH_RCID_SCHEDULE_LOCATION_NEXT 0x640U /**< Register offset */
#define XDFEPRACH_RCID_SCHEDULE_LOCATION_FRAMEID_WIDTH 8U
#define XDFEPRACH_RCID_SCHEDULE_LOCATION_FRAMEID_OFFSET 0U
#define XDFEPRACH_RCID_SCHEDULE_LOCATION_SUBFRAME_ID_WIDTH 4U
#define XDFEPRACH_RCID_SCHEDULE_LOCATION_SUBFRAME_ID_OFFSET 8U
#define XDFEPRACH_RCID_SCHEDULE_LOCATION_SLOT_ID_WIDTH 4U
#define XDFEPRACH_RCID_SCHEDULE_LOCATION_SLOT_ID_OFFSET 12U
#define XDFEPRACH_RCID_SCHEDULE_LOCATION_PATTERN_PERIOD_WIDTH 8U
#define XDFEPRACH_RCID_SCHEDULE_LOCATION_PATTERN_PERIOD_OFFSET 16U
/* Length */
#define XDFEPRACH_RCID_SCHEDULE_LENGTH_CURRENT 0x680U /**< Register offset */
#define XDFEPRACH_RCID_SCHEDULE_LENGTH_NEXT 0x6C0U /**< Register offset */
#define XDFEPRACH_RCID_SCHEDULE_LENGTH_DURATION_WIDTH 12U
#define XDFEPRACH_RCID_SCHEDULE_LENGTH_DURATION_OFFSET 0U
#define XDFEPRACH_RCID_SCHEDULE_LENGTH_NUM_REPEATS_WIDTH 8U
#define XDFEPRACH_RCID_SCHEDULE_LENGTH_NUM_REPEATS_OFFSET 16U

/* RACH mixer */
/* Captur Phase */
#define XDFEPRACH_RACH_MIXER_PHASE_CAPTURE 0x1010U /**< Register offset */
#define XDFEPRACH_RACH_MIXER_PHASE_CAPTURE_WIDTH 1U
#define XDFEPRACH_RACH_MIXER_PHASE_CAPTURE_OFFSET 0U

/* Status */
#define XDFEPRACH_STATUS_DECIMATOR_OVERFLOW 0x1000U /**< Register offset */
#define XDFEPRACH_STATUS_DECIMATOR_OVERRUN 0x1004U /**< Register offset */
#define XDFEPRACH_STATUS_MIXER_OVERFLOW 0x1008U /**< Register offset */
#define XDFEPRACH_STATUS_SELECTOR_OVERRUN 0x100CU /**< Register offset */
#define XDFEPRACH_STATUS_ANTENNA_WIDTH 4U
#define XDFEPRACH_STATUS_ANTENNA_OFFSET 0U
#define XDFEPRACH_STATUS_CHANNEL_WIDTH 4U
#define XDFEPRACH_STATUS_CHANNEL_OFFSET 4U

/* CONFIG_DECIMATOR */
#define XDFEPRACH_CONFIG_DEC_ADDR_STEP 0x10U
#define XDFEPRACH_CONFIG_DEC_NUM 16U
/* Configure decimation rate */
#define XDFEPRACH_DECIMATION_RATE 0x700U /**< Register offset */
#define XDFEPRACH_DECIMATION_RATE_WIDTH 4U
#define XDFEPRACH_DECIMATION_RATE_OFFSET 0U
#define XDFEPRACH_DECIMATION_RATE_2X 1U
#define XDFEPRACH_DECIMATION_RATE_4X 2U
#define XDFEPRACH_DECIMATION_RATE_8X 3U
#define XDFEPRACH_DECIMATION_RATE_16X 4U
#define XDFEPRACH_DECIMATION_RATE_32X 5U
#define XDFEPRACH_DECIMATION_RATE_3X 8U
#define XDFEPRACH_DECIMATION_RATE_6X 9U
#define XDFEPRACH_DECIMATION_RATE_12X 10U
#define XDFEPRACH_DECIMATION_RATE_24X 11U
#define XDFEPRACH_DECIMATION_RATE_48X 12U
#define XDFEPRACH_DECIMATION_RATE_96X 13U
/* Configure decimation gain */
#define XDFEPRACH_DECIMATION_GAIN 0x704U /**< Register offset */
#define XDFEPRACH_DECIMATION_GAIN0_WIDTH 1U
#define XDFEPRACH_DECIMATION_GAIN0_OFFSET 0U
#define XDFEPRACH_DECIMATION_GAIN1_WIDTH 1U
#define XDFEPRACH_DECIMATION_GAIN1_OFFSET 1U
#define XDFEPRACH_DECIMATION_GAIN2_WIDTH 1U
#define XDFEPRACH_DECIMATION_GAIN2_OFFSET 2U
#define XDFEPRACH_DECIMATION_GAIN3_WIDTH 1U
#define XDFEPRACH_DECIMATION_GAIN3_OFFSET 3U
#define XDFEPRACH_DECIMATION_GAIN4_WIDTH 1U
#define XDFEPRACH_DECIMATION_GAIN4_OFFSET 4U
#define XDFEPRACH_DECIMATION_GAIN5_WIDTH 2U
#define XDFEPRACH_DECIMATION_GAIN5_OFFSET 5U
#define XDFEPRACH_DECIMATION_GAIN_0DB 0U
#define XDFEPRACH_DECIMATION_GAIN_6DB 1U
#define XDFEPRACH_DECIMATION_GAIN_12DB 2U
#define XDFEPRACH_DECIMATION_GAIN_18DB 3U

/* NCO CTRL */
#define XDFEPRACH_NCO_CTRL_ADDR_STEP 0x2CU
#define XDFEPRACH_NCO_NUM 16U
/* Frequency */
#define XDFEPRACH_FREQUENCY_CONTROL_WORD 0x800U /**< Register offset */
#define XDFEPRACH_FREQUENCY_CONTROL_WORD_WIDTH 32U
#define XDFEPRACH_FREQUENCY_CONTROL_WORD_OFFSET 0U
#define XDFEPRACH_FREQUENCY_SINGLE_MOD_COUNT 0x804U /**< Register offset */
#define XDFEPRACH_FREQUENCY_SINGLE_MOD_COUNT_WIDTH 32U
#define XDFEPRACH_FREQUENCY_SINGLE_MOD_COUNT_OFFSET 0U
#define XDFEPRACH_FREQUENCY_DUAL_MOD_COUNT 0x808U /**< Register offset */
#define XDFEPRACH_FREQUENCY_DUAL_MOD_COUNT_WIDTH 32U
#define XDFEPRACH_FREQUENCY_DUAL_MOD_COUNT_OFFSET 0U
#define XDFEPRACH_FREQUENCY_PHASE_OFFSET 0x80CU /**< Register offset */
#define XDFEPRACH_FREQUENCY_PHASE_OFFSET_WIDTH 18U
#define XDFEPRACH_FREQUENCY_PHASE_OFFSET_OFFSET 0U

/* Phase */
#define XDFEPRACH_PHASE_PHASE_ACC 0x810U /**< Register offset */
#define XDFEPRACH_PHASE_PHASE_ACC_WIDTH 32U
#define XDFEPRACH_PHASE_PHASE_ACC_OFFSET 0U
#define XDFEPRACH_PHASE_DUAL_MOD_COUNT 0x814U /**< Register offset */
#define XDFEPRACH_PHASE_DUAL_MOD_COUNT_WIDTH 32U
#define XDFEPRACH_PHASE_DUAL_MOD_COUNT_OFFSET 0U
#define XDFEPRACH_PHASE_DUAL_MOD_SEL 0x818U /**< Register offset */
#define XDFEPRACH_PHASE_DUAL_MOD_SEL_WIDTH 1U
#define XDFEPRACH_PHASE_DUAL_MOD_SEL_OFFSET 0U

/* NCO gain */
#define XDFEPRACH_NCO_GAIN 0x81CU /**< Register offset */
#define XDFEPRACH_NCO_GAIN_WIDTH 2U
#define XDFEPRACH_NCO_GAIN_OFFSET 0U
#define XDFEPRACH_NCO_GAIN_ZERODB 0U
#define XDFEPRACH_NCO_GAIN_MINUS3DB 1U
#define XDFEPRACH_NCO_GAIN_MINUS6DB 2U
#define XDFEPRACH_NCO_GAIN_MINUS9DB 3U

/* Captured phase */
#define XDFEPRACH_CAPTURED_PHASE_PHASE_ACC 0x820U /**< Register offset */
#define XDFEPRACH_CAPTURED_PHASE_PHASE_ACC_WIDTH 32U
#define XDFEPRACH_CAPTURED_PHASE_PHASE_ACC_OFFSET 0U
#define XDFEPRACH_CAPTURED_PHASE_DUAL_MOD_COUNT 0x824U /**< Register offset */
#define XDFEPRACH_CAPTURED_PHASE_DUAL_MOD_COUNT_WIDTH 32U
#define XDFEPRACH_CAPTURED_PHASE_DUAL_MOD_COUNT_OFFSET 0U
#define XDFEPRACH_CAPTURED_PHASE_DUAL_MOD_SEL 0x828U /**< Register offset */
#define XDFEPRACH_CAPTURED_PHASE_DUAL_MOD_SEL_WIDTH 1U
#define XDFEPRACH_CAPTURED_PHASE_DUAL_MOD_SEL_OFFSET 0U

#ifdef __cplusplus
}
#endif

#endif
/**
* @endcond
*/
/** @} */
