/******************************************************************************
* Copyright (C) 2025 Advanced Micro Devices, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************/
/**
 *
 * @file xdcdma_hw.h
 *
 * This header file contains identifiers and low-level driver functions (or
 * macros) that can be used to access the device.
 *
 * @note	None.
 *
 * <pre>
 * MODIFICATION HISTORY:
 *
 * Ver	Who         Date     Changes
 * ---- -----       -------- ----------------------------------------------------
 * 1.0  akhilrag    10/10/23 Initial release.
 * </pre>
 *
 *****************************************************************************/

#ifndef __XDCDMA_HW_H__
/* Prevent circular inclusions by using protection macros. */
#define __XDCDMA_HW_H__

#ifdef __cplusplus
extern "C" {
#endif

/***************************** Include Files **********************************/

#include "xil_io.h"

/************************** Constant Definitions ******************************/

/******************************************************************************/
/**
 * Address mapping for DC_DMA.
 */
/******************************************************************************/
/** @name DC_DMA registers
 *  @{
 */

#define XDCDMA_BASEADDR         0xEDD10000U

/**
 * Register: XDCDMA_WPROTS
 */
#define XDCDMA_WPROTS       	0x0000

#define XDCDMA_WPROTS_ACTIVE_SHIFT	        0
#define XDCDMA_WPROTS_ACTIVE_WIDTH		    1
#define XDCDMA_WPROTS_ACTIVE_MASK		    0X1

/**
 * Register: XDCDMA_ERR_CTRL
 */
#define XDCDMA_ERR_CTRL         0x0010

#define XDCDMA_ERR_CTRL_APB_ERR_RES_SHIFT		0
#define XDCDMA_ERR_CTRL_APB_ERR_RES_WIDTH		1
#define XDCDMA_ERR_CTRL_APB_ERR_RES_MASK		0X1

/**
 * Register: XDCDMA_ISR
 */
#define XDCDMA_ISR              0x0050

#define XDCDMA_ISR_DSCR_ERR7_SHIFT			31
#define XDCDMA_ISR_DSCR_ERR7_WIDTH			1
#define XDCDMA_ISR_DSCR_ERR7_MASK			0X80000000

#define XDCDMA_ISR_DSCR_ERR6_SHIFT			30
#define XDCDMA_ISR_DSCR_ERR6_WIDTH			1
#define XDCDMA_ISR_DSCR_ERR6_MASK			0X40000000

#define XDCDMA_ISR_DSCR_ERR5_SHIFT			29
#define XDCDMA_ISR_DSCR_ERR5_WIDTH			1
#define XDCDMA_ISR_DSCR_ERR5_MASK			0X20000000

#define XDCDMA_ISR_DSCR_ERR4_SHIFT			28
#define XDCDMA_ISR_DSCR_ERR4_WIDTH			1
#define XDCDMA_ISR_DSCR_ERR4_MASK			0X10000000

#define XDCDMA_ISR_DSCR_ERR3_SHIFT			27
#define XDCDMA_ISR_DSCR_ERR3_WIDTH			1
#define XDCDMA_ISR_DSCR_ERR3_MASK			0X08000000

#define XDCDMA_ISR_DSCR_ERR2_SHIFT			26
#define XDCDMA_ISR_DSCR_ERR2_WIDTH			1
#define XDCDMA_ISR_DSCR_ERR2_MASK			0X04000000

#define XDCDMA_ISR_DSCR_ERR1_SHIFT			25
#define XDCDMA_ISR_DSCR_ERR1_WIDTH			1
#define XDCDMA_ISR_DSCR_ERR1_MASK			0X02000000

#define XDCDMA_ISR_DSCR_ERR0_SHIFT			24
#define XDCDMA_ISR_DSCR_ERR0_WIDTH			1
#define XDCDMA_ISR_DSCR_ERR0_MASK			0X01000000

#define XDCDMA_ISR_DATA_AXI_ERR7_SHIFT			23
#define XDCDMA_ISR_DATA_AXI_ERR7_WIDTH			1
#define XDCDMA_ISR_DATA_AXI_ERR7_MASK			0X00800000

#define XDCDMA_ISR_DATA_AXI_ERR6_SHIFT			22
#define XDCDMA_ISR_DATA_AXI_ERR6_WIDTH			1
#define XDCDMA_ISR_DATA_AXI_ERR6_MASK			0X00400000

#define XDCDMA_ISR_DATA_AXI_ERR5_SHIFT			21
#define XDCDMA_ISR_DATA_AXI_ERR5_WIDTH			1
#define XDCDMA_ISR_DATA_AXI_ERR5_MASK			0X00200000

#define XDCDMA_ISR_DATA_AXI_ERR4_SHIFT			20
#define XDCDMA_ISR_DATA_AXI_ERR4_WIDTH			1
#define XDCDMA_ISR_DATA_AXI_ERR4_MASK			0X00100000

#define XDCDMA_ISR_DATA_AXI_ERR3_SHIFT			19
#define XDCDMA_ISR_DATA_AXI_ERR3_WIDTH			1
#define XDCDMA_ISR_DATA_AXI_ERR3_MASK			0X00080000

#define XDCDMA_ISR_DATA_AXI_ERR2_SHIFT			18
#define XDCDMA_ISR_DATA_AXI_ERR2_WIDTH			1
#define XDCDMA_ISR_DATA_AXI_ERR2_MASK			0X00040000

#define XDCDMA_ISR_DATA_AXI_ERR1_SHIFT			17
#define XDCDMA_ISR_DATA_AXI_ERR1_WIDTH			1
#define XDCDMA_ISR_DATA_AXI_ERR1_MASK			0X00020000

#define XDCDMA_ISR_DATA_AXI_ERR0_SHIFT			16
#define XDCDMA_ISR_DATA_AXI_ERR0_WIDTH			1
#define XDCDMA_ISR_DATA_AXI_ERR0_MASK			0X00010000

#define XDCDMA_ISR_NO_OSTAND_TRAN7_SHIFT		15
#define XDCDMA_ISR_NO_OSTAND_TRAN7_WIDTH		1
#define XDCDMA_ISR_NO_OSTAND_TRAN7_MASK			0X00008000

#define XDCDMA_ISR_NO_OSTAND_TRAN6_SHIFT		14
#define XDCDMA_ISR_NO_OSTAND_TRAN6_WIDTH		1
#define XDCDMA_ISR_NO_OSTAND_TRAN6_MASK			0X00004000

#define XDCDMA_ISR_NO_OSTAND_TRAN5_SHIFT		13
#define XDCDMA_ISR_NO_OSTAND_TRAN5_WIDTH		1
#define XDCDMA_ISR_NO_OSTAND_TRAN5_MASK			0X00002000

#define XDCDMA_ISR_NO_OSTAND_TRAN4_SHIFT		12
#define XDCDMA_ISR_NO_OSTAND_TRAN4_WIDTH		1
#define XDCDMA_ISR_NO_OSTAND_TRAN4_MASK			0X00001000

#define XDCDMA_ISR_NO_OSTAND_TRAN3_SHIFT		11
#define XDCDMA_ISR_NO_OSTAND_TRAN3_WIDTH		1
#define XDCDMA_ISR_NO_OSTAND_TRAN3_MASK			0X00000800

#define XDCDMA_ISR_NO_OSTAND_TRAN2_SHIFT		10
#define XDCDMA_ISR_NO_OSTAND_TRAN2_WIDTH		1
#define XDCDMA_ISR_NO_OSTAND_TRAN2_MASK			0X00000400

#define XDCDMA_ISR_NO_OSTAND_TRAN1_SHIFT		9
#define XDCDMA_ISR_NO_OSTAND_TRAN1_WIDTH		1
#define XDCDMA_ISR_NO_OSTAND_TRAN1_MASK			0X00000200

#define XDCDMA_ISR_NO_OSTAND_TRAN0_SHIFT		8
#define XDCDMA_ISR_NO_OSTAND_TRAN0_WIDTH		1
#define XDCDMA_ISR_NO_OSTAND_TRAN0_MASK			0X00000100

#define XDCDMA_ISR_DSCR_DONE7_SHIFT			    7
#define XDCDMA_ISR_DSCR_DONE7_WIDTH			    1
#define XDCDMA_ISR_DSCR_DONE7_MASK			    0X00000080

#define XDCDMA_ISR_DSCR_DONE6_SHIFT			    6
#define XDCDMA_ISR_DSCR_DONE6_WIDTH			    1
#define XDCDMA_ISR_DSCR_DONE6_MASK			    0X00000040

#define XDCDMA_ISR_DSCR_DONE5_SHIFT			    5
#define XDCDMA_ISR_DSCR_DONE5_WIDTH			    1
#define XDCDMA_ISR_DSCR_DONE5_MASK			    0X00000020

#define XDCDMA_ISR_DSCR_DONE4_SHIFT			    4
#define XDCDMA_ISR_DSCR_DONE4_WIDTH			    1
#define XDCDMA_ISR_DSCR_DONE4_MASK			    0X00000010

#define XDCDMA_ISR_DSCR_DONE3_SHIFT			    3
#define XDCDMA_ISR_DSCR_DONE3_WIDTH			    1
#define XDCDMA_ISR_DSCR_DONE3_MASK			    0X00000008

#define XDCDMA_ISR_DSCR_DONE2_SHIFT			    2
#define XDCDMA_ISR_DSCR_DONE2_WIDTH			    1
#define XDCDMA_ISR_DSCR_DONE2_MASK			    0X00000004

#define XDCDMA_ISR_DSCR_DONE1_SHIFT			    1
#define XDCDMA_ISR_DSCR_DONE1_WIDTH			    1
#define XDCDMA_ISR_DSCR_DONE1_MASK			    0X00000002

#define XDCDMA_ISR_DSCR_DONE0_SHIFT			    0
#define XDCDMA_ISR_DSCR_DONE0_WIDTH			    1
#define XDCDMA_ISR_DSCR_DONE0_MASK			    0X00000001

/**
 * Register: XDCDMA_IMR
 */
#define XDCDMA_IMR              0x0054

#define XDCDMA_IMR_DSCR_ERR7_SHIFT			31
#define XDCDMA_IMR_DSCR_ERR7_WIDTH			1
#define XDCDMA_IMR_DSCR_ERR7_MASK			0X80000000

#define XDCDMA_IMR_DSCR_ERR6_SHIFT			30
#define XDCDMA_IMR_DSCR_ERR6_WIDTH			1
#define XDCDMA_IMR_DSCR_ERR6_MASK			0X40000000

#define XDCDMA_IMR_DSCR_ERR5_SHIFT			29
#define XDCDMA_IMR_DSCR_ERR5_WIDTH			1
#define XDCDMA_IMR_DSCR_ERR5_MASK			0X20000000

#define XDCDMA_IMR_DSCR_ERR4_SHIFT			28
#define XDCDMA_IMR_DSCR_ERR4_WIDTH			1
#define XDCDMA_IMR_DSCR_ERR4_MASK			0X10000000

#define XDCDMA_IMR_DSCR_ERR3_SHIFT			27
#define XDCDMA_IMR_DSCR_ERR3_WIDTH			1
#define XDCDMA_IMR_DSCR_ERR3_MASK			0X08000000

#define XDCDMA_IMR_DSCR_ERR2_SHIFT			26
#define XDCDMA_IMR_DSCR_ERR2_WIDTH			1
#define XDCDMA_IMR_DSCR_ERR2_MASK			0X04000000

#define XDCDMA_IMR_DSCR_ERR1_SHIFT			25
#define XDCDMA_IMR_DSCR_ERR1_WIDTH			1
#define XDCDMA_IMR_DSCR_ERR1_MASK			0X02000000

#define XDCDMA_IMR_DSCR_ERR0_SHIFT			24
#define XDCDMA_IMR_DSCR_ERR0_WIDTH			1
#define XDCDMA_IMR_DSCR_ERR0_MASK			0X01000000

#define XDCDMA_IMR_DATA_AXI_ERR7_SHIFT			23
#define XDCDMA_IMR_DATA_AXI_ERR7_WIDTH			1
#define XDCDMA_IMR_DATA_AXI_ERR7_MASK			0X00800000

#define XDCDMA_IMR_DATA_AXI_ERR6_SHIFT			22
#define XDCDMA_IMR_DATA_AXI_ERR6_WIDTH			1
#define XDCDMA_IMR_DATA_AXI_ERR6_MASK			0X00400000

#define XDCDMA_IMR_DATA_AXI_ERR5_SHIFT			21
#define XDCDMA_IMR_DATA_AXI_ERR5_WIDTH			1
#define XDCDMA_IMR_DATA_AXI_ERR5_MASK			0X00200000

#define XDCDMA_IMR_DATA_AXI_ERR4_SHIFT			20
#define XDCDMA_IMR_DATA_AXI_ERR4_WIDTH			1
#define XDCDMA_IMR_DATA_AXI_ERR4_MASK			0X00100000

#define XDCDMA_IMR_DATA_AXI_ERR3_SHIFT			19
#define XDCDMA_IMR_DATA_AXI_ERR3_WIDTH			1
#define XDCDMA_IMR_DATA_AXI_ERR3_MASK			0X00080000

#define XDCDMA_IMR_DATA_AXI_ERR2_SHIFT			18
#define XDCDMA_IMR_DATA_AXI_ERR2_WIDTH			1
#define XDCDMA_IMR_DATA_AXI_ERR2_MASK			0X00040000

#define XDCDMA_IMR_DATA_AXI_ERR1_SHIFT			17
#define XDCDMA_IMR_DATA_AXI_ERR1_WIDTH			1
#define XDCDMA_IMR_DATA_AXI_ERR1_MASK			0X00020000

#define XDCDMA_IMR_DATA_AXI_ERR0_SHIFT			16
#define XDCDMA_IMR_DATA_AXI_ERR0_WIDTH			1
#define XDCDMA_IMR_DATA_AXI_ERR0_MASK			0X00010000

#define XDCDMA_IMR_NO_OSTAND_TRAN7_SHIFT		15
#define XDCDMA_IMR_NO_OSTAND_TRAN7_WIDTH		1
#define XDCDMA_IMR_NO_OSTAND_TRAN7_MASK			0X00008000

#define XDCDMA_IMR_NO_OSTAND_TRAN6_SHIFT		14
#define XDCDMA_IMR_NO_OSTAND_TRAN6_WIDTH		1
#define XDCDMA_IMR_NO_OSTAND_TRAN6_MASK			0X00004000

#define XDCDMA_IMR_NO_OSTAND_TRAN5_SHIFT		13
#define XDCDMA_IMR_NO_OSTAND_TRAN5_WIDTH		1
#define XDCDMA_IMR_NO_OSTAND_TRAN5_MASK			0X00002000

#define XDCDMA_IMR_NO_OSTAND_TRAN4_SHIFT		12
#define XDCDMA_IMR_NO_OSTAND_TRAN4_WIDTH		1
#define XDCDMA_IMR_NO_OSTAND_TRAN4_MASK			0X00001000

#define XDCDMA_IMR_NO_OSTAND_TRAN3_SHIFT		11
#define XDCDMA_IMR_NO_OSTAND_TRAN3_WIDTH		1
#define XDCDMA_IMR_NO_OSTAND_TRAN3_MASK			0X00000800

#define XDCDMA_IMR_NO_OSTAND_TRAN2_SHIFT		10
#define XDCDMA_IMR_NO_OSTAND_TRAN2_WIDTH		1
#define XDCDMA_IMR_NO_OSTAND_TRAN2_MASK			0X00000400

#define XDCDMA_IMR_NO_OSTAND_TRAN1_SHIFT		9
#define XDCDMA_IMR_NO_OSTAND_TRAN1_WIDTH		1
#define XDCDMA_IMR_NO_OSTAND_TRAN1_MASK			0X00000200

#define XDCDMA_IMR_NO_OSTAND_TRAN0_SHIFT		8
#define XDCDMA_IMR_NO_OSTAND_TRAN0_WIDTH		1
#define XDCDMA_IMR_NO_OSTAND_TRAN0_MASK			0X00000100

#define XDCDMA_IMR_DSCR_DONE7_SHIFT			    7
#define XDCDMA_IMR_DSCR_DONE7_WIDTH			    1
#define XDCDMA_IMR_DSCR_DONE7_MASK			    0X00000080

#define XDCDMA_IMR_DSCR_DONE6_SHIFT			    6
#define XDCDMA_IMR_DSCR_DONE6_WIDTH			    1
#define XDCDMA_IMR_DSCR_DONE6_MASK			    0X00000040

#define XDCDMA_IMR_DSCR_DONE5_SHIFT			    5
#define XDCDMA_IMR_DSCR_DONE5_WIDTH			    1
#define XDCDMA_IMR_DSCR_DONE5_MASK			    0X00000020

#define XDCDMA_IMR_DSCR_DONE4_SHIFT			    4
#define XDCDMA_IMR_DSCR_DONE4_WIDTH			    1
#define XDCDMA_IMR_DSCR_DONE4_MASK			    0X00000010

#define XDCDMA_IMR_DSCR_DONE3_SHIFT			    3
#define XDCDMA_IMR_DSCR_DONE3_WIDTH			    1
#define XDCDMA_IMR_DSCR_DONE3_MASK			    0X00000008

#define XDCDMA_IMR_DSCR_DONE2_SHIFT			    2
#define XDCDMA_IMR_DSCR_DONE2_WIDTH			    1
#define XDCDMA_IMR_DSCR_DONE2_MASK			    0X00000004

#define XDCDMA_IMR_DSCR_DONE1_SHIFT			    1
#define XDCDMA_IMR_DSCR_DONE1_WIDTH			    1
#define XDCDMA_IMR_DSCR_DONE1_MASK			    0X00000002

#define XDCDMA_IMR_DSCR_DONE0_SHIFT			    0
#define XDCDMA_IMR_DSCR_DONE0_WIDTH			    1
#define XDCDMA_IMR_DSCR_DONE0_MASK			    0X00000001

/**
 * Register: XDCDMA_IER
 */
#define XDCDMA_IER              0x0058

#define XDCDMA_IER_DSCR_ERR7_SHIFT			31
#define XDCDMA_IER_DSCR_ERR7_WIDTH			1
#define XDCDMA_IER_DSCR_ERR7_MASK			0X80000000

#define XDCDMA_IER_DSCR_ERR6_SHIFT			30
#define XDCDMA_IER_DSCR_ERR6_WIDTH			1
#define XDCDMA_IER_DSCR_ERR6_MASK			0X40000000

#define XDCDMA_IER_DSCR_ERR5_SHIFT			29
#define XDCDMA_IER_DSCR_ERR5_WIDTH			1
#define XDCDMA_IER_DSCR_ERR5_MASK			0X20000000

#define XDCDMA_IER_DSCR_ERR4_SHIFT			28
#define XDCDMA_IER_DSCR_ERR4_WIDTH			1
#define XDCDMA_IER_DSCR_ERR4_MASK			0X10000000

#define XDCDMA_IER_DSCR_ERR3_SHIFT			27
#define XDCDMA_IER_DSCR_ERR3_WIDTH			1
#define XDCDMA_IER_DSCR_ERR3_MASK			0X08000000

#define XDCDMA_IER_DSCR_ERR2_SHIFT			26
#define XDCDMA_IER_DSCR_ERR2_WIDTH			1
#define XDCDMA_IER_DSCR_ERR2_MASK			0X04000000

#define XDCDMA_IER_DSCR_ERR1_SHIFT			25
#define XDCDMA_IER_DSCR_ERR1_WIDTH			1
#define XDCDMA_IER_DSCR_ERR1_MASK			0X02000000

#define XDCDMA_IER_DSCR_ERR0_SHIFT			24
#define XDCDMA_IER_DSCR_ERR0_WIDTH			1
#define XDCDMA_IER_DSCR_ERR0_MASK			0X01000000

#define XDCDMA_IER_DATA_AXI_ERR7_SHIFT			23
#define XDCDMA_IER_DATA_AXI_ERR7_WIDTH			1
#define XDCDMA_IER_DATA_AXI_ERR7_MASK			0X00800000

#define XDCDMA_IER_DATA_AXI_ERR6_SHIFT			22
#define XDCDMA_IER_DATA_AXI_ERR6_WIDTH			1
#define XDCDMA_IER_DATA_AXI_ERR6_MASK			0X00400000

#define XDCDMA_IER_DATA_AXI_ERR5_SHIFT			21
#define XDCDMA_IER_DATA_AXI_ERR5_WIDTH			1
#define XDCDMA_IER_DATA_AXI_ERR5_MASK			0X00200000

#define XDCDMA_IER_DATA_AXI_ERR4_SHIFT			20
#define XDCDMA_IER_DATA_AXI_ERR4_WIDTH			1
#define XDCDMA_IER_DATA_AXI_ERR4_MASK			0X00100000

#define XDCDMA_IER_DATA_AXI_ERR3_SHIFT			19
#define XDCDMA_IER_DATA_AXI_ERR3_WIDTH			1
#define XDCDMA_IER_DATA_AXI_ERR3_MASK			0X00080000

#define XDCDMA_IER_DATA_AXI_ERR2_SHIFT			18
#define XDCDMA_IER_DATA_AXI_ERR2_WIDTH			1
#define XDCDMA_IER_DATA_AXI_ERR2_MASK			0X00040000

#define XDCDMA_IER_DATA_AXI_ERR1_SHIFT			17
#define XDCDMA_IER_DATA_AXI_ERR1_WIDTH			1
#define XDCDMA_IER_DATA_AXI_ERR1_MASK			0X00020000

#define XDCDMA_IER_DATA_AXI_ERR0_SHIFT			16
#define XDCDMA_IER_DATA_AXI_ERR0_WIDTH			1
#define XDCDMA_IER_DATA_AXI_ERR0_MASK			0X00010000

#define XDCDMA_IER_NO_OSTAND_TRAN7_SHIFT		15
#define XDCDMA_IER_NO_OSTAND_TRAN7_WIDTH		1
#define XDCDMA_IER_NO_OSTAND_TRAN7_MASK			0X00008000

#define XDCDMA_IER_NO_OSTAND_TRAN6_SHIFT		14
#define XDCDMA_IER_NO_OSTAND_TRAN6_WIDTH		1
#define XDCDMA_IER_NO_OSTAND_TRAN6_MASK			0X00004000

#define XDCDMA_IER_NO_OSTAND_TRAN5_SHIFT		13
#define XDCDMA_IER_NO_OSTAND_TRAN5_WIDTH		1
#define XDCDMA_IER_NO_OSTAND_TRAN5_MASK			0X00002000

#define XDCDMA_IER_NO_OSTAND_TRAN4_SHIFT		12
#define XDCDMA_IER_NO_OSTAND_TRAN4_WIDTH		1
#define XDCDMA_IER_NO_OSTAND_TRAN4_MASK			0X00001000

#define XDCDMA_IER_NO_OSTAND_TRAN3_SHIFT		11
#define XDCDMA_IER_NO_OSTAND_TRAN3_WIDTH		1
#define XDCDMA_IER_NO_OSTAND_TRAN3_MASK			0X00000800

#define XDCDMA_IER_NO_OSTAND_TRAN2_SHIFT		10
#define XDCDMA_IER_NO_OSTAND_TRAN2_WIDTH		1
#define XDCDMA_IER_NO_OSTAND_TRAN2_MASK			0X00000400

#define XDCDMA_IER_NO_OSTAND_TRAN1_SHIFT		9
#define XDCDMA_IER_NO_OSTAND_TRAN1_WIDTH		1
#define XDCDMA_IER_NO_OSTAND_TRAN1_MASK			0X00000200

#define XDCDMA_IER_NO_OSTAND_TRAN0_SHIFT		8
#define XDCDMA_IER_NO_OSTAND_TRAN0_WIDTH		1
#define XDCDMA_IER_NO_OSTAND_TRAN0_MASK			0X00000100

#define XDCDMA_IER_DSCR_DONE7_SHIFT			    7
#define XDCDMA_IER_DSCR_DONE7_WIDTH			    1
#define XDCDMA_IER_DSCR_DONE7_MASK			    0X00000080

#define XDCDMA_IER_DSCR_DONE6_SHIFT			    6
#define XDCDMA_IER_DSCR_DONE6_WIDTH			    1
#define XDCDMA_IER_DSCR_DONE6_MASK			    0X00000040

#define XDCDMA_IER_DSCR_DONE5_SHIFT			    5
#define XDCDMA_IER_DSCR_DONE5_WIDTH			    1
#define XDCDMA_IER_DSCR_DONE5_MASK			    0X00000020

#define XDCDMA_IER_DSCR_DONE4_SHIFT			    4
#define XDCDMA_IER_DSCR_DONE4_WIDTH			    1
#define XDCDMA_IER_DSCR_DONE4_MASK			    0X00000010

#define XDCDMA_IER_DSCR_DONE3_SHIFT			    3
#define XDCDMA_IER_DSCR_DONE3_WIDTH			    1
#define XDCDMA_IER_DSCR_DONE3_MASK			    0X00000008

#define XDCDMA_IER_DSCR_DONE2_SHIFT			    2
#define XDCDMA_IER_DSCR_DONE2_WIDTH			    1
#define XDCDMA_IER_DSCR_DONE2_MASK			    0X00000004

#define XDCDMA_IER_DSCR_DONE1_SHIFT			    1
#define XDCDMA_IER_DSCR_DONE1_WIDTH			    1
#define XDCDMA_IER_DSCR_DONE1_MASK			    0X00000002

#define XDCDMA_IER_DSCR_DONE0_SHIFT			    0
#define XDCDMA_IER_DSCR_DONE0_WIDTH			    1
#define XDCDMA_IER_DSCR_DONE0_MASK			    0X00000001

/**
 * Register: XDCDMA_IDR
 */
#define XDCDMA_IDR              0x005C

#define XDCDMA_IDR_DSCR_ERR7_SHIFT			    31
#define XDCDMA_IDR_DSCR_ERR7_WIDTH			    1
#define XDCDMA_IDR_DSCR_ERR7_MASK			    0X80000000

#define XDCDMA_IDR_DSCR_ERR6_SHIFT			    30
#define XDCDMA_IDR_DSCR_ERR6_WIDTH			    1
#define XDCDMA_IDR_DSCR_ERR6_MASK			    0X40000000

#define XDCDMA_IDR_DSCR_ERR5_SHIFT			29
#define XDCDMA_IDR_DSCR_ERR5_WIDTH			1
#define XDCDMA_IDR_DSCR_ERR5_MASK			0X20000000

#define XDCDMA_IDR_DSCR_ERR4_SHIFT			28
#define XDCDMA_IDR_DSCR_ERR4_WIDTH			1
#define XDCDMA_IDR_DSCR_ERR4_MASK			0X10000000

#define XDCDMA_IDR_DSCR_ERR3_SHIFT			27
#define XDCDMA_IDR_DSCR_ERR3_WIDTH			1
#define XDCDMA_IDR_DSCR_ERR3_MASK			0X08000000

#define XDCDMA_IDR_DSCR_ERR2_SHIFT			26
#define XDCDMA_IDR_DSCR_ERR2_WIDTH			1
#define XDCDMA_IDR_DSCR_ERR2_MASK			0X04000000

#define XDCDMA_IDR_DSCR_ERR1_SHIFT			25
#define XDCDMA_IDR_DSCR_ERR1_WIDTH			1
#define XDCDMA_IDR_DSCR_ERR1_MASK			0X02000000

#define XDCDMA_IDR_DSCR_ERR0_SHIFT			24
#define XDCDMA_IDR_DSCR_ERR0_WIDTH			1
#define XDCDMA_IDR_DSCR_ERR0_MASK			0X01000000

#define XDCDMA_IDR_DATA_AXI_ERR7_SHIFT			23
#define XDCDMA_IDR_DATA_AXI_ERR7_WIDTH			1
#define XDCDMA_IDR_DATA_AXI_ERR7_MASK			0X00800000

#define XDCDMA_IDR_DATA_AXI_ERR6_SHIFT			22
#define XDCDMA_IDR_DATA_AXI_ERR6_WIDTH			1
#define XDCDMA_IDR_DATA_AXI_ERR6_MASK			0X00400000

#define XDCDMA_IDR_DATA_AXI_ERR5_SHIFT			21
#define XDCDMA_IDR_DATA_AXI_ERR5_WIDTH			1
#define XDCDMA_IDR_DATA_AXI_ERR5_MASK			0X00200000

#define XDCDMA_IDR_DATA_AXI_ERR4_SHIFT			20
#define XDCDMA_IDR_DATA_AXI_ERR4_WIDTH			1
#define XDCDMA_IDR_DATA_AXI_ERR4_MASK			0X00100000

#define XDCDMA_IDR_DATA_AXI_ERR3_SHIFT			19
#define XDCDMA_IDR_DATA_AXI_ERR3_WIDTH			1
#define XDCDMA_IDR_DATA_AXI_ERR3_MASK			0X00080000

#define XDCDMA_IDR_DATA_AXI_ERR2_SHIFT			18
#define XDCDMA_IDR_DATA_AXI_ERR2_WIDTH			1
#define XDCDMA_IDR_DATA_AXI_ERR2_MASK			0X00040000

#define XDCDMA_IDR_DATA_AXI_ERR1_SHIFT			17
#define XDCDMA_IDR_DATA_AXI_ERR1_WIDTH			1
#define XDCDMA_IDR_DATA_AXI_ERR1_MASK			0X00020000

#define XDCDMA_IDR_DATA_AXI_ERR0_SHIFT			16
#define XDCDMA_IDR_DATA_AXI_ERR0_WIDTH			1
#define XDCDMA_IDR_DATA_AXI_ERR0_MASK			0X00010000

#define XDCDMA_IDR_NO_OSTAND_TRAN7_SHIFT		15
#define XDCDMA_IDR_NO_OSTAND_TRAN7_WIDTH		1
#define XDCDMA_IDR_NO_OSTAND_TRAN7_MASK			0X00008000

#define XDCDMA_IDR_NO_OSTAND_TRAN6_SHIFT		14
#define XDCDMA_IDR_NO_OSTAND_TRAN6_WIDTH		1
#define XDCDMA_IDR_NO_OSTAND_TRAN6_MASK			0X00004000

#define XDCDMA_IDR_NO_OSTAND_TRAN5_SHIFT		13
#define XDCDMA_IDR_NO_OSTAND_TRAN5_WIDTH		1
#define XDCDMA_IDR_NO_OSTAND_TRAN5_MASK			0X00002000

#define XDCDMA_IDR_NO_OSTAND_TRAN4_SHIFT		12
#define XDCDMA_IDR_NO_OSTAND_TRAN4_WIDTH		1
#define XDCDMA_IDR_NO_OSTAND_TRAN4_MASK			0X00001000

#define XDCDMA_IDR_NO_OSTAND_TRAN3_SHIFT		11
#define XDCDMA_IDR_NO_OSTAND_TRAN3_WIDTH		1
#define XDCDMA_IDR_NO_OSTAND_TRAN3_MASK			0X00000800

#define XDCDMA_IDR_NO_OSTAND_TRAN2_SHIFT		10
#define XDCDMA_IDR_NO_OSTAND_TRAN2_WIDTH		1
#define XDCDMA_IDR_NO_OSTAND_TRAN2_MASK			0X00000400

#define XDCDMA_IDR_NO_OSTAND_TRAN1_SHIFT		9
#define XDCDMA_IDR_NO_OSTAND_TRAN1_WIDTH		1
#define XDCDMA_IDR_NO_OSTAND_TRAN1_MASK			0X00000200

#define XDCDMA_IDR_NO_OSTAND_TRAN0_SHIFT		8
#define XDCDMA_IDR_NO_OSTAND_TRAN0_WIDTH		1
#define XDCDMA_IDR_NO_OSTAND_TRAN0_MASK			0X00000100

#define XDCDMA_IDR_DSCR_DONE7_SHIFT			    7
#define XDCDMA_IDR_DSCR_DONE7_WIDTH			    1
#define XDCDMA_IDR_DSCR_DONE7_MASK			    0X00000080

#define XDCDMA_IDR_DSCR_DONE6_SHIFT			    6
#define XDCDMA_IDR_DSCR_DONE6_WIDTH			    1
#define XDCDMA_IDR_DSCR_DONE6_MASK			    0X00000040

#define XDCDMA_IDR_DSCR_DONE5_SHIFT			    5
#define XDCDMA_IDR_DSCR_DONE5_WIDTH			    1
#define XDCDMA_IDR_DSCR_DONE5_MASK			    0X00000020

#define XDCDMA_IDR_DSCR_DONE4_SHIFT			    4
#define XDCDMA_IDR_DSCR_DONE4_WIDTH			    1
#define XDCDMA_IDR_DSCR_DONE4_MASK			    0X00000010

#define XDCDMA_IDR_DSCR_DONE3_SHIFT			    3
#define XDCDMA_IDR_DSCR_DONE3_WIDTH			    1
#define XDCDMA_IDR_DSCR_DONE3_MASK			    0X00000008

#define XDCDMA_IDR_DSCR_DONE2_SHIFT			    2
#define XDCDMA_IDR_DSCR_DONE2_WIDTH			    1
#define XDCDMA_IDR_DSCR_DONE2_MASK			    0X00000004

#define XDCDMA_IDR_DSCR_DONE1_SHIFT			    1
#define XDCDMA_IDR_DSCR_DONE1_WIDTH			    1
#define XDCDMA_IDR_DSCR_DONE1_MASK			    0X00000002

#define XDCDMA_IDR_DSCR_DONE0_SHIFT			    0
#define XDCDMA_IDR_DSCR_DONE0_WIDTH			    1
#define XDCDMA_IDR_DSCR_DONE0_MASK			    0X00000001

/**
 * Register: XDCDMA_ITR
 */
#define XDCDMA_ITR              0x0060

#define XDCDMA_ITR_DSCR_ERR7_SHIFT			    31
#define XDCDMA_ITR_DSCR_ERR7_WIDTH			    1
#define XDCDMA_ITR_DSCR_ERR7_MASK			    0X80000000

#define XDCDMA_ITR_DSCR_ERR6_SHIFT			    30
#define XDCDMA_ITR_DSCR_ERR6_WIDTH			    1
#define XDCDMA_ITR_DSCR_ERR6_MASK			    0X40000000

#define XDCDMA_ITR_DSCR_ERR5_SHIFT			29
#define XDCDMA_ITR_DSCR_ERR5_WIDTH			1
#define XDCDMA_ITR_DSCR_ERR5_MASK			0X20000000

#define XDCDMA_ITR_DSCR_ERR4_SHIFT			28
#define XDCDMA_ITR_DSCR_ERR4_WIDTH			1
#define XDCDMA_ITR_DSCR_ERR4_MASK			0X10000000

#define XDCDMA_ITR_DSCR_ERR3_SHIFT			27
#define XDCDMA_ITR_DSCR_ERR3_WIDTH			1
#define XDCDMA_ITR_DSCR_ERR3_MASK			0X08000000

#define XDCDMA_ITR_DSCR_ERR2_SHIFT			26
#define XDCDMA_ITR_DSCR_ERR2_WIDTH			1
#define XDCDMA_ITR_DSCR_ERR2_MASK			0X04000000

#define XDCDMA_ITR_DSCR_ERR1_SHIFT			25
#define XDCDMA_ITR_DSCR_ERR1_WIDTH			1
#define XDCDMA_ITR_DSCR_ERR1_MASK			0X02000000

#define XDCDMA_ITR_DSCR_ERR0_SHIFT			24
#define XDCDMA_ITR_DSCR_ERR0_WIDTH			1
#define XDCDMA_ITR_DSCR_ERR0_MASK			0X01000000

#define XDCDMA_ITR_DATA_AXI_ERR7_SHIFT			23
#define XDCDMA_ITR_DATA_AXI_ERR7_WIDTH			1
#define XDCDMA_ITR_DATA_AXI_ERR7_MASK			0X00800000

#define XDCDMA_ITR_DATA_AXI_ERR6_SHIFT			22
#define XDCDMA_ITR_DATA_AXI_ERR6_WIDTH			1
#define XDCDMA_ITR_DATA_AXI_ERR6_MASK			0X00400000

#define XDCDMA_ITR_DATA_AXI_ERR5_SHIFT			21
#define XDCDMA_ITR_DATA_AXI_ERR5_WIDTH			1
#define XDCDMA_ITR_DATA_AXI_ERR5_MASK			0X00200000

#define XDCDMA_ITR_DATA_AXI_ERR4_SHIFT			20
#define XDCDMA_ITR_DATA_AXI_ERR4_WIDTH			1
#define XDCDMA_ITR_DATA_AXI_ERR4_MASK			0X00100000

#define XDCDMA_ITR_DATA_AXI_ERR3_SHIFT			19
#define XDCDMA_ITR_DATA_AXI_ERR3_WIDTH			1
#define XDCDMA_ITR_DATA_AXI_ERR3_MASK			0X00080000

#define XDCDMA_ITR_DATA_AXI_ERR2_SHIFT			18
#define XDCDMA_ITR_DATA_AXI_ERR2_WIDTH			1
#define XDCDMA_ITR_DATA_AXI_ERR2_MASK			0X00040000

#define XDCDMA_ITR_DATA_AXI_ERR1_SHIFT			17
#define XDCDMA_ITR_DATA_AXI_ERR1_WIDTH			1
#define XDCDMA_ITR_DATA_AXI_ERR1_MASK			0X00020000

#define XDCDMA_ITR_DATA_AXI_ERR0_SHIFT			16
#define XDCDMA_ITR_DATA_AXI_ERR0_WIDTH			1
#define XDCDMA_ITR_DATA_AXI_ERR0_MASK			0X00010000

#define XDCDMA_ITR_NO_OSTAND_TRAN7_SHIFT		15
#define XDCDMA_ITR_NO_OSTAND_TRAN7_WIDTH		1
#define XDCDMA_ITR_NO_OSTAND_TRAN7_MASK			0X00008000

#define XDCDMA_ITR_NO_OSTAND_TRAN6_SHIFT		14
#define XDCDMA_ITR_NO_OSTAND_TRAN6_WIDTH		1
#define XDCDMA_ITR_NO_OSTAND_TRAN6_MASK			0X00004000

#define XDCDMA_ITR_NO_OSTAND_TRAN5_SHIFT		13
#define XDCDMA_ITR_NO_OSTAND_TRAN5_WIDTH		1
#define XDCDMA_ITR_NO_OSTAND_TRAN5_MASK			0X00002000

#define XDCDMA_ITR_NO_OSTAND_TRAN4_SHIFT		12
#define XDCDMA_ITR_NO_OSTAND_TRAN4_WIDTH		1
#define XDCDMA_ITR_NO_OSTAND_TRAN4_MASK			0X00001000

#define XDCDMA_ITR_NO_OSTAND_TRAN3_SHIFT		11
#define XDCDMA_ITR_NO_OSTAND_TRAN3_WIDTH		1
#define XDCDMA_ITR_NO_OSTAND_TRAN3_MASK			0X00000800

#define XDCDMA_ITR_NO_OSTAND_TRAN2_SHIFT		10
#define XDCDMA_ITR_NO_OSTAND_TRAN2_WIDTH		1
#define XDCDMA_ITR_NO_OSTAND_TRAN2_MASK			0X00000400

#define XDCDMA_ITR_NO_OSTAND_TRAN1_SHIFT		9
#define XDCDMA_ITR_NO_OSTAND_TRAN1_WIDTH		1
#define XDCDMA_ITR_NO_OSTAND_TRAN1_MASK			0X00000200

#define XDCDMA_ITR_NO_OSTAND_TRAN0_SHIFT		8
#define XDCDMA_ITR_NO_OSTAND_TRAN0_WIDTH		1
#define XDCDMA_ITR_NO_OSTAND_TRAN0_MASK			0X00000100

#define XDCDMA_ITR_DSCR_DONE7_SHIFT			    7
#define XDCDMA_ITR_DSCR_DONE7_WIDTH			    1
#define XDCDMA_ITR_DSCR_DONE7_MASK			    0X00000080

#define XDCDMA_ITR_DSCR_DONE6_SHIFT			    6
#define XDCDMA_ITR_DSCR_DONE6_WIDTH			    1
#define XDCDMA_ITR_DSCR_DONE6_MASK			    0X00000040

#define XDCDMA_ITR_DSCR_DONE5_SHIFT			    5
#define XDCDMA_ITR_DSCR_DONE5_WIDTH			    1
#define XDCDMA_ITR_DSCR_DONE5_MASK			    0X00000020

#define XDCDMA_ITR_DSCR_DONE4_SHIFT			    4
#define XDCDMA_ITR_DSCR_DONE4_WIDTH			    1
#define XDCDMA_ITR_DSCR_DONE4_MASK			    0X00000010

#define XDCDMA_ITR_DSCR_DONE3_SHIFT			    3
#define XDCDMA_ITR_DSCR_DONE3_WIDTH			    1
#define XDCDMA_ITR_DSCR_DONE3_MASK			    0X00000008

#define XDCDMA_ITR_DSCR_DONE2_SHIFT			    2
#define XDCDMA_ITR_DSCR_DONE2_WIDTH			    1
#define XDCDMA_ITR_DSCR_DONE2_MASK			    0X00000004

#define XDCDMA_ITR_DSCR_DONE1_SHIFT			    1
#define XDCDMA_ITR_DSCR_DONE1_WIDTH			    1
#define XDCDMA_ITR_DSCR_DONE1_MASK			    0X00000002

#define XDCDMA_ITR_DSCR_DONE0_SHIFT			    0
#define XDCDMA_ITR_DSCR_DONE0_WIDTH			    1
#define XDCDMA_ITR_DSCR_DONE0_MASK			    0X00000001

/**
 * Register: XDCDMA_MISC_ISR
 */
#define XDCDMA_MISC_ISR         0X0070

#define XDCDMA_ISR_VSYNC2_INT_SHIFT			    3
#define XDCDMA_ISR_VSYNC2_INT_WIDTH			    1
#define XDCDMA_ISR_VSYNC2_INT_MASK			    0X8

#define XDCDMA_ISR_VSYNC1_INT_SHIFT			    2
#define XDCDMA_ISR_VSYNC1_INT_WIDTH			    1
#define XDCDMA_ISR_VSYNC1_INT_MASK			    0X4

#define XDCDMA_ISR_AXI_RD_4K_CROSS_SHIFT		1
#define XDCDMA_ISR_AXI_RD_4K_CROSS_WIDTH		1
#define XDCDMA_ISR_AXI_RD_4K_CROSS_MASK			0X2

#define XDCDMA_ISR_ADDR_DECODE_ERR_SHIFT        0
#define XDCDMA_ISR_ADDR_DECODE_ERR_WIDTH        1
#define XDCDMA_ISR_ADDR_DECODE_ERR_MASK         0X1

/**
 * Register: XDCDMA_MISC_IMR
 */
#define XDCDMA_MISC_IMR         0X0074

#define XDCDMA_IMR_VSYNC_INT_SHIFT			    2
#define XDCDMA_IMR_VSYNC_INT_WIDTH			    1
#define XDCDMA_IMR_VSYNC_INT_MASK			    0X4

#define XDCDMA_IMR_AXI_RD_4K_CROSS_SHIFT		1
#define XDCDMA_IMR_AXI_RD_4K_CROSS_WIDTH		1
#define XDCDMA_IMR_AXI_RD_4K_CROSS_MASK			0X2

#define XDCDMA_IMR_ADDR_DECODE_ERR_SHIFT        0
#define XDCDMA_IMR_ADDR_DECODE_ERR_WIDTH        1
#define XDCDMA_IMR_ADDR_DECODE_ERR_MASK         0X1

/**
 * Register: XDCDMA_MISC_IER
 */
#define XDCDMA_MISC_IER         0X0078

#define XDCDMA_IER_VSYNC2_INT_SHIFT			    3
#define XDCDMA_IER_VSYNC2_INT_WIDTH			    1
#define XDCDMA_IER_VSYNC2_INT_MASK			    0X8

#define XDCDMA_IER_VSYNC1_INT_SHIFT			    2
#define XDCDMA_IER_VSYNC1_INT_WIDTH			    1
#define XDCDMA_IER_VSYNC1_INT_MASK			    0X4

#define XDCDMA_IER_AXI_RD_4K_CROSS_SHIFT		1
#define XDCDMA_IER_AXI_RD_4K_CROSS_WIDTH		1
#define XDCDMA_IER_AXI_RD_4K_CROSS_MASK			0X2

#define XDCDMA_IER_ADDR_DECODE_ERR_SHIFT        0
#define XDCDMA_IER_ADDR_DECODE_ERR_WIDTH        1
#define XDCDMA_IER_ADDR_DECODE_ERR_MASK         0X1

/**
 * Register: XDCDMA_MISC_IDR
 */
#define XDCDMA_MISC_IDR         0X007C

#define XDCDMA_IDR_VSYNC_INT_SHIFT			    2
#define XDCDMA_IDR_VSYNC_INT_WIDTH			    1
#define XDCDMA_IDR_VSYNC_INT_MASK			    0X4

#define XDCDMA_IDR_AXI_RD_4K_CROSS_SHIFT		1
#define XDCDMA_IDR_AXI_RD_4K_CROSS_WIDTH		1
#define XDCDMA_IDR_AXI_RD_4K_CROSS_MASK			0X2

#define XDCDMA_IDR_ADDR_DECODE_ERR_SHIFT        0
#define XDCDMA_IDR_ADDR_DECODE_ERR_WIDTH        1
#define XDCDMA_IDR_ADDR_DECODE_ERR_MASK         0X1

/**
 * Register: XDCDMA_MISC_ITR
 */
#define XDCDMA_MISC_ITR         0X0080

#define XDCDMA_ITR_VSYNC_INT_SHIFT			    2
#define XDCDMA_ITR_VSYNC_INT_WIDTH			    1
#define XDCDMA_ITR_VSYNC_INT_MASK			    0X4

#define XDCDMA_ITR_AXI_RD_4K_CROSS_SHIFT		1
#define XDCDMA_ITR_AXI_RD_4K_CROSS_WIDTH		1
#define XDCDMA_ITR_AXI_RD_4K_CROSS_MASK			0X2

#define XDCDMA_ITR_ADDR_DECODE_ERR_SHIFT        0
#define XDCDMA_ITR_ADDR_DECODE_ERR_WIDTH        1
#define XDCDMA_ITR_ADDR_DECODE_ERR_MASK         0X1

/**
 * Register: XDCDMA_CH0TOCH5_EISR
 */
#define XDCDMA_CH0TOCH5_EISR    0X0090

#define XDCDMA_EISR_DSCR_DONE_ERR5_SHIFT        29
#define XDCDMA_EISR_DSCR_DONE_ERR5_WIDTH        1
#define XDCDMA_EISR_DSCR_DONE_ERR5_MASK         0X20000000

#define XDCDMA_EISR_DSCR_DONE_ERR4_SHIFT        28
#define XDCDMA_EISR_DSCR_DONE_ERR4_WIDTH        1
#define XDCDMA_EISR_DSCR_DONE_ERR4_MASK         0X10000000

#define XDCDMA_EISR_DSCR_DONE_ERR3_SHIFT        27
#define XDCDMA_EISR_DSCR_DONE_ERR3_WIDTH        1
#define XDCDMA_EISR_DSCR_DONE_ERR3_MASK         0X08000000

#define XDCDMA_EISR_DSCR_DONE_ERR2_SHIFT        26
#define XDCDMA_EISR_DSCR_DONE_ERR2_WIDTH        1
#define XDCDMA_EISR_DSCR_DONE_ERR2_MASK         0X04000000

#define XDCDMA_EISR_DSCR_DONE_ERR1_SHIFT        25
#define XDCDMA_EISR_DSCR_DONE_ERR1_WIDTH        1
#define XDCDMA_EISR_DSCR_DONE_ERR1_MASK         0X02000000

#define XDCDMA_EISR_DSCR_DONE_ERR0_SHIFT        24
#define XDCDMA_EISR_DSCR_DONE_ERR0_WIDTH        1
#define XDCDMA_EISR_DSCR_DONE_ERR0_MASK         0X01000000

#define XDCDMA_EISR_DSCR_WR_AXI_ERR5_SHIFT      23
#define XDCDMA_EISR_DSCR_WR_AXI_ERR5_WIDTH      1
#define XDCDMA_EISR_DSCR_WR_AXI_ERR5_MASK       0X00800000

#define XDCDMA_EISR_DSCR_WR_AXI_ERR4_SHIFT      22
#define XDCDMA_EISR_DSCR_WR_AXI_ERR4_WIDTH      1
#define XDCDMA_EISR_DSCR_WR_AXI_ERR4_MASK       0X00400000

#define XDCDMA_EISR_DSCR_WR_AXI_ERR3_SHIFT      21
#define XDCDMA_EISR_DSCR_WR_AXI_ERR3_WIDTH      1
#define XDCDMA_EISR_DSCR_WR_AXI_ERR3_MASK       0X00200000

#define XDCDMA_EISR_DSCR_WR_AXI_ERR2_SHIFT      20
#define XDCDMA_EISR_DSCR_WR_AXI_ERR2_WIDTH      1
#define XDCDMA_EISR_DSCR_WR_AXI_ERR2_MASK       0X00100000

#define XDCDMA_EISR_DSCR_WR_AXI_ERR1_SHIFT      19
#define XDCDMA_EISR_DSCR_WR_AXI_ERR1_WIDTH      1
#define XDCDMA_EISR_DSCR_WR_AXI_ERR1_MASK       0X00080000

#define XDCDMA_EISR_DSCR_WR_AXI_ERR0_SHIFT      18
#define XDCDMA_EISR_DSCR_WR_AXI_ERR0_WIDTH      1
#define XDCDMA_EISR_DSCR_WR_AXI_ERR0_MASK       0X00040000

#define XDCDMA_EISR_DSCR_CRC_ERR5_SHIFT         17
#define XDCDMA_EISR_DSCR_CRC_ERR5_WIDTH         1
#define XDCDMA_EISR_DSCR_CRC_ERR5_MASK          0X00020000

#define XDCDMA_EISR_DSCR_CRC_ERR4_SHIFT         16
#define XDCDMA_EISR_DSCR_CRC_ERR4_WIDTH         1
#define XDCDMA_EISR_DSCR_CRC_ERR4_MASK          0X00010000

#define XDCDMA_EISR_DSCR_CRC_ERR3_SHIFT         15
#define XDCDMA_EISR_DSCR_CRC_ERR3_WIDTH         1
#define XDCDMA_EISR_DSCR_CRC_ERR3_MASK          0X00008000

#define XDCDMA_EISR_DSCR_CRC_ERR2_SHIFT         14
#define XDCDMA_EISR_DSCR_CRC_ERR2_WIDTH         1
#define XDCDMA_EISR_DSCR_CRC_ERR2_MASK          0X00004000

#define XDCDMA_EISR_DSCR_CRC_ERR1_SHIFT         13
#define XDCDMA_EISR_DSCR_CRC_ERR1_WIDTH         1
#define XDCDMA_EISR_DSCR_CRC_ERR1_MASK          0X00002000

#define XDCDMA_EISR_DSCR_CRC_ERR0_SHIFT         12
#define XDCDMA_EISR_DSCR_CRC_ERR0_WIDTH         1
#define XDCDMA_EISR_DSCR_CRC_ERR0_MASK          0X00001000

#define XDCDMA_EISR_DSCR_PRE_ERR5_SHIFT         11
#define XDCDMA_EISR_DSCR_PRE_ERR5_WIDTH         1
#define XDCDMA_EISR_DSCR_PRE_ERR5_MASK          0X00000800

#define XDCDMA_EISR_DSCR_PRE_ERR4_SHIFT         10
#define XDCDMA_EISR_DSCR_PRE_ERR4_WIDTH         1
#define XDCDMA_EISR_DSCR_PRE_ERR4_MASK          0X00000400

#define XDCDMA_EISR_DSCR_PRE_ERR3_SHIFT         9
#define XDCDMA_EISR_DSCR_PRE_ERR3_WIDTH         1
#define XDCDMA_EISR_DSCR_PRE_ERR3_MASK          0X00000200

#define XDCDMA_EISR_DSCR_PRE_ERR2_SHIFT         8
#define XDCDMA_EISR_DSCR_PRE_ERR2_WIDTH         1
#define XDCDMA_EISR_DSCR_PRE_ERR2_MASK          0X00000100

#define XDCDMA_EISR_DSCR_PRE_ERR1_SHIFT         7
#define XDCDMA_EISR_DSCR_PRE_ERR1_WIDTH         1
#define XDCDMA_EISR_DSCR_PRE_ERR1_MASK          0X00000080

#define XDCDMA_EISR_DSCR_PRE_ERR0_SHIFT         6
#define XDCDMA_EISR_DSCR_PRE_ERR0_WIDTH         1
#define XDCDMA_EISR_DSCR_PRE_ERR0_MASK          0X00000040

#define XDCDMA_EISR_DSCR_RD_AXI_ERR5_SHIFT      5
#define XDCDMA_EISR_DSCR_RD_AXI_ERR5_WIDTH      1
#define XDCDMA_EISR_DSCR_RD_AXI_ERR5_MASK       0X00000020

#define XDCDMA_EISR_DSCR_RD_AXI_ERR4_SHIFT      4
#define XDCDMA_EISR_DSCR_RD_AXI_ERR4_WIDTH      1
#define XDCDMA_EISR_DSCR_RD_AXI_ERR4_MASK       0X00000010

#define XDCDMA_EISR_DSCR_RD_AXI_ERR3_SHIFT      3
#define XDCDMA_EISR_DSCR_RD_AXI_ERR3_WIDTH      1
#define XDCDMA_EISR_DSCR_RD_AXI_ERR3_MASK       0X00000008

#define XDCDMA_EISR_DSCR_RD_AXI_ERR2_SHIFT      2
#define XDCDMA_EISR_DSCR_RD_AXI_ERR2_WIDTH      1
#define XDCDMA_EISR_DSCR_RD_AXI_ERR2_MASK       0X00000004

#define XDCDMA_EISR_DSCR_RD_AXI_ERR1_SHIFT      1
#define XDCDMA_EISR_DSCR_RD_AXI_ERR1_WIDTH      1
#define XDCDMA_EISR_DSCR_RD_AXI_ERR1_MASK       0X00000002

#define XDCDMA_EISR_DSCR_RD_AXI_ERR0_SHIFT      0
#define XDCDMA_EISR_DSCR_RD_AXI_ERR0_WIDTH      1
#define XDCDMA_EISR_DSCR_RD_AXI_ERR0_MASK       0X00000001

/**
 * Register: XDCDMA_CH0TOCH5_EIMR
 */
#define XDCDMA_CH0TOCH5_EIMR    0X0094

#define XDCDMA_EIMR_DSCR_DONE_ERR5_SHIFT        29
#define XDCDMA_EIMR_DSCR_DONE_ERR5_WIDTH        1
#define XDCDMA_EIMR_DSCR_DONE_ERR5_MASK         0X20000000

#define XDCDMA_EIMR_DSCR_DONE_ERR4_SHIFT        28
#define XDCDMA_EIMR_DSCR_DONE_ERR4_WIDTH        1
#define XDCDMA_EIMR_DSCR_DONE_ERR4_MASK         0X10000000

#define XDCDMA_EIMR_DSCR_DONE_ERR3_SHIFT        27
#define XDCDMA_EIMR_DSCR_DONE_ERR3_WIDTH        1
#define XDCDMA_EIMR_DSCR_DONE_ERR3_MASK         0X08000000

#define XDCDMA_EIMR_DSCR_DONE_ERR2_SHIFT        26
#define XDCDMA_EIMR_DSCR_DONE_ERR2_WIDTH        1
#define XDCDMA_EIMR_DSCR_DONE_ERR2_MASK         0X04000000

#define XDCDMA_EIMR_DSCR_DONE_ERR1_SHIFT        25
#define XDCDMA_EIMR_DSCR_DONE_ERR1_WIDTH        1
#define XDCDMA_EIMR_DSCR_DONE_ERR1_MASK         0X02000000

#define XDCDMA_EIMR_DSCR_DONE_ERR0_SHIFT        24
#define XDCDMA_EIMR_DSCR_DONE_ERR0_WIDTH        1
#define XDCDMA_EIMR_DSCR_DONE_ERR0_MASK         0X01000000

#define XDCDMA_EIMR_DSCR_WR_AXI_ERR5_SHIFT      23
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR5_WIDTH      1
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR5_MASK       0X00800000

#define XDCDMA_EIMR_DSCR_WR_AXI_ERR4_SHIFT      22
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR4_WIDTH      1
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR4_MASK       0X00400000

#define XDCDMA_EIMR_DSCR_WR_AXI_ERR3_SHIFT      21
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR3_WIDTH      1
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR3_MASK       0X00200000

#define XDCDMA_EIMR_DSCR_WR_AXI_ERR2_SHIFT      20
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR2_WIDTH      1
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR2_MASK       0X00100000

#define XDCDMA_EIMR_DSCR_WR_AXI_ERR1_SHIFT      19
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR1_WIDTH      1
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR1_MASK       0X00080000

#define XDCDMA_EIMR_DSCR_WR_AXI_ERR0_SHIFT      18
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR0_WIDTH      1
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR0_MASK       0X00040000

#define XDCDMA_EIMR_DSCR_CRC_ERR5_SHIFT         17
#define XDCDMA_EIMR_DSCR_CRC_ERR5_WIDTH         1
#define XDCDMA_EIMR_DSCR_CRC_ERR5_MASK          0X00020000

#define XDCDMA_EIMR_DSCR_CRC_ERR4_SHIFT         16
#define XDCDMA_EIMR_DSCR_CRC_ERR4_WIDTH         1
#define XDCDMA_EIMR_DSCR_CRC_ERR4_MASK          0X00010000

#define XDCDMA_EIMR_DSCR_CRC_ERR3_SHIFT         15
#define XDCDMA_EIMR_DSCR_CRC_ERR3_WIDTH         1
#define XDCDMA_EIMR_DSCR_CRC_ERR3_MASK          0X00008000

#define XDCDMA_EIMR_DSCR_CRC_ERR2_SHIFT         14
#define XDCDMA_EIMR_DSCR_CRC_ERR2_WIDTH         1
#define XDCDMA_EIMR_DSCR_CRC_ERR2_MASK          0X00004000

#define XDCDMA_EIMR_DSCR_CRC_ERR1_SHIFT         13
#define XDCDMA_EIMR_DSCR_CRC_ERR1_WIDTH         1
#define XDCDMA_EIMR_DSCR_CRC_ERR1_MASK          0X00002000

#define XDCDMA_EIMR_DSCR_CRC_ERR0_SHIFT         12
#define XDCDMA_EIMR_DSCR_CRC_ERR0_WIDTH         1
#define XDCDMA_EIMR_DSCR_CRC_ERR0_MASK          0X00001000

#define XDCDMA_EIMR_DSCR_PRE_ERR5_SHIFT         11
#define XDCDMA_EIMR_DSCR_PRE_ERR5_WIDTH         1
#define XDCDMA_EIMR_DSCR_PRE_ERR5_MASK          0X00000800

#define XDCDMA_EIMR_DSCR_PRE_ERR4_SHIFT         10
#define XDCDMA_EIMR_DSCR_PRE_ERR4_WIDTH         1
#define XDCDMA_EIMR_DSCR_PRE_ERR4_MASK          0X00000400

#define XDCDMA_EIMR_DSCR_PRE_ERR3_SHIFT         9
#define XDCDMA_EIMR_DSCR_PRE_ERR3_WIDTH         1
#define XDCDMA_EIMR_DSCR_PRE_ERR3_MASK          0X00000200

#define XDCDMA_EIMR_DSCR_PRE_ERR2_SHIFT         8
#define XDCDMA_EIMR_DSCR_PRE_ERR2_WIDTH         1
#define XDCDMA_EIMR_DSCR_PRE_ERR2_MASK          0X00000100

#define XDCDMA_EIMR_DSCR_PRE_ERR1_SHIFT         7
#define XDCDMA_EIMR_DSCR_PRE_ERR1_WIDTH         1
#define XDCDMA_EIMR_DSCR_PRE_ERR1_MASK          0X00000080

#define XDCDMA_EIMR_DSCR_PRE_ERR0_SHIFT         6
#define XDCDMA_EIMR_DSCR_PRE_ERR0_WIDTH         1
#define XDCDMA_EIMR_DSCR_PRE_ERR0_MASK          0X00000040

#define XDCDMA_EIMR_DSCR_RD_AXI_ERR5_SHIFT      5
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR5_WIDTH      1
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR5_MASK       0X00000020

#define XDCDMA_EIMR_DSCR_RD_AXI_ERR4_SHIFT      4
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR4_WIDTH      1
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR4_MASK       0X00000010

#define XDCDMA_EIMR_DSCR_RD_AXI_ERR3_SHIFT      3
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR3_WIDTH      1
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR3_MASK       0X00000008

#define XDCDMA_EIMR_DSCR_RD_AXI_ERR2_SHIFT      2
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR2_WIDTH      1
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR2_MASK       0X00000004

#define XDCDMA_EIMR_DSCR_RD_AXI_ERR1_SHIFT      1
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR1_WIDTH      1
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR1_MASK       0X00000002

#define XDCDMA_EIMR_DSCR_RD_AXI_ERR0_SHIFT      0
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR0_WIDTH      1
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR0_MASK       0X00000001

/**
 * Register: XDCDMA_CH0TOCH5_EIER
 */
#define XDCDMA_CH0TOCH5_EIER    0X0098

#define XDCDMA_EIER_DSCR_DONE_ERR5_SHIFT        29
#define XDCDMA_EIER_DSCR_DONE_ERR5_WIDTH        1
#define XDCDMA_EIER_DSCR_DONE_ERR5_MASK         0X20000000

#define XDCDMA_EIER_DSCR_DONE_ERR4_SHIFT        28
#define XDCDMA_EIER_DSCR_DONE_ERR4_WIDTH        1
#define XDCDMA_EIER_DSCR_DONE_ERR4_MASK         0X10000000

#define XDCDMA_EIER_DSCR_DONE_ERR3_SHIFT        27
#define XDCDMA_EIER_DSCR_DONE_ERR3_WIDTH        1
#define XDCDMA_EIER_DSCR_DONE_ERR3_MASK         0X08000000

#define XDCDMA_EIER_DSCR_DONE_ERR2_SHIFT        26
#define XDCDMA_EIER_DSCR_DONE_ERR2_WIDTH        1
#define XDCDMA_EIER_DSCR_DONE_ERR2_MASK         0X04000000

#define XDCDMA_EIER_DSCR_DONE_ERR1_SHIFT        25
#define XDCDMA_EIER_DSCR_DONE_ERR1_WIDTH        1
#define XDCDMA_EIER_DSCR_DONE_ERR1_MASK         0X02000000

#define XDCDMA_EIER_DSCR_DONE_ERR0_SHIFT        24
#define XDCDMA_EIER_DSCR_DONE_ERR0_WIDTH        1
#define XDCDMA_EIER_DSCR_DONE_ERR0_MASK         0X01000000

#define XDCDMA_EIER_DSCR_WR_AXI_ERR5_SHIFT      23
#define XDCDMA_EIER_DSCR_WR_AXI_ERR5_WIDTH      1
#define XDCDMA_EIER_DSCR_WR_AXI_ERR5_MASK       0X00800000

#define XDCDMA_EIER_DSCR_WR_AXI_ERR4_SHIFT      22
#define XDCDMA_EIER_DSCR_WR_AXI_ERR4_WIDTH      1
#define XDCDMA_EIER_DSCR_WR_AXI_ERR4_MASK       0X00400000

#define XDCDMA_EIER_DSCR_WR_AXI_ERR3_SHIFT      21
#define XDCDMA_EIER_DSCR_WR_AXI_ERR3_WIDTH      1
#define XDCDMA_EIER_DSCR_WR_AXI_ERR3_MASK       0X00200000

#define XDCDMA_EIER_DSCR_WR_AXI_ERR2_SHIFT      20
#define XDCDMA_EIER_DSCR_WR_AXI_ERR2_WIDTH      1
#define XDCDMA_EIER_DSCR_WR_AXI_ERR2_MASK       0X00100000

#define XDCDMA_EIER_DSCR_WR_AXI_ERR1_SHIFT      19
#define XDCDMA_EIER_DSCR_WR_AXI_ERR1_WIDTH      1
#define XDCDMA_EIER_DSCR_WR_AXI_ERR1_MASK       0X00080000

#define XDCDMA_EIER_DSCR_WR_AXI_ERR0_SHIFT      18
#define XDCDMA_EIER_DSCR_WR_AXI_ERR0_WIDTH      1
#define XDCDMA_EIER_DSCR_WR_AXI_ERR0_MASK       0X00040000

#define XDCDMA_EIER_DSCR_CRC_ERR5_SHIFT         17
#define XDCDMA_EIER_DSCR_CRC_ERR5_WIDTH         1
#define XDCDMA_EIER_DSCR_CRC_ERR5_MASK          0X00020000

#define XDCDMA_EIER_DSCR_CRC_ERR4_SHIFT         16
#define XDCDMA_EIER_DSCR_CRC_ERR4_WIDTH         1
#define XDCDMA_EIER_DSCR_CRC_ERR4_MASK          0X00010000

#define XDCDMA_EIER_DSCR_CRC_ERR3_SHIFT         15
#define XDCDMA_EIER_DSCR_CRC_ERR3_WIDTH         1
#define XDCDMA_EIER_DSCR_CRC_ERR3_MASK          0X00008000

#define XDCDMA_EIER_DSCR_CRC_ERR2_SHIFT         14
#define XDCDMA_EIER_DSCR_CRC_ERR2_WIDTH         1
#define XDCDMA_EIER_DSCR_CRC_ERR2_MASK          0X00004000

#define XDCDMA_EIER_DSCR_CRC_ERR1_SHIFT         13
#define XDCDMA_EIER_DSCR_CRC_ERR1_WIDTH         1
#define XDCDMA_EIER_DSCR_CRC_ERR1_MASK          0X00002000

#define XDCDMA_EIER_DSCR_CRC_ERR0_SHIFT         12
#define XDCDMA_EIER_DSCR_CRC_ERR0_WIDTH         1
#define XDCDMA_EIER_DSCR_CRC_ERR0_MASK          0X00001000

#define XDCDMA_EIER_DSCR_PRE_ERR5_SHIFT         11
#define XDCDMA_EIER_DSCR_PRE_ERR5_WIDTH         1
#define XDCDMA_EIER_DSCR_PRE_ERR5_MASK          0X00000800

#define XDCDMA_EIER_DSCR_PRE_ERR4_SHIFT         10
#define XDCDMA_EIER_DSCR_PRE_ERR4_WIDTH         1
#define XDCDMA_EIER_DSCR_PRE_ERR4_MASK          0X00000400

#define XDCDMA_EIER_DSCR_PRE_ERR3_SHIFT         9
#define XDCDMA_EIER_DSCR_PRE_ERR3_WIDTH         1
#define XDCDMA_EIER_DSCR_PRE_ERR3_MASK          0X00000200

#define XDCDMA_EIER_DSCR_PRE_ERR2_SHIFT         8
#define XDCDMA_EIER_DSCR_PRE_ERR2_WIDTH         1
#define XDCDMA_EIER_DSCR_PRE_ERR2_MASK          0X00000100

#define XDCDMA_EIER_DSCR_PRE_ERR1_SHIFT         7
#define XDCDMA_EIER_DSCR_PRE_ERR1_WIDTH         1
#define XDCDMA_EIER_DSCR_PRE_ERR1_MASK          0X00000080

#define XDCDMA_EIER_DSCR_PRE_ERR0_SHIFT         6
#define XDCDMA_EIER_DSCR_PRE_ERR0_WIDTH         1
#define XDCDMA_EIER_DSCR_PRE_ERR0_MASK          0X00000040

#define XDCDMA_EIER_DSCR_RD_AXI_ERR5_SHIFT      5
#define XDCDMA_EIER_DSCR_RD_AXI_ERR5_WIDTH      1
#define XDCDMA_EIER_DSCR_RD_AXI_ERR5_MASK       0X00000020

#define XDCDMA_EIER_DSCR_RD_AXI_ERR4_SHIFT      4
#define XDCDMA_EIER_DSCR_RD_AXI_ERR4_WIDTH      1
#define XDCDMA_EIER_DSCR_RD_AXI_ERR4_MASK       0X00000010

#define XDCDMA_EIER_DSCR_RD_AXI_ERR3_SHIFT      3
#define XDCDMA_EIER_DSCR_RD_AXI_ERR3_WIDTH      1
#define XDCDMA_EIER_DSCR_RD_AXI_ERR3_MASK       0X00000008

#define XDCDMA_EIER_DSCR_RD_AXI_ERR2_SHIFT      2
#define XDCDMA_EIER_DSCR_RD_AXI_ERR2_WIDTH      1
#define XDCDMA_EIER_DSCR_RD_AXI_ERR2_MASK       0X00000004

#define XDCDMA_EIER_DSCR_RD_AXI_ERR1_SHIFT      1
#define XDCDMA_EIER_DSCR_RD_AXI_ERR1_WIDTH      1
#define XDCDMA_EIER_DSCR_RD_AXI_ERR1_MASK       0X00000002

#define XDCDMA_EIER_DSCR_RD_AXI_ERR0_SHIFT      0
#define XDCDMA_EIER_DSCR_RD_AXI_ERR0_WIDTH      1
#define XDCDMA_EIER_DSCR_RD_AXI_ERR0_MASK       0X00000001

/**
 * Register: XDCDMA_CH0TOCH5_EIDR
 */
#define XDCDMA_CH0TOCH5_EIDR    0X009C

#define XDCDMA_EIDR_DSCR_DONE_ERR5_SHIFT        29
#define XDCDMA_EIDR_DSCR_DONE_ERR5_WIDTH        1
#define XDCDMA_EIDR_DSCR_DONE_ERR5_MASK         0X20000000

#define XDCDMA_EIDR_DSCR_DONE_ERR4_SHIFT        28
#define XDCDMA_EIDR_DSCR_DONE_ERR4_WIDTH        1
#define XDCDMA_EIDR_DSCR_DONE_ERR4_MASK         0X10000000

#define XDCDMA_EIDR_DSCR_DONE_ERR3_SHIFT        27
#define XDCDMA_EIDR_DSCR_DONE_ERR3_WIDTH        1
#define XDCDMA_EIDR_DSCR_DONE_ERR3_MASK         0X08000000

#define XDCDMA_EIDR_DSCR_DONE_ERR2_SHIFT        26
#define XDCDMA_EIDR_DSCR_DONE_ERR2_WIDTH        1
#define XDCDMA_EIDR_DSCR_DONE_ERR2_MASK         0X04000000

#define XDCDMA_EIDR_DSCR_DONE_ERR1_SHIFT        25
#define XDCDMA_EIDR_DSCR_DONE_ERR1_WIDTH        1
#define XDCDMA_EIDR_DSCR_DONE_ERR1_MASK         0X02000000

#define XDCDMA_EIDR_DSCR_DONE_ERR0_SHIFT        24
#define XDCDMA_EIDR_DSCR_DONE_ERR0_WIDTH        1
#define XDCDMA_EIDR_DSCR_DONE_ERR0_MASK         0X01000000

#define XDCDMA_EIDR_DSCR_WR_AXI_ERR5_SHIFT      23
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR5_WIDTH      1
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR5_MASK       0X00800000

#define XDCDMA_EIDR_DSCR_WR_AXI_ERR4_SHIFT      22
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR4_WIDTH      1
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR4_MASK       0X00400000

#define XDCDMA_EIDR_DSCR_WR_AXI_ERR3_SHIFT      21
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR3_WIDTH      1
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR3_MASK       0X00200000

#define XDCDMA_EIDR_DSCR_WR_AXI_ERR2_SHIFT      20
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR2_WIDTH      1
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR2_MASK       0X00100000

#define XDCDMA_EIDR_DSCR_WR_AXI_ERR1_SHIFT      19
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR1_WIDTH      1
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR1_MASK       0X00080000

#define XDCDMA_EIDR_DSCR_WR_AXI_ERR0_SHIFT      18
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR0_WIDTH      1
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR0_MASK       0X00040000

#define XDCDMA_EIDR_DSCR_CRC_ERR5_SHIFT         17
#define XDCDMA_EIDR_DSCR_CRC_ERR5_WIDTH         1
#define XDCDMA_EIDR_DSCR_CRC_ERR5_MASK          0X00020000

#define XDCDMA_EIDR_DSCR_CRC_ERR4_SHIFT         16
#define XDCDMA_EIDR_DSCR_CRC_ERR4_WIDTH         1
#define XDCDMA_EIDR_DSCR_CRC_ERR4_MASK          0X00010000

#define XDCDMA_EIDR_DSCR_CRC_ERR3_SHIFT         15
#define XDCDMA_EIDR_DSCR_CRC_ERR3_WIDTH         1
#define XDCDMA_EIDR_DSCR_CRC_ERR3_MASK          0X00008000

#define XDCDMA_EIDR_DSCR_CRC_ERR2_SHIFT         14
#define XDCDMA_EIDR_DSCR_CRC_ERR2_WIDTH         1
#define XDCDMA_EIDR_DSCR_CRC_ERR2_MASK          0X00004000

#define XDCDMA_EIDR_DSCR_CRC_ERR1_SHIFT         13
#define XDCDMA_EIDR_DSCR_CRC_ERR1_WIDTH         1
#define XDCDMA_EIDR_DSCR_CRC_ERR1_MASK          0X00002000

#define XDCDMA_EIDR_DSCR_CRC_ERR0_SHIFT         12
#define XDCDMA_EIDR_DSCR_CRC_ERR0_WIDTH         1
#define XDCDMA_EIDR_DSCR_CRC_ERR0_MASK          0X00001000

#define XDCDMA_EIDR_DSCR_PRE_ERR5_SHIFT         11
#define XDCDMA_EIDR_DSCR_PRE_ERR5_WIDTH         1
#define XDCDMA_EIDR_DSCR_PRE_ERR5_MASK          0X00000800

#define XDCDMA_EIDR_DSCR_PRE_ERR4_SHIFT         10
#define XDCDMA_EIDR_DSCR_PRE_ERR4_WIDTH         1
#define XDCDMA_EIDR_DSCR_PRE_ERR4_MASK          0X00000400

#define XDCDMA_EIDR_DSCR_PRE_ERR3_SHIFT         9
#define XDCDMA_EIDR_DSCR_PRE_ERR3_WIDTH         1
#define XDCDMA_EIDR_DSCR_PRE_ERR3_MASK          0X00000200

#define XDCDMA_EIDR_DSCR_PRE_ERR2_SHIFT         8
#define XDCDMA_EIDR_DSCR_PRE_ERR2_WIDTH         1
#define XDCDMA_EIDR_DSCR_PRE_ERR2_MASK          0X00000100

#define XDCDMA_EIDR_DSCR_PRE_ERR1_SHIFT         7
#define XDCDMA_EIDR_DSCR_PRE_ERR1_WIDTH         1
#define XDCDMA_EIDR_DSCR_PRE_ERR1_MASK          0X00000080

#define XDCDMA_EIDR_DSCR_PRE_ERR0_SHIFT         6
#define XDCDMA_EIDR_DSCR_PRE_ERR0_WIDTH         1
#define XDCDMA_EIDR_DSCR_PRE_ERR0_MASK          0X00000040

#define XDCDMA_EIDR_DSCR_RD_AXI_ERR5_SHIFT      5
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR5_WIDTH      1
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR5_MASK       0X00000020

#define XDCDMA_EIDR_DSCR_RD_AXI_ERR4_SHIFT      4
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR4_WIDTH      1
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR4_MASK       0X00000010

#define XDCDMA_EIDR_DSCR_RD_AXI_ERR3_SHIFT      3
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR3_WIDTH      1
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR3_MASK       0X00000008

#define XDCDMA_EIDR_DSCR_RD_AXI_ERR2_SHIFT      2
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR2_WIDTH      1
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR2_MASK       0X00000004

#define XDCDMA_EIDR_DSCR_RD_AXI_ERR1_SHIFT      1
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR1_WIDTH      1
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR1_MASK       0X00000002

#define XDCDMA_EIDR_DSCR_RD_AXI_ERR0_SHIFT      0
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR0_WIDTH      1
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR0_MASK       0X00000001

/**
 * Register: XDCDMA_CH0TOCH5_EITR
 */
#define XDCDMA_CH0TOCH5_EITR    0X00A0

#define XDCDMA_EITR_DSCR_DONE_ERR5_SHIFT        29
#define XDCDMA_EITR_DSCR_DONE_ERR5_WIDTH        1
#define XDCDMA_EITR_DSCR_DONE_ERR5_MASK         0X20000000

#define XDCDMA_EITR_DSCR_DONE_ERR4_SHIFT        28
#define XDCDMA_EITR_DSCR_DONE_ERR4_WIDTH        1
#define XDCDMA_EITR_DSCR_DONE_ERR4_MASK         0X10000000

#define XDCDMA_EITR_DSCR_DONE_ERR3_SHIFT        27
#define XDCDMA_EITR_DSCR_DONE_ERR3_WIDTH        1
#define XDCDMA_EITR_DSCR_DONE_ERR3_MASK         0X08000000

#define XDCDMA_EITR_DSCR_DONE_ERR2_SHIFT        26
#define XDCDMA_EITR_DSCR_DONE_ERR2_WIDTH        1
#define XDCDMA_EITR_DSCR_DONE_ERR2_MASK         0X04000000

#define XDCDMA_EITR_DSCR_DONE_ERR1_SHIFT        25
#define XDCDMA_EITR_DSCR_DONE_ERR1_WIDTH        1
#define XDCDMA_EITR_DSCR_DONE_ERR1_MASK         0X02000000

#define XDCDMA_EITR_DSCR_DONE_ERR0_SHIFT        24
#define XDCDMA_EITR_DSCR_DONE_ERR0_WIDTH        1
#define XDCDMA_EITR_DSCR_DONE_ERR0_MASK         0X01000000

#define XDCDMA_EITR_DSCR_WR_AXI_ERR5_SHIFT      23
#define XDCDMA_EITR_DSCR_WR_AXI_ERR5_WIDTH      1
#define XDCDMA_EITR_DSCR_WR_AXI_ERR5_MASK       0X00800000

#define XDCDMA_EITR_DSCR_WR_AXI_ERR4_SHIFT      22
#define XDCDMA_EITR_DSCR_WR_AXI_ERR4_WIDTH      1
#define XDCDMA_EITR_DSCR_WR_AXI_ERR4_MASK       0X00400000

#define XDCDMA_EITR_DSCR_WR_AXI_ERR3_SHIFT      21
#define XDCDMA_EITR_DSCR_WR_AXI_ERR3_WIDTH      1
#define XDCDMA_EITR_DSCR_WR_AXI_ERR3_MASK       0X00200000

#define XDCDMA_EITR_DSCR_WR_AXI_ERR2_SHIFT      20
#define XDCDMA_EITR_DSCR_WR_AXI_ERR2_WIDTH      1
#define XDCDMA_EITR_DSCR_WR_AXI_ERR2_MASK       0X00100000

#define XDCDMA_EITR_DSCR_WR_AXI_ERR1_SHIFT      19
#define XDCDMA_EITR_DSCR_WR_AXI_ERR1_WIDTH      1
#define XDCDMA_EITR_DSCR_WR_AXI_ERR1_MASK       0X00080000

#define XDCDMA_EITR_DSCR_WR_AXI_ERR0_SHIFT      18
#define XDCDMA_EITR_DSCR_WR_AXI_ERR0_WIDTH      1
#define XDCDMA_EITR_DSCR_WR_AXI_ERR0_MASK       0X00040000

#define XDCDMA_EITR_DSCR_CRC_ERR5_SHIFT         17
#define XDCDMA_EITR_DSCR_CRC_ERR5_WIDTH         1
#define XDCDMA_EITR_DSCR_CRC_ERR5_MASK          0X00020000

#define XDCDMA_EITR_DSCR_CRC_ERR4_SHIFT         16
#define XDCDMA_EITR_DSCR_CRC_ERR4_WIDTH         1
#define XDCDMA_EITR_DSCR_CRC_ERR4_MASK          0X00010000

#define XDCDMA_EITR_DSCR_CRC_ERR3_SHIFT         15
#define XDCDMA_EITR_DSCR_CRC_ERR3_WIDTH         1
#define XDCDMA_EITR_DSCR_CRC_ERR3_MASK          0X00008000

#define XDCDMA_EITR_DSCR_CRC_ERR2_SHIFT         14
#define XDCDMA_EITR_DSCR_CRC_ERR2_WIDTH         1
#define XDCDMA_EITR_DSCR_CRC_ERR2_MASK          0X00004000

#define XDCDMA_EITR_DSCR_CRC_ERR1_SHIFT         13
#define XDCDMA_EITR_DSCR_CRC_ERR1_WIDTH         1
#define XDCDMA_EITR_DSCR_CRC_ERR1_MASK          0X00002000

#define XDCDMA_EITR_DSCR_CRC_ERR0_SHIFT         12
#define XDCDMA_EITR_DSCR_CRC_ERR0_WIDTH         1
#define XDCDMA_EITR_DSCR_CRC_ERR0_MASK          0X00001000

#define XDCDMA_EITR_DSCR_PRE_ERR5_SHIFT         11
#define XDCDMA_EITR_DSCR_PRE_ERR5_WIDTH         1
#define XDCDMA_EITR_DSCR_PRE_ERR5_MASK          0X00000800

#define XDCDMA_EITR_DSCR_PRE_ERR4_SHIFT         10
#define XDCDMA_EITR_DSCR_PRE_ERR4_WIDTH         1
#define XDCDMA_EITR_DSCR_PRE_ERR4_MASK          0X00000400

#define XDCDMA_EITR_DSCR_PRE_ERR3_SHIFT         9
#define XDCDMA_EITR_DSCR_PRE_ERR3_WIDTH         1
#define XDCDMA_EITR_DSCR_PRE_ERR3_MASK          0X00000200

#define XDCDMA_EITR_DSCR_PRE_ERR2_SHIFT         8
#define XDCDMA_EITR_DSCR_PRE_ERR2_WIDTH         1
#define XDCDMA_EITR_DSCR_PRE_ERR2_MASK          0X00000100

#define XDCDMA_EITR_DSCR_PRE_ERR1_SHIFT         7
#define XDCDMA_EITR_DSCR_PRE_ERR1_WIDTH         1
#define XDCDMA_EITR_DSCR_PRE_ERR1_MASK          0X00000080

#define XDCDMA_EITR_DSCR_PRE_ERR0_SHIFT         6
#define XDCDMA_EITR_DSCR_PRE_ERR0_WIDTH         1
#define XDCDMA_EITR_DSCR_PRE_ERR0_MASK          0X00000040

#define XDCDMA_EITR_DSCR_RD_AXI_ERR5_SHIFT      5
#define XDCDMA_EITR_DSCR_RD_AXI_ERR5_WIDTH      1
#define XDCDMA_EITR_DSCR_RD_AXI_ERR5_MASK       0X00000020

#define XDCDMA_EITR_DSCR_RD_AXI_ERR4_SHIFT      4
#define XDCDMA_EITR_DSCR_RD_AXI_ERR4_WIDTH      1
#define XDCDMA_EITR_DSCR_RD_AXI_ERR4_MASK       0X00000010

#define XDCDMA_EITR_DSCR_RD_AXI_ERR3_SHIFT      3
#define XDCDMA_EITR_DSCR_RD_AXI_ERR3_WIDTH      1
#define XDCDMA_EITR_DSCR_RD_AXI_ERR3_MASK       0X00000008

#define XDCDMA_EITR_DSCR_RD_AXI_ERR2_SHIFT      2
#define XDCDMA_EITR_DSCR_RD_AXI_ERR2_WIDTH      1
#define XDCDMA_EITR_DSCR_RD_AXI_ERR2_MASK       0X00000004

#define XDCDMA_EITR_DSCR_RD_AXI_ERR1_SHIFT      1
#define XDCDMA_EITR_DSCR_RD_AXI_ERR1_WIDTH      1
#define XDCDMA_EITR_DSCR_RD_AXI_ERR1_MASK       0X00000002

#define XDCDMA_EITR_DSCR_RD_AXI_ERR0_SHIFT      0
#define XDCDMA_EITR_DSCR_RD_AXI_ERR0_WIDTH      1
#define XDCDMA_EITR_DSCR_RD_AXI_ERR0_MASK       0X00000001

/**
 * Register: XDCDMA_CH6TOCH7_EISR
 */
#define XDCDMA_CH6TOCH7_EISR    0X00A4

#define XDCDMA_EISR_DSCR_DONE_ERR7_SHIFT        9
#define XDCDMA_EISR_DSCR_DONE_ERR7_WIDTH        1
#define XDCDMA_EISR_DSCR_DONE_ERR7_MASK         0X00000200

#define XDCDMA_EISR_DSCR_DONE_ERR6_SHIFT        8
#define XDCDMA_EISR_DSCR_DONE_ERR6_WIDTH        1
#define XDCDMA_EISR_DSCR_DONE_ERR6_MASK         0X00000100

#define XDCDMA_EISR_DSCR_WR_AXI_ERR7_SHIFT      7
#define XDCDMA_EISR_DSCR_WR_AXI_ERR7_WIDTH      1
#define XDCDMA_EISR_DSCR_WR_AXI_ERR7_MASK       0X00000080

#define XDCDMA_EISR_DSCR_WR_AXI_ERR6_SHIFT      6
#define XDCDMA_EISR_DSCR_WR_AXI_ERR6_WIDTH      1
#define XDCDMA_EISR_DSCR_WR_AXI_ERR6_MASK       0X00000040

#define XDCDMA_EISR_DSCR_CRC_ERR7_SHIFT         5
#define XDCDMA_EISR_DSCR_CRC_ERR7_WIDTH         1
#define XDCDMA_EISR_DSCR_CRC_ERR7_MASK          0X00000020

#define XDCDMA_EISR_DSCR_CRC_ERR6_SHIFT         4
#define XDCDMA_EISR_DSCR_CRC_ERR6_WIDTH         1
#define XDCDMA_EISR_DSCR_CRC_ERR6_MASK          0X00000010

#define XDCDMA_EISR_DSCR_PRE_ERR7_SHIFT         3
#define XDCDMA_EISR_DSCR_PRE_ERR7_WIDTH         1
#define XDCDMA_EISR_DSCR_PRE_ERR7_MASK          0X00000008

#define XDCDMA_EISR_DSCR_PRE_ERR6_SHIFT         2
#define XDCDMA_EISR_DSCR_PRE_ERR6_WIDTH         1
#define XDCDMA_EISR_DSCR_PRE_ERR6_MASK          0X00000004

#define XDCDMA_EISR_DSCR_RD_AXI_ERR7_SHIFT      1
#define XDCDMA_EISR_DSCR_RD_AXI_ERR7_WIDTH      1
#define XDCDMA_EISR_DSCR_RD_AXI_ERR7_MASK       0X00000002

#define XDCDMA_EISR_DSCR_RD_AXI_ERR6_SHIFT      0
#define XDCDMA_EISR_DSCR_RD_AXI_ERR6_WIDTH      1
#define XDCDMA_EISR_DSCR_RD_AXI_ERR6_MASK       0X00000001

/**
 * Register: XDCDMA_CH6TOCH7_EIMR
 */
#define XDCDMA_CH6TOCH7_EIMR    0X00A8

#define XDCDMA_EIMR_DSCR_DONE_ERR7_SHIFT        9
#define XDCDMA_EIMR_DSCR_DONE_ERR7_WIDTH        1
#define XDCDMA_EIMR_DSCR_DONE_ERR7_MASK         0X00000200

#define XDCDMA_EIMR_DSCR_DONE_ERR6_SHIFT        8
#define XDCDMA_EIMR_DSCR_DONE_ERR6_WIDTH        1
#define XDCDMA_EIMR_DSCR_DONE_ERR6_MASK         0X00000100

#define XDCDMA_EIMR_DSCR_WR_AXI_ERR7_SHIFT      7
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR7_WIDTH      1
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR7_MASK       0X00000080

#define XDCDMA_EIMR_DSCR_WR_AXI_ERR6_SHIFT      6
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR6_WIDTH      1
#define XDCDMA_EIMR_DSCR_WR_AXI_ERR6_MASK       0X00000040

#define XDCDMA_EIMR_DSCR_CRC_ERR7_SHIFT         5
#define XDCDMA_EIMR_DSCR_CRC_ERR7_WIDTH         1
#define XDCDMA_EIMR_DSCR_CRC_ERR7_MASK          0X00000020

#define XDCDMA_EIMR_DSCR_CRC_ERR6_SHIFT         4
#define XDCDMA_EIMR_DSCR_CRC_ERR6_WIDTH         1
#define XDCDMA_EIMR_DSCR_CRC_ERR6_MASK          0X00000010

#define XDCDMA_EIMR_DSCR_PRE_ERR7_SHIFT         3
#define XDCDMA_EIMR_DSCR_PRE_ERR7_WIDTH         1
#define XDCDMA_EIMR_DSCR_PRE_ERR7_MASK          0X00000008

#define XDCDMA_EIMR_DSCR_PRE_ERR6_SHIFT         2
#define XDCDMA_EIMR_DSCR_PRE_ERR6_WIDTH         1
#define XDCDMA_EIMR_DSCR_PRE_ERR6_MASK          0X00000004

#define XDCDMA_EIMR_DSCR_RD_AXI_ERR7_SHIFT      1
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR7_WIDTH      1
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR7_MASK       0X00000002

#define XDCDMA_EIMR_DSCR_RD_AXI_ERR6_SHIFT      0
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR6_WIDTH      1
#define XDCDMA_EIMR_DSCR_RD_AXI_ERR6_MASK       0X00000001

/**
 * Register: XDCDMA_CH6TOCH7_EIER
 */
#define XDCDMA_CH6TOCH7_EIER    0X00AC

#define XDCDMA_EIER_DSCR_DONE_ERR7_SHIFT        9
#define XDCDMA_EIER_DSCR_DONE_ERR7_WIDTH        1
#define XDCDMA_EIER_DSCR_DONE_ERR7_MASK         0X00000200

#define XDCDMA_EIER_DSCR_DONE_ERR6_SHIFT        8
#define XDCDMA_EIER_DSCR_DONE_ERR6_WIDTH        1
#define XDCDMA_EIER_DSCR_DONE_ERR6_MASK         0X00000100

#define XDCDMA_EIER_DSCR_WR_AXI_ERR7_SHIFT      7
#define XDCDMA_EIER_DSCR_WR_AXI_ERR7_WIDTH      1
#define XDCDMA_EIER_DSCR_WR_AXI_ERR7_MASK       0X00000080

#define XDCDMA_EIER_DSCR_WR_AXI_ERR6_SHIFT      6
#define XDCDMA_EIER_DSCR_WR_AXI_ERR6_WIDTH      1
#define XDCDMA_EIER_DSCR_WR_AXI_ERR6_MASK       0X00000040

#define XDCDMA_EIER_DSCR_CRC_ERR7_SHIFT         5
#define XDCDMA_EIER_DSCR_CRC_ERR7_WIDTH         1
#define XDCDMA_EIER_DSCR_CRC_ERR7_MASK          0X00000020

#define XDCDMA_EIER_DSCR_CRC_ERR6_SHIFT         4
#define XDCDMA_EIER_DSCR_CRC_ERR6_WIDTH         1
#define XDCDMA_EIER_DSCR_CRC_ERR6_MASK          0X00000010

#define XDCDMA_EIER_DSCR_PRE_ERR7_SHIFT         3
#define XDCDMA_EIER_DSCR_PRE_ERR7_WIDTH         1
#define XDCDMA_EIER_DSCR_PRE_ERR7_MASK          0X00000008

#define XDCDMA_EIER_DSCR_PRE_ERR6_SHIFT         2
#define XDCDMA_EIER_DSCR_PRE_ERR6_WIDTH         1
#define XDCDMA_EIER_DSCR_PRE_ERR6_MASK          0X00000004

#define XDCDMA_EIER_DSCR_RD_AXI_ERR7_SHIFT      1
#define XDCDMA_EIER_DSCR_RD_AXI_ERR7_WIDTH      1
#define XDCDMA_EIER_DSCR_RD_AXI_ERR7_MASK       0X00000002

#define XDCDMA_EIER_DSCR_RD_AXI_ERR6_SHIFT      0
#define XDCDMA_EIER_DSCR_RD_AXI_ERR6_WIDTH      1
#define XDCDMA_EIER_DSCR_RD_AXI_ERR6_MASK       0X00000001

/**
 * Register: XDCDMA_CH6TOCH7_EIDR
 */
#define XDCDMA_CH6TOCH7_EIDR    0X00B0

#define XDCDMA_EIDR_DSCR_DONE_ERR7_SHIFT        9
#define XDCDMA_EIDR_DSCR_DONE_ERR7_WIDTH        1
#define XDCDMA_EIDR_DSCR_DONE_ERR7_MASK         0X00000200

#define XDCDMA_EIDR_DSCR_DONE_ERR6_SHIFT        8
#define XDCDMA_EIDR_DSCR_DONE_ERR6_WIDTH        1
#define XDCDMA_EIDR_DSCR_DONE_ERR6_MASK         0X00000100

#define XDCDMA_EIDR_DSCR_WR_AXI_ERR7_SHIFT      7
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR7_WIDTH      1
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR7_MASK       0X00000080

#define XDCDMA_EIDR_DSCR_WR_AXI_ERR6_SHIFT      6
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR6_WIDTH      1
#define XDCDMA_EIDR_DSCR_WR_AXI_ERR6_MASK       0X00000040

#define XDCDMA_EIDR_DSCR_CRC_ERR7_SHIFT         5
#define XDCDMA_EIDR_DSCR_CRC_ERR7_WIDTH         1
#define XDCDMA_EIDR_DSCR_CRC_ERR7_MASK          0X00000020

#define XDCDMA_EIDR_DSCR_CRC_ERR6_SHIFT         4
#define XDCDMA_EIDR_DSCR_CRC_ERR6_WIDTH         1
#define XDCDMA_EIDR_DSCR_CRC_ERR6_MASK          0X00000010

#define XDCDMA_EIDR_DSCR_PRE_ERR7_SHIFT         3
#define XDCDMA_EIDR_DSCR_PRE_ERR7_WIDTH         1
#define XDCDMA_EIDR_DSCR_PRE_ERR7_MASK          0X00000008

#define XDCDMA_EIDR_DSCR_PRE_ERR6_SHIFT         2
#define XDCDMA_EIDR_DSCR_PRE_ERR6_WIDTH         1
#define XDCDMA_EIDR_DSCR_PRE_ERR6_MASK          0X00000004

#define XDCDMA_EIDR_DSCR_RD_AXI_ERR7_SHIFT      1
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR7_WIDTH      1
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR7_MASK       0X00000002

#define XDCDMA_EIDR_DSCR_RD_AXI_ERR6_SHIFT      0
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR6_WIDTH      1
#define XDCDMA_EIDR_DSCR_RD_AXI_ERR6_MASK       0X00000001

/**
 * Register: XDCDMA_CH6TOCH7_EITR
 */
#define XDCDMA_CH6TOCH7_EITR    0X00B4

#define XDCDMA_EITR_DSCR_DONE_ERR7_SHIFT        9
#define XDCDMA_EITR_DSCR_DONE_ERR7_WIDTH        1
#define XDCDMA_EITR_DSCR_DONE_ERR7_MASK         0X00000200

#define XDCDMA_EITR_DSCR_DONE_ERR6_SHIFT        8
#define XDCDMA_EITR_DSCR_DONE_ERR6_WIDTH        1
#define XDCDMA_EITR_DSCR_DONE_ERR6_MASK         0X00000100

#define XDCDMA_EITR_DSCR_WR_AXI_ERR7_SHIFT      7
#define XDCDMA_EITR_DSCR_WR_AXI_ERR7_WIDTH      1
#define XDCDMA_EITR_DSCR_WR_AXI_ERR7_MASK       0X00000080

#define XDCDMA_EITR_DSCR_WR_AXI_ERR6_SHIFT      6
#define XDCDMA_EITR_DSCR_WR_AXI_ERR6_WIDTH      1
#define XDCDMA_EITR_DSCR_WR_AXI_ERR6_MASK       0X00000040

#define XDCDMA_EITR_DSCR_CRC_ERR7_SHIFT         5
#define XDCDMA_EITR_DSCR_CRC_ERR7_WIDTH         1
#define XDCDMA_EITR_DSCR_CRC_ERR7_MASK          0X00000020

#define XDCDMA_EITR_DSCR_CRC_ERR6_SHIFT         4
#define XDCDMA_EITR_DSCR_CRC_ERR6_WIDTH         1
#define XDCDMA_EITR_DSCR_CRC_ERR6_MASK          0X00000010

#define XDCDMA_EITR_DSCR_PRE_ERR7_SHIFT         3
#define XDCDMA_EITR_DSCR_PRE_ERR7_WIDTH         1
#define XDCDMA_EITR_DSCR_PRE_ERR7_MASK          0X00000008

#define XDCDMA_EITR_DSCR_PRE_ERR6_SHIFT         2
#define XDCDMA_EITR_DSCR_PRE_ERR6_WIDTH         1
#define XDCDMA_EITR_DSCR_PRE_ERR6_MASK          0X00000004

#define XDCDMA_EITR_DSCR_RD_AXI_ERR7_SHIFT      1
#define XDCDMA_EITR_DSCR_RD_AXI_ERR7_WIDTH      1
#define XDCDMA_EITR_DSCR_RD_AXI_ERR7_MASK       0X00000002

#define XDCDMA_EITR_DSCR_RD_AXI_ERR6_SHIFT      0
#define XDCDMA_EITR_DSCR_RD_AXI_ERR6_WIDTH      1
#define XDCDMA_EITR_DSCR_RD_AXI_ERR6_MASK       0X00000001

/**
 * Register: XDCDMA_BRDY_CNT_EISR
 */
#define XDCDMA_BRDY_CNT_EISR    0X00C0

#define XDCDMA_EISR_CH7_OVRFLOW_SHIFT           7
#define XDCDMA_EISR_CH7_OVRFLOW_WIDTH           1
#define XDCDMA_EISR_CH7_OVRFLOW_MASK            0X00000080

#define XDCDMA_EISR_CH6_OVRFLOW_SHIFT           6
#define XDCDMA_EISR_CH6_OVRFLOW_WIDTH           1
#define XDCDMA_EISR_CH6_OVRFLOW_MASK            0X00000040

#define XDCDMA_EISR_CH5_OVRFLOW_SHIFT           5
#define XDCDMA_EISR_CH5_OVRFLOW_WIDTH           1
#define XDCDMA_EISR_CH5_OVRFLOW_MASK            0X00000020

#define XDCDMA_EISR_CH4_OVRFLOW_SHIFT           4
#define XDCDMA_EISR_CH4_OVRFLOW_WIDTH           1
#define XDCDMA_EISR_CH4_OVRFLOW_MASK            0X00000010

#define XDCDMA_EISR_CH3_OVRFLOW_SHIFT           3
#define XDCDMA_EISR_CH3_OVRFLOW_WIDTH           1
#define XDCDMA_EISR_CH3_OVRFLOW_MASK            0X00000008

#define XDCDMA_EISR_CH2_OVRFLOW_SHIFT           2
#define XDCDMA_EISR_CH2_OVRFLOW_WIDTH           1
#define XDCDMA_EISR_CH2_OVRFLOW_MASK            0X00000004

#define XDCDMA_EISR_CH1_OVRFLOW_SHIFT           1
#define XDCDMA_EISR_CH1_OVRFLOW_WIDTH           1
#define XDCDMA_EISR_CH1_OVRFLOW_MASK            0X00000002

#define XDCDMA_EISR_CH0_OVRFLOW_SHIFT           0
#define XDCDMA_EISR_CH0_OVRFLOW_WIDTH           1
#define XDCDMA_EISR_CH0_OVRFLOW_MASK            0X00000001

/**
 * Register: XDCDMA_BRDY_CNT_EIMR
 */
#define XDCDMA_BRDY_CNT_EIMR    0X00C4

#define XDCDMA_EIMR_CH7_OVRFLOW_SHIFT           7
#define XDCDMA_EIMR_CH7_OVRFLOW_WIDTH           1
#define XDCDMA_EIMR_CH7_OVRFLOW_MASK            0X00000080

#define XDCDMA_EIMR_CH6_OVRFLOW_SHIFT           6
#define XDCDMA_EIMR_CH6_OVRFLOW_WIDTH           1
#define XDCDMA_EIMR_CH6_OVRFLOW_MASK            0X00000040

#define XDCDMA_EIMR_CH5_OVRFLOW_SHIFT           5
#define XDCDMA_EIMR_CH5_OVRFLOW_WIDTH           1
#define XDCDMA_EIMR_CH5_OVRFLOW_MASK            0X00000020

#define XDCDMA_EIMR_CH4_OVRFLOW_SHIFT           4
#define XDCDMA_EIMR_CH4_OVRFLOW_WIDTH           1
#define XDCDMA_EIMR_CH4_OVRFLOW_MASK            0X00000010

#define XDCDMA_EIMR_CH3_OVRFLOW_SHIFT           3
#define XDCDMA_EIMR_CH3_OVRFLOW_WIDTH           1
#define XDCDMA_EIMR_CH3_OVRFLOW_MASK            0X00000008

#define XDCDMA_EIMR_CH2_OVRFLOW_SHIFT           2
#define XDCDMA_EIMR_CH2_OVRFLOW_WIDTH           1
#define XDCDMA_EIMR_CH2_OVRFLOW_MASK            0X00000004

#define XDCDMA_EIMR_CH1_OVRFLOW_SHIFT           1
#define XDCDMA_EIMR_CH1_OVRFLOW_WIDTH           1
#define XDCDMA_EIMR_CH1_OVRFLOW_MASK            0X00000002

#define XDCDMA_EIMR_CH0_OVRFLOW_SHIFT           0
#define XDCDMA_EIMR_CH0_OVRFLOW_WIDTH           1
#define XDCDMA_EIMR_CH0_OVRFLOW_MASK            0X00000001

/**
 * Register: XDCDMA_BRDY_CNT_EIER
 */
#define XDCDMA_BRDY_CNT_EIER    0X00C8

#define XDCDMA_EIER_CH7_OVRFLOW_SHIFT           7
#define XDCDMA_EIER_CH7_OVRFLOW_WIDTH           1
#define XDCDMA_EIER_CH7_OVRFLOW_MASK            0X00000080

#define XDCDMA_EIER_CH6_OVRFLOW_SHIFT           6
#define XDCDMA_EIER_CH6_OVRFLOW_WIDTH           1
#define XDCDMA_EIER_CH6_OVRFLOW_MASK            0X00000040

#define XDCDMA_EIER_CH5_OVRFLOW_SHIFT           5
#define XDCDMA_EIER_CH5_OVRFLOW_WIDTH           1
#define XDCDMA_EIER_CH5_OVRFLOW_MASK            0X00000020

#define XDCDMA_EIER_CH4_OVRFLOW_SHIFT           4
#define XDCDMA_EIER_CH4_OVRFLOW_WIDTH           1
#define XDCDMA_EIER_CH4_OVRFLOW_MASK            0X00000010

#define XDCDMA_EIER_CH3_OVRFLOW_SHIFT           3
#define XDCDMA_EIER_CH3_OVRFLOW_WIDTH           1
#define XDCDMA_EIER_CH3_OVRFLOW_MASK            0X00000008

#define XDCDMA_EIER_CH2_OVRFLOW_SHIFT           2
#define XDCDMA_EIER_CH2_OVRFLOW_WIDTH           1
#define XDCDMA_EIER_CH2_OVRFLOW_MASK            0X00000004

#define XDCDMA_EIER_CH1_OVRFLOW_SHIFT           1
#define XDCDMA_EIER_CH1_OVRFLOW_WIDTH           1
#define XDCDMA_EIER_CH1_OVRFLOW_MASK            0X00000002

#define XDCDMA_EIER_CH0_OVRFLOW_SHIFT           0
#define XDCDMA_EIER_CH0_OVRFLOW_WIDTH           1
#define XDCDMA_EIER_CH0_OVRFLOW_MASK            0X00000001

/**
 * Register: XDCDMA_BRDY_CNT_EIDR
 */
#define XDCDMA_BRDY_CNT_EIDR    0X00CC

#define XDCDMA_EIDR_CH7_OVRFLOW_SHIFT           7
#define XDCDMA_EIDR_CH7_OVRFLOW_WIDTH           1
#define XDCDMA_EIDR_CH7_OVRFLOW_MASK            0X00000080

#define XDCDMA_EIDR_CH6_OVRFLOW_SHIFT           6
#define XDCDMA_EIDR_CH6_OVRFLOW_WIDTH           1
#define XDCDMA_EIDR_CH6_OVRFLOW_MASK            0X00000040

#define XDCDMA_EIDR_CH5_OVRFLOW_SHIFT           5
#define XDCDMA_EIDR_CH5_OVRFLOW_WIDTH           1
#define XDCDMA_EIDR_CH5_OVRFLOW_MASK            0X00000020

#define XDCDMA_EIDR_CH4_OVRFLOW_SHIFT           4
#define XDCDMA_EIDR_CH4_OVRFLOW_WIDTH           1
#define XDCDMA_EIDR_CH4_OVRFLOW_MASK            0X00000010

#define XDCDMA_EIDR_CH3_OVRFLOW_SHIFT           3
#define XDCDMA_EIDR_CH3_OVRFLOW_WIDTH           1
#define XDCDMA_EIDR_CH3_OVRFLOW_MASK            0X00000008

#define XDCDMA_EIDR_CH2_OVRFLOW_SHIFT           2
#define XDCDMA_EIDR_CH2_OVRFLOW_WIDTH           1
#define XDCDMA_EIDR_CH2_OVRFLOW_MASK            0X00000004

#define XDCDMA_EIDR_CH1_OVRFLOW_SHIFT           1
#define XDCDMA_EIDR_CH1_OVRFLOW_WIDTH           1
#define XDCDMA_EIDR_CH1_OVRFLOW_MASK            0X00000002

#define XDCDMA_EIDR_CH0_OVRFLOW_SHIFT           0
#define XDCDMA_EIDR_CH0_OVRFLOW_WIDTH           1
#define XDCDMA_EIDR_CH0_OVRFLOW_MASK            0X00000001

/**
 * Register: XDCDMA_BRDY_CNT_EITR
 */
#define XDCDMA_BRDY_CNT_EITR    0X00D0

#define XDCDMA_EITR_CH7_OVRFLOW_SHIFT           7
#define XDCDMA_EITR_CH7_OVRFLOW_WIDTH           1
#define XDCDMA_EITR_CH7_OVRFLOW_MASK            0X00000080

#define XDCDMA_EITR_CH6_OVRFLOW_SHIFT           6
#define XDCDMA_EITR_CH6_OVRFLOW_WIDTH           1
#define XDCDMA_EITR_CH6_OVRFLOW_MASK            0X00000040

#define XDCDMA_EITR_CH5_OVRFLOW_SHIFT           5
#define XDCDMA_EITR_CH5_OVRFLOW_WIDTH           1
#define XDCDMA_EITR_CH5_OVRFLOW_MASK            0X00000020

#define XDCDMA_EITR_CH4_OVRFLOW_SHIFT           4
#define XDCDMA_EITR_CH4_OVRFLOW_WIDTH           1
#define XDCDMA_EITR_CH4_OVRFLOW_MASK            0X00000010

#define XDCDMA_EITR_CH3_OVRFLOW_SHIFT           3
#define XDCDMA_EITR_CH3_OVRFLOW_WIDTH           1
#define XDCDMA_EITR_CH3_OVRFLOW_MASK            0X00000008

#define XDCDMA_EITR_CH2_OVRFLOW_SHIFT           2
#define XDCDMA_EITR_CH2_OVRFLOW_WIDTH           1
#define XDCDMA_EITR_CH2_OVRFLOW_MASK            0X00000004

#define XDCDMA_EITR_CH1_OVRFLOW_SHIFT           1
#define XDCDMA_EITR_CH1_OVRFLOW_WIDTH           1
#define XDCDMA_EITR_CH1_OVRFLOW_MASK            0X00000002

#define XDCDMA_EITR_CH0_OVRFLOW_SHIFT           0
#define XDCDMA_EITR_CH0_OVRFLOW_WIDTH           1
#define XDCDMA_EITR_CH0_OVRFLOW_MASK            0X00000001

/**
 * Register: XDCDMA_AXI
 */
#define XDCDMA_AXI              0X0100

#define XDCDMA_AXI_CLKEN_FR_REG_SHIFT           1
#define XDCDMA_AXI_CLKEN_FR_REG_WIDTH           1
#define XDCDMA_AXI_CLKEN_FR_REG_MASK            0x00000002

#define XDCDMA_AXI_CLKEN_OVERRIDE_SHIFT         0
#define XDCDMA_AXI_CLKEN_OVERRIDE_WIDTH         1
#define XDCDMA_AXI_CLKEN_OVERRIDE_MASK          0x00000001

/**
 * Register: XDCDMA_GBL
 */
#define XDCDMA_GBL              0X0104

#define XDCDMA_GBL_RTRG_CH7_SHIFT                   15
#define XDCDMA_GBL_RTRG_CH7_WIDTH                   1
#define XDCDMA_GBL_RTRG_CH7_MASK                    0X00008000

#define XDCDMA_GBL_RTRG_CH6_SHIFT                   14
#define XDCDMA_GBL_RTRG_CH6_WIDTH                   1
#define XDCDMA_GBL_RTRG_CH6_MASK                    0X00004000

#define XDCDMA_GBL_RTRG_CH5_SHIFT                   13
#define XDCDMA_GBL_RTRG_CH5_WIDTH                   1
#define XDCDMA_GBL_RTRG_CH5_MASK                    0X00002000

#define XDCDMA_GBL_RTRG_CH4_SHIFT                   12
#define XDCDMA_GBL_RTRG_CH4_WIDTH                   1
#define XDCDMA_GBL_RTRG_CH4_MASK                    0X00001000

#define XDCDMA_GBL_RTRG_CH3_SHIFT                   11
#define XDCDMA_GBL_RTRG_CH3_WIDTH                   1
#define XDCDMA_GBL_RTRG_CH3_MASK                    0X00000800

#define XDCDMA_GBL_RTRG_CH2_SHIFT                   10
#define XDCDMA_GBL_RTRG_CH2_WIDTH                   1
#define XDCDMA_GBL_RTRG_CH2_MASK                    0X00000400

#define XDCDMA_GBL_RTRG_CH1_SHIFT                   9
#define XDCDMA_GBL_RTRG_CH1_WIDTH                   1
#define XDCDMA_GBL_RTRG_CH1_MASK                    0X00000200

#define XDCDMA_GBL_RTRG_CH0_SHIFT                   8
#define XDCDMA_GBL_RTRG_CH0_WIDTH                   1
#define XDCDMA_GBL_RTRG_CH0_MASK                    0X00000100

#define XDCDMA_GBL_TRG_CH7_SHIFT                    7
#define XDCDMA_GBL_TRG_CH7_WIDTH                    1
#define XDCDMA_GBL_TRG_CH7_MASK                     0X00000080

#define XDCDMA_GBL_TRG_CH6_SHIFT                    6
#define XDCDMA_GBL_TRG_CH6_WIDTH                    1
#define XDCDMA_GBL_TRG_CH6_MASK                     0X00000040

#define XDCDMA_GBL_TRG_CH5_SHIFT                    5
#define XDCDMA_GBL_TRG_CH5_WIDTH                    1
#define XDCDMA_GBL_TRG_CH5_MASK                     0X00000020

#define XDCDMA_GBL_TRG_CH4_SHIFT                    4
#define XDCDMA_GBL_TRG_CH4_WIDTH                    1
#define XDCDMA_GBL_TRG_CH4_MASK                     0X00000010

#define XDCDMA_GBL_TRG_CH3_SHIFT                    3
#define XDCDMA_GBL_TRG_CH3_WIDTH                    1
#define XDCDMA_GBL_TRG_CH3_MASK                     0X00000008

#define XDCDMA_GBL_TRG_CH2_SHIFT                    2
#define XDCDMA_GBL_TRG_CH2_WIDTH                    1
#define XDCDMA_GBL_TRG_CH2_MASK                     0X00000004

#define XDCDMA_GBL_TRG_CH1_SHIFT                    1
#define XDCDMA_GBL_TRG_CH1_WIDTH                    1
#define XDCDMA_GBL_TRG_CH1_MASK                     0X00000002

#define XDCDMA_GBL_TRG_CH0_SHIFT                    0
#define XDCDMA_GBL_TRG_CH0_WIDTH                    1
#define XDCDMA_GBL_TRG_CH0_MASK                     0X00000001

/**
 * Register: XDCDMA_ALC0_CNTL
 */
#define XDCDMA_ALC0_CNTL        0X0108

#define XDCDMA_ALC0_CNTL_MON_ID_SHIFT               2
#define XDCDMA_ALC0_CNTL_MON_ID_WIDTH               4
#define XDCDMA_ALC0_CNTL_MON_ID_MASK                0X0000003C

#define XDCDMA_ALC0_CNTL_CLEAR_SHIFT                1
#define XDCDMA_ALC0_CNTL_CLEAR_WIDTH                1
#define XDCDMA_ALC0_CNTL_CLEAR_MASK                 0X00000002

#define XDCDMA_ALC0_CNTL_EN_SHIFT                   0
#define XDCDMA_ALC0_CNTL_EN_WIDTH                   1
#define XDCDMA_ALC0_CNTL_EN_MASK                    0X00000001

/**
 * Register: XDCDMA_ALC0_STATUS
 */
#define XDCDMA_ALC0_STATUS      0X010C

#define XDCDMA_ALC0_STATUS_OFLOW_SHIFT              0
#define XDCDMA_ALC0_STATUS_OFLOW_WIDTH              1
#define XDCDMA_ALC0_STATUS_OFLOW_MASK               0X00000001

/**
 * Register: XDCDMA_ALC0_MAX
 */
#define XDCDMA_ALC0_MAX         0X0110

#define XDCDMA_ALC0_MAX_LATENCY_SHIFT               0
#define XDCDMA_ALC0_MAX_LATENCY_WIDTH               16
#define XDCDMA_ALC0_MAX_LATENCY_MASK                0X0000FFFF

/**
 * Register: XDCDMA_ALC0_MIN
 */
#define XDCDMA_ALC0_MIN         0X0114

#define XDCDMA_ALC0_MIN_LATENCY_SHIFT               0
#define XDCDMA_ALC0_MIN_LATENCY_WIDTH               16
#define XDCDMA_ALC0_MIN_LATENCY_MASK                0X0000FFFF

/**
 * Register: XDCDMA_ALC0_ACC
 */
#define XDCDMA_ALC0_ACC         0X0118

#define XDCDMA_ALC0_ACC_LATENCY_SHIFT               0
#define XDCDMA_ALC0_ACC_LATENCY_WIDTH               32
#define XDCDMA_ALC0_ACC_LATENCY_MASK                0XFFFFFFFF

/**
 * Register: XDCDMA_ALC0_ACC_TRAN
 */
#define XDCDMA_ALC0_ACC_TRAN    0X011C

#define XDCDMA_ALC0_ACC_TRAN_COUNT_SHIFT            0
#define XDCDMA_ALC0_ACC_TRAN_COUNT_WIDTH            32
#define XDCDMA_ALC0_ACC_TRAN_COUNT_MASK             0XFFFFFFFF

/**
 * Register: XDCDMA_ALC1_CNTL
 */
#define XDCDMA_ALC1_CNTL        0X0120

#define XDCDMA_ALC1_CNTL_MON_ID_SHIFT               2
#define XDCDMA_ALC1_CNTL_MON_ID_WIDTH               4
#define XDCDMA_ALC1_CNTL_MON_ID_MASK                0X0000003C

#define XDCDMA_ALC1_CNTL_CLEAR_SHIFT                1
#define XDCDMA_ALC1_CNTL_CLEAR_WIDTH                1
#define XDCDMA_ALC1_CNTL_CLEAR_MASK                 0X00000002

#define XDCDMA_ALC1_CNTL_EN_SHIFT                   0
#define XDCDMA_ALC1_CNTL_EN_WIDTH                   1
#define XDCDMA_ALC1_CNTL_EN_MASK                    0X00000001

/**
 * Register: XDCDMA_ALC1_STATUS
 */
#define XDCDMA_ALC1_STATUS      0X0124

#define XDCDMA_ALC1_STATUS_OFLOW_SHIFT              0
#define XDCDMA_ALC1_STATUS_OFLOW_WIDTH              1
#define XDCDMA_ALC1_STATUS_OFLOW_MASK               0X00000001

/**
 * Register: XDCDMA_ALC1_MAX
 */
#define XDCDMA_ALC1_MAX         0X0128

#define XDCDMA_ALC1_MAX_LATENCY_SHIFT               0
#define XDCDMA_ALC1_MAX_LATENCY_WIDTH               16
#define XDCDMA_ALC1_MAX_LATENCY_MASK                0X0000FFFF

/**
 * Register: XDCDMA_ALC1_MIN
 */
#define XDCDMA_ALC1_MIN         0X012C

#define XDCDMA_ALC1_MIN_LATENCY_SHIFT               0
#define XDCDMA_ALC1_MIN_LATENCY_WIDTH               16
#define XDCDMA_ALC1_MIN_LATENCY_MASK                0X0000FFFF

/**
 * Register: XDCDMA_ALC1_ACC
 */
#define XDCDMA_ALC1_ACC         0X0130

#define XDCDMA_ALC1_ACC_LATENCY_SHIFT               0
#define XDCDMA_ALC1_ACC_LATENCY_WIDTH               32
#define XDCDMA_ALC1_ACC_LATENCY_MASK                0XFFFFFFFF

/**
 * Register: XDCDMA_ALC1_ACC_TRAN
 */
#define XDCDMA_ALC1_ACC_TRAN    0X0134

#define XDCDMA_ALC1_ACC_TRAN_COUNT_SHIFT            0
#define XDCDMA_ALC1_ACC_TRAN_COUNT_WIDTH            32
#define XDCDMA_ALC1_ACC_TRAN_COUNT_MASK             0XFFFFFFFF

/**
 * Register: XDCDMA_TLB_PREF_USE
 */
#define XDCDMA_TLB_PREF_USE     0X0138

#define XDCDMA_TLB_PREF_USE_TYPE_SHIFT              0
#define XDCDMA_TLB_PREF_USE_TYPE_WIDTH              8
#define XDCDMA_TLB_PREF_USE_TYPE_MASK               0X000000FF

/**
 * Register: XDCDMA_CH0_DSCR_STRT_ADDRE
 */
#define XDCDMA_CH0_DSCR_STRT_ADDRE  0X0200

/**
 * Register: XDCDMA_CH0_DSCR_STRT_ADDR
 */
#define XDCDMA_CH0_DSCR_STRT_ADDR   0X0204

/**
 * Register: XDCDMA_CH0_DSCR_NEXT_ADDRE
 */
#define XDCDMA_CH0_DSCR_NEXT_ADDRE  0X0208

/**
 * Register: XDCDMA_CH0_DSCR_NEXT_ADDR
 */
#define XDCDMA_CH0_DSCR_NEXT_ADDR   0X020C

/**
 * Register: XDCDMA_CH0_PYLD_CUR_ADDRE
 */
#define XDCDMA_CH0_PYLD_CUR_ADDRE   0X0210

/**
 * Register: XDCDMA_CH0_PYLD_CUR_ADDR
 */
#define XDCDMA_CH0_PYLD_CUR_ADDR    0X0214

/**
 * Register: XDCDMA_CH0_CNTL
 */
#define XDCDMA_CH0_CNTL         0X0218

/**
 * Register: XDCDMA_CH0_STATUS
 */
#define XDCDMA_CH0_STATUS       0X021C

/**
 * Register: XDCDMA_CH0_LINE_SZ
 */
#define XDCDMA_CH0_LINE_SZ      0X0220

/**
 * Register: XDCDMA_CH0_TILE_SZ
 */
#define XDCDMA_CH0_TILE_SZ      0X0224

/**
 * Register: XDCDMA_CH0_TLB_PREF_BLK
 */
#define XDCDMA_CH0_TLB_PREF_BLK     0X0228

/**
 * Register: XDCDMA_CH0_PYLD_SZ
 */
#define XDCDMA_CH0_PYLD_SZ      0X022C

/**
 * Register: XDCDMA_CH0_DSCR_ID
 */
#define XDCDMA_CH0_DSCR_ID      0X0230

/**
 * Register: XDCDMA_CH1_DSCR_STRT_ADDRE
 */
#define XDCDMA_CH1_DSCR_STRT_ADDRE  0X0300

/**
 * Register: XDCDMA_CH1_DSCR_STRT_ADDR
 */
#define XDCDMA_CH1_DSCR_STRT_ADDR   0X0304

/**
 * Register: XDCDMA_CH1_DSCR_NEXT_ADDRE
 */
#define XDCDMA_CH1_DSCR_NEXT_ADDRE  0X0308

/**
 * Register: XDCDMA_CH1_DSCR_NEXT_ADDR
 */
#define XDCDMA_CH1_DSCR_NEXT_ADDR   0X030C

/**
 * Register: XDCDMA_CH1_PYLD_CUR_ADDRE
 */
#define XDCDMA_CH1_PYLD_CUR_ADDRE   0X0310

/**
 * Register: XDCDMA_CH1_PYLD_CUR_ADDR
 */
#define XDCDMA_CH1_PYLD_CUR_ADDR    0X0314

/**
 * Register: XDCDMA_CH1_CNTL
 */
#define XDCDMA_CH1_CNTL         0X0318

/**
 * Register: XDCDMA_CH1_STATUS
 */
#define XDCDMA_CH1_STATUS       0X031C

/**
 * Register: XDCDMA_CH1_LINE_SZ
 */
#define XDCDMA_CH1_LINE_SZ      0X0320

/**
 * Register: XDCDMA_CH1_TILE_SZ
 */
#define XDCDMA_CH1_TILE_SZ      0X0324

/**
 * Register: XDCDMA_CH1_TLB_PREF_BLK
 */
#define XDCDMA_CH1_TLB_PREF_BLK     0X0328

/**
 * Register: XDCDMA_CH1_PYLD_SZ
 */
#define XDCDMA_CH1_PYLD_SZ      0X032C

/**
 * Register: XDCDMA_CH1_DSCR_ID
 */
#define XDCDMA_CH1_DSCR_ID      0X0330

/**
 * Register: XDCDMA_CH2_DSCR_STRT_ADDRE
 */
#define XDCDMA_CH2_DSCR_STRT_ADDRE  0X0400

/**
 * Register: XDCDMA_CH2_DSCR_STRT_ADDR
 */
#define XDCDMA_CH2_DSCR_STRT_ADDR   0X0404

/**
 * Register: XDCDMA_CH2_DSCR_NEXT_ADDRE
 */
#define XDCDMA_CH2_DSCR_NEXT_ADDRE  0X0408

/**
 * Register: XDCDMA_CH2_DSCR_NEXT_ADDR
 */
#define XDCDMA_CH2_DSCR_NEXT_ADDR   0X040C

/**
 * Register: XDCDMA_CH2_PYLD_CUR_ADDRE
 */
#define XDCDMA_CH2_PYLD_CUR_ADDRE   0X0410

/**
 * Register: XDCDMA_CH2_PYLD_CUR_ADDR
 */
#define XDCDMA_CH2_PYLD_CUR_ADDR    0X0414

/**
 * Register: XDCDMA_CH2_CNTL
 */
#define XDCDMA_CH2_CNTL         0X0418

/**
 * Register: XDCDMA_CH2_STATUS
 */
#define XDCDMA_CH2_STATUS       0X041C

/**
 * Register: XDCDMA_CH2_LINE_SZ
 */
#define XDCDMA_CH2_LINE_SZ      0X0420

/**
 * Register: XDCDMA_CH2_TILE_SZ
 */
#define XDCDMA_CH2_TILE_SZ      0X0424

/**
 * Register: XDCDMA_CH2_TLB_PREF_BLK
 */
#define XDCDMA_CH2_TLB_PREF_BLK     0X0428

/**
 * Register: XDCDMA_CH2_PYLD_SZ
 */
#define XDCDMA_CH2_PYLD_SZ      0X042C

/**
 * Register: XDCDMA_CH2_DSCR_ID
 */
#define XDCDMA_CH2_DSCR_ID      0X0430

/**
 * Register: XDCDMA_CH3_DSCR_STRT_ADDRE
 */
#define XDCDMA_CH3_DSCR_STRT_ADDRE  0X0500

/**
 * Register: XDCDMA_CH3_DSCR_STRT_ADDR
 */
#define XDCDMA_CH3_DSCR_STRT_ADDR   0X0504

/**
 * Register: XDCDMA_CH3_DSCR_NEXT_ADDRE
 */
#define XDCDMA_CH3_DSCR_NEXT_ADDRE  0X0508

/**
 * Register: XDCDMA_CH3_DSCR_NEXT_ADDR
 */
#define XDCDMA_CH3_DSCR_NEXT_ADDR   0X050C

/**
 * Register: XDCDMA_CH3_PYLD_CUR_ADDRE
 */
#define XDCDMA_CH3_PYLD_CUR_ADDRE   0X0510

/**
 * Register: XDCDMA_CH3_PYLD_CUR_ADDR
 */
#define XDCDMA_CH3_PYLD_CUR_ADDR    0X0514

/**
 * Register: XDCDMA_CH3_CNTL
 */
#define XDCDMA_CH3_CNTL         0X0518

/**
 * Register: XDCDMA_CH3_STATUS
 */
#define XDCDMA_CH3_STATUS       0X051C

/**
 * Register: XDCDMA_CH3_LINE_SZ
 */
#define XDCDMA_CH3_LINE_SZ      0X0520

/**
 * Register: XDCDMA_CH3_TILE_SZ
 */
#define XDCDMA_CH3_TILE_SZ      0X0524

/**
 * Register: XDCDMA_CH3_TLB_PREF_BLK
 */
#define XDCDMA_CH3_TLB_PREF_BLK     0X0528

/**
 * Register: XDCDMA_CH3_PYLD_SZ
 */
#define XDCDMA_CH3_PYLD_SZ      0X052C

/**
 * Register: XDCDMA_CH3_DSCR_ID
 */
#define XDCDMA_CH3_DSCR_ID      0X0530

/**
 * Register: XDCDMA_CH4_DSCR_STRT_ADDRE
 */
#define XDCDMA_CH4_DSCR_STRT_ADDRE  0X0600

/**
 * Register: XDCDMA_CH4_DSCR_STRT_ADDR
 */
#define XDCDMA_CH4_DSCR_STRT_ADDR   0X0604

/**
 * Register: XDCDMA_CH4_DSCR_NEXT_ADDRE
 */
#define XDCDMA_CH4_DSCR_NEXT_ADDRE  0X0608

/**
 * Register: XDCDMA_CH4_DSCR_NEXT_ADDR
 */
#define XDCDMA_CH4_DSCR_NEXT_ADDR   0X060C

/**
 * Register: XDCDMA_CH4_PYLD_CUR_ADDRE
 */
#define XDCDMA_CH4_PYLD_CUR_ADDRE   0X0610

/**
 * Register: XDCDMA_CH4_PYLD_CUR_ADDRE
 */
#define XDCDMA_CH4_PYLD_CUR_ADDR    0X0614

/**
 * Register: XDCDMA_CH4_CNTL
 */
#define XDCDMA_CH4_CNTL         0X0618

/**
 * Register: XDCDMA_CH4_STATUS
 */
#define XDCDMA_CH4_STATUS       0X061C

/**
 * Register: XDCDMA_CH4_LINE_SZ
 */
#define XDCDMA_CH4_LINE_SZ      0X0620

/**
 * Register: XDCDMA_CH4_TILE_SZ
 */
#define XDCDMA_CH4_TILE_SZ      0X0624

/**
 * Register: XDCDMA_CH4_TLB_PREF_BLK
 */
#define XDCDMA_CH4_TLB_PREF_BLK     0X0628

/**
 * Register: XDCDMA_CH4_PYLD_SZ
 */
#define XDCDMA_CH4_PYLD_SZ      0X062C

/**
 * Register: XDCDMA_CH4_DSCR_ID
 */
#define XDCDMA_CH4_DSCR_ID      0X0630

/**
 * Register: XDCDMA_CH5_DSCR_STRT_ADDRE
 */
#define XDCDMA_CH5_DSCR_STRT_ADDRE  0X0700

/**
 * Register: XDCDMA_CH5_DSCR_STRT_ADDR
 */
#define XDCDMA_CH5_DSCR_STRT_ADDR   0X0704

/**
 * Register: XDCDMA_CH5_DSCR_NEXT_ADDRE
 */
#define XDCDMA_CH5_DSCR_NEXT_ADDRE  0X0708

/**
 * Register: XDCDMA_CH5_DSCR_NEXT_ADDR
 */
#define XDCDMA_CH5_DSCR_NEXT_ADDR   0X070C

/**
 * Register: XDCDMA_CH5_PYLD_CUR_ADDRE
 */
#define XDCDMA_CH5_PYLD_CUR_ADDRE   0X0710

/**
 * Register: XDCDMA_CH5_PYLD_CUR_ADDR
 */
#define XDCDMA_CH5_PYLD_CUR_ADDR    0X0714

/**
 * Register: XDCDMA_CH5_CNTL
 */
#define XDCDMA_CH5_CNTL         0X0718

/**
 * Register: XDCDMA_CH5_STATUS
 */
#define XDCDMA_CH5_STATUS       0X071C

/**
 * Register: XDCDMA_CH5_LINE_SZ
 */
#define XDCDMA_CH5_LINE_SZ      0X0720

/**
 * Register: XDCDMA_CH5_TILE_SZ
 */
#define XDCDMA_CH5_TILE_SZ      0X0724

/**
 * Register: XDCDMA_CH5_TLB_PREF_BLK
 */
#define XDCDMA_CH5_TLB_PREF_BLK     0X0728

/**
 * Register: XDCDMA_CH5_PYLD_SZ
 */
#define XDCDMA_CH5_PYLD_SZ      0X072C

/**
 * Register: XDCDMA_CH5_DSCR_ID
 */
#define XDCDMA_CH5_DSCR_ID      0X0730

/**
 * Register: XDCDMA_CH6_DSCR_STRT_ADDRE
 */
#define XDCDMA_CH6_DSCR_STRT_ADDRE  0X0800

/**
 * Register: XDCDMA_CH6_DSCR_STRT_ADDR
 */
#define XDCDMA_CH6_DSCR_STRT_ADDR   0X0804

/**
 * Register: XDCDMA_CH6_DSCR_NEXT_ADDRE
 */
#define XDCDMA_CH6_DSCR_NEXT_ADDRE  0X0808

/**
 * Register: XDCDMA_CH6_DSCR_NEXT_ADDRE
 */
#define XDCDMA_CH6_DSCR_NEXT_ADDR   0X080C

/**
 * Register: XDCDMA_CH6_PYLD_CUR_ADDRE
 */
#define XDCDMA_CH6_PYLD_CUR_ADDRE   0X0810

/**
 * Register: XDCDMA_CH6_PYLD_CUR_ADDR
 */
#define XDCDMA_CH6_PYLD_CUR_ADDR    0X0814

/**
 * Register: XDCDMA_CH6_CNTL
 */
#define XDCDMA_CH6_CNTL         0X0818

/**
 * Register: XDCDMA_CH6_STATUS
 */
#define XDCDMA_CH6_STATUS       0X081C

/**
 * Register: XDCDMA_CH6_TLB_PREF_BLK
 */
#define XDCDMA_CH6_TLB_PREF_BLK     0X0828

/**
 * Register: XDCDMA_CH6_PYLD_SZ
 */
#define XDCDMA_CH6_PYLD_SZ      0X082C

/**
 * Register: XDCDMA_CH6_DSCR_ID
 */
#define XDCDMA_CH6_DSCR_ID      0X0830

/**
 * Register: XDCDMA_CH7_DSCR_STRT_ADDRE
 */
#define XDCDMA_CH7_DSCR_STRT_ADDRE  0X0900

/**
 * Register: XDCDMA_CH7_DSCR_STRT_ADDR
 */
#define XDCDMA_CH7_DSCR_STRT_ADDR   0X0904

/**
 * Register: XDCDMA_CH7_DSCR_NEXT_ADDRE
 */
#define XDCDMA_CH7_DSCR_NEXT_ADDRE  0X0908

/**
 * Register: XDCDMA_CH7_DSCR_NEXT_ADDR
 */
#define XDCDMA_CH7_DSCR_NEXT_ADDR   0X090C

/**
 * Register: XDCDMA_CH7_PYLD_CUR_ADDRE
 */
#define XDCDMA_CH7_PYLD_CUR_ADDRE   0X0910

/**
 * Register: XDCDMA_CH7_PYLD_CUR_ADDR
 */
#define XDCDMA_CH7_PYLD_CUR_ADDR    0X0914

/**
 * Register: XDCDMA_CH7_CNTL
 */
#define XDCDMA_CH7_CNTL         0X0918

/**
 * Register: XDCDMA_CH7_STATUS
 */
#define XDCDMA_CH7_STATUS       0X091C

/**
 * Register: XDCDMA_CH7_TLB_PREF_BLK
 */
#define XDCDMA_CH7_TLB_PREF_BLK     0X0928

/**
 * Register: XDCDMA_CH7_PYLD_SZ
 */
#define XDCDMA_CH7_PYLD_SZ      0X092C

/**
 * Register: XDCDMA_CH7_DSCR_ID
 */
#define XDCDMA_CH7_DSCR_ID      0X0930

/**
 * DCDMA_CH DESCRIPTOR REGISTER FIELDS
 */
#define XDCDMA_CH_DSCR_STRT_ADDRE_MSB_SHIFT		    0
#define XDCDMA_CH_DSCR_STRT_ADDRE_MSB_WIDTH		    16
#define XDCDMA_CH_DSCR_STRT_ADDRE_MSB_MASK		    0XFFFF

#define XDCDMA_CH_DSCR_STRT_ADDR_LSB_SHIFT		    0
#define XDCDMA_CH_DSCR_STRT_ADDR_LSB_WIDTH		    32
#define XDCDMA_CH_DSCR_STRT_ADDR_LSB_MASK		    0XFFFFFFFFU

#define XDCDMA_CH_DSCR_NEXT_ADDRE_MSB_SHIFT		    0
#define XDCDMA_CH_DSCR_NEXT_ADDRE_MSB_WIDTH		    16
#define XDCDMA_CH_DSCR_NEXT_ADDRE_MSB_MASK		    0XFFFF

#define XDCDMA_CH_DSCR_NEXT_ADDR_LSB_SHIFT		    0
#define XDCDMA_CH_DSCR_NEXT_ADDR_LSB_WIDTH		    32
#define XDCDMA_CH_DSCR_NEXT_ADDR_LSB_MASK		    0XFFFFFFFFU

#define XDCDMA_CH_PYLD_CUR_ADDRE_MSB_SHIFT		    0
#define XDCDMA_CH_PYLD_CUR_ADDRE_MSB_WIDTH		    16
#define XDCDMA_CH_PYLD_CUR_ADDRE_MSB_MASK		    0XFFFF

#define XDCDMA_CH_PYLD_CUR_ADDR_LSB_SHIFT		    0
#define XDCDMA_CH_PYLD_CUR_ADDR_LSB_WIDTH		    32
#define XDCDMA_CH_PYLD_CUR_ADDR_LSB_MASK		    0XFFFFFFFFU

#define XDCDMA_CH_CNTL_DSCR_DLY_CNT_SHIFT           20
#define XDCDMA_CH_CNTL_DSCR_DLY_CNT_WIDTH           10
#define XDCDMA_CH_CNTL_DSCR_DLY_CNT_MASK            0X3FF00000

#define XDCDMA_CH_CNTL_DSCR_AXCACHE_SHIFT           16
#define XDCDMA_CH_CNTL_DSCR_AXCACHE_WIDTH           4
#define XDCDMA_CH_CNTL_DSCR_AXCACHE_MASK            0X000F0000

#define XDCDMA_CH_CNTL_DSCR_AXPROT_SHIFT            14
#define XDCDMA_CH_CNTL_DSCR_AXPROT_WIDTH            2
#define XDCDMA_CH_CNTL_DSCR_AXPROT_MASK             0X0000C000

#define XDCDMA_CH_CNTL_QOS_DATA_RD_SHIFT            10
#define XDCDMA_CH_CNTL_QOS_DATA_RD_WIDTH            4
#define XDCDMA_CH_CNTL_QOS_DATA_RD_MASK             0X00003C00

#define XDCDMA_CH_CNTL_QOS_DSCR_RD_SHIFT            6
#define XDCDMA_CH_CNTL_QOS_DSCR_RD_WIDTH            4
#define XDCDMA_CH_CNTL_QOS_DSCR_RD_MASK             0X000003C0

#define XDCDMA_CH_CNTL_QOS_DSCR_WR_SHIFT            2
#define XDCDMA_CH_CNTL_QOS_DSCR_WR_WIDTH            4
#define XDCDMA_CH_CNTL_QOS_DSCR_WR_MASK             0X0000003C

#define XDCDMA_CH_CNTL_PAUSE_SHIFT                  1
#define XDCDMA_CH_CNTL_PAUSE_WIDTH                  1
#define XDCDMA_CH_CNTL_PAUSE_MASK                   0X00000002

#define XDCDMA_CH_CNTL_EN_SHIFT                     0
#define XDCDMA_CH_CNTL_EN_WIDTH                     1
#define XDCDMA_CH_CNTL_EN_MASK                      0X00000001

#define XDCDMA_CH_STATUS_TLB_PREFETCH_EN_SHIFT      29
#define XDCDMA_CH_STATUS_TLB_PREFETCH_EN_WIDTH      1
#define XDCDMA_CH_STATUS_TLB_PREFETCH_EN_MASK       0X20000000

#define XDCDMA_CH_STATUS_OTRAN_CNT_SHIFT            20
#define XDCDMA_CH_STATUS_OTRAN_CNT_WIDTH            9
#define XDCDMA_CH_STATUS_OTRAN_CNT_MASK             0X1FF00000

#define XDCDMA_CH_STATUS_PREAMBLE_SHIFT             12
#define XDCDMA_CH_STATUS_PREAMBLE_WIDTH             8
#define XDCDMA_CH_STATUS_PREAMBLE_MASK              0X000FF000

#define XDCDMA_CH_STATUS_EN_DSCR_INTR_SHIFT         11
#define XDCDMA_CH_STATUS_EN_DSCR_INTR_WIDTH         1
#define XDCDMA_CH_STATUS_EN_DSCR_INTR_MASK          0X00000800

#define XDCDMA_CH_STATUS_EN_DSCR_UP_SHIFT           10
#define XDCDMA_CH_STATUS_EN_DSCR_UP_WIDTH           1
#define XDCDMA_CH_STATUS_EN_DSCR_UP_MASK            0X00000400

#define XDCDMA_CH_STATUS_DSCR_DONE_SHIFT            9
#define XDCDMA_CH_STATUS_DSCR_DONE_WIDTH            1
#define XDCDMA_CH_STATUS_DSCR_DONE_MASK             0X00000200

#define XDCDMA_CH_STATUS_IGNR_DONE_SHIFT            8
#define XDCDMA_CH_STATUS_IGNR_DONE_WIDTH            1
#define XDCDMA_CH_STATUS_IGNR_DONE_MASK             0X00000100

#define XDCDMA_CH_STATUS_LDSCR_FRAME_SHIFT          7
#define XDCDMA_CH_STATUS_LDSCR_FRAME_WIDTH          1
#define XDCDMA_CH_STATUS_LDSCR_FRAME_MASK           0X00000080

#define XDCDMA_CH_STATUS_LAST_DSCR_SHIFT            6
#define XDCDMA_CH_STATUS_LAST_DSCR_WIDTH            1
#define XDCDMA_CH_STATUS_LAST_DSCR_MASK             0X00000040

#define XDCDMA_CH_STATUS_EN_CRC_SHIFT               5
#define XDCDMA_CH_STATUS_EN_CRC_WIDTH               1
#define XDCDMA_CH_STATUS_EN_CRC_MASK                0X00000020

#define XDCDMA_CH_STATUS_BURST_TYPE_SHIFT           4
#define XDCDMA_CH_STATUS_BURST_TYPE_WIDTH           1
#define XDCDMA_CH_STATUS_BURST_TYPE_MASK            0X00000010

#define XDCDMA_CH_STATUS_BURST_LEN_SHIFT            0
#define XDCDMA_CH_STATUS_BURST_LEN_WIDTH            4
#define XDCDMA_CH_STATUS_BURST_LEN_MASK             0X0000000F

#define XDCDMA_CH_LINE_SZ_LENGTH_SHIFT              14
#define XDCDMA_CH_LINE_SZ_LENGTH_WIDTH              18
#define XDCDMA_CH_LINE_SZ_LENGTH_MASK               0XFFFFC000

#define XDCDMA_CH_LINE_SZ_STRIDE_SHIFT              0
#define XDCDMA_CH_LINE_SZ_STRIDE_WIDTH              14
#define XDCDMA_CH_LINE_SZ_STRIDE_MASK               0X00003FFF

#define XDCDMA_CH_TILE_SZ_PITCH_SHIFT               16
#define XDCDMA_CH_TILE_SZ_PITCH_WIDTH               14
#define XDCDMA_CH_TILE_SZ_PITCH_MASK                0X3FFF0000

#define XDCDMA_CH_TILE_SZ_TILE_TYPE_SHIFT           1
#define XDCDMA_CH_TILE_SZ_TILE_TYPE_WIDTH           1
#define XDCDMA_CH_TILE_SZ_TILE_TYPE_MASK            0X00000002

#define XDCDMA_CH_TILE_SZ_LINE_OR_TILE_SHIFT        0
#define XDCDMA_CH_TILE_SZ_LINE_OR_TILE_WIDTH        1
#define XDCDMA_CH_TILE_SZ_LINE_OR_TILE_MASK         0X00000001

#define XDCDMA_CH_TLB_PREF_BLK_OFFSET_SHIFT         14
#define XDCDMA_CH_TLB_PREF_BLK_OFFSET_WIDTH         14
#define XDCDMA_CH_TLB_PREF_BLK_OFFSET_MASK          0X0FFFC000

#define XDCDMA_CH_TLB_PREF_BLK_SIZE_SHIFT           0
#define XDCDMA_CH_TLB_PREF_BLK_SIZE_WIDTH           14
#define XDCDMA_CH_TLB_PREF_BLK_SIZE_MASK            0X00003FFF

#define XDCDMA_CH_PYLD_SZ_BYTE_SHIFT			    0
#define XDCDMA_CH_PYLD_SZ_BYTE_WIDTH			    32
#define XDCDMA_CH_PYLD_SZ_BYTE_MASK			        0XFFFFFFFFU

#define XDCDMA_CH_DSCR_ID_VAL_SHIFT			        0
#define XDCDMA_CH_DSCR_ID_VAL_WIDTH			        16
#define XDCDMA_CH_DSCR_ID_VAL_MASK			        0XFFFF

/**
 * Register: XDCDMA_DBG_CNTL
 */
#define XDCDMA_DBG_CNTL         0X0C00

#define XDCDMA_DBG_CNTL_DATA_SEL_SHIFT              8
#define XDCDMA_DBG_CNTL_DATA_SEL_WIDTH              1
#define XDCDMA_DBG_CNTL_DATA_SEL_MASK               0X00000100

#define XDCDMA_DBG_CNTL_RST_N_SHIFT                 7
#define XDCDMA_DBG_CNTL_RST_N_WIDTH                 1
#define XDCDMA_DBG_CNTL_RST_N_MASK                  0X00000080

#define XDCDMA_DBG_CNTL_MODE_SHIFT                  5
#define XDCDMA_DBG_CNTL_MODE_WIDTH                  2
#define XDCDMA_DBG_CNTL_MODE_MASK                   0X00000060

#define XDCDMA_DBG_CNTL_CLKDIV_SHIFT                3
#define XDCDMA_DBG_CNTL_CLKDIV_WIDTH                2
#define XDCDMA_DBG_CNTL_CLKDIV_MASK                 0X00000018

#define XDCDMA_DBG_CNTL_CLK_EN_SHIFT                2
#define XDCDMA_DBG_CNTL_CLK_EN_WIDTH                1
#define XDCDMA_DBG_CNTL_CLK_EN_MASK                 0X00000004

#define XDCDMA_DBG_CNTL_CDC_SHIFT                   1
#define XDCDMA_DBG_CNTL_CDC_WIDTH                   1
#define XDCDMA_DBG_CNTL_CDC_MASK                    0X00000002

#define XDCDMA_DBG_CNTL_EN_SHIFT                    0
#define XDCDMA_DBG_CNTL_EN_WIDTH                    1
#define XDCDMA_DBG_CNTL_EN_MASK                     0X00000001

/**
 * Register: XDCDMA_DBG_STATUS
 */
#define XDCDMA_DBG_STATUS       		    0X0C04

#define XDCDMA_DBG_STATUS_FIFO_EMPTY_SHIFT          1
#define XDCDMA_DBG_STATUS_FIFO_EMPTY_WIDTH          1
#define XDCDMA_DBG_STATUS_FIFO_EMPTY_MASK           0X00000002

#define XDCDMA_DBG_STATUS_FIFO_FULL_SHIFT           0
#define XDCDMA_DBG_STATUS_FIFO_FULL_WIDTH           1
#define XDCDMA_DBG_STATUS_FIFO_FULL_MASK            0X00000001

/**
 * Register: XDCDMA_ECO
 */
#define XDCDMA_ECO              0X0FFC

#define XDCDMA_ECO_VAL_SHIFT	0
#define XDCDMA_ECO_VAL_WIDTH	32
#define XDCDMA_ECO_VAL_MASK	0XFFFFFFFF

/******************* Macros (Inline Functions) Definitions ********************/

/** @name Register access macro definitions.
  * @{
  */
#define XDcDma_In32 Xil_In32
#define XDcDma_Out32 Xil_Out32
/* @} */

/******************************************************************************/
/**
 * This is a low-level function that reads from the specified register.
 *
 * @param       BaseAddress is the base address of the device.
 * @param       RegOffset is the register offset to be read from.
 *
 * @return      The 32-bit value of the specified register.
 *
 * @note        C-style signature:
 *              u32 XDcDma_ReadReg(u32 BaseAddress, u32 RegOffset
 *
*******************************************************************************/
#define XDcDma_ReadReg(BaseAddress, RegOffset) \
	XDc_In32((BaseAddress) + (RegOffset))

/******************************************************************************/
/**
 * This is a low-level function that writes to the specified register.
 *
 * @param       BaseAddress is the base address of the device.
 * @param       RegOffset is the register offset to write to.
 * @param       Data is the 32-bit data to write to the specified register.
 *
 * @return      None.
 *
 * @note        C-style signature:
 *              void XDcDma_WriteReg(u32 BaseAddress, u32 RegOffset, u32 Data)
 *
*******************************************************************************/
#define XDcDma_WriteReg(BaseAddress, RegOffset, Data) \
	XDcDma_Out32((BaseAddress) + (RegOffset), (Data))

/******************************************************************************/
/**
 * This is a low-level function that writes to the specified register.
 *
 * @param	BaseAddress is the base address of the device.
 * @param	RegOffset is the register offset to write to.
 * @param	Data is the 32-bit data to write to the specified register.
 * @param	Mask is the 32-bit field to which data is to be written
 *
 * @return	None.
 *
 * @note	C-style signature:
 *		void XDcDma_ReadModifyWrite(u32 BaseAddress,
 *							u32 RegOffset, u32 Data)
 *
*******************************************************************************/
#define XDcDma_ReadModifyWrite(BaseAddress, RegOffset, Data, Mask) \
	XDcDma_WriteReg((BaseAddress), (RegOffset), \
			((XDcDma_ReadReg(BaseAddress, RegOffset) &  \
			  ~(Mask)) | Data))

#ifdef __cplusplus
}
#endif

#endif /* __XDCDMA_HW_H__ */
