/******************************************************************************
* Copyright (C) 2011 - 2020 Xilinx, Inc.  All rights reserved.
* Copyright (C) 2022 - 2023 Advanced Micro Devices, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************
**
* @file xaxipcie_sinit.c
* @addtogroup axipcie Overview
* @{
*
* This file contains the implementation of AXI PCIe driver's static
* initialization functionality.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who  Date     Changes
* ----- ---- -------- ---------------------------------------------------
* 1.00a rkv  03/03/11  Original code.
*
* </pre>
*
******************************************************************************/

/****************************** Include Files ********************************/

#include "xparameters.h"
#include "xaxipcie.h"

/*************************** Constant Definitions ****************************/

/***************************** Type Definitions ******************************/

/****************** Macros (Inline Functions) Definitions ********************/

/*************************** Variable Definitions ****************************/

extern XAxiPcie_Config XAxiPcie_ConfigTable[];

/*************************** Function Prototypes *****************************/

/*****************************************************************************/
/**
* Lookup the device configuration based on the unique device ID.  The table
* ConfigTable contains the configuration info for each device in the system.
*
* @param 	DeviceId is the device identifier to lookup.
*
* @return
* 		- XAxiPcie configuration structure pointer if DeviceID is
*		found.
* 		- NULL if DeviceID is not found.
*
* @note		None
*
******************************************************************************/
#ifndef SDT
XAxiPcie_Config *XAxiPcie_LookupConfig(u16 DeviceId)
{
	XAxiPcie_Config *CfgPtr = NULL;

	int Index;

	for (Index = 0; Index < XPAR_XAXIPCIE_NUM_INSTANCES; Index++) {
		if (XAxiPcie_ConfigTable[Index].DeviceId == DeviceId) {
			CfgPtr = &XAxiPcie_ConfigTable[Index];
			break;
		}
	}

	return (CfgPtr);
}
#else
XAxiPcie_Config *XAxiPcie_LookupConfig(UINTPTR BaseAddress)
{
	XAxiPcie_Config *CfgPtr = NULL;

	int Index;

	for (Index = 0; XAxiPcie_ConfigTable[Index].Name != NULL; Index++) {
		if (XAxiPcie_ConfigTable[Index].BaseAddress == BaseAddress) {
			CfgPtr = &XAxiPcie_ConfigTable[Index];
			break;
		}
	}

	return (CfgPtr);
}
#endif





/** @} */
