/******************************************************************************
* Copyright (C) 2005 - 2020 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


/*****************************************************************************/
/**
* @file xaiegbl_reginit.c
* @{
*
* This file contains the instances of the register bit field definitions for the
* Core, Memory, NoC and PL module registers.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who     Date     Changes
* ----- ------  -------- -----------------------------------------------------
* 1.0  Naresh  03/14/2018  Initial creation
* 1.1  Naresh  07/11/2018  Updated copyright info
* 1.2  Naresh  08/13/2018  Added Done attributes to CoreStsReg
* 1.3  Hyun    10/02/2018  Added performance counter registers
* 1.4  Hyun    10/02/2018  Added event registers
* 1.5  Hyun    10/03/2018  Added event port select registers
* 1.6  Hyun    10/12/2018  Added the colum reset register
* 1.7  Nishad  12/05/2018  Renamed ME attributes to AIE
* 1.8  Hyun    12/13/2018  Added the core PC event registers
* 1.9  Jubaer  02/26/2019  Add Group Event registers
* 2.0  Hyun    06/27/2019  Change CoreTimerReg to TimerReg
* 2.1  Wendy   12/18/2019  Added Timer control and events to TimerReg
* </pre>
*
******************************************************************************/

/***************************** Include Files *********************************/
#include "xaiegbl_reginit.h"
#include "xaiegbl.h"

/************************** Constant Definitions *****************************/

/**************************** Type Definitions *******************************/

/**************************** Macro Definitions ******************************/

/************************** Variable Definitions *****************************/
/*
 * Global instance for Core module Core_Control register.
 */
XAieGbl_RegCoreCtrl CoreCtrlReg =
{
	XAIEGBL_CORE_CORECTRL,
	{XAIEGBL_CORE_CORECTRL_ENA_LSB, XAIEGBL_CORE_CORECTRL_ENA_MASK},
	{XAIEGBL_CORE_CORECTRL_RST_LSB, XAIEGBL_CORE_CORECTRL_RST_MASK}
};

/*
 * Global instance for Core module Core_Status register.
 */
XAieGbl_RegCoreSts CoreStsReg =
{
	XAIEGBL_CORE_CORESTA,
        {XAIEGBL_CORE_CORESTA_COREDON_LSB, XAIEGBL_CORE_CORESTA_COREDON_MASK},
	{XAIEGBL_CORE_CORESTA_RST_LSB, XAIEGBL_CORE_CORESTA_RST_MASK},
	{XAIEGBL_CORE_CORESTA_ENA_LSB, XAIEGBL_CORE_CORESTA_ENA_MASK}
};

/*
 * Global instance for Timer registers: Idx: 0 = core, 1 = PL, 2 = Mem
 */
XAieGbl_RegTimer TimerReg[] =
{
	{
	        XAIEGBL_CORE_TIMCTRL,
	        XAIEGBL_CORE_TIMLOW,
	        XAIEGBL_CORE_TIMHIG,
	        XAIEGBL_CORE_TIMTRIEVTLOWVAL,
	        XAIEGBL_CORE_TIMTRIEVTHIGVAL,
	        {XAIEGBL_CORE_TIMCTRL_RST_LSB, XAIEGBL_CORE_TIMCTRL_RST_MASK},
	        {XAIEGBL_CORE_TIMCTRL_RSTEVT_LSB, XAIEGBL_CORE_TIMCTRL_RSTEVT_MASK},
	},
	{
	        XAIEGBL_PL_TIMCTRL,
	        XAIEGBL_PL_TIMLOW,
	        XAIEGBL_PL_TIMHIG,
	        XAIEGBL_PL_TIMTRIEVTLOWVAL,
	        XAIEGBL_PL_TIMTRIEVTHIGVAL,
	        {XAIEGBL_PL_TIMCTRL_RST_LSB, XAIEGBL_PL_TIMCTRL_RST_MASK},
	        {XAIEGBL_PL_TIMCTRL_RSTEVT_LSB, XAIEGBL_PL_TIMCTRL_RSTEVT_MASK},
	},
	{
	        XAIEGBL_MEM_TIMCTRL,
	        XAIEGBL_MEM_TIMLOW,
	        XAIEGBL_MEM_TIMHIG,
	        XAIEGBL_MEM_TIMTRIEVTLOWVAL,
	        XAIEGBL_MEM_TIMTRIEVTHIGVAL,
	        {XAIEGBL_MEM_TIMCTRL_RST_LSB, XAIEGBL_MEM_TIMCTRL_RST_MASK},
	        {XAIEGBL_MEM_TIMCTRL_RSTEVT_LSB, XAIEGBL_MEM_TIMCTRL_RSTEVT_MASK},
	},
};

/*
 * Global instance for Core module Stream_Switch_Master_Config_* registers.
 */
XAieGbl_RegStrmMstr TileStrmMstr[] =
{
	{
		XAIEGBL_CORE_STRSWIMSTRCFGMECORE0,
		{XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGMECORE1,
		{XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGDMA0,
		{XAIEGBL_CORE_STRSWIMSTRCFGDMA0_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGDMA0_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGDMA0_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGDMA0_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGDMA0_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGDMA0_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGDMA0_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGDMA0_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGDMA1,
		{XAIEGBL_CORE_STRSWIMSTRCFGDMA1_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGDMA1_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGDMA1_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGDMA1_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGDMA1_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGDMA1_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGDMA1_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGDMA1_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGTILCTR,
		{XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGFIF0,
		{XAIEGBL_CORE_STRSWIMSTRCFGFIF0_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGFIF0_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGFIF0_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGFIF0_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGFIF0_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGFIF0_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGFIF0_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGFIF0_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGFIF1,
		{XAIEGBL_CORE_STRSWIMSTRCFGFIF1_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGFIF1_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGFIF1_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGFIF1_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGFIF1_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGFIF1_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGFIF1_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGFIF1_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGSOU0,
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU0_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU0_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU0_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU0_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU0_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU0_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU0_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU0_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGSOU1,
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU1_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU1_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU1_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU1_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU1_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU1_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU1_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU1_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGSOU2,
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU2_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU2_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU2_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU2_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU2_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU2_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU2_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU2_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGSOU3,
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU3_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU3_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU3_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU3_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU3_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU3_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGSOU3_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGSOU3_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGWES0,
		{XAIEGBL_CORE_STRSWIMSTRCFGWES0_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES0_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGWES0_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES0_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGWES0_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES0_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGWES0_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES0_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGWES1,
		{XAIEGBL_CORE_STRSWIMSTRCFGWES1_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES1_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGWES1_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES1_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGWES1_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES1_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGWES1_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES1_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGWES2,
		{XAIEGBL_CORE_STRSWIMSTRCFGWES2_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES2_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGWES2_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES2_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGWES2_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES2_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGWES2_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES2_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGWES3,
		{XAIEGBL_CORE_STRSWIMSTRCFGWES3_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES3_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGWES3_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES3_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGWES3_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES3_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGWES3_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGWES3_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGNOR0,
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR0_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR0_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR0_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR0_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR0_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR0_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR0_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR0_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGNOR1,
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR1_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR1_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR1_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR1_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR1_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR1_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR1_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR1_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGNOR2,
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR2_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR2_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR2_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR2_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR2_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR2_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR2_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR2_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGNOR3,
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR3_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR3_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR3_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR3_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR3_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR3_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR3_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR3_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGNOR4,
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR4_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR4_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR4_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR4_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR4_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR4_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR4_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR4_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGNOR5,
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR5_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR5_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR5_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR5_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR5_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR5_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGNOR5_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGNOR5_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGEAS0,
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS0_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS0_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS0_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS0_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS0_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS0_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS0_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS0_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGEAS1,
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS1_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS1_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS1_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS1_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS1_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS1_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS1_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS1_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGEAS2,
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS2_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS2_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS2_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS2_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS2_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS2_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS2_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS2_CON_MASK},
	},
	{
		XAIEGBL_CORE_STRSWIMSTRCFGEAS3,
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS3_MSTRENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS3_MSTRENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS3_PKTENA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS3_PKTENA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS3_DROHEA_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS3_DROHEA_MASK},
		{XAIEGBL_CORE_STRSWIMSTRCFGEAS3_CON_LSB, XAIEGBL_CORE_STRSWIMSTRCFGEAS3_CON_MASK},
	}
};

/*
 * Global instance for Core module Stream_Switch_Slave_*_Config registers.
 */
XAieGbl_RegStrmSlv TileStrmSlv[] =
{
	{
		XAIEGBL_CORE_STRSWISLVMECORE0CFG,
		{XAIEGBL_CORE_STRSWISLVMECORE0CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVMECORE0CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVMECORE0CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMECORE1CFG,
		{XAIEGBL_CORE_STRSWISLVMECORE1CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVMECORE1CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVMECORE1CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVDMA0CFG,
		{XAIEGBL_CORE_STRSWISLVDMA0CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVDMA0CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVDMA0CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVDMA1CFG,
		{XAIEGBL_CORE_STRSWISLVDMA1CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVDMA1CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVDMA1CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVTILCTRCFG,
		{XAIEGBL_CORE_STRSWISLVTILCTRCFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVTILCTRCFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRCFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVTILCTRCFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVFIF0CFG,
		{XAIEGBL_CORE_STRSWISLVFIF0CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVFIF0CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVFIF0CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVFIF1CFG,
		{XAIEGBL_CORE_STRSWISLVFIF1CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVFIF1CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVFIF1CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU0CFG,
		{XAIEGBL_CORE_STRSWISLVSOU0CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVSOU0CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVSOU0CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU1CFG,
		{XAIEGBL_CORE_STRSWISLVSOU1CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVSOU1CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVSOU1CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU2CFG,
		{XAIEGBL_CORE_STRSWISLVSOU2CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVSOU2CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVSOU2CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU3CFG,
		{XAIEGBL_CORE_STRSWISLVSOU3CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVSOU3CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVSOU3CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU4CFG,
		{XAIEGBL_CORE_STRSWISLVSOU4CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVSOU4CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVSOU4CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU5CFG,
		{XAIEGBL_CORE_STRSWISLVSOU5CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVSOU5CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVSOU5CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES0CFG,
		{XAIEGBL_CORE_STRSWISLVWES0CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVWES0CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVWES0CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES1CFG,
		{XAIEGBL_CORE_STRSWISLVWES1CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVWES1CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVWES1CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES2CFG,
		{XAIEGBL_CORE_STRSWISLVWES2CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVWES2CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVWES2CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES3CFG,
		{XAIEGBL_CORE_STRSWISLVWES3CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVWES3CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVWES3CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR0CFG,
		{XAIEGBL_CORE_STRSWISLVNOR0CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVNOR0CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVNOR0CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR1CFG,
		{XAIEGBL_CORE_STRSWISLVNOR1CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVNOR1CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVNOR1CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR2CFG,
		{XAIEGBL_CORE_STRSWISLVNOR2CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVNOR2CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVNOR2CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR3CFG,
		{XAIEGBL_CORE_STRSWISLVNOR3CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVNOR3CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVNOR3CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS0CFG,
		{XAIEGBL_CORE_STRSWISLVEAS0CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVEAS0CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVEAS0CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS1CFG,
		{XAIEGBL_CORE_STRSWISLVEAS1CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVEAS1CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVEAS1CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS2CFG,
		{XAIEGBL_CORE_STRSWISLVEAS2CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVEAS2CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVEAS2CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS3CFG,
		{XAIEGBL_CORE_STRSWISLVEAS3CFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVEAS3CFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3CFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVEAS3CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMETRACFG,
		{XAIEGBL_CORE_STRSWISLVMETRACFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVMETRACFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRACFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVMETRACFG_PKTENA_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMEMTRACFG,
		{XAIEGBL_CORE_STRSWISLVMEMTRACFG_SLVENA_LSB, XAIEGBL_CORE_STRSWISLVMEMTRACFG_SLVENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRACFG_PKTENA_LSB, XAIEGBL_CORE_STRSWISLVMEMTRACFG_PKTENA_MASK},
	}
};

/*
 * Global instance for Core module Stream_Switch_Slave_*_Slot* registers.
 */
XAieGbl_RegStrmSlot TileStrmSlot[] =
{
        {
		XAIEGBL_CORE_STRSWISLVMECORE0SLO0,
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ARB_MASK}
	},
	{	
		XAIEGBL_CORE_STRSWISLVMECORE0SLO1,
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ARB_MASK}
	},
	{
		XAIEGBL_CORE_STRSWISLVMECORE0SLO2,
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ARB_MASK}
	},
	{
		XAIEGBL_CORE_STRSWISLVMECORE0SLO3,
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ARB_MASK}
        },
        {
		XAIEGBL_CORE_STRSWISLVMECORE1SLO0,
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ARB_MASK}
	},
	{
		XAIEGBL_CORE_STRSWISLVMECORE1SLO1,
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMECORE1SLO2,
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMECORE1SLO3,
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ARB_MASK},
        },
        {
		XAIEGBL_CORE_STRSWISLVDMA0SLO0,
		{XAIEGBL_CORE_STRSWISLVDMA0SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVDMA0SLO1,
		{XAIEGBL_CORE_STRSWISLVDMA0SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVDMA0SLO2,
		{XAIEGBL_CORE_STRSWISLVDMA0SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVDMA0SLO3,
		{XAIEGBL_CORE_STRSWISLVDMA0SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA0SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVDMA0SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVDMA1SLO0,
		{XAIEGBL_CORE_STRSWISLVDMA1SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVDMA1SLO1,
		{XAIEGBL_CORE_STRSWISLVDMA1SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVDMA1SLO2,
		{XAIEGBL_CORE_STRSWISLVDMA1SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVDMA1SLO3,
		{XAIEGBL_CORE_STRSWISLVDMA1SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVDMA1SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVDMA1SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVTILCTRSLO0,
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVTILCTRSLO1,
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVTILCTRSLO2,
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVTILCTRSLO3,
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVFIF0SLO0,
		{XAIEGBL_CORE_STRSWISLVFIF0SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVFIF0SLO1,
		{XAIEGBL_CORE_STRSWISLVFIF0SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVFIF0SLO2,
		{XAIEGBL_CORE_STRSWISLVFIF0SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVFIF0SLO3,
		{XAIEGBL_CORE_STRSWISLVFIF0SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF0SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVFIF0SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVFIF1SLO0,
		{XAIEGBL_CORE_STRSWISLVFIF1SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVFIF1SLO1,
		{XAIEGBL_CORE_STRSWISLVFIF1SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVFIF1SLO2,
		{XAIEGBL_CORE_STRSWISLVFIF1SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVFIF1SLO3,
		{XAIEGBL_CORE_STRSWISLVFIF1SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVFIF1SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVFIF1SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU0SLO0,
		{XAIEGBL_CORE_STRSWISLVSOU0SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU0SLO1,
		{XAIEGBL_CORE_STRSWISLVSOU0SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU0SLO2,
		{XAIEGBL_CORE_STRSWISLVSOU0SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU0SLO3,
		{XAIEGBL_CORE_STRSWISLVSOU0SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU0SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU0SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU1SLO0,
		{XAIEGBL_CORE_STRSWISLVSOU1SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU1SLO1,
		{XAIEGBL_CORE_STRSWISLVSOU1SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU1SLO2,
		{XAIEGBL_CORE_STRSWISLVSOU1SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU1SLO3,
		{XAIEGBL_CORE_STRSWISLVSOU1SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU1SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU1SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU2SLO0,
		{XAIEGBL_CORE_STRSWISLVSOU2SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU2SLO1,
		{XAIEGBL_CORE_STRSWISLVSOU2SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU2SLO2,
		{XAIEGBL_CORE_STRSWISLVSOU2SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU2SLO3,
		{XAIEGBL_CORE_STRSWISLVSOU2SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU2SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU2SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU3SLO0,
		{XAIEGBL_CORE_STRSWISLVSOU3SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU3SLO1,
		{XAIEGBL_CORE_STRSWISLVSOU3SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU3SLO2,
		{XAIEGBL_CORE_STRSWISLVSOU3SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU3SLO3,
		{XAIEGBL_CORE_STRSWISLVSOU3SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU3SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU3SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU4SLO0,
		{XAIEGBL_CORE_STRSWISLVSOU4SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU4SLO1,
		{XAIEGBL_CORE_STRSWISLVSOU4SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU4SLO2,
		{XAIEGBL_CORE_STRSWISLVSOU4SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU4SLO3,
		{XAIEGBL_CORE_STRSWISLVSOU4SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU4SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU4SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU5SLO0,
		{XAIEGBL_CORE_STRSWISLVSOU5SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU5SLO1,
		{XAIEGBL_CORE_STRSWISLVSOU5SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU5SLO2,
		{XAIEGBL_CORE_STRSWISLVSOU5SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVSOU5SLO3,
		{XAIEGBL_CORE_STRSWISLVSOU5SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVSOU5SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVSOU5SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES0SLO0,
		{XAIEGBL_CORE_STRSWISLVWES0SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES0SLO1,
		{XAIEGBL_CORE_STRSWISLVWES0SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES0SLO2,
		{XAIEGBL_CORE_STRSWISLVWES0SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES0SLO3,
		{XAIEGBL_CORE_STRSWISLVWES0SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES0SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES0SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES1SLO0,
		{XAIEGBL_CORE_STRSWISLVWES1SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES1SLO1,
		{XAIEGBL_CORE_STRSWISLVWES1SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES1SLO2,
		{XAIEGBL_CORE_STRSWISLVWES1SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES1SLO3,
		{XAIEGBL_CORE_STRSWISLVWES1SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES1SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES1SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES2SLO0,
		{XAIEGBL_CORE_STRSWISLVWES2SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES2SLO1,
		{XAIEGBL_CORE_STRSWISLVWES2SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES2SLO2,
		{XAIEGBL_CORE_STRSWISLVWES2SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES2SLO3,
		{XAIEGBL_CORE_STRSWISLVWES2SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES2SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES2SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES3SLO0,
		{XAIEGBL_CORE_STRSWISLVWES3SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES3SLO1,
		{XAIEGBL_CORE_STRSWISLVWES3SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES3SLO2,
		{XAIEGBL_CORE_STRSWISLVWES3SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVWES3SLO3,
		{XAIEGBL_CORE_STRSWISLVWES3SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVWES3SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVWES3SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR0SLO0,
		{XAIEGBL_CORE_STRSWISLVNOR0SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR0SLO1,
		{XAIEGBL_CORE_STRSWISLVNOR0SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR0SLO2,
		{XAIEGBL_CORE_STRSWISLVNOR0SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR0SLO3,
		{XAIEGBL_CORE_STRSWISLVNOR0SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR0SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR0SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR1SLO0,
		{XAIEGBL_CORE_STRSWISLVNOR1SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR1SLO1,
		{XAIEGBL_CORE_STRSWISLVNOR1SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR1SLO2,
		{XAIEGBL_CORE_STRSWISLVNOR1SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR1SLO3,
		{XAIEGBL_CORE_STRSWISLVNOR1SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR1SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR1SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR2SLO0,
		{XAIEGBL_CORE_STRSWISLVNOR2SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR2SLO1,
		{XAIEGBL_CORE_STRSWISLVNOR2SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR2SLO2,
		{XAIEGBL_CORE_STRSWISLVNOR2SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR2SLO3,
		{XAIEGBL_CORE_STRSWISLVNOR2SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR2SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR2SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR3SLO0,
		{XAIEGBL_CORE_STRSWISLVNOR3SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR3SLO1,
		{XAIEGBL_CORE_STRSWISLVNOR3SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR3SLO2,
		{XAIEGBL_CORE_STRSWISLVNOR3SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVNOR3SLO3,
		{XAIEGBL_CORE_STRSWISLVNOR3SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVNOR3SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVNOR3SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS0SLO0,
		{XAIEGBL_CORE_STRSWISLVEAS0SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS0SLO1,
		{XAIEGBL_CORE_STRSWISLVEAS0SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS0SLO2,
		{XAIEGBL_CORE_STRSWISLVEAS0SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS0SLO3,
		{XAIEGBL_CORE_STRSWISLVEAS0SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS0SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS0SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS1SLO0,
		{XAIEGBL_CORE_STRSWISLVEAS1SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS1SLO1,
		{XAIEGBL_CORE_STRSWISLVEAS1SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS1SLO2,
		{XAIEGBL_CORE_STRSWISLVEAS1SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS1SLO3,
		{XAIEGBL_CORE_STRSWISLVEAS1SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS1SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS1SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS2SLO0,
		{XAIEGBL_CORE_STRSWISLVEAS2SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS2SLO1,
		{XAIEGBL_CORE_STRSWISLVEAS2SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS2SLO2,
		{XAIEGBL_CORE_STRSWISLVEAS2SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS2SLO3,
		{XAIEGBL_CORE_STRSWISLVEAS2SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS2SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS2SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS3SLO0,
		{XAIEGBL_CORE_STRSWISLVEAS3SLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS3SLO1,
		{XAIEGBL_CORE_STRSWISLVEAS3SLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS3SLO2,
		{XAIEGBL_CORE_STRSWISLVEAS3SLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVEAS3SLO3,
		{XAIEGBL_CORE_STRSWISLVEAS3SLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVEAS3SLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVEAS3SLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMETRASLO0,
		{XAIEGBL_CORE_STRSWISLVMETRASLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMETRASLO1,
		{XAIEGBL_CORE_STRSWISLVMETRASLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMETRASLO2,
		{XAIEGBL_CORE_STRSWISLVMETRASLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMETRASLO3,
		{XAIEGBL_CORE_STRSWISLVMETRASLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMETRASLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVMETRASLO3_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMEMTRASLO0,
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ID_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO0_MSK_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO0_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ENA_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO0_MSE_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO0_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ARB_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMEMTRASLO1,
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ID_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO1_MSK_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO1_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ENA_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO1_MSE_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO1_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ARB_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMEMTRASLO2,
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ID_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO2_MSK_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO2_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ENA_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO2_MSE_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO2_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ARB_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ARB_MASK},
	},
	{
		XAIEGBL_CORE_STRSWISLVMEMTRASLO3,
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ID_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ID_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO3_MSK_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO3_MSK_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ENA_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ENA_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO3_MSE_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO3_MSE_MASK},
		{XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ARB_LSB, XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ARB_MASK},
	}
};

/*
 * Global instance for Memory module Lock acquire/release registers.
 */
XAieGbl_RegLocks TileLockRegs[] =
{
	{
		XAIEGBL_MEM_LOCK0RELNV,
		{XAIEGBL_MEM_LOCK0RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK0RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK0RELV0,
		{XAIEGBL_MEM_LOCK0RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK0RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK0RELV1,
		{XAIEGBL_MEM_LOCK0RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK0RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK0ACQNV,
		{XAIEGBL_MEM_LOCK0ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK0ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK0ACQV0,
		{XAIEGBL_MEM_LOCK0ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK0ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK0ACQV1,
		{XAIEGBL_MEM_LOCK0ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK0ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK1RELNV,
		{XAIEGBL_MEM_LOCK1RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK1RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK1RELV0,
		{XAIEGBL_MEM_LOCK1RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK1RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK1RELV1,
		{XAIEGBL_MEM_LOCK1RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK1RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK1ACQNV,
		{XAIEGBL_MEM_LOCK1ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK1ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK1ACQV0,
		{XAIEGBL_MEM_LOCK1ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK1ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK1ACQV1,
		{XAIEGBL_MEM_LOCK1ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK1ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK2RELNV,
		{XAIEGBL_MEM_LOCK2RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK2RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK2RELV0,
		{XAIEGBL_MEM_LOCK2RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK2RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK2RELV1,
		{XAIEGBL_MEM_LOCK2RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK2RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK2ACQNV,
		{XAIEGBL_MEM_LOCK2ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK2ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK2ACQV0,
		{XAIEGBL_MEM_LOCK2ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK2ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK2ACQV1,
		{XAIEGBL_MEM_LOCK2ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK2ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK3RELNV,
		{XAIEGBL_MEM_LOCK3RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK3RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK3RELV0,
		{XAIEGBL_MEM_LOCK3RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK3RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK3RELV1,
		{XAIEGBL_MEM_LOCK3RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK3RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK3ACQNV,
		{XAIEGBL_MEM_LOCK3ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK3ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK3ACQV0,
		{XAIEGBL_MEM_LOCK3ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK3ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK3ACQV1,
		{XAIEGBL_MEM_LOCK3ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK3ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK4RELNV,
		{XAIEGBL_MEM_LOCK4RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK4RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK4RELV0,
		{XAIEGBL_MEM_LOCK4RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK4RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK4RELV1,
		{XAIEGBL_MEM_LOCK4RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK4RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK4ACQNV,
		{XAIEGBL_MEM_LOCK4ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK4ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK4ACQV0,
		{XAIEGBL_MEM_LOCK4ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK4ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK4ACQV1,
		{XAIEGBL_MEM_LOCK4ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK4ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK5RELNV,
		{XAIEGBL_MEM_LOCK5RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK5RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK5RELV0,
		{XAIEGBL_MEM_LOCK5RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK5RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK5RELV1,
		{XAIEGBL_MEM_LOCK5RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK5RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK5ACQNV,
		{XAIEGBL_MEM_LOCK5ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK5ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK5ACQV0,
		{XAIEGBL_MEM_LOCK5ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK5ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK5ACQV1,
		{XAIEGBL_MEM_LOCK5ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK5ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK6RELNV,
		{XAIEGBL_MEM_LOCK6RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK6RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK6RELV0,
		{XAIEGBL_MEM_LOCK6RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK6RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK6RELV1,
		{XAIEGBL_MEM_LOCK6RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK6RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK6ACQNV,
		{XAIEGBL_MEM_LOCK6ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK6ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK6ACQV0,
		{XAIEGBL_MEM_LOCK6ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK6ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK6ACQV1,
		{XAIEGBL_MEM_LOCK6ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK6ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK7RELNV,
		{XAIEGBL_MEM_LOCK7RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK7RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK7RELV0,
		{XAIEGBL_MEM_LOCK7RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK7RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK7RELV1,
		{XAIEGBL_MEM_LOCK7RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK7RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK7ACQNV,
		{XAIEGBL_MEM_LOCK7ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK7ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK7ACQV0,
		{XAIEGBL_MEM_LOCK7ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK7ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK7ACQV1,
		{XAIEGBL_MEM_LOCK7ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK7ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK8RELNV,
		{XAIEGBL_MEM_LOCK8RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK8RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK8RELV0,
		{XAIEGBL_MEM_LOCK8RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK8RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK8RELV1,
		{XAIEGBL_MEM_LOCK8RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK8RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK8ACQNV,
		{XAIEGBL_MEM_LOCK8ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK8ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK8ACQV0,
		{XAIEGBL_MEM_LOCK8ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK8ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK8ACQV1,
		{XAIEGBL_MEM_LOCK8ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK8ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK9RELNV,
		{XAIEGBL_MEM_LOCK9RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK9RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK9RELV0,
		{XAIEGBL_MEM_LOCK9RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK9RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK9RELV1,
		{XAIEGBL_MEM_LOCK9RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK9RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK9ACQNV,
		{XAIEGBL_MEM_LOCK9ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK9ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK9ACQV0,
		{XAIEGBL_MEM_LOCK9ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK9ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK9ACQV1,
		{XAIEGBL_MEM_LOCK9ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK9ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK10RELNV,
		{XAIEGBL_MEM_LOCK10RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK10RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK10RELV0,
		{XAIEGBL_MEM_LOCK10RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK10RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK10RELV1,
		{XAIEGBL_MEM_LOCK10RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK10RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK10ACQNV,
		{XAIEGBL_MEM_LOCK10ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK10ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK10ACQV0,
		{XAIEGBL_MEM_LOCK10ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK10ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK10ACQV1,
		{XAIEGBL_MEM_LOCK10ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK10ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK11RELNV,
		{XAIEGBL_MEM_LOCK11RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK11RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK11RELV0,
		{XAIEGBL_MEM_LOCK11RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK11RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK11RELV1,
		{XAIEGBL_MEM_LOCK11RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK11RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK11ACQNV,
		{XAIEGBL_MEM_LOCK11ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK11ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK11ACQV0,
		{XAIEGBL_MEM_LOCK11ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK11ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK11ACQV1,
		{XAIEGBL_MEM_LOCK11ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK11ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK12RELNV,
		{XAIEGBL_MEM_LOCK12RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK12RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK12RELV0,
		{XAIEGBL_MEM_LOCK12RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK12RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK12RELV1,
		{XAIEGBL_MEM_LOCK12RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK12RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK12ACQNV,
		{XAIEGBL_MEM_LOCK12ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK12ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK12ACQV0,
		{XAIEGBL_MEM_LOCK12ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK12ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK12ACQV1,
		{XAIEGBL_MEM_LOCK12ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK12ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK13RELNV,
		{XAIEGBL_MEM_LOCK13RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK13RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK13RELV0,
		{XAIEGBL_MEM_LOCK13RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK13RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK13RELV1,
		{XAIEGBL_MEM_LOCK13RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK13RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK13ACQNV,
		{XAIEGBL_MEM_LOCK13ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK13ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK13ACQV0,
		{XAIEGBL_MEM_LOCK13ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK13ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK13ACQV1,
		{XAIEGBL_MEM_LOCK13ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK13ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK14RELNV,
		{XAIEGBL_MEM_LOCK14RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK14RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK14RELV0,
		{XAIEGBL_MEM_LOCK14RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK14RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK14RELV1,
		{XAIEGBL_MEM_LOCK14RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK14RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK14ACQNV,
		{XAIEGBL_MEM_LOCK14ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK14ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK14ACQV0,
		{XAIEGBL_MEM_LOCK14ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK14ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK14ACQV1,
		{XAIEGBL_MEM_LOCK14ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK14ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_MEM_LOCK15RELNV,
		{XAIEGBL_MEM_LOCK15RELNV_RELDON_LSB, XAIEGBL_MEM_LOCK15RELNV_RELDON_MASK},
		XAIEGBL_MEM_LOCK15RELV0,
		{XAIEGBL_MEM_LOCK15RELV0_RELDON_LSB, XAIEGBL_MEM_LOCK15RELV0_RELDON_MASK},
		XAIEGBL_MEM_LOCK15RELV1,
		{XAIEGBL_MEM_LOCK15RELV1_RELDON_LSB, XAIEGBL_MEM_LOCK15RELV1_RELDON_MASK},
		XAIEGBL_MEM_LOCK15ACQNV,
		{XAIEGBL_MEM_LOCK15ACQNV_ACQDON_LSB, XAIEGBL_MEM_LOCK15ACQNV_ACQDON_MASK},
		XAIEGBL_MEM_LOCK15ACQV0,
		{XAIEGBL_MEM_LOCK15ACQV0_ACQDON_LSB, XAIEGBL_MEM_LOCK15ACQV0_ACQDON_MASK},
		XAIEGBL_MEM_LOCK15ACQV1,
		{XAIEGBL_MEM_LOCK15ACQV1_ACQDON_LSB, XAIEGBL_MEM_LOCK15ACQV1_ACQDON_MASK}
	}
};

/*
 * Global instance for Memory module DMA_BD*_* registers.
 */
XAieGbl_RegTileDmaBd TileBd[] =
{
	{
		{
			XAIEGBL_MEM_DMABD0ADDA,
			XAIEGBL_MEM_DMABD0ADDB,
			XAIEGBL_MEM_DMABD02DX,
			XAIEGBL_MEM_DMABD02DY,
			XAIEGBL_MEM_DMABD0PKT,
			XAIEGBL_MEM_DMABD0INTSTA,
			XAIEGBL_MEM_DMABD0CTRL,
		},
        	{
        		{XAIEGBL_MEM_DMABD0ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD0ADDA_LOCKIDA_MASK},
        		{XAIEGBL_MEM_DMABD0ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD0ADDA_ENAREL_MASK},
        		{XAIEGBL_MEM_DMABD0ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD0ADDA_RELVALA_MASK},
        		{XAIEGBL_MEM_DMABD0ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD0ADDA_USERELVALA_MASK},
        		{XAIEGBL_MEM_DMABD0ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD0ADDA_ENAACQ_MASK},
        		{XAIEGBL_MEM_DMABD0ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD0ADDA_ACQVALA_MASK},
        		{XAIEGBL_MEM_DMABD0ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD0ADDA_USEACQVALA_MASK},
        		{XAIEGBL_MEM_DMABD0ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD0ADDA_BASADDA_MASK},
        	},
        	{
        		{XAIEGBL_MEM_DMABD0ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD0ADDB_LOCKIDB_MASK},
        		{XAIEGBL_MEM_DMABD0ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD0ADDB_ENAREL_MASK},
        		{XAIEGBL_MEM_DMABD0ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD0ADDB_RELVALB_MASK},
        		{XAIEGBL_MEM_DMABD0ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD0ADDB_USERELVALB_MASK},
        		{XAIEGBL_MEM_DMABD0ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD0ADDB_ENAACQ_MASK},
        		{XAIEGBL_MEM_DMABD0ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD0ADDB_ACQVALB_MASK},
        		{XAIEGBL_MEM_DMABD0ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD0ADDB_USEACQVALB_MASK},
        		{XAIEGBL_MEM_DMABD0ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD0ADDB_BASADDB_MASK},
        	},
        	{
        		{XAIEGBL_MEM_DMABD02DX_XINC_LSB, XAIEGBL_MEM_DMABD02DX_XINC_MASK},
        		{XAIEGBL_MEM_DMABD02DX_XWRA_LSB, XAIEGBL_MEM_DMABD02DX_XWRA_MASK},
        		{XAIEGBL_MEM_DMABD02DX_XOFF_LSB, XAIEGBL_MEM_DMABD02DX_XOFF_MASK},
        	},
        	{
        		{XAIEGBL_MEM_DMABD02DY_YINC_LSB, XAIEGBL_MEM_DMABD02DY_YINC_MASK},
        		{XAIEGBL_MEM_DMABD02DY_YWRA_LSB, XAIEGBL_MEM_DMABD02DY_YWRA_MASK},
        		{XAIEGBL_MEM_DMABD02DY_YOFF_LSB, XAIEGBL_MEM_DMABD02DY_YOFF_MASK},
        	},
        	{
        		{XAIEGBL_MEM_DMABD0PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD0PKT_PKTTYP_MASK},
        		{XAIEGBL_MEM_DMABD0PKT_ID_LSB, XAIEGBL_MEM_DMABD0PKT_ID_MASK},
        	},
        	{
        		{XAIEGBL_MEM_DMABD0INTSTA_AB_LSB, XAIEGBL_MEM_DMABD0INTSTA_AB_MASK},
        		{XAIEGBL_MEM_DMABD0INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD0INTSTA_CURPTR_MASK},
        	},
        	{
        		{XAIEGBL_MEM_DMABD0CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD0CTRL_VALBD_MASK},
        		{XAIEGBL_MEM_DMABD0CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD0CTRL_ENAABMOD_MASK},
        		{XAIEGBL_MEM_DMABD0CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD0CTRL_ENAFIFMOD_MASK},
        		{XAIEGBL_MEM_DMABD0CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD0CTRL_ENAPKT_MASK},
        		{XAIEGBL_MEM_DMABD0CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD0CTRL_ENAINT_MASK},
        		{XAIEGBL_MEM_DMABD0CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD0CTRL_INTCNT_MASK},
        		{XAIEGBL_MEM_DMABD0CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD0CTRL_USENEXBD_MASK},
        		{XAIEGBL_MEM_DMABD0CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD0CTRL_NEXBD_MASK},
        		{XAIEGBL_MEM_DMABD0CTRL_LEN_LSB, XAIEGBL_MEM_DMABD0CTRL_LEN_MASK},
        	}
        },
	{
		{
			XAIEGBL_MEM_DMABD1ADDA,
			XAIEGBL_MEM_DMABD1ADDB,
			XAIEGBL_MEM_DMABD12DX,
			XAIEGBL_MEM_DMABD12DY,
			XAIEGBL_MEM_DMABD1PKT,
			XAIEGBL_MEM_DMABD1INTSTA,
			XAIEGBL_MEM_DMABD1CTRL,
		},
		{
        		{XAIEGBL_MEM_DMABD1ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD1ADDA_LOCKIDA_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD1ADDA_ENAREL_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD1ADDA_RELVALA_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD1ADDA_USERELVALA_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD1ADDA_ENAACQ_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD1ADDA_ACQVALA_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD1ADDA_USEACQVALA_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD1ADDA_BASADDA_MASK},
        	},
	        {
	        	{XAIEGBL_MEM_DMABD1ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD1ADDB_LOCKIDB_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD1ADDB_ENAREL_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD1ADDB_RELVALB_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD1ADDB_USERELVALB_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD1ADDB_ENAACQ_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD1ADDB_ACQVALB_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD1ADDB_USEACQVALB_MASK},
	        	{XAIEGBL_MEM_DMABD1ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD1ADDB_BASADDB_MASK},
	        },
	        {
	        	{XAIEGBL_MEM_DMABD12DX_XINC_LSB, XAIEGBL_MEM_DMABD12DX_XINC_MASK},
	        	{XAIEGBL_MEM_DMABD12DX_XWRA_LSB, XAIEGBL_MEM_DMABD12DX_XWRA_MASK},
	        	{XAIEGBL_MEM_DMABD12DX_XOFF_LSB, XAIEGBL_MEM_DMABD12DX_XOFF_MASK},
	        },
	        {
	        	{XAIEGBL_MEM_DMABD12DY_YINC_LSB, XAIEGBL_MEM_DMABD12DY_YINC_MASK},
	        	{XAIEGBL_MEM_DMABD12DY_YWRA_LSB, XAIEGBL_MEM_DMABD12DY_YWRA_MASK},
	        	{XAIEGBL_MEM_DMABD12DY_YOFF_LSB, XAIEGBL_MEM_DMABD12DY_YOFF_MASK},
	        },
	        {
	        	{XAIEGBL_MEM_DMABD1PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD1PKT_PKTTYP_MASK},
	        	{XAIEGBL_MEM_DMABD1PKT_ID_LSB, XAIEGBL_MEM_DMABD1PKT_ID_MASK},
	        },
	        {
	        	{XAIEGBL_MEM_DMABD1INTSTA_AB_LSB, XAIEGBL_MEM_DMABD1INTSTA_AB_MASK},
	        	{XAIEGBL_MEM_DMABD1INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD1INTSTA_CURPTR_MASK},
	        },
	        {
	        	{XAIEGBL_MEM_DMABD1CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD1CTRL_VALBD_MASK},
	        	{XAIEGBL_MEM_DMABD1CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD1CTRL_ENAABMOD_MASK},
	        	{XAIEGBL_MEM_DMABD1CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD1CTRL_ENAFIFMOD_MASK},
	        	{XAIEGBL_MEM_DMABD1CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD1CTRL_ENAPKT_MASK},
	        	{XAIEGBL_MEM_DMABD1CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD1CTRL_ENAINT_MASK},
	        	{XAIEGBL_MEM_DMABD1CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD1CTRL_INTCNT_MASK},
	        	{XAIEGBL_MEM_DMABD1CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD1CTRL_USENEXBD_MASK},
	        	{XAIEGBL_MEM_DMABD1CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD1CTRL_NEXBD_MASK},
	        	{XAIEGBL_MEM_DMABD1CTRL_LEN_LSB, XAIEGBL_MEM_DMABD1CTRL_LEN_MASK},
	        }
        },
        {
		{
			XAIEGBL_MEM_DMABD2ADDA,
			XAIEGBL_MEM_DMABD2ADDB,
			XAIEGBL_MEM_DMABD22DX,
			XAIEGBL_MEM_DMABD22DY,
			XAIEGBL_MEM_DMABD2PKT,
			XAIEGBL_MEM_DMABD2INTSTA,
			XAIEGBL_MEM_DMABD2CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD2ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD2ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD2ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD2ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD2ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD2ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD2ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD2ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD2ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD2ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD2ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD2ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD2ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD2ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD2ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD2ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD2ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD2ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD2ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD2ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD2ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD2ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD2ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD2ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD2ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD2ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD2ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD2ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD2ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD2ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD2ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD2ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD22DX_XINC_LSB, XAIEGBL_MEM_DMABD22DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD22DX_XWRA_LSB, XAIEGBL_MEM_DMABD22DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD22DX_XOFF_LSB, XAIEGBL_MEM_DMABD22DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD22DY_YINC_LSB, XAIEGBL_MEM_DMABD22DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD22DY_YWRA_LSB, XAIEGBL_MEM_DMABD22DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD22DY_YOFF_LSB, XAIEGBL_MEM_DMABD22DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD2PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD2PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD2PKT_ID_LSB, XAIEGBL_MEM_DMABD2PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD2INTSTA_AB_LSB, XAIEGBL_MEM_DMABD2INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD2INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD2INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD2CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD2CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD2CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD2CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD2CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD2CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD2CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD2CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD2CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD2CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD2CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD2CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD2CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD2CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD2CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD2CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD2CTRL_LEN_LSB, XAIEGBL_MEM_DMABD2CTRL_LEN_MASK},
		}
	},
	{
		{
			XAIEGBL_MEM_DMABD3ADDA,
			XAIEGBL_MEM_DMABD3ADDB,
			XAIEGBL_MEM_DMABD32DX,
			XAIEGBL_MEM_DMABD32DY,
			XAIEGBL_MEM_DMABD3PKT,
			XAIEGBL_MEM_DMABD3INTSTA,
			XAIEGBL_MEM_DMABD3CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD3ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD3ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD3ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD3ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD3ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD3ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD3ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD3ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD3ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD3ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD3ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD3ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD3ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD3ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD3ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD3ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD3ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD3ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD3ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD3ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD3ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD3ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD3ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD3ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD3ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD3ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD3ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD3ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD3ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD3ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD3ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD3ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD32DX_XINC_LSB, XAIEGBL_MEM_DMABD32DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD32DX_XWRA_LSB, XAIEGBL_MEM_DMABD32DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD32DX_XOFF_LSB, XAIEGBL_MEM_DMABD32DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD32DY_YINC_LSB, XAIEGBL_MEM_DMABD32DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD32DY_YWRA_LSB, XAIEGBL_MEM_DMABD32DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD32DY_YOFF_LSB, XAIEGBL_MEM_DMABD32DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD3PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD3PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD3PKT_ID_LSB, XAIEGBL_MEM_DMABD3PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD3INTSTA_AB_LSB, XAIEGBL_MEM_DMABD3INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD3INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD3INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD3CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD3CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD3CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD3CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD3CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD3CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD3CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD3CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD3CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD3CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD3CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD3CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD3CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD3CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD3CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD3CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD3CTRL_LEN_LSB, XAIEGBL_MEM_DMABD3CTRL_LEN_MASK},
		}
	},
	{
		{
			XAIEGBL_MEM_DMABD4ADDA,
			XAIEGBL_MEM_DMABD4ADDB,
			XAIEGBL_MEM_DMABD42DX,
			XAIEGBL_MEM_DMABD42DY,
			XAIEGBL_MEM_DMABD4PKT,
			XAIEGBL_MEM_DMABD4INTSTA,
			XAIEGBL_MEM_DMABD4CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD4ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD4ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD4ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD4ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD4ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD4ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD4ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD4ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD4ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD4ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD4ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD4ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD4ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD4ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD4ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD4ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD4ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD4ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD4ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD4ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD4ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD4ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD4ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD4ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD4ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD4ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD4ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD4ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD4ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD4ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD4ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD4ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD42DX_XINC_LSB, XAIEGBL_MEM_DMABD42DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD42DX_XWRA_LSB, XAIEGBL_MEM_DMABD42DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD42DX_XOFF_LSB, XAIEGBL_MEM_DMABD42DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD42DY_YINC_LSB, XAIEGBL_MEM_DMABD42DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD42DY_YWRA_LSB, XAIEGBL_MEM_DMABD42DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD42DY_YOFF_LSB, XAIEGBL_MEM_DMABD42DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD4PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD4PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD4PKT_ID_LSB, XAIEGBL_MEM_DMABD4PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD4INTSTA_AB_LSB, XAIEGBL_MEM_DMABD4INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD4INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD4INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD4CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD4CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD4CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD4CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD4CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD4CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD4CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD4CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD4CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD4CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD4CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD4CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD4CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD4CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD4CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD4CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD4CTRL_LEN_LSB, XAIEGBL_MEM_DMABD4CTRL_LEN_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_DMABD5ADDA,
			XAIEGBL_MEM_DMABD5ADDB,
			XAIEGBL_MEM_DMABD52DX,
			XAIEGBL_MEM_DMABD52DY,
			XAIEGBL_MEM_DMABD5PKT,
			XAIEGBL_MEM_DMABD5INTSTA,
			XAIEGBL_MEM_DMABD5CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD5ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD5ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD5ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD5ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD5ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD5ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD5ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD5ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD5ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD5ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD5ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD5ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD5ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD5ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD5ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD5ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD5ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD5ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD5ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD5ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD5ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD5ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD5ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD5ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD5ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD5ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD5ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD5ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD5ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD5ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD5ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD5ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD52DX_XINC_LSB, XAIEGBL_MEM_DMABD52DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD52DX_XWRA_LSB, XAIEGBL_MEM_DMABD52DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD52DX_XOFF_LSB, XAIEGBL_MEM_DMABD52DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD52DY_YINC_LSB, XAIEGBL_MEM_DMABD52DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD52DY_YWRA_LSB, XAIEGBL_MEM_DMABD52DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD52DY_YOFF_LSB, XAIEGBL_MEM_DMABD52DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD5PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD5PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD5PKT_ID_LSB, XAIEGBL_MEM_DMABD5PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD5INTSTA_AB_LSB, XAIEGBL_MEM_DMABD5INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD5INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD5INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD5CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD5CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD5CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD5CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD5CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD5CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD5CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD5CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD5CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD5CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD5CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD5CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD5CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD5CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD5CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD5CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD5CTRL_LEN_LSB, XAIEGBL_MEM_DMABD5CTRL_LEN_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_DMABD6ADDA,
			XAIEGBL_MEM_DMABD6ADDB,
			XAIEGBL_MEM_DMABD62DX,
			XAIEGBL_MEM_DMABD62DY,
			XAIEGBL_MEM_DMABD6PKT,
			XAIEGBL_MEM_DMABD6INTSTA,
			XAIEGBL_MEM_DMABD6CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD6ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD6ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD6ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD6ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD6ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD6ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD6ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD6ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD6ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD6ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD6ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD6ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD6ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD6ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD6ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD6ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD6ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD6ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD6ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD6ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD6ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD6ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD6ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD6ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD6ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD6ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD6ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD6ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD6ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD6ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD6ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD6ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD62DX_XINC_LSB, XAIEGBL_MEM_DMABD62DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD62DX_XWRA_LSB, XAIEGBL_MEM_DMABD62DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD62DX_XOFF_LSB, XAIEGBL_MEM_DMABD62DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD62DY_YINC_LSB, XAIEGBL_MEM_DMABD62DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD62DY_YWRA_LSB, XAIEGBL_MEM_DMABD62DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD62DY_YOFF_LSB, XAIEGBL_MEM_DMABD62DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD6PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD6PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD6PKT_ID_LSB, XAIEGBL_MEM_DMABD6PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD6INTSTA_AB_LSB, XAIEGBL_MEM_DMABD6INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD6INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD6INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD6CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD6CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD6CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD6CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD6CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD6CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD6CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD6CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD6CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD6CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD6CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD6CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD6CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD6CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD6CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD6CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD6CTRL_LEN_LSB, XAIEGBL_MEM_DMABD6CTRL_LEN_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_DMABD7ADDA,
			XAIEGBL_MEM_DMABD7ADDB,
			XAIEGBL_MEM_DMABD72DX,
			XAIEGBL_MEM_DMABD72DY,
			XAIEGBL_MEM_DMABD7PKT,
			XAIEGBL_MEM_DMABD7INTSTA,
			XAIEGBL_MEM_DMABD7CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD7ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD7ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD7ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD7ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD7ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD7ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD7ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD7ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD7ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD7ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD7ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD7ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD7ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD7ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD7ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD7ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD7ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD7ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD7ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD7ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD7ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD7ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD7ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD7ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD7ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD7ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD7ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD7ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD7ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD7ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD7ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD7ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD72DX_XINC_LSB, XAIEGBL_MEM_DMABD72DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD72DX_XWRA_LSB, XAIEGBL_MEM_DMABD72DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD72DX_XOFF_LSB, XAIEGBL_MEM_DMABD72DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD72DY_YINC_LSB, XAIEGBL_MEM_DMABD72DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD72DY_YWRA_LSB, XAIEGBL_MEM_DMABD72DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD72DY_YOFF_LSB, XAIEGBL_MEM_DMABD72DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD7PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD7PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD7PKT_ID_LSB, XAIEGBL_MEM_DMABD7PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD7INTSTA_AB_LSB, XAIEGBL_MEM_DMABD7INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD7INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD7INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD7CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD7CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD7CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD7CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD7CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD7CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD7CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD7CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD7CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD7CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD7CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD7CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD7CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD7CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD7CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD7CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD7CTRL_LEN_LSB, XAIEGBL_MEM_DMABD7CTRL_LEN_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_DMABD8ADDA,
			XAIEGBL_MEM_DMABD8ADDB,
			XAIEGBL_MEM_DMABD82DX,
			XAIEGBL_MEM_DMABD82DY,
			XAIEGBL_MEM_DMABD8PKT,
			XAIEGBL_MEM_DMABD8INTSTA,
			XAIEGBL_MEM_DMABD8CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD8ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD8ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD8ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD8ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD8ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD8ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD8ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD8ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD8ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD8ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD8ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD8ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD8ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD8ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD8ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD8ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD8ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD8ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD8ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD8ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD8ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD8ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD8ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD8ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD8ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD8ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD8ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD8ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD8ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD8ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD8ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD8ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD82DX_XINC_LSB, XAIEGBL_MEM_DMABD82DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD82DX_XWRA_LSB, XAIEGBL_MEM_DMABD82DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD82DX_XOFF_LSB, XAIEGBL_MEM_DMABD82DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD82DY_YINC_LSB, XAIEGBL_MEM_DMABD82DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD82DY_YWRA_LSB, XAIEGBL_MEM_DMABD82DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD82DY_YOFF_LSB, XAIEGBL_MEM_DMABD82DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD8PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD8PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD8PKT_ID_LSB, XAIEGBL_MEM_DMABD8PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD8INTSTA_AB_LSB, XAIEGBL_MEM_DMABD8INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD8INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD8INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD8CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD8CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD8CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD8CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD8CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD8CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD8CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD8CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD8CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD8CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD8CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD8CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD8CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD8CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD8CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD8CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD8CTRL_LEN_LSB, XAIEGBL_MEM_DMABD8CTRL_LEN_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_DMABD9ADDA,
			XAIEGBL_MEM_DMABD9ADDB,
			XAIEGBL_MEM_DMABD92DX,
			XAIEGBL_MEM_DMABD92DY,
			XAIEGBL_MEM_DMABD9PKT,
			XAIEGBL_MEM_DMABD9INTSTA,
			XAIEGBL_MEM_DMABD9CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD9ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD9ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD9ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD9ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD9ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD9ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD9ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD9ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD9ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD9ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD9ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD9ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD9ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD9ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD9ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD9ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD9ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD9ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD9ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD9ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD9ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD9ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD9ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD9ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD9ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD9ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD9ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD9ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD9ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD9ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD9ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD9ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD92DX_XINC_LSB, XAIEGBL_MEM_DMABD92DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD92DX_XWRA_LSB, XAIEGBL_MEM_DMABD92DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD92DX_XOFF_LSB, XAIEGBL_MEM_DMABD92DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD92DY_YINC_LSB, XAIEGBL_MEM_DMABD92DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD92DY_YWRA_LSB, XAIEGBL_MEM_DMABD92DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD92DY_YOFF_LSB, XAIEGBL_MEM_DMABD92DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD9PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD9PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD9PKT_ID_LSB, XAIEGBL_MEM_DMABD9PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD9INTSTA_AB_LSB, XAIEGBL_MEM_DMABD9INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD9INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD9INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD9CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD9CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD9CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD9CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD9CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD9CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD9CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD9CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD9CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD9CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD9CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD9CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD9CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD9CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD9CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD9CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD9CTRL_LEN_LSB, XAIEGBL_MEM_DMABD9CTRL_LEN_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_DMABD10ADDA,
			XAIEGBL_MEM_DMABD10ADDB,
			XAIEGBL_MEM_DMABD102DX,
			XAIEGBL_MEM_DMABD102DY,
			XAIEGBL_MEM_DMABD10PKT,
			XAIEGBL_MEM_DMABD10INTSTA,
			XAIEGBL_MEM_DMABD10CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD10ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD10ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD10ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD10ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD10ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD10ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD10ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD10ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD10ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD10ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD10ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD10ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD10ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD10ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD10ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD10ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD10ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD10ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD10ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD10ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD10ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD10ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD10ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD10ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD10ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD10ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD10ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD10ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD10ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD10ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD10ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD10ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD102DX_XINC_LSB, XAIEGBL_MEM_DMABD102DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD102DX_XWRA_LSB, XAIEGBL_MEM_DMABD102DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD102DX_XOFF_LSB, XAIEGBL_MEM_DMABD102DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD102DY_YINC_LSB, XAIEGBL_MEM_DMABD102DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD102DY_YWRA_LSB, XAIEGBL_MEM_DMABD102DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD102DY_YOFF_LSB, XAIEGBL_MEM_DMABD102DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD10PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD10PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD10PKT_ID_LSB, XAIEGBL_MEM_DMABD10PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD10INTSTA_AB_LSB, XAIEGBL_MEM_DMABD10INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD10INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD10INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD10CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD10CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD10CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD10CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD10CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD10CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD10CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD10CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD10CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD10CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD10CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD10CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD10CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD10CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD10CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD10CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD10CTRL_LEN_LSB, XAIEGBL_MEM_DMABD10CTRL_LEN_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_DMABD11ADDA,
			XAIEGBL_MEM_DMABD11ADDB,
			XAIEGBL_MEM_DMABD112DX,
			XAIEGBL_MEM_DMABD112DY,
			XAIEGBL_MEM_DMABD11PKT,
			XAIEGBL_MEM_DMABD11INTSTA,
			XAIEGBL_MEM_DMABD11CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD11ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD11ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD11ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD11ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD11ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD11ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD11ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD11ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD11ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD11ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD11ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD11ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD11ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD11ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD11ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD11ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD11ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD11ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD11ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD11ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD11ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD11ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD11ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD11ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD11ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD11ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD11ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD11ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD11ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD11ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD11ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD11ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD112DX_XINC_LSB, XAIEGBL_MEM_DMABD112DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD112DX_XWRA_LSB, XAIEGBL_MEM_DMABD112DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD112DX_XOFF_LSB, XAIEGBL_MEM_DMABD112DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD112DY_YINC_LSB, XAIEGBL_MEM_DMABD112DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD112DY_YWRA_LSB, XAIEGBL_MEM_DMABD112DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD112DY_YOFF_LSB, XAIEGBL_MEM_DMABD112DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD11PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD11PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD11PKT_ID_LSB, XAIEGBL_MEM_DMABD11PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD11INTSTA_AB_LSB, XAIEGBL_MEM_DMABD11INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD11INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD11INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD11CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD11CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD11CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD11CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD11CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD11CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD11CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD11CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD11CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD11CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD11CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD11CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD11CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD11CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD11CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD11CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD11CTRL_LEN_LSB, XAIEGBL_MEM_DMABD11CTRL_LEN_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_DMABD12ADDA,
			XAIEGBL_MEM_DMABD12ADDB,
			XAIEGBL_MEM_DMABD122DX,
			XAIEGBL_MEM_DMABD122DY,
			XAIEGBL_MEM_DMABD12PKT,
			XAIEGBL_MEM_DMABD12INTSTA,
			XAIEGBL_MEM_DMABD12CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD12ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD12ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD12ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD12ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD12ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD12ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD12ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD12ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD12ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD12ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD12ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD12ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD12ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD12ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD12ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD12ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD12ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD12ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD12ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD12ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD12ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD12ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD12ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD12ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD12ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD12ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD12ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD12ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD12ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD12ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD12ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD12ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD122DX_XINC_LSB, XAIEGBL_MEM_DMABD122DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD122DX_XWRA_LSB, XAIEGBL_MEM_DMABD122DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD122DX_XOFF_LSB, XAIEGBL_MEM_DMABD122DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD122DY_YINC_LSB, XAIEGBL_MEM_DMABD122DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD122DY_YWRA_LSB, XAIEGBL_MEM_DMABD122DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD122DY_YOFF_LSB, XAIEGBL_MEM_DMABD122DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD12PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD12PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD12PKT_ID_LSB, XAIEGBL_MEM_DMABD12PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD12INTSTA_AB_LSB, XAIEGBL_MEM_DMABD12INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD12INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD12INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD12CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD12CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD12CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD12CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD12CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD12CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD12CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD12CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD12CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD12CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD12CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD12CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD12CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD12CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD12CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD12CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD12CTRL_LEN_LSB, XAIEGBL_MEM_DMABD12CTRL_LEN_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_DMABD13ADDA,
			XAIEGBL_MEM_DMABD13ADDB,
			XAIEGBL_MEM_DMABD132DX,
			XAIEGBL_MEM_DMABD132DY,
			XAIEGBL_MEM_DMABD13PKT,
			XAIEGBL_MEM_DMABD13INTSTA,
			XAIEGBL_MEM_DMABD13CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD13ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD13ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD13ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD13ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD13ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD13ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD13ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD13ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD13ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD13ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD13ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD13ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD13ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD13ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD13ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD13ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD13ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD13ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD13ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD13ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD13ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD13ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD13ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD13ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD13ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD13ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD13ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD13ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD13ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD13ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD13ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD13ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD132DX_XINC_LSB, XAIEGBL_MEM_DMABD132DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD132DX_XWRA_LSB, XAIEGBL_MEM_DMABD132DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD132DX_XOFF_LSB, XAIEGBL_MEM_DMABD132DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD132DY_YINC_LSB, XAIEGBL_MEM_DMABD132DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD132DY_YWRA_LSB, XAIEGBL_MEM_DMABD132DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD132DY_YOFF_LSB, XAIEGBL_MEM_DMABD132DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD13PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD13PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD13PKT_ID_LSB, XAIEGBL_MEM_DMABD13PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD13INTSTA_AB_LSB, XAIEGBL_MEM_DMABD13INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD13INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD13INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD13CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD13CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD13CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD13CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD13CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD13CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD13CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD13CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD13CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD13CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD13CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD13CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD13CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD13CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD13CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD13CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD13CTRL_LEN_LSB, XAIEGBL_MEM_DMABD13CTRL_LEN_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_DMABD14ADDA,
			XAIEGBL_MEM_DMABD14ADDB,
			XAIEGBL_MEM_DMABD142DX,
			XAIEGBL_MEM_DMABD142DY,
			XAIEGBL_MEM_DMABD14PKT,
			XAIEGBL_MEM_DMABD14INTSTA,
			XAIEGBL_MEM_DMABD14CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD14ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD14ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD14ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD14ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD14ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD14ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD14ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD14ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD14ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD14ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD14ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD14ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD14ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD14ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD14ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD14ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD14ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD14ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD14ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD14ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD14ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD14ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD14ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD14ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD14ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD14ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD14ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD14ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD14ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD14ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD14ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD14ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD142DX_XINC_LSB, XAIEGBL_MEM_DMABD142DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD142DX_XWRA_LSB, XAIEGBL_MEM_DMABD142DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD142DX_XOFF_LSB, XAIEGBL_MEM_DMABD142DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD142DY_YINC_LSB, XAIEGBL_MEM_DMABD142DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD142DY_YWRA_LSB, XAIEGBL_MEM_DMABD142DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD142DY_YOFF_LSB, XAIEGBL_MEM_DMABD142DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD14PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD14PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD14PKT_ID_LSB, XAIEGBL_MEM_DMABD14PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD14INTSTA_AB_LSB, XAIEGBL_MEM_DMABD14INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD14INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD14INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD14CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD14CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD14CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD14CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD14CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD14CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD14CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD14CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD14CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD14CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD14CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD14CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD14CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD14CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD14CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD14CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD14CTRL_LEN_LSB, XAIEGBL_MEM_DMABD14CTRL_LEN_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_DMABD15ADDA,
			XAIEGBL_MEM_DMABD15ADDB,
			XAIEGBL_MEM_DMABD152DX,
			XAIEGBL_MEM_DMABD152DY,
			XAIEGBL_MEM_DMABD15PKT,
			XAIEGBL_MEM_DMABD15INTSTA,
			XAIEGBL_MEM_DMABD15CTRL,
		},
		{
			{XAIEGBL_MEM_DMABD15ADDA_LOCKIDA_LSB, XAIEGBL_MEM_DMABD15ADDA_LOCKIDA_MASK},
			{XAIEGBL_MEM_DMABD15ADDA_ENAREL_LSB, XAIEGBL_MEM_DMABD15ADDA_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD15ADDA_RELVALA_LSB, XAIEGBL_MEM_DMABD15ADDA_RELVALA_MASK},
			{XAIEGBL_MEM_DMABD15ADDA_USERELVALA_LSB, XAIEGBL_MEM_DMABD15ADDA_USERELVALA_MASK},
			{XAIEGBL_MEM_DMABD15ADDA_ENAACQ_LSB, XAIEGBL_MEM_DMABD15ADDA_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD15ADDA_ACQVALA_LSB, XAIEGBL_MEM_DMABD15ADDA_ACQVALA_MASK},
			{XAIEGBL_MEM_DMABD15ADDA_USEACQVALA_LSB, XAIEGBL_MEM_DMABD15ADDA_USEACQVALA_MASK},
			{XAIEGBL_MEM_DMABD15ADDA_BASADDA_LSB, XAIEGBL_MEM_DMABD15ADDA_BASADDA_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD15ADDB_LOCKIDB_LSB, XAIEGBL_MEM_DMABD15ADDB_LOCKIDB_MASK},
			{XAIEGBL_MEM_DMABD15ADDB_ENAREL_LSB, XAIEGBL_MEM_DMABD15ADDB_ENAREL_MASK},
			{XAIEGBL_MEM_DMABD15ADDB_RELVALB_LSB, XAIEGBL_MEM_DMABD15ADDB_RELVALB_MASK},
			{XAIEGBL_MEM_DMABD15ADDB_USERELVALB_LSB, XAIEGBL_MEM_DMABD15ADDB_USERELVALB_MASK},
			{XAIEGBL_MEM_DMABD15ADDB_ENAACQ_LSB, XAIEGBL_MEM_DMABD15ADDB_ENAACQ_MASK},
			{XAIEGBL_MEM_DMABD15ADDB_ACQVALB_LSB, XAIEGBL_MEM_DMABD15ADDB_ACQVALB_MASK},
			{XAIEGBL_MEM_DMABD15ADDB_USEACQVALB_LSB, XAIEGBL_MEM_DMABD15ADDB_USEACQVALB_MASK},
			{XAIEGBL_MEM_DMABD15ADDB_BASADDB_LSB, XAIEGBL_MEM_DMABD15ADDB_BASADDB_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD152DX_XINC_LSB, XAIEGBL_MEM_DMABD152DX_XINC_MASK},
			{XAIEGBL_MEM_DMABD152DX_XWRA_LSB, XAIEGBL_MEM_DMABD152DX_XWRA_MASK},
			{XAIEGBL_MEM_DMABD152DX_XOFF_LSB, XAIEGBL_MEM_DMABD152DX_XOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD152DY_YINC_LSB, XAIEGBL_MEM_DMABD152DY_YINC_MASK},
			{XAIEGBL_MEM_DMABD152DY_YWRA_LSB, XAIEGBL_MEM_DMABD152DY_YWRA_MASK},
			{XAIEGBL_MEM_DMABD152DY_YOFF_LSB, XAIEGBL_MEM_DMABD152DY_YOFF_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD15PKT_PKTTYP_LSB, XAIEGBL_MEM_DMABD15PKT_PKTTYP_MASK},
			{XAIEGBL_MEM_DMABD15PKT_ID_LSB, XAIEGBL_MEM_DMABD15PKT_ID_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD15INTSTA_AB_LSB, XAIEGBL_MEM_DMABD15INTSTA_AB_MASK},
			{XAIEGBL_MEM_DMABD15INTSTA_CURPTR_LSB, XAIEGBL_MEM_DMABD15INTSTA_CURPTR_MASK},
		},
		{
			{XAIEGBL_MEM_DMABD15CTRL_VALBD_LSB, XAIEGBL_MEM_DMABD15CTRL_VALBD_MASK},
			{XAIEGBL_MEM_DMABD15CTRL_ENAABMOD_LSB, XAIEGBL_MEM_DMABD15CTRL_ENAABMOD_MASK},
			{XAIEGBL_MEM_DMABD15CTRL_ENAFIFMOD_LSB, XAIEGBL_MEM_DMABD15CTRL_ENAFIFMOD_MASK},
			{XAIEGBL_MEM_DMABD15CTRL_ENAPKT_LSB, XAIEGBL_MEM_DMABD15CTRL_ENAPKT_MASK},
			{XAIEGBL_MEM_DMABD15CTRL_ENAINT_LSB, XAIEGBL_MEM_DMABD15CTRL_ENAINT_MASK},
			{XAIEGBL_MEM_DMABD15CTRL_INTCNT_LSB, XAIEGBL_MEM_DMABD15CTRL_INTCNT_MASK},
			{XAIEGBL_MEM_DMABD15CTRL_USENEXBD_LSB, XAIEGBL_MEM_DMABD15CTRL_USENEXBD_MASK},
			{XAIEGBL_MEM_DMABD15CTRL_NEXBD_LSB, XAIEGBL_MEM_DMABD15CTRL_NEXBD_MASK},
			{XAIEGBL_MEM_DMABD15CTRL_LEN_LSB, XAIEGBL_MEM_DMABD15CTRL_LEN_MASK},
		}
	}
};

/*
 * Global instance for Memory module DMA S2MM/MM2S channel control registers.
 */
XAieGbl_RegTileDmaCh TileDmaCh[] =
{
	{	XAIEGBL_MEM_DMAS2MM0CTR,
		XAIEGBL_MEM_DMAS2MM0STAQUE,
                XAIEGBL_MEM_DMAS2MMSTA,
		{XAIEGBL_MEM_DMAS2MM0CTR_RST_LSB, XAIEGBL_MEM_DMAS2MM0CTR_RST_MASK},
		{XAIEGBL_MEM_DMAS2MM0CTR_ENA_LSB, XAIEGBL_MEM_DMAS2MM0CTR_ENA_MASK},
		{XAIEGBL_MEM_DMAS2MM0STAQUE_STABD_LSB, XAIEGBL_MEM_DMAS2MM0STAQUE_STABD_MASK},
                {XAIEGBL_MEM_DMAS2MMSTA_STA0_LSB, XAIEGBL_MEM_DMAS2MMSTA_STA0_MASK}
	},
	{
		XAIEGBL_MEM_DMAS2MM1CTR,
		XAIEGBL_MEM_DMAS2MM1STAQUE,
                XAIEGBL_MEM_DMAS2MMSTA,
		{XAIEGBL_MEM_DMAS2MM1CTR_RST_LSB, XAIEGBL_MEM_DMAS2MM1CTR_RST_MASK},
		{XAIEGBL_MEM_DMAS2MM1CTR_ENA_LSB, XAIEGBL_MEM_DMAS2MM1CTR_ENA_MASK},
		{XAIEGBL_MEM_DMAS2MM1STAQUE_STABD_LSB, XAIEGBL_MEM_DMAS2MM1STAQUE_STABD_MASK},
                {XAIEGBL_MEM_DMAS2MMSTA_STA1_LSB, XAIEGBL_MEM_DMAS2MMSTA_STA1_MASK}
	},
	{
		XAIEGBL_MEM_DMAMM2S0CTR,
		XAIEGBL_MEM_DMAMM2S0STAQUE,
                XAIEGBL_MEM_DMAMM2SSTA,
		{XAIEGBL_MEM_DMAMM2S0CTR_RST_LSB, XAIEGBL_MEM_DMAMM2S0CTR_RST_MASK},
		{XAIEGBL_MEM_DMAMM2S0CTR_ENA_LSB, XAIEGBL_MEM_DMAMM2S0CTR_ENA_MASK},
		{XAIEGBL_MEM_DMAMM2S0STAQUE_STABD_LSB, XAIEGBL_MEM_DMAMM2S0STAQUE_STABD_MASK},
                {XAIEGBL_MEM_DMAMM2SSTA_STA0_LSB, XAIEGBL_MEM_DMAMM2SSTA_STA0_MASK}
	},
	{
		XAIEGBL_MEM_DMAMM2S1CTR,
		XAIEGBL_MEM_DMAMM2S1STAQUE,
                XAIEGBL_MEM_DMAMM2SSTA,
		{XAIEGBL_MEM_DMAMM2S1CTR_RST_LSB, XAIEGBL_MEM_DMAMM2S1CTR_RST_MASK},
		{XAIEGBL_MEM_DMAMM2S1CTR_ENA_LSB, XAIEGBL_MEM_DMAMM2S1CTR_ENA_MASK},
		{XAIEGBL_MEM_DMAMM2S1STAQUE_STABD_LSB, XAIEGBL_MEM_DMAMM2S1STAQUE_STABD_MASK},
                {XAIEGBL_MEM_DMAMM2SSTA_STA1_LSB, XAIEGBL_MEM_DMAMM2SSTA_STA1_MASK}
	}
};

/*
 * Global instance for Noc module Lock acquire/release registers.
 */
XAieGbl_RegLocks ShimLockRegs[] =
{
	{
		XAIEGBL_NOC_LOCK0RELNV,
		{XAIEGBL_NOC_LOCK0RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK0RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK0RELV0,
		{XAIEGBL_NOC_LOCK0RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK0RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK0RELV1,
		{XAIEGBL_NOC_LOCK0RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK0RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK0ACQNV,
		{XAIEGBL_NOC_LOCK0ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK0ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK0ACQV0,
		{XAIEGBL_NOC_LOCK0ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK0ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK0ACQV1,
		{XAIEGBL_NOC_LOCK0ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK0ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK1RELNV,
		{XAIEGBL_NOC_LOCK1RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK1RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK1RELV0,
		{XAIEGBL_NOC_LOCK1RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK1RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK1RELV1,
		{XAIEGBL_NOC_LOCK1RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK1RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK1ACQNV,
		{XAIEGBL_NOC_LOCK1ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK1ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK1ACQV0,
		{XAIEGBL_NOC_LOCK1ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK1ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK1ACQV1,
		{XAIEGBL_NOC_LOCK1ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK1ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK2RELNV,
		{XAIEGBL_NOC_LOCK2RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK2RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK2RELV0,
		{XAIEGBL_NOC_LOCK2RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK2RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK2RELV1,
		{XAIEGBL_NOC_LOCK2RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK2RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK2ACQNV,
		{XAIEGBL_NOC_LOCK2ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK2ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK2ACQV0,
		{XAIEGBL_NOC_LOCK2ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK2ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK2ACQV1,
		{XAIEGBL_NOC_LOCK2ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK2ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK3RELNV,
		{XAIEGBL_NOC_LOCK3RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK3RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK3RELV0,
		{XAIEGBL_NOC_LOCK3RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK3RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK3RELV1,
		{XAIEGBL_NOC_LOCK3RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK3RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK3ACQNV,
		{XAIEGBL_NOC_LOCK3ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK3ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK3ACQV0,
		{XAIEGBL_NOC_LOCK3ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK3ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK3ACQV1,
		{XAIEGBL_NOC_LOCK3ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK3ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK4RELNV,
		{XAIEGBL_NOC_LOCK4RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK4RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK4RELV0,
		{XAIEGBL_NOC_LOCK4RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK4RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK4RELV1,
		{XAIEGBL_NOC_LOCK4RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK4RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK4ACQNV,
		{XAIEGBL_NOC_LOCK4ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK4ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK4ACQV0,
		{XAIEGBL_NOC_LOCK4ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK4ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK4ACQV1,
		{XAIEGBL_NOC_LOCK4ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK4ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK5RELNV,
		{XAIEGBL_NOC_LOCK5RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK5RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK5RELV0,
		{XAIEGBL_NOC_LOCK5RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK5RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK5RELV1,
		{XAIEGBL_NOC_LOCK5RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK5RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK5ACQNV,
		{XAIEGBL_NOC_LOCK5ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK5ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK5ACQV0,
		{XAIEGBL_NOC_LOCK5ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK5ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK5ACQV1,
		{XAIEGBL_NOC_LOCK5ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK5ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK6RELNV,
		{XAIEGBL_NOC_LOCK6RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK6RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK6RELV0,
		{XAIEGBL_NOC_LOCK6RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK6RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK6RELV1,
		{XAIEGBL_NOC_LOCK6RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK6RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK6ACQNV,
		{XAIEGBL_NOC_LOCK6ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK6ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK6ACQV0,
		{XAIEGBL_NOC_LOCK6ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK6ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK6ACQV1,
		{XAIEGBL_NOC_LOCK6ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK6ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK7RELNV,
		{XAIEGBL_NOC_LOCK7RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK7RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK7RELV0,
		{XAIEGBL_NOC_LOCK7RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK7RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK7RELV1,
		{XAIEGBL_NOC_LOCK7RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK7RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK7ACQNV,
		{XAIEGBL_NOC_LOCK7ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK7ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK7ACQV0,
		{XAIEGBL_NOC_LOCK7ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK7ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK7ACQV1,
		{XAIEGBL_NOC_LOCK7ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK7ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK8RELNV,
		{XAIEGBL_NOC_LOCK8RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK8RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK8RELV0,
		{XAIEGBL_NOC_LOCK8RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK8RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK8RELV1,
		{XAIEGBL_NOC_LOCK8RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK8RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK8ACQNV,
		{XAIEGBL_NOC_LOCK8ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK8ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK8ACQV0,
		{XAIEGBL_NOC_LOCK8ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK8ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK8ACQV1,
		{XAIEGBL_NOC_LOCK8ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK8ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK9RELNV,
		{XAIEGBL_NOC_LOCK9RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK9RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK9RELV0,
		{XAIEGBL_NOC_LOCK9RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK9RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK9RELV1,
		{XAIEGBL_NOC_LOCK9RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK9RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK9ACQNV,
		{XAIEGBL_NOC_LOCK9ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK9ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK9ACQV0,
		{XAIEGBL_NOC_LOCK9ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK9ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK9ACQV1,
		{XAIEGBL_NOC_LOCK9ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK9ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK10RELNV,
		{XAIEGBL_NOC_LOCK10RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK10RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK10RELV0,
		{XAIEGBL_NOC_LOCK10RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK10RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK10RELV1,
		{XAIEGBL_NOC_LOCK10RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK10RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK10ACQNV,
		{XAIEGBL_NOC_LOCK10ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK10ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK10ACQV0,
		{XAIEGBL_NOC_LOCK10ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK10ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK10ACQV1,
		{XAIEGBL_NOC_LOCK10ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK10ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK11RELNV,
		{XAIEGBL_NOC_LOCK11RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK11RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK11RELV0,
		{XAIEGBL_NOC_LOCK11RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK11RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK11RELV1,
		{XAIEGBL_NOC_LOCK11RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK11RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK11ACQNV,
		{XAIEGBL_NOC_LOCK11ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK11ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK11ACQV0,
		{XAIEGBL_NOC_LOCK11ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK11ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK11ACQV1,
		{XAIEGBL_NOC_LOCK11ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK11ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK12RELNV,
		{XAIEGBL_NOC_LOCK12RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK12RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK12RELV0,
		{XAIEGBL_NOC_LOCK12RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK12RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK12RELV1,
		{XAIEGBL_NOC_LOCK12RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK12RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK12ACQNV,
		{XAIEGBL_NOC_LOCK12ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK12ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK12ACQV0,
		{XAIEGBL_NOC_LOCK12ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK12ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK12ACQV1,
		{XAIEGBL_NOC_LOCK12ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK12ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK13RELNV,
		{XAIEGBL_NOC_LOCK13RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK13RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK13RELV0,
		{XAIEGBL_NOC_LOCK13RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK13RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK13RELV1,
		{XAIEGBL_NOC_LOCK13RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK13RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK13ACQNV,
		{XAIEGBL_NOC_LOCK13ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK13ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK13ACQV0,
		{XAIEGBL_NOC_LOCK13ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK13ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK13ACQV1,
		{XAIEGBL_NOC_LOCK13ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK13ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK14RELNV,
		{XAIEGBL_NOC_LOCK14RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK14RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK14RELV0,
		{XAIEGBL_NOC_LOCK14RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK14RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK14RELV1,
		{XAIEGBL_NOC_LOCK14RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK14RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK14ACQNV,
		{XAIEGBL_NOC_LOCK14ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK14ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK14ACQV0,
		{XAIEGBL_NOC_LOCK14ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK14ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK14ACQV1,
		{XAIEGBL_NOC_LOCK14ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK14ACQV1_ACQDON_MASK}
	},
	{
		XAIEGBL_NOC_LOCK15RELNV,
		{XAIEGBL_NOC_LOCK15RELNV_RELDON_LSB, XAIEGBL_NOC_LOCK15RELNV_RELDON_MASK},
		XAIEGBL_NOC_LOCK15RELV0,
		{XAIEGBL_NOC_LOCK15RELV0_RELDON_LSB, XAIEGBL_NOC_LOCK15RELV0_RELDON_MASK},
		XAIEGBL_NOC_LOCK15RELV1,
		{XAIEGBL_NOC_LOCK15RELV1_RELDON_LSB, XAIEGBL_NOC_LOCK15RELV1_RELDON_MASK},
		XAIEGBL_NOC_LOCK15ACQNV,
		{XAIEGBL_NOC_LOCK15ACQNV_ACQDON_LSB, XAIEGBL_NOC_LOCK15ACQNV_ACQDON_MASK},
		XAIEGBL_NOC_LOCK15ACQV0,
		{XAIEGBL_NOC_LOCK15ACQV0_ACQDON_LSB, XAIEGBL_NOC_LOCK15ACQV0_ACQDON_MASK},
		XAIEGBL_NOC_LOCK15ACQV1,
		{XAIEGBL_NOC_LOCK15ACQV1_ACQDON_LSB, XAIEGBL_NOC_LOCK15ACQV1_ACQDON_MASK}
	}
};

/*
 * Global instance for Noc module DMA_BD*_* registers.
 */
XAieGbl_RegShimDmaBd ShimBd[] =
{
	{
		{
			XAIEGBL_NOC_DMABD0ADDLOW,
			XAIEGBL_NOC_DMABD0BUFLEN,
			XAIEGBL_NOC_DMABD0CTRL,
			XAIEGBL_NOC_DMABD0AXICFG,
			XAIEGBL_NOC_DMABD0PKT,
		},
		{
			XAIEGBL_NOC_DMABD0ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD0ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD0BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD0BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD0CTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD0CTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD0CTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD0CTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD0CTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD0CTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD0CTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD0CTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD0CTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD0CTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD0CTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD0CTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD0CTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD0CTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD0CTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD0CTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD0CTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD0CTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD0CTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD0CTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD0CTRL_VALBD_LSB, XAIEGBL_NOC_DMABD0CTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD0AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD0AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD0AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD0AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD0AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD0AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD0AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD0AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD0AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD0AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD0PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD0PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD0PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD0PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD0PKT_ID_LSB, XAIEGBL_NOC_DMABD0PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD1ADDLOW,
			XAIEGBL_NOC_DMABD1BUFLEN,
			XAIEGBL_NOC_DMABD1BUFCTRL,
			XAIEGBL_NOC_DMABD1AXICFG,
			XAIEGBL_NOC_DMABD1PKT,
		},
		{
			XAIEGBL_NOC_DMABD1ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD1ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD1BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD1BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD1BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD1BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD1BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD1BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD1BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD1BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD1BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD1BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD1BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD1BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD1BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD1BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD1BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD1BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD1BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD1BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD1BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD1BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD1BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD1BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD1BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD1BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD1AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD1AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD1AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD1AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD1AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD1AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD1AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD1AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD1AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD1AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD1PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD1PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD1PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD1PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD1PKT_ID_LSB, XAIEGBL_NOC_DMABD1PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD2ADDLOW,
			XAIEGBL_NOC_DMABD2BUFLEN,
			XAIEGBL_NOC_DMABD2BUFCTRL,
			XAIEGBL_NOC_DMABD2AXICFG,
			XAIEGBL_NOC_DMABD2PKT,
		},
		{
			XAIEGBL_NOC_DMABD2ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD2ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD2BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD2BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD2BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD2BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD2BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD2BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD2BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD2BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD2BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD2BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD2BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD2BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD2BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD2BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD2BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD2BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD2BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD2BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD2BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD2BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD2BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD2BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD2BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD2BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD2AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD2AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD2AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD2AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD2AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD2AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD2AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD2AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD2AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD2AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD2PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD2PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD2PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD2PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD2PKT_ID_LSB, XAIEGBL_NOC_DMABD2PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD3ADDLOW,
			XAIEGBL_NOC_DMABD3BUFLEN,
			XAIEGBL_NOC_DMABD3BUFCTRL,
			XAIEGBL_NOC_DMABD3AXICFG,
			XAIEGBL_NOC_DMABD3PKT,
		},
		{
			XAIEGBL_NOC_DMABD3ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD3ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD3BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD3BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD3BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD3BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD3BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD3BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD3BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD3BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD3BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD3BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD3BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD3BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD3BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD3BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD3BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD3BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD3BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD3BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD3BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD3BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD3BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD3BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD3BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD3BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD3AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD3AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD3AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD3AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD3AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD3AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD3AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD3AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD3AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD3AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD3PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD3PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD3PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD3PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD3PKT_ID_LSB, XAIEGBL_NOC_DMABD3PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD4ADDLOW,
			XAIEGBL_NOC_DMABD4BUFLEN,
			XAIEGBL_NOC_DMABD4BUFCTRL,
			XAIEGBL_NOC_DMABD4AXICFG,
			XAIEGBL_NOC_DMABD4PKT,
		},
		{
			XAIEGBL_NOC_DMABD4ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD4ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD4BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD4BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD4BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD4BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD4BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD4BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD4BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD4BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD4BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD4BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD4BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD4BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD4BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD4BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD4BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD4BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD4BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD4BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD4BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD4BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD4BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD4BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD4BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD4BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD4AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD4AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD4AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD4AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD4AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD4AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD4AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD4AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD4AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD4AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD4PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD4PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD4PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD4PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD4PKT_ID_LSB, XAIEGBL_NOC_DMABD4PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD5ADDLOW,
			XAIEGBL_NOC_DMABD5BUFLEN,
			XAIEGBL_NOC_DMABD5BUFCTRL,
			XAIEGBL_NOC_DMABD5AXICFG,
			XAIEGBL_NOC_DMABD5PKT,
		},
		{
			XAIEGBL_NOC_DMABD5ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD5ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD5BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD5BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD5BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD5BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD5BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD5BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD5BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD5BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD5BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD5BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD5BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD5BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD5BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD5BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD5BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD5BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD5BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD5BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD5BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD5BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD5BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD5BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD5BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD5BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD5AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD5AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD5AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD5AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD5AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD5AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD5AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD5AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD5AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD5AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD5PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD5PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD5PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD5PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD5PKT_ID_LSB, XAIEGBL_NOC_DMABD5PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD6ADDLOW,
			XAIEGBL_NOC_DMABD6BUFLEN,
			XAIEGBL_NOC_DMABD6BUFCTRL,
			XAIEGBL_NOC_DMABD6AXICFG,
			XAIEGBL_NOC_DMABD6PKT,
		},
		{
			XAIEGBL_NOC_DMABD6ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD6ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD6BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD6BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD6BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD6BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD6BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD6BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD6BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD6BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD6BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD6BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD6BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD6BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD6BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD6BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD6BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD6BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD6BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD6BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD6BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD6BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD6BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD6BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD6BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD6BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD6AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD6AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD6AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD6AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD6AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD6AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD6AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD6AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD6AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD6AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD6PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD6PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD6PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD6PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD6PKT_ID_LSB, XAIEGBL_NOC_DMABD6PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD7ADDLOW,
			XAIEGBL_NOC_DMABD7BUFLEN,
			XAIEGBL_NOC_DMABD7BUFCTRL,
			XAIEGBL_NOC_DMABD7AXICFG,
			XAIEGBL_NOC_DMABD7PKT,
		},
		{
			XAIEGBL_NOC_DMABD7ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD7ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD7BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD7BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD7BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD7BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD7BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD7BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD7BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD7BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD7BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD7BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD7BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD7BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD7BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD7BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD7BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD7BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD7BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD7BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD7BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD7BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD7BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD7BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD7BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD7BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD7AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD7AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD7AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD7AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD7AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD7AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD7AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD7AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD7AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD7AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD7PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD7PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD7PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD7PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD7PKT_ID_LSB, XAIEGBL_NOC_DMABD7PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD8ADDLOW,
			XAIEGBL_NOC_DMABD8BUFLEN,
			XAIEGBL_NOC_DMABD8BUFCTRL,
			XAIEGBL_NOC_DMABD8AXICFG,
			XAIEGBL_NOC_DMABD8PKT,
		},
		{
			XAIEGBL_NOC_DMABD8ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD8ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD8BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD8BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD8BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD8BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD8BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD8BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD8BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD8BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD8BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD8BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD8BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD8BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD8BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD8BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD8BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD8BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD8BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD8BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD8BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD8BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD8BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD8BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD8BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD8BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD8AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD8AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD8AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD8AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD8AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD8AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD8AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD8AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD8AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD8AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD8PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD8PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD8PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD8PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD8PKT_ID_LSB, XAIEGBL_NOC_DMABD8PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD9ADDLOW,
			XAIEGBL_NOC_DMABD9BUFLEN,
			XAIEGBL_NOC_DMABD9BUFCTRL,
			XAIEGBL_NOC_DMABD9AXICFG,
			XAIEGBL_NOC_DMABD9PKT,
		},
		{
			XAIEGBL_NOC_DMABD9ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD9ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD9BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD9BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD9BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD9BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD9BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD9BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD9BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD9BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD9BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD9BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD9BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD9BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD9BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD9BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD9BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD9BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD9BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD9BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD9BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD9BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD9BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD9BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD9BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD9BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD9AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD9AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD9AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD9AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD9AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD9AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD9AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD9AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD9AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD9AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD9PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD9PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD9PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD9PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD9PKT_ID_LSB, XAIEGBL_NOC_DMABD9PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD10ADDLOW,
			XAIEGBL_NOC_DMABD10BUFLEN,
			XAIEGBL_NOC_DMABD10BUFCTRL,
			XAIEGBL_NOC_DMABD10AXICFG,
			XAIEGBL_NOC_DMABD10PKT,
		},
		{
			XAIEGBL_NOC_DMABD10ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD10ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD10BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD10BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD10BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD10BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD10BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD10BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD10BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD10BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD10BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD10BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD10BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD10BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD10BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD10BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD10BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD10BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD10BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD10BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD10BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD10BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD10BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD10BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD10BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD10BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD10AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD10AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD10AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD10AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD10AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD10AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD10AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD10AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD10AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD10AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD10PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD10PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD10PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD10PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD10PKT_ID_LSB, XAIEGBL_NOC_DMABD10PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD11ADDLOW,
			XAIEGBL_NOC_DMABD11BUFLEN,
			XAIEGBL_NOC_DMABD11BUFCTRL,
			XAIEGBL_NOC_DMABD11AXICFG,
			XAIEGBL_NOC_DMABD11PKT,
		},
		{
			XAIEGBL_NOC_DMABD11ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD11ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD11BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD11BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD11BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD11BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD11BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD11BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD11BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD11BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD11BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD11BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD11BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD11BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD11BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD11BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD11BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD11BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD11BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD11BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD11BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD11BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD11BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD11BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD11BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD11BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD11AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD11AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD11AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD11AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD11AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD11AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD11AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD11AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD11AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD11AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD11PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD11PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD11PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD11PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD11PKT_ID_LSB, XAIEGBL_NOC_DMABD11PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD12ADDLOW,
			XAIEGBL_NOC_DMABD12BUFLEN,
			XAIEGBL_NOC_DMABD12BUFCTRL,
			XAIEGBL_NOC_DMABD12AXICFG,
			XAIEGBL_NOC_DMABD12PKT,
		},
		{
			XAIEGBL_NOC_DMABD12ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD12ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD12BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD12BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD12BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD12BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD12BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD12BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD12BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD12BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD12BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD12BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD12BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD12BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD12BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD12BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD12BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD12BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD12BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD12BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD12BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD12BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD12BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD12BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD12BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD12BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD12AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD12AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD12AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD12AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD12AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD12AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD12AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD12AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD12AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD12AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD12PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD12PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD12PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD12PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD12PKT_ID_LSB, XAIEGBL_NOC_DMABD12PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD13ADDLOW,
			XAIEGBL_NOC_DMABD13BUFLEN,
			XAIEGBL_NOC_DMABD13BUFCTRL,
			XAIEGBL_NOC_DMABD13AXICFG,
			XAIEGBL_NOC_DMABD13PKT,
		},
		{
			XAIEGBL_NOC_DMABD13ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD13ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD13BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD13BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD13BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD13BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD13BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD13BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD13BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD13BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD13BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD13BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD13BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD13BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD13BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD13BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD13BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD13BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD13BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD13BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD13BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD13BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD13BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD13BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD13BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD13BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD13AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD13AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD13AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD13AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD13AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD13AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD13AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD13AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD13AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD13AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD13PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD13PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD13PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD13PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD13PKT_ID_LSB, XAIEGBL_NOC_DMABD13PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD14ADDLOW,
			XAIEGBL_NOC_DMABD14BUFLEN,
			XAIEGBL_NOC_DMABD14BUFCTRL,
			XAIEGBL_NOC_DMABD14AXICFG,
			XAIEGBL_NOC_DMABD14PKT,
		},
		{
			XAIEGBL_NOC_DMABD14ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD14ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD14BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD14BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD14BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD14BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD14BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD14BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD14BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD14BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD14BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD14BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD14BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD14BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD14BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD14BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD14BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD14BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD14BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD14BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD14BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD14BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD14BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD14BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD14BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD14BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD14AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD14AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD14AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD14AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD14AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD14AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD14AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD14AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD14AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD14AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD14PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD14PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD14PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD14PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD14PKT_ID_LSB, XAIEGBL_NOC_DMABD14PKT_ID_MASK},
		},
	},
	{
		{
			XAIEGBL_NOC_DMABD15ADDLOW,
			XAIEGBL_NOC_DMABD15BUFLEN,
			XAIEGBL_NOC_DMABD15BUFCTRL,
			XAIEGBL_NOC_DMABD15AXICFG,
			XAIEGBL_NOC_DMABD15PKT,
		},
		{
			XAIEGBL_NOC_DMABD15ADDLOW_ADDLOW_LSB, XAIEGBL_NOC_DMABD15ADDLOW_ADDLOW_MASK,
		},
		{
			XAIEGBL_NOC_DMABD15BUFLEN_BUFLEN_LSB, XAIEGBL_NOC_DMABD15BUFLEN_BUFLEN_MASK,
		},
		{
			{XAIEGBL_NOC_DMABD15BUFCTRL_ADDHIG_LSB, XAIEGBL_NOC_DMABD15BUFCTRL_ADDHIG_MASK},
			{XAIEGBL_NOC_DMABD15BUFCTRL_USENEXBD_LSB, XAIEGBL_NOC_DMABD15BUFCTRL_USENEXBD_MASK},
			{XAIEGBL_NOC_DMABD15BUFCTRL_NEXBD_LSB, XAIEGBL_NOC_DMABD15BUFCTRL_NEXBD_MASK},
			{XAIEGBL_NOC_DMABD15BUFCTRL_LOCKID_LSB, XAIEGBL_NOC_DMABD15BUFCTRL_LOCKID_MASK},
			{XAIEGBL_NOC_DMABD15BUFCTRL_ENAREL_LSB, XAIEGBL_NOC_DMABD15BUFCTRL_ENAREL_MASK},
			{XAIEGBL_NOC_DMABD15BUFCTRL_RELVAL_LSB, XAIEGBL_NOC_DMABD15BUFCTRL_RELVAL_MASK},
			{XAIEGBL_NOC_DMABD15BUFCTRL_USERELVAL_LSB, XAIEGBL_NOC_DMABD15BUFCTRL_USERELVAL_MASK},
			{XAIEGBL_NOC_DMABD15BUFCTRL_ENAACQ_LSB, XAIEGBL_NOC_DMABD15BUFCTRL_ENAACQ_MASK},
			{XAIEGBL_NOC_DMABD15BUFCTRL_ACQVAL_LSB, XAIEGBL_NOC_DMABD15BUFCTRL_ACQVAL_MASK},
			{XAIEGBL_NOC_DMABD15BUFCTRL_USEACQVAL_LSB, XAIEGBL_NOC_DMABD15BUFCTRL_USEACQVAL_MASK},
			{XAIEGBL_NOC_DMABD15BUFCTRL_VALBD_LSB, XAIEGBL_NOC_DMABD15BUFCTRL_VALBD_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD15AXICFG_SMI_LSB, XAIEGBL_NOC_DMABD15AXICFG_SMI_MASK},
			{XAIEGBL_NOC_DMABD15AXICFG_BURLEN_LSB, XAIEGBL_NOC_DMABD15AXICFG_BURLEN_MASK},
			{XAIEGBL_NOC_DMABD15AXICFG_AXQ_LSB, XAIEGBL_NOC_DMABD15AXICFG_AXQ_MASK},
			{XAIEGBL_NOC_DMABD15AXICFG_SECACC_LSB, XAIEGBL_NOC_DMABD15AXICFG_SECACC_MASK},
			{XAIEGBL_NOC_DMABD15AXICFG_AXC_LSB, XAIEGBL_NOC_DMABD15AXICFG_AXC_MASK},
		},
		{
			{XAIEGBL_NOC_DMABD15PKT_ENAPKT_LSB, XAIEGBL_NOC_DMABD15PKT_ENAPKT_MASK},
			{XAIEGBL_NOC_DMABD15PKT_PKTTYP_LSB, XAIEGBL_NOC_DMABD15PKT_PKTTYP_MASK},
			{XAIEGBL_NOC_DMABD15PKT_ID_LSB, XAIEGBL_NOC_DMABD15PKT_ID_MASK},
		}
	}
};

/*
 * Global instance for Noc module DMA S2MM/MM2S channel control registers.
 */
XAieGbl_RegShimDmaCh ShimDmaCh[] =
{
	{
		XAIEGBL_NOC_DMAS2MM0CTR,
		XAIEGBL_NOC_DMAS2MM0STAQUE,
		{XAIEGBL_NOC_DMAS2MM0CTR_PAUSTR_LSB, XAIEGBL_NOC_DMAS2MM0CTR_PAUSTR_MASK},
		{XAIEGBL_NOC_DMAS2MM0CTR_PAUMEM_LSB, XAIEGBL_NOC_DMAS2MM0CTR_PAUMEM_MASK},
		{XAIEGBL_NOC_DMAS2MM0CTR_ENA_LSB, XAIEGBL_NOC_DMAS2MM0CTR_ENA_MASK},
		{XAIEGBL_NOC_DMAS2MM0STAQUE_STABD_LSB, XAIEGBL_NOC_DMAS2MM0STAQUE_STABD_MASK},
	},
	{
		XAIEGBL_NOC_DMAS2MM1CTR,
		XAIEGBL_NOC_DMAS2MM1STABDQUE,
		{XAIEGBL_NOC_DMAS2MM1CTR_PAUSTR_LSB, XAIEGBL_NOC_DMAS2MM1CTR_PAUSTR_MASK},
		{XAIEGBL_NOC_DMAS2MM1CTR_PAUMEM_LSB, XAIEGBL_NOC_DMAS2MM1CTR_PAUMEM_MASK},
		{XAIEGBL_NOC_DMAS2MM1CTR_ENA_LSB, XAIEGBL_NOC_DMAS2MM1CTR_ENA_MASK},
		{XAIEGBL_NOC_DMAS2MM1STABDQUE_STABD_LSB, XAIEGBL_NOC_DMAS2MM1STABDQUE_STABD_MASK},
	},
	{
		XAIEGBL_NOC_DMAMM2S0CTR,
		XAIEGBL_NOC_DMAMM2S0STABDQUE,
		{XAIEGBL_NOC_DMAMM2S0CTR_PAUSTR_LSB, XAIEGBL_NOC_DMAMM2S0CTR_PAUSTR_MASK},
		{XAIEGBL_NOC_DMAMM2S0CTR_PAUMEM_LSB, XAIEGBL_NOC_DMAMM2S0CTR_PAUMEM_MASK},
		{XAIEGBL_NOC_DMAMM2S0CTR_ENA_LSB, XAIEGBL_NOC_DMAMM2S0CTR_ENA_MASK},
		{XAIEGBL_NOC_DMAMM2S0STABDQUE_STABD_LSB, XAIEGBL_NOC_DMAMM2S0STABDQUE_STABD_MASK},
	},
	{
		XAIEGBL_NOC_DMAMM2S1CTR,
		XAIEGBL_NOC_DMAMM2S1STABDQUE,
		{XAIEGBL_NOC_DMAMM2S1CTR_PAUSTR_LSB, XAIEGBL_NOC_DMAMM2S1CTR_PAUSTR_MASK},
		{XAIEGBL_NOC_DMAMM2S1CTR_PAUMEM_LSB, XAIEGBL_NOC_DMAMM2S1CTR_PAUMEM_MASK},
		{XAIEGBL_NOC_DMAMM2S1CTR_ENA_LSB, XAIEGBL_NOC_DMAMM2S1CTR_ENA_MASK},
		{XAIEGBL_NOC_DMAMM2S1STABDQUE_STABD_LSB, XAIEGBL_NOC_DMAMM2S1STABDQUE_STABD_MASK},
	}
};

/*
 * Global instance for Shim DMA Status
 */
XAieGbl_RegShimDmaSts ShimDmaSts[] =
{
	{
		XAIEGBL_NOC_DMAS2MMSTA,
		{XAIEGBL_MEM_DMAS2MMSTA_STAQUEOVE0_LSB, XAIEGBL_MEM_DMAS2MMSTA_STAQUEOVE0_MASK},
		{XAIEGBL_MEM_DMAS2MMSTA_CURBD0_LSB, XAIEGBL_MEM_DMAS2MMSTA_CURBD0_MASK},
		{XAIEGBL_MEM_DMAS2MMSTA_STAQUESIZ0_LSB, XAIEGBL_MEM_DMAS2MMSTA_STAQUESIZ0_MASK},
		{XAIEGBL_MEM_DMAS2MMSTA_LOCKSTAL0_LSB, XAIEGBL_MEM_DMAS2MMSTA_LOCKSTAL0_MASK},
		{XAIEGBL_MEM_DMAS2MMSTA_STA0_LSB, XAIEGBL_MEM_DMAS2MMSTA_STA0_MASK},
	},
	{
		XAIEGBL_NOC_DMAS2MMSTA,
		{XAIEGBL_MEM_DMAS2MMSTA_STAQUEOVE1_LSB, XAIEGBL_MEM_DMAS2MMSTA_STAQUEOVE1_MASK},
		{XAIEGBL_MEM_DMAS2MMSTA_CURBD1_LSB, XAIEGBL_MEM_DMAS2MMSTA_CURBD1_MASK},
		{XAIEGBL_MEM_DMAS2MMSTA_STAQUESIZ1_LSB, XAIEGBL_MEM_DMAS2MMSTA_STAQUESIZ1_MASK},
		{XAIEGBL_MEM_DMAS2MMSTA_LOCKSTAL1_LSB, XAIEGBL_MEM_DMAS2MMSTA_LOCKSTAL1_MASK},
		{XAIEGBL_MEM_DMAS2MMSTA_STA1_LSB, XAIEGBL_MEM_DMAS2MMSTA_STA1_MASK},
	},
	{
		XAIEGBL_NOC_DMAMM2SSTA,
		{XAIEGBL_MEM_DMAMM2SSTA_STAQUEOVE0_LSB, XAIEGBL_MEM_DMAMM2SSTA_STAQUEOVE0_MASK},
		{XAIEGBL_MEM_DMAMM2SSTA_CURBD0_LSB, XAIEGBL_MEM_DMAMM2SSTA_CURBD0_MASK},
		{XAIEGBL_MEM_DMAMM2SSTA_STAQUESIZ0_LSB, XAIEGBL_MEM_DMAMM2SSTA_STAQUESIZ0_MASK},
		{XAIEGBL_MEM_DMAMM2SSTA_LOCKSTAL0_LSB, XAIEGBL_MEM_DMAMM2SSTA_LOCKSTAL0_MASK},
		{XAIEGBL_MEM_DMAMM2SSTA_STA0_LSB, XAIEGBL_MEM_DMAMM2SSTA_STA0_MASK},
	},
	{
		XAIEGBL_NOC_DMAMM2SSTA,
		{XAIEGBL_MEM_DMAMM2SSTA_STAQUEOVE1_LSB, XAIEGBL_MEM_DMAMM2SSTA_STAQUEOVE1_MASK},
		{XAIEGBL_MEM_DMAMM2SSTA_CURBD1_LSB, XAIEGBL_MEM_DMAMM2SSTA_CURBD1_MASK},
		{XAIEGBL_MEM_DMAMM2SSTA_STAQUESIZ1_LSB, XAIEGBL_MEM_DMAMM2SSTA_STAQUESIZ1_MASK},
		{XAIEGBL_MEM_DMAMM2SSTA_LOCKSTAL1_LSB, XAIEGBL_MEM_DMAMM2SSTA_LOCKSTAL1_MASK},
		{XAIEGBL_MEM_DMAMM2SSTA_STA1_LSB, XAIEGBL_MEM_DMAMM2SSTA_STA1_MASK},
	},
};

/*
 * Global instance for PL module colum reset register.
 */
XAieGbl_RegShimColumnReset ShimColumnReset =
{
	XAIEGBL_PL_AIETILCOLRST,
	{XAIEGBL_PL_AIETILCOLRST_RST_LSB, XAIEGBL_PL_AIETILCOLRST_RST_MASK},
};

/*
 * Global instance for Noc module stream mux configuration control registers.
 */
XAieGbl_RegShimMuxCfg ShimStrmMuxCfg =
{
	XAIEGBL_NOC_MUXCFG,
	{
		{XAIEGBL_NOC_MUXCFG_SOU2_LSB, XAIEGBL_NOC_MUXCFG_SOU2_MASK},
		{XAIEGBL_NOC_MUXCFG_SOU3_LSB, XAIEGBL_NOC_MUXCFG_SOU3_MASK},
		{XAIEGBL_NOC_MUXCFG_SOU6_LSB, XAIEGBL_NOC_MUXCFG_SOU6_MASK},
		{XAIEGBL_NOC_MUXCFG_SOU7_LSB, XAIEGBL_NOC_MUXCFG_SOU7_MASK},
	}
};

/*
 * Global instance for Noc module stream demux configuration control registers.
 */
XAieGbl_RegShimDemCfg ShimStrmDemCfg =
{
	XAIEGBL_NOC_DEMCFG,
	{
		{XAIEGBL_NOC_DEMCFG_SOU2_LSB, XAIEGBL_NOC_DEMCFG_SOU2_MASK},
		{XAIEGBL_NOC_DEMCFG_SOU3_LSB, XAIEGBL_NOC_DEMCFG_SOU3_MASK},
		{XAIEGBL_NOC_DEMCFG_SOU4_LSB, XAIEGBL_NOC_DEMCFG_SOU4_MASK},
		{XAIEGBL_NOC_DEMCFG_SOU5_LSB, XAIEGBL_NOC_DEMCFG_SOU5_MASK},
	}
};

/*
 * Global instance for stream switch event port configuration registers.
 * Id: 0 = Core, 1 = PL.
 */
XAieGbl_RegStrmEvtPort TileStrmEvtPort[] =
{
	{
		{
			XAIEGBL_CORE_STRSWIEVTPORTSEL0,
			XAIEGBL_CORE_STRSWIEVTPORTSEL1,
		},
		{
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0MSTRSLV_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1MSTRSLV_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2MSTRSLV_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3MSTRSLV_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4MSTRSLV_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5MSTRSLV_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6MSTRSLV_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7MSTRSLV_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7MSTRSLV_MASK},
		},
		{
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0ID_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1ID_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2ID_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3ID_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4ID_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5ID_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6ID_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7ID_LSB, XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7ID_MASK},
		},
	},
	{
		{
			XAIEGBL_PL_STRSWIEVTPORTSEL0,
			XAIEGBL_PL_STRSWIEVTPORTSEL1,
		},
		{
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0MSTRSLV_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1MSTRSLV_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2MSTRSLV_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3MSTRSLV_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4MSTRSLV_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5MSTRSLV_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6MSTRSLV_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7MSTRSLV_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7MSTRSLV_MASK},
		},
		{
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0ID_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1ID_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2ID_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3ID_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4ID_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5ID_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6ID_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7ID_LSB, XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7ID_MASK},
		},

	},
};

/*
 * Global instance for PL module PL_Interface_Upsizer_Config register.
 */
XAieGbl_RegPlUpsz UpszCfg = 
{
	XAIEGBL_PL_PLINTUPSCFG,	
	{
		{XAIEGBL_PL_PLINTUPSCFG_SOU0_LSB, XAIEGBL_PL_PLINTUPSCFG_SOU0_MASK},
		{XAIEGBL_PL_PLINTUPSCFG_SOU1_LSB, XAIEGBL_PL_PLINTUPSCFG_SOU1_MASK},
		{XAIEGBL_PL_PLINTUPSCFG_SOU2_LSB, XAIEGBL_PL_PLINTUPSCFG_SOU2_MASK},
		{XAIEGBL_PL_PLINTUPSCFG_SOU3_LSB, XAIEGBL_PL_PLINTUPSCFG_SOU3_MASK},
		{XAIEGBL_PL_PLINTUPSCFG_SOU4_LSB, XAIEGBL_PL_PLINTUPSCFG_SOU4_MASK},
		{XAIEGBL_PL_PLINTUPSCFG_SOU5_LSB, XAIEGBL_PL_PLINTUPSCFG_SOU5_MASK}
	},
	{
		{XAIEGBL_PL_PLINTUPSCFG_SOU0SOU1128COM_LSB, XAIEGBL_PL_PLINTUPSCFG_SOU0SOU1128COM_MASK},
		{XAIEGBL_PL_PLINTUPSCFG_SOU2SOU3128COM_LSB, XAIEGBL_PL_PLINTUPSCFG_SOU2SOU3128COM_MASK},
		{XAIEGBL_PL_PLINTUPSCFG_SOU4SOU5128COM_LSB, XAIEGBL_PL_PLINTUPSCFG_SOU4SOU5128COM_MASK}
	}
};

/*
 * Global instance for PL module PL_Interface_Downsizer_Config register.
 */
XAieGbl_RegPlDwsz DwszCfg = 
{
	XAIEGBL_PL_PLINTDOWCFG,	
	{
		{XAIEGBL_PL_PLINTDOWCFG_SOU0_LSB, XAIEGBL_PL_PLINTDOWCFG_SOU0_MASK},
		{XAIEGBL_PL_PLINTDOWCFG_SOU1_LSB, XAIEGBL_PL_PLINTDOWCFG_SOU1_MASK},
		{XAIEGBL_PL_PLINTDOWCFG_SOU2_LSB, XAIEGBL_PL_PLINTDOWCFG_SOU2_MASK},
		{XAIEGBL_PL_PLINTDOWCFG_SOU3_LSB, XAIEGBL_PL_PLINTDOWCFG_SOU3_MASK},
		{XAIEGBL_PL_PLINTDOWCFG_SOU4_LSB, XAIEGBL_PL_PLINTDOWCFG_SOU4_MASK},
		{XAIEGBL_PL_PLINTDOWCFG_SOU5_LSB, XAIEGBL_PL_PLINTDOWCFG_SOU5_MASK},
		{XAIEGBL_PL_PLINTDOWCFG_SOU6_LSB, XAIEGBL_PL_PLINTDOWCFG_SOU6_MASK},
		{XAIEGBL_PL_PLINTDOWCFG_SOU7_LSB, XAIEGBL_PL_PLINTDOWCFG_SOU7_MASK}
	},
	{
		{XAIEGBL_PL_PLINTDOWCFG_SOU0SOU1128COM_LSB, XAIEGBL_PL_PLINTDOWCFG_SOU0SOU1128COM_MASK},
		{XAIEGBL_PL_PLINTDOWCFG_SOU2SOU3128COM_LSB, XAIEGBL_PL_PLINTDOWCFG_SOU2SOU3128COM_MASK},
		{XAIEGBL_PL_PLINTDOWCFG_SOU4SOU5128COM_LSB, XAIEGBL_PL_PLINTDOWCFG_SOU4SOU5128COM_MASK},
		{XAIEGBL_PL_PLINTDOWCFG_SOU6SOU7128COM_LSB, XAIEGBL_PL_PLINTDOWCFG_SOU6SOU7128COM_MASK}
	}
};

/*
 * Global instance for PL module PL_Interface_Downsizer_Enable register.
 */
XAieGbl_RegPlDwszEn DwszEn =
{
	XAIEGBL_PL_PLINTDOWENA,
	{
		{XAIEGBL_PL_PLINTDOWENA_SOU0_LSB, XAIEGBL_PL_PLINTDOWENA_SOU0_MASK},
		{XAIEGBL_PL_PLINTDOWENA_SOU1_LSB, XAIEGBL_PL_PLINTDOWENA_SOU1_MASK},
		{XAIEGBL_PL_PLINTDOWENA_SOU2_LSB, XAIEGBL_PL_PLINTDOWENA_SOU2_MASK},
		{XAIEGBL_PL_PLINTDOWENA_SOU3_LSB, XAIEGBL_PL_PLINTDOWENA_SOU3_MASK},
		{XAIEGBL_PL_PLINTDOWENA_SOU4_LSB, XAIEGBL_PL_PLINTDOWENA_SOU4_MASK},
		{XAIEGBL_PL_PLINTDOWENA_SOU5_LSB, XAIEGBL_PL_PLINTDOWENA_SOU5_MASK},
		{XAIEGBL_PL_PLINTDOWENA_SOU6_LSB, XAIEGBL_PL_PLINTDOWENA_SOU6_MASK},
		{XAIEGBL_PL_PLINTDOWENA_SOU7_LSB, XAIEGBL_PL_PLINTDOWENA_SOU7_MASK}
	}
};

/*
 * Global instance for PL module PL_Interface_Downsizer_Bypass register.
 */
XAieGbl_RegPlDwszBypass DwszBypass =
{
	XAIEGBL_PL_PLINTDOWBYPASS,
	{
		{XAIEGBL_PL_PLINTDOWBYPASS_SOU0_LSB, XAIEGBL_PL_PLINTDOWBYPASS_SOU0_MASK},
		{XAIEGBL_PL_PLINTDOWBYPASS_SOU1_LSB, XAIEGBL_PL_PLINTDOWBYPASS_SOU1_MASK},
		{XAIEGBL_PL_PLINTDOWBYPASS_SOU2_LSB, XAIEGBL_PL_PLINTDOWBYPASS_SOU2_MASK},
		{XAIEGBL_PL_PLINTDOWBYPASS_SOU4_LSB, XAIEGBL_PL_PLINTDOWBYPASS_SOU4_MASK},
		{XAIEGBL_PL_PLINTDOWBYPASS_SOU5_LSB, XAIEGBL_PL_PLINTDOWBYPASS_SOU5_MASK},
		{XAIEGBL_PL_PLINTDOWBYPASS_SOU6_LSB, XAIEGBL_PL_PLINTDOWBYPASS_SOU6_MASK},
	}
};

/*
 * Global instance for PL module Stream_Switch_Master_Config_* registers.
 */
XAieGbl_RegStrmMstr ShimStrmMstr[] =
{
	{
		XAIEGBL_PL_STRSWIMSTRCFGTILCTR,
		{XAIEGBL_PL_STRSWIMSTRCFGTILCTR_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGTILCTR_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGTILCTR_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGTILCTR_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGTILCTR_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGTILCTR_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGTILCTR_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGTILCTR_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGFIF0,
		{XAIEGBL_PL_STRSWIMSTRCFGFIF0_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGFIF0_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGFIF0_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGFIF0_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGFIF0_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGFIF0_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGFIF0_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGFIF0_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGFIF1,
		{XAIEGBL_PL_STRSWIMSTRCFGFIF1_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGFIF1_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGFIF1_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGFIF1_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGFIF1_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGFIF1_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGFIF1_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGFIF1_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGSOU0,
		{XAIEGBL_PL_STRSWIMSTRCFGSOU0_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU0_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU0_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU0_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU0_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU0_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU0_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU0_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGSOU1,
		{XAIEGBL_PL_STRSWIMSTRCFGSOU1_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU1_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU1_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU1_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU1_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU1_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU1_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU1_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGSOU2,
		{XAIEGBL_PL_STRSWIMSTRCFGSOU2_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU2_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU2_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU2_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU2_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU2_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU2_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU2_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGSOU3,
		{XAIEGBL_PL_STRSWIMSTRCFGSOU3_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU3_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU3_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU3_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU3_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU3_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU3_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU3_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGSOU4,
		{XAIEGBL_PL_STRSWIMSTRCFGSOU4_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU4_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU4_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU4_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU4_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU4_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU4_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU4_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGSOU5,
		{XAIEGBL_PL_STRSWIMSTRCFGSOU5_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU5_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU5_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU5_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU5_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU5_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGSOU5_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGSOU5_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGWES0,
		{XAIEGBL_PL_STRSWIMSTRCFGWES0_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES0_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGWES0_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES0_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGWES0_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES0_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGWES0_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES0_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGWES1,
		{XAIEGBL_PL_STRSWIMSTRCFGWES1_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES1_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGWES1_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES1_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGWES1_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES1_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGWES1_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES1_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGWES2,
		{XAIEGBL_PL_STRSWIMSTRCFGWES2_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES2_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGWES2_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES2_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGWES2_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES2_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGWES2_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES2_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGWES3,
		{XAIEGBL_PL_STRSWIMSTRCFGWES3_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES3_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGWES3_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES3_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGWES3_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES3_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGWES3_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGWES3_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGNOR0,
		{XAIEGBL_PL_STRSWIMSTRCFGNOR0_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR0_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR0_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR0_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR0_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR0_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR0_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR0_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGNOR1,
		{XAIEGBL_PL_STRSWIMSTRCFGNOR1_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR1_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR1_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR1_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR1_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR1_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR1_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR1_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGNOR2,
		{XAIEGBL_PL_STRSWIMSTRCFGNOR2_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR2_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR2_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR2_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR2_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR2_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR2_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR2_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGNOR3,
		{XAIEGBL_PL_STRSWIMSTRCFGNOR3_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR3_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR3_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR3_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR3_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR3_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR3_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR3_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGNOR4,
		{XAIEGBL_PL_STRSWIMSTRCFGNOR4_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR4_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR4_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR4_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR4_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR4_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR4_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR4_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGNOR5,
		{XAIEGBL_PL_STRSWIMSTRCFGNOR5_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR5_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR5_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR5_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR5_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR5_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGNOR5_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGNOR5_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGEAS0,
		{XAIEGBL_PL_STRSWIMSTRCFGEAS0_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS0_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGEAS0_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS0_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGEAS0_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS0_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGEAS0_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS0_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGEAS1,
		{XAIEGBL_PL_STRSWIMSTRCFGEAS1_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS1_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGEAS1_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS1_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGEAS1_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS1_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGEAS1_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS1_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGEAS2,
		{XAIEGBL_PL_STRSWIMSTRCFGEAS2_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS2_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGEAS2_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS2_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGEAS2_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS2_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGEAS2_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS2_CON_MASK},
	},
	{
		XAIEGBL_PL_STRSWIMSTRCFGEAS3,
		{XAIEGBL_PL_STRSWIMSTRCFGEAS3_MSTRENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS3_MSTRENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGEAS3_PKTENA_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS3_PKTENA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGEAS3_DROHEA_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS3_DROHEA_MASK},
		{XAIEGBL_PL_STRSWIMSTRCFGEAS3_CON_LSB, XAIEGBL_PL_STRSWIMSTRCFGEAS3_CON_MASK},
	}
};

/*
 * Global instance for PL module Stream_Switch_Slave_*_Config registers.
 */
XAieGbl_RegStrmSlv ShimStrmSlv[] =
{
	{
		XAIEGBL_PL_STRSWISLVTILCTRCFG,
		{XAIEGBL_PL_STRSWISLVTILCTRCFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVTILCTRCFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRCFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVTILCTRCFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVFIF0CFG,
		{XAIEGBL_PL_STRSWISLVFIF0CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVFIF0CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVFIF0CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVFIF1CFG,
		{XAIEGBL_PL_STRSWISLVFIF1CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVFIF1CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVFIF1CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU0CFG,
		{XAIEGBL_PL_STRSWISLVSOU0CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVSOU0CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVSOU0CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU1CFG,
		{XAIEGBL_PL_STRSWISLVSOU1CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVSOU1CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVSOU1CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU2CFG,
		{XAIEGBL_PL_STRSWISLVSOU2CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVSOU2CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVSOU2CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU3CFG,
		{XAIEGBL_PL_STRSWISLVSOU3CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVSOU3CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVSOU3CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU4CFG,
		{XAIEGBL_PL_STRSWISLVSOU4CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVSOU4CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVSOU4CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU5CFG,
		{XAIEGBL_PL_STRSWISLVSOU5CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVSOU5CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVSOU5CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU6CFG,
		{XAIEGBL_PL_STRSWISLVSOU6CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVSOU6CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVSOU6CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU7CFG,
		{XAIEGBL_PL_STRSWISLVSOU7CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVSOU7CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVSOU7CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES0CFG,
		{XAIEGBL_PL_STRSWISLVWES0CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVWES0CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES0CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVWES0CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES1CFG,
		{XAIEGBL_PL_STRSWISLVWES1CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVWES1CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES1CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVWES1CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES2CFG,
		{XAIEGBL_PL_STRSWISLVWES2CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVWES2CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES2CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVWES2CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES3CFG,
		{XAIEGBL_PL_STRSWISLVWES3CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVWES3CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES3CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVWES3CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR0CFG,
		{XAIEGBL_PL_STRSWISLVNOR0CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVNOR0CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVNOR0CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR1CFG,
		{XAIEGBL_PL_STRSWISLVNOR1CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVNOR1CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVNOR1CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR2CFG,
		{XAIEGBL_PL_STRSWISLVNOR2CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVNOR2CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVNOR2CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR3CFG,
		{XAIEGBL_PL_STRSWISLVNOR3CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVNOR3CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVNOR3CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS0CFG,
		{XAIEGBL_PL_STRSWISLVEAS0CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVEAS0CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVEAS0CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS1CFG,
		{XAIEGBL_PL_STRSWISLVEAS1CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVEAS1CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVEAS1CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS2CFG,
		{XAIEGBL_PL_STRSWISLVEAS2CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVEAS2CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVEAS2CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS3CFG,
		{XAIEGBL_PL_STRSWISLVEAS3CFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVEAS3CFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3CFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVEAS3CFG_PKTENA_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVTRACFG,
		{XAIEGBL_PL_STRSWISLVTRACFG_SLVENA_LSB, XAIEGBL_PL_STRSWISLVTRACFG_SLVENA_MASK},
		{XAIEGBL_PL_STRSWISLVTRACFG_PKTENA_LSB, XAIEGBL_PL_STRSWISLVTRACFG_PKTENA_MASK},
	}
};

/*
 * Global instance for PL module Stream_Switch_Slave_*_Slot* registers.
 */
XAieGbl_RegStrmSlot ShimStrmSlot[] =
{
	{
		XAIEGBL_PL_STRSWISLVTILCTRSLO0,
		{XAIEGBL_PL_STRSWISLVTILCTRSLO0_ID_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVTILCTRSLO1,
		{XAIEGBL_PL_STRSWISLVTILCTRSLO1_ID_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVTILCTRSLO2,
		{XAIEGBL_PL_STRSWISLVTILCTRSLO2_ID_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVTILCTRSLO3,
		{XAIEGBL_PL_STRSWISLVTILCTRSLO3_ID_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVTILCTRSLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVTILCTRSLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVFIF0SLO0,
		{XAIEGBL_PL_STRSWISLVFIF0SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVFIF0SLO1,
		{XAIEGBL_PL_STRSWISLVFIF0SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVFIF0SLO2,
		{XAIEGBL_PL_STRSWISLVFIF0SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVFIF0SLO3,
		{XAIEGBL_PL_STRSWISLVFIF0SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVFIF0SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVFIF0SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVFIF1SLO0,
		{XAIEGBL_PL_STRSWISLVFIF1SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVFIF1SLO1,
		{XAIEGBL_PL_STRSWISLVFIF1SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVFIF1SLO2,
		{XAIEGBL_PL_STRSWISLVFIF1SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVFIF1SLO3,
		{XAIEGBL_PL_STRSWISLVFIF1SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVFIF1SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVFIF1SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU0SLO0,
		{XAIEGBL_PL_STRSWISLVSOU0SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU0SLO1,
		{XAIEGBL_PL_STRSWISLVSOU0SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU0SLO2,
		{XAIEGBL_PL_STRSWISLVSOU0SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU0SLO3,
		{XAIEGBL_PL_STRSWISLVSOU0SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU0SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU0SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU1SLO0,
		{XAIEGBL_PL_STRSWISLVSOU1SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU1SLO1,
		{XAIEGBL_PL_STRSWISLVSOU1SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU1SLO2,
		{XAIEGBL_PL_STRSWISLVSOU1SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU1SLO3,
		{XAIEGBL_PL_STRSWISLVSOU1SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU1SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU1SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU2SLO0,
		{XAIEGBL_PL_STRSWISLVSOU2SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU2SLO1,
		{XAIEGBL_PL_STRSWISLVSOU2SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU2SLO2,
		{XAIEGBL_PL_STRSWISLVSOU2SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU2SLO3,
		{XAIEGBL_PL_STRSWISLVSOU2SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU2SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU2SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU3SLO0,
		{XAIEGBL_PL_STRSWISLVSOU3SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU3SLO1,
		{XAIEGBL_PL_STRSWISLVSOU3SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU3SLO2,
		{XAIEGBL_PL_STRSWISLVSOU3SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU3SLO3,
		{XAIEGBL_PL_STRSWISLVSOU3SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU3SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU3SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU4SLO0,
		{XAIEGBL_PL_STRSWISLVSOU4SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU4SLO1,
		{XAIEGBL_PL_STRSWISLVSOU4SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU4SLO2,
		{XAIEGBL_PL_STRSWISLVSOU4SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU4SLO3,
		{XAIEGBL_PL_STRSWISLVSOU4SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU4SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU4SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU5SLO0,
		{XAIEGBL_PL_STRSWISLVSOU5SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU5SLO1,
		{XAIEGBL_PL_STRSWISLVSOU5SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU5SLO2,
		{XAIEGBL_PL_STRSWISLVSOU5SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU5SLO3,
		{XAIEGBL_PL_STRSWISLVSOU5SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU5SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU5SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU6SLO0,
		{XAIEGBL_PL_STRSWISLVSOU6SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU6SLO1,
		{XAIEGBL_PL_STRSWISLVSOU6SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU6SLO2,
		{XAIEGBL_PL_STRSWISLVSOU6SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU6SLO3,
		{XAIEGBL_PL_STRSWISLVSOU6SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU6SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU6SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU7SLO0,
		{XAIEGBL_PL_STRSWISLVSOU7SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU7SLO1,
		{XAIEGBL_PL_STRSWISLVSOU7SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU7SLO2,
		{XAIEGBL_PL_STRSWISLVSOU7SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVSOU7SLO3,
		{XAIEGBL_PL_STRSWISLVSOU7SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVSOU7SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVSOU7SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES0SLO0,
		{XAIEGBL_PL_STRSWISLVWES0SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVWES0SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVWES0SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVWES0SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVWES0SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVWES0SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES0SLO1,
		{XAIEGBL_PL_STRSWISLVWES0SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVWES0SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVWES0SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVWES0SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVWES0SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVWES0SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES0SLO2,
		{XAIEGBL_PL_STRSWISLVWES0SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVWES0SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVWES0SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVWES0SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVWES0SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVWES0SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES0SLO3,
		{XAIEGBL_PL_STRSWISLVWES0SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVWES0SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVWES0SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVWES0SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVWES0SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES0SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVWES0SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES1SLO0,
		{XAIEGBL_PL_STRSWISLVWES1SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVWES1SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVWES1SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVWES1SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVWES1SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVWES1SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES1SLO1,
		{XAIEGBL_PL_STRSWISLVWES1SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVWES1SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVWES1SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVWES1SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVWES1SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVWES1SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES1SLO2,
		{XAIEGBL_PL_STRSWISLVWES1SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVWES1SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVWES1SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVWES1SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVWES1SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVWES1SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES1SLO3,
		{XAIEGBL_PL_STRSWISLVWES1SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVWES1SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVWES1SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVWES1SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVWES1SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES1SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVWES1SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES2SLO0,
		{XAIEGBL_PL_STRSWISLVWES2SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVWES2SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVWES2SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVWES2SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVWES2SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVWES2SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES2SLO1,
		{XAIEGBL_PL_STRSWISLVWES2SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVWES2SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVWES2SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVWES2SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVWES2SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVWES2SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES2SLO2,
		{XAIEGBL_PL_STRSWISLVWES2SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVWES2SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVWES2SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVWES2SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVWES2SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVWES2SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES2SLO3,
		{XAIEGBL_PL_STRSWISLVWES2SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVWES2SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVWES2SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVWES2SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVWES2SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES2SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVWES2SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES3SLO0,
		{XAIEGBL_PL_STRSWISLVWES3SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVWES3SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVWES3SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVWES3SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVWES3SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVWES3SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES3SLO1,
		{XAIEGBL_PL_STRSWISLVWES3SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVWES3SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVWES3SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVWES3SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVWES3SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVWES3SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES3SLO2,
		{XAIEGBL_PL_STRSWISLVWES3SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVWES3SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVWES3SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVWES3SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVWES3SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVWES3SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVWES3SLO3,
		{XAIEGBL_PL_STRSWISLVWES3SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVWES3SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVWES3SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVWES3SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVWES3SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVWES3SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVWES3SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR0SLO0,
		{XAIEGBL_PL_STRSWISLVNOR0SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR0SLO1,
		{XAIEGBL_PL_STRSWISLVNOR0SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR0SLO2,
		{XAIEGBL_PL_STRSWISLVNOR0SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR0SLO3,
		{XAIEGBL_PL_STRSWISLVNOR0SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR0SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR0SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR1SLO0,
		{XAIEGBL_PL_STRSWISLVNOR1SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR1SLO1,
		{XAIEGBL_PL_STRSWISLVNOR1SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR1SLO2,
		{XAIEGBL_PL_STRSWISLVNOR1SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR1SLO3,
		{XAIEGBL_PL_STRSWISLVNOR1SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR1SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR1SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR2SLO0,
		{XAIEGBL_PL_STRSWISLVNOR2SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR2SLO1,
		{XAIEGBL_PL_STRSWISLVNOR2SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR2SLO2,
		{XAIEGBL_PL_STRSWISLVNOR2SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR2SLO3,
		{XAIEGBL_PL_STRSWISLVNOR2SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR2SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR2SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR3SLO0,
		{XAIEGBL_PL_STRSWISLVNOR3SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR3SLO1,
		{XAIEGBL_PL_STRSWISLVNOR3SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR3SLO2,
		{XAIEGBL_PL_STRSWISLVNOR3SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVNOR3SLO3,
		{XAIEGBL_PL_STRSWISLVNOR3SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVNOR3SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVNOR3SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS0SLO0,
		{XAIEGBL_PL_STRSWISLVEAS0SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS0SLO1,
		{XAIEGBL_PL_STRSWISLVEAS0SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS0SLO2,
		{XAIEGBL_PL_STRSWISLVEAS0SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS0SLO3,
		{XAIEGBL_PL_STRSWISLVEAS0SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS0SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS0SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS1SLO0,
		{XAIEGBL_PL_STRSWISLVEAS1SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS1SLO1,
		{XAIEGBL_PL_STRSWISLVEAS1SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS1SLO2,
		{XAIEGBL_PL_STRSWISLVEAS1SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS1SLO3,
		{XAIEGBL_PL_STRSWISLVEAS1SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS1SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS1SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS2SLO0,
		{XAIEGBL_PL_STRSWISLVEAS2SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS2SLO1,
		{XAIEGBL_PL_STRSWISLVEAS2SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS2SLO2,
		{XAIEGBL_PL_STRSWISLVEAS2SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS2SLO3,
		{XAIEGBL_PL_STRSWISLVEAS2SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS2SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS2SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS3SLO0,
		{XAIEGBL_PL_STRSWISLVEAS3SLO0_ID_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS3SLO1,
		{XAIEGBL_PL_STRSWISLVEAS3SLO1_ID_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS3SLO2,
		{XAIEGBL_PL_STRSWISLVEAS3SLO2_ID_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVEAS3SLO3,
		{XAIEGBL_PL_STRSWISLVEAS3SLO3_ID_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVEAS3SLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVEAS3SLO3_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVTRASLO0,
		{XAIEGBL_PL_STRSWISLVTRASLO0_ID_LSB, XAIEGBL_PL_STRSWISLVTRASLO0_ID_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO0_MSK_LSB, XAIEGBL_PL_STRSWISLVTRASLO0_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO0_ENA_LSB, XAIEGBL_PL_STRSWISLVTRASLO0_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO0_MSE_LSB, XAIEGBL_PL_STRSWISLVTRASLO0_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO0_ARB_LSB, XAIEGBL_PL_STRSWISLVTRASLO0_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVTRASLO1,
		{XAIEGBL_PL_STRSWISLVTRASLO1_ID_LSB, XAIEGBL_PL_STRSWISLVTRASLO1_ID_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO1_MSK_LSB, XAIEGBL_PL_STRSWISLVTRASLO1_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO1_ENA_LSB, XAIEGBL_PL_STRSWISLVTRASLO1_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO1_MSE_LSB, XAIEGBL_PL_STRSWISLVTRASLO1_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO1_ARB_LSB, XAIEGBL_PL_STRSWISLVTRASLO1_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVTRASLO2,
		{XAIEGBL_PL_STRSWISLVTRASLO2_ID_LSB, XAIEGBL_PL_STRSWISLVTRASLO2_ID_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO2_MSK_LSB, XAIEGBL_PL_STRSWISLVTRASLO2_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO2_ENA_LSB, XAIEGBL_PL_STRSWISLVTRASLO2_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO2_MSE_LSB, XAIEGBL_PL_STRSWISLVTRASLO2_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO2_ARB_LSB, XAIEGBL_PL_STRSWISLVTRASLO2_ARB_MASK},
	},
	{
		XAIEGBL_PL_STRSWISLVTRASLO3,
		{XAIEGBL_PL_STRSWISLVTRASLO3_ID_LSB, XAIEGBL_PL_STRSWISLVTRASLO3_ID_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO3_MSK_LSB, XAIEGBL_PL_STRSWISLVTRASLO3_MSK_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO3_ENA_LSB, XAIEGBL_PL_STRSWISLVTRASLO3_ENA_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO3_MSE_LSB, XAIEGBL_PL_STRSWISLVTRASLO3_MSE_MASK},
		{XAIEGBL_PL_STRSWISLVTRASLO3_ARB_LSB, XAIEGBL_PL_STRSWISLVTRASLO3_ARB_MASK},
	}
};


/*
 * Performance Counter control. Idx: 0 = Core module, 1 = PL module, 2 = Mem module
 */
XAieGbl_RegPerfCtrls PerfCtrl[] =
{
	{
		{
			XAIEGBL_CORE_PERCTR0,
			XAIEGBL_CORE_PERCTR0,
			XAIEGBL_CORE_PERCTR1,
			XAIEGBL_CORE_PERCTR1,
		},
		{
			{XAIEGBL_CORE_PERCTR0_CNT0STAEVT_LSB, XAIEGBL_CORE_PERCTR0_CNT0STAEVT_MASK},
			{XAIEGBL_CORE_PERCTR0_CNT1STAEVT_LSB, XAIEGBL_CORE_PERCTR0_CNT1STAEVT_MASK},
			{XAIEGBL_CORE_PERCTR1_CNT2STAEVT_LSB, XAIEGBL_CORE_PERCTR1_CNT2STAEVT_MASK},
			{XAIEGBL_CORE_PERCTR1_CNT3STAEVT_LSB, XAIEGBL_CORE_PERCTR1_CNT3STAEVT_MASK},
		},
		{
			{XAIEGBL_CORE_PERCTR0_CNT0STOPEVT_LSB, XAIEGBL_CORE_PERCTR0_CNT0STOPEVT_MASK},
			{XAIEGBL_CORE_PERCTR0_CNT1STOPEVT_LSB, XAIEGBL_CORE_PERCTR0_CNT1STOPEVT_MASK},
			{XAIEGBL_CORE_PERCTR1_CNT2STOPEVT_LSB, XAIEGBL_CORE_PERCTR1_CNT2STOPEVT_MASK},
			{XAIEGBL_CORE_PERCTR1_CNT3STOPEVT_LSB, XAIEGBL_CORE_PERCTR1_CNT3STOPEVT_MASK},
		},
	},
	{
		{
			XAIEGBL_PL_PERCTR0,
			XAIEGBL_PL_PERCTR0,
		},
		{
			{XAIEGBL_PL_PERCTR0_CNT0STAEVT_LSB, XAIEGBL_PL_PERCTR0_CNT0STAEVT_MASK},
			{XAIEGBL_PL_PERCTR0_CNT1STAEVT_LSB, XAIEGBL_PL_PERCTR0_CNT1STAEVT_MASK},
		},
		{
			{XAIEGBL_PL_PERCTR0_CNT0STOPEVT_LSB, XAIEGBL_PL_PERCTR0_CNT0STOPEVT_MASK},
			{XAIEGBL_PL_PERCTR0_CNT1STOPEVT_LSB, XAIEGBL_PL_PERCTR0_CNT1STOPEVT_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_PERCTRL0,
			XAIEGBL_MEM_PERCTRL0,
		},
		{
			{XAIEGBL_MEM_PERCTRL0_CNT0STAEVT_LSB, XAIEGBL_MEM_PERCTRL0_CNT0STAEVT_MASK},
			{XAIEGBL_MEM_PERCTRL0_CNT1STAEVT_LSB, XAIEGBL_MEM_PERCTRL0_CNT1STAEVT_MASK},
		},
		{
			{XAIEGBL_MEM_PERCTRL0_CNT0STOPEVT_LSB, XAIEGBL_MEM_PERCTRL0_CNT0STOPEVT_MASK},
			{XAIEGBL_MEM_PERCTRL0_CNT1STOPEVT_LSB, XAIEGBL_MEM_PERCTRL0_CNT1STOPEVT_MASK},
		},
	},
};

/*
 * Performance Counter reset. Idx: 0 = Core module, 1 = PL module, 2 = Mem module
 */
XAieGbl_RegPerfCtrlReset PerfCtrlReset[] =
{
	{
		{
			XAIEGBL_CORE_PERCTR2,
			XAIEGBL_CORE_PERCTR2,
			XAIEGBL_CORE_PERCTR2,
			XAIEGBL_CORE_PERCTR2,
		},
		{
			{XAIEGBL_CORE_PERCTR2_CNT0RSTEVT_LSB, XAIEGBL_CORE_PERCTR2_CNT0RSTEVT_MASK},
			{XAIEGBL_CORE_PERCTR2_CNT1RSTEVT_LSB, XAIEGBL_CORE_PERCTR2_CNT1RSTEVT_MASK},
			{XAIEGBL_CORE_PERCTR2_CNT2RSTEVT_LSB, XAIEGBL_CORE_PERCTR2_CNT2RSTEVT_MASK},
			{XAIEGBL_CORE_PERCTR2_CNT3RSTEVT_LSB, XAIEGBL_CORE_PERCTR2_CNT3RSTEVT_MASK},
		},
	},
	{
		{
			XAIEGBL_PL_PERCTR1,
			XAIEGBL_PL_PERCTR1,
		},
		{
			{XAIEGBL_PL_PERCTR1_CNT0RSTEVT_LSB, XAIEGBL_PL_PERCTR1_CNT0RSTEVT_MASK},
			{XAIEGBL_PL_PERCTR1_CNT1RSTEVT_LSB, XAIEGBL_PL_PERCTR1_CNT1RSTEVT_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_PERCTRL1,
			XAIEGBL_MEM_PERCTRL1,
		},
		{
			{XAIEGBL_MEM_PERCTRL1_CNT0RSTEVT_LSB, XAIEGBL_MEM_PERCTRL1_CNT0RSTEVT_MASK},
			{XAIEGBL_MEM_PERCTRL1_CNT1RSTEVT_LSB, XAIEGBL_MEM_PERCTRL1_CNT1RSTEVT_MASK},
		},
	},
};

/*
 * Performance Counter. Idx: 0 = Core module, 1 = PL module, 2 = Mem module
 */
XAieGbl_RegPerfCounter PerfCounter[] =
{
	{
		{
			XAIEGBL_CORE_PERCOU0,
			XAIEGBL_CORE_PERCOU1,
			XAIEGBL_CORE_PERCOU2,
			XAIEGBL_CORE_PERCOU3,
		},
		{
			{XAIEGBL_CORE_PERCOU0_COU0VAL_LSB, XAIEGBL_CORE_PERCOU0_COU0VAL_MASK},
			{XAIEGBL_CORE_PERCOU1_COU0VAL_LSB, XAIEGBL_CORE_PERCOU1_COU0VAL_MASK},
			{XAIEGBL_CORE_PERCOU2_COU0VAL_LSB, XAIEGBL_CORE_PERCOU2_COU0VAL_MASK},
			{XAIEGBL_CORE_PERCOU3_COU0VAL_LSB, XAIEGBL_CORE_PERCOU3_COU0VAL_MASK},
		},
	},
	{
		{
			XAIEGBL_PL_PERCOU0,
			XAIEGBL_PL_PERCOU1,
		},
		{
			{XAIEGBL_PL_PERCOU0_COU0VAL_LSB, XAIEGBL_PL_PERCOU0_COU0VAL_MASK},
			{XAIEGBL_PL_PERCOU1_COU0VAL_LSB, XAIEGBL_PL_PERCOU1_COU0VAL_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_PERCOU0,
			XAIEGBL_MEM_PERCOU1,
		},
		{
			{XAIEGBL_MEM_PERCOU0_COU0VAL_LSB, XAIEGBL_MEM_PERCOU0_COU0VAL_MASK},
			{XAIEGBL_MEM_PERCOU1_COU0VAL_LSB, XAIEGBL_MEM_PERCOU1_COU0VAL_MASK},
		},
	},
};

/*
 * Performance Counter Event. Idx: 0 = Core module, 1 = PL module, 2 = Mem module
 */
XAieGbl_RegPerfCounterEvent PerfCounterEvent[] =
{
	{
		{
			XAIEGBL_CORE_PERCOU0EVTVAL,
			XAIEGBL_CORE_PERCOU1EVTVAL,
			XAIEGBL_CORE_PERCOU2EVTVAL,
			XAIEGBL_CORE_PERCOU3EVTVAL,
		},
		{
			{XAIEGBL_CORE_PERCOU0EVTVAL_COUEVTVAL_LSB, XAIEGBL_CORE_PERCOU0EVTVAL_COUEVTVAL_MASK},
			{XAIEGBL_CORE_PERCOU1EVTVAL_COUEVTVAL_LSB, XAIEGBL_CORE_PERCOU1EVTVAL_COUEVTVAL_MASK},
			{XAIEGBL_CORE_PERCOU2EVTVAL_COUEVTVAL_LSB, XAIEGBL_CORE_PERCOU2EVTVAL_COUEVTVAL_MASK},
			{XAIEGBL_CORE_PERCOU3EVTVAL_COUEVTVAL_LSB, XAIEGBL_CORE_PERCOU3EVTVAL_COUEVTVAL_MASK},
		},
	},
	{
		{
			XAIEGBL_PL_PERCOU0EVTVAL,
			XAIEGBL_PL_PERCOU1EVTVAL,
		},
		{
			{XAIEGBL_PL_PERCOU0EVTVAL_COUEVTVAL_LSB, XAIEGBL_PL_PERCOU0EVTVAL_COUEVTVAL_MASK},
			{XAIEGBL_PL_PERCOU1EVTVAL_COUEVTVAL_LSB, XAIEGBL_PL_PERCOU1EVTVAL_COUEVTVAL_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_PERCOU0EVTVAL,
			XAIEGBL_MEM_PERCOU1EVTVAL,
		},
		{
			{XAIEGBL_MEM_PERCOU0EVTVAL_COU0EVTVAL_LSB, XAIEGBL_MEM_PERCOU0EVTVAL_COU0EVTVAL_MASK},
			{XAIEGBL_MEM_PERCOU1EVTVAL_COU1EVTVAL_LSB, XAIEGBL_MEM_PERCOU1EVTVAL_COU1EVTVAL_MASK},
		},
	},
};

/*
 * Event generate. Idx: 0 = Core module, 1 = PL module, 2 = Mem module
 */
XAieGbl_RegEventGenerate EventGenerate[] =
{
	{
		XAIEGBL_CORE_EVTGEN,
		{XAIEGBL_CORE_EVTGEN_EVT_LSB, XAIEGBL_CORE_EVTGEN_EVT_MASK},
	},
	{
		XAIEGBL_PL_EVTGEN,
		{XAIEGBL_PL_EVTGEN_EVT_LSB, XAIEGBL_PL_EVTGEN_EVT_MASK},
	},
	{
		XAIEGBL_MEM_EVTGEN,
		{XAIEGBL_MEM_EVTGEN_EVT_LSB, XAIEGBL_MEM_EVTGEN_EVT_MASK},
	},
};

/*
 * Event broadcast. Idx: 0 = Core module, 1 = PL module, 2 = Mem module
 */
XAieGbl_RegEventBroadcast EventBroadcast[] =
{
	{
		XAIEGBL_CORE_EVTBRDCAST0,
		{XAIEGBL_CORE_EVTBRDCAST0_EVT_LSB, XAIEGBL_CORE_EVTBRDCAST0_EVT_MASK},
	},
	{
		XAIEGBL_PL_EVTBRDCAST0A,
		{XAIEGBL_PL_EVTBRDCAST0A_EVT_LSB, XAIEGBL_PL_EVTBRDCAST0A_EVT_MASK},
	},
	{
		XAIEGBL_MEM_EVTBRDCAST0,
		{XAIEGBL_MEM_EVTBRDCAST0_EVT_LSB, XAIEGBL_MEM_EVTBRDCAST0_EVT_MASK},
	},
};

/*
 * Event broadcast set. Idx: 0 = Core module, 1 = PL module, 2 = Mem module
 */
XAieGbl_RegEventBroadcastSet EventBroadcastSet[] =
{
	{
		{
			XAIEGBL_CORE_EVTBRDCASTBLKSOUSET,
			XAIEGBL_CORE_EVTBRDCASTBLKWESSET,
			XAIEGBL_CORE_EVTBRDCASTBLKNORSET,
			XAIEGBL_CORE_EVTBRDCASTBLKEASSET,
		},
		{
			{XAIEGBL_CORE_EVTBRDCASTBLKSOUSET_SET_LSB, XAIEGBL_CORE_EVTBRDCASTBLKSOUSET_SET_MASK},
			{XAIEGBL_CORE_EVTBRDCASTBLKWESSET_SET_LSB, XAIEGBL_CORE_EVTBRDCASTBLKWESSET_SET_MASK},
			{XAIEGBL_CORE_EVTBRDCASTBLKNORSET_SET_LSB, XAIEGBL_CORE_EVTBRDCASTBLKNORSET_SET_MASK},
			{XAIEGBL_CORE_EVTBRDCASTBLKEASSET_SET_LSB, XAIEGBL_CORE_EVTBRDCASTBLKEASSET_SET_MASK},
		},
	},
	{
		{
			XAIEGBL_PL_EVTBRDCASTABLKSOUSET,
			XAIEGBL_PL_EVTBRDCASTABLKWESSET,
			XAIEGBL_PL_EVTBRDCASTABLKNORSET,
			XAIEGBL_PL_EVTBRDCASTABLKEASSET,
			XAIEGBL_PL_EVTBRDCASTBBLKSOUSET,
			XAIEGBL_PL_EVTBRDCASTBBLKWESSET,
			XAIEGBL_PL_EVTBRDCASTBBLKNORSET,
			XAIEGBL_PL_EVTBRDCASTBBLKEASSET,
		},
		{
			{XAIEGBL_PL_EVTBRDCASTABLKSOUSET_SET_LSB, XAIEGBL_PL_EVTBRDCASTABLKSOUSET_SET_MASK},
			{XAIEGBL_PL_EVTBRDCASTABLKWESSET_SET_LSB, XAIEGBL_PL_EVTBRDCASTABLKWESSET_SET_MASK},
			{XAIEGBL_PL_EVTBRDCASTABLKNORSET_SET_LSB, XAIEGBL_PL_EVTBRDCASTABLKNORSET_SET_MASK},
			{XAIEGBL_PL_EVTBRDCASTABLKEASSET_SET_LSB, XAIEGBL_PL_EVTBRDCASTABLKEASSET_SET_MASK},
			{XAIEGBL_PL_EVTBRDCASTBBLKSOUSET_SET_LSB, XAIEGBL_PL_EVTBRDCASTBBLKSOUSET_SET_MASK},
			{XAIEGBL_PL_EVTBRDCASTBBLKWESSET_SET_LSB, XAIEGBL_PL_EVTBRDCASTBBLKWESSET_SET_MASK},
			{XAIEGBL_PL_EVTBRDCASTBBLKNORSET_SET_LSB, XAIEGBL_PL_EVTBRDCASTBBLKNORSET_SET_MASK},
			{XAIEGBL_PL_EVTBRDCASTBBLKEASSET_SET_LSB, XAIEGBL_PL_EVTBRDCASTBBLKEASSET_SET_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_EVTBRDCASTBLKSOUSET,
			XAIEGBL_MEM_EVTBRDCASTBLKWESSET,
			XAIEGBL_MEM_EVTBRDCASTBLKNORSET,
			XAIEGBL_MEM_EVTBRDCASTBLKEASSET,
		},
		{
			{XAIEGBL_MEM_EVTBRDCASTBLKSOUSET_SET_LSB, XAIEGBL_MEM_EVTBRDCASTBLKSOUSET_SET_MASK},
			{XAIEGBL_MEM_EVTBRDCASTBLKWESSET_SET_LSB, XAIEGBL_MEM_EVTBRDCASTBLKWESSET_SET_MASK},
			{XAIEGBL_MEM_EVTBRDCASTBLKNORSET_SET_LSB, XAIEGBL_MEM_EVTBRDCASTBLKNORSET_SET_MASK},
			{XAIEGBL_MEM_EVTBRDCASTBLKEASSET_SET_LSB, XAIEGBL_MEM_EVTBRDCASTBLKEASSET_SET_MASK},
		},
	},
};

/*
 * Event broadcast clear. Idx: 0 = Core module, 1 = PL module, 2 = Mem module
 */
XAieGbl_RegEventBroadcastClear EventBroadcastClear[] =
{
	{
		{
			XAIEGBL_CORE_EVTBRDCASTBLKSOUCLR,
			XAIEGBL_CORE_EVTBRDCASTBLKWESCLR,
			XAIEGBL_CORE_EVTBRDCASTBLKNORCLR,
			XAIEGBL_CORE_EVTBRDCASTBLKEASCLR,
		},
		{
			{XAIEGBL_CORE_EVTBRDCASTBLKSOUCLR_CLR_LSB, XAIEGBL_CORE_EVTBRDCASTBLKSOUCLR_CLR_MASK},
			{XAIEGBL_CORE_EVTBRDCASTBLKWESCLR_CLR_LSB, XAIEGBL_CORE_EVTBRDCASTBLKWESCLR_CLR_MASK},
			{XAIEGBL_CORE_EVTBRDCASTBLKNORCLR_CLR_LSB, XAIEGBL_CORE_EVTBRDCASTBLKNORCLR_CLR_MASK},
			{XAIEGBL_CORE_EVTBRDCASTBLKEASCLR_CLR_LSB, XAIEGBL_CORE_EVTBRDCASTBLKEASCLR_CLR_MASK},
		},
	},
	{
		{
			XAIEGBL_PL_EVTBRDCASTABLKSOUCLR,
			XAIEGBL_PL_EVTBRDCASTABLKWESCLR,
			XAIEGBL_PL_EVTBRDCASTABLKNORCLR,
			XAIEGBL_PL_EVTBRDCASTABLKEASCLR,
			XAIEGBL_PL_EVTBRDCASTBBLKSOUCLR,
			XAIEGBL_PL_EVTBRDCASTBBLKWESCLR,
			XAIEGBL_PL_EVTBRDCASTBBLKNORCLR,
			XAIEGBL_PL_EVTBRDCASTBBLKEASCLR,
		},
		{
			{XAIEGBL_PL_EVTBRDCASTABLKSOUCLR_CLR_LSB, XAIEGBL_PL_EVTBRDCASTABLKSOUCLR_CLR_MASK},
			{XAIEGBL_PL_EVTBRDCASTABLKWESCLR_CLR_LSB, XAIEGBL_PL_EVTBRDCASTABLKWESCLR_CLR_MASK},
			{XAIEGBL_PL_EVTBRDCASTABLKNORCLR_CLR_LSB, XAIEGBL_PL_EVTBRDCASTABLKNORCLR_CLR_MASK},
			{XAIEGBL_PL_EVTBRDCASTABLKEASCLR_CLR_LSB, XAIEGBL_PL_EVTBRDCASTABLKEASCLR_CLR_MASK},
			{XAIEGBL_PL_EVTBRDCASTBBLKSOUCLR_CLR_LSB, XAIEGBL_PL_EVTBRDCASTBBLKSOUCLR_CLR_MASK},
			{XAIEGBL_PL_EVTBRDCASTBBLKWESCLR_CLR_LSB, XAIEGBL_PL_EVTBRDCASTBBLKWESCLR_CLR_MASK},
			{XAIEGBL_PL_EVTBRDCASTBBLKNORCLR_CLR_LSB, XAIEGBL_PL_EVTBRDCASTBBLKNORCLR_CLR_MASK},
			{XAIEGBL_PL_EVTBRDCASTBBLKEASCLR_CLR_LSB, XAIEGBL_PL_EVTBRDCASTBBLKEASCLR_CLR_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_EVTBRDCASTBLKSOUCLR,
			XAIEGBL_MEM_EVTBRDCASTBLKWESCLR,
			XAIEGBL_MEM_EVTBRDCASTBLKNORCLR,
			XAIEGBL_MEM_EVTBRDCASTBLKEASCLR,
		},
		{
			{XAIEGBL_MEM_EVTBRDCASTBLKSOUCLR_CLR_LSB, XAIEGBL_MEM_EVTBRDCASTBLKSOUCLR_CLR_MASK},
			{XAIEGBL_MEM_EVTBRDCASTBLKWESCLR_CLR_LSB, XAIEGBL_MEM_EVTBRDCASTBLKWESCLR_CLR_MASK},
			{XAIEGBL_MEM_EVTBRDCASTBLKNORCLR_CLR_LSB, XAIEGBL_MEM_EVTBRDCASTBLKNORCLR_CLR_MASK},
			{XAIEGBL_MEM_EVTBRDCASTBLKEASCLR_CLR_LSB, XAIEGBL_MEM_EVTBRDCASTBLKEASCLR_CLR_MASK},
		},
	},
};

/*
 * Event broadcast value. Idx: 0 = Core module, 1 = PL module, 2 = Mem module
 */
XAieGbl_RegEventBroadcastValue EventBroadcastValue[] =
{
	{
		{
			XAIEGBL_CORE_EVTBRDCASTBLKSOUVAL,
			XAIEGBL_CORE_EVTBRDCASTBLKWESVAL,
			XAIEGBL_CORE_EVTBRDCASTBLKNORVAL,
			XAIEGBL_CORE_EVTBRDCASTBLKEASVAL,
		},
		{
			{XAIEGBL_CORE_EVTBRDCASTBLKSOUVAL_VAL_LSB, XAIEGBL_CORE_EVTBRDCASTBLKSOUVAL_VAL_MASK},
			{XAIEGBL_CORE_EVTBRDCASTBLKWESVAL_VAL_LSB, XAIEGBL_CORE_EVTBRDCASTBLKWESVAL_VAL_MASK},
			{XAIEGBL_CORE_EVTBRDCASTBLKNORVAL_VAL_LSB, XAIEGBL_CORE_EVTBRDCASTBLKNORVAL_VAL_MASK},
			{XAIEGBL_CORE_EVTBRDCASTBLKEASVAL_VAL_LSB, XAIEGBL_CORE_EVTBRDCASTBLKEASVAL_VAL_MASK},
		},
	},
	{
		{
			XAIEGBL_PL_EVTBRDCASTABLKSOUVAL,
			XAIEGBL_PL_EVTBRDCASTABLKWESVAL,
			XAIEGBL_PL_EVTBRDCASTABLKNORVAL,
			XAIEGBL_PL_EVTBRDCASTABLKEASVAL,
			XAIEGBL_PL_EVTBRDCASTBBLKSOUVAL,
			XAIEGBL_PL_EVTBRDCASTBBLKWESVAL,
			XAIEGBL_PL_EVTBRDCASTBBLKNORVAL,
			XAIEGBL_PL_EVTBRDCASTBBLKEASVAL,
		},
		{
			{XAIEGBL_PL_EVTBRDCASTABLKSOUVAL_VAL_LSB, XAIEGBL_PL_EVTBRDCASTABLKSOUVAL_VAL_MASK},
			{XAIEGBL_PL_EVTBRDCASTABLKWESVAL_VAL_LSB, XAIEGBL_PL_EVTBRDCASTABLKWESVAL_VAL_MASK},
			{XAIEGBL_PL_EVTBRDCASTABLKNORVAL_VAL_LSB, XAIEGBL_PL_EVTBRDCASTABLKNORVAL_VAL_MASK},
			{XAIEGBL_PL_EVTBRDCASTABLKEASVAL_VAL_LSB, XAIEGBL_PL_EVTBRDCASTABLKEASVAL_VAL_MASK},
			{XAIEGBL_PL_EVTBRDCASTBBLKSOUVAL_VAL_LSB, XAIEGBL_PL_EVTBRDCASTBBLKSOUVAL_VAL_MASK},
			{XAIEGBL_PL_EVTBRDCASTBBLKWESVAL_VAL_LSB, XAIEGBL_PL_EVTBRDCASTBBLKWESVAL_VAL_MASK},
			{XAIEGBL_PL_EVTBRDCASTBBLKNORVAL_VAL_LSB, XAIEGBL_PL_EVTBRDCASTBBLKNORVAL_VAL_MASK},
			{XAIEGBL_PL_EVTBRDCASTBBLKEASVAL_VAL_LSB, XAIEGBL_PL_EVTBRDCASTBBLKEASVAL_VAL_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_EVTBRDCASTBLKSOUVAL,
			XAIEGBL_MEM_EVTBRDCASTBLKWESVAL,
			XAIEGBL_MEM_EVTBRDCASTBLKNORVAL,
			XAIEGBL_MEM_EVTBRDCASTBLKEASVAL,
		},
		{
			{XAIEGBL_MEM_EVTBRDCASTBLKSOUVAL_VAL_LSB, XAIEGBL_MEM_EVTBRDCASTBLKSOUVAL_VAL_MASK},
			{XAIEGBL_MEM_EVTBRDCASTBLKWESVAL_VAL_LSB, XAIEGBL_MEM_EVTBRDCASTBLKWESVAL_VAL_MASK},
			{XAIEGBL_MEM_EVTBRDCASTBLKNORVAL_VAL_LSB, XAIEGBL_MEM_EVTBRDCASTBLKNORVAL_VAL_MASK},
			{XAIEGBL_MEM_EVTBRDCASTBLKEASVAL_VAL_LSB, XAIEGBL_MEM_EVTBRDCASTBLKEASVAL_VAL_MASK},
		},
	},
};

XAieGbl_RegTraceCtrls TraceCtrl[] =
{
	{
		{
			XAIEGBL_CORE_TRACTRL0,
			XAIEGBL_CORE_TRACTRL1,
		},
		{XAIEGBL_CORE_TRACTRL0_MOD_LSB, XAIEGBL_CORE_TRACTRL0_MOD_MASK},
		{XAIEGBL_CORE_TRACTRL0_TRASTAEVT_LSB, XAIEGBL_CORE_TRACTRL0_TRASTAEVT_MASK},
		{XAIEGBL_CORE_TRACTRL0_TRASTOPEVT_LSB, XAIEGBL_CORE_TRACTRL0_TRASTOPEVT_MASK},
		{XAIEGBL_CORE_TRACTRL1_ID_LSB, XAIEGBL_CORE_TRACTRL1_ID_MASK},
		{XAIEGBL_CORE_TRACTRL1_PKTTYP_LSB, XAIEGBL_CORE_TRACTRL1_PKTTYP_MASK},
	},
	{
		{
			XAIEGBL_PL_TRACTRL0,
			XAIEGBL_PL_TRACTRL1,
		},
		{0, 0}, /* No mode config */
		{XAIEGBL_PL_TRACTRL0_TRASTAEVT_LSB, XAIEGBL_PL_TRACTRL0_TRASTAEVT_MASK},
		{XAIEGBL_PL_TRACTRL0_TRASTOPEVT_LSB, XAIEGBL_PL_TRACTRL0_TRASTOPEVT_MASK},
		{XAIEGBL_PL_TRACTRL1_ID_LSB, XAIEGBL_PL_TRACTRL1_ID_MASK},
		{XAIEGBL_PL_TRACTRL1_PKTTYP_LSB, XAIEGBL_PL_TRACTRL1_PKTTYP_MASK},
	},
	{
		{
			XAIEGBL_MEM_TRACTRL0,
			XAIEGBL_MEM_TRACTRL1,
		},
		{0, 0}, /* No mode config */
		{XAIEGBL_MEM_TRACTRL0_TRASTAEVT_LSB, XAIEGBL_MEM_TRACTRL0_TRASTAEVT_MASK},
		{XAIEGBL_MEM_TRACTRL0_TRASTOPEVT_LSB, XAIEGBL_MEM_TRACTRL0_TRASTOPEVT_MASK},
		{XAIEGBL_MEM_TRACTRL1_ID_LSB, XAIEGBL_MEM_TRACTRL1_ID_MASK},
		{XAIEGBL_MEM_TRACTRL1_PKTTYP_LSB, XAIEGBL_MEM_TRACTRL1_PKTTYP_MASK},
	},
};

/*
 * Trace event. Idx: 0 = Core module, 1 = PL module, 2 = Mem module
 */
XAieGbl_RegTraceEvent TraceEvent[] =
{
	{
		{
			XAIEGBL_CORE_TRAEVT0,
			XAIEGBL_CORE_TRAEVT1,
		},
		{
			{XAIEGBL_CORE_TRAEVT0_TRAEVT0_LSB, XAIEGBL_CORE_TRAEVT0_TRAEVT0_MASK},
			{XAIEGBL_CORE_TRAEVT0_TRAEVT1_LSB, XAIEGBL_CORE_TRAEVT0_TRAEVT1_MASK},
			{XAIEGBL_CORE_TRAEVT0_TRAEVT2_LSB, XAIEGBL_CORE_TRAEVT0_TRAEVT2_MASK},
			{XAIEGBL_CORE_TRAEVT0_TRAEVT3_LSB, XAIEGBL_CORE_TRAEVT0_TRAEVT3_MASK},
			{XAIEGBL_CORE_TRAEVT1_TRAEVT4_LSB, XAIEGBL_CORE_TRAEVT1_TRAEVT4_MASK},
			{XAIEGBL_CORE_TRAEVT1_TRAEVT5_LSB, XAIEGBL_CORE_TRAEVT1_TRAEVT5_MASK},
			{XAIEGBL_CORE_TRAEVT1_TRAEVT6_LSB, XAIEGBL_CORE_TRAEVT1_TRAEVT6_MASK},
			{XAIEGBL_CORE_TRAEVT1_TRAEVT7_LSB, XAIEGBL_CORE_TRAEVT1_TRAEVT7_MASK},
		},
	},
	{
		{
			XAIEGBL_PL_TRAEVT0,
			XAIEGBL_PL_TRAEVT1,
		},
		{
			{XAIEGBL_PL_TRAEVT0_TRAEVT0_LSB, XAIEGBL_PL_TRAEVT0_TRAEVT0_MASK},
			{XAIEGBL_PL_TRAEVT0_TRAEVT1_LSB, XAIEGBL_PL_TRAEVT0_TRAEVT1_MASK},
			{XAIEGBL_PL_TRAEVT0_TRAEVT2_LSB, XAIEGBL_PL_TRAEVT0_TRAEVT2_MASK},
			{XAIEGBL_PL_TRAEVT0_TRAEVT3_LSB, XAIEGBL_PL_TRAEVT0_TRAEVT3_MASK},
			{XAIEGBL_PL_TRAEVT1_TRAEVT4_LSB, XAIEGBL_PL_TRAEVT1_TRAEVT4_MASK},
			{XAIEGBL_PL_TRAEVT1_TRAEVT5_LSB, XAIEGBL_PL_TRAEVT1_TRAEVT5_MASK},
			{XAIEGBL_PL_TRAEVT1_TRAEVT6_LSB, XAIEGBL_PL_TRAEVT1_TRAEVT6_MASK},
			{XAIEGBL_PL_TRAEVT1_TRAEVT7_LSB, XAIEGBL_PL_TRAEVT1_TRAEVT7_MASK},
		},
	},
	{
		{
			XAIEGBL_MEM_TRAEVT0,
			XAIEGBL_MEM_TRAEVT1,
		},
		{
			{XAIEGBL_MEM_TRAEVT0_TRAEVT0_LSB, XAIEGBL_MEM_TRAEVT0_TRAEVT0_MASK},
			{XAIEGBL_MEM_TRAEVT0_TRAEVT1_LSB, XAIEGBL_MEM_TRAEVT0_TRAEVT1_MASK},
			{XAIEGBL_MEM_TRAEVT0_TRAEVT2_LSB, XAIEGBL_MEM_TRAEVT0_TRAEVT2_MASK},
			{XAIEGBL_MEM_TRAEVT0_TRAEVT3_LSB, XAIEGBL_MEM_TRAEVT0_TRAEVT3_MASK},
			{XAIEGBL_MEM_TRAEVT1_TRAEVT4_LSB, XAIEGBL_MEM_TRAEVT1_TRAEVT4_MASK},
			{XAIEGBL_MEM_TRAEVT1_TRAEVT5_LSB, XAIEGBL_MEM_TRAEVT1_TRAEVT5_MASK},
			{XAIEGBL_MEM_TRAEVT1_TRAEVT6_LSB, XAIEGBL_MEM_TRAEVT1_TRAEVT6_MASK},
			{XAIEGBL_MEM_TRAEVT1_TRAEVT7_LSB, XAIEGBL_MEM_TRAEVT1_TRAEVT7_MASK},
		},
	},
};

XAieGbl_RegCorePCEvent CorePCEvents[] =
{
	{
		XAIEGBL_CORE_PCEVT0,
		{XAIEGBL_CORE_PCEVT0_PCADD_LSB, XAIEGBL_CORE_PCEVT0_PCADD_MASK},
		{XAIEGBL_CORE_PCEVT0_VAL_LSB, XAIEGBL_CORE_PCEVT0_VAL_MASK},
	},
	{
		XAIEGBL_CORE_PCEVT1,
		{XAIEGBL_CORE_PCEVT1_PCADD_LSB, XAIEGBL_CORE_PCEVT1_PCADD_MASK},
		{XAIEGBL_CORE_PCEVT1_VAL_LSB, XAIEGBL_CORE_PCEVT1_VAL_MASK},
	},
	{
		XAIEGBL_CORE_PCEVT2,
		{XAIEGBL_CORE_PCEVT2_PCADD_LSB, XAIEGBL_CORE_PCEVT2_PCADD_MASK},
		{XAIEGBL_CORE_PCEVT2_VAL_LSB, XAIEGBL_CORE_PCEVT2_VAL_MASK},
	},
	{
		XAIEGBL_CORE_PCEVT3,
		{XAIEGBL_CORE_PCEVT3_PCADD_LSB, XAIEGBL_CORE_PCEVT3_PCADD_MASK},
		{XAIEGBL_CORE_PCEVT3_VAL_LSB, XAIEGBL_CORE_PCEVT3_VAL_MASK},
	},
};

XAieGbl_GroupEvents GroupEvents[] =
{
	{
		{
			XAIEGBL_CORE_EVTGRP0ENAMSK,
			XAIEGBL_CORE_EVTGRPPCENAMSK,
			XAIEGBL_CORE_EVTGRPCORESTALENAMSK,
			XAIEGBL_CORE_EVTGRPCOREPRGFLOENAMSK,
			XAIEGBL_CORE_EVTGRPERR0ENAMSK,
			XAIEGBL_CORE_EVTGRPERR1ENAMSK,
			XAIEGBL_CORE_EVTGRPSTRSWIENAMSK,
			XAIEGBL_CORE_EVTGRPBRDCASTENAMSK,
			XAIEGBL_CORE_EVTGRPUSREVTENAMSK,
		},
	},
	{
		{
			XAIEGBL_PL_EVTGRP0ENAMSK,
			XAIEGBL_PL_EVTGRPDMAACTENAMSK,
			XAIEGBL_PL_EVTGRPLOCKENAMSK,
			XAIEGBL_PL_EVTGRPERRENAMSK,
			XAIEGBL_PL_EVTGRPSTRSWIENAMSK,
			XAIEGBL_PL_EVTGRPBRDCASTAENAMSK,
			XAIEGBL_PL_EVTGRPUSRENAMSK,
		},
	},
	{
		{
			XAIEGBL_MEM_EVTGRP0ENAMSK,
			XAIEGBL_MEM_EVTGRPWTCHPTENAMSK,
			XAIEGBL_MEM_EVTGRPDMAENAMSK,
			XAIEGBL_MEM_EVTGRPLOCKENAMSK,
			XAIEGBL_MEM_EVTGRPMEMCONENAMSK,
			XAIEGBL_MEM_EVTGRPERRENAMSK,
			XAIEGBL_MEM_EVTGRPBRDCASTENAMSK,
			XAIEGBL_MEM_EVTGRPUSREVTENAMSK,
		},
	},
};

XAieGbl_ComboEventInput ComboEventInput[] =
{
	{
		{
			XAIEGBL_CORE_COMEVTINP_EVTA_LSB,
			XAIEGBL_CORE_COMEVTINP_EVTB_LSB,
			XAIEGBL_CORE_COMEVTINP_EVTC_LSB,
			XAIEGBL_CORE_COMEVTINP_EVTD_LSB,
		},
		{
			XAIEGBL_CORE_COMEVTINP_EVTA_MASK,
			XAIEGBL_CORE_COMEVTINP_EVTB_MASK,
			XAIEGBL_CORE_COMEVTINP_EVTC_MASK,
			XAIEGBL_CORE_COMEVTINP_EVTD_MASK,
		},
	},
	{
		{
			XAIEGBL_PL_COMEVTINP_EVTA_LSB,
			XAIEGBL_PL_COMEVTINP_EVTB_LSB,
			XAIEGBL_PL_COMEVTINP_EVTC_LSB,
			XAIEGBL_PL_COMEVTINP_EVTD_LSB,
		},
		{
			XAIEGBL_PL_COMEVTINP_EVTA_MASK,
			XAIEGBL_PL_COMEVTINP_EVTB_MASK,
			XAIEGBL_PL_COMEVTINP_EVTC_MASK,
			XAIEGBL_PL_COMEVTINP_EVTD_MASK,
		},
	},
	{
		{
			XAIEGBL_MEM_COMEVTINP_EVTA_LSB,
			XAIEGBL_MEM_COMEVTINP_EVTB_LSB,
			XAIEGBL_MEM_COMEVTINP_EVTC_LSB,
			XAIEGBL_MEM_COMEVTINP_EVTD_LSB,
		},
		{
			XAIEGBL_MEM_COMEVTINP_EVTA_MASK,
			XAIEGBL_MEM_COMEVTINP_EVTB_MASK,
			XAIEGBL_MEM_COMEVTINP_EVTC_MASK,
			XAIEGBL_MEM_COMEVTINP_EVTD_MASK,
		},
	},
};

XAieGbl_ComboEventControl ComboEventControl[] =
{
	{
		{
			XAIEGBL_CORE_COMEVTCTRL_COM0_LSB,
			XAIEGBL_CORE_COMEVTCTRL_COM1_LSB,
			XAIEGBL_CORE_COMEVTCTRL_COM2_LSB,
		},
		{
			XAIEGBL_CORE_COMEVTCTRL_COM0_MASK,
			XAIEGBL_CORE_COMEVTCTRL_COM1_MASK,
			XAIEGBL_CORE_COMEVTCTRL_COM2_MASK,
		},
	},
	{
		{
			XAIEGBL_PL_COMEVTCTRL_COM0_LSB,
			XAIEGBL_PL_COMEVTCTRL_COM1_LSB,
			XAIEGBL_PL_COMEVTCTRL_COM2_LSB,
		},
		{
			XAIEGBL_PL_COMEVTCTRL_COM0_MASK,
			XAIEGBL_PL_COMEVTCTRL_COM1_MASK,
			XAIEGBL_PL_COMEVTCTRL_COM2_MASK,
		},
	},
	{
		{
			XAIEGBL_MEM_COMEVTCTRL_COM0_LSB,
			XAIEGBL_MEM_COMEVTCTRL_COM1_LSB,
			XAIEGBL_MEM_COMEVTCTRL_COM2_LSB,
		},
		{
			XAIEGBL_MEM_COMEVTCTRL_COM0_MASK,
			XAIEGBL_MEM_COMEVTCTRL_COM1_MASK,
			XAIEGBL_MEM_COMEVTCTRL_COM2_MASK,
		},
	},
};

XAieGbl_RegShimReset ShimReset =
{
	XAIEGBL_PL_AIESHIRSTENA,
	{XAIEGBL_PL_AIESHIRSTENA_RST_LSB, XAIEGBL_PL_AIESHIRSTENA_RST_MASK},
};

XAieGbl_RegStrmSwEventPortSelect StrmSwEventPortSelect[] =
{
	{
		XAIEGBL_CORE_STRSWIEVTPORTSEL0,
		{
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0ID_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1ID_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2ID_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3ID_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4ID_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5ID_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6ID_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6ID_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7ID_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7ID_MASK},
		},
		{
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0MSTRSLV_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1MSTRSLV_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2MSTRSLV_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3MSTRSLV_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4MSTRSLV_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5MSTRSLV_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6MSTRSLV_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6MSTRSLV_MASK},
			{XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7MSTRSLV_LSB,
			 XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7MSTRSLV_MASK},
		},
	},
	{
		XAIEGBL_PL_STRSWIEVTPORTSEL0,
		{
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0ID_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1ID_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2ID_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3ID_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4ID_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5ID_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6ID_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6ID_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7ID_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7ID_MASK},
		},
		{
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0MSTRSLV_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1MSTRSLV_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2MSTRSLV_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3MSTRSLV_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4MSTRSLV_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5MSTRSLV_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6MSTRSLV_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6MSTRSLV_MASK},
			{XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7MSTRSLV_LSB,
			 XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7MSTRSLV_MASK},
		}
	},
};

XAieGbl_1stIrqCntr Shim_1stIrqCntr =
{
	(XAIEGBL_PL_INTCON1STLEVMSKB - XAIEGBL_PL_INTCON1STLEVMSKA),
	XAIEGBL_PL_INTCON1STLEVMSKA,
	XAIEGBL_PL_INTCON1STLEVENAA,
	XAIEGBL_PL_INTCON1STLEVDISA,
	XAIEGBL_PL_INTCON1STLEVSTAA,
	XAIEGBL_PL_INTCON1STLEVIRQNOA,
	XAIEGBL_PL_INTCON1STLEVIRQEVTA,
	XAIEGBL_PL_INTCON1STLEVBLKNORINASET,
	XAIEGBL_PL_INTCON1STLEVBLKNORINACLR,
	XAIEGBL_PL_INTCON1STLEVBLKNORINAVAL,
	{XAIEGBL_PL_INTCON1STLEVMSKA_IRQMSKA_LSB,
	 XAIEGBL_PL_INTCON1STLEVMSKA_IRQMSKA_MASK},
	{XAIEGBL_PL_INTCON1STLEVIRQNOB_STAB_LSB,
	 XAIEGBL_PL_INTCON1STLEVIRQNOB_STAB_MASK},
	{XAIEGBL_PL_INTCON1STLEVBLKNORINBVAL_VAL_LSB,
	 XAIEGBL_PL_INTCON1STLEVBLKNORINBVAL_VAL_MASK},
	{
		{XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT0_LSB,
		 XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT0_MASK},
		{XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT1_LSB,
		 XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT1_MASK},
		{XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT2_LSB,
		 XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT2_MASK},
		{XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT3_LSB,
		 XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT3_MASK},
	},
};

/************************** Function Definitions ******************************/

/** @} */
