/******************************************************************************
* Copyright (c) 2022 Xilinx, Inc.  All rights reserved.
* Copyright (C) 2022 - 2024 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


/******************************************************************************/
/**
*
* @file net/client/xnvm_efuseclient_hw.h
*
* This file contains register offsets for EFUSE_CACHE module and other related
* definitions.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who  Date        Changes
* ----- ---- ---------- --------------------------------------------------------
* 3.0   har  07/06/22   Initial release
*
* </pre>
*
* @note
*
*******************************************************************************/

#ifndef XNVM_EFUSECLIENT_HW_H
#define XNVM_EFUSECLIENT_HW_H

#ifdef __cplusplus
extern "C" {
#endif

/****************************** Include Files *********************************/
/*************************** Constant Definitions *****************************/
/**
 *  @name eFUSE Cache Register Offsets
 */
/**< eFUSE Cache Register Offsets */
#define XNVM_EFUSE_CACHE_METAHEADER_IV_RANGE_0_OFFSET		(0x00000180U)
#define XNVM_EFUSE_CACHE_BLACK_IV_0_OFFSET			(0x000001D0U)
#define XNVM_EFUSE_CACHE_PLM_IV_RANGE_0_OFFSET			(0x000001DCU)
#define XNVM_EFUSE_CACHE_DATA_PARTITION_IV_RANGE_0_OFFSET	(0x000001E8U)
#define XNVM_EFUSE_CACHE_REVOCATION_ID_0_OFFSET			(0x000000B0U)
#define XNVM_EFUSE_CACHE_USER_FUSE_OFFSET			(0x00000240U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_OFFSET			(0x000000A0U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_OFFSET		(0x000000ACU)
#define XNVM_EFUSE_CACHE_OFFCHIP_REVOKE_0_OFFSET		(0x00000160U)
#define XNVM_EFUSE_CACHE_PPK0_HASH_0_OFFSET			(0x00000100U)
#define XNVM_EFUSE_CACHE_PPK0_HASH_1_OFFSET			(0x00000120U)
#define XNVM_EFUSE_CACHE_PPK0_HASH_2_OFFSET			(0x00000140U)
#define XNVM_EFUSE_CACHE_DEC_ONLY_OFFSET			(0x000000E4U)
#define XNVM_EFUSE_CACHE_SEC_MISC1_OFFSET			(0x000000E8U)
#define XNVM_EFUSE_CACHE_DNA_OFFSET				(0x00000020U)
#define XNVM_EFUSE_CACHE_PUF_ECC_CTRL_OFFSET			(0x000000A4U)
#define XNVM_EFUSE_CACHE_PUF_CHASH_OFFSET			(0x000000A8U)
#define XNVM_EFUSE_CACHE_PUF_SYN_DATA_OFFSET			(0x00000300U)
#define XNVM_EFUSE_CACHE_PUF_RO_SWAP_OFFSET			(0x000000D0U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_OFFSET			(0x00000094U)
#define XNVM_EFUSE_CACHE_DME_FIPS_OFFSET			(0x00000234U)
#define XNVM_EFUSE_CACHE_BOOT_MODE_DIS_OFFSET			(0x00000238U)
#define XNVM_EFUSE_CACHE_USER_FUSE_START_OFFSET			(0x00000240U)
#define XNVM_EFUSE_CACHE_ROM_RSVD_OFFSET			(0x00000090U)
#define XNVM_EFUSE_CACHE_IP_DISABLE_0_OFFSET			(0x00000018U)

/**
 * @name Register: EFUSE_CACHE_SECURITY_CONTROL_REG
 */
/**< eFUSE Cache Security Control Register Masks And Shifts */
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_REG_INIT_DIS_1_0_MASK		(0xc0000000U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_BOOT_ENV_WR_LK_MASK		(0x10000000U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PMC_SC_EN_2_0_MASK		(0x03800000U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_AUTH_JTAG_LOCK_DIS_MASK	(0x00600000U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_AUTH_JTAG_DIS_MASK		(0x00180000U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PUF_DIS_MASK			(0x00040000U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PUF_TEST2_DIS_MASK		(0x00020000U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PUF_SYN_LK_MASK		(0x00010000U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_USR_KEY_1_WR_LK_MASK		(0x00008000U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_USR_KEY_1_CRC_LK_MASK		(0x00004000U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_USR_KEY_0_WR_LK_MASK		(0x00002000U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_USR_KEY_0_CRC_LK_MASK		(0x00001000U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_AES_WR_LK_MASK		(0x00000800U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_AES_CRC_LK_1_0_MASK		(0x00000600U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PPK2_WR_LK_MASK		(0x00000100U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PPK1_WR_LK_MASK		(0x00000080U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PPK0_WR_LK_MASK		(0x00000040U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_UDS_WR_LK_MASK		(0x00000010U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_HWTSTBITS_DIS_MASK		(0x00000008U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_JTAG_DIS_MASK			(0x00000004U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_JTAG_ERROUT_DIS_MASK		(0x00000002U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_AES_DIS_MASK			(0x00000001U)

#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_REG_INIT_DIS_1_0_SHIFT	(30U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_BOOT_ENV_WR_LK_SHIFT		(28U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PMC_SC_EN_2_0_SHIFT		(23U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_AUTH_JTAG_LOCK_DIS_1_0_SHIFT	(21U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_AUTH_JTAG_DIS_1_0_SHIFT	(19U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PUF_DIS_SHIFT			(18U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PUF_TEST2_DIS_SHIFT		(17U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PUF_SYN_LK_SHIFT		(16U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_USR_KEY_1_WR_LK_SHIFT		(15U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_USR_KEY_1_CRC_LK_0_SHIFT	(14U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_USR_KEY_0_WR_LK_SHIFT		(13U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_USR_KEY_0_CRC_LK_0_SHIFT	(12U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_AES_WR_LK_SHIFT		(11U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_AES_CRC_LK_1_0_SHIFT		(9U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PPK2_WR_LK_SHIFT		(8U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PPK1_WR_LK_SHIFT		(7U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_PPK0_WR_LK_SHIFT		(6U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_UDS_WR_LK_SHIFT		(4U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_HWTSTBITS_DIS_SHIFT		(3U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_JTAG_DIS_SHIFT		(2U)
#define XNVM_EFUSE_CACHE_SECURITY_CONTROL_JTAG_ERROR_OUT_DIS_SHIFT	(1U)
/** @} */

/**
 * @name Register: EFUSE_CACHE_PUF_ECC_CTRL
 */
/**< eFUSE CACHE PUF ECC CTRL Register Masks And Shifts */
#define XNVM_EFUSE_CACHE_PUF_ECC_PUF_CTRL_REGEN_DIS_MASK	(0x80000000U)
#define XNVM_EFUSE_CACHE_PUF_ECC_PUF_CTRL_HD_INVLD_MASK		(0x40000000U)
#define XNVM_EFUSE_CACHE_PUF_ECC_PUF_CTRL_ECC_23_0_MASK		(0x00ffffffU)
#define XNVM_EFUSE_CACHE_PUF_ECC_PUF_CTRL_REGIS_DIS_MASK	(0x20000000U)

#define XNVM_EFUSE_CACHE_PUF_ECC_PUF_CTRL_PUF_REGEN_DIS_SHIFT		(31U)
#define XNVM_EFUSE_CACHE_PUF_ECC_PUF_CTRL_PUF_HD_INVLD_SHIFT		(30U)
#define XNVM_EFUSE_CACHE_PUF_ECC_PUF_CTRL_PUF_REGIS_DIS_SHIFT		(29)
/** @} */

/**
 * @name  Register: EFUSE_CACHE_SECURITY_MISC_0
 */
/**< eFUSE Cache DEC_EFUSE_ONLY Mask */
#define XNVM_EFUSE_CACHE_DEC_EFUSE_ONLY_MASK			(0x0000ffffU)
/** @} */

/**
 * @name  Register: EFUSE_CACHE_MISC_CTRL
 */
/**< eFUSE Cache MISC CTRL Register Masks And Shifts */
#define XNVM_EFUSE_CACHE_MISC_CTRL_GD_HALT_BOOT_EN_1_0_MASK	(0xc0000000U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_GD_ROM_MONITOR_EN_MASK	(0x20000000U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_HALT_BOOT_ERROR_1_0_MASK	(0x00600000U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_HALT_BOOT_ENV_1_0_MASK	(0x00180000U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_CRYPTO_KAT_EN_MASK		(0x00008000U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_LBIST_EN_MASK		(0x00004000U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_SAFETY_MISSION_EN_MASK	(0x00000100U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_PPK2_INVLD_1_0_MASK		(0x000000c0U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_PPK1_INVLD_1_0_MASK		(0x00000030U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_PPK0_INVLD_1_0_MASK		(0x0000000cU)

#define XNVM_EFUSE_CACHE_MISC_CTRL_GD_HALT_BOOT_EN_1_0_SHIFT	   	(30U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_GD_ROM_MONITOR_EN_SHIFT   		(29U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_HALT_BOOT_ERROR_1_0_SHIFT   		(21U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_HALT_BOOT_ENV_1_0_SHIFT   		(19U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_CRYPTO_KAT_EN_SHIFT   		(15U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_LBIST_EN_SHIFT   			(14U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_SAFETY_MISSION_EN_SHIFT   		(8U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_PPK2_INVLD_1_0_SHIFT			(6U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_PPK1_INVLD_1_0_SHIFT			(4U)
#define XNVM_EFUSE_CACHE_MISC_CTRL_PPK0_INVLD_1_0_SHIFT			(2U)
/** @} */

/**
 * @name  Register: EFUSE_CACHE_SECURITY_MISC_1
 */
/**< eFUSE Cache SECURITY_MISC_1 Masks And Shifts */
#define XNVM_EFUSE_CACHE_SEC_MISC_1_LPD_MBIST_EN_2_0_MASK    	(0x00001c00U)
#define XNVM_EFUSE_CACHE_SEC_MISC_1_PMC_MBIST_EN_2_0_MASK    	(0x00000380U)
#define XNVM_EFUSE_CACHE_SEC_MISC_1_LPD_NOC_SC_EN_2_0_MASK   	(0x00000070U)
#define XNVM_EFUSE_CACHE_SEC_MISC_1_SYSMON_VOLT_MON_EN_1_0_MASK	(0x0000000cU)
#define XNVM_EFUSE_CACHE_SEC_MISC_1_SYSMON_TEMP_MON_EN_1_0_MASK	(0x00000003U)

#define XNVM_EFUSE_CACHE_SEC_MISC_1_LPD_MBIST_EN_2_0_SHIFT   		(10U)
#define XNVM_EFUSE_CACHE_SEC_MISC_1_PMC_MBIST_EN_2_0_SHIFT   		(7U)
#define XNVM_EFUSE_CACHE_SEC_MISC_1_LPD_NOC_SC_EN_2_0_SHIFT  		(4U)
#define XNVM_EFUSE_CACHE_SEC_MISC_1_SYSMON_VOLT_MON_EN_1_0_SHIFT   	(2U)
#define XNVM_EFUSE_CACHE_SEC_MISC_1_SYSMON_TEMP_MON_EN_1_0_SHIFT   	(0U)
/** @} */

/**
 * @name  Register: EFUSE_CACHE_BOOT_ENV_CTRL
 */
/**< eFUSE Cache BOOT_ENV_CTRL Masks And Shifts */
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_TEMP_EN_MASK	(0x00200000U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_VOLT_EN_MASK	(0x00100000U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_TEMP_HOT_MASK	(0x00060000U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_VOLT_PMC_MASK	(0x00003000U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_VOLT_PSLP_MASK	(0x00000c00U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_VOLT_SOC_MASK	(0x00000300U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_TEMP_COLD_MASK	(0x00000003U)

#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_TEMP_EN_SHIFT		(21U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_VOLT_EN_SHIFT		(20U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_TEMP_HOT_SHIFT		(17U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_VOLT_PMC_SHIFT		(12U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_VOLT_PSLP_SHIFT		(10U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_VOLT_SOC_SHIFT		(9U)
#define XNVM_EFUSE_CACHE_BOOT_ENV_CTRL_SYSMON_TEMP_COLD_SHIFT		(0U)

/**
 * @name  Register: EFUSE_CACHE_ROM_RSVD
 */
/**< eFUSE Cache ROM_RSVD Masks And Shifts */
#define XNVM_EFUSE_CACHE_ROM_RSVD_PLM_UPDATE_MASK		(0x00000400U)
#define XNVM_EFUSE_CACHE_ROM_RSVD_AUTH_KEYS_TO_HASH_MASK	(0x00000200U)
#define XNVM_EFUSE_CACHE_ROM_RSVD_IRO_SWAP_MASK			(0x00000100U)
#define XNVM_EFUSE_CACHE_ROM_RSVD_ROM_SWDT_USAGE_MASK		(0x000000C0U)

#define XNVM_EFUSE_CACHE_ROM_RSVD_PLM_UPDATE_SHIFT		(10U)
#define XNVM_EFUSE_CACHE_ROM_RSVD_AUTH_KEYS_TO_HASH_SHIFT	(9U)
#define XNVM_EFUSE_CACHE_ROM_RSVD_IRO_SWAP_SHIFT		(8U)
#define XNVM_EFUSE_CACHE_ROM_RSVD_ROM_SWDT_USAGE_SHIFT		(6U)

/** @} */

/**
 * @name  Register: EFUSE_CACHE_DME_FIPS
 */
/**< eFUSE Cache DME_FIPS Masks And Shifts */
#define XNVM_EFUSE_CACHE_DME_FIPS_FIPS_MODE_MASK		(0xFF000000U)

#define XNVM_EFUSE_CACHE_DME_FIPS_FIPS_MODE_SHIFT		(24U)
/** @} */

/**
 * @name  Register: EFUSE_CACHE_IP_DISABLE_0
 */
/**< eFUSE Cache IP_DISABLE_0 Masks And Shifts */
#define XNVM_EFUSE_CACHE_IP_DISABLE_0_FIPS_VERSION_2_1_MASK	(0xC0000000U)
#define XNVM_EFUSE_CACHE_IP_DISABLE_0_FIPS_VERSION_0_MASK	(0x00000004U)

#define XNVM_EFUSE_CACHE_IP_DISABLE_0_FIPS_VERSION_2_1_SHIFT	(30U)
#define XNVM_EFUSE_CACHE_IP_DISABLE_0_FIPS_VERSION_0_SHIFT	(2U)
/** @} */


/**
 * @name Register: EFUSE_CACHE_ANLG_TRIM_3
 */
/**< ANLG_TRIM_3 Masks and Shifts */
#define XNVM_EFUSE_GLITCH_CONFIG_DATA_MASK			(0x7FFFFFFFU)
#define XNVM_EFUSE_CACHE_ANLG_TRIM_3_GLITCH_DET_WR_LK_MASK	(0x80000000U)
/** @} */

#ifdef __cplusplus
}
#endif

#endif	/* XNVM_EFUSECLIENT_HW_H */
