/******************************************************************************
* Copyright (c) 2015 - 2020 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


#ifndef PMU_IOMODULE_H_
#define PMU_IOMODULE_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * PMU_IOMODULE Base Address
 */
#define PMU_IOMODULE_BASEADDR      ((u32)0XFFD40000U)

/**
 * Register: PMU_IOMODULE_IRQ_MODE
 */
#define PMU_IOMODULE_IRQ_MODE    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X0000000CU) )

/**
 * Register: PMU_IOMODULE_GPO0
 */
#define PMU_IOMODULE_GPO0    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000010U) )

#define PMU_IOMODULE_GPO0_MAGIC_WORD_1_SHIFT   24
#define PMU_IOMODULE_GPO0_MAGIC_WORD_1_WIDTH   8
#define PMU_IOMODULE_GPO0_MAGIC_WORD_1_MASK    ((u32)0XFF000000U)

#define PMU_IOMODULE_GPO0_MAGIC_WORD_2_SHIFT   16
#define PMU_IOMODULE_GPO0_MAGIC_WORD_2_WIDTH   8
#define PMU_IOMODULE_GPO0_MAGIC_WORD_2_MASK    ((u32)0X00FF0000U)

#define PMU_IOMODULE_GPO0_FT_INJECT_FAILURE_SHIFT   13
#define PMU_IOMODULE_GPO0_FT_INJECT_FAILURE_WIDTH   3
#define PMU_IOMODULE_GPO0_FT_INJECT_FAILURE_MASK    ((u32)0X0000E000U)

#define PMU_IOMODULE_GPO0_DISABLE_RST_FTSM_SHIFT   12
#define PMU_IOMODULE_GPO0_DISABLE_RST_FTSM_WIDTH   1
#define PMU_IOMODULE_GPO0_DISABLE_RST_FTSM_MASK    ((u32)0X00001000U)

#define PMU_IOMODULE_GPO0_RST_FTSM_SHIFT   11
#define PMU_IOMODULE_GPO0_RST_FTSM_WIDTH   1
#define PMU_IOMODULE_GPO0_RST_FTSM_MASK    ((u32)0X00000800U)

#define PMU_IOMODULE_GPO0_CLR_FTSTS_SHIFT   10
#define PMU_IOMODULE_GPO0_CLR_FTSTS_WIDTH   1
#define PMU_IOMODULE_GPO0_CLR_FTSTS_MASK    ((u32)0X00000400U)

#define PMU_IOMODULE_GPO0_RST_ON_SLEEP_SHIFT   9
#define PMU_IOMODULE_GPO0_RST_ON_SLEEP_WIDTH   1
#define PMU_IOMODULE_GPO0_RST_ON_SLEEP_MASK    ((u32)0X00000200U)

#define PMU_IOMODULE_GPO0_DISABLE_TRACE_COMP_SHIFT   8
#define PMU_IOMODULE_GPO0_DISABLE_TRACE_COMP_WIDTH   1
#define PMU_IOMODULE_GPO0_DISABLE_TRACE_COMP_MASK    ((u32)0X00000100U)

#define PMU_IOMODULE_GPO0_PIT3_PRESCALE_SHIFT   7
#define PMU_IOMODULE_GPO0_PIT3_PRESCALE_WIDTH   1
#define PMU_IOMODULE_GPO0_PIT3_PRESCALE_MASK    ((u32)0X00000080U)

#define PMU_IOMODULE_GPO0_PIT2_PRESCALE_SHIFT   5
#define PMU_IOMODULE_GPO0_PIT2_PRESCALE_WIDTH   2
#define PMU_IOMODULE_GPO0_PIT2_PRESCALE_MASK    ((u32)0X00000060U)

#define PMU_IOMODULE_GPO0_PIT1_PRESCALE_SHIFT   3
#define PMU_IOMODULE_GPO0_PIT1_PRESCALE_WIDTH   2
#define PMU_IOMODULE_GPO0_PIT1_PRESCALE_MASK    ((u32)0X00000018U)

#define PMU_IOMODULE_GPO0_PIT0_PRESCALE_SHIFT   1
#define PMU_IOMODULE_GPO0_PIT0_PRESCALE_WIDTH   2
#define PMU_IOMODULE_GPO0_PIT0_PRESCALE_MASK    ((u32)0X00000006U)

#define PMU_IOMODULE_GPO0_DEBUG_REMAP_SHIFT   0
#define PMU_IOMODULE_GPO0_DEBUG_REMAP_WIDTH   1
#define PMU_IOMODULE_GPO0_DEBUG_REMAP_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_IOMODULE_GPO1
 */
#define PMU_IOMODULE_GPO1    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000014U) )

#define PMU_IOMODULE_GPO1_MIO_5_SHIFT   5
#define PMU_IOMODULE_GPO1_MIO_5_WIDTH   1
#define PMU_IOMODULE_GPO1_MIO_5_MASK    ((u32)0X00000020U)

#define PMU_IOMODULE_GPO1_MIO_4_SHIFT   4
#define PMU_IOMODULE_GPO1_MIO_4_WIDTH   1
#define PMU_IOMODULE_GPO1_MIO_4_MASK    ((u32)0X00000010U)

#define PMU_IOMODULE_GPO1_MIO_3_SHIFT   3
#define PMU_IOMODULE_GPO1_MIO_3_WIDTH   1
#define PMU_IOMODULE_GPO1_MIO_3_MASK    ((u32)0X00000008U)

#define PMU_IOMODULE_GPO1_MIO_2_SHIFT   2
#define PMU_IOMODULE_GPO1_MIO_2_WIDTH   1
#define PMU_IOMODULE_GPO1_MIO_2_MASK    ((u32)0X00000004U)

#define PMU_IOMODULE_GPO1_MIO_1_SHIFT   1
#define PMU_IOMODULE_GPO1_MIO_1_WIDTH   1
#define PMU_IOMODULE_GPO1_MIO_1_MASK    ((u32)0X00000002U)

#define PMU_IOMODULE_GPO1_MIO_0_SHIFT   0
#define PMU_IOMODULE_GPO1_MIO_0_WIDTH   1
#define PMU_IOMODULE_GPO1_MIO_0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_IOMODULE_GPO2
 */
#define PMU_IOMODULE_GPO2    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000018U) )

#define PMU_IOMODULE_GPO2_DAP_RPU_WAKE_ACK_SHIFT   9
#define PMU_IOMODULE_GPO2_DAP_RPU_WAKE_ACK_WIDTH   1
#define PMU_IOMODULE_GPO2_DAP_RPU_WAKE_ACK_MASK    ((u32)0X00000200U)

#define PMU_IOMODULE_GPO2_DAP_FP_WAKE_ACK_SHIFT   8
#define PMU_IOMODULE_GPO2_DAP_FP_WAKE_ACK_WIDTH   1
#define PMU_IOMODULE_GPO2_DAP_FP_WAKE_ACK_MASK    ((u32)0X00000100U)

#define PMU_IOMODULE_GPO2_PS_STATUS_SHIFT   7
#define PMU_IOMODULE_GPO2_PS_STATUS_WIDTH   1
#define PMU_IOMODULE_GPO2_PS_STATUS_MASK    ((u32)0X00000080U)

/**
 * Register: PMU_IOMODULE_GPO3
 */
#define PMU_IOMODULE_GPO3    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X0000001CU) )

#define PMU_IOMODULE_GPO3_PL_GPO_31_SHIFT   31
#define PMU_IOMODULE_GPO3_PL_GPO_31_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_31_MASK    ((u32)0X80000000U)

#define PMU_IOMODULE_GPO3_PL_GPO_30_SHIFT   30
#define PMU_IOMODULE_GPO3_PL_GPO_30_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_30_MASK    ((u32)0X40000000U)

#define PMU_IOMODULE_GPO3_PL_GPO_29_SHIFT   29
#define PMU_IOMODULE_GPO3_PL_GPO_29_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_29_MASK    ((u32)0X20000000U)

#define PMU_IOMODULE_GPO3_PL_GPO_28_SHIFT   28
#define PMU_IOMODULE_GPO3_PL_GPO_28_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_28_MASK    ((u32)0X10000000U)

#define PMU_IOMODULE_GPO3_PL_GPO_27_SHIFT   27
#define PMU_IOMODULE_GPO3_PL_GPO_27_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_27_MASK    ((u32)0X08000000U)

#define PMU_IOMODULE_GPO3_PL_GPO_26_SHIFT   26
#define PMU_IOMODULE_GPO3_PL_GPO_26_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_26_MASK    ((u32)0X04000000U)

#define PMU_IOMODULE_GPO3_PL_GPO_25_SHIFT   25
#define PMU_IOMODULE_GPO3_PL_GPO_25_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_25_MASK    ((u32)0X02000000U)

#define PMU_IOMODULE_GPO3_PL_GPO_24_SHIFT   24
#define PMU_IOMODULE_GPO3_PL_GPO_24_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_24_MASK    ((u32)0X01000000U)

#define PMU_IOMODULE_GPO3_PL_GPO_23_SHIFT   23
#define PMU_IOMODULE_GPO3_PL_GPO_23_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_23_MASK    ((u32)0X00800000U)

#define PMU_IOMODULE_GPO3_PL_GPO_22_SHIFT   22
#define PMU_IOMODULE_GPO3_PL_GPO_22_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_22_MASK    ((u32)0X00400000U)

#define PMU_IOMODULE_GPO3_PL_GPO_21_SHIFT   21
#define PMU_IOMODULE_GPO3_PL_GPO_21_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_21_MASK    ((u32)0X00200000U)

#define PMU_IOMODULE_GPO3_PL_GPO_20_SHIFT   20
#define PMU_IOMODULE_GPO3_PL_GPO_20_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_20_MASK    ((u32)0X00100000U)

#define PMU_IOMODULE_GPO3_PL_GPO_19_SHIFT   19
#define PMU_IOMODULE_GPO3_PL_GPO_19_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_19_MASK    ((u32)0X00080000U)

#define PMU_IOMODULE_GPO3_PL_GPO_18_SHIFT   18
#define PMU_IOMODULE_GPO3_PL_GPO_18_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_18_MASK    ((u32)0X00040000U)

#define PMU_IOMODULE_GPO3_PL_GPO_17_SHIFT   17
#define PMU_IOMODULE_GPO3_PL_GPO_17_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_17_MASK    ((u32)0X00020000U)

#define PMU_IOMODULE_GPO3_PL_GPO_16_SHIFT   16
#define PMU_IOMODULE_GPO3_PL_GPO_16_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_16_MASK    ((u32)0X00010000U)

#define PMU_IOMODULE_GPO3_PL_GPO_15_SHIFT   15
#define PMU_IOMODULE_GPO3_PL_GPO_15_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_15_MASK    ((u32)0X00008000U)

#define PMU_IOMODULE_GPO3_PL_GPO_14_SHIFT   14
#define PMU_IOMODULE_GPO3_PL_GPO_14_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_14_MASK    ((u32)0X00004000U)

#define PMU_IOMODULE_GPO3_PL_GPO_13_SHIFT   13
#define PMU_IOMODULE_GPO3_PL_GPO_13_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_13_MASK    ((u32)0X00002000U)

#define PMU_IOMODULE_GPO3_PL_GPO_12_SHIFT   12
#define PMU_IOMODULE_GPO3_PL_GPO_12_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_12_MASK    ((u32)0X00001000U)

#define PMU_IOMODULE_GPO3_PL_GPO_11_SHIFT   11
#define PMU_IOMODULE_GPO3_PL_GPO_11_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_11_MASK    ((u32)0X00000800U)

#define PMU_IOMODULE_GPO3_PL_GPO_10_SHIFT   10
#define PMU_IOMODULE_GPO3_PL_GPO_10_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_10_MASK    ((u32)0X00000400U)

#define PMU_IOMODULE_GPO3_PL_GPO_9_SHIFT   9
#define PMU_IOMODULE_GPO3_PL_GPO_9_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_9_MASK    ((u32)0X00000200U)

#define PMU_IOMODULE_GPO3_PL_GPO_8_SHIFT   8
#define PMU_IOMODULE_GPO3_PL_GPO_8_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_8_MASK    ((u32)0X00000100U)

#define PMU_IOMODULE_GPO3_PL_GPO_7_SHIFT   7
#define PMU_IOMODULE_GPO3_PL_GPO_7_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_7_MASK    ((u32)0X00000080U)

#define PMU_IOMODULE_GPO3_PL_GPO_6_SHIFT   6
#define PMU_IOMODULE_GPO3_PL_GPO_6_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_6_MASK    ((u32)0X00000040U)

#define PMU_IOMODULE_GPO3_PL_GPO_5_SHIFT   5
#define PMU_IOMODULE_GPO3_PL_GPO_5_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_5_MASK    ((u32)0X00000020U)

#define PMU_IOMODULE_GPO3_PL_GPO_4_SHIFT   4
#define PMU_IOMODULE_GPO3_PL_GPO_4_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_4_MASK    ((u32)0X00000010U)

#define PMU_IOMODULE_GPO3_PL_GPO_3_SHIFT   3
#define PMU_IOMODULE_GPO3_PL_GPO_3_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_3_MASK    ((u32)0X00000008U)

#define PMU_IOMODULE_GPO3_PL_GPO_2_SHIFT   2
#define PMU_IOMODULE_GPO3_PL_GPO_2_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_2_MASK    ((u32)0X00000004U)

#define PMU_IOMODULE_GPO3_PL_GPO_1_SHIFT   1
#define PMU_IOMODULE_GPO3_PL_GPO_1_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_1_MASK    ((u32)0X00000002U)

#define PMU_IOMODULE_GPO3_PL_GPO_0_SHIFT   0
#define PMU_IOMODULE_GPO3_PL_GPO_0_WIDTH   1
#define PMU_IOMODULE_GPO3_PL_GPO_0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_IOMODULE_GPI0
 */
#define PMU_IOMODULE_GPI0    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000020U) )

#define PMU_IOMODULE_GPI0_RFT_ECC_FATAL_ERR_SHIFT   31
#define PMU_IOMODULE_GPI0_RFT_ECC_FATAL_ERR_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_ECC_FATAL_ERR_MASK    ((u32)0X80000000U)

#define PMU_IOMODULE_GPI0_RFT_VOTER_ERR_SHIFT   30
#define PMU_IOMODULE_GPI0_RFT_VOTER_ERR_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_VOTER_ERR_MASK    ((u32)0X40000000U)

#define PMU_IOMODULE_GPI0_RFT_COMPARE_ERR_23_SHIFT   29
#define PMU_IOMODULE_GPI0_RFT_COMPARE_ERR_23_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_COMPARE_ERR_23_MASK    ((u32)0X20000000U)

#define PMU_IOMODULE_GPI0_RFT_COMPARE_ERR_13_SHIFT   28
#define PMU_IOMODULE_GPI0_RFT_COMPARE_ERR_13_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_COMPARE_ERR_13_MASK    ((u32)0X10000000U)

#define PMU_IOMODULE_GPI0_RFT_COMPARE_ERR_12_SHIFT   27
#define PMU_IOMODULE_GPI0_RFT_COMPARE_ERR_12_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_COMPARE_ERR_12_MASK    ((u32)0X08000000U)

#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_23_B_SHIFT   26
#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_23_B_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_23_B_MASK    ((u32)0X04000000U)

#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_13_B_SHIFT   25
#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_13_B_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_13_B_MASK    ((u32)0X02000000U)

#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_12_B_SHIFT   24
#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_12_B_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_12_B_MASK    ((u32)0X01000000U)

#define PMU_IOMODULE_GPI0_RFT_MISMATCH_STATE_SHIFT   23
#define PMU_IOMODULE_GPI0_RFT_MISMATCH_STATE_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_MISMATCH_STATE_MASK    ((u32)0X00800000U)

#define PMU_IOMODULE_GPI0_RFT_MISMATCH_CPU_SHIFT   22
#define PMU_IOMODULE_GPI0_RFT_MISMATCH_CPU_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_MISMATCH_CPU_MASK    ((u32)0X00400000U)

#define PMU_IOMODULE_GPI0_RFT_SLEEP_RESET_SHIFT   19
#define PMU_IOMODULE_GPI0_RFT_SLEEP_RESET_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_SLEEP_RESET_MASK    ((u32)0X00080000U)

#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_23_A_SHIFT   18
#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_23_A_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_23_A_MASK    ((u32)0X00040000U)

#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_13_A_SHIFT   17
#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_13_A_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_13_A_MASK    ((u32)0X00020000U)

#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_12_A_SHIFT   16
#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_12_A_WIDTH   1
#define PMU_IOMODULE_GPI0_RFT_LS_MISMATCH_12_A_MASK    ((u32)0X00010000U)

#define PMU_IOMODULE_GPI0_NFT_ECC_FATAL_ERR_SHIFT   15
#define PMU_IOMODULE_GPI0_NFT_ECC_FATAL_ERR_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_ECC_FATAL_ERR_MASK    ((u32)0X00008000U)

#define PMU_IOMODULE_GPI0_NFT_VOTER_ERR_SHIFT   14
#define PMU_IOMODULE_GPI0_NFT_VOTER_ERR_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_VOTER_ERR_MASK    ((u32)0X00004000U)

#define PMU_IOMODULE_GPI0_NFT_COMPARE_ERR_23_SHIFT   13
#define PMU_IOMODULE_GPI0_NFT_COMPARE_ERR_23_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_COMPARE_ERR_23_MASK    ((u32)0X00002000U)

#define PMU_IOMODULE_GPI0_NFT_COMPARE_ERR_13_SHIFT   12
#define PMU_IOMODULE_GPI0_NFT_COMPARE_ERR_13_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_COMPARE_ERR_13_MASK    ((u32)0X00001000U)

#define PMU_IOMODULE_GPI0_NFT_COMPARE_ERR_12_SHIFT   11
#define PMU_IOMODULE_GPI0_NFT_COMPARE_ERR_12_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_COMPARE_ERR_12_MASK    ((u32)0X00000800U)

#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_23_B_SHIFT   10
#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_23_B_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_23_B_MASK    ((u32)0X00000400U)

#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_13_B_SHIFT   9
#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_13_B_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_13_B_MASK    ((u32)0X00000200U)

#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_12_B_SHIFT   8
#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_12_B_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_12_B_MASK    ((u32)0X00000100U)

#define PMU_IOMODULE_GPI0_NFT_MISMATCH_STATE_SHIFT   7
#define PMU_IOMODULE_GPI0_NFT_MISMATCH_STATE_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_MISMATCH_STATE_MASK    ((u32)0X00000080U)

#define PMU_IOMODULE_GPI0_NFT_MISMATCH_CPU_SHIFT   6
#define PMU_IOMODULE_GPI0_NFT_MISMATCH_CPU_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_MISMATCH_CPU_MASK    ((u32)0X00000040U)

#define PMU_IOMODULE_GPI0_NFT_SLEEP_RESET_SHIFT   3
#define PMU_IOMODULE_GPI0_NFT_SLEEP_RESET_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_SLEEP_RESET_MASK    ((u32)0X00000008U)

#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_23_A_SHIFT   2
#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_23_A_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_23_A_MASK    ((u32)0X00000004U)

#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_13_A_SHIFT   1
#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_13_A_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_13_A_MASK    ((u32)0X00000002U)

#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_12_A_SHIFT   0
#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_12_A_WIDTH   1
#define PMU_IOMODULE_GPI0_NFT_LS_MISMATCH_12_A_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_IOMODULE_GPI1
 */
#define PMU_IOMODULE_GPI1    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000024U) )

#define PMU_IOMODULE_GPI1_APB_AIB_ERROR_SHIFT   31
#define PMU_IOMODULE_GPI1_APB_AIB_ERROR_WIDTH   1
#define PMU_IOMODULE_GPI1_APB_AIB_ERROR_MASK    ((u32)0X80000000U)

#define PMU_IOMODULE_GPI1_AXI_AIB_ERROR_SHIFT   30
#define PMU_IOMODULE_GPI1_AXI_AIB_ERROR_WIDTH   1
#define PMU_IOMODULE_GPI1_AXI_AIB_ERROR_MASK    ((u32)0X40000000U)

#define PMU_IOMODULE_GPI1_ERROR_2_SHIFT   29
#define PMU_IOMODULE_GPI1_ERROR_2_WIDTH   1
#define PMU_IOMODULE_GPI1_ERROR_2_MASK    ((u32)0X20000000U)

#define PMU_IOMODULE_GPI1_ERROR_1_SHIFT   28
#define PMU_IOMODULE_GPI1_ERROR_1_WIDTH   1
#define PMU_IOMODULE_GPI1_ERROR_1_MASK    ((u32)0X10000000U)

#define PMU_IOMODULE_GPI1_ACPU_3_DBG_PWRUP_SHIFT   23
#define PMU_IOMODULE_GPI1_ACPU_3_DBG_PWRUP_WIDTH   1
#define PMU_IOMODULE_GPI1_ACPU_3_DBG_PWRUP_MASK    ((u32)0X00800000U)

#define PMU_IOMODULE_GPI1_ACPU_2_DBG_PWRUP_SHIFT   22
#define PMU_IOMODULE_GPI1_ACPU_2_DBG_PWRUP_WIDTH   1
#define PMU_IOMODULE_GPI1_ACPU_2_DBG_PWRUP_MASK    ((u32)0X00400000U)

#define PMU_IOMODULE_GPI1_ACPU_1_DBG_PWRUP_SHIFT   21
#define PMU_IOMODULE_GPI1_ACPU_1_DBG_PWRUP_WIDTH   1
#define PMU_IOMODULE_GPI1_ACPU_1_DBG_PWRUP_MASK    ((u32)0X00200000U)

#define PMU_IOMODULE_GPI1_ACPU_0_DBG_PWRUP_SHIFT   20
#define PMU_IOMODULE_GPI1_ACPU_0_DBG_PWRUP_WIDTH   1
#define PMU_IOMODULE_GPI1_ACPU_0_DBG_PWRUP_MASK    ((u32)0X00100000U)

#define PMU_IOMODULE_GPI1_FPD_WAKE_GIC_PROXY_SHIFT   16
#define PMU_IOMODULE_GPI1_FPD_WAKE_GIC_PROXY_WIDTH   1
#define PMU_IOMODULE_GPI1_FPD_WAKE_GIC_PROXY_MASK    ((u32)0X00010000U)

#define PMU_IOMODULE_GPI1_MIO_WAKE_5_SHIFT   15
#define PMU_IOMODULE_GPI1_MIO_WAKE_5_WIDTH   1
#define PMU_IOMODULE_GPI1_MIO_WAKE_5_MASK    ((u32)0X00008000U)

#define PMU_IOMODULE_GPI1_MIO_WAKE_4_SHIFT   14
#define PMU_IOMODULE_GPI1_MIO_WAKE_4_WIDTH   1
#define PMU_IOMODULE_GPI1_MIO_WAKE_4_MASK    ((u32)0X00004000U)

#define PMU_IOMODULE_GPI1_MIO_WAKE_3_SHIFT   13
#define PMU_IOMODULE_GPI1_MIO_WAKE_3_WIDTH   1
#define PMU_IOMODULE_GPI1_MIO_WAKE_3_MASK    ((u32)0X00002000U)

#define PMU_IOMODULE_GPI1_MIO_WAKE_2_SHIFT   12
#define PMU_IOMODULE_GPI1_MIO_WAKE_2_WIDTH   1
#define PMU_IOMODULE_GPI1_MIO_WAKE_2_MASK    ((u32)0X00001000U)

#define PMU_IOMODULE_GPI1_MIO_WAKE_1_SHIFT   11
#define PMU_IOMODULE_GPI1_MIO_WAKE_1_WIDTH   1
#define PMU_IOMODULE_GPI1_MIO_WAKE_1_MASK    ((u32)0X00000800U)

#define PMU_IOMODULE_GPI1_MIO_WAKE_0_SHIFT   10
#define PMU_IOMODULE_GPI1_MIO_WAKE_0_WIDTH   1
#define PMU_IOMODULE_GPI1_MIO_WAKE_0_MASK    ((u32)0X00000400U)

#define PMU_IOMODULE_GPI1_DAP_RPU_WAKE_SHIFT   9
#define PMU_IOMODULE_GPI1_DAP_RPU_WAKE_WIDTH   1
#define PMU_IOMODULE_GPI1_DAP_RPU_WAKE_MASK    ((u32)0X00000200U)

#define PMU_IOMODULE_GPI1_DAP_FPD_WAKE_SHIFT   8
#define PMU_IOMODULE_GPI1_DAP_FPD_WAKE_WIDTH   1
#define PMU_IOMODULE_GPI1_DAP_FPD_WAKE_MASK    ((u32)0X00000100U)

#define PMU_IOMODULE_GPI1_USB_1_WAKE_SHIFT   7
#define PMU_IOMODULE_GPI1_USB_1_WAKE_WIDTH   1
#define PMU_IOMODULE_GPI1_USB_1_WAKE_MASK    ((u32)0X00000080U)

#define PMU_IOMODULE_GPI1_USB_0_WAKE_SHIFT   6
#define PMU_IOMODULE_GPI1_USB_0_WAKE_WIDTH   1
#define PMU_IOMODULE_GPI1_USB_0_WAKE_MASK    ((u32)0X00000040U)

#define PMU_IOMODULE_GPI1_R5_1_WAKE_SHIFT   5
#define PMU_IOMODULE_GPI1_R5_1_WAKE_WIDTH   1
#define PMU_IOMODULE_GPI1_R5_1_WAKE_MASK    ((u32)0X00000020U)

#define PMU_IOMODULE_GPI1_R5_0_WAKE_SHIFT   4
#define PMU_IOMODULE_GPI1_R5_0_WAKE_WIDTH   1
#define PMU_IOMODULE_GPI1_R5_0_WAKE_MASK    ((u32)0X00000010U)

#define PMU_IOMODULE_GPI1_ACPU_3_WAKE_SHIFT   3
#define PMU_IOMODULE_GPI1_ACPU_3_WAKE_WIDTH   1
#define PMU_IOMODULE_GPI1_ACPU_3_WAKE_MASK    ((u32)0X00000008U)

#define PMU_IOMODULE_GPI1_ACPU_2_WAKE_SHIFT   2
#define PMU_IOMODULE_GPI1_ACPU_2_WAKE_WIDTH   1
#define PMU_IOMODULE_GPI1_ACPU_2_WAKE_MASK    ((u32)0X00000004U)

#define PMU_IOMODULE_GPI1_ACPU_1_WAKE_SHIFT   1
#define PMU_IOMODULE_GPI1_ACPU_1_WAKE_WIDTH   1
#define PMU_IOMODULE_GPI1_ACPU_1_WAKE_MASK    ((u32)0X00000002U)

#define PMU_IOMODULE_GPI1_ACPU_0_WAKE_SHIFT   0
#define PMU_IOMODULE_GPI1_ACPU_0_WAKE_WIDTH   1
#define PMU_IOMODULE_GPI1_ACPU_0_WAKE_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_IOMODULE_GPI2
 */
#define PMU_IOMODULE_GPI2    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000028U) )

#define PMU_IOMODULE_GPI2_VCC_INT_FP_DISCONNECT_SHIFT   31
#define PMU_IOMODULE_GPI2_VCC_INT_FP_DISCONNECT_WIDTH   1
#define PMU_IOMODULE_GPI2_VCC_INT_FP_DISCONNECT_MASK    ((u32)0X80000000U)

#define PMU_IOMODULE_GPI2_VCC_INT_DISCONNECT_SHIFT   30
#define PMU_IOMODULE_GPI2_VCC_INT_DISCONNECT_WIDTH   1
#define PMU_IOMODULE_GPI2_VCC_INT_DISCONNECT_MASK    ((u32)0X40000000U)

#define PMU_IOMODULE_GPI2_VCC_AUX_DISCONNECT_SHIFT   29
#define PMU_IOMODULE_GPI2_VCC_AUX_DISCONNECT_WIDTH   1
#define PMU_IOMODULE_GPI2_VCC_AUX_DISCONNECT_MASK    ((u32)0X20000000U)

#define PMU_IOMODULE_GPI2_DBG_ACPU3_RST_REQ_SHIFT   23
#define PMU_IOMODULE_GPI2_DBG_ACPU3_RST_REQ_WIDTH   1
#define PMU_IOMODULE_GPI2_DBG_ACPU3_RST_REQ_MASK    ((u32)0X00800000U)

#define PMU_IOMODULE_GPI2_DBG_ACPU2_RST_REQ_SHIFT   22
#define PMU_IOMODULE_GPI2_DBG_ACPU2_RST_REQ_WIDTH   1
#define PMU_IOMODULE_GPI2_DBG_ACPU2_RST_REQ_MASK    ((u32)0X00400000U)

#define PMU_IOMODULE_GPI2_DBG_ACPU1_RST_REQ_SHIFT   21
#define PMU_IOMODULE_GPI2_DBG_ACPU1_RST_REQ_WIDTH   1
#define PMU_IOMODULE_GPI2_DBG_ACPU1_RST_REQ_MASK    ((u32)0X00200000U)

#define PMU_IOMODULE_GPI2_DBG_ACPU0_RST_REQ_SHIFT   20
#define PMU_IOMODULE_GPI2_DBG_ACPU0_RST_REQ_WIDTH   1
#define PMU_IOMODULE_GPI2_DBG_ACPU0_RST_REQ_MASK    ((u32)0X00100000U)

#define PMU_IOMODULE_GPI2_CP_ACPU3_RST_REQ_SHIFT   19
#define PMU_IOMODULE_GPI2_CP_ACPU3_RST_REQ_WIDTH   1
#define PMU_IOMODULE_GPI2_CP_ACPU3_RST_REQ_MASK    ((u32)0X00080000U)

#define PMU_IOMODULE_GPI2_CP_ACPU2_RST_REQ_SHIFT   18
#define PMU_IOMODULE_GPI2_CP_ACPU2_RST_REQ_WIDTH   1
#define PMU_IOMODULE_GPI2_CP_ACPU2_RST_REQ_MASK    ((u32)0X00040000U)

#define PMU_IOMODULE_GPI2_CP_ACPU1_RST_REQ_SHIFT   17
#define PMU_IOMODULE_GPI2_CP_ACPU1_RST_REQ_WIDTH   1
#define PMU_IOMODULE_GPI2_CP_ACPU1_RST_REQ_MASK    ((u32)0X00020000U)

#define PMU_IOMODULE_GPI2_CP_ACPU0_RST_REQ_SHIFT   16
#define PMU_IOMODULE_GPI2_CP_ACPU0_RST_REQ_WIDTH   1
#define PMU_IOMODULE_GPI2_CP_ACPU0_RST_REQ_MASK    ((u32)0X00010000U)

#define PMU_IOMODULE_GPI2_DBG_RCPU1_RST_REQ_SHIFT   9
#define PMU_IOMODULE_GPI2_DBG_RCPU1_RST_REQ_WIDTH   1
#define PMU_IOMODULE_GPI2_DBG_RCPU1_RST_REQ_MASK    ((u32)0X00000200U)

#define PMU_IOMODULE_GPI2_DBG_RCPU0_RST_REQ_SHIFT   8
#define PMU_IOMODULE_GPI2_DBG_RCPU0_RST_REQ_WIDTH   1
#define PMU_IOMODULE_GPI2_DBG_RCPU0_RST_REQ_MASK    ((u32)0X00000100U)

#define PMU_IOMODULE_GPI2_R5_1_SLEEP_SHIFT   5
#define PMU_IOMODULE_GPI2_R5_1_SLEEP_WIDTH   1
#define PMU_IOMODULE_GPI2_R5_1_SLEEP_MASK    ((u32)0X00000020U)

#define PMU_IOMODULE_GPI2_R5_0_SLEEP_SHIFT   4
#define PMU_IOMODULE_GPI2_R5_0_SLEEP_WIDTH   1
#define PMU_IOMODULE_GPI2_R5_0_SLEEP_MASK    ((u32)0X00000010U)

#define PMU_IOMODULE_GPI2_ACPU_3_SLEEP_SHIFT   3
#define PMU_IOMODULE_GPI2_ACPU_3_SLEEP_WIDTH   1
#define PMU_IOMODULE_GPI2_ACPU_3_SLEEP_MASK    ((u32)0X00000008U)

#define PMU_IOMODULE_GPI2_ACPU_2_SLEEP_SHIFT   2
#define PMU_IOMODULE_GPI2_ACPU_2_SLEEP_WIDTH   1
#define PMU_IOMODULE_GPI2_ACPU_2_SLEEP_MASK    ((u32)0X00000004U)

#define PMU_IOMODULE_GPI2_ACPU_1_SLEEP_SHIFT   1
#define PMU_IOMODULE_GPI2_ACPU_1_SLEEP_WIDTH   1
#define PMU_IOMODULE_GPI2_ACPU_1_SLEEP_MASK    ((u32)0X00000002U)

#define PMU_IOMODULE_GPI2_ACPU_0_SLEEP_SHIFT   0
#define PMU_IOMODULE_GPI2_ACPU_0_SLEEP_WIDTH   1
#define PMU_IOMODULE_GPI2_ACPU_0_SLEEP_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_IOMODULE_GPI3
 */
#define PMU_IOMODULE_GPI3    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X0000002CU) )

#define PMU_IOMODULE_GPI3_PL_GPI_31_SHIFT   31
#define PMU_IOMODULE_GPI3_PL_GPI_31_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_31_MASK    ((u32)0X80000000U)

#define PMU_IOMODULE_GPI3_PL_GPI_30_SHIFT   30
#define PMU_IOMODULE_GPI3_PL_GPI_30_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_30_MASK    ((u32)0X40000000U)

#define PMU_IOMODULE_GPI3_PL_GPI_29_SHIFT   29
#define PMU_IOMODULE_GPI3_PL_GPI_29_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_29_MASK    ((u32)0X20000000U)

#define PMU_IOMODULE_GPI3_PL_GPI_28_SHIFT   28
#define PMU_IOMODULE_GPI3_PL_GPI_28_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_28_MASK    ((u32)0X10000000U)

#define PMU_IOMODULE_GPI3_PL_GPI_27_SHIFT   27
#define PMU_IOMODULE_GPI3_PL_GPI_27_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_27_MASK    ((u32)0X08000000U)

#define PMU_IOMODULE_GPI3_PL_GPI_26_SHIFT   26
#define PMU_IOMODULE_GPI3_PL_GPI_26_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_26_MASK    ((u32)0X04000000U)

#define PMU_IOMODULE_GPI3_PL_GPI_25_SHIFT   25
#define PMU_IOMODULE_GPI3_PL_GPI_25_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_25_MASK    ((u32)0X02000000U)

#define PMU_IOMODULE_GPI3_PL_GPI_24_SHIFT   24
#define PMU_IOMODULE_GPI3_PL_GPI_24_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_24_MASK    ((u32)0X01000000U)

#define PMU_IOMODULE_GPI3_PL_GPI_23_SHIFT   23
#define PMU_IOMODULE_GPI3_PL_GPI_23_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_23_MASK    ((u32)0X00800000U)

#define PMU_IOMODULE_GPI3_PL_GPI_22_SHIFT   22
#define PMU_IOMODULE_GPI3_PL_GPI_22_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_22_MASK    ((u32)0X00400000U)

#define PMU_IOMODULE_GPI3_PL_GPI_21_SHIFT   21
#define PMU_IOMODULE_GPI3_PL_GPI_21_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_21_MASK    ((u32)0X00200000U)

#define PMU_IOMODULE_GPI3_PL_GPI_20_SHIFT   20
#define PMU_IOMODULE_GPI3_PL_GPI_20_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_20_MASK    ((u32)0X00100000U)

#define PMU_IOMODULE_GPI3_PL_GPI_19_SHIFT   19
#define PMU_IOMODULE_GPI3_PL_GPI_19_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_19_MASK    ((u32)0X00080000U)

#define PMU_IOMODULE_GPI3_PL_GPI_18_SHIFT   18
#define PMU_IOMODULE_GPI3_PL_GPI_18_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_18_MASK    ((u32)0X00040000U)

#define PMU_IOMODULE_GPI3_PL_GPI_17_SHIFT   17
#define PMU_IOMODULE_GPI3_PL_GPI_17_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_17_MASK    ((u32)0X00020000U)

#define PMU_IOMODULE_GPI3_PL_GPI_16_SHIFT   16
#define PMU_IOMODULE_GPI3_PL_GPI_16_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_16_MASK    ((u32)0X00010000U)

#define PMU_IOMODULE_GPI3_PL_GPI_15_SHIFT   15
#define PMU_IOMODULE_GPI3_PL_GPI_15_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_15_MASK    ((u32)0X00008000U)

#define PMU_IOMODULE_GPI3_PL_GPI_14_SHIFT   14
#define PMU_IOMODULE_GPI3_PL_GPI_14_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_14_MASK    ((u32)0X00004000U)

#define PMU_IOMODULE_GPI3_PL_GPI_13_SHIFT   13
#define PMU_IOMODULE_GPI3_PL_GPI_13_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_13_MASK    ((u32)0X00002000U)

#define PMU_IOMODULE_GPI3_PL_GPI_12_SHIFT   12
#define PMU_IOMODULE_GPI3_PL_GPI_12_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_12_MASK    ((u32)0X00001000U)

#define PMU_IOMODULE_GPI3_PL_GPI_11_SHIFT   11
#define PMU_IOMODULE_GPI3_PL_GPI_11_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_11_MASK    ((u32)0X00000800U)

#define PMU_IOMODULE_GPI3_PL_GPI_10_SHIFT   10
#define PMU_IOMODULE_GPI3_PL_GPI_10_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_10_MASK    ((u32)0X00000400U)

#define PMU_IOMODULE_GPI3_PL_GPI_9_SHIFT   9
#define PMU_IOMODULE_GPI3_PL_GPI_9_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_9_MASK    ((u32)0X00000200U)

#define PMU_IOMODULE_GPI3_PL_GPI_8_SHIFT   8
#define PMU_IOMODULE_GPI3_PL_GPI_8_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_8_MASK    ((u32)0X00000100U)

#define PMU_IOMODULE_GPI3_PL_GPI_7_SHIFT   7
#define PMU_IOMODULE_GPI3_PL_GPI_7_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_7_MASK    ((u32)0X00000080U)

#define PMU_IOMODULE_GPI3_PL_GPI_6_SHIFT   6
#define PMU_IOMODULE_GPI3_PL_GPI_6_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_6_MASK    ((u32)0X00000040U)

#define PMU_IOMODULE_GPI3_PL_GPI_5_SHIFT   5
#define PMU_IOMODULE_GPI3_PL_GPI_5_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_5_MASK    ((u32)0X00000020U)

#define PMU_IOMODULE_GPI3_PL_GPI_4_SHIFT   4
#define PMU_IOMODULE_GPI3_PL_GPI_4_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_4_MASK    ((u32)0X00000010U)

#define PMU_IOMODULE_GPI3_PL_GPI_3_SHIFT   3
#define PMU_IOMODULE_GPI3_PL_GPI_3_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_3_MASK    ((u32)0X00000008U)

#define PMU_IOMODULE_GPI3_PL_GPI_2_SHIFT   2
#define PMU_IOMODULE_GPI3_PL_GPI_2_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_2_MASK    ((u32)0X00000004U)

#define PMU_IOMODULE_GPI3_PL_GPI_1_SHIFT   1
#define PMU_IOMODULE_GPI3_PL_GPI_1_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_1_MASK    ((u32)0X00000002U)

#define PMU_IOMODULE_GPI3_PL_GPI_0_SHIFT   0
#define PMU_IOMODULE_GPI3_PL_GPI_0_WIDTH   1
#define PMU_IOMODULE_GPI3_PL_GPI_0_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_IOMODULE_IRQ_STATUS
 */
#define PMU_IOMODULE_IRQ_STATUS    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000030U) )

#define PMU_IOMODULE_IRQ_STATUS_CSU_PMU_SEC_LOCK_SHIFT   31
#define PMU_IOMODULE_IRQ_STATUS_CSU_PMU_SEC_LOCK_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_CSU_PMU_SEC_LOCK_MASK    ((u32)0X80000000U)

#define PMU_IOMODULE_IRQ_STATUS_INV_ADDR_SHIFT   29
#define PMU_IOMODULE_IRQ_STATUS_INV_ADDR_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_INV_ADDR_MASK    ((u32)0X20000000U)

#define PMU_IOMODULE_IRQ_STATUS_PWR_DN_REQ_SHIFT   28
#define PMU_IOMODULE_IRQ_STATUS_PWR_DN_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_PWR_DN_REQ_MASK    ((u32)0X10000000U)

#define PMU_IOMODULE_IRQ_STATUS_PWR_UP_REQ_SHIFT   27
#define PMU_IOMODULE_IRQ_STATUS_PWR_UP_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_PWR_UP_REQ_MASK    ((u32)0X08000000U)

#define PMU_IOMODULE_IRQ_STATUS_SW_RST_REQ_SHIFT   26
#define PMU_IOMODULE_IRQ_STATUS_SW_RST_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_SW_RST_REQ_MASK    ((u32)0X04000000U)

#define PMU_IOMODULE_IRQ_STATUS_HW_RST_REQ_SHIFT   25
#define PMU_IOMODULE_IRQ_STATUS_HW_RST_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_HW_RST_REQ_MASK    ((u32)0X02000000U)

#define PMU_IOMODULE_IRQ_STATUS_ISO_REQ_SHIFT   24
#define PMU_IOMODULE_IRQ_STATUS_ISO_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_ISO_REQ_MASK    ((u32)0X01000000U)

#define PMU_IOMODULE_IRQ_STATUS_LOGCLR_REQ_SHIFT   23
#define PMU_IOMODULE_IRQ_STATUS_LOGCLR_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_LOGCLR_REQ_MASK    ((u32)0X00800000U)

#define PMU_IOMODULE_IRQ_STATUS_IPI3_SHIFT   22
#define PMU_IOMODULE_IRQ_STATUS_IPI3_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_IPI3_MASK    ((u32)0X00400000U)

#define PMU_IOMODULE_IRQ_STATUS_IPI2_SHIFT   21
#define PMU_IOMODULE_IRQ_STATUS_IPI2_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_IPI2_MASK    ((u32)0X00200000U)

#define PMU_IOMODULE_IRQ_STATUS_IPI1_SHIFT   20
#define PMU_IOMODULE_IRQ_STATUS_IPI1_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_IPI1_MASK    ((u32)0X00100000U)

#define PMU_IOMODULE_IRQ_STATUS_IPI0_SHIFT   19
#define PMU_IOMODULE_IRQ_STATUS_IPI0_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_IPI0_MASK    ((u32)0X00080000U)

#define PMU_IOMODULE_IRQ_STATUS_RTC_ALARM_SHIFT   18
#define PMU_IOMODULE_IRQ_STATUS_RTC_ALARM_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_RTC_ALARM_MASK    ((u32)0X00040000U)

#define PMU_IOMODULE_IRQ_STATUS_RTC_EVERY_SECOND_SHIFT   17
#define PMU_IOMODULE_IRQ_STATUS_RTC_EVERY_SECOND_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_RTC_EVERY_SECOND_MASK    ((u32)0X00020000U)

#define PMU_IOMODULE_IRQ_STATUS_CORRECTABLE_ECC_SHIFT   16
#define PMU_IOMODULE_IRQ_STATUS_CORRECTABLE_ECC_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_CORRECTABLE_ECC_MASK    ((u32)0X00010000U)

#define PMU_IOMODULE_IRQ_STATUS_GPI3_SHIFT   14
#define PMU_IOMODULE_IRQ_STATUS_GPI3_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_GPI3_MASK    ((u32)0X00004000U)

#define PMU_IOMODULE_IRQ_STATUS_GPI2_SHIFT   13
#define PMU_IOMODULE_IRQ_STATUS_GPI2_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_GPI2_MASK    ((u32)0X00002000U)

#define PMU_IOMODULE_IRQ_STATUS_GPI1_SHIFT   12
#define PMU_IOMODULE_IRQ_STATUS_GPI1_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_GPI1_MASK    ((u32)0X00001000U)

#define PMU_IOMODULE_IRQ_STATUS_GPI0_SHIFT   11
#define PMU_IOMODULE_IRQ_STATUS_GPI0_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_GPI0_MASK    ((u32)0X00000800U)

#define PMU_IOMODULE_IRQ_STATUS_PIT3_SHIFT   6
#define PMU_IOMODULE_IRQ_STATUS_PIT3_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_PIT3_MASK    ((u32)0X00000040U)

#define PMU_IOMODULE_IRQ_STATUS_PIT2_SHIFT   5
#define PMU_IOMODULE_IRQ_STATUS_PIT2_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_PIT2_MASK    ((u32)0X00000020U)

#define PMU_IOMODULE_IRQ_STATUS_PIT1_SHIFT   4
#define PMU_IOMODULE_IRQ_STATUS_PIT1_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_PIT1_MASK    ((u32)0X00000010U)

#define PMU_IOMODULE_IRQ_STATUS_PIT0_SHIFT   3
#define PMU_IOMODULE_IRQ_STATUS_PIT0_WIDTH   1
#define PMU_IOMODULE_IRQ_STATUS_PIT0_MASK    ((u32)0X00000008U)

/**
 * Register: PMU_IOMODULE_IRQ_PENDING
 */
#define PMU_IOMODULE_IRQ_PENDING    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000034U) )

#define PMU_IOMODULE_IRQ_PENDING_CSU_PMU_SEC_LOCK_SHIFT   31
#define PMU_IOMODULE_IRQ_PENDING_CSU_PMU_SEC_LOCK_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_CSU_PMU_SEC_LOCK_MASK    ((u32)0X80000000U)

#define PMU_IOMODULE_IRQ_PENDING_INV_ADDR_SHIFT   29
#define PMU_IOMODULE_IRQ_PENDING_INV_ADDR_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_INV_ADDR_MASK    ((u32)0X20000000U)

#define PMU_IOMODULE_IRQ_PENDING_PWR_DN_REQ_SHIFT   28
#define PMU_IOMODULE_IRQ_PENDING_PWR_DN_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_PWR_DN_REQ_MASK    ((u32)0X10000000U)

#define PMU_IOMODULE_IRQ_PENDING_PWR_UP_REQ_SHIFT   27
#define PMU_IOMODULE_IRQ_PENDING_PWR_UP_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_PWR_UP_REQ_MASK    ((u32)0X08000000U)

#define PMU_IOMODULE_IRQ_PENDING_SW_RST_REQ_SHIFT   26
#define PMU_IOMODULE_IRQ_PENDING_SW_RST_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_SW_RST_REQ_MASK    ((u32)0X04000000U)

#define PMU_IOMODULE_IRQ_PENDING_HW_RST_REQ_SHIFT   25
#define PMU_IOMODULE_IRQ_PENDING_HW_RST_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_HW_RST_REQ_MASK    ((u32)0X02000000U)

#define PMU_IOMODULE_IRQ_PENDING_ISO_REQ_SHIFT   24
#define PMU_IOMODULE_IRQ_PENDING_ISO_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_ISO_REQ_MASK    ((u32)0X01000000U)

#define PMU_IOMODULE_IRQ_PENDING_LOGCLR_REQ_SHIFT   23
#define PMU_IOMODULE_IRQ_PENDING_LOGCLR_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_LOGCLR_REQ_MASK    ((u32)0X00800000U)

#define PMU_IOMODULE_IRQ_PENDING_IPI3_SHIFT   22
#define PMU_IOMODULE_IRQ_PENDING_IPI3_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_IPI3_MASK    ((u32)0X00400000U)

#define PMU_IOMODULE_IRQ_PENDING_IPI2_SHIFT   21
#define PMU_IOMODULE_IRQ_PENDING_IPI2_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_IPI2_MASK    ((u32)0X00200000U)

#define PMU_IOMODULE_IRQ_PENDING_IPI1_SHIFT   20
#define PMU_IOMODULE_IRQ_PENDING_IPI1_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_IPI1_MASK    ((u32)0X00100000U)

#define PMU_IOMODULE_IRQ_PENDING_IPI0_SHIFT   19
#define PMU_IOMODULE_IRQ_PENDING_IPI0_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_IPI0_MASK    ((u32)0X00080000U)

#define PMU_IOMODULE_IRQ_PENDING_RTC_ALARM_SHIFT   18
#define PMU_IOMODULE_IRQ_PENDING_RTC_ALARM_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_RTC_ALARM_MASK    ((u32)0X00040000U)

#define PMU_IOMODULE_IRQ_PENDING_RTC_EVERY_SECOND_SHIFT   17
#define PMU_IOMODULE_IRQ_PENDING_RTC_EVERY_SECOND_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_RTC_EVERY_SECOND_MASK    ((u32)0X00020000U)

#define PMU_IOMODULE_IRQ_PENDING_CORRECTABLE_ECC_SHIFT   16
#define PMU_IOMODULE_IRQ_PENDING_CORRECTABLE_ECC_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_CORRECTABLE_ECC_MASK    ((u32)0X00010000U)

#define PMU_IOMODULE_IRQ_PENDING_GPI3_SHIFT   14
#define PMU_IOMODULE_IRQ_PENDING_GPI3_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_GPI3_MASK    ((u32)0X00004000U)

#define PMU_IOMODULE_IRQ_PENDING_GPI2_SHIFT   13
#define PMU_IOMODULE_IRQ_PENDING_GPI2_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_GPI2_MASK    ((u32)0X00002000U)

#define PMU_IOMODULE_IRQ_PENDING_GPI1_SHIFT   12
#define PMU_IOMODULE_IRQ_PENDING_GPI1_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_GPI1_MASK    ((u32)0X00001000U)

#define PMU_IOMODULE_IRQ_PENDING_GPI0_SHIFT   11
#define PMU_IOMODULE_IRQ_PENDING_GPI0_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_GPI0_MASK    ((u32)0X00000800U)

#define PMU_IOMODULE_IRQ_PENDING_PIT3_SHIFT   6
#define PMU_IOMODULE_IRQ_PENDING_PIT3_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_PIT3_MASK    ((u32)0X00000040U)

#define PMU_IOMODULE_IRQ_PENDING_PIT2_SHIFT   5
#define PMU_IOMODULE_IRQ_PENDING_PIT2_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_PIT2_MASK    ((u32)0X00000020U)

#define PMU_IOMODULE_IRQ_PENDING_PIT1_SHIFT   4
#define PMU_IOMODULE_IRQ_PENDING_PIT1_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_PIT1_MASK    ((u32)0X00000010U)

#define PMU_IOMODULE_IRQ_PENDING_PIT0_SHIFT   3
#define PMU_IOMODULE_IRQ_PENDING_PIT0_WIDTH   1
#define PMU_IOMODULE_IRQ_PENDING_PIT0_MASK    ((u32)0X00000008U)

/**
 * Register: PMU_IOMODULE_IRQ_ENABLE
 */
#define PMU_IOMODULE_IRQ_ENABLE    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000038U) )

#define PMU_IOMODULE_IRQ_ENABLE_CSU_PMU_SEC_LOCK_SHIFT   31
#define PMU_IOMODULE_IRQ_ENABLE_CSU_PMU_SEC_LOCK_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_CSU_PMU_SEC_LOCK_MASK    ((u32)0X80000000U)

#define PMU_IOMODULE_IRQ_ENABLE_INV_ADDR_SHIFT   29
#define PMU_IOMODULE_IRQ_ENABLE_INV_ADDR_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_INV_ADDR_MASK    ((u32)0X20000000U)

#define PMU_IOMODULE_IRQ_ENABLE_PWR_DN_REQ_SHIFT   28
#define PMU_IOMODULE_IRQ_ENABLE_PWR_DN_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_PWR_DN_REQ_MASK    ((u32)0X10000000U)

#define PMU_IOMODULE_IRQ_ENABLE_PWR_UP_REQ_SHIFT   27
#define PMU_IOMODULE_IRQ_ENABLE_PWR_UP_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_PWR_UP_REQ_MASK    ((u32)0X08000000U)

#define PMU_IOMODULE_IRQ_ENABLE_SW_RST_REQ_SHIFT   26
#define PMU_IOMODULE_IRQ_ENABLE_SW_RST_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_SW_RST_REQ_MASK    ((u32)0X04000000U)

#define PMU_IOMODULE_IRQ_ENABLE_HW_RST_REQ_SHIFT   25
#define PMU_IOMODULE_IRQ_ENABLE_HW_RST_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_HW_RST_REQ_MASK    ((u32)0X02000000U)

#define PMU_IOMODULE_IRQ_ENABLE_ISO_REQ_SHIFT   24
#define PMU_IOMODULE_IRQ_ENABLE_ISO_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_ISO_REQ_MASK    ((u32)0X01000000U)

#define PMU_IOMODULE_IRQ_ENABLE_LOGCLR_REQ_SHIFT   23
#define PMU_IOMODULE_IRQ_ENABLE_LOGCLR_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_LOGCLR_REQ_MASK    ((u32)0X00800000U)

#define PMU_IOMODULE_IRQ_ENABLE_IPI3_SHIFT   22
#define PMU_IOMODULE_IRQ_ENABLE_IPI3_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_IPI3_MASK    ((u32)0X00400000U)

#define PMU_IOMODULE_IRQ_ENABLE_IPI2_SHIFT   21
#define PMU_IOMODULE_IRQ_ENABLE_IPI2_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_IPI2_MASK    ((u32)0X00200000U)

#define PMU_IOMODULE_IRQ_ENABLE_IPI1_SHIFT   20
#define PMU_IOMODULE_IRQ_ENABLE_IPI1_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_IPI1_MASK    ((u32)0X00100000U)

#define PMU_IOMODULE_IRQ_ENABLE_IPI0_SHIFT   19
#define PMU_IOMODULE_IRQ_ENABLE_IPI0_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_IPI0_MASK    ((u32)0X00080000U)

#define PMU_IOMODULE_IRQ_ENABLE_RTC_ALARM_SHIFT   18
#define PMU_IOMODULE_IRQ_ENABLE_RTC_ALARM_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_RTC_ALARM_MASK    ((u32)0X00040000U)

#define PMU_IOMODULE_IRQ_ENABLE_RTC_EVERY_SECOND_SHIFT   17
#define PMU_IOMODULE_IRQ_ENABLE_RTC_EVERY_SECOND_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_RTC_EVERY_SECOND_MASK    ((u32)0X00020000U)

#define PMU_IOMODULE_IRQ_ENABLE_CORRECTABLE_ECC_SHIFT   16
#define PMU_IOMODULE_IRQ_ENABLE_CORRECTABLE_ECC_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_CORRECTABLE_ECC_MASK    ((u32)0X00010000U)

#define PMU_IOMODULE_IRQ_ENABLE_GPI3_SHIFT   14
#define PMU_IOMODULE_IRQ_ENABLE_GPI3_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_GPI3_MASK    ((u32)0X00004000U)

#define PMU_IOMODULE_IRQ_ENABLE_GPI2_SHIFT   13
#define PMU_IOMODULE_IRQ_ENABLE_GPI2_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_GPI2_MASK    ((u32)0X00002000U)

#define PMU_IOMODULE_IRQ_ENABLE_GPI1_SHIFT   12
#define PMU_IOMODULE_IRQ_ENABLE_GPI1_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_GPI1_MASK    ((u32)0X00001000U)

#define PMU_IOMODULE_IRQ_ENABLE_GPI0_SHIFT   11
#define PMU_IOMODULE_IRQ_ENABLE_GPI0_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_GPI0_MASK    ((u32)0X00000800U)

#define PMU_IOMODULE_IRQ_ENABLE_PIT3_SHIFT   6
#define PMU_IOMODULE_IRQ_ENABLE_PIT3_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_PIT3_MASK    ((u32)0X00000040U)

#define PMU_IOMODULE_IRQ_ENABLE_PIT2_SHIFT   5
#define PMU_IOMODULE_IRQ_ENABLE_PIT2_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_PIT2_MASK    ((u32)0X00000020U)

#define PMU_IOMODULE_IRQ_ENABLE_PIT1_SHIFT   4
#define PMU_IOMODULE_IRQ_ENABLE_PIT1_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_PIT1_MASK    ((u32)0X00000010U)

#define PMU_IOMODULE_IRQ_ENABLE_PIT0_SHIFT   3
#define PMU_IOMODULE_IRQ_ENABLE_PIT0_WIDTH   1
#define PMU_IOMODULE_IRQ_ENABLE_PIT0_MASK    ((u32)0X00000008U)

/**
 * Register: PMU_IOMODULE_IRQ_ACK
 */
#define PMU_IOMODULE_IRQ_ACK    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X0000003CU) )

#define PMU_IOMODULE_IRQ_ACK_CSU_PMU_SEC_LOCK_SHIFT   31
#define PMU_IOMODULE_IRQ_ACK_CSU_PMU_SEC_LOCK_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_CSU_PMU_SEC_LOCK_MASK    ((u32)0X80000000U)

#define PMU_IOMODULE_IRQ_ACK_INV_ADDR_SHIFT   29
#define PMU_IOMODULE_IRQ_ACK_INV_ADDR_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_INV_ADDR_MASK    ((u32)0X20000000U)

#define PMU_IOMODULE_IRQ_ACK_PWR_DN_REQ_SHIFT   28
#define PMU_IOMODULE_IRQ_ACK_PWR_DN_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_PWR_DN_REQ_MASK    ((u32)0X10000000U)

#define PMU_IOMODULE_IRQ_ACK_PWR_UP_REQ_SHIFT   27
#define PMU_IOMODULE_IRQ_ACK_PWR_UP_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_PWR_UP_REQ_MASK    ((u32)0X08000000U)

#define PMU_IOMODULE_IRQ_ACK_SW_RST_REQ_SHIFT   26
#define PMU_IOMODULE_IRQ_ACK_SW_RST_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_SW_RST_REQ_MASK    ((u32)0X04000000U)

#define PMU_IOMODULE_IRQ_ACK_HW_RST_REQ_SHIFT   25
#define PMU_IOMODULE_IRQ_ACK_HW_RST_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_HW_RST_REQ_MASK    ((u32)0X02000000U)

#define PMU_IOMODULE_IRQ_ACK_ISO_REQ_SHIFT   24
#define PMU_IOMODULE_IRQ_ACK_ISO_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_ISO_REQ_MASK    ((u32)0X01000000U)

#define PMU_IOMODULE_IRQ_ACK_LOGCLR_REQ_SHIFT   23
#define PMU_IOMODULE_IRQ_ACK_LOGCLR_REQ_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_LOGCLR_REQ_MASK    ((u32)0X00800000U)

#define PMU_IOMODULE_IRQ_ACK_IPI3_SHIFT   22
#define PMU_IOMODULE_IRQ_ACK_IPI3_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_IPI3_MASK    ((u32)0X00400000U)

#define PMU_IOMODULE_IRQ_ACK_IPI2_SHIFT   21
#define PMU_IOMODULE_IRQ_ACK_IPI2_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_IPI2_MASK    ((u32)0X00200000U)

#define PMU_IOMODULE_IRQ_ACK_IPI1_SHIFT   20
#define PMU_IOMODULE_IRQ_ACK_IPI1_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_IPI1_MASK    ((u32)0X00100000U)

#define PMU_IOMODULE_IRQ_ACK_IPI0_SHIFT   19
#define PMU_IOMODULE_IRQ_ACK_IPI0_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_IPI0_MASK    ((u32)0X00080000U)

#define PMU_IOMODULE_IRQ_ACK_RTC_ALARM_SHIFT   18
#define PMU_IOMODULE_IRQ_ACK_RTC_ALARM_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_RTC_ALARM_MASK    ((u32)0X00040000U)

#define PMU_IOMODULE_IRQ_ACK_RTC_EVERY_SECOND_SHIFT   17
#define PMU_IOMODULE_IRQ_ACK_RTC_EVERY_SECOND_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_RTC_EVERY_SECOND_MASK    ((u32)0X00020000U)

#define PMU_IOMODULE_IRQ_ACK_CORRECTABLE_ECC_SHIFT   16
#define PMU_IOMODULE_IRQ_ACK_CORRECTABLE_ECC_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_CORRECTABLE_ECC_MASK    ((u32)0X00010000U)

#define PMU_IOMODULE_IRQ_ACK_GPI3_SHIFT   14
#define PMU_IOMODULE_IRQ_ACK_GPI3_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_GPI3_MASK    ((u32)0X00004000U)

#define PMU_IOMODULE_IRQ_ACK_GPI2_SHIFT   13
#define PMU_IOMODULE_IRQ_ACK_GPI2_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_GPI2_MASK    ((u32)0X00002000U)

#define PMU_IOMODULE_IRQ_ACK_GPI1_SHIFT   12
#define PMU_IOMODULE_IRQ_ACK_GPI1_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_GPI1_MASK    ((u32)0X00001000U)

#define PMU_IOMODULE_IRQ_ACK_GPI0_SHIFT   11
#define PMU_IOMODULE_IRQ_ACK_GPI0_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_GPI0_MASK    ((u32)0X00000800U)

#define PMU_IOMODULE_IRQ_ACK_PIT3_SHIFT   6
#define PMU_IOMODULE_IRQ_ACK_PIT3_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_PIT3_MASK    ((u32)0X00000040U)

#define PMU_IOMODULE_IRQ_ACK_PIT2_SHIFT   5
#define PMU_IOMODULE_IRQ_ACK_PIT2_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_PIT2_MASK    ((u32)0X00000020U)

#define PMU_IOMODULE_IRQ_ACK_PIT1_SHIFT   4
#define PMU_IOMODULE_IRQ_ACK_PIT1_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_PIT1_MASK    ((u32)0X00000010U)

#define PMU_IOMODULE_IRQ_ACK_PIT0_SHIFT   3
#define PMU_IOMODULE_IRQ_ACK_PIT0_WIDTH   1
#define PMU_IOMODULE_IRQ_ACK_PIT0_MASK    ((u32)0X00000008U)

/**
 * Register: PMU_IOMODULE_PIT0_PRELOAD
 */
#define PMU_IOMODULE_PIT0_PRELOAD    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000040U) )

#define PMU_IOMODULE_PIT0_PRELOAD_PIT0_PRELOAD_SHIFT   0
#define PMU_IOMODULE_PIT0_PRELOAD_PIT0_PRELOAD_WIDTH   32
#define PMU_IOMODULE_PIT0_PRELOAD_PIT0_PRELOAD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_IOMODULE_PIT0_COUNTER
 */
#define PMU_IOMODULE_PIT0_COUNTER    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000044U) )

#define PMU_IOMODULE_PIT0_COUNTER_PIT0_COUNTER_SHIFT   0
#define PMU_IOMODULE_PIT0_COUNTER_PIT0_COUNTER_WIDTH   32
#define PMU_IOMODULE_PIT0_COUNTER_PIT0_COUNTER_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_IOMODULE_PIT0_CONTROL
 */
#define PMU_IOMODULE_PIT0_CONTROL    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000048U) )

#define PMU_IOMODULE_PIT0_CONTROL_PRELOAD_SHIFT   1
#define PMU_IOMODULE_PIT0_CONTROL_PRELOAD_WIDTH   1
#define PMU_IOMODULE_PIT0_CONTROL_PRELOAD_MASK    ((u32)0X00000002U)

#define PMU_IOMODULE_PIT0_CONTROL_EN_SHIFT   0
#define PMU_IOMODULE_PIT0_CONTROL_EN_WIDTH   1
#define PMU_IOMODULE_PIT0_CONTROL_EN_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_IOMODULE_PIT1_PRELOAD
 */
#define PMU_IOMODULE_PIT1_PRELOAD    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000050U) )

#define PMU_IOMODULE_PIT1_PRELOAD_PIT1_PRELOAD_SHIFT   0
#define PMU_IOMODULE_PIT1_PRELOAD_PIT1_PRELOAD_WIDTH   32
#define PMU_IOMODULE_PIT1_PRELOAD_PIT1_PRELOAD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_IOMODULE_PIT1_COUNTER
 */
#define PMU_IOMODULE_PIT1_COUNTER    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000054U) )

#define PMU_IOMODULE_PIT1_COUNTER_PIT1_COUNTER_SHIFT   0
#define PMU_IOMODULE_PIT1_COUNTER_PIT1_COUNTER_WIDTH   32
#define PMU_IOMODULE_PIT1_COUNTER_PIT1_COUNTER_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_IOMODULE_PIT1_CONTROL
 */
#define PMU_IOMODULE_PIT1_CONTROL    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000058U) )

#define PMU_IOMODULE_PIT1_CONTROL_PRELOAD_SHIFT   1
#define PMU_IOMODULE_PIT1_CONTROL_PRELOAD_WIDTH   1
#define PMU_IOMODULE_PIT1_CONTROL_PRELOAD_MASK    ((u32)0X00000002U)

#define PMU_IOMODULE_PIT1_CONTROL_EN_SHIFT   0
#define PMU_IOMODULE_PIT1_CONTROL_EN_WIDTH   1
#define PMU_IOMODULE_PIT1_CONTROL_EN_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_IOMODULE_PIT2_PRELOAD
 */
#define PMU_IOMODULE_PIT2_PRELOAD    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000060U) )

#define PMU_IOMODULE_PIT2_PRELOAD_PIT2_PRELOAD_SHIFT   0
#define PMU_IOMODULE_PIT2_PRELOAD_PIT2_PRELOAD_WIDTH   32
#define PMU_IOMODULE_PIT2_PRELOAD_PIT2_PRELOAD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_IOMODULE_PIT2_COUNTER
 */
#define PMU_IOMODULE_PIT2_COUNTER    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000064U) )

#define PMU_IOMODULE_PIT2_COUNTER_PIT2_COUNTER_SHIFT   0
#define PMU_IOMODULE_PIT2_COUNTER_PIT2_COUNTER_WIDTH   32
#define PMU_IOMODULE_PIT2_COUNTER_PIT2_COUNTER_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_IOMODULE_PIT2_CONTROL
 */
#define PMU_IOMODULE_PIT2_CONTROL    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000068U) )

#define PMU_IOMODULE_PIT2_CONTROL_PRELOAD_SHIFT   1
#define PMU_IOMODULE_PIT2_CONTROL_PRELOAD_WIDTH   1
#define PMU_IOMODULE_PIT2_CONTROL_PRELOAD_MASK    ((u32)0X00000002U)

#define PMU_IOMODULE_PIT2_CONTROL_EN_SHIFT   0
#define PMU_IOMODULE_PIT2_CONTROL_EN_WIDTH   1
#define PMU_IOMODULE_PIT2_CONTROL_EN_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_IOMODULE_PIT3_PRELOAD
 */
#define PMU_IOMODULE_PIT3_PRELOAD    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000070U) )

#define PMU_IOMODULE_PIT3_PRELOAD_PIT3_PRELOAD_SHIFT   0
#define PMU_IOMODULE_PIT3_PRELOAD_PIT3_PRELOAD_WIDTH   32
#define PMU_IOMODULE_PIT3_PRELOAD_PIT3_PRELOAD_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_IOMODULE_PIT3_COUNTER
 */
#define PMU_IOMODULE_PIT3_COUNTER    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000074U) )

#define PMU_IOMODULE_PIT3_COUNTER_PIT3_COUNTER_SHIFT   0
#define PMU_IOMODULE_PIT3_COUNTER_PIT3_COUNTER_WIDTH   32
#define PMU_IOMODULE_PIT3_COUNTER_PIT3_COUNTER_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_IOMODULE_PIT3_CONTROL
 */
#define PMU_IOMODULE_PIT3_CONTROL    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00000078U) )

#define PMU_IOMODULE_PIT3_CONTROL_PRELOAD_SHIFT   1
#define PMU_IOMODULE_PIT3_CONTROL_PRELOAD_WIDTH   1
#define PMU_IOMODULE_PIT3_CONTROL_PRELOAD_MASK    ((u32)0X00000002U)

#define PMU_IOMODULE_PIT3_CONTROL_EN_SHIFT   0
#define PMU_IOMODULE_PIT3_CONTROL_EN_WIDTH   1
#define PMU_IOMODULE_PIT3_CONTROL_EN_MASK    ((u32)0X00000001U)

/**
 * Register: PMU_IOMODULE_INSTRUCTION_INJECT_ADDR
 */
#define PMU_IOMODULE_INSTRUCTION_INJECT_ADDR    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00001014U) )

#define PMU_IOMODULE_INSTRUCTION_INJECT_ADDR_BIT0_SHIFT   0
#define PMU_IOMODULE_INSTRUCTION_INJECT_ADDR_BIT0_WIDTH   32
#define PMU_IOMODULE_INSTRUCTION_INJECT_ADDR_BIT0_MASK    ((u32)0XFFFFFFFFU)

/**
 * Register: PMU_IOMODULE_INSTRUCTION_INJECT
 */
#define PMU_IOMODULE_INSTRUCTION_INJECT    ( ( PMU_IOMODULE_BASEADDR ) + ((u32)0X00001018U) )

#define PMU_IOMODULE_INSTRUCTION_INJECT_BIT0_SHIFT   0
#define PMU_IOMODULE_INSTRUCTION_INJECT_BIT0_WIDTH   32
#define PMU_IOMODULE_INSTRUCTION_INJECT_BIT0_MASK    ((u32)0XFFFFFFFFU)

#ifdef __cplusplus
}
#endif


#endif /* _PMU_IOMODULE_H_ */
