/******************************************************************************
* Copyright (c) 2016 -2020 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


#ifndef CSU_H_
#define CSU_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * CSU Base Address
 */
#define CSU_BASEADDR	0XFFCA0000U

#define CSU_VERSION_EMPTY_SHIFT		20
#define CSU_VERSION_PL_STATE_SHIFT	29

/**
 * Register: CSU_STATUS
 */
#define CSU_STATUS    ( ( CSU_BASEADDR ) + 0X00000000 )

#define CSU_STATUS_UNUSED_SHIFT   2
#define CSU_STATUS_UNUSED_WIDTH   30
#define CSU_STATUS_UNUSED_MASK    0XFFFFFFFCU

#define CSU_STATUS_BOOT_ENC_SHIFT   1
#define CSU_STATUS_BOOT_ENC_WIDTH   1
#define CSU_STATUS_BOOT_ENC_MASK    0X00000002

#define CSU_STATUS_BOOT_AUTH_SHIFT   0
#define CSU_STATUS_BOOT_AUTH_WIDTH   1
#define CSU_STATUS_BOOT_AUTH_MASK    0X00000001

/**
 * Register: CSU_CTRL
 */
#define CSU_CTRL    ( ( CSU_BASEADDR ) + 0X00000004 )

#define CSU_CTRL_SLVERR_ENABLE_SHIFT   4
#define CSU_CTRL_SLVERR_ENABLE_WIDTH   1
#define CSU_CTRL_SLVERR_ENABLE_MASK    0X00000010

#define CSU_CTRL_CSU_CLK_SEL_SHIFT   0
#define CSU_CTRL_CSU_CLK_SEL_WIDTH   1
#define CSU_CTRL_CSU_CLK_SEL_MASK    0X00000001

/**
 * Register: CSU_SSS_CFG
 */
#define CSU_SSS_CFG    ( ( CSU_BASEADDR ) + 0X00000008 )

#define CSU_SSS_CFG_PSTP_SSS_SHIFT   16
#define CSU_SSS_CFG_PSTP_SSS_WIDTH   4
#define CSU_SSS_CFG_PSTP_SSS_MASK    0X000F0000

#define CSU_SSS_CFG_SHA_SSS_SHIFT   12
#define CSU_SSS_CFG_SHA_SSS_WIDTH   4
#define CSU_SSS_CFG_SHA_SSS_MASK    0X0000F000

#define CSU_SSS_CFG_AES_SSS_SHIFT   8
#define CSU_SSS_CFG_AES_SSS_WIDTH   4
#define CSU_SSS_CFG_AES_SSS_MASK    0X00000F00

#define CSU_SSS_CFG_DMA_SSS_SHIFT   4
#define CSU_SSS_CFG_DMA_SSS_WIDTH   4
#define CSU_SSS_CFG_DMA_SSS_MASK    0X000000F0

#define CSU_SSS_CFG_PCAP_SSS_SHIFT   0
#define CSU_SSS_CFG_PCAP_SSS_WIDTH   4
#define CSU_SSS_CFG_PCAP_SSS_MASK    0X0000000F

/**
 * Register: CSU_DMA_RESET
 */
#define CSU_DMA_RESET    ( ( CSU_BASEADDR ) + 0X0000000C )

#define CSU_DMA_RESET_RESET_SHIFT   0
#define CSU_DMA_RESET_RESET_WIDTH   1
#define CSU_DMA_RESET_RESET_MASK    0X00000001

/**
 * Register: CSU_MULTI_BOOT
 */
#define CSU_MULTI_BOOT    ( ( CSU_BASEADDR ) + 0X00000010 )

#define CSU_MULTI_BOOT_SSSS_MULTI_BOOT_ADDR_SHIFT   0
#define CSU_MULTI_BOOT_SSSS_MULTI_BOOT_ADDR_WIDTH   32
#define CSU_MULTI_BOOT_SSSS_MULTI_BOOT_ADDR_MASK    0XFFFFFFFFU

/**
 * Register: CSU_TAMPER_TRIG
 */
#define CSU_TAMPER_TRIG    ( ( CSU_BASEADDR ) + 0X00000014 )

#define CSU_TAMPER_TRIG_TAMPER_SHIFT   0
#define CSU_TAMPER_TRIG_TAMPER_WIDTH   1
#define CSU_TAMPER_TRIG_TAMPER_MASK    0X00000001

/**
 * Register: CSU_FT_STATUS
 */
#define CSU_FT_STATUS    ( ( CSU_BASEADDR ) + 0X00000018 )

#define CSU_FT_STATUS_R_UE_SHIFT   31
#define CSU_FT_STATUS_R_UE_WIDTH   1
#define CSU_FT_STATUS_R_UE_MASK    0X80000000U

#define CSU_FT_STATUS_R_VOTER_ERROR_SHIFT   30
#define CSU_FT_STATUS_R_VOTER_ERROR_WIDTH   1
#define CSU_FT_STATUS_R_VOTER_ERROR_MASK    0X40000000

#define CSU_FT_STATUS_R_COMP_ERR_23_SHIFT   29
#define CSU_FT_STATUS_R_COMP_ERR_23_WIDTH   1
#define CSU_FT_STATUS_R_COMP_ERR_23_MASK    0X20000000

#define CSU_FT_STATUS_R_COMP_ERR_13_SHIFT   28
#define CSU_FT_STATUS_R_COMP_ERR_13_WIDTH   1
#define CSU_FT_STATUS_R_COMP_ERR_13_MASK    0X10000000

#define CSU_FT_STATUS_R_COMP_ERR_12_SHIFT   27
#define CSU_FT_STATUS_R_COMP_ERR_12_WIDTH   1
#define CSU_FT_STATUS_R_COMP_ERR_12_MASK    0X08000000

#define CSU_FT_STATUS_R_MISMATCH_23_A_SHIFT   26
#define CSU_FT_STATUS_R_MISMATCH_23_A_WIDTH   1
#define CSU_FT_STATUS_R_MISMATCH_23_A_MASK    0X04000000

#define CSU_FT_STATUS_R_MISMATCH_13_A_SHIFT   25
#define CSU_FT_STATUS_R_MISMATCH_13_A_WIDTH   1
#define CSU_FT_STATUS_R_MISMATCH_13_A_MASK    0X02000000

#define CSU_FT_STATUS_R_MISMATCH_12_A_SHIFT   24
#define CSU_FT_STATUS_R_MISMATCH_12_A_WIDTH   1
#define CSU_FT_STATUS_R_MISMATCH_12_A_MASK    0X01000000

#define CSU_FT_STATUS_R_FT_ST_MISMATCH_SHIFT   23
#define CSU_FT_STATUS_R_FT_ST_MISMATCH_WIDTH   1
#define CSU_FT_STATUS_R_FT_ST_MISMATCH_MASK    0X00800000

#define CSU_FT_STATUS_R_CPU_ID_MISMATCH_SHIFT   22
#define CSU_FT_STATUS_R_CPU_ID_MISMATCH_WIDTH   1
#define CSU_FT_STATUS_R_CPU_ID_MISMATCH_MASK    0X00400000

#define CSU_FT_STATUS_R_SLEEP_RESET_SHIFT   19
#define CSU_FT_STATUS_R_SLEEP_RESET_WIDTH   1
#define CSU_FT_STATUS_R_SLEEP_RESET_MASK    0X00080000

#define CSU_FT_STATUS_R_MISMATCH_23_B_SHIFT   18
#define CSU_FT_STATUS_R_MISMATCH_23_B_WIDTH   1
#define CSU_FT_STATUS_R_MISMATCH_23_B_MASK    0X00040000

#define CSU_FT_STATUS_R_MISMATCH_13_B_SHIFT   17
#define CSU_FT_STATUS_R_MISMATCH_13_B_WIDTH   1
#define CSU_FT_STATUS_R_MISMATCH_13_B_MASK    0X00020000

#define CSU_FT_STATUS_R_MISMATCH_12_B_SHIFT   16
#define CSU_FT_STATUS_R_MISMATCH_12_B_WIDTH   1
#define CSU_FT_STATUS_R_MISMATCH_12_B_MASK    0X00010000

#define CSU_FT_STATUS_N_UE_SHIFT   15
#define CSU_FT_STATUS_N_UE_WIDTH   1
#define CSU_FT_STATUS_N_UE_MASK    0X00008000

#define CSU_FT_STATUS_N_VOTER_ERROR_SHIFT   14
#define CSU_FT_STATUS_N_VOTER_ERROR_WIDTH   1
#define CSU_FT_STATUS_N_VOTER_ERROR_MASK    0X00004000

#define CSU_FT_STATUS_N_COMP_ERR_23_SHIFT   13
#define CSU_FT_STATUS_N_COMP_ERR_23_WIDTH   1
#define CSU_FT_STATUS_N_COMP_ERR_23_MASK    0X00002000

#define CSU_FT_STATUS_N_COMP_ERR_13_SHIFT   12
#define CSU_FT_STATUS_N_COMP_ERR_13_WIDTH   1
#define CSU_FT_STATUS_N_COMP_ERR_13_MASK    0X00001000

#define CSU_FT_STATUS_N_COMP_ERR_12_SHIFT   11
#define CSU_FT_STATUS_N_COMP_ERR_12_WIDTH   1
#define CSU_FT_STATUS_N_COMP_ERR_12_MASK    0X00000800

#define CSU_FT_STATUS_N_MISMATCH_23_A_SHIFT   10
#define CSU_FT_STATUS_N_MISMATCH_23_A_WIDTH   1
#define CSU_FT_STATUS_N_MISMATCH_23_A_MASK    0X00000400

#define CSU_FT_STATUS_N_MISMATCH_13_A_SHIFT   9
#define CSU_FT_STATUS_N_MISMATCH_13_A_WIDTH   1
#define CSU_FT_STATUS_N_MISMATCH_13_A_MASK    0X00000200

#define CSU_FT_STATUS_N_MISMATCH_12_A_SHIFT   8
#define CSU_FT_STATUS_N_MISMATCH_12_A_WIDTH   1
#define CSU_FT_STATUS_N_MISMATCH_12_A_MASK    0X00000100

#define CSU_FT_STATUS_N_FT_ST_MISMATCH_SHIFT   7
#define CSU_FT_STATUS_N_FT_ST_MISMATCH_WIDTH   1
#define CSU_FT_STATUS_N_FT_ST_MISMATCH_MASK    0X00000080

#define CSU_FT_STATUS_N_CPU_ID_MISMATCH_SHIFT   6
#define CSU_FT_STATUS_N_CPU_ID_MISMATCH_WIDTH   1
#define CSU_FT_STATUS_N_CPU_ID_MISMATCH_MASK    0X00000040

#define CSU_FT_STATUS_N_SLEEP_RESET_SHIFT   3
#define CSU_FT_STATUS_N_SLEEP_RESET_WIDTH   1
#define CSU_FT_STATUS_N_SLEEP_RESET_MASK    0X00000008

#define CSU_FT_STATUS_N_MISMATCH_23_B_SHIFT   2
#define CSU_FT_STATUS_N_MISMATCH_23_B_WIDTH   1
#define CSU_FT_STATUS_N_MISMATCH_23_B_MASK    0X00000004

#define CSU_FT_STATUS_N_MISMATCH_13_B_SHIFT   1
#define CSU_FT_STATUS_N_MISMATCH_13_B_WIDTH   1
#define CSU_FT_STATUS_N_MISMATCH_13_B_MASK    0X00000002

#define CSU_FT_STATUS_N_MISMATCH_12_B_SHIFT   0
#define CSU_FT_STATUS_N_MISMATCH_12_B_WIDTH   1
#define CSU_FT_STATUS_N_MISMATCH_12_B_MASK    0X00000001

/**
 * Register: CSU_ISR
 */
#define CSU_ISR    ( ( CSU_BASEADDR ) + 0X00000020 )

#define CSU_ISR_UNUSED31_SHIFT   31
#define CSU_ISR_UNUSED31_WIDTH   1
#define CSU_ISR_UNUSED31_MASK    0X80000000U

#define CSU_ISR_UNUSED30_SHIFT   30
#define CSU_ISR_UNUSED30_WIDTH   1
#define CSU_ISR_UNUSED30_MASK    0X40000000

#define CSU_ISR_UNUSED29_SHIFT   29
#define CSU_ISR_UNUSED29_WIDTH   1
#define CSU_ISR_UNUSED29_MASK    0X20000000

#define CSU_ISR_UNUSED28_SHIFT   28
#define CSU_ISR_UNUSED28_WIDTH   1
#define CSU_ISR_UNUSED28_MASK    0X10000000

#define CSU_ISR_UNUSED27_SHIFT   27
#define CSU_ISR_UNUSED27_WIDTH   1
#define CSU_ISR_UNUSED27_MASK    0X08000000

#define CSU_ISR_UNUSED26_SHIFT   26
#define CSU_ISR_UNUSED26_WIDTH   1
#define CSU_ISR_UNUSED26_MASK    0X04000000

#define CSU_ISR_UNUSED25_SHIFT   25
#define CSU_ISR_UNUSED25_WIDTH   1
#define CSU_ISR_UNUSED25_MASK    0X02000000

#define CSU_ISR_UNUSED24_SHIFT   24
#define CSU_ISR_UNUSED24_WIDTH   1
#define CSU_ISR_UNUSED24_MASK    0X01000000

#define CSU_ISR_UNUSED23_SHIFT   23
#define CSU_ISR_UNUSED23_WIDTH   1
#define CSU_ISR_UNUSED23_MASK    0X00800000

#define CSU_ISR_UNUSED22_SHIFT   22
#define CSU_ISR_UNUSED22_WIDTH   1
#define CSU_ISR_UNUSED22_MASK    0X00400000

#define CSU_ISR_UNUSED21_SHIFT   21
#define CSU_ISR_UNUSED21_WIDTH   1
#define CSU_ISR_UNUSED21_MASK    0X00200000

#define CSU_ISR_UNUSED20_SHIFT   20
#define CSU_ISR_UNUSED20_WIDTH   1
#define CSU_ISR_UNUSED20_MASK    0X00100000

#define CSU_ISR_UNUSED19_SHIFT   19
#define CSU_ISR_UNUSED19_WIDTH   1
#define CSU_ISR_UNUSED19_MASK    0X00080000

#define CSU_ISR_UNUSED18_SHIFT   18
#define CSU_ISR_UNUSED18_WIDTH   1
#define CSU_ISR_UNUSED18_MASK    0X00040000

#define CSU_ISR_UNUSED17_SHIFT   17
#define CSU_ISR_UNUSED17_WIDTH   1
#define CSU_ISR_UNUSED17_MASK    0X00020000

#define CSU_ISR_UNUSED16_SHIFT   16
#define CSU_ISR_UNUSED16_WIDTH   1
#define CSU_ISR_UNUSED16_MASK    0X00010000

#define CSU_ISR_CSU_PL_ISO_SHIFT   15
#define CSU_ISR_CSU_PL_ISO_WIDTH   1
#define CSU_ISR_CSU_PL_ISO_MASK    0X00008000

#define CSU_ISR_CSU_RAM_ECC_ERROR_SHIFT   14
#define CSU_ISR_CSU_RAM_ECC_ERROR_WIDTH   1
#define CSU_ISR_CSU_RAM_ECC_ERROR_MASK    0X00004000

#define CSU_ISR_TAMPER_SHIFT   13
#define CSU_ISR_TAMPER_WIDTH   1
#define CSU_ISR_TAMPER_MASK    0X00002000

#define CSU_ISR_PUF_ACC_ERROR_SHIFT   12
#define CSU_ISR_PUF_ACC_ERROR_WIDTH   1
#define CSU_ISR_PUF_ACC_ERROR_MASK    0X00001000

#define CSU_ISR_APB_SLVERR_SHIFT   11
#define CSU_ISR_APB_SLVERR_WIDTH   1
#define CSU_ISR_APB_SLVERR_MASK    0X00000800

#define CSU_ISR_TMR_FATAL_SHIFT   10
#define CSU_ISR_TMR_FATAL_WIDTH   1
#define CSU_ISR_TMR_FATAL_MASK    0X00000400

#define CSU_ISR_PL_SEU_ERROR_SHIFT   9
#define CSU_ISR_PL_SEU_ERROR_WIDTH   1
#define CSU_ISR_PL_SEU_ERROR_MASK    0X00000200

#define CSU_ISR_AES_ERROR_SHIFT   8
#define CSU_ISR_AES_ERROR_WIDTH   1
#define CSU_ISR_AES_ERROR_MASK    0X00000100

#define CSU_ISR_PCAP_WR_OVERFLOW_SHIFT   7
#define CSU_ISR_PCAP_WR_OVERFLOW_WIDTH   1
#define CSU_ISR_PCAP_WR_OVERFLOW_MASK    0X00000080

#define CSU_ISR_PCAP_RD_OVERFLOW_SHIFT   6
#define CSU_ISR_PCAP_RD_OVERFLOW_WIDTH   1
#define CSU_ISR_PCAP_RD_OVERFLOW_MASK    0X00000040

#define CSU_ISR_PL_POR_B_SHIFT   5
#define CSU_ISR_PL_POR_B_WIDTH   1
#define CSU_ISR_PL_POR_B_MASK    0X00000020

#define CSU_ISR_PL_INIT_SHIFT   4
#define CSU_ISR_PL_INIT_WIDTH   1
#define CSU_ISR_PL_INIT_MASK    0X00000010

#define CSU_ISR_PL_DONE_SHIFT   3
#define CSU_ISR_PL_DONE_WIDTH   1
#define CSU_ISR_PL_DONE_MASK    0X00000008

#define CSU_ISR_SHA_DONE_SHIFT   2
#define CSU_ISR_SHA_DONE_WIDTH   1
#define CSU_ISR_SHA_DONE_MASK    0X00000004

#define CSU_ISR_RSA_DONE_SHIFT   1
#define CSU_ISR_RSA_DONE_WIDTH   1
#define CSU_ISR_RSA_DONE_MASK    0X00000002

#define CSU_ISR_AES_DONE_SHIFT   0
#define CSU_ISR_AES_DONE_WIDTH   1
#define CSU_ISR_AES_DONE_MASK    0X00000001

/**
 * Register: CSU_IMR
 */
#define CSU_IMR    ( ( CSU_BASEADDR ) + 0X00000024 )

#define CSU_IMR_UNUSED31_SHIFT   31
#define CSU_IMR_UNUSED31_WIDTH   1
#define CSU_IMR_UNUSED31_MASK    0X80000000U

#define CSU_IMR_UNUSED30_SHIFT   30
#define CSU_IMR_UNUSED30_WIDTH   1
#define CSU_IMR_UNUSED30_MASK    0X40000000

#define CSU_IMR_UNUSED29_SHIFT   29
#define CSU_IMR_UNUSED29_WIDTH   1
#define CSU_IMR_UNUSED29_MASK    0X20000000

#define CSU_IMR_UNUSED28_SHIFT   28
#define CSU_IMR_UNUSED28_WIDTH   1
#define CSU_IMR_UNUSED28_MASK    0X10000000

#define CSU_IMR_UNUSED27_SHIFT   27
#define CSU_IMR_UNUSED27_WIDTH   1
#define CSU_IMR_UNUSED27_MASK    0X08000000

#define CSU_IMR_UNUSED26_SHIFT   26
#define CSU_IMR_UNUSED26_WIDTH   1
#define CSU_IMR_UNUSED26_MASK    0X04000000

#define CSU_IMR_UNUSED25_SHIFT   25
#define CSU_IMR_UNUSED25_WIDTH   1
#define CSU_IMR_UNUSED25_MASK    0X02000000

#define CSU_IMR_UNUSED24_SHIFT   24
#define CSU_IMR_UNUSED24_WIDTH   1
#define CSU_IMR_UNUSED24_MASK    0X01000000

#define CSU_IMR_UNUSED23_SHIFT   23
#define CSU_IMR_UNUSED23_WIDTH   1
#define CSU_IMR_UNUSED23_MASK    0X00800000

#define CSU_IMR_UNUSED22_SHIFT   22
#define CSU_IMR_UNUSED22_WIDTH   1
#define CSU_IMR_UNUSED22_MASK    0X00400000

#define CSU_IMR_UNUSED21_SHIFT   21
#define CSU_IMR_UNUSED21_WIDTH   1
#define CSU_IMR_UNUSED21_MASK    0X00200000

#define CSU_IMR_UNUSED20_SHIFT   20
#define CSU_IMR_UNUSED20_WIDTH   1
#define CSU_IMR_UNUSED20_MASK    0X00100000

#define CSU_IMR_UNUSED19_SHIFT   19
#define CSU_IMR_UNUSED19_WIDTH   1
#define CSU_IMR_UNUSED19_MASK    0X00080000

#define CSU_IMR_UNUSED18_SHIFT   18
#define CSU_IMR_UNUSED18_WIDTH   1
#define CSU_IMR_UNUSED18_MASK    0X00040000

#define CSU_IMR_UNUSED17_SHIFT   17
#define CSU_IMR_UNUSED17_WIDTH   1
#define CSU_IMR_UNUSED17_MASK    0X00020000

#define CSU_IMR_UNUSED16_SHIFT   16
#define CSU_IMR_UNUSED16_WIDTH   1
#define CSU_IMR_UNUSED16_MASK    0X00010000

#define CSU_IMR_CSU_PL_ISO_SHIFT   15
#define CSU_IMR_CSU_PL_ISO_WIDTH   1
#define CSU_IMR_CSU_PL_ISO_MASK    0X00008000

#define CSU_IMR_CSU_RAM_ECC_ERROR_SHIFT   14
#define CSU_IMR_CSU_RAM_ECC_ERROR_WIDTH   1
#define CSU_IMR_CSU_RAM_ECC_ERROR_MASK    0X00004000

#define CSU_IMR_TAMPER_SHIFT   13
#define CSU_IMR_TAMPER_WIDTH   1
#define CSU_IMR_TAMPER_MASK    0X00002000

#define CSU_IMR_PUF_ACC_ERROR_SHIFT   12
#define CSU_IMR_PUF_ACC_ERROR_WIDTH   1
#define CSU_IMR_PUF_ACC_ERROR_MASK    0X00001000

#define CSU_IMR_APB_SLVERR_SHIFT   11
#define CSU_IMR_APB_SLVERR_WIDTH   1
#define CSU_IMR_APB_SLVERR_MASK    0X00000800

#define CSU_IMR_TMR_FATAL_SHIFT   10
#define CSU_IMR_TMR_FATAL_WIDTH   1
#define CSU_IMR_TMR_FATAL_MASK    0X00000400

#define CSU_IMR_PL_SEU_ERROR_SHIFT   9
#define CSU_IMR_PL_SEU_ERROR_WIDTH   1
#define CSU_IMR_PL_SEU_ERROR_MASK    0X00000200U

#define CSU_IMR_AES_ERROR_SHIFT   8
#define CSU_IMR_AES_ERROR_WIDTH   1
#define CSU_IMR_AES_ERROR_MASK    0X00000100

#define CSU_IMR_PCAP_WR_OVERFLOW_SHIFT   7
#define CSU_IMR_PCAP_WR_OVERFLOW_WIDTH   1
#define CSU_IMR_PCAP_WR_OVERFLOW_MASK    0X00000080

#define CSU_IMR_PCAP_RD_OVERFLOW_SHIFT   6
#define CSU_IMR_PCAP_RD_OVERFLOW_WIDTH   1
#define CSU_IMR_PCAP_RD_OVERFLOW_MASK    0X00000040

#define CSU_IMR_PL_POR_B_SHIFT   5
#define CSU_IMR_PL_POR_B_WIDTH   1
#define CSU_IMR_PL_POR_B_MASK    0X00000020

#define CSU_IMR_PL_INIT_SHIFT   4
#define CSU_IMR_PL_INIT_WIDTH   1
#define CSU_IMR_PL_INIT_MASK    0X00000010

#define CSU_IMR_PL_DONE_SHIFT   3
#define CSU_IMR_PL_DONE_WIDTH   1
#define CSU_IMR_PL_DONE_MASK    0X00000008

#define CSU_IMR_SHA_DONE_SHIFT   2
#define CSU_IMR_SHA_DONE_WIDTH   1
#define CSU_IMR_SHA_DONE_MASK    0X00000004

#define CSU_IMR_RSA_DONE_SHIFT   1
#define CSU_IMR_RSA_DONE_WIDTH   1
#define CSU_IMR_RSA_DONE_MASK    0X00000002

#define CSU_IMR_AES_DONE_SHIFT   0
#define CSU_IMR_AES_DONE_WIDTH   1
#define CSU_IMR_AES_DONE_MASK    0X00000001

/**
 * Register: CSU_IER
 */
#define CSU_IER    ( ( CSU_BASEADDR ) + 0X00000028 )

#define CSU_IER_UNUSED31_SHIFT   31
#define CSU_IER_UNUSED31_WIDTH   1
#define CSU_IER_UNUSED31_MASK    0X80000000U

#define CSU_IER_UNUSED30_SHIFT   30
#define CSU_IER_UNUSED30_WIDTH   1
#define CSU_IER_UNUSED30_MASK    0X40000000

#define CSU_IER_UNUSED29_SHIFT   29
#define CSU_IER_UNUSED29_WIDTH   1
#define CSU_IER_UNUSED29_MASK    0X20000000

#define CSU_IER_UNUSED28_SHIFT   28
#define CSU_IER_UNUSED28_WIDTH   1
#define CSU_IER_UNUSED28_MASK    0X10000000

#define CSU_IER_UNUSED27_SHIFT   27
#define CSU_IER_UNUSED27_WIDTH   1
#define CSU_IER_UNUSED27_MASK    0X08000000

#define CSU_IER_UNUSED26_SHIFT   26
#define CSU_IER_UNUSED26_WIDTH   1
#define CSU_IER_UNUSED26_MASK    0X04000000

#define CSU_IER_UNUSED25_SHIFT   25
#define CSU_IER_UNUSED25_WIDTH   1
#define CSU_IER_UNUSED25_MASK    0X02000000

#define CSU_IER_UNUSED24_SHIFT   24
#define CSU_IER_UNUSED24_WIDTH   1
#define CSU_IER_UNUSED24_MASK    0X01000000

#define CSU_IER_UNUSED23_SHIFT   23
#define CSU_IER_UNUSED23_WIDTH   1
#define CSU_IER_UNUSED23_MASK    0X00800000

#define CSU_IER_UNUSED22_SHIFT   22
#define CSU_IER_UNUSED22_WIDTH   1
#define CSU_IER_UNUSED22_MASK    0X00400000

#define CSU_IER_UNUSED21_SHIFT   21
#define CSU_IER_UNUSED21_WIDTH   1
#define CSU_IER_UNUSED21_MASK    0X00200000

#define CSU_IER_UNUSED20_SHIFT   20
#define CSU_IER_UNUSED20_WIDTH   1
#define CSU_IER_UNUSED20_MASK    0X00100000

#define CSU_IER_UNUSED19_SHIFT   19
#define CSU_IER_UNUSED19_WIDTH   1
#define CSU_IER_UNUSED19_MASK    0X00080000

#define CSU_IER_UNUSED18_SHIFT   18
#define CSU_IER_UNUSED18_WIDTH   1
#define CSU_IER_UNUSED18_MASK    0X00040000

#define CSU_IER_UNUSED17_SHIFT   17
#define CSU_IER_UNUSED17_WIDTH   1
#define CSU_IER_UNUSED17_MASK    0X00020000

#define CSU_IER_UNUSED16_SHIFT   16
#define CSU_IER_UNUSED16_WIDTH   1
#define CSU_IER_UNUSED16_MASK    0X00010000

#define CSU_IER_CSU_PL_ISO_SHIFT   15
#define CSU_IER_CSU_PL_ISO_WIDTH   1
#define CSU_IER_CSU_PL_ISO_MASK    0X00008000

#define CSU_IER_CSU_RAM_ECC_ERROR_SHIFT   14
#define CSU_IER_CSU_RAM_ECC_ERROR_WIDTH   1
#define CSU_IER_CSU_RAM_ECC_ERROR_MASK    0X00004000

#define CSU_IER_TAMPER_SHIFT   13
#define CSU_IER_TAMPER_WIDTH   1
#define CSU_IER_TAMPER_MASK    0X00002000

#define CSU_IER_PUF_ACC_ERROR_SHIFT   12
#define CSU_IER_PUF_ACC_ERROR_WIDTH   1
#define CSU_IER_PUF_ACC_ERROR_MASK    0X00001000

#define CSU_IER_APB_SLVERR_SHIFT   11
#define CSU_IER_APB_SLVERR_WIDTH   1
#define CSU_IER_APB_SLVERR_MASK    0X00000800

#define CSU_IER_TMR_FATAL_SHIFT   10
#define CSU_IER_TMR_FATAL_WIDTH   1
#define CSU_IER_TMR_FATAL_MASK    0X00000400

#define CSU_IER_PL_SEU_ERROR_SHIFT   9
#define CSU_IER_PL_SEU_ERROR_WIDTH   1
#define CSU_IER_PL_SEU_ERROR_MASK    0X00000200

#define CSU_IER_AES_ERROR_SHIFT   8
#define CSU_IER_AES_ERROR_WIDTH   1
#define CSU_IER_AES_ERROR_MASK    0X00000100

#define CSU_IER_PCAP_WR_OVERFLOW_SHIFT   7
#define CSU_IER_PCAP_WR_OVERFLOW_WIDTH   1
#define CSU_IER_PCAP_WR_OVERFLOW_MASK    0X00000080

#define CSU_IER_PCAP_RD_OVERFLOW_SHIFT   6
#define CSU_IER_PCAP_RD_OVERFLOW_WIDTH   1
#define CSU_IER_PCAP_RD_OVERFLOW_MASK    0X00000040

#define CSU_IER_PL_POR_B_SHIFT   5
#define CSU_IER_PL_POR_B_WIDTH   1
#define CSU_IER_PL_POR_B_MASK    0X00000020

#define CSU_IER_PL_INIT_SHIFT   4
#define CSU_IER_PL_INIT_WIDTH   1
#define CSU_IER_PL_INIT_MASK    0X00000010

#define CSU_IER_PL_DONE_SHIFT   3
#define CSU_IER_PL_DONE_WIDTH   1
#define CSU_IER_PL_DONE_MASK    0X00000008

#define CSU_IER_SHA_DONE_SHIFT   2
#define CSU_IER_SHA_DONE_WIDTH   1
#define CSU_IER_SHA_DONE_MASK    0X00000004

#define CSU_IER_RSA_DONE_SHIFT   1
#define CSU_IER_RSA_DONE_WIDTH   1
#define CSU_IER_RSA_DONE_MASK    0X00000002

#define CSU_IER_AES_DONE_SHIFT   0
#define CSU_IER_AES_DONE_WIDTH   1
#define CSU_IER_AES_DONE_MASK    0X00000001

/**
 * Register: CSU_IDR
 */
#define CSU_IDR    ( ( CSU_BASEADDR ) + 0X0000002C )

#define CSU_IDR_UNUSED31_SHIFT   31
#define CSU_IDR_UNUSED31_WIDTH   1
#define CSU_IDR_UNUSED31_MASK    0X80000000U

#define CSU_IDR_UNUSED30_SHIFT   30
#define CSU_IDR_UNUSED30_WIDTH   1
#define CSU_IDR_UNUSED30_MASK    0X40000000

#define CSU_IDR_UNUSED29_SHIFT   29
#define CSU_IDR_UNUSED29_WIDTH   1
#define CSU_IDR_UNUSED29_MASK    0X20000000

#define CSU_IDR_UNUSED28_SHIFT   28
#define CSU_IDR_UNUSED28_WIDTH   1
#define CSU_IDR_UNUSED28_MASK    0X10000000

#define CSU_IDR_UNUSED27_SHIFT   27
#define CSU_IDR_UNUSED27_WIDTH   1
#define CSU_IDR_UNUSED27_MASK    0X08000000

#define CSU_IDR_UNUSED26_SHIFT   26
#define CSU_IDR_UNUSED26_WIDTH   1
#define CSU_IDR_UNUSED26_MASK    0X04000000

#define CSU_IDR_UNUSED25_SHIFT   25
#define CSU_IDR_UNUSED25_WIDTH   1
#define CSU_IDR_UNUSED25_MASK    0X02000000

#define CSU_IDR_UNUSED24_SHIFT   24
#define CSU_IDR_UNUSED24_WIDTH   1
#define CSU_IDR_UNUSED24_MASK    0X01000000

#define CSU_IDR_UNUSED23_SHIFT   23
#define CSU_IDR_UNUSED23_WIDTH   1
#define CSU_IDR_UNUSED23_MASK    0X00800000

#define CSU_IDR_UNUSED22_SHIFT   22
#define CSU_IDR_UNUSED22_WIDTH   1
#define CSU_IDR_UNUSED22_MASK    0X00400000

#define CSU_IDR_UNUSED21_SHIFT   21
#define CSU_IDR_UNUSED21_WIDTH   1
#define CSU_IDR_UNUSED21_MASK    0X00200000

#define CSU_IDR_UNUSED20_SHIFT   20
#define CSU_IDR_UNUSED20_WIDTH   1
#define CSU_IDR_UNUSED20_MASK    0X00100000

#define CSU_IDR_UNUSED19_SHIFT   19
#define CSU_IDR_UNUSED19_WIDTH   1
#define CSU_IDR_UNUSED19_MASK    0X00080000

#define CSU_IDR_UNUSED18_SHIFT   18
#define CSU_IDR_UNUSED18_WIDTH   1
#define CSU_IDR_UNUSED18_MASK    0X00040000

#define CSU_IDR_UNUSED17_SHIFT   17
#define CSU_IDR_UNUSED17_WIDTH   1
#define CSU_IDR_UNUSED17_MASK    0X00020000

#define CSU_IDR_UNUSED16_SHIFT   16
#define CSU_IDR_UNUSED16_WIDTH   1
#define CSU_IDR_UNUSED16_MASK    0X00010000

#define CSU_IDR_CSU_PL_ISO_SHIFT   15
#define CSU_IDR_CSU_PL_ISO_WIDTH   1
#define CSU_IDR_CSU_PL_ISO_MASK    0X00008000

#define CSU_IDR_CSU_RAM_ECC_ERROR_SHIFT   14
#define CSU_IDR_CSU_RAM_ECC_ERROR_WIDTH   1
#define CSU_IDR_CSU_RAM_ECC_ERROR_MASK    0X00004000

#define CSU_IDR_TAMPER_SHIFT   13
#define CSU_IDR_TAMPER_WIDTH   1
#define CSU_IDR_TAMPER_MASK    0X00002000

#define CSU_IDR_PUF_ACC_ERROR_SHIFT   12
#define CSU_IDR_PUF_ACC_ERROR_WIDTH   1
#define CSU_IDR_PUF_ACC_ERROR_MASK    0X00001000

#define CSU_IDR_APB_SLVERR_SHIFT   11
#define CSU_IDR_APB_SLVERR_WIDTH   1
#define CSU_IDR_APB_SLVERR_MASK    0X00000800

#define CSU_IDR_TMR_FATAL_SHIFT   10
#define CSU_IDR_TMR_FATAL_WIDTH   1
#define CSU_IDR_TMR_FATAL_MASK    0X00000400

#define CSU_IDR_PL_SEU_ERROR_SHIFT   9
#define CSU_IDR_PL_SEU_ERROR_WIDTH   1
#define CSU_IDR_PL_SEU_ERROR_MASK    0X00000200

#define CSU_IDR_AES_ERROR_SHIFT   8
#define CSU_IDR_AES_ERROR_WIDTH   1
#define CSU_IDR_AES_ERROR_MASK    0X00000100

#define CSU_IDR_PCAP_WR_OVERFLOW_SHIFT   7
#define CSU_IDR_PCAP_WR_OVERFLOW_WIDTH   1
#define CSU_IDR_PCAP_WR_OVERFLOW_MASK    0X00000080

#define CSU_IDR_PCAP_RD_OVERFLOW_SHIFT   6
#define CSU_IDR_PCAP_RD_OVERFLOW_WIDTH   1
#define CSU_IDR_PCAP_RD_OVERFLOW_MASK    0X00000040

#define CSU_IDR_PL_POR_B_SHIFT   5
#define CSU_IDR_PL_POR_B_WIDTH   1
#define CSU_IDR_PL_POR_B_MASK    0X00000020

#define CSU_IDR_PL_INIT_SHIFT   4
#define CSU_IDR_PL_INIT_WIDTH   1
#define CSU_IDR_PL_INIT_MASK    0X00000010

#define CSU_IDR_PL_DONE_SHIFT   3
#define CSU_IDR_PL_DONE_WIDTH   1
#define CSU_IDR_PL_DONE_MASK    0X00000008

#define CSU_IDR_SHA_DONE_SHIFT   2
#define CSU_IDR_SHA_DONE_WIDTH   1
#define CSU_IDR_SHA_DONE_MASK    0X00000004

#define CSU_IDR_RSA_DONE_SHIFT   1
#define CSU_IDR_RSA_DONE_WIDTH   1
#define CSU_IDR_RSA_DONE_MASK    0X00000002

#define CSU_IDR_AES_DONE_SHIFT   0
#define CSU_IDR_AES_DONE_WIDTH   1
#define CSU_IDR_AES_DONE_MASK    0X00000001

/**
 * Register: CSU_JTAG_CHAIN_CFG
 */
#define CSU_JTAG_CHAIN_CFG    ( ( CSU_BASEADDR ) + 0X00000030 )

#define CSU_JTAG_CHAIN_CFG_SSSS_LINK_ARM_DAP_SHIFT   1
#define CSU_JTAG_CHAIN_CFG_SSSS_LINK_ARM_DAP_WIDTH   1
#define CSU_JTAG_CHAIN_CFG_SSSS_LINK_ARM_DAP_MASK    0X00000002

#define CSU_JTAG_CHAIN_CFG_SSSS_LINK_PL_TAP_SHIFT   0
#define CSU_JTAG_CHAIN_CFG_SSSS_LINK_PL_TAP_WIDTH   1
#define CSU_JTAG_CHAIN_CFG_SSSS_LINK_PL_TAP_MASK    0X00000001

/**
 * Register: CSU_JTAG_CHAIN_STATUS
 */
#define CSU_JTAG_CHAIN_STATUS    ( ( CSU_BASEADDR ) + 0X00000034 )

#define CSU_JTAG_CHAIN_STATUS_ARM_DAP_SHIFT   1
#define CSU_JTAG_CHAIN_STATUS_ARM_DAP_WIDTH   1
#define CSU_JTAG_CHAIN_STATUS_ARM_DAP_MASK    0X00000002

#define CSU_JTAG_CHAIN_STATUS_PL_TAP_SHIFT   0
#define CSU_JTAG_CHAIN_STATUS_PL_TAP_WIDTH   1
#define CSU_JTAG_CHAIN_STATUS_PL_TAP_MASK    0X00000001

/**
 * Register: CSU_JTAG_SEC
 */
#define CSU_JTAG_SEC    ( ( CSU_BASEADDR ) + 0X00000038 )

#define CSU_JTAG_SEC_SSSS_DDRPHY_SEC_SHIFT   12
#define CSU_JTAG_SEC_SSSS_DDRPHY_SEC_WIDTH   3
#define CSU_JTAG_SEC_SSSS_DDRPHY_SEC_MASK    0X00007000

#define CSU_JTAG_SEC_SSSS_PLTAP_EN_SHIFT   9
#define CSU_JTAG_SEC_SSSS_PLTAP_EN_WIDTH   3
#define CSU_JTAG_SEC_SSSS_PLTAP_EN_MASK    0X00000E00

#define CSU_JTAG_SEC_SSSS_PMU_SEC_SHIFT   6
#define CSU_JTAG_SEC_SSSS_PMU_SEC_WIDTH   3
#define CSU_JTAG_SEC_SSSS_PMU_SEC_MASK    0X000001C0

#define CSU_JTAG_SEC_SSSS_PLTAP_SEC_SHIFT   3
#define CSU_JTAG_SEC_SSSS_PLTAP_SEC_WIDTH   3
#define CSU_JTAG_SEC_SSSS_PLTAP_SEC_MASK    0X00000038

#define CSU_JTAG_SEC_SSSS_DAP_SEC_SHIFT   0
#define CSU_JTAG_SEC_SSSS_DAP_SEC_WIDTH   3
#define CSU_JTAG_SEC_SSSS_DAP_SEC_MASK    0X00000007

/**
 * Register: CSU_JTAG_DAP_CFG
 */
#define CSU_JTAG_DAP_CFG    ( ( CSU_BASEADDR ) + 0X0000003C )

#define CSU_JTAG_DAP_CFG_SSSS_RPU_SPNIDEN_SHIFT   7
#define CSU_JTAG_DAP_CFG_SSSS_RPU_SPNIDEN_WIDTH   1
#define CSU_JTAG_DAP_CFG_SSSS_RPU_SPNIDEN_MASK    0X00000080

#define CSU_JTAG_DAP_CFG_SSSS_RPU_SPIDEN_SHIFT   6
#define CSU_JTAG_DAP_CFG_SSSS_RPU_SPIDEN_WIDTH   1
#define CSU_JTAG_DAP_CFG_SSSS_RPU_SPIDEN_MASK    0X00000040

#define CSU_JTAG_DAP_CFG_SSSS_RPU_NIDEN_SHIFT   5
#define CSU_JTAG_DAP_CFG_SSSS_RPU_NIDEN_WIDTH   1
#define CSU_JTAG_DAP_CFG_SSSS_RPU_NIDEN_MASK    0X00000020

#define CSU_JTAG_DAP_CFG_SSSS_RPU_DBGEN_SHIFT   4
#define CSU_JTAG_DAP_CFG_SSSS_RPU_DBGEN_WIDTH   1
#define CSU_JTAG_DAP_CFG_SSSS_RPU_DBGEN_MASK    0X00000010

#define CSU_JTAG_DAP_CFG_SSSS_APU_SPNIDEN_SHIFT   3
#define CSU_JTAG_DAP_CFG_SSSS_APU_SPNIDEN_WIDTH   1
#define CSU_JTAG_DAP_CFG_SSSS_APU_SPNIDEN_MASK    0X00000008

#define CSU_JTAG_DAP_CFG_SSSS_APU_SPIDEN_SHIFT   2
#define CSU_JTAG_DAP_CFG_SSSS_APU_SPIDEN_WIDTH   1
#define CSU_JTAG_DAP_CFG_SSSS_APU_SPIDEN_MASK    0X00000004

#define CSU_JTAG_DAP_CFG_SSSS_APU_NIDEN_SHIFT   1
#define CSU_JTAG_DAP_CFG_SSSS_APU_NIDEN_WIDTH   1
#define CSU_JTAG_DAP_CFG_SSSS_APU_NIDEN_MASK    0X00000002

#define CSU_JTAG_DAP_CFG_SSSS_APU_DBGEN_SHIFT   0
#define CSU_JTAG_DAP_CFG_SSSS_APU_DBGEN_WIDTH   1
#define CSU_JTAG_DAP_CFG_SSSS_APU_DBGEN_MASK    0X00000001

/**
 * Register: CSU_IDCODE
 */
#define CSU_IDCODE    ( ( CSU_BASEADDR ) + 0X00000040U )

#define CSU_IDCODE_IDCODE_SHIFT   0
#define CSU_IDCODE_IDCODE_WIDTH   32
#define CSU_IDCODE_IDCODE_MASK    0XFFFFFFFFU

/**
 * Register: CSU_VERSION
 */
#define CSU_VERSION    ( ( CSU_BASEADDR ) + 0X00000044U )

#define CSU_VERSION_PLATFORM_VERSION_SHIFT   16
#define CSU_VERSION_PLATFORM_VERSION_WIDTH   4
#define CSU_VERSION_PLATFORM_VERSION_MASK    0X000F0000

#define CSU_VERSION_PLATFORM_SHIFT   12
#define CSU_VERSION_PLATFORM_WIDTH   4
#define CSU_VERSION_PLATFORM_MASK    0X0000F000

#define CSU_VERSION_RTL_VERSION_SHIFT   4
#define CSU_VERSION_RTL_VERSION_WIDTH   8
#define CSU_VERSION_RTL_VERSION_MASK    0X00000FF0

#define CSU_VERSION_PS_VERSION_SHIFT   0
#define CSU_VERSION_PS_VERSION_WIDTH   4
#define CSU_VERSION_PS_VERSION_MASK    0X0000000F

/**
 * Register: CSU_ROM_DIGEST_0
 */
#define CSU_ROM_DIGEST_0    ( ( CSU_BASEADDR ) + 0X00000050 )

#define CSU_ROM_DIGEST_0_DIGEST_SHIFT   0
#define CSU_ROM_DIGEST_0_DIGEST_WIDTH   32
#define CSU_ROM_DIGEST_0_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_ROM_DIGEST_1
 */
#define CSU_ROM_DIGEST_1    ( ( CSU_BASEADDR ) + 0X00000054 )

#define CSU_ROM_DIGEST_1_DIGEST_SHIFT   0
#define CSU_ROM_DIGEST_1_DIGEST_WIDTH   32
#define CSU_ROM_DIGEST_1_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_ROM_DIGEST_2
 */
#define CSU_ROM_DIGEST_2    ( ( CSU_BASEADDR ) + 0X00000058 )

#define CSU_ROM_DIGEST_2_DIGEST_SHIFT   0
#define CSU_ROM_DIGEST_2_DIGEST_WIDTH   32
#define CSU_ROM_DIGEST_2_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_ROM_DIGEST_3
 */
#define CSU_ROM_DIGEST_3    ( ( CSU_BASEADDR ) + 0X0000005C )

#define CSU_ROM_DIGEST_3_DIGEST_SHIFT   0
#define CSU_ROM_DIGEST_3_DIGEST_WIDTH   32
#define CSU_ROM_DIGEST_3_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_ROM_DIGEST_4
 */
#define CSU_ROM_DIGEST_4    ( ( CSU_BASEADDR ) + 0X00000060 )

#define CSU_ROM_DIGEST_4_DIGEST_SHIFT   0
#define CSU_ROM_DIGEST_4_DIGEST_WIDTH   32
#define CSU_ROM_DIGEST_4_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_ROM_DIGEST_5
 */
#define CSU_ROM_DIGEST_5    ( ( CSU_BASEADDR ) + 0X00000064 )

#define CSU_ROM_DIGEST_5_DIGEST_SHIFT   0
#define CSU_ROM_DIGEST_5_DIGEST_WIDTH   32
#define CSU_ROM_DIGEST_5_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_ROM_DIGEST_6
 */
#define CSU_ROM_DIGEST_6    ( ( CSU_BASEADDR ) + 0X00000068 )

#define CSU_ROM_DIGEST_6_DIGEST_SHIFT   0
#define CSU_ROM_DIGEST_6_DIGEST_WIDTH   32
#define CSU_ROM_DIGEST_6_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_ROM_DIGEST_7
 */
#define CSU_ROM_DIGEST_7    ( ( CSU_BASEADDR ) + 0X0000006C )

#define CSU_ROM_DIGEST_7_DIGEST_SHIFT   0
#define CSU_ROM_DIGEST_7_DIGEST_WIDTH   32
#define CSU_ROM_DIGEST_7_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_ROM_DIGEST_8
 */
#define CSU_ROM_DIGEST_8    ( ( CSU_BASEADDR ) + 0X00000070 )

#define CSU_ROM_DIGEST_8_DIGEST_SHIFT   0
#define CSU_ROM_DIGEST_8_DIGEST_WIDTH   32
#define CSU_ROM_DIGEST_8_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_ROM_DIGEST_9
 */
#define CSU_ROM_DIGEST_9    ( ( CSU_BASEADDR ) + 0X00000074 )

#define CSU_ROM_DIGEST_9_DIGEST_SHIFT   0
#define CSU_ROM_DIGEST_9_DIGEST_WIDTH   32
#define CSU_ROM_DIGEST_9_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_ROM_DIGEST_10
 */
#define CSU_ROM_DIGEST_10    ( ( CSU_BASEADDR ) + 0X00000078 )

#define CSU_ROM_DIGEST_10_DIGEST_SHIFT   0
#define CSU_ROM_DIGEST_10_DIGEST_WIDTH   32
#define CSU_ROM_DIGEST_10_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_ROM_DIGEST_11
 */
#define CSU_ROM_DIGEST_11    ( ( CSU_BASEADDR ) + 0X0000007C )

#define CSU_ROM_DIGEST_11_DIGEST_SHIFT   0
#define CSU_ROM_DIGEST_11_DIGEST_WIDTH   32
#define CSU_ROM_DIGEST_11_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_AES_STATUS
 */
#define CSU_AES_STATUS    ( ( CSU_BASEADDR ) + 0X00001000 )

#define CSU_AES_STATUS_OKR_ZEROED_SHIFT   11
#define CSU_AES_STATUS_OKR_ZEROED_WIDTH   1
#define CSU_AES_STATUS_OKR_ZEROED_MASK    0X00000800

#define CSU_AES_STATUS_BOOT_ZEROED_SHIFT   10
#define CSU_AES_STATUS_BOOT_ZEROED_WIDTH   1
#define CSU_AES_STATUS_BOOT_ZEROED_MASK    0X00000400

#define CSU_AES_STATUS_KUP_ZEROED_SHIFT   9
#define CSU_AES_STATUS_KUP_ZEROED_WIDTH   1
#define CSU_AES_STATUS_KUP_ZEROED_MASK    0X00000200

#define CSU_AES_STATUS_AES_KEY_ZEROED_SHIFT   8
#define CSU_AES_STATUS_AES_KEY_ZEROED_WIDTH   1
#define CSU_AES_STATUS_AES_KEY_ZEROED_MASK    0X00000100

#define CSU_AES_STATUS_BLACK_KEY_DONE_SHIFT   5
#define CSU_AES_STATUS_BLACK_KEY_DONE_WIDTH   1
#define CSU_AES_STATUS_BLACK_KEY_DONE_MASK    0X00000020

#define CSU_AES_STATUS_KEY_INIT_DONE_SHIFT   4
#define CSU_AES_STATUS_KEY_INIT_DONE_WIDTH   1
#define CSU_AES_STATUS_KEY_INIT_DONE_MASK    0X00000010

#define CSU_AES_STATUS_GCM_TAG_PASS_SHIFT   3
#define CSU_AES_STATUS_GCM_TAG_PASS_WIDTH   1
#define CSU_AES_STATUS_GCM_TAG_PASS_MASK    0X00000008

#define CSU_AES_STATUS_DONE_SHIFT   2
#define CSU_AES_STATUS_DONE_WIDTH   1
#define CSU_AES_STATUS_DONE_MASK    0X00000004

#define CSU_AES_STATUS_READY_SHIFT   1
#define CSU_AES_STATUS_READY_WIDTH   1
#define CSU_AES_STATUS_READY_MASK    0X00000002

#define CSU_AES_STATUS_BUSY_SHIFT   0
#define CSU_AES_STATUS_BUSY_WIDTH   1
#define CSU_AES_STATUS_BUSY_MASK    0X00000001

/**
 * Register: CSU_AES_KEY_SRC
 */
#define CSU_AES_KEY_SRC    ( ( CSU_BASEADDR ) + 0X00001004 )

#define CSU_AES_KEY_SRC_KEY_SRC_SHIFT   0
#define CSU_AES_KEY_SRC_KEY_SRC_WIDTH   4
#define CSU_AES_KEY_SRC_KEY_SRC_MASK    0X0000000F

/**
 * Register: CSU_AES_KEY_LOAD
 */
#define CSU_AES_KEY_LOAD    ( ( CSU_BASEADDR ) + 0X00001008 )

#define CSU_AES_KEY_LOAD_KEY_LOAD_SHIFT   0
#define CSU_AES_KEY_LOAD_KEY_LOAD_WIDTH   1
#define CSU_AES_KEY_LOAD_KEY_LOAD_MASK    0X00000001

/**
 * Register: CSU_AES_START_MSG
 */
#define CSU_AES_START_MSG    ( ( CSU_BASEADDR ) + 0X0000100C )

#define CSU_AES_START_MSG_START_MSG_SHIFT   0
#define CSU_AES_START_MSG_START_MSG_WIDTH   1
#define CSU_AES_START_MSG_START_MSG_MASK    0X00000001

/**
 * Register: CSU_AES_RESET
 */
#define CSU_AES_RESET    ( ( CSU_BASEADDR ) + 0X00001010 )

#define CSU_AES_RESET_RESET_SHIFT   0
#define CSU_AES_RESET_RESET_WIDTH   1
#define CSU_AES_RESET_RESET_MASK    0X00000001

/**
 * Register: CSU_AES_KEY_CLEAR
 */
#define CSU_AES_KEY_CLEAR    ( ( CSU_BASEADDR ) + 0X00001014 )

#define CSU_AES_KEY_CLEAR_AES_OKR_ZERO_SHIFT   3
#define CSU_AES_KEY_CLEAR_AES_OKR_ZERO_WIDTH   1
#define CSU_AES_KEY_CLEAR_AES_OKR_ZERO_MASK    0X00000008

#define CSU_AES_KEY_CLEAR_AES_BOOT_ZERO_SHIFT   2
#define CSU_AES_KEY_CLEAR_AES_BOOT_ZERO_WIDTH   1
#define CSU_AES_KEY_CLEAR_AES_BOOT_ZERO_MASK    0X00000004

#define CSU_AES_KEY_CLEAR_AES_KUP_ZERO_SHIFT   1
#define CSU_AES_KEY_CLEAR_AES_KUP_ZERO_WIDTH   1
#define CSU_AES_KEY_CLEAR_AES_KUP_ZERO_MASK    0X00000002

#define CSU_AES_KEY_CLEAR_AES_KEY_ZERO_SHIFT   0
#define CSU_AES_KEY_CLEAR_AES_KEY_ZERO_WIDTH   1
#define CSU_AES_KEY_CLEAR_AES_KEY_ZERO_MASK    0X00000001

/**
 * Register: CSU_AES_CFG
 */
#define CSU_AES_CFG    ( ( CSU_BASEADDR ) + 0X00001018 )

#define CSU_AES_CFG_ENCRYPT_DECRYPT_N_SHIFT   0
#define CSU_AES_CFG_ENCRYPT_DECRYPT_N_WIDTH   1
#define CSU_AES_CFG_ENCRYPT_DECRYPT_N_MASK    0X00000001

/**
 * Register: CSU_AES_KUP_WR
 */
#define CSU_AES_KUP_WR    ( ( CSU_BASEADDR ) + 0X0000101C )

#define CSU_AES_KUP_WR_IV_WRITE_SHIFT   1
#define CSU_AES_KUP_WR_IV_WRITE_WIDTH   1
#define CSU_AES_KUP_WR_IV_WRITE_MASK    0X00000002

#define CSU_AES_KUP_WR_KUP_WRITE_SHIFT   0
#define CSU_AES_KUP_WR_KUP_WRITE_WIDTH   1
#define CSU_AES_KUP_WR_KUP_WRITE_MASK    0X00000001

/**
 * Register: CSU_AES_KUP_0
 */
#define CSU_AES_KUP_0    ( ( CSU_BASEADDR ) + 0X00001020 )

#define CSU_AES_KUP_0_AES_KEY_SHIFT   0
#define CSU_AES_KUP_0_AES_KEY_WIDTH   32
#define CSU_AES_KUP_0_AES_KEY_MASK    0XFFFFFFFFU

/**
 * Register: CSU_AES_KUP_1
 */
#define CSU_AES_KUP_1    ( ( CSU_BASEADDR ) + 0X00001024 )

#define CSU_AES_KUP_1_AES_KEY_SHIFT   0
#define CSU_AES_KUP_1_AES_KEY_WIDTH   32
#define CSU_AES_KUP_1_AES_KEY_MASK    0XFFFFFFFFU

/**
 * Register: CSU_AES_KUP_2
 */
#define CSU_AES_KUP_2    ( ( CSU_BASEADDR ) + 0X00001028 )

#define CSU_AES_KUP_2_AES_KEY_SHIFT   0
#define CSU_AES_KUP_2_AES_KEY_WIDTH   32
#define CSU_AES_KUP_2_AES_KEY_MASK    0XFFFFFFFFU

/**
 * Register: CSU_AES_KUP_3
 */
#define CSU_AES_KUP_3    ( ( CSU_BASEADDR ) + 0X0000102C )

#define CSU_AES_KUP_3_AES_KEY_SHIFT   0
#define CSU_AES_KUP_3_AES_KEY_WIDTH   32
#define CSU_AES_KUP_3_AES_KEY_MASK    0XFFFFFFFFU

/**
 * Register: CSU_AES_KUP_4
 */
#define CSU_AES_KUP_4    ( ( CSU_BASEADDR ) + 0X00001030 )

#define CSU_AES_KUP_4_AES_KEY_SHIFT   0
#define CSU_AES_KUP_4_AES_KEY_WIDTH   32
#define CSU_AES_KUP_4_AES_KEY_MASK    0XFFFFFFFFU

/**
 * Register: CSU_AES_KUP_5
 */
#define CSU_AES_KUP_5    ( ( CSU_BASEADDR ) + 0X00001034 )

#define CSU_AES_KUP_5_AES_KEY_SHIFT   0
#define CSU_AES_KUP_5_AES_KEY_WIDTH   32
#define CSU_AES_KUP_5_AES_KEY_MASK    0XFFFFFFFFU

/**
 * Register: CSU_AES_KUP_6
 */
#define CSU_AES_KUP_6    ( ( CSU_BASEADDR ) + 0X00001038 )

#define CSU_AES_KUP_6_AES_KEY_SHIFT   0
#define CSU_AES_KUP_6_AES_KEY_WIDTH   32
#define CSU_AES_KUP_6_AES_KEY_MASK    0XFFFFFFFFU

/**
 * Register: CSU_AES_KUP_7
 */
#define CSU_AES_KUP_7    ( ( CSU_BASEADDR ) + 0X0000103C )

#define CSU_AES_KUP_7_AES_KEY_SHIFT   0
#define CSU_AES_KUP_7_AES_KEY_WIDTH   32
#define CSU_AES_KUP_7_AES_KEY_MASK    0XFFFFFFFFU

/**
 * Register: CSU_AES_IV_0
 */
#define CSU_AES_IV_0    ( ( CSU_BASEADDR ) + 0X00001040 )

#define CSU_AES_IV_0_AES_IV_SHIFT   0
#define CSU_AES_IV_0_AES_IV_WIDTH   32
#define CSU_AES_IV_0_AES_IV_MASK    0XFFFFFFFFU

/**
 * Register: CSU_AES_IV_1
 */
#define CSU_AES_IV_1    ( ( CSU_BASEADDR ) + 0X00001044 )

#define CSU_AES_IV_1_AES_IV_SHIFT   0
#define CSU_AES_IV_1_AES_IV_WIDTH   32
#define CSU_AES_IV_1_AES_IV_MASK    0XFFFFFFFFU

/**
 * Register: CSU_AES_IV_2
 */
#define CSU_AES_IV_2    ( ( CSU_BASEADDR ) + 0X00001048 )

#define CSU_AES_IV_2_AES_IV_SHIFT   0
#define CSU_AES_IV_2_AES_IV_WIDTH   32
#define CSU_AES_IV_2_AES_IV_MASK    0XFFFFFFFFU

/**
 * Register: CSU_AES_IV_3
 */
#define CSU_AES_IV_3    ( ( CSU_BASEADDR ) + 0X0000104C )

#define CSU_AES_IV_3_AES_IV_DLC_SHIFT   0
#define CSU_AES_IV_3_AES_IV_DLC_WIDTH   32
#define CSU_AES_IV_3_AES_IV_DLC_MASK    0XFFFFFFFFU

/**
 * Register: CSU_SHA_START
 */
#define CSU_SHA_START    ( ( CSU_BASEADDR ) + 0X00002000 )

#define CSU_SHA_START_START_MSG_SHIFT   0
#define CSU_SHA_START_START_MSG_WIDTH   1
#define CSU_SHA_START_START_MSG_MASK    0X00000001

/**
 * Register: CSU_SHA_RESET
 */
#define CSU_SHA_RESET    ( ( CSU_BASEADDR ) + 0X00002004 )

#define CSU_SHA_RESET_RESET_SHIFT   0
#define CSU_SHA_RESET_RESET_WIDTH   1
#define CSU_SHA_RESET_RESET_MASK    0X00000001

/**
 * Register: CSU_SHA_DONE
 */
#define CSU_SHA_DONE    ( ( CSU_BASEADDR ) + 0X00002008 )

#define CSU_SHA_DONE_SHA_DONE_SHIFT   0
#define CSU_SHA_DONE_SHA_DONE_WIDTH   1
#define CSU_SHA_DONE_SHA_DONE_MASK    0X00000001

/**
 * Register: CSU_SHA_DIGEST_0
 */
#define CSU_SHA_DIGEST_0    ( ( CSU_BASEADDR ) + 0X00002010 )

#define CSU_SHA_DIGEST_0_DIGEST_SHIFT   0
#define CSU_SHA_DIGEST_0_DIGEST_WIDTH   32
#define CSU_SHA_DIGEST_0_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_SHA_DIGEST_1
 */
#define CSU_SHA_DIGEST_1    ( ( CSU_BASEADDR ) + 0X00002014 )

#define CSU_SHA_DIGEST_1_DIGEST_SHIFT   0
#define CSU_SHA_DIGEST_1_DIGEST_WIDTH   32
#define CSU_SHA_DIGEST_1_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_SHA_DIGEST_2
 */
#define CSU_SHA_DIGEST_2    ( ( CSU_BASEADDR ) + 0X00002018 )

#define CSU_SHA_DIGEST_2_DIGEST_SHIFT   0
#define CSU_SHA_DIGEST_2_DIGEST_WIDTH   32
#define CSU_SHA_DIGEST_2_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_SHA_DIGEST_3
 */
#define CSU_SHA_DIGEST_3    ( ( CSU_BASEADDR ) + 0X0000201C )

#define CSU_SHA_DIGEST_3_DIGEST_SHIFT   0
#define CSU_SHA_DIGEST_3_DIGEST_WIDTH   32
#define CSU_SHA_DIGEST_3_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_SHA_DIGEST_4
 */
#define CSU_SHA_DIGEST_4    ( ( CSU_BASEADDR ) + 0X00002020 )

#define CSU_SHA_DIGEST_4_DIGEST_SHIFT   0
#define CSU_SHA_DIGEST_4_DIGEST_WIDTH   32
#define CSU_SHA_DIGEST_4_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_SHA_DIGEST_5
 */
#define CSU_SHA_DIGEST_5    ( ( CSU_BASEADDR ) + 0X00002024 )

#define CSU_SHA_DIGEST_5_DIGEST_SHIFT   0
#define CSU_SHA_DIGEST_5_DIGEST_WIDTH   32
#define CSU_SHA_DIGEST_5_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_SHA_DIGEST_6
 */
#define CSU_SHA_DIGEST_6    ( ( CSU_BASEADDR ) + 0X00002028 )

#define CSU_SHA_DIGEST_6_DIGEST_SHIFT   0
#define CSU_SHA_DIGEST_6_DIGEST_WIDTH   32
#define CSU_SHA_DIGEST_6_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_SHA_DIGEST_7
 */
#define CSU_SHA_DIGEST_7    ( ( CSU_BASEADDR ) + 0X0000202C )

#define CSU_SHA_DIGEST_7_DIGEST_SHIFT   0
#define CSU_SHA_DIGEST_7_DIGEST_WIDTH   32
#define CSU_SHA_DIGEST_7_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_SHA_DIGEST_8
 */
#define CSU_SHA_DIGEST_8    ( ( CSU_BASEADDR ) + 0X00002030 )

#define CSU_SHA_DIGEST_8_DIGEST_SHIFT   0
#define CSU_SHA_DIGEST_8_DIGEST_WIDTH   32
#define CSU_SHA_DIGEST_8_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_SHA_DIGEST_9
 */
#define CSU_SHA_DIGEST_9    ( ( CSU_BASEADDR ) + 0X00002034 )

#define CSU_SHA_DIGEST_9_DIGEST_SHIFT   0
#define CSU_SHA_DIGEST_9_DIGEST_WIDTH   32
#define CSU_SHA_DIGEST_9_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_SHA_DIGEST_10
 */
#define CSU_SHA_DIGEST_10    ( ( CSU_BASEADDR ) + 0X00002038 )

#define CSU_SHA_DIGEST_10_DIGEST_SHIFT   0
#define CSU_SHA_DIGEST_10_DIGEST_WIDTH   32
#define CSU_SHA_DIGEST_10_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_SHA_DIGEST_11
 */
#define CSU_SHA_DIGEST_11    ( ( CSU_BASEADDR ) + 0X0000203C )

#define CSU_SHA_DIGEST_11_DIGEST_SHIFT   0
#define CSU_SHA_DIGEST_11_DIGEST_WIDTH   32
#define CSU_SHA_DIGEST_11_DIGEST_MASK    0XFFFFFFFFU

/**
 * Register: CSU_PCAP_PROG
 */
#define CSU_PCAP_PROG_REG    ( ( CSU_BASEADDR ) + 0X00003000 )

#define CSU_PCAP_PROG_PCFG_PROG_B_SHIFT_VAL   0
#define CSU_PCAP_PROG_PCFG_PROG_B_WIDTH_VAL   1
#define CSU_PCAP_PROG_PCFG_PROG_B_MASK_VAL    0X00000001

/**
 * Register: CSU_PCAP_RDWR
 */
#define CSU_PCAP_RDWR_REG    ( ( CSU_BASEADDR ) + 0X00003004 )

#define CSU_PCAP_RDWR_PCAP_RDWR_B_SHIFT_VAL   0
#define CSU_PCAP_RDWR_PCAP_RDWR_B_WIDTH_VAL   1
#define CSU_PCAP_RDWR_PCAP_RDWR_B_MASK_VAL    0X00000001

/**
 * Register: CSU_PCAP_CTRL
 */
#define CSU_PCAP_CTRL_REG    ( ( CSU_BASEADDR ) + 0X00003008 )

#define CSU_PCAP_CTRL_PCFG_GSR_SHIFT   3
#define CSU_PCAP_CTRL_PCFG_GSR_WIDTH   1
#define CSU_PCAP_CTRL_PCFG_GSR_MASK    0X00000008

#define CSU_PCAP_CTRL_PCFG_GTS_SHIFT   2
#define CSU_PCAP_CTRL_PCFG_GTS_WIDTH   1
#define CSU_PCAP_CTRL_PCFG_GTS_MASK    0X00000004

#define CSU_PCAP_CTRL_PCFG_POR_CNT_4K_SHIFT   1
#define CSU_PCAP_CTRL_PCFG_POR_CNT_4K_WIDTH   1
#define CSU_PCAP_CTRL_PCFG_POR_CNT_4K_MASK    0X00000002

#define CSU_PCAP_CTRL_PCAP_PR_SHIFT   0
#define CSU_PCAP_CTRL_PCAP_PR_WIDTH   1
#define CSU_PCAP_CTRL_PCAP_PR_MASK_VAL    0X00000001

/**
 * Register: CSU_PCAP_RESET
 */
#define CSU_PCAP_RESET_REG    ( ( CSU_BASEADDR ) + 0X0000300C )

#define CSU_PCAP_RESET_SHIFT   0
#define CSU_PCAP_RESET_WIDTH   1
#define CSU_PCAP_RESET_MASK    0X00000001

/**
 * Register: CSU_PCAP_STATUS
 */
#define CSU_PCAP_STATUS_REG    ( ( CSU_BASEADDR ) + 0X00003010U )

#define CSU_PCAP_STATUS_PCFG_FUSE_PL_DIS_SHIFT   31
#define CSU_PCAP_STATUS_PCFG_FUSE_PL_DIS_WIDTH   1
#define CSU_PCAP_STATUS_PCFG_FUSE_PL_DIS_MASK    0X80000000U

#define CSU_PCAP_STATUS_PCFG_PL_CFG_USED_SHIFT   30
#define CSU_PCAP_STATUS_PCFG_PL_CFG_USED_WIDTH   1
#define CSU_PCAP_STATUS_PCFG_PL_CFG_USED_MASK    0X40000000

#define CSU_PCAP_STATUS_PCFG_IS_ZYNQ_SHIFT   29
#define CSU_PCAP_STATUS_PCFG_IS_ZYNQ_WIDTH   1
#define CSU_PCAP_STATUS_PCFG_IS_ZYNQ_MASK    0X20000000

#define CSU_PCAP_STATUS_PCFG_GWE_SHIFT   13
#define CSU_PCAP_STATUS_PCFG_GWE_WIDTH   1
#define CSU_PCAP_STATUS_PCFG_GWE_MASK    0X00002000

#define CSU_PCAP_STATUS_PCFG_MCAP_MODE_SHIFT   12
#define CSU_PCAP_STATUS_PCFG_MCAP_MODE_WIDTH   1
#define CSU_PCAP_STATUS_PCFG_MCAP_MODE_MASK    0X00001000

#define CSU_PCAP_STATUS_PL_GTS_USR_B_SHIFT   11
#define CSU_PCAP_STATUS_PL_GTS_USR_B_WIDTH   1
#define CSU_PCAP_STATUS_PL_GTS_USR_B_MASK    0X00000800

#define CSU_PCAP_STATUS_PL_GTS_CFG_B_SHIFT   10
#define CSU_PCAP_STATUS_PL_GTS_CFG_B_WIDTH   1
#define CSU_PCAP_STATUS_PL_GTS_CFG_B_MASK    0X00000400

#define CSU_PCAP_STATUS_PL_GPWRDWN_B_SHIFT   9
#define CSU_PCAP_STATUS_PL_GPWRDWN_B_WIDTH   1
#define CSU_PCAP_STATUS_PL_GPWRDWN_B_MASK    0X00000200

#define CSU_PCAP_STATUS_PL_GHIGH_B_SHIFT   8
#define CSU_PCAP_STATUS_PL_GHIGH_B_WIDTH   1
#define CSU_PCAP_STATUS_PL_GHIGH_B_MASK    0X00000100

#define CSU_PCAP_STATUS_PL_FST_CFG_SHIFT   7
#define CSU_PCAP_STATUS_PL_FST_CFG_WIDTH   1
#define CSU_PCAP_STATUS_PL_FST_CFG_MASK    0X00000080

#define CSU_PCAP_STATUS_PL_CFG_RESET_B_SHIFT   6
#define CSU_PCAP_STATUS_PL_CFG_RESET_B_WIDTH   1
#define CSU_PCAP_STATUS_PL_CFG_RESET_B_MASK    0X00000040

#define CSU_PCAP_STATUS_PL_SEU_ERROR_SHIFT   5
#define CSU_PCAP_STATUS_PL_SEU_ERROR_WIDTH   1
#define CSU_PCAP_STATUS_PL_SEU_ERROR_MASK    0X00000020

#define CSU_PCAP_STATUS_PL_EOS_SHIFT   4
#define CSU_PCAP_STATUS_PL_EOS_WIDTH   1
#define CSU_PCAP_STATUS_PL_EOS_MASK    0X00000010

#define CSU_PCAP_STATUS_PL_DONE_SHIFT_VAL   3
#define CSU_PCAP_STATUS_PL_DONE_WIDTH_VAL   1
#define CSU_PCAP_STATUS_PL_DONE_MASK_VAL    0X00000008

#define CSU_PCAP_STATUS_PL_INIT_SHIFT_VAL   2
#define CSU_PCAP_STATUS_PL_INIT_WIDTH_VAL   1
#define CSU_PCAP_STATUS_PL_INIT_MASK_VAL    0X00000004U

#define CSU_PCAP_STATUS_RD_IDLE_SHIFT   1
#define CSU_PCAP_STATUS_RD_IDLE_WIDTH   1
#define CSU_PCAP_STATUS_RD_IDLE_MASK    0X00000002

#define CSU_PCAP_STATUS_WR_IDLE_SHIFT   0
#define CSU_PCAP_STATUS_WR_IDLE_WIDTH   1
#define CSU_PCAP_STATUS_WR_IDLE_MASK    0X00000001

/**
 * Register: CSU_TAMPER_STATUS
 */
#define CSU_TAMPER_STATUS    ( ( CSU_BASEADDR ) + 0X00005000 )

#define CSU_TAMPER_STATUS_TAMPER_13_SHIFT   13
#define CSU_TAMPER_STATUS_TAMPER_13_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_13_MASK    0X00002000

#define CSU_TAMPER_STATUS_TAMPER_12_SHIFT   12
#define CSU_TAMPER_STATUS_TAMPER_12_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_12_MASK    0X00001000

#define CSU_TAMPER_STATUS_TAMPER_11_SHIFT   11
#define CSU_TAMPER_STATUS_TAMPER_11_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_11_MASK    0X00000800

#define CSU_TAMPER_STATUS_TAMPER_10_SHIFT   10
#define CSU_TAMPER_STATUS_TAMPER_10_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_10_MASK    0X00000400

#define CSU_TAMPER_STATUS_TAMPER_9_SHIFT   9
#define CSU_TAMPER_STATUS_TAMPER_9_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_9_MASK    0X00000200

#define CSU_TAMPER_STATUS_TAMPER_8_SHIFT   8
#define CSU_TAMPER_STATUS_TAMPER_8_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_8_MASK    0X00000100

#define CSU_TAMPER_STATUS_TAMPER_7_SHIFT   7
#define CSU_TAMPER_STATUS_TAMPER_7_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_7_MASK    0X00000080

#define CSU_TAMPER_STATUS_TAMPER_6_SHIFT   6
#define CSU_TAMPER_STATUS_TAMPER_6_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_6_MASK    0X00000040

#define CSU_TAMPER_STATUS_TAMPER_5_SHIFT   5
#define CSU_TAMPER_STATUS_TAMPER_5_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_5_MASK    0X00000020

#define CSU_TAMPER_STATUS_TAMPER_4_SHIFT   4
#define CSU_TAMPER_STATUS_TAMPER_4_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_4_MASK    0X00000010

#define CSU_TAMPER_STATUS_TAMPER_3_SHIFT   3
#define CSU_TAMPER_STATUS_TAMPER_3_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_3_MASK    0X00000008

#define CSU_TAMPER_STATUS_TAMPER_2_SHIFT   2
#define CSU_TAMPER_STATUS_TAMPER_2_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_2_MASK    0X00000004

#define CSU_TAMPER_STATUS_TAMPER_1_SHIFT   1
#define CSU_TAMPER_STATUS_TAMPER_1_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_1_MASK    0X00000002

#define CSU_TAMPER_STATUS_TAMPER_0_SHIFT   0
#define CSU_TAMPER_STATUS_TAMPER_0_WIDTH   1
#define CSU_TAMPER_STATUS_TAMPER_0_MASK    0X00000001

/**
 * Register: CSU_TAMPER_0
 */
#define CSU_TAMPER_0    ( ( CSU_BASEADDR ) + 0X00005004 )

#define CSU_TAMPER_0_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_0_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_0_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_0_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_0_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_0_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_0_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_0_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_0_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_0_SYS_RESET_SHIFT   1
#define CSU_TAMPER_0_SYS_RESET_WIDTH   1
#define CSU_TAMPER_0_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_0_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_0_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_0_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_1
 */
#define CSU_TAMPER_1    ( ( CSU_BASEADDR ) + 0X00005008 )

#define CSU_TAMPER_1_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_1_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_1_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_1_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_1_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_1_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_1_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_1_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_1_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_1_SYS_RESET_SHIFT   1
#define CSU_TAMPER_1_SYS_RESET_WIDTH   1
#define CSU_TAMPER_1_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_1_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_1_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_1_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_2
 */
#define CSU_TAMPER_2    ( ( CSU_BASEADDR ) + 0X0000500C )

#define CSU_TAMPER_2_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_2_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_2_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_2_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_2_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_2_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_2_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_2_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_2_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_2_SYS_RESET_SHIFT   1
#define CSU_TAMPER_2_SYS_RESET_WIDTH   1
#define CSU_TAMPER_2_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_2_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_2_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_2_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_3
 */
#define CSU_TAMPER_3    ( ( CSU_BASEADDR ) + 0X00005010 )

#define CSU_TAMPER_3_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_3_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_3_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_3_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_3_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_3_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_3_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_3_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_3_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_3_SYS_RESET_SHIFT   1
#define CSU_TAMPER_3_SYS_RESET_WIDTH   1
#define CSU_TAMPER_3_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_3_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_3_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_3_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_4
 */
#define CSU_TAMPER_4    ( ( CSU_BASEADDR ) + 0X00005014 )

#define CSU_TAMPER_4_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_4_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_4_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_4_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_4_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_4_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_4_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_4_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_4_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_4_SYS_RESET_SHIFT   1
#define CSU_TAMPER_4_SYS_RESET_WIDTH   1
#define CSU_TAMPER_4_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_4_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_4_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_4_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_5
 */
#define CSU_TAMPER_5    ( ( CSU_BASEADDR ) + 0X00005018 )

#define CSU_TAMPER_5_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_5_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_5_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_5_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_5_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_5_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_5_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_5_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_5_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_5_SYS_RESET_SHIFT   1
#define CSU_TAMPER_5_SYS_RESET_WIDTH   1
#define CSU_TAMPER_5_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_5_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_5_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_5_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_6
 */
#define CSU_TAMPER_6    ( ( CSU_BASEADDR ) + 0X0000501C )

#define CSU_TAMPER_6_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_6_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_6_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_6_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_6_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_6_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_6_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_6_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_6_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_6_SYS_RESET_SHIFT   1
#define CSU_TAMPER_6_SYS_RESET_WIDTH   1
#define CSU_TAMPER_6_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_6_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_6_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_6_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_7
 */
#define CSU_TAMPER_7    ( ( CSU_BASEADDR ) + 0X00005020 )

#define CSU_TAMPER_7_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_7_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_7_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_7_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_7_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_7_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_7_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_7_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_7_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_7_SYS_RESET_SHIFT   1
#define CSU_TAMPER_7_SYS_RESET_WIDTH   1
#define CSU_TAMPER_7_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_7_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_7_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_7_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_8
 */
#define CSU_TAMPER_8    ( ( CSU_BASEADDR ) + 0X00005024 )

#define CSU_TAMPER_8_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_8_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_8_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_8_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_8_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_8_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_8_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_8_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_8_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_8_SYS_RESET_SHIFT   1
#define CSU_TAMPER_8_SYS_RESET_WIDTH   1
#define CSU_TAMPER_8_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_8_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_8_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_8_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_9
 */
#define CSU_TAMPER_9    ( ( CSU_BASEADDR ) + 0X00005028 )

#define CSU_TAMPER_9_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_9_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_9_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_9_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_9_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_9_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_9_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_9_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_9_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_9_SYS_RESET_SHIFT   1
#define CSU_TAMPER_9_SYS_RESET_WIDTH   1
#define CSU_TAMPER_9_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_9_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_9_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_9_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_10
 */
#define CSU_TAMPER_10    ( ( CSU_BASEADDR ) + 0X0000502C )

#define CSU_TAMPER_10_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_10_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_10_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_10_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_10_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_10_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_10_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_10_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_10_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_10_SYS_RESET_SHIFT   1
#define CSU_TAMPER_10_SYS_RESET_WIDTH   1
#define CSU_TAMPER_10_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_10_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_10_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_10_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_11
 */
#define CSU_TAMPER_11    ( ( CSU_BASEADDR ) + 0X00005030 )

#define CSU_TAMPER_11_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_11_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_11_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_11_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_11_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_11_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_11_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_11_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_11_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_11_SYS_RESET_SHIFT   1
#define CSU_TAMPER_11_SYS_RESET_WIDTH   1
#define CSU_TAMPER_11_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_11_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_11_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_11_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_12
 */
#define CSU_TAMPER_12    ( ( CSU_BASEADDR ) + 0X00005034 )

#define CSU_TAMPER_12_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_12_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_12_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_12_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_12_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_12_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_12_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_12_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_12_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_12_SYS_RESET_SHIFT   1
#define CSU_TAMPER_12_SYS_RESET_WIDTH   1
#define CSU_TAMPER_12_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_12_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_12_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_12_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_13
 */
#define CSU_TAMPER_13    ( ( CSU_BASEADDR ) + 0X00005038 )

#define CSU_TAMPER_13_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_13_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_13_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_13_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_13_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_13_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_13_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_13_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_13_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_13_SYS_RESET_SHIFT   1
#define CSU_TAMPER_13_SYS_RESET_WIDTH   1
#define CSU_TAMPER_13_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_13_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_13_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_13_SYS_INTERRUPT_MASK    0X00000001

/**
 * Register: CSU_TAMPER_14
 */
#define CSU_TAMPER_14    ( ( CSU_BASEADDR ) + 0X0000503C )

#define CSU_TAMPER_14_BBRAM_ERASE_SHIFT   4
#define CSU_TAMPER_14_BBRAM_ERASE_WIDTH   1
#define CSU_TAMPER_14_BBRAM_ERASE_MASK    0X00000010

#define CSU_TAMPER_14_SEC_LOCKDOWN_1_SHIFT   3
#define CSU_TAMPER_14_SEC_LOCKDOWN_1_WIDTH   1
#define CSU_TAMPER_14_SEC_LOCKDOWN_1_MASK    0X00000008

#define CSU_TAMPER_14_SEC_LOCKDOWN_0_SHIFT   2
#define CSU_TAMPER_14_SEC_LOCKDOWN_0_WIDTH   1
#define CSU_TAMPER_14_SEC_LOCKDOWN_0_MASK    0X00000004

#define CSU_TAMPER_14_SYS_RESET_SHIFT   1
#define CSU_TAMPER_14_SYS_RESET_WIDTH   1
#define CSU_TAMPER_14_SYS_RESET_MASK    0X00000002

#define CSU_TAMPER_14_SYS_INTERRUPT_SHIFT   0
#define CSU_TAMPER_14_SYS_INTERRUPT_WIDTH   1
#define CSU_TAMPER_14_SYS_INTERRUPT_MASK    0X00000001

#ifdef __cplusplus
}
#endif


#endif /* _CSU_H_ */
