/******************************************************************************
* Copyright (c) 2022 Xilinx, Inc.  All rights reserved.
* Copyright (c) 2022 - 2024 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************/
/**
*
* @file psmx_local.h
*
* This file contains PSMX local registers information
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who  Date        Changes
* ----- ---- -------- -------------------------------------------------------
* 1.00  sr   03/03/2022 Initial release
*
* </pre>
*
* @note
*
******************************************************************************/

#ifndef XPSMFW_PSMX_LOCAL_H_
#define XPSMFW_PSMX_LOCAL_H_


#ifdef __cplusplus
extern "C" {
#endif

/**
 * @defgroup psmx_local_module PSM Local register definitions
 * @{
 */
/**
 * PSMX_LOCAL_REG Base Address
 */
#define PSMX_LOCAL_REG_BASEADDR      (u32)0xEBC88000U

/**
 * @name Power control registers for APU cores
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Power control registers for APU core
 */
#define PSMX_LOCAL_REG_APU0_CORE0_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000000U )
#define PSMX_LOCAL_REG_APU0_CORE1_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000008U )
#define PSMX_LOCAL_REG_APU0_CORE2_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000010U )
#define PSMX_LOCAL_REG_APU0_CORE3_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000018U )
#define PSMX_LOCAL_REG_APU1_CORE0_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000020U )
#define PSMX_LOCAL_REG_APU1_CORE1_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000028U )
#define PSMX_LOCAL_REG_APU1_CORE2_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000030U )
#define PSMX_LOCAL_REG_APU1_CORE3_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000038U )
#define PSMX_LOCAL_REG_APU2_CORE0_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000040U )
#define PSMX_LOCAL_REG_APU2_CORE1_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000048U )
#define PSMX_LOCAL_REG_APU2_CORE2_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000050U )
#define PSMX_LOCAL_REG_APU2_CORE3_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000058U )
#define PSMX_LOCAL_REG_APU3_CORE0_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000060U )
#define PSMX_LOCAL_REG_APU3_CORE1_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000068U )
#define PSMX_LOCAL_REG_APU3_CORE2_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000070U )
#define PSMX_LOCAL_REG_APU3_CORE3_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000078U )
/** @} */

/**
 * @name Power control register masks for APU cores
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Power control register mask for APU core
 */
#define PSMX_LOCAL_REG_APU0_CORE0_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU0_CORE0_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU0_CORE1_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU0_CORE1_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU0_CORE2_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU0_CORE2_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU0_CORE3_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU0_CORE3_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU1_CORE0_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU1_CORE0_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU1_CORE1_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU1_CORE1_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU1_CORE2_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU1_CORE2_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU1_CORE3_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU1_CORE3_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU2_CORE0_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU2_CORE0_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU2_CORE1_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU2_CORE1_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU2_CORE2_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU2_CORE2_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU2_CORE3_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU2_CORE3_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU3_CORE0_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU3_CORE0_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU3_CORE1_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU3_CORE1_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU3_CORE2_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU3_CORE2_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU3_CORE3_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU3_CORE3_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
/** @} */

/**
 * @name Power status registers for APU cores
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Power status register for APU core
 */
#define PSMX_LOCAL_REG_APU0_CORE0_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000004U )
#define PSMX_LOCAL_REG_APU0_CORE1_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000000CU )
#define PSMX_LOCAL_REG_APU0_CORE2_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000014U )
#define PSMX_LOCAL_REG_APU0_CORE3_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000001CU )
#define PSMX_LOCAL_REG_APU1_CORE0_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000024U )
#define PSMX_LOCAL_REG_APU1_CORE1_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000002CU )
#define PSMX_LOCAL_REG_APU1_CORE2_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000034U )
#define PSMX_LOCAL_REG_APU1_CORE3_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000003CU )
#define PSMX_LOCAL_REG_APU2_CORE0_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000044U )
#define PSMX_LOCAL_REG_APU2_CORE1_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000004CU )
#define PSMX_LOCAL_REG_APU2_CORE2_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000054U )
#define PSMX_LOCAL_REG_APU2_CORE3_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000005CU )
#define PSMX_LOCAL_REG_APU3_CORE0_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000064U )
#define PSMX_LOCAL_REG_APU3_CORE1_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000006CU )
#define PSMX_LOCAL_REG_APU3_CORE2_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000074U )
#define PSMX_LOCAL_REG_APU3_CORE3_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000007CU )
/** @} */

/**
 * @name Power status register mask for APU cores
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Power status register mask for APU core
 */
#define PSMX_LOCAL_REG_APU0_CORE0_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU0_CORE1_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU0_CORE2_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU0_CORE3_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU1_CORE0_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU1_CORE1_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU1_CORE2_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU1_CORE3_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU2_CORE0_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU2_CORE1_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU2_CORE2_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU2_CORE3_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU3_CORE0_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU3_CORE1_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU3_CORE2_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_APU3_CORE3_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
/** @} */

/**
 * @name Power control registers for RPU cores
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Power control register for RPU core
 */
#define PSMX_LOCAL_REG_RPU_A_CORE0_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000100U )
#define PSMX_LOCAL_REG_RPU_A_CORE1_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000108U )
#define PSMX_LOCAL_REG_RPU_B_CORE0_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000110U )
#define PSMX_LOCAL_REG_RPU_B_CORE1_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000118U )
/** @} */

/**
 * @name Power control register masks for RPU cores
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Power control register mask for RPU core
 */
#define PSMX_LOCAL_REG_RPU_A_CORE0_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_RPU_A_CORE0_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_RPU_A_CORE1_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_RPU_A_CORE1_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_RPU_B_CORE0_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_RPU_B_CORE0_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_RPU_B_CORE1_PWR_CNTRL_ISOLATION_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_RPU_B_CORE1_PWR_CNTRL_PWR_GATES_MASK    (u32)0x0000000fU
/** @} */

/**
 * @name Power status registers for RPU cores
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Power status register for RPU core
 */
#define PSMX_LOCAL_REG_RPU_A_CORE0_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000104U )
#define PSMX_LOCAL_REG_RPU_A_CORE1_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000010CU )
#define PSMX_LOCAL_REG_RPU_B_CORE0_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000114U )
#define PSMX_LOCAL_REG_RPU_B_CORE1_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000011CU )
/** @} */

/**
 * @name Power status register masks for RPU cores
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Power status register mask for RPU core
 */
#define PSMX_LOCAL_REG_RPU_A_CORE0_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_RPU_A_CORE1_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_RPU_B_CORE0_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
#define PSMX_LOCAL_REG_RPU_B_CORE1_PWR_STATUS_PWR_GATES_MASK    (u32)0x0000000fU
/** @} */

/**
 * @name Power control registers
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Power control register
 */
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000150U )
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000015CU )
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000168U )
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000174U )
#define PSMX_LOCAL_REG_RPU_CACHE_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000200U )
#define PSMX_LOCAL_REG_OCM_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000250U )
#define PSMX_LOCAL_REG_TCM_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000300U )
#define PSMX_LOCAL_REG_GEM_PWR_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000350U )
/** @} */

/**
 * @name Power control register masks
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Power control register mask
 */
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_CNTRL_LTDB_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_CNTRL_SF_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_CNTRL_VICTIM_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_CNTRL_DATA1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_CNTRL_DATA0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_CNTRL_TAG3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_CNTRL_TAG2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_CNTRL_TAG1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_CNTRL_TAG0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_CNTRL_LTDB_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_CNTRL_SF_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_CNTRL_VICTIM_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_CNTRL_DATA1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_CNTRL_DATA0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_CNTRL_TAG3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_CNTRL_TAG2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_CNTRL_TAG1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_CNTRL_TAG0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_CNTRL_LTDB_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_CNTRL_SF_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_CNTRL_VICTIM_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_CNTRL_DATA1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_CNTRL_DATA0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_CNTRL_TAG3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_CNTRL_TAG2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_CNTRL_TAG1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_CNTRL_TAG0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_CNTRL_LTDB_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_CNTRL_SF_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_CNTRL_VICTIM_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_CNTRL_DATA1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_CNTRL_DATA0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_CNTRL_TAG3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_CNTRL_TAG2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_CNTRL_TAG1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_CNTRL_TAG0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_RPU_CACHE_PWR_CNTRL_B1_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_RPU_CACHE_PWR_CNTRL_B0_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_RPU_CACHE_PWR_CNTRL_A1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_RPU_CACHE_PWR_CNTRL_A0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_OCM_PWR_CNTRL_B1_I3_MASK    (u32)0x00000800U
#define PSMX_LOCAL_REG_OCM_PWR_CNTRL_B1_I2_MASK    (u32)0x00000400U
#define PSMX_LOCAL_REG_OCM_PWR_CNTRL_B1_I1_MASK    (u32)0x00000200U
#define PSMX_LOCAL_REG_OCM_PWR_CNTRL_B1_I0_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_OCM_PWR_CNTRL_B0_I3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_OCM_PWR_CNTRL_B0_I2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_OCM_PWR_CNTRL_B0_I1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_OCM_PWR_CNTRL_B0_I0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_TCM_PWR_CNTRL_TCMB1_MASK    (u32)0x01000000U
#define PSMX_LOCAL_REG_TCM_PWR_CNTRL_TCMB0_MASK    (u32)0x00010000U
#define PSMX_LOCAL_REG_TCM_PWR_CNTRL_TCMA1_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_TCM_PWR_CNTRL_TCMA0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_GEM_PWR_CNTRL_GEM1_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_GEM_PWR_CNTRL_GEM0_MASK    (u32)0x00000001U
/** @} */

/**
 * @name Chip Enable registers
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Chip Enable register
 */
#define PSMX_LOCAL_REG_APU0_DSU_L3_CE_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000154U )
#define PSMX_LOCAL_REG_APU1_DSU_L3_CE_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000160U )
#define PSMX_LOCAL_REG_APU2_DSU_L3_CE_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000016CU )
#define PSMX_LOCAL_REG_APU3_DSU_L3_CE_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000178U )
#define PSMX_LOCAL_REG_RPU_CACHE_CE_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000204U )
#define PSMX_LOCAL_REG_OCM_CE_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000258U )
#define PSMX_LOCAL_REG_TCM_CE_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000308U )
#define PSMX_LOCAL_REG_GEM_CE_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000354U )
/** @} */

/**
 * @name Chip Enable register masks
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Chip Enable register mask
 */
#define PSMX_LOCAL_REG_APU0_DSU_L3_CE_CNTRL_LTDB_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_APU0_DSU_L3_CE_CNTRL_SF_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_APU0_DSU_L3_CE_CNTRL_VICTIM_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_APU0_DSU_L3_CE_CNTRL_DATA1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_APU0_DSU_L3_CE_CNTRL_DATA0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU0_DSU_L3_CE_CNTRL_TAG3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_APU0_DSU_L3_CE_CNTRL_TAG2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_APU0_DSU_L3_CE_CNTRL_TAG1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_APU0_DSU_L3_CE_CNTRL_TAG0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_APU1_DSU_L3_CE_CNTRL_LTDB_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_APU1_DSU_L3_CE_CNTRL_SF_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_APU1_DSU_L3_CE_CNTRL_VICTIM_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_APU1_DSU_L3_CE_CNTRL_DATA1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_APU1_DSU_L3_CE_CNTRL_DATA0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU1_DSU_L3_CE_CNTRL_TAG3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_APU1_DSU_L3_CE_CNTRL_TAG2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_APU1_DSU_L3_CE_CNTRL_TAG1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_APU1_DSU_L3_CE_CNTRL_TAG0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_APU2_DSU_L3_CE_CNTRL_LTDB_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_APU2_DSU_L3_CE_CNTRL_SF_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_APU2_DSU_L3_CE_CNTRL_VICTIM_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_APU2_DSU_L3_CE_CNTRL_DATA1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_APU2_DSU_L3_CE_CNTRL_DATA0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU2_DSU_L3_CE_CNTRL_TAG3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_APU2_DSU_L3_CE_CNTRL_TAG2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_APU2_DSU_L3_CE_CNTRL_TAG1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_APU2_DSU_L3_CE_CNTRL_TAG0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_APU3_DSU_L3_CE_CNTRL_LTDB_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_APU3_DSU_L3_CE_CNTRL_SF_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_APU3_DSU_L3_CE_CNTRL_VICTIM_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_APU3_DSU_L3_CE_CNTRL_DATA1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_APU3_DSU_L3_CE_CNTRL_DATA0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU3_DSU_L3_CE_CNTRL_TAG3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_APU3_DSU_L3_CE_CNTRL_TAG2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_APU3_DSU_L3_CE_CNTRL_TAG1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_APU3_DSU_L3_CE_CNTRL_TAG0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_RPU_CACHE_CE_CNTRL_B1_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_RPU_CACHE_CE_CNTRL_B0_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_RPU_CACHE_CE_CNTRL_A1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_RPU_CACHE_CE_CNTRL_A0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_OCM_CE_CNTRL_B1_I3_MASK    (u32)0x00000800U
#define PSMX_LOCAL_REG_OCM_CE_CNTRL_B1_I2_MASK    (u32)0x00000400U
#define PSMX_LOCAL_REG_OCM_CE_CNTRL_B1_I1_MASK    (u32)0x00000200U
#define PSMX_LOCAL_REG_OCM_CE_CNTRL_B1_I0_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_OCM_CE_CNTRL_B0_I3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_OCM_CE_CNTRL_B0_I2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_OCM_CE_CNTRL_B0_I1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_OCM_CE_CNTRL_B0_I0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_TCM_CE_CNTRL_TCMB1_MASK    (u32)0x01000000U
#define PSMX_LOCAL_REG_TCM_CE_CNTRL_TCMB0_MASK    (u32)0x00010000U
#define PSMX_LOCAL_REG_TCM_CE_CNTRL_TCMA1_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_TCM_CE_CNTRL_TCMA0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_GEM_CE_CNTRL_GEM1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_GEM_CE_CNTRL_GEM0_MASK    (u32)0x00000001U
/** @} */

/**
 * @name Power status registers
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Power status register
 */
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000158U )
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000164U )
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000170U )
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000017CU )
#define PSMX_LOCAL_REG_RPU_CACHE_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000208U )
#define PSMX_LOCAL_REG_OCM_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000025CU )
#define PSMX_LOCAL_REG_TCM_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000030CU )
#define PSMX_LOCAL_REG_GEM_PWR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000358U )
/** @} */

/**
 * @name Power status register masks
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Power status register mask
 */
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_STATUS_LTDB_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_STATUS_SF_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_STATUS_VICTIM_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_STATUS_DATA1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_STATUS_DATA0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_STATUS_TAG3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_STATUS_TAG2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_STATUS_TAG1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_APU0_DSU_L3_PWR_STATUS_TAG0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_STATUS_LTDB_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_STATUS_SF_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_STATUS_VICTIM_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_STATUS_DATA1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_STATUS_DATA0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_STATUS_TAG3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_STATUS_TAG2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_STATUS_TAG1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_APU1_DSU_L3_PWR_STATUS_TAG0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_STATUS_LTDB_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_STATUS_SF_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_STATUS_VICTIM_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_STATUS_DATA1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_STATUS_DATA0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_STATUS_TAG3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_STATUS_TAG2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_STATUS_TAG1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_APU2_DSU_L3_PWR_STATUS_TAG0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_STATUS_LTDB_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_STATUS_SF_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_STATUS_VICTIM_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_STATUS_DATA1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_STATUS_DATA0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_STATUS_TAG3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_STATUS_TAG2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_STATUS_TAG1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_APU3_DSU_L3_PWR_STATUS_TAG0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_RPU_CACHE_PWR_STATUS_B1_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_RPU_CACHE_PWR_STATUS_B0_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_RPU_CACHE_PWR_STATUS_A1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_RPU_CACHE_PWR_STATUS_A0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_OCM_PWR_STATUS_B1_I3_MASK    (u32)0x00000800U
#define PSMX_LOCAL_REG_OCM_PWR_STATUS_B1_I2_MASK    (u32)0x00000400U
#define PSMX_LOCAL_REG_OCM_PWR_STATUS_B1_I1_MASK    (u32)0x00000200U
#define PSMX_LOCAL_REG_OCM_PWR_STATUS_B1_I0_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_OCM_PWR_STATUS_B0_I3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_OCM_PWR_STATUS_B0_I2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_OCM_PWR_STATUS_B0_I1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_OCM_PWR_STATUS_B0_I0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_TCM_PWR_STATUS_TCMB1_MASK    (u32)0x01000000U
#define PSMX_LOCAL_REG_TCM_PWR_STATUS_TCMB0_MASK    (u32)0x00010000U
#define PSMX_LOCAL_REG_TCM_PWR_STATUS_TCMA1_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_TCM_PWR_STATUS_TCMA0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_GEM_PWR_STATUS_GEM1_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_GEM_PWR_STATUS_GEM0_MASK    (u32)0x00000001U
/** @} */

/**
 * Register: PSMX_LOCAL_REG_OCM_RET_CNTRL
 */
#define PSMX_LOCAL_REG_OCM_RET_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000254U )

/**
 * Register: PSMX_LOCAL_REG_TCM_RET_CNTRL
 */
#define PSMX_LOCAL_REG_TCM_RET_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000304U )

/**
 * @name Retention signal control register masks
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Retention signal control register mask
 */
#define PSMX_LOCAL_REG_OCM_RET_CNTRL_B1_I3_MASK    (u32)0x00000800U
#define PSMX_LOCAL_REG_OCM_RET_CNTRL_B1_I2_MASK    (u32)0x00000400U
#define PSMX_LOCAL_REG_OCM_RET_CNTRL_B1_I1_MASK    (u32)0x00000200U
#define PSMX_LOCAL_REG_OCM_RET_CNTRL_B1_I0_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_OCM_RET_CNTRL_B0_I3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_OCM_RET_CNTRL_B0_I2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_OCM_RET_CNTRL_B0_I1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_OCM_RET_CNTRL_B0_I0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_TCM_RET_CNTRL_TCMB1_MASK    (u32)0x01000000U
#define PSMX_LOCAL_REG_TCM_RET_CNTRL_TCMB0_MASK    (u32)0x00010000U
#define PSMX_LOCAL_REG_TCM_RET_CNTRL_TCMA1_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_TCM_RET_CNTRL_TCMA0_MASK    (u32)0x00000001U
/** @} */

/**
 * Register: PSMX_LOCAL_REG_DOMAIN_ISO_CNTRL
 */
#define PSMX_LOCAL_REG_DOMAIN_ISO_CNTRL    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000400U )

/**
 * @name Domain isolation control register masks
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Domain isolation control register masks
 */
#define PSMX_LOCAL_REG_DOMAIN_ISO_CNTRL_FPD_CPM5_DFX_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_DOMAIN_ISO_CNTRL_FPD_CPM5_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_DOMAIN_ISO_CNTRL_LPD_OCM2_DFX_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_DOMAIN_ISO_CNTRL_LPD_OCM2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_DOMAIN_ISO_CNTRL_LPD_FPD_DFX_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_DOMAIN_ISO_CNTRL_LPD_FPD_MASK    (u32)0x00000001U
/** @} */

/**
 * @name PSM Local power state registers
 * @ingroup psmx_local_module
 * @{
 */
/**
 * PSM Local power state register
 */
#define PSMX_LOCAL_REG_LOC_PWR_STATE0    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000410U )
#define PSMX_LOCAL_REG_LOC_PWR_STATE1    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000414U )
/** @} */

/**
 * @name PSM Local power state register masks
 * @ingroup psmx_local_module
 * @{
 */
/**
 * PSM Local power state register mask
 */
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_OCM_B1_I3_MASK    (u32)0x80000000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_OCM_B1_I2_MASK    (u32)0x40000000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_OCM_B1_I1_MASK    (u32)0x20000000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_OCM_B1_I0_MASK    (u32)0x10000000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_OCM_B0_I3_MASK    (u32)0x08000000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_OCM_B0_I2_MASK    (u32)0x04000000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_OCM_B0_I1_MASK    (u32)0x02000000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_OCM_B0_I0_MASK    (u32)0x01000000U

#define PSMX_LOCAL_REG_LOC_PWR_STATE0_TCMB1_MASK    (u32)0x00800000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_TCMB0_MASK    (u32)0x00400000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_TCMA1_MASK    (u32)0x00200000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_TCMA0_MASK    (u32)0x00100000U

#define PSMX_LOCAL_REG_LOC_PWR_STATE0_RPU_B_CORE1_MASK    (u32)0x00080000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_RPU_B_CORE0_MASK    (u32)0x00040000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_RPU_A_CORE1_MASK    (u32)0x00020000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_RPU_A_CORE0_MASK    (u32)0x00010000U

#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU3_CORE3_MASK    (u32)0x00008000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU3_CORE2_MASK    (u32)0x00004000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU3_CORE1_MASK    (u32)0x00002000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU3_CORE0_MASK    (u32)0x00001000U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU2_CORE3_MASK    (u32)0x00000800U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU2_CORE2_MASK    (u32)0x00000400U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU2_CORE1_MASK    (u32)0x00000200U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU2_CORE0_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU1_CORE3_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU1_CORE2_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU1_CORE1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU1_CORE0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU0_CORE3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU0_CORE2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU0_CORE1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_LOC_PWR_STATE0_APU0_CORE0_MASK    (u32)0x00000001U

#define PSMX_LOCAL_REG_LOC_PWR_STATE1_FP_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_LOC_PWR_STATE1_GEM1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_LOC_PWR_STATE1_GEM0_MASK    (u32)0x00000001U
/** @} */

/**
 * Register: PSMX_LOCAL_REG_LOC_AUX_PWR_STATE
 */
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000420U )

/**
 * @name PSM Local Aux power state register masks
 * @ingroup psmx_local_module
 * @{
 */
/**
 * PSM Local Aux power state register mask
 */
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_OCM_B1_I3_MASK    (u32)0x80000000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_OCM_B1_I2_MASK    (u32)0x40000000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_OCM_B1_I1_MASK    (u32)0x20000000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_OCM_B1_I0_MASK    (u32)0x10000000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_OCM_B0_I3_MASK    (u32)0x08000000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_OCM_B0_I2_MASK    (u32)0x04000000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_OCM_B0_I1_MASK    (u32)0x02000000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_OCM_B0_I0_MASK    (u32)0x01000000U

#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_TCMB1_MASK    (u32)0x00800000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_TCMB0_MASK    (u32)0x00400000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_TCMA1_MASK    (u32)0x00200000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_TCMA0_MASK    (u32)0x00100000U

#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_RPU_B_CORE1_MASK    (u32)0x00080000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_RPU_B_CORE0_MASK    (u32)0x00040000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_RPU_A_CORE1_MASK    (u32)0x00020000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_RPU_A_CORE0_MASK    (u32)0x00010000U

#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU3_CORE3_MASK    (u32)0x00008000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU3_CORE2_MASK    (u32)0x00004000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU3_CORE1_MASK    (u32)0x00002000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU3_CORE0_MASK    (u32)0x00001000U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU2_CORE3_MASK    (u32)0x00000800U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU2_CORE2_MASK    (u32)0x00000400U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU2_CORE1_MASK    (u32)0x00000200U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU2_CORE0_MASK    (u32)0x00000100U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU1_CORE3_MASK    (u32)0x00000080U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU1_CORE2_MASK    (u32)0x00000040U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU1_CORE1_MASK    (u32)0x00000020U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU1_CORE0_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU0_CORE3_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU0_CORE2_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU0_CORE1_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_LOC_AUX_PWR_STATE_APU0_CORE0_MASK    (u32)0x00000001U
/** @} */

/**
 * @name Local General Storage registers
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Local General Storage register
 */
#define PSMX_LOCAL_REG_LOCAL_GEN_STORAGE0    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000430U )
#define PSMX_LOCAL_REG_LOCAL_GEN_STORAGE1    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000434U )
#define PSMX_LOCAL_REG_LOCAL_GEN_STORAGE2    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000438U )
#define PSMX_LOCAL_REG_LOCAL_GEN_STORAGE3    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000043CU )
/** @} */

/**
 * @name Local General Storage register masks
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Local General Storage register mask
 */
#define PSMX_LOCAL_REG_LOCAL_GEN_STORAGE0_DATA_MASK    (u32)0xffffffffU
#define PSMX_LOCAL_REG_LOCAL_GEN_STORAGE1_DATA_MASK    (u32)0xffffffffU
#define PSMX_LOCAL_REG_LOCAL_GEN_STORAGE2_DATA_MASK    (u32)0xffffffffU
#define PSMX_LOCAL_REG_LOCAL_GEN_STORAGE3_DATA_MASK    (u32)0xffffffffU
/** @} */

/**
 * @name Persistent Local General Storage registers
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Persistent Local General Storage register
 */
#define PSMX_LOCAL_REG_PERS_LOC_GEN_STORAGE0    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000440U )
#define PSMX_LOCAL_REG_PERS_LOC_GEN_STORAGE1    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000444U )
#define PSMX_LOCAL_REG_PERS_LOC_GEN_STORAGE2    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000448U )
#define PSMX_LOCAL_REG_PERS_LOC_GEN_STORAGE3    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000044CU )
/** @} */

/**
 * @name Persistent Local General Storage register masks
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Persistent Local General Storage register mask
 */
#define PSMX_LOCAL_REG_PERS_LOC_GEN_STORAGE1_DATA_MASK    (u32)0xffffffffU
#define PSMX_LOCAL_REG_PERS_LOC_GEN_STORAGE2_DATA_MASK    (u32)0xffffffffU
#define PSMX_LOCAL_REG_PERS_LOC_GEN_STORAGE3_DATA_MASK    (u32)0xffffffffU
#define PSMX_LOCAL_REG_PERS_LOC_GEN_STORAGE0_DATA_MASK    (u32)0xffffffffU
/** @} */

/**
 * @name Address Error registers
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Address Error register
 */
#define PSMX_LOCAL_REG_ADDR_ERROR_STATUS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000450U )
#define PSMX_LOCAL_REG_ADDR_ERROR_INT_MASK    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000454U )
#define PSMX_LOCAL_REG_ADDR_ERROR_INT_EN    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000458U )
#define PSMX_LOCAL_REG_ADDR_ERROR_INT_DIS    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x0000045CU )
/** @} */

/**
 * @name Address Error register masks
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Address Error register mask
 */
#define PSMX_LOCAL_REG_ADDR_ERROR_STATUS_STATUS_MASK    (u32)0x00000001U
#define PSMX_LOCAL_REG_ADDR_ERROR_INT_MASK_MASK_MASK    (u32)0x00000001U
#define PSMX_LOCAL_REG_ADDR_ERROR_INT_EN_EN_MASK    (u32)0x00000001U
#define PSMX_LOCAL_REG_ADDR_ERROR_INT_DIS_DIS_MASK    (u32)0x00000001U
/** @} */

/**
 * Register: PSMX_LOCAL_REG_PSM_GLOBAL_APB
 */
#define PSMX_LOCAL_REG_PSM_GLOBAL_APB    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000600U )

/**
 * @name Global APB register masks
 * @ingroup psmx_local_module
 * @{
 */
/**
 * Global APB register mask
 */
#define PSMX_LOCAL_REG_PSM_GLOBAL_APB_RST_N_MASK    (u32)0x00000010U
#define PSMX_LOCAL_REG_PSM_GLOBAL_APB_POWER_IDLEREQ_MASK    (u32)0x00000008U
#define PSMX_LOCAL_REG_PSM_GLOBAL_APB_POWER_IDLEACK_MASK    (u32)0x00000004U
#define PSMX_LOCAL_REG_PSM_GLOBAL_APB_POWER_IDLE_MASK    (u32)0x00000002U
#define PSMX_LOCAL_REG_PSM_GLOBAL_APB_MAINEXTEN_MASK    (u32)0x00000001U
/** @} */

/**
 * Register: PSMX_LOCAL_REG_ECO_1
 */
#define PSMX_LOCAL_REG_ECO_1    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000800U )

/**
 * Register: PSMX_LOCAL_REG_ECO_2
 */
#define PSMX_LOCAL_REG_ECO_2    ( ( PSMX_LOCAL_REG_BASEADDR ) + (u32)0x00000804U )

/**
 * @name ECO reserved register masks
 * @ingroup psmx_local_module
 * @{
 */
/**
 * ECO reserved register mask
 */
#define PSMX_LOCAL_REG_ECO_1_VALUE_MASK    (u32)0xffffffffU
#define PSMX_LOCAL_REG_ECO_2_CPM5_LPD_DFX_MASK    (u32)0x80000000U
#define PSMX_LOCAL_REG_ECO_2_CPM5_LPD_MASK    (u32)0x40000000U
#define PSMX_LOCAL_REG_ECO_2_CPM5_GT_DFX_MASK    (u32)0x20000000U
#define PSMX_LOCAL_REG_ECO_2_CPM5_GT_MASK    (u32)0x10000000U
#define PSMX_LOCAL_REG_ECO_2_CPM5_PL_DFX_MASK    (u32)0x08000000U
#define PSMX_LOCAL_REG_ECO_2_CPM5_PL_MASK    (u32)0x04000000U
#define PSMX_LOCAL_REG_ECO_2_VALUE_MASK    (u32)0x03ffffffU
/** @} */

/**
 * @name PSM Local power control register operations
 * @ingroup psmx_local_module
 * @{
 */
/**
 * PSM Local power control register operation
 */
#define PSM_LOCAL_PWR_CTRL_GATES_SHIFT                (0U)
#define PSM_LOCAL_PWR_CTRL_GATES_WIDTH                ((u32)4U)
#define PSM_LOCAL_PWR_CTRL_GATES_MASK                 ((u32)(u32)0x0000000FU)
#define PSM_LOCAL_PWR_CTRL_MAX_PWRUP_STAGES           PSM_LOCAL_PWR_CTRL_GATES_WIDTH
#define PSM_LOCAL_PWR_CTRL_ISO_MASK                   ((u32)(u32)0x00000010U)
/** @} */
/** @} */


#ifdef __cplusplus
}
#endif

#endif /* XPSMFW_PSMX_LOCAL_H_ */
