/******************************************************************************
* Copyright (c) 2018 - 2020 Xilinx, Inc.  All rights reserved.
* Copyright (C) 2022 - 2024 Advanced Micro Devices, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************/
/**
*
* @file xpsmfw_iomodule.h
*
* This file contains IO Module definitions
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver	Who		Date		Changes
* ---- ---- -------- ------------------------------
* 1.00  ma   04/09/2018 Initial release
* 1.01  rama 08/07/2023 Made IOModule as extern variable for STL support
*
* </pre>
*
* @note
*
******************************************************************************/

#ifndef XPSMFW_IOMODULE_H_
#define XPSMFW_IOMODULE_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "xpsmfw_default.h"
#include "xiomodule.h"
#include "xpsmfw_ipi_manager.h"

extern XIOModule IOModule;

/**
 * @defgroup iomodule IOMODULE related registers
 * @{
 */
#define PSM_IOMODULE_BASEADDR		(IOMODULE_BASEADDR) /**< IO Module base address */

#define PSM_IOMODULE_IRQ_STATUS		((PSM_IOMODULE_BASEADDR) + ((u32)0x00000030U)) /**< IO Module interrupt status register */

/**
 * @name IOMODULE interrupt status register operations
 * @ingroup iomodule
 * @{
 */
/**
 * IOMODULE interrupt status register operation
 */
#define PSM_IOMODULE_IRQ_STATUS_PWR_CNT_REQ_SHIFT		31
#define PSM_IOMODULE_IRQ_STATUS_PWR_CNT_REQ_WIDTH		1
#define PSM_IOMODULE_IRQ_STATUS_PWR_CNT_REQ_MASK		((u32)0x80000000U)

#define PSM_IOMODULE_IRQ_STATUS_WAKE_UP_REQ_SHIFT		30
#define PSM_IOMODULE_IRQ_STATUS_WAKE_UP_REQ_WIDTH		1
#define PSM_IOMODULE_IRQ_STATUS_WAKE_UP_REQ_MASK		((u32)0x40000000U)

#define PSM_IOMODULE_IRQ_STATUS_PSM_ERR_INT_SHIFT		29
#define PSM_IOMODULE_IRQ_STATUS_PSM_ERR_INT_WIDTH		1
#define PSM_IOMODULE_IRQ_STATUS_PSM_ERR_INT_MASK		((u32)0x20000000U)

#define PSM_IOMODULE_IRQ_STATUS_PWR_DWN_REQ_SHIFT		28
#define PSM_IOMODULE_IRQ_STATUS_PWR_DWN_REQ_WIDTH		1
#define PSM_IOMODULE_IRQ_STATUS_PWR_DWN_REQ_MASK		((u32)0x10000000U)

#define PSM_IOMODULE_IRQ_STATUS_PWR_UP_REQ_SHIFT		27
#define PSM_IOMODULE_IRQ_STATUS_PWR_UP_REQ_WIDTH		1
#define PSM_IOMODULE_IRQ_STATUS_PWR_UP_REQ_MASK			((u32)0x08000000U)

#define PSM_IOMODULE_IRQ_STATUS_SW_RST_REQ_SHIFT		26
#define PSM_IOMODULE_IRQ_STATUS_SW_RST_REQ_WIDTH		1
#define PSM_IOMODULE_IRQ_STATUS_SW_RST_REQ_MASK			((u32)0x04000000U)

#define PSM_IOMODULE_IRQ_STATUS_HW_BLK_RST_REQ_SHIFT	25
#define PSM_IOMODULE_IRQ_STATUS_HW_BLK_RST_REQ_WIDTH	1
#define PSM_IOMODULE_IRQ_STATUS_HW_BLK_RST_REQ_MASK		((u32)0x02000000U)

#define PSM_IOMODULE_IRQ_STATUS_ISO_REQ_SHIFT			24
#define PSM_IOMODULE_IRQ_STATUS_ISO_REQ_WIDTH			1
#define PSM_IOMODULE_IRQ_STATUS_ISO_REQ_MASK			((u32)0x01000000U)

#define PSM_IOMODULE_IRQ_STATUS_GICP_INT_SHIFT			22
#define PSM_IOMODULE_IRQ_STATUS_GICP_INT_WIDTH			1
#define PSM_IOMODULE_IRQ_STATUS_GICP_INT_MASK			((u32)0x00400000U)

#define PSM_IOMODULE_IRQ_STATUS_IPI_SHIFT				18
#define PSM_IOMODULE_IRQ_STATUS_IPI_WIDTH				1
#define PSM_IOMODULE_IRQ_STATUS_IPI_MASK				((u32)0x00040000U)

#define PSM_IOMODULE_IRQ_STATUS_PSM_RAM_ECC_ERR_SHIFT	16
#define PSM_IOMODULE_IRQ_STATUS_PSM_RAM_ECC_ERR_WIDTH	1
#define PSM_IOMODULE_IRQ_STATUS_PSM_RAM_ECC_ERR_MASK	((u32)0x00010000U)

#define PSM_IOMODULE_IRQ_STATUS_PIT4_SHIFT				6
#define PSM_IOMODULE_IRQ_STATUS_PIT4_WIDTH				1
#define PSM_IOMODULE_IRQ_STATUS_PIT4_MASK				((u32)0x00000040U)

#define PSM_IOMODULE_IRQ_STATUS_PIT3_SHIFT				5
#define PSM_IOMODULE_IRQ_STATUS_PIT3_WIDTH				1
#define PSM_IOMODULE_IRQ_STATUS_PIT3_MASK				((u32)0x00000020U)

#define PSM_IOMODULE_IRQ_STATUS_PIT2_SHIFT				4
#define PSM_IOMODULE_IRQ_STATUS_PIT2_WIDTH				1
#define PSM_IOMODULE_IRQ_STATUS_PIT2_MASK				((u32)0x00000010U)

#define PSM_IOMODULE_IRQ_STATUS_PIT1_SHIFT				3
#define PSM_IOMODULE_IRQ_STATUS_PIT1_WIDTH				1
#define PSM_IOMODULE_IRQ_STATUS_PIT1_MASK				((u32)0x00000008U)
/** @} */

#define PSM_IOMODULE_IRQ_PENDING	((PSM_IOMODULE_BASEADDR) + ((u32)0x00000034U)) /**< IO Module interrupt pending register */

/**
 * @name IOMODULE interrupt pending register operations
 * @ingroup iomodule
 * @{
 */
/**
 * IOMODULE interrupt pending register operation
 */
#define PSM_IOMODULE_IRQ_PENDING_PWR_CNT_REQ_SHIFT		31
#define PSM_IOMODULE_IRQ_PENDING_PWR_CNT_REQ_WIDTH		1
#define PSM_IOMODULE_IRQ_PENDING_PWR_CNT_REQ_MASK		((u32)0x80000000U)

#define PSM_IOMODULE_IRQ_PENDING_WAKE_UP_REQ_SHIFT		30
#define PSM_IOMODULE_IRQ_PENDING_WAKE_UP_REQ_WIDTH		1
#define PSM_IOMODULE_IRQ_PENDING_WAKE_UP_REQ_MASK		((u32)0x40000000U)

#define PSM_IOMODULE_IRQ_PENDING_PSM_ERR_INT_SHIFT		29
#define PSM_IOMODULE_IRQ_PENDING_PSM_ERR_INT_WIDTH		1
#define PSM_IOMODULE_IRQ_PENDING_PSM_ERR_INT_MASK		((u32)0x20000000U)

#define PSM_IOMODULE_IRQ_PENDING_PWR_DWN_REQ_SHIFT		28
#define PSM_IOMODULE_IRQ_PENDING_PWR_DWN_REQ_WIDTH		1
#define PSM_IOMODULE_IRQ_PENDING_PWR_DWN_REQ_MASK		((u32)0x10000000U)

#define PSM_IOMODULE_IRQ_PENDING_PWR_UP_REQ_SHIFT		27
#define PSM_IOMODULE_IRQ_PENDING_PWR_UP_REQ_WIDTH		1
#define PSM_IOMODULE_IRQ_PENDING_PWR_UP_REQ_MASK		((u32)0x08000000U)

#define PSM_IOMODULE_IRQ_PENDING_SW_RST_REQ_SHIFT		26
#define PSM_IOMODULE_IRQ_PENDING_SW_RST_REQ_WIDTH		1
#define PSM_IOMODULE_IRQ_PENDING_SW_RST_REQ_MASK		((u32)0x04000000U)

#define PSM_IOMODULE_IRQ_PENDING_HW_BLK_RST_REQ_SHIFT	25
#define PSM_IOMODULE_IRQ_PENDING_HW_BLK_RST_REQ_WIDTH	1
#define PSM_IOMODULE_IRQ_PENDING_HW_BLK_RST_REQ_MASK	((u32)0x02000000U)

#define PSM_IOMODULE_IRQ_PENDING_ISO_REQ_SHIFT			24
#define PSM_IOMODULE_IRQ_PENDING_ISO_REQ_WIDTH			1
#define PSM_IOMODULE_IRQ_PENDING_ISO_REQ_MASK			((u32)0x01000000U)

#define PSM_IOMODULE_IRQ_PENDING_GICP_INT_SHIFT			22
#define PSM_IOMODULE_IRQ_PENDING_GICP_INT_WIDTH			1
#define PSM_IOMODULE_IRQ_PENDING_GICP_INT_MASK			((u32)0x00400000U)

#define PSM_IOMODULE_IRQ_PENDING_IPI_SHIFT				18
#define PSM_IOMODULE_IRQ_PENDING_IPI_WIDTH				1
#define PSM_IOMODULE_IRQ_PENDING_IPI_MASK				((u32)0x00040000U)

#define PSM_IOMODULE_IRQ_PENDING_PSM_RAM_ECC_ERR_SHIFT	16
#define PSM_IOMODULE_IRQ_PENDING_PSM_RAM_ECC_ERR_WIDTH	1
#define PSM_IOMODULE_IRQ_PENDING_PSM_RAM_ECC_ERR_MASK	((u32)0x00010000U)

#define PSM_IOMODULE_IRQ_PENDING_PIT4_SHIFT				6
#define PSM_IOMODULE_IRQ_PENDING_PIT4_WIDTH				1
#define PSM_IOMODULE_IRQ_PENDING_PIT4_MASK				((u32)0x00000040U)

#define PSM_IOMODULE_IRQ_PENDING_PIT3_SHIFT				5
#define PSM_IOMODULE_IRQ_PENDING_PIT3_WIDTH				1
#define PSM_IOMODULE_IRQ_PENDING_PIT3_MASK				((u32)0x00000020U)

#define PSM_IOMODULE_IRQ_PENDING_PIT2_SHIFT				4
#define PSM_IOMODULE_IRQ_PENDING_PIT2_WIDTH				1
#define PSM_IOMODULE_IRQ_PENDING_PIT2_MASK				((u32)0x00000010U)

#define PSM_IOMODULE_IRQ_PENDING_PIT1_SHIFT				3
#define PSM_IOMODULE_IRQ_PENDING_PIT1_WIDTH				1
#define PSM_IOMODULE_IRQ_PENDING_PIT1_MASK				((u32)0x00000008U)
/** @} */

#define PSM_IOMODULE_IRQ_ACK		((PSM_IOMODULE_BASEADDR) + ((u32)0x0000003CU)) /**< IO Module interrupt ack register */

/**
 * @name IOMODULE interrupt ack register operations
 * @ingroup iomodule
 * @{
 */
/**
 * IOMODULE interrupt ack register operation
 */
#define PSM_IOMODULE_IRQ_ACK_PWR_CNT_REQ_SHIFT			31
#define PSM_IOMODULE_IRQ_ACK_PWR_CNT_REQ_WIDTH			1
#define PSM_IOMODULE_IRQ_ACK_PWR_CNT_REQ_MASK			((u32)0x80000000U)

#define PSM_IOMODULE_IRQ_ACK_WAKE_UP_REQ_SHIFT			30
#define PSM_IOMODULE_IRQ_ACK_WAKE_UP_REQ_WIDTH			1
#define PSM_IOMODULE_IRQ_ACK_WAKE_UP_REQ_MASK			((u32)0x40000000U)

#define PSM_IOMODULE_IRQ_ACK_PSM_ERR_INT_SHIFT			29
#define PSM_IOMODULE_IRQ_ACK_PSM_ERR_INT_WIDTH			1
#define PSM_IOMODULE_IRQ_ACK_PSM_ERR_INT_MASK			((u32)0x20000000U)

#define PSM_IOMODULE_IRQ_ACK_PWR_DWN_REQ_SHIFT			28
#define PSM_IOMODULE_IRQ_ACK_PWR_DWN_REQ_WIDTH			1
#define PSM_IOMODULE_IRQ_ACK_PWR_DWN_REQ_MASK			((u32)0x10000000U)

#define PSM_IOMODULE_IRQ_ACK_PWR_UP_REQ_SHIFT			27
#define PSM_IOMODULE_IRQ_ACK_PWR_UP_REQ_WIDTH			1
#define PSM_IOMODULE_IRQ_ACK_PWR_UP_REQ_MASK			((u32)0x08000000U)

#define PSM_IOMODULE_IRQ_ACK_SW_RST_REQ_SHIFT			26
#define PSM_IOMODULE_IRQ_ACK_SW_RST_REQ_WIDTH			1
#define PSM_IOMODULE_IRQ_ACK_SW_RST_REQ_MASK			((u32)0x04000000U)

#define PSM_IOMODULE_IRQ_ACK_HW_BLK_RST_REQ_SHIFT		25
#define PSM_IOMODULE_IRQ_ACK_HW_BLK_RST_REQ_WIDTH		1
#define PSM_IOMODULE_IRQ_ACK_HW_BLK_RST_REQ_MASK		((u32)0x02000000U)

#define PSM_IOMODULE_IRQ_ACK_ISO_REQ_SHIFT				24
#define PSM_IOMODULE_IRQ_ACK_ISO_REQ_WIDTH				1
#define PSM_IOMODULE_IRQ_ACK_ISO_REQ_MASK				((u32)0x01000000U)

#define PSM_IOMODULE_IRQ_ACK_GICP_INT_SHIFT				22
#define PSM_IOMODULE_IRQ_ACK_GICP_INT_WIDTH				1
#define PSM_IOMODULE_IRQ_ACK_GICP_INT_MASK				((u32)0x00400000U)

#define PSM_IOMODULE_IRQ_ACK_IPI_SHIFT					18
#define PSM_IOMODULE_IRQ_ACK_IPI_WIDTH					1
#define PSM_IOMODULE_IRQ_ACK_IPI_MASK					((u32)0x00040000U)

#define PSM_IOMODULE_IRQ_ACK_PSM_RAM_ECC_ERR_SHIFT		16
#define PSM_IOMODULE_IRQ_ACK_PSM_RAM_ECC_ERR_WIDTH		1
#define PSM_IOMODULE_IRQ_ACK_PSM_RAM_ECC_ERR_MASK		((u32)0x00010000U)

#define PSM_IOMODULE_IRQ_ACK_PIT4_SHIFT					6
#define PSM_IOMODULE_IRQ_ACK_PIT4_WIDTH					1
#define PSM_IOMODULE_IRQ_ACK_PIT4_MASK					((u32)0x00000040U)

#define PSM_IOMODULE_IRQ_ACK_PIT3_SHIFT					5
#define PSM_IOMODULE_IRQ_ACK_PIT3_WIDTH					1
#define PSM_IOMODULE_IRQ_ACK_PIT3_MASK					((u32)0x00000020U)

#define PSM_IOMODULE_IRQ_ACK_PIT2_SHIFT					4
#define PSM_IOMODULE_IRQ_ACK_PIT2_WIDTH					1
#define PSM_IOMODULE_IRQ_ACK_PIT2_MASK					((u32)0x00000010U)

#define PSM_IOMODULE_IRQ_ACK_PIT1_SHIFT					3
#define PSM_IOMODULE_IRQ_ACK_PIT1_WIDTH					1
#define PSM_IOMODULE_IRQ_ACK_PIT1_MASK					((u32)0x00000008U)
/** @} */
/** @} */

/************************ Function Prototype ************************/
XStatus XPsmFw_IoModuleInit(u16 DeviceId);
XStatus SetUpInterruptSystem(void);

/******************************************************************************/
/**
*
* @brief	Disables the interrupt system
*
* @return	None
*
* @note		None
*
****************************************************************************/
void XPsmFw_DisableInterruptSystem(void);

/******************************************************************************/
/**
*
* @brief	Stops the I/O module
*
* @return	None
*
* @note		None
*
****************************************************************************/
void XPsmFw_StopIoModule(void);
void XPsmFw_IntrHandler(void *IntrNumber);
#ifdef PSM_ENABLE_STL
int XPsmFw_RegisterStlInterruptHandler(u8 InteruptNumber,
				       XInterruptHandler StlInterruptHandler);
int XPsmFw_RestoreInterruptHandler(u8 InteruptNumber);
#endif

#ifdef __cplusplus
}
#endif

#endif /* XPSMFW_IOMODULE_H_ */
