/******************************************************************************
* Copyright (c) 2022 Xilinx, Inc.  All rights reserved.
* Copyright (c) 2022-2025 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/
#ifndef XPARAMETERS_H   /* prevent circular inclusions */
#define XPARAMETERS_H   /* by using protection macros */

#ifdef __cplusplus
extern "C" {
#endif

#define XPAR_CPU_ID 4U

#define STDIN_BASEADDRESS 0xFF000000
#define STDOUT_BASEADDRESS 0xFF000000


/* Definitions for PMC Microblaze */
#define XPAR_MICROBLAZE_ADDR_SIZE 32
#define XPAR_MICROBLAZE_ADDR_TAG_BITS 0
#define XPAR_MICROBLAZE_ALLOW_DCACHE_WR 1
#define XPAR_MICROBLAZE_ALLOW_ICACHE_WR 1
#define XPAR_MICROBLAZE_AREA_OPTIMIZED 0
#define XPAR_MICROBLAZE_ASYNC_INTERRUPT 1
#define XPAR_MICROBLAZE_ASYNC_WAKEUP 3
#define XPAR_MICROBLAZE_AVOID_PRIMITIVES 0
#define XPAR_MICROBLAZE_BASE_VECTORS 0x00000000F0240000
#define XPAR_MICROBLAZE_BRANCH_TARGET_CACHE_SIZE 0
#define XPAR_MICROBLAZE_CACHE_BYTE_SIZE 8192
#define XPAR_MICROBLAZE_DADDR_SIZE 32
#define XPAR_MICROBLAZE_DATA_SIZE 32
#define XPAR_MICROBLAZE_DCACHE_ADDR_TAG 0
#define XPAR_MICROBLAZE_DCACHE_ALWAYS_USED 0
#define XPAR_MICROBLAZE_DCACHE_BASEADDR 0x00000000
#define XPAR_MICROBLAZE_DCACHE_BYTE_SIZE 8192
#define XPAR_MICROBLAZE_DCACHE_DATA_WIDTH 0
#define XPAR_MICROBLAZE_DCACHE_FORCE_TAG_LUTRAM 0
#define XPAR_MICROBLAZE_DCACHE_HIGHADDR 0x3FFFFFFF
#define XPAR_MICROBLAZE_DCACHE_LINE_LEN 4
#define XPAR_MICROBLAZE_DCACHE_USE_WRITEBACK 0
#define XPAR_MICROBLAZE_DCACHE_VICTIMS 0
#define XPAR_MICROBLAZE_DC_AXI_MON 0
#define XPAR_MICROBLAZE_DEBUG_COUNTER_WIDTH 32
#define XPAR_MICROBLAZE_DEBUG_ENABLED 1
#define XPAR_MICROBLAZE_DEBUG_EVENT_COUNTERS 5
#define XPAR_MICROBLAZE_DEBUG_EXTERNAL_TRACE 0
#define XPAR_MICROBLAZE_DEBUG_INTERFACE 0
#define XPAR_MICROBLAZE_DEBUG_LATENCY_COUNTERS 1
#define XPAR_MICROBLAZE_DEBUG_PROFILE_SIZE 0
#define XPAR_MICROBLAZE_DEBUG_TRACE_SIZE 8192
#define XPAR_MICROBLAZE_DIV_ZERO_EXCEPTION 1
#define XPAR_MICROBLAZE_DP_AXI_MON 0
#define XPAR_MICROBLAZE_DYNAMIC_BUS_SIZING 0
#define XPAR_MICROBLAZE_D_AXI 1
#define XPAR_MICROBLAZE_D_LMB 1
#define XPAR_MICROBLAZE_D_LMB_MON 0
#define XPAR_MICROBLAZE_ECC_USE_CE_EXCEPTION 0
#define XPAR_MICROBLAZE_EDGE_IS_POSITIVE 1
#define XPAR_MICROBLAZE_ENABLE_DISCRETE_PORTS 0
#define XPAR_MICROBLAZE_ENDIANNESS 1
#define XPAR_MICROBLAZE_FAULT_TOLERANT 1
#define XPAR_MICROBLAZE_FPU_EXCEPTION 0
#define XPAR_MICROBLAZE_FREQ 320000000
#define XPAR_MICROBLAZE_FSL_EXCEPTION 0
#define XPAR_MICROBLAZE_FSL_LINKS 0
#define XPAR_MICROBLAZE_IADDR_SIZE 32
#define XPAR_MICROBLAZE_ICACHE_ALWAYS_USED 0
#define XPAR_MICROBLAZE_ICACHE_BASEADDR 0x00000000
#define XPAR_MICROBLAZE_ICACHE_DATA_WIDTH 0
#define XPAR_MICROBLAZE_ICACHE_FORCE_TAG_LUTRAM 0
#define XPAR_MICROBLAZE_ICACHE_HIGHADDR 0x3FFFFFFF
#define XPAR_MICROBLAZE_ICACHE_LINE_LEN 4
#define XPAR_MICROBLAZE_ICACHE_STREAMS 0
#define XPAR_MICROBLAZE_ICACHE_VICTIMS 0
#define XPAR_MICROBLAZE_IC_AXI_MON 0
#define XPAR_MICROBLAZE_ILL_OPCODE_EXCEPTION 1
#define XPAR_MICROBLAZE_IMPRECISE_EXCEPTIONS 0
#define XPAR_MICROBLAZE_INSTR_SIZE 32
#define XPAR_MICROBLAZE_INTERCONNECT 2
#define XPAR_MICROBLAZE_INTERRUPT_IS_EDGE 0
#define XPAR_MICROBLAZE_INTERRUPT_MON 0
#define XPAR_MICROBLAZE_IP_AXI_MON 0
#define XPAR_MICROBLAZE_I_AXI 0
#define XPAR_MICROBLAZE_I_LMB 1
#define XPAR_MICROBLAZE_I_LMB_MON 0
#define XPAR_MICROBLAZE_LOCKSTEP_MASTER 0
#define XPAR_MICROBLAZE_LOCKSTEP_SELECT 0
#define XPAR_MICROBLAZE_LOCKSTEP_SLAVE 0
#define XPAR_MICROBLAZE_M0_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M0_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M1_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M1_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M2_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M2_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M3_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M3_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M4_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M4_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M5_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M5_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M6_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M6_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M7_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M7_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M8_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M8_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M9_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M9_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M10_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M10_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M11_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M11_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M12_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M12_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M13_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M13_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M14_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M14_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M15_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M15_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_MMU_DTLB_SIZE 4
#define XPAR_MICROBLAZE_MMU_ITLB_SIZE 2
#define XPAR_MICROBLAZE_MMU_PRIVILEGED_INSTR 0
#define XPAR_MICROBLAZE_MMU_TLB_ACCESS 3
#define XPAR_MICROBLAZE_MMU_ZONES 16
#define XPAR_MICROBLAZE_M_AXI_DC_ADDR_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_DC_ARUSER_WIDTH 5
#define XPAR_MICROBLAZE_M_AXI_DC_AWUSER_WIDTH 5
#define XPAR_MICROBLAZE_M_AXI_DC_BUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_DC_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_DC_EXCLUSIVE_ACCESS 0
#define XPAR_MICROBLAZE_M_AXI_DC_RUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_DC_THREAD_ID_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_DC_USER_SIGNALS 0
#define XPAR_MICROBLAZE_M_AXI_DC_USER_VALUE 31
#define XPAR_MICROBLAZE_M_AXI_DC_WUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_DP_ADDR_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_DP_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_DP_EXCLUSIVE_ACCESS 0
#define XPAR_MICROBLAZE_M_AXI_DP_THREAD_ID_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_D_BUS_EXCEPTION 1
#define XPAR_MICROBLAZE_M_AXI_IC_ADDR_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_IC_ARUSER_WIDTH 5
#define XPAR_MICROBLAZE_M_AXI_IC_AWUSER_WIDTH 5
#define XPAR_MICROBLAZE_M_AXI_IC_BUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_IC_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_IC_RUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_IC_THREAD_ID_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_IC_USER_SIGNALS 0
#define XPAR_MICROBLAZE_M_AXI_IC_USER_VALUE 31
#define XPAR_MICROBLAZE_M_AXI_IC_WUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_IP_ADDR_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_IP_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_IP_THREAD_ID_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_I_BUS_EXCEPTION 0
#define XPAR_MICROBLAZE_NUMBER_OF_PC_BRK 2
#define XPAR_MICROBLAZE_NUMBER_OF_RD_ADDR_BRK 1
#define XPAR_MICROBLAZE_NUMBER_OF_WR_ADDR_BRK 1
#define XPAR_MICROBLAZE_NUM_SYNC_FF_CLK 2
#define XPAR_MICROBLAZE_NUM_SYNC_FF_CLK_DEBUG 2
#define XPAR_MICROBLAZE_NUM_SYNC_FF_CLK_IRQ 1
#define XPAR_MICROBLAZE_NUM_SYNC_FF_DBG_CLK 1
#define XPAR_MICROBLAZE_OPCODE_0X0_ILLEGAL 1
#define XPAR_MICROBLAZE_OPTIMIZATION 0
#define XPAR_MICROBLAZE_PC_WIDTH 32
#define XPAR_MICROBLAZE_PVR 2
#define XPAR_MICROBLAZE_PVR_USER1 0x05
#define XPAR_MICROBLAZE_PVR_USER2 0x00000000
#define XPAR_MICROBLAZE_RESET_MSR 0x00000000
#define XPAR_MICROBLAZE_RESET_MSR_BIP 1
#define XPAR_MICROBLAZE_RESET_MSR_DCE 0
#define XPAR_MICROBLAZE_RESET_MSR_EE 0
#define XPAR_MICROBLAZE_RESET_MSR_EIP 0
#define XPAR_MICROBLAZE_RESET_MSR_ICE 0
#define XPAR_MICROBLAZE_RESET_MSR_IE 0
#define XPAR_MICROBLAZE_S0_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S0_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S1_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S1_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S2_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S2_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S3_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S3_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S4_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S4_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S5_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S5_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S6_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S6_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S7_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S7_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S8_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S8_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S9_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S9_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S10_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S10_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S11_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S11_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S12_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S12_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S13_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S13_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S14_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S14_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S15_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S15_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_SCO 0
#define XPAR_MICROBLAZE_TRACE 1
#define XPAR_MICROBLAZE_UNALIGNED_EXCEPTIONS 1
#define XPAR_MICROBLAZE_USE_BARREL 1
#define XPAR_MICROBLAZE_USE_BRANCH_TARGET_CACHE 0
#define XPAR_MICROBLAZE_USE_CONFIG_RESET 0
#define XPAR_MICROBLAZE_USE_DCACHE 0
#define XPAR_MICROBLAZE_USE_DIV 1
#define XPAR_MICROBLAZE_USE_EXTENDED_FSL_INSTR 0
#define XPAR_MICROBLAZE_USE_EXT_BRK 0
#define XPAR_MICROBLAZE_USE_EXT_NM_BRK 0
#define XPAR_MICROBLAZE_USE_FPU 0
#define XPAR_MICROBLAZE_USE_HW_MUL 2
#define XPAR_MICROBLAZE_USE_ICACHE 0
#define XPAR_MICROBLAZE_USE_INTERRUPT 1
#define XPAR_MICROBLAZE_USE_MMU 0
#define XPAR_MICROBLAZE_USE_MSR_INSTR 1
#define XPAR_MICROBLAZE_USE_NON_SECURE 0
#define XPAR_MICROBLAZE_USE_PCMP_INSTR 1
#define XPAR_MICROBLAZE_USE_REORDER_INSTR 1
#define XPAR_MICROBLAZE_USE_STACK_PROTECTION 1
#define XPAR_MICROBLAZE_EDK_IPTYPE PROCESSOR
#define XPAR_MICROBLAZE_EDK_SPECIAL microblaze
#define XPAR_MICROBLAZE_G_TEMPLATE_LIST 0
#define XPAR_MICROBLAZE_G_USE_EXCEPTIONS 1

/******************************************************************/

#define XPAR_CPU_CORE_CLOCK_FREQ_HZ XPAR_MICROBLAZE_FREQ

/******************************************************************/

 /* Definition for PSS REF CLK FREQUENCY */
#define XPAR_PSU_PSS_REF_CLK_FREQ_HZ 33333000U

/******************************************************************/

/* Platform specific definitions */
#define VERSAL_PLM
#ifndef versal
#define versal
#endif


/* Definitions for sleep timer configuration */
#define XSLEEP_TIMER_IS_DEFAULT_TIMER


/******************************************************************/
#define XPAR_CANFD_ISPS
/* Definitions for driver CANFD */
#define XPAR_XCANFD_NUM_INSTANCES 1U

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CANFD_1 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CANFD_1_DEVICE_ID 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CANFD_1_BASEADDR 0xFF070000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CANFD_1_HIGHADDR 0xFF07FFFFU
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CANFD_1_RX_MODE 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CANFD_1_NUM_OF_RX_MB_BUF 48U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CANFD_1_NUM_OF_TX_BUF 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CANFD_1_CAN_CLK_FREQ_HZ 99999901U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CANFD_1_IS_PL 0U

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CANFD_1 */
#define XPAR_CANFD_0_DEVICE_ID 0U
#define XPAR_CANFD_0_BASEADDR 0xFF070000U
#define XPAR_CANFD_0_HIGHADDR 0xFF07FFFFU
#define XPAR_CANFD_0_RX_MODE 0U
#define XPAR_CANFD_0_NUM_OF_RX_MB_BUF 48U
#define XPAR_CANFD_0_NUM_OF_TX_BUF 32U
#define XPAR_CANFD_0_CAN_CLK_FREQ_HZ 99999901U
#define XPAR_CANFD_0_IS_PL 0U

/******************************************************************/
/* Definitions for driver CFRAME */
#define XPAR_XCFRAME_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFI_CFRAME_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFI_CFRAME_0_DEVICE_ID 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFI_CFRAME_0_BASEADDR 0xF12D0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFI_CFRAME_0_HIGHADDR 0xF12D0FFF


/******************************************************************/

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFI_CFRAME_0 */
#define XPAR_XCFRAME_0_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFI_CFRAME_0_DEVICE_ID
#define XPAR_XCFRAME_0_BASEADDR 0xF12D0000
#define XPAR_XCFRAME_0_HIGHADDR 0xF12D0FFF


/******************************************************************/

/* Definitions for driver CFUPMC */
#define XPAR_XCFUPMC_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFU_APB_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFU_APB_0_DEVICE_ID 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFU_APB_0_BASEADDR 0xF12B0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFU_APB_0_HIGHADDR 0xF12BFFFF


/******************************************************************/

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFU_APB_0 */
#define XPAR_XCFUPMC_0_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFU_APB_0_DEVICE_ID
#define XPAR_XCFUPMC_0_BASEADDR 0xF12B0000
#define XPAR_XCFUPMC_0_HIGHADDR 0xF12BFFFF


/******************************************************************/

/* Definitions for driver CSUDMA */
#define XPAR_XCSUDMA_NUM_INSTANCES 2

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_0_DEVICE_ID 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_0_BASEADDR 0xF11C0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_0_HIGHADDR 0xF11CFFFF
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_0_CSUDMA_CLK_FREQ_HZ 0


/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_1 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_1_DEVICE_ID 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_1_BASEADDR 0xF11D0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_1_HIGHADDR 0xF11DFFFF
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_1_CSUDMA_CLK_FREQ_HZ 0


/******************************************************************/

#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_0_DMATYPE 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_1_DMATYPE 2
/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_0 */
#define XPAR_XCSUDMA_0_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_0_DEVICE_ID
#define XPAR_XCSUDMA_0_BASEADDR 0xF11C0000
#define XPAR_XCSUDMA_0_HIGHADDR 0xF11CFFFF
#define XPAR_XCSUDMA_0_CSUDMA_CLK_FREQ_HZ 0

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_1 */
#define XPAR_XCSUDMA_1_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_DMA_1_DEVICE_ID
#define XPAR_XCSUDMA_1_BASEADDR 0xF11D0000
#define XPAR_XCSUDMA_1_HIGHADDR 0xF11DFFFF
#define XPAR_XCSUDMA_1_CSUDMA_CLK_FREQ_HZ 0


/******************************************************************/


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_STM */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_STM_S_AXI_BASEADDR 0xF0B70000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_STM_S_AXI_HIGHADDR 0xF0B7FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CPM */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CPM_S_AXI_BASEADDR 0xFC000000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CPM_S_AXI_HIGHADDR 0xFCFFFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CRF_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CRF_0_S_AXI_BASEADDR 0xFD1A0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CRF_0_S_AXI_HIGHADDR 0xFD2DFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CRL_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CRL_0_S_AXI_BASEADDR 0xFF5E0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CRL_0_S_AXI_HIGHADDR 0xFF8DFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CRP_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CRP_0_S_AXI_BASEADDR 0xF1260000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CRP_0_S_AXI_HIGHADDR 0xF126FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_0_S_AXI_BASEADDR 0xFD360000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_0_S_AXI_HIGHADDR 0xFD36FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_2 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_2_S_AXI_BASEADDR 0xFD380000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_2_S_AXI_HIGHADDR 0xFD38FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_CCI_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_CCI_0_S_AXI_BASEADDR 0xFD5E0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_CCI_0_S_AXI_HIGHADDR 0xFD5EFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_GPV_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_GPV_0_S_AXI_BASEADDR 0xFD700000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_GPV_0_S_AXI_HIGHADDR 0xFD7FFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_MAINCCI_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_MAINCCI_0_S_AXI_BASEADDR 0xFD000000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_MAINCCI_0_S_AXI_HIGHADDR 0xFD0FFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLAVE_XMPU_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLAVE_XMPU_0_S_AXI_BASEADDR 0xFD390000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLAVE_XMPU_0_S_AXI_HIGHADDR 0xFD39FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_0_S_AXI_BASEADDR 0xFD610000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_0_S_AXI_HIGHADDR 0xFD61FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_SECURE_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_SECURE_0_S_AXI_BASEADDR 0xFD690000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_SECURE_0_S_AXI_HIGHADDR 0xFD69FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SMMU_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SMMU_0_S_AXI_BASEADDR 0xFD5F0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SMMU_0_S_AXI_HIGHADDR 0xFD5FFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SMMUTCU_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SMMUTCU_0_S_AXI_BASEADDR 0xFD800000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SMMUTCU_0_S_AXI_HIGHADDR 0xFDFFFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_AFI_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_AFI_0_S_AXI_BASEADDR 0xFF9B0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_AFI_0_S_AXI_HIGHADDR 0xFF9BFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SECURE_SLCR_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SECURE_SLCR_0_S_AXI_BASEADDR 0xFF0A0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SECURE_SLCR_0_S_AXI_HIGHADDR 0xFF0AFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SLCR_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SLCR_0_S_AXI_BASEADDR 0xFF080000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SLCR_0_S_AXI_HIGHADDR 0xFF09FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_0_S_AXI_BASEADDR 0xFF410000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_0_S_AXI_HIGHADDR 0xFF50FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_SECURE_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_SECURE_0_S_AXI_BASEADDR 0xFF510000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_SECURE_0_S_AXI_HIGHADDR 0xFF54FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_XPPU_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_XPPU_0_S_AXI_BASEADDR 0xFF990000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_XPPU_0_S_AXI_HIGHADDR 0xFF99FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_OCM_CTRL */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_OCM_CTRL_S_AXI_BASEADDR 0xFF960000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_OCM_CTRL_S_AXI_HIGHADDR 0xFF96FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_OCM_RAM_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_OCM_RAM_0_S_AXI_BASEADDR 0xFFFC0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_OCM_RAM_0_S_AXI_HIGHADDR 0xFFFFFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_OCM_XMPU_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_OCM_XMPU_0_S_AXI_BASEADDR 0xFF980000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_OCM_XMPU_0_S_AXI_HIGHADDR 0xFF98FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_AES */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_AES_S_AXI_BASEADDR 0xF11E0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_AES_S_AXI_HIGHADDR 0xF11EFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_BBRAM_CTRL */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_BBRAM_CTRL_S_AXI_BASEADDR 0xF11F0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_BBRAM_CTRL_S_AXI_HIGHADDR 0xF11FFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CACHE */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CACHE_S_AXI_BASEADDR 0xF1250000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CACHE_S_AXI_HIGHADDR 0xF125FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CTRL */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CTRL_S_AXI_BASEADDR 0xF1240000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CTRL_S_AXI_HIGHADDR 0xF124FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GLOBAL_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GLOBAL_0_S_AXI_BASEADDR 0xF1110000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GLOBAL_0_S_AXI_HIGHADDR 0xF115FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_OSPI_FLASH_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_OSPI_FLASH_0_S_AXI_BASEADDR 0xC0000000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_OSPI_FLASH_0_S_AXI_HIGHADDR 0xDFFFFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_S_AXI_BASEADDR 0xF2000000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_S_AXI_HIGHADDR 0xF201FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_DATA_CNTLR */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_DATA_CNTLR_S_AXI_BASEADDR 0xF0240000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_DATA_CNTLR_S_AXI_HIGHADDR 0xF025FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_INSTR_CNTLR */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_INSTR_CNTLR_S_AXI_BASEADDR 0xF0200000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_INSTR_CNTLR_S_AXI_HIGHADDR 0xF023FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_NPI */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_NPI_S_AXI_BASEADDR 0xF6000000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_NPI_S_AXI_HIGHADDR 0xF7FFFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RSA */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RSA_S_AXI_BASEADDR 0xF1200000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RSA_S_AXI_HIGHADDR 0xF120FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SHA */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SHA_S_AXI_BASEADDR 0xF1210000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SHA_S_AXI_HIGHADDR 0xF121FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_XMPU_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_XMPU_0_S_AXI_BASEADDR 0xF12F0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_XMPU_0_S_AXI_HIGHADDR 0xF12FFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_XPPU_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_XPPU_0_S_AXI_BASEADDR 0xF1310000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_XPPU_0_S_AXI_HIGHADDR 0xF131FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_XPPU_NPI_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_XPPU_NPI_0_S_AXI_BASEADDR 0xF1300000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_XPPU_NPI_0_S_AXI_HIGHADDR 0xF130FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_GLOBAL_REG */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_GLOBAL_REG_S_AXI_BASEADDR 0xFFC90000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_GLOBAL_REG_S_AXI_HIGHADDR 0xFFC9EFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_R5_1_ATCM_GLOBAL */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_R5_1_ATCM_GLOBAL_S_AXI_BASEADDR 0xFFE90000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_R5_1_ATCM_GLOBAL_S_AXI_HIGHADDR 0xFFE9FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_R5_1_BTCM_GLOBAL */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_R5_1_BTCM_GLOBAL_S_AXI_BASEADDR 0xFFEB0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_R5_1_BTCM_GLOBAL_S_AXI_HIGHADDR 0xFFEBFFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_R5_TCM_RAM_GLOBAL */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_R5_TCM_RAM_GLOBAL_S_AXI_BASEADDR 0xFFE00000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_R5_TCM_RAM_GLOBAL_S_AXI_HIGHADDR 0xFFE3FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_SCNTR_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SCNTR_0_S_AXI_BASEADDR 0xFF130000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SCNTR_0_S_AXI_HIGHADDR 0xFF13FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_SCNTRS_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SCNTRS_0_S_AXI_BASEADDR 0xFF140000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SCNTRS_0_S_AXI_HIGHADDR 0xFF14FFFF


/* Peripheral Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_USB_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_USB_0_S_AXI_BASEADDR 0xFF9D0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_USB_0_S_AXI_HIGHADDR 0xFF9DFFFF


/******************************************************************/


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_STM */
#define XPAR_PSV_CORESIGHT_FPD_STM_0_S_AXI_BASEADDR 0xF0B70000
#define XPAR_PSV_CORESIGHT_FPD_STM_0_S_AXI_HIGHADDR 0xF0B7FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CPM */
#define XPAR_PSV_CPM_0_S_AXI_BASEADDR 0xFC000000
#define XPAR_PSV_CPM_0_S_AXI_HIGHADDR 0xFCFFFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CRF_0 */
#define XPAR_PSV_CRF_0_S_AXI_BASEADDR 0xFD1A0000
#define XPAR_PSV_CRF_0_S_AXI_HIGHADDR 0xFD2DFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CRL_0 */
#define XPAR_PSV_CRL_0_S_AXI_BASEADDR 0xFF5E0000
#define XPAR_PSV_CRL_0_S_AXI_HIGHADDR 0xFF8DFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CRP_0 */
#define XPAR_PSV_CRP_0_S_AXI_BASEADDR 0xF1260000
#define XPAR_PSV_CRP_0_S_AXI_HIGHADDR 0xF126FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_0 */
#define XPAR_PSV_FPD_AFI_0_S_AXI_BASEADDR 0xFD360000
#define XPAR_PSV_FPD_AFI_0_S_AXI_HIGHADDR 0xFD36FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_2 */
#define XPAR_PSV_FPD_AFI_1_S_AXI_BASEADDR 0xFD380000
#define XPAR_PSV_FPD_AFI_1_S_AXI_HIGHADDR 0xFD38FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_CCI_0 */
#define XPAR_PSV_FPD_CCI_0_S_AXI_BASEADDR 0xFD5E0000
#define XPAR_PSV_FPD_CCI_0_S_AXI_HIGHADDR 0xFD5EFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_GPV_0 */
#define XPAR_PSV_FPD_GPV_0_S_AXI_BASEADDR 0xFD700000
#define XPAR_PSV_FPD_GPV_0_S_AXI_HIGHADDR 0xFD7FFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_MAINCCI_0 */
#define XPAR_PSV_FPD_MAINCCI_0_S_AXI_BASEADDR 0xFD000000
#define XPAR_PSV_FPD_MAINCCI_0_S_AXI_HIGHADDR 0xFD0FFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLAVE_XMPU_0 */
#define XPAR_PSV_FPD_SLAVE_XMPU_0_S_AXI_BASEADDR 0xFD390000
#define XPAR_PSV_FPD_SLAVE_XMPU_0_S_AXI_HIGHADDR 0xFD39FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_0 */
#define XPAR_PSV_FPD_SLCR_0_S_AXI_BASEADDR 0xFD610000
#define XPAR_PSV_FPD_SLCR_0_S_AXI_HIGHADDR 0xFD61FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_SECURE_0 */
#define XPAR_PSV_FPD_SLCR_SECURE_0_S_AXI_BASEADDR 0xFD690000
#define XPAR_PSV_FPD_SLCR_SECURE_0_S_AXI_HIGHADDR 0xFD69FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SMMU_0 */
#define XPAR_PSV_FPD_SMMU_0_S_AXI_BASEADDR 0xFD5F0000
#define XPAR_PSV_FPD_SMMU_0_S_AXI_HIGHADDR 0xFD5FFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SMMUTCU_0 */
#define XPAR_PSV_FPD_SMMUTCU_0_S_AXI_BASEADDR 0xFD800000
#define XPAR_PSV_FPD_SMMUTCU_0_S_AXI_HIGHADDR 0xFDFFFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_AFI_0 */
#define XPAR_PSV_LPD_AFI_0_S_AXI_BASEADDR 0xFF9B0000
#define XPAR_PSV_LPD_AFI_0_S_AXI_HIGHADDR 0xFF9BFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SECURE_SLCR_0 */
#define XPAR_PSV_LPD_IOU_SECURE_SLCR_0_S_AXI_BASEADDR 0xFF0A0000
#define XPAR_PSV_LPD_IOU_SECURE_SLCR_0_S_AXI_HIGHADDR 0xFF0AFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SLCR_0 */
#define XPAR_PSV_LPD_IOU_SLCR_0_S_AXI_BASEADDR 0xFF080000
#define XPAR_PSV_LPD_IOU_SLCR_0_S_AXI_HIGHADDR 0xFF09FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_0 */
#define XPAR_PSV_LPD_SLCR_0_S_AXI_BASEADDR 0xFF410000
#define XPAR_PSV_LPD_SLCR_0_S_AXI_HIGHADDR 0xFF50FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_SECURE_0 */
#define XPAR_PSV_LPD_SLCR_SECURE_0_S_AXI_BASEADDR 0xFF510000
#define XPAR_PSV_LPD_SLCR_SECURE_0_S_AXI_HIGHADDR 0xFF54FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_XPPU_0 */
#define XPAR_PSV_LPD_XPPU_0_S_AXI_BASEADDR 0xFF990000
#define XPAR_PSV_LPD_XPPU_0_S_AXI_HIGHADDR 0xFF99FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_OCM_CTRL */
#define XPAR_PSV_OCM_0_S_AXI_BASEADDR 0xFF960000
#define XPAR_PSV_OCM_0_S_AXI_HIGHADDR 0xFF96FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_OCM_RAM_0 */
#define XPAR_PSV_OCM_RAM_0_S_AXI_BASEADDR 0xFFFC0000
#define XPAR_PSV_OCM_RAM_0_S_AXI_HIGHADDR 0xFFFFFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_OCM_XMPU_0 */
#define XPAR_PSV_OCM_XMPU_0_S_AXI_BASEADDR 0xFF980000
#define XPAR_PSV_OCM_XMPU_0_S_AXI_HIGHADDR 0xFF98FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_AES */
#define XPAR_PSV_PMC_AES_0_S_AXI_BASEADDR 0xF11E0000
#define XPAR_PSV_PMC_AES_0_S_AXI_HIGHADDR 0xF11EFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_BBRAM_CTRL */
#define XPAR_PSV_PMC_BBRAM_CTRL_0_S_AXI_BASEADDR 0xF11F0000
#define XPAR_PSV_PMC_BBRAM_CTRL_0_S_AXI_HIGHADDR 0xF11FFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CACHE */
#define XPAR_PSV_PMC_EFUSE_CACHE_0_S_AXI_BASEADDR 0xF1250000
#define XPAR_PSV_PMC_EFUSE_CACHE_0_S_AXI_HIGHADDR 0xF125FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CTRL */
#define XPAR_PSV_PMC_EFUSE_CTRL_0_S_AXI_BASEADDR 0xF1240000
#define XPAR_PSV_PMC_EFUSE_CTRL_0_S_AXI_HIGHADDR 0xF124FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GLOBAL_0 */
#define XPAR_PSV_PMC_GLOBAL_0_S_AXI_BASEADDR 0xF1110000
#define XPAR_PSV_PMC_GLOBAL_0_S_AXI_HIGHADDR 0xF115FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_OSPI_FLASH_0 */
#define XPAR_PSV_PMC_QSPI_OSPI_0_S_AXI_BASEADDR 0xC0000000
#define XPAR_PSV_PMC_QSPI_OSPI_0_S_AXI_HIGHADDR 0xDFFFFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM */
#define XPAR_PSV_PMC_RAM_0_S_AXI_BASEADDR 0xF2000000
#define XPAR_PSV_PMC_RAM_0_S_AXI_HIGHADDR 0xF201FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_DATA_CNTLR */
#define XPAR_RAM_DATA_CNTLR_0_S_AXI_BASEADDR 0xF0240000
#define XPAR_RAM_DATA_CNTLR_0_S_AXI_HIGHADDR 0xF025FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_INSTR_CNTLR */
#define XPAR_RAM_INSTR_CNTLR_0_S_AXI_BASEADDR 0xF0200000
#define XPAR_RAM_INSTR_CNTLR_0_S_AXI_HIGHADDR 0xF023FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_NPI */
#define XPAR_PSV_PMC_RAM_NPI_0_S_AXI_BASEADDR 0xF6000000
#define XPAR_PSV_PMC_RAM_NPI_0_S_AXI_HIGHADDR 0xF7FFFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RSA */
#define XPAR_PSV_PMC_RSA_0_S_AXI_BASEADDR 0xF1200000
#define XPAR_PSV_PMC_RSA_0_S_AXI_HIGHADDR 0xF120FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SHA */
#define XPAR_PSV_PMC_SHA_0_S_AXI_BASEADDR 0xF1210000
#define XPAR_PSV_PMC_SHA_0_S_AXI_HIGHADDR 0xF121FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_XMPU_0 */
#define XPAR_PSV_PMC_XMPU_0_S_AXI_BASEADDR 0xF12F0000
#define XPAR_PSV_PMC_XMPU_0_S_AXI_HIGHADDR 0xF12FFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_XPPU_0 */
#define XPAR_PSV_PMC_XPPU_0_S_AXI_BASEADDR 0xF1310000
#define XPAR_PSV_PMC_XPPU_0_S_AXI_HIGHADDR 0xF131FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_XPPU_NPI_0 */
#define XPAR_PSV_PMC_XPPU_NPI_0_S_AXI_BASEADDR 0xF1300000
#define XPAR_PSV_PMC_XPPU_NPI_0_S_AXI_HIGHADDR 0xF130FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_GLOBAL_REG */
#define XPAR_PSV_PSM_GLOBAL_REG_0_S_AXI_BASEADDR 0xFFC90000
#define XPAR_PSV_PSM_GLOBAL_REG_0_S_AXI_HIGHADDR 0xFFC9EFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_R5_1_ATCM_GLOBAL */
#define XPAR_PSV_TCM_GLOBAL_0_S_AXI_BASEADDR 0xFFE90000
#define XPAR_PSV_TCM_GLOBAL_0_S_AXI_HIGHADDR 0xFFE9FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_R5_1_BTCM_GLOBAL */
#define XPAR_PSV_TCM_GLOBAL_1_S_AXI_BASEADDR 0xFFEB0000
#define XPAR_PSV_TCM_GLOBAL_1_S_AXI_HIGHADDR 0xFFEBFFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_R5_TCM_RAM_GLOBAL */
#define XPAR_PSV_R5_TCM_0_S_AXI_BASEADDR 0xFFE00000
#define XPAR_PSV_R5_TCM_0_S_AXI_HIGHADDR 0xFFE3FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_SCNTR_0 */
#define XPAR_PSV_SCNTR_0_S_AXI_BASEADDR 0xFF130000
#define XPAR_PSV_SCNTR_0_S_AXI_HIGHADDR 0xFF13FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_SCNTRS_0 */
#define XPAR_PSV_SCNTRS_0_S_AXI_BASEADDR 0xFF140000
#define XPAR_PSV_SCNTRS_0_S_AXI_HIGHADDR 0xFF14FFFF


/* Canonical Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_USB_0 */
#define XPAR_PSV_USB_0_S_AXI_BASEADDR 0xFF9D0000
#define XPAR_PSV_USB_0_S_AXI_HIGHADDR 0xFF9DFFFF


/******************************************************************/

/* Definitions for driver GPIOPS */
#define XPAR_XGPIOPS_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GPIO_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GPIO_0_DEVICE_ID 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GPIO_0_BASEADDR 0xF1020000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GPIO_0_HIGHADDR 0xF102FFFF


/******************************************************************/

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GPIO_0 */
#define XPAR_XGPIOPS_0_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GPIO_0_DEVICE_ID
#define XPAR_XGPIOPS_0_BASEADDR 0xF1020000
#define XPAR_XGPIOPS_0_HIGHADDR 0xF102FFFF


/******************************************************************/

/* Definitions for driver IICPS */
#define XPAR_XIICPS_NUM_INSTANCES 2

/* Definitions for peripheral CIPS_0_PSPMC_0_PSV_I2C_1 */
#define XPAR_CIPS_0_PSPMC_0_PSV_I2C_1_DEVICE_ID 0
#define XPAR_CIPS_0_PSPMC_0_PSV_I2C_1_BASEADDR 0xFF030000
#define XPAR_CIPS_0_PSPMC_0_PSV_I2C_1_HIGHADDR 0xFF03FFFF
#define XPAR_CIPS_0_PSPMC_0_PSV_I2C_1_I2C_CLK_FREQ_HZ 100000000


/* Definitions for peripheral CIPS_0_PSPMC_0_PSV_PMC_I2C_0 */
#define XPAR_CIPS_0_PSPMC_0_PSV_PMC_I2C_0_DEVICE_ID 1
#define XPAR_CIPS_0_PSPMC_0_PSV_PMC_I2C_0_BASEADDR 0xF1000000
#define XPAR_CIPS_0_PSPMC_0_PSV_PMC_I2C_0_HIGHADDR 0xF100FFFF
#define XPAR_CIPS_0_PSPMC_0_PSV_PMC_I2C_0_I2C_CLK_FREQ_HZ 100000000


/******************************************************************/

/* Canonical definitions for peripheral CIPS_0_PSPMC_0_PSV_I2C_1 */
#define XPAR_XIICPS_0_DEVICE_ID XPAR_CIPS_0_PSPMC_0_PSV_I2C_1_DEVICE_ID
#define XPAR_XIICPS_0_BASEADDR 0xFF030000
#define XPAR_XIICPS_0_HIGHADDR 0xFF03FFFF
#define XPAR_XIICPS_0_I2C_CLK_FREQ_HZ 100000000

/* Canonical definitions for peripheral CIPS_0_PSPMC_0_PSV_PMC_I2C_0 */
#define XPAR_XIICPS_1_DEVICE_ID XPAR_CIPS_0_PSPMC_0_PSV_PMC_I2C_0_DEVICE_ID
#define XPAR_XIICPS_1_BASEADDR 0xF1000000
#define XPAR_XIICPS_1_HIGHADDR 0xF100FFFF
#define XPAR_XIICPS_1_I2C_CLK_FREQ_HZ 100000000

/******************************************************************/

/* Definition for input Clock */
/* Definition for input Clock */
/* Definitions for driver IOMODULE */
#define XPAR_XIOMODULE_NUM_INSTANCES 1U

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_DEVICE_ID 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_BASEADDR 0xF0280000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_HIGHADDR 0xF0280FFFU
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_MASK 0x00000000FFFFF000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_FREQ 100000000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_UART_RX 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_UART_TX 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_UART_BAUDRATE 115200U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_UART_PROG_BAUDRATE 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_UART_DATA_BITS 8U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_UART_USE_PARITY 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_UART_ODD_PARITY 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_UART_RX_INTERRUPT 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_UART_TX_INTERRUPT 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_UART_ERROR_INTERRUPT 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_FIT1 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_FIT1_NO_CLOCKS 6216U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_FIT1_INTERRUPT 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_FIT2 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_FIT2_NO_CLOCKS 6216U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_FIT2_INTERRUPT 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_FIT3 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_FIT3_NO_CLOCKS 6216U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_FIT3_INTERRUPT 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_FIT4 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_FIT4_NO_CLOCKS 6216U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_FIT4_INTERRUPT 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_PIT1 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT1_SIZE 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT1_EXPIRED_MASK 0xFFFFFFFFU
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT1_READABLE 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT1_PRESCALER 9U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT1_INTERRUPT 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_PIT2 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT2_SIZE 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT2_EXPIRED_MASK 0xFFFFFFFFU
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT2_READABLE 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT2_PRESCALER 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT2_INTERRUPT 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_PIT3 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT3_SIZE 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT3_EXPIRED_MASK 0xFFFFFFFFU
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT3_READABLE 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT3_PRESCALER 9U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT3_INTERRUPT 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_PIT4 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT4_SIZE 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT4_EXPIRED_MASK 0xFFFFFFFFU
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT4_READABLE 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT4_PRESCALER 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_PIT4_INTERRUPT 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_GPO1 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPO1_SIZE 3U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_GPO2 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPO2_SIZE 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_GPO3 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPO3_SIZE 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_GPO4 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPO4_SIZE 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_GPI1 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPI1_SIZE 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPI1_INTERRUPT 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_GPI2 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPI2_SIZE 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPI2_INTERRUPT 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_GPI3 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPI3_SIZE 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPI3_INTERRUPT 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_GPI4 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPI4_SIZE 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPI4_INTERRUPT 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_INTC_USE_EXT_INTR 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_INTC_INTR_SIZE 16U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_INTC_HAS_FAST 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_INTC_BASE_VECTORS 0xF0240000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_INTC_ADDR_WIDTH 32U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_ 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_USE_IO_BUS 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_IO_BASEADDR 0xFFFFFFFFFFFFFFFFU
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_IO_HIGHADDR 0x00000000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_IO_MASK 0x00000000FFFE0000U


/******************************************************************/


/* Additional definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPO1_INIT 0x00000000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPO2_INIT 0x00000000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPO3_INIT 0x00000000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_GPO4_INIT 0x00000000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_INTC_LEVEL_EDGE 0x0000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_INTC_POSITIVE 0xFFFFU


/******************************************************************/

#define XPAR_IOMODULE_SINGLE_BASEADDR 0xF0280000
#define XPAR_IOMODULE_SINGLE_HIGHADDR 0xF0280FFF
#define XPAR_IOMODULE_INTC_SINGLE_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0_DEVICE_ID
#define XPAR_IOMODULE_INTC_MAX_INTR_SIZE 32U

/******************************************************************/


/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_IOMODULE_0 */
#define XPAR_IOMODULE_0_NUM_INSTANCES 0U
#define XPAR_IOMODULE_0_DEVICE_ID 0U
#define XPAR_IOMODULE_0_BASEADDR 0xF0280000U
#define XPAR_IOMODULE_0_HIGHADDR 0xF0280FFFU
#define XPAR_IOMODULE_0_MASK 0x00000000FFFFF000U
#define XPAR_IOMODULE_0_FREQ 100000000U
#define XPAR_IOMODULE_0_USE_UART_RX 1U
#define XPAR_IOMODULE_0_USE_UART_TX 1U
#define XPAR_IOMODULE_0_UART_BAUDRATE 115200U
#define XPAR_IOMODULE_0_UART_PROG_BAUDRATE 1U
#define XPAR_IOMODULE_0_UART_DATA_BITS 8U
#define XPAR_IOMODULE_0_UART_USE_PARITY 0U
#define XPAR_IOMODULE_0_UART_ODD_PARITY 0U
#define XPAR_IOMODULE_0_UART_RX_INTERRUPT 1U
#define XPAR_IOMODULE_0_UART_TX_INTERRUPT 1U
#define XPAR_IOMODULE_0_UART_ERROR_INTERRUPT 1U
#define XPAR_IOMODULE_0_USE_FIT1 0U
#define XPAR_IOMODULE_0_FIT1_NO_CLOCKS 6216U
#define XPAR_IOMODULE_0_FIT1_INTERRUPT 0U
#define XPAR_IOMODULE_0_USE_FIT2 0U
#define XPAR_IOMODULE_0_FIT2_NO_CLOCKS 6216U
#define XPAR_IOMODULE_0_FIT2_INTERRUPT 0U
#define XPAR_IOMODULE_0_USE_FIT3 0U
#define XPAR_IOMODULE_0_FIT3_NO_CLOCKS 6216U
#define XPAR_IOMODULE_0_FIT3_INTERRUPT 0U
#define XPAR_IOMODULE_0_USE_FIT4 0U
#define XPAR_IOMODULE_0_FIT4_NO_CLOCKS 6216U
#define XPAR_IOMODULE_0_FIT4_INTERRUPT 0U
#define XPAR_IOMODULE_0_USE_PIT1 1U
#define XPAR_IOMODULE_0_PIT1_SIZE 32U
#define XPAR_IOMODULE_0_PIT1_EXPIRED_MASK 0xFFFFFFFFU
#define XPAR_IOMODULE_0_PIT1_READABLE 1U
#define XPAR_IOMODULE_0_PIT1_PRESCALER 9U
#define XPAR_IOMODULE_0_PIT1_INTERRUPT 1U
#define XPAR_IOMODULE_0_USE_PIT2 1U
#define XPAR_IOMODULE_0_PIT2_SIZE 32U
#define XPAR_IOMODULE_0_PIT2_EXPIRED_MASK 0xFFFFFFFFU
#define XPAR_IOMODULE_0_PIT2_READABLE 1U
#define XPAR_IOMODULE_0_PIT2_PRESCALER 0U
#define XPAR_IOMODULE_0_PIT2_INTERRUPT 1U
#define XPAR_IOMODULE_0_USE_PIT3 1U
#define XPAR_IOMODULE_0_PIT3_SIZE 32U
#define XPAR_IOMODULE_0_PIT3_EXPIRED_MASK 0xFFFFFFFFU
#define XPAR_IOMODULE_0_PIT3_READABLE 1U
#define XPAR_IOMODULE_0_PIT3_PRESCALER 9U
#define XPAR_IOMODULE_0_PIT3_INTERRUPT 1U
#define XPAR_IOMODULE_0_USE_PIT4 1U
#define XPAR_IOMODULE_0_PIT4_SIZE 32U
#define XPAR_IOMODULE_0_PIT4_EXPIRED_MASK 0xFFFFFFFFU
#define XPAR_IOMODULE_0_PIT4_READABLE 1U
#define XPAR_IOMODULE_0_PIT4_PRESCALER 0U
#define XPAR_IOMODULE_0_PIT4_INTERRUPT 1U
#define XPAR_IOMODULE_0_USE_GPO1 1U
#define XPAR_IOMODULE_0_GPO1_SIZE 3U
#define XPAR_IOMODULE_0_USE_GPO2 0U
#define XPAR_IOMODULE_0_GPO2_SIZE 32U
#define XPAR_IOMODULE_0_USE_GPO3 0U
#define XPAR_IOMODULE_0_GPO3_SIZE 32U
#define XPAR_IOMODULE_0_USE_GPO4 0U
#define XPAR_IOMODULE_0_GPO4_SIZE 32U
#define XPAR_IOMODULE_0_USE_GPI1 0U
#define XPAR_IOMODULE_0_GPI1_SIZE 32U
#define XPAR_IOMODULE_0_GPI1_INTERRUPT 0U
#define XPAR_IOMODULE_0_USE_GPI2 0U
#define XPAR_IOMODULE_0_GPI2_SIZE 32U
#define XPAR_IOMODULE_0_GPI2_INTERRUPT 0U
#define XPAR_IOMODULE_0_USE_GPI3 0U
#define XPAR_IOMODULE_0_GPI3_SIZE 32U
#define XPAR_IOMODULE_0_GPI3_INTERRUPT 0U
#define XPAR_IOMODULE_0_USE_GPI4 0U
#define XPAR_IOMODULE_0_GPI4_SIZE 32U
#define XPAR_IOMODULE_0_GPI4_INTERRUPT 0U
#define XPAR_IOMODULE_0_INTC_USE_EXT_INTR 1U
#define XPAR_IOMODULE_0_INTC_INTR_SIZE 16U
#define XPAR_IOMODULE_0_INTC_HAS_FAST 0U
#define XPAR_IOMODULE_0_INTC_BASE_VECTORS 0xF0240000U
#define XPAR_IOMODULE_0_INTC_ADDR_WIDTH 32U
#define XPAR_IOMODULE_0_ 0U
#define XPAR_IOMODULE_0_USE_IO_BUS 0U
#define XPAR_IOMODULE_0_IO_BASEADDR 0xFFFFFFFFFFFFFFFFU
#define XPAR_IOMODULE_0_IO_HIGHADDR 0x00000000U
#define XPAR_IOMODULE_0_IO_MASK 0x00000000FFFE0000U
#define XPAR_IOMODULE_0_GPO1_INIT 0x00000000U
#define XPAR_IOMODULE_0_GPO2_INIT 0x00000000U
#define XPAR_IOMODULE_0_GPO3_INIT 0x00000000U
#define XPAR_IOMODULE_0_GPO4_INIT 0x00000000U
#define XPAR_IOMODULE_0_INTC_LEVEL_EDGE 0x0000U
#define XPAR_IOMODULE_0_INTC_POSITIVE 0xFFFFU


/******************************************************************/
/******************************************************************/

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_ATM */
#define XPAR_XPMONPSV_0_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_ATM_DEVICE_ID
#define XPAR_XPMONPSV_0_S_AXI_BASEADDR 0xF0B80000

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_LPD_ATM */
#define XPAR_XPMONPSV_1_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_LPD_ATM_DEVICE_ID
#define XPAR_XPMONPSV_1_S_AXI_BASEADDR 0xF0980000


/******************************************************************/

/* Definitions for driver QSPIPSU */
#define XPAR_XQSPIPSU_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_0_DEVICE_ID 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_0_BASEADDR 0xF1030000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_0_HIGHADDR 0xF103FFFF
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_0_QSPI_CLK_FREQ_HZ 295833038
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_0_QSPI_MODE 2
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_0_QSPI_BUS_WIDTH 2


/******************************************************************/

#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_0_IS_CACHE_COHERENT 0
/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_0 */
#define XPAR_XQSPIPSU_0_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_QSPI_0_DEVICE_ID
#define XPAR_XQSPIPSU_0_BASEADDR 0xF1030000
#define XPAR_XQSPIPSU_0_HIGHADDR 0xF103FFFF
#define XPAR_XQSPIPSU_0_QSPI_CLK_FREQ_HZ 295833038
#define XPAR_XQSPIPSU_0_QSPI_MODE 2
#define XPAR_XQSPIPSU_0_QSPI_BUS_WIDTH 2
#define XPAR_XQSPIPSU_0_IS_CACHE_COHERENT 0

/* Definitions for driver OSPIPSV */
#define XPAR_XOSPIPSV_NUM_INSTANCES 1

/* Definitions for peripheral CIPS_0_PSPMC_0_PSV_PMC_OSPI_0 */
#define XPAR_CIPS_0_PSPMC_0_PSV_PMC_OSPI_0_DEVICE_ID 0
#define XPAR_CIPS_0_PSPMC_0_PSV_PMC_OSPI_0_BASEADDR 0xF1010000
#define XPAR_CIPS_0_PSPMC_0_PSV_PMC_OSPI_0_HIGHADDR 0xF101FFFF
#define XPAR_CIPS_0_PSPMC_0_PSV_PMC_OSPI_0_OSPI_CLK_FREQ_HZ 199999802
#define XPAR_CIPS_0_PSPMC_0_PSV_PMC_OSPI_0_OSPI_MODE 0


/******************************************************************/

#define XPAR_CIPS_0_PSPMC_0_PSV_PMC_OSPI_0_IS_CACHE_COHERENT 0
/* Canonical definitions for peripheral CIPS_0_PSPMC_0_PSV_PMC_OSPI_0 */
#define XPAR_XOSPIPSV_0_DEVICE_ID XPAR_CIPS_0_PSPMC_0_PSV_PMC_OSPI_0_DEVICE_ID
#define XPAR_XOSPIPSV_0_BASEADDR 0xF1010000
#define XPAR_XOSPIPSV_0_HIGHADDR 0xF101FFFF
#define XPAR_XOSPIPSV_0_OSPI_CLK_FREQ_HZ 199999802
#define XPAR_XOSPIPSV_0_IS_CACHE_COHERENT 0
#define XPAR_XOSPIPSV_0_OSPI_MODE 0

/******************************************************************/

#define XPAR_XSYSMONPSV_NUM_INSTANCES 1

/* Definitions for peripheral  */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SYSMON_0_S_AXI_BASEADDR 0xF1270000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SYSMON_0_S_AXI_HIGHADDR 0xF129FFFF


/******************************************************************/

/* Canonical definitions for peripheral  */
#define XPAR_XSYSMONPSV_0_S_AXI_BASEADDR 0xF1270000
#define XPAR_XSYSMONPSV_0_S_AXI_HIGHADDR 0xF129FFFF

#define XPAR_XSYSMONPSV_0_NO_MEAS	161

/******************************************************************/

/* Xilinx Sysmon Device Name */

/******************************************************************/

/* Definitions for driver TMR_INJECT */
#define XPAR_XTMR_INJECT_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_INJECT_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_INJECT_0_DEVICE_ID 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_INJECT_0_BASEADDR 0xF0284000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_INJECT_0_HIGHADDR 0xF0284FFF
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_INJECT_0_MASK 0x0000000000084000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_INJECT_0_MAGIC 0x27
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_INJECT_0_CPU_ID 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_INJECT_0_INJECT_LMB_AWIDTH 0


/******************************************************************/

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_INJECT_0 */
#define XPAR_TMR_INJECT_0_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_INJECT_0_DEVICE_ID
#define XPAR_TMR_INJECT_0_BASEADDR 0xF0284000
#define XPAR_TMR_INJECT_0_HIGHADDR 0xF0284FFF
#define XPAR_TMR_INJECT_0_MASK 0x0000000000084000
#define XPAR_TMR_INJECT_0_MAGIC 0x27
#define XPAR_TMR_INJECT_0_CPU_ID 1
#define XPAR_TMR_INJECT_0_INJECT_LMB_AWIDTH 0


/******************************************************************/

/* Definitions for driver TMR_MANAGER */
#define XPAR_XTMR_MANAGER_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_DEVICE_ID 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_BASEADDR 0xF0283000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_HIGHADDR 0xF0283FFF
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_MASK 0x0000000000083000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_BRK_DELAY_RST_VALUE 0x00000000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_MASK_RST_VALUE 0xFFFFFFFFFFFFFFFF
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_MAGIC1 0x00
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_MAGIC2 0x00
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_UE_IS_FATAL 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_UE_WIDTH 3
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_NO_OF_COMPARATORS 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_COMPARATORS_MASK 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_WATCHDOG 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_WATCHDOG_WIDTH 30
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_SEM_INTERFACE 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_SEM_HEARTBEAT_WATCHDOG 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_SEM_HEARTBEAT_WATCHDOG_WIDTH 10
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_BRK_DELAY_WIDTH 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_TMR 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_TEST_COMPARATOR 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_STRICT_MISCOMPARE 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_USE_DEBUG_DISABLE 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_USE_TMR_DISABLE 0


/******************************************************************/

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0 */
#define XPAR_TMR_MANAGER_0_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TMR_MANAGER_0_DEVICE_ID
#define XPAR_TMR_MANAGER_0_BASEADDR 0xF0283000
#define XPAR_TMR_MANAGER_0_HIGHADDR 0xF0283FFF
#define XPAR_TMR_MANAGER_0_BRK_DELAY_RST_VALUE 0x00000000
#define XPAR_TMR_MANAGER_0_MASK_RST_VALUE 0xFFFFFFFFFFFFFFFF
#define XPAR_TMR_MANAGER_0_MASK 0x0000000000083000
#define XPAR_TMR_MANAGER_0_MAGIC1 0x00
#define XPAR_TMR_MANAGER_0_MAGIC2 0x00
#define XPAR_TMR_MANAGER_0_UE_IS_FATAL 0
#define XPAR_TMR_MANAGER_0_UE_WIDTH 3
#define XPAR_TMR_MANAGER_0_NO_OF_COMPARATORS 1
#define XPAR_TMR_MANAGER_0_COMPARATORS_MASK 0
#define XPAR_TMR_MANAGER_0_WATCHDOG 0
#define XPAR_TMR_MANAGER_0_WATCHDOG_WIDTH 30
#define XPAR_TMR_MANAGER_0_SEM_INTERFACE 0
#define XPAR_TMR_MANAGER_0_SEM_HEARTBEAT_WATCHDOG 0
#define XPAR_TMR_MANAGER_0_SEM_HEARTBEAT_WATCHDOG_WIDTH 10
#define XPAR_TMR_MANAGER_0_BRK_DELAY_WIDTH 0
#define XPAR_TMR_MANAGER_0_TMR 1
#define XPAR_TMR_MANAGER_0_TEST_COMPARATOR 0
#define XPAR_TMR_MANAGER_0_STRICT_MISCOMPARE 0
#define XPAR_TMR_MANAGER_0_USE_DEBUG_DISABLE 0
#define XPAR_TMR_MANAGER_0_USE_TMR_DISABLE 0


/******************************************************************/

/* Definitions for driver TRNGPSV */
#define XPAR_XTRNGPSV_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TRNG */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TRNG_DEVICE_ID 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TRNG_BASEADDR 0xF1230000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TRNG_HIGHADDR 0xF123FFFF


/******************************************************************/

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TRNG */
#define XPAR_XTRNGPSV_0_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TRNG_DEVICE_ID
#define XPAR_XTRNGPSV_0_BASEADDR 0xF1230000
#define XPAR_XTRNGPSV_0_HIGHADDR 0xF123FFFF


/******************************************************************/

/* Definitions for driver TTCPS */
#define XPAR_XTTCPS_NUM_INSTANCES 12U

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_TTC_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_0_DEVICE_ID 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_0_BASEADDR 0XFF0E0000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_0_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_0_TTC_CLK_CLKSRC 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_1_DEVICE_ID 1U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_1_BASEADDR 0XFF0E0004U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_1_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_1_TTC_CLK_CLKSRC 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_2_DEVICE_ID 2U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_2_BASEADDR 0XFF0E0008U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_2_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_2_TTC_CLK_CLKSRC 0U


/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_TTC_1 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_3_DEVICE_ID 3U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_3_BASEADDR 0XFF0F0000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_3_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_3_TTC_CLK_CLKSRC 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_4_DEVICE_ID 4U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_4_BASEADDR 0XFF0F0004U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_4_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_4_TTC_CLK_CLKSRC 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_5_DEVICE_ID 5U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_5_BASEADDR 0XFF0F0008U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_5_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_5_TTC_CLK_CLKSRC 0U


/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_TTC_2 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_6_DEVICE_ID 6U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_6_BASEADDR 0XFF100000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_6_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_6_TTC_CLK_CLKSRC 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_7_DEVICE_ID 7U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_7_BASEADDR 0XFF100004U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_7_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_7_TTC_CLK_CLKSRC 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_8_DEVICE_ID 8U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_8_BASEADDR 0XFF100008U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_8_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_8_TTC_CLK_CLKSRC 0U


/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_TTC_3 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_9_DEVICE_ID 9U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_9_BASEADDR 0XFF110000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_9_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_9_TTC_CLK_CLKSRC 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_10_DEVICE_ID 10U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_10_BASEADDR 0XFF110004U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_10_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_10_TTC_CLK_CLKSRC 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_11_DEVICE_ID 11U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_11_BASEADDR 0XFF110008U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_11_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_11_TTC_CLK_CLKSRC 0U


/******************************************************************/

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_TTC_0 */
#define XPAR_XTTCPS_0_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_0_DEVICE_ID
#define XPAR_XTTCPS_0_BASEADDR 0xFF0E0000U
#define XPAR_XTTCPS_0_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_XTTCPS_0_TTC_CLK_CLKSRC 0U

#define XPAR_XTTCPS_1_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_1_DEVICE_ID
#define XPAR_XTTCPS_1_BASEADDR 0xFF0E0004U
#define XPAR_XTTCPS_1_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_XTTCPS_1_TTC_CLK_CLKSRC 0U

#define XPAR_XTTCPS_2_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_2_DEVICE_ID
#define XPAR_XTTCPS_2_BASEADDR 0xFF0E0008U
#define XPAR_XTTCPS_2_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_XTTCPS_2_TTC_CLK_CLKSRC 0U

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_TTC_1 */
#define XPAR_XTTCPS_3_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_3_DEVICE_ID
#define XPAR_XTTCPS_3_BASEADDR 0xFF0F0000U
#define XPAR_XTTCPS_3_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_XTTCPS_3_TTC_CLK_CLKSRC 0U

#define XPAR_XTTCPS_4_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_4_DEVICE_ID
#define XPAR_XTTCPS_4_BASEADDR 0xFF0F0004U
#define XPAR_XTTCPS_4_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_XTTCPS_4_TTC_CLK_CLKSRC 0U

#define XPAR_XTTCPS_5_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_5_DEVICE_ID
#define XPAR_XTTCPS_5_BASEADDR 0xFF0F0008U
#define XPAR_XTTCPS_5_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_XTTCPS_5_TTC_CLK_CLKSRC 0U

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_TTC_2 */
#define XPAR_XTTCPS_6_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_6_DEVICE_ID
#define XPAR_XTTCPS_6_BASEADDR 0xFF100000U
#define XPAR_XTTCPS_6_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_XTTCPS_6_TTC_CLK_CLKSRC 0U

#define XPAR_XTTCPS_7_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_7_DEVICE_ID
#define XPAR_XTTCPS_7_BASEADDR 0xFF100004U
#define XPAR_XTTCPS_7_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_XTTCPS_7_TTC_CLK_CLKSRC 0U

#define XPAR_XTTCPS_8_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_8_DEVICE_ID
#define XPAR_XTTCPS_8_BASEADDR 0xFF100008U
#define XPAR_XTTCPS_8_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_XTTCPS_8_TTC_CLK_CLKSRC 0U

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_TTC_3 */
#define XPAR_XTTCPS_9_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_9_DEVICE_ID
#define XPAR_XTTCPS_9_BASEADDR 0xFF110000U
#define XPAR_XTTCPS_9_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_XTTCPS_9_TTC_CLK_CLKSRC 0U

#define XPAR_XTTCPS_10_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_10_DEVICE_ID
#define XPAR_XTTCPS_10_BASEADDR 0xFF110004U
#define XPAR_XTTCPS_10_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_XTTCPS_10_TTC_CLK_CLKSRC 0U

#define XPAR_XTTCPS_11_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_TTC_11_DEVICE_ID
#define XPAR_XTTCPS_11_BASEADDR 0xFF110008U
#define XPAR_XTTCPS_11_TTC_CLK_FREQ_HZ 149999863U
#define XPAR_XTTCPS_11_TTC_CLK_CLKSRC 0U


/******************************************************************/

/* Definitions for driver UARTLITE */
#define XPAR_XUARTLITE_NUM_INSTANCES 1U

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0_DEVICE_ID 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0_BASEADDR 0xF0310000U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0_HIGHADDR 0xF0317FFFU
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0_BAUDRATE 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0_USE_PARITY 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0_ODD_PARITY 0U
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0_DATA_BITS 0U

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0 */
#define XPAR_UARTLITE_0_DEVICE_ID 0U
#define XPAR_UARTLITE_0_BASEADDR 0xF0310000U
#define XPAR_UARTLITE_0_HIGHADDR 0xF0317FFFU
#define XPAR_UARTLITE_0_BAUDRATE 0U
#define XPAR_UARTLITE_0_USE_PARITY 0U
#define XPAR_UARTLITE_0_ODD_PARITY 0U
#define XPAR_UARTLITE_0_DATA_BITS 0U


/******************************************************************/
/* Definitions for driver UARTPSV */
#define XPAR_XUARTPSV_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_SBSAUART_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SBSAUART_0_DEVICE_ID 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SBSAUART_0_BASEADDR 0xFF000000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SBSAUART_0_HIGHADDR 0xFF00FFFF
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SBSAUART_0_UART_CLK_FREQ_HZ 99999901
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SBSAUART_0_HAS_MODEM 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SBSAUART_0_BAUDRATE 115200


/******************************************************************/

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_SBSAUART_0 */
#define XPAR_XUARTPSV_0_DEVICE_ID XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SBSAUART_0_DEVICE_ID
#define XPAR_XUARTPSV_0_BASEADDR 0xFF000000
#define XPAR_XUARTPSV_0_HIGHADDR 0xFF00FFFF
#define XPAR_XUARTPSV_0_UART_CLK_FREQ_HZ 99999901
#define XPAR_XUARTPSV_0_HAS_MODEM 0
#define XPAR_XUARTPSV_0_BAUDRATE 115200

/******************************************************************/

/* PLM/XilPLMI configuration */

/* Debug level option */
//#define PLM_DEBUG

/* Boot time measurement enable */
//#define PLM_PRINT_PERF

/* USB Boot mode support disable */
#define PLM_USB_EXCLUDE

/* NVM handlers disable */
#define PLM_NVM_EXCLUDE

/* PUF handlers disable */
#define PLM_PUF_EXCLUDE

//#define PLM_QSPI_EXCLUDE
#define PLM_SD_EXCLUDE
//#define PLM_OSPI_EXCLUDE
#define PLM_SEM_EXCLUDE
#define PLM_SECURE_EXCLUDE
#define PLM_ECDSA_EXCLUDE
#define PLM_RSA_EXCLUDE

/* Xilinx Secure library ecdsa endianness Settings */
#define XSECURE_ELLIPTIC_ENDIANNESS    0U    /* 0: Little Endian and 1: Big endian */

/* Number of user modules. */
#define XPAR_MAX_USER_MODULES 0U

/* Customer Defined PLM Version */
#define XPAR_PLM_VERSION_USER_DEFINED 0U

//#define XPAR_XILPM_ENABLED

#ifdef __cplusplus
}
#endif

#endif  /* end of protection macro */
