# Copyright (C) 2023-2025 Advanced Micro Devices, Inc.  All rights reserved.
# SPDX-License-Identifier: MIT
set( CMAKE_EXPORT_COMPILE_COMMANDS ON)
set( CMAKE_INSTALL_MESSAGE LAZY)
set( CMAKE_C_COMPILER armr5-none-eabi-gcc )
set( CMAKE_CXX_COMPILER armr5-none-eabi-g++ )
set( CMAKE_C_COMPILER_LAUNCHER  )
set( CMAKE_CXX_COMPILER_LAUNCHER  )
set( CMAKE_ASM_COMPILER armr5-none-eabi-gcc )
set( CMAKE_AR armr5-none-eabi-ar CACHE FILEPATH "Archiver" )
set( CMAKE_SIZE armr5-none-eabi-size CACHE FILEPATH "Size" )
set( CMAKE_SYSTEM_PROCESSOR "cortexr52" )
set( CMAKE_MACHINE "VersalNet" )
set( CMAKE_SUBMACHINE "VersalNet")
set( CMAKE_SYSTEM_NAME "Generic" )
set( CMAKE_SPECS_FILE "$ENV{ESW_REPO}/scripts/specs/arm/Xilinx.spec" CACHE STRING "Specs file path for using CMAKE toolchain files" )
set( TOOLCHAIN_C_FLAGS " -mcpu=cortex-r52 -DSDT -DARMR5 -DARMR52 -mfloat-abi=hard -mfpu=vfpv3-d16" CACHE STRING "CFLAGS" )
set( TOOLCHAIN_CXX_FLAGS " -mcpu=cortex-r52 -DSDT -DARMR5 -DARMR52 -mfloat-abi=hard -mfpu=vfpv3-d16" CACHE STRING "CXXFLAGS" )
set( TOOLCHAIN_ASM_FLAGS " -mcpu=cortex-r52 -DSDT -DARMR5 -DARMR52 -mfloat-abi=hard -mfpu=vfpv3-d16" CACHE STRING "ASM FLAGS" )
set( TOOLCHAIN_DEP_FLAGS " -MMD -MP" CACHE STRING "Flags used by compiler to generate dependency files")
set( TOOLCHAIN_EXTRA_C_FLAGS " -O2 -g -Wall -Wextra -fno-tree-loop-distribute-patterns" CACHE STRING "Extra CFLAGS")
set( CMAKE_C_FLAGS_RELEASE "-DNDEBUG" CACHE STRING "Additional CFLAGS for release" )
set( CMAKE_CXX_FLAGS_RELEASE "-DNDEBUG" CACHE STRING "Additional CXXFLAGS for release" )
set( CMAKE_ASM_FLAGS_RELEASE "-DNDEBUG" CACHE STRING "Additional ASM FLAGS for release" )
set( CMAKE_C_FLAGS "${TOOLCHAIN_C_FLAGS} ${TOOLCHAIN_DEP_FLAGS} -specs=${CMAKE_SPECS_FILE} -I${CMAKE_INCLUDE_PATH}" CACHE STRING "CFLAGS")
set( CMAKE_CXX_FLAGS "${TOOLCHAIN_CXX_FLAGS} ${TOOLCHAIN_DEP_FLAGS} -specs=${CMAKE_SPECS_FILE} -I${CMAKE_INCLUDE_PATH}" CACHE STRING "CXXFLAGS")
set( CMAKE_ASM_FLAGS "${TOOLCHAIN_ASM_FLAGS} ${TOOLCHAIN_DEP_FLAGS} -specs=${CMAKE_SPECS_FILE} -I${CMAKE_INCLUDE_PATH}" CACHE STRING "ASMFLAGS")
