# Copyright (C) 2024 Advanced Micro Devices, Inc.  All rights reserved.
# SPDX-License-Identifier: MIT
set( CMAKE_EXPORT_COMPILE_COMMANDS ON)
set( CMAKE_INSTALL_MESSAGE LAZY)
set( CMAKE_C_COMPILER armclang )
set( CMAKE_CXX_COMPILER armclang )
set( CMAKE_C_COMPILER_LAUNCHER  )
set( CMAKE_CXX_COMPILER_LAUNCHER  )
set( CMAKE_ASM_COMPILER armasm )
set( CMAKE_SYSTEM_ARCH armv8-a)
set( CMAKE_AR armar CACHE FILEPATH "Archiver" )
set( CMAKE_SIZE aarch64-none-elf-size CACHE FILEPATH "Size" )
set( CMAKE_SYSTEM_PROCESSOR "cortexa72" )
set( CMAKE_MACHINE "Versal" )
set( CMAKE_SYSTEM_NAME "Generic" )
set( TOOLCHAIN_C_FLAGS "  --target=aarch64-arm-none-eabi -O2 -DSDT -DARMA72_EL3" CACHE STRING "CFLAGS" )
set( TOOLCHAIN_CXX_FLAGS "  --target=aarch64-arm-none-eabi -O2 -DSDT -DARMA72_EL3" CACHE STRING "CXXFLAGS" )
set( TOOLCHAIN_ASM_FLAGS "  --target=aarch64-arm-none-eabi -O2 -DSDT -DARMA72_EL3" CACHE STRING "ASM FLAGS" )
set( TOOLCHAIN_EXTRA_C_FLAGS " -mfpu=fp-armv8 -g -Wall -Wextra -march=armv8-a " CACHE STRING "Extra CFLAGS")
set( CMAKE_C_FLAGS_RELEASE "-DNDEBUG" CACHE STRING "Additional CFLAGS for release" )
set( CMAKE_CXX_FLAGS_RELEASE "-DNDEBUG" CACHE STRING "Additional CXXFLAGS for release" )
set( CMAKE_ASM_FLAGS_RELEASE "-DNDEBUG" CACHE STRING "Additional ASM FLAGS for release" )
set( CMAKE_C_FLAGS "${TOOLCHAIN_C_FLAGS} -I${CMAKE_INCLUDE_PATH}" CACHE STRING "CFLAGS")
set( CMAKE_CXX_FLAGS "${TOOLCHAIN_CXX_FLAGS} -I${CMAKE_INCLUDE_PATH}" CACHE STRING "CXXFLAGS")
set( CMAKE_ASM_FLAGS "${TOOLCHAIN_ASM_FLAGS}  -I${CMAKE_INCLUDE_PATH}" CACHE STRING "ASMFLAGS")
