/******************************************************************************
* Copyright (C) 2022 Xilinx, Inc.  All rights reserved.
* Copyright 2022-2023 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/***************************** Include Files *********************************/
#include "xv_warp_init_utils.h"
#include "math.h"

/*****************************************************************************/
/**
* Look up table of exponential values between 0 and 8 representated in Q10 format
*
******************************************************************************/
static unsigned int exp_neg_int_lut[12] = {
				131072,48219,17739,6526,2401,883,325,120,44,16,
				6,2 };

/*****************************************************************************/
/**
* Look up table of exponential values between 0 and -12 representated in Q17 format
*
******************************************************************************/
static unsigned int exp_pos_int_lut[8] = {
				1024,2783,7566,20567,55908,151975,413111,1122952 };

/*****************************************************************************/
/**
* Look up table of exponential values between 0 and  1 in steps of
* 0.0078125 representated in Q14 format
*
******************************************************************************/
static unsigned short exp_pos_fract_lut1[129] = {
				16384,16512,16642,16772,16904,17036,17170,17304,17440,17577,
				17715,17854,17994,18135,18277,18421,18565,18711,18857,19005,
				19154,19305,19456,19609,19762,19917,20074,20231,20390,20550,
				20711,20873,21037,21202,21368,21536,21705,21875,22047,22219,
				22394,22569,22746,22925,23105,23286,23468,23653,23838,24025,
				24213,24403,24595,24788,24982,25178,25376,25575,25775,25977,
				26181,26386,26593,26802,27012,27224,27438,27653,27870,28088,
				28309,28531,28754,28980,29207,29436,29667,29900,30134,30371,
				30609,30849,31091,31335,31580,31828,32078,32329,32583,32839,
				33096,33356,33617,33881,34147,34415,34684,34956,35231,35507,
				35785,36066,36349,36634,36921,37211,37503,37797,38093,38392,
				38693,38997,39303,39611,39922,40235,40550,40868,41189,41512,
				41838,42166,42496,42830,43166,43504,43845,44189,44536 };

/*****************************************************************************/
/**
* Look up table of exponential values between 0 and 0.0078125 in steps of
* 0.0000019073486328125 representated in Q22 format
*
******************************************************************************/
static unsigned short exp_pos_fract_lut2[4101] = {
				0,8,16,24,32,40,48,56,64,72,
				80,88,96,104,112,120,128,136,144,152,
				160,168,176,184,192,200,208,216,224,232,
				240,248,256,264,272,280,288,296,304,312,
				320,328,336,344,352,360,368,376,384,392,
				400,408,416,424,432,440,448,456,464,472,
				480,488,496,504,512,520,528,536,544,552,
				560,568,576,584,592,600,608,616,624,632,
				640,648,656,664,672,680,688,696,704,712,
				720,728,736,744,752,760,768,776,784,792,
				800,808,816,824,832,840,848,856,864,872,
				880,888,896,904,912,920,928,936,944,952,
				960,968,976,984,992,1000,1008,1016,1024,1032,
				1040,1048,1056,1064,1072,1080,1088,1096,1104,1112,
				1120,1128,1136,1144,1152,1160,1168,1176,1184,1192,
				1200,1208,1216,1224,1232,1240,1248,1256,1264,1272,
				1280,1288,1296,1304,1312,1320,1328,1336,1344,1352,
				1360,1368,1376,1384,1392,1400,1408,1416,1424,1432,
				1440,1448,1456,1464,1472,1480,1488,1496,1504,1512,
				1520,1528,1536,1544,1552,1560,1568,1576,1584,1592,
				1600,1608,1616,1624,1632,1640,1648,1656,1664,1672,
				1680,1688,1696,1704,1712,1720,1728,1736,1744,1752,
				1760,1768,1776,1784,1792,1800,1808,1816,1824,1832,
				1840,1848,1856,1864,1872,1880,1888,1896,1904,1912,
				1920,1928,1936,1944,1952,1960,1968,1976,1984,1992,
				2000,2008,2016,2024,2032,2040,2048,2056,2064,2072,
				2080,2088,2096,2104,2112,2120,2128,2136,2144,2152,
				2160,2168,2176,2184,2192,2200,2208,2216,2224,2232,
				2240,2248,2256,2264,2272,2280,2288,2296,2304,2312,
				2320,2328,2336,2344,2352,2360,2368,2376,2384,2392,
				2400,2408,2416,2424,2432,2440,2448,2456,2464,2472,
				2480,2488,2496,2504,2512,2520,2528,2536,2544,2552,
				2560,2568,2576,2584,2592,2600,2608,2616,2624,2632,
				2640,2648,2656,2664,2672,2680,2688,2696,2704,2712,
				2720,2728,2736,2744,2752,2760,2768,2776,2784,2792,
				2800,2808,2816,2824,2832,2840,2848,2856,2864,2872,
				2880,2888,2897,2905,2913,2921,2929,2937,2945,2953,
				2961,2969,2977,2985,2993,3001,3009,3017,3025,3033,
				3041,3049,3057,3065,3073,3081,3089,3097,3105,3113,
				3121,3129,3137,3145,3153,3161,3169,3177,3185,3193,
				3201,3209,3217,3225,3233,3241,3249,3257,3265,3273,
				3281,3289,3297,3305,3313,3321,3329,3337,3345,3353,
				3361,3369,3377,3385,3393,3401,3409,3417,3425,3433,
				3441,3449,3457,3465,3473,3481,3489,3497,3505,3513,
				3521,3529,3537,3545,3553,3561,3569,3577,3585,3593,
				3601,3609,3617,3625,3633,3641,3649,3657,3665,3673,
				3681,3689,3697,3705,3713,3721,3729,3737,3745,3753,
				3761,3769,3777,3785,3793,3801,3809,3817,3825,3833,
				3841,3849,3857,3865,3873,3881,3889,3897,3905,3913,
				3921,3929,3937,3945,3953,3961,3969,3977,3985,3993,
				4001,4009,4017,4025,4033,4041,4049,4057,4065,4073,
				4081,4089,4098,4106,4114,4122,4130,4138,4146,4154,
				4162,4170,4178,4186,4194,4202,4210,4218,4226,4234,
				4242,4250,4258,4266,4274,4282,4290,4298,4306,4314,
				4322,4330,4338,4346,4354,4362,4370,4378,4386,4394,
				4402,4410,4418,4426,4434,4442,4450,4458,4466,4474,
				4482,4490,4498,4506,4514,4522,4530,4538,4546,4554,
				4562,4570,4578,4586,4594,4602,4610,4618,4626,4634,
				4642,4650,4658,4666,4674,4682,4690,4698,4706,4714,
				4722,4730,4738,4746,4754,4762,4770,4778,4786,4794,
				4802,4810,4818,4826,4834,4842,4850,4858,4866,4874,
				4882,4890,4898,4906,4914,4922,4930,4938,4946,4954,
				4962,4970,4978,4986,4994,5002,5010,5019,5027,5035,
				5043,5051,5059,5067,5075,5083,5091,5099,5107,5115,
				5123,5131,5139,5147,5155,5163,5171,5179,5187,5195,
				5203,5211,5219,5227,5235,5243,5251,5259,5267,5275,
				5283,5291,5299,5307,5315,5323,5331,5339,5347,5355,
				5363,5371,5379,5387,5395,5403,5411,5419,5427,5435,
				5443,5451,5459,5467,5475,5483,5491,5499,5507,5515,
				5523,5531,5539,5547,5555,5563,5571,5579,5587,5595,
				5603,5611,5619,5627,5635,5643,5651,5659,5667,5675,
				5683,5691,5699,5707,5715,5723,5731,5739,5747,5755,
				5763,5771,5779,5787,5796,5804,5812,5820,5828,5836,
				5844,5852,5860,5868,5876,5884,5892,5900,5908,5916,
				5924,5932,5940,5948,5956,5964,5972,5980,5988,5996,
				6004,6012,6020,6028,6036,6044,6052,6060,6068,6076,
				6084,6092,6100,6108,6116,6124,6132,6140,6148,6156,
				6164,6172,6180,6188,6196,6204,6212,6220,6228,6236,
				6244,6252,6260,6268,6276,6284,6292,6300,6308,6316,
				6324,6332,6340,6348,6356,6364,6372,6380,6388,6396,
				6404,6412,6420,6428,6436,6444,6452,6460,6468,6476,
				6485,6493,6501,6509,6517,6525,6533,6541,6549,6557,
				6565,6573,6581,6589,6597,6605,6613,6621,6629,6637,
				6645,6653,6661,6669,6677,6685,6693,6701,6709,6717,
				6725,6733,6741,6749,6757,6765,6773,6781,6789,6797,
				6805,6813,6821,6829,6837,6845,6853,6861,6869,6877,
				6885,6893,6901,6909,6917,6925,6933,6941,6949,6957,
				6965,6973,6981,6989,6997,7005,7013,7021,7029,7037,
				7045,7053,7061,7069,7077,7085,7093,7102,7110,7118,
				7126,7134,7142,7150,7158,7166,7174,7182,7190,7198,
				7206,7214,7222,7230,7238,7246,7254,7262,7270,7278,
				7286,7294,7302,7310,7318,7326,7334,7342,7350,7358,
				7366,7374,7382,7390,7398,7406,7414,7422,7430,7438,
				7446,7454,7462,7470,7478,7486,7494,7502,7510,7518,
				7526,7534,7542,7550,7558,7566,7574,7582,7590,7598,
				7606,7614,7622,7630,7638,7646,7654,7662,7671,7679,
				7687,7695,7703,7711,7719,7727,7735,7743,7751,7759,
				7767,7775,7783,7791,7799,7807,7815,7823,7831,7839,
				7847,7855,7863,7871,7879,7887,7895,7903,7911,7919,
				7927,7935,7943,7951,7959,7967,7975,7983,7991,7999,
				8007,8015,8023,8031,8039,8047,8055,8063,8071,8079,
				8087,8095,8103,8111,8119,8127,8135,8143,8151,8159,
				8167,8175,8183,8191,8200,8208,8216,8224,8232,8240,
				8248,8256,8264,8272,8280,8288,8296,8304,8312,8320,
				8328,8336,8344,8352,8360,8368,8376,8384,8392,8400,
				8408,8416,8424,8432,8440,8448,8456,8464,8472,8480,
				8488,8496,8504,8512,8520,8528,8536,8544,8552,8560,
				8568,8576,8584,8592,8600,8608,8616,8624,8632,8640,
				8648,8656,8664,8672,8680,8688,8697,8705,8713,8721,
				8729,8737,8745,8753,8761,8769,8777,8785,8793,8801,
				8809,8817,8825,8833,8841,8849,8857,8865,8873,8881,
				8889,8897,8905,8913,8921,8929,8937,8945,8953,8961,
				8969,8977,8985,8993,9001,9009,9017,9025,9033,9041,
				9049,9057,9065,9073,9081,9089,9097,9105,9113,9121,
				9129,9137,9145,9153,9161,9170,9178,9186,9194,9202,
				9210,9218,9226,9234,9242,9250,9258,9266,9274,9282,
				9290,9298,9306,9314,9322,9330,9338,9346,9354,9362,
				9370,9378,9386,9394,9402,9410,9418,9426,9434,9442,
				9450,9458,9466,9474,9482,9490,9498,9506,9514,9522,
				9530,9538,9546,9554,9562,9570,9578,9586,9594,9602,
				9610,9619,9627,9635,9643,9651,9659,9667,9675,9683,
				9691,9699,9707,9715,9723,9731,9739,9747,9755,9763,
				9771,9779,9787,9795,9803,9811,9819,9827,9835,9843,
				9851,9859,9867,9875,9883,9891,9899,9907,9915,9923,
				9931,9939,9947,9955,9963,9971,9979,9987,9995,10003,
				10011,10019,10027,10035,10044,10052,10060,10068,10076,10084,
				10092,10100,10108,10116,10124,10132,10140,10148,10156,10164,
				10172,10180,10188,10196,10204,10212,10220,10228,10236,10244,
				10252,10260,10268,10276,10284,10292,10300,10308,10316,10324,
				10332,10340,10348,10356,10364,10372,10380,10388,10396,10404,
				10412,10420,10428,10436,10444,10453,10461,10469,10477,10485,
				10493,10501,10509,10517,10525,10533,10541,10549,10557,10565,
				10573,10581,10589,10597,10605,10613,10621,10629,10637,10645,
				10653,10661,10669,10677,10685,10693,10701,10709,10717,10725,
				10733,10741,10749,10757,10765,10773,10781,10789,10797,10805,
				10813,10821,10829,10837,10845,10854,10862,10870,10878,10886,
				10894,10902,10910,10918,10926,10934,10942,10950,10958,10966,
				10974,10982,10990,10998,11006,11014,11022,11030,11038,11046,
				11054,11062,11070,11078,11086,11094,11102,11110,11118,11126,
				11134,11142,11150,11158,11166,11174,11182,11190,11198,11206,
				11214,11222,11231,11239,11247,11255,11263,11271,11279,11287,
				11295,11303,11311,11319,11327,11335,11343,11351,11359,11367,
				11375,11383,11391,11399,11407,11415,11423,11431,11439,11447,
				11455,11463,11471,11479,11487,11495,11503,11511,11519,11527,
				11535,11543,11551,11559,11567,11575,11583,11591,11600,11608,
				11616,11624,11632,11640,11648,11656,11664,11672,11680,11688,
				11696,11704,11712,11720,11728,11736,11744,11752,11760,11768,
				11776,11784,11792,11800,11808,11816,11824,11832,11840,11848,
				11856,11864,11872,11880,11888,11896,11904,11912,11920,11928,
				11936,11944,11952,11961,11969,11977,11985,11993,12001,12009,
				12017,12025,12033,12041,12049,12057,12065,12073,12081,12089,
				12097,12105,12113,12121,12129,12137,12145,12153,12161,12169,
				12177,12185,12193,12201,12209,12217,12225,12233,12241,12249,
				12257,12265,12273,12281,12289,12297,12306,12314,12322,12330,
				12338,12346,12354,12362,12370,12378,12386,12394,12402,12410,
				12418,12426,12434,12442,12450,12458,12466,12474,12482,12490,
				12498,12506,12514,12522,12530,12538,12546,12554,12562,12570,
				12578,12586,12594,12602,12610,12618,12626,12634,12643,12651,
				12659,12667,12675,12683,12691,12699,12707,12715,12723,12731,
				12739,12747,12755,12763,12771,12779,12787,12795,12803,12811,
				12819,12827,12835,12843,12851,12859,12867,12875,12883,12891,
				12899,12907,12915,12923,12931,12939,12947,12955,12963,12972,
				12980,12988,12996,13004,13012,13020,13028,13036,13044,13052,
				13060,13068,13076,13084,13092,13100,13108,13116,13124,13132,
				13140,13148,13156,13164,13172,13180,13188,13196,13204,13212,
				13220,13228,13236,13244,13252,13260,13268,13276,13284,13293,
				13301,13309,13317,13325,13333,13341,13349,13357,13365,13373,
				13381,13389,13397,13405,13413,13421,13429,13437,13445,13453,
				13461,13469,13477,13485,13493,13501,13509,13517,13525,13533,
				13541,13549,13557,13565,13573,13581,13589,13597,13606,13614,
				13622,13630,13638,13646,13654,13662,13670,13678,13686,13694,
				13702,13710,13718,13726,13734,13742,13750,13758,13766,13774,
				13782,13790,13798,13806,13814,13822,13830,13838,13846,13854,
				13862,13870,13878,13886,13894,13902,13911,13919,13927,13935,
				13943,13951,13959,13967,13975,13983,13991,13999,14007,14015,
				14023,14031,14039,14047,14055,14063,14071,14079,14087,14095,
				14103,14111,14119,14127,14135,14143,14151,14159,14167,14175,
				14183,14191,14199,14208,14216,14224,14232,14240,14248,14256,
				14264,14272,14280,14288,14296,14304,14312,14320,14328,14336,
				14344,14352,14360,14368,14376,14384,14392,14400,14408,14416,
				14424,14432,14440,14448,14456,14464,14472,14480,14488,14496,
				14505,14513,14521,14529,14537,14545,14553,14561,14569,14577,
				14585,14593,14601,14609,14617,14625,14633,14641,14649,14657,
				14665,14673,14681,14689,14697,14705,14713,14721,14729,14737,
				14745,14753,14761,14769,14777,14786,14794,14802,14810,14818,
				14826,14834,14842,14850,14858,14866,14874,14882,14890,14898,
				14906,14914,14922,14930,14938,14946,14954,14962,14970,14978,
				14986,14994,15002,15010,15018,15026,15034,15042,15050,15058,
				15066,15075,15083,15091,15099,15107,15115,15123,15131,15139,
				15147,15155,15163,15171,15179,15187,15195,15203,15211,15219,
				15227,15235,15243,15251,15259,15267,15275,15283,15291,15299,
				15307,15315,15323,15331,15339,15348,15356,15364,15372,15380,
				15388,15396,15404,15412,15420,15428,15436,15444,15452,15460,
				15468,15476,15484,15492,15500,15508,15516,15524,15532,15540,
				15548,15556,15564,15572,15580,15588,15596,15604,15612,15621,
				15629,15637,15645,15653,15661,15669,15677,15685,15693,15701,
				15709,15717,15725,15733,15741,15749,15757,15765,15773,15781,
				15789,15797,15805,15813,15821,15829,15837,15845,15853,15861,
				15869,15877,15886,15894,15902,15910,15918,15926,15934,15942,
				15950,15958,15966,15974,15982,15990,15998,16006,16014,16022,
				16030,16038,16046,16054,16062,16070,16078,16086,16094,16102,
				16110,16118,16126,16134,16142,16151,16159,16167,16175,16183,
				16191,16199,16207,16215,16223,16231,16239,16247,16255,16263,
				16271,16279,16287,16295,16303,16311,16319,16327,16335,16343,
				16351,16359,16367,16375,16383,16391,16399,16408,16416,16424,
				16432,16440,16448,16456,16464,16472,16480,16488,16496,16504,
				16512,16520,16528,16536,16544,16552,16560,16568,16576,16584,
				16592,16600,16608,16616,16624,16632,16640,16648,16656,16665,
				16673,16681,16689,16697,16705,16713,16721,16729,16737,16745,
				16753,16761,16769,16777,16785,16793,16801,16809,16817,16825,
				16833,16841,16849,16857,16865,16873,16881,16889,16897,16905,
				16914,16922,16930,16938,16946,16954,16962,16970,16978,16986,
				16994,17002,17010,17018,17026,17034,17042,17050,17058,17066,
				17074,17082,17090,17098,17106,17114,17122,17130,17138,17146,
				17154,17163,17171,17179,17187,17195,17203,17211,17219,17227,
				17235,17243,17251,17259,17267,17275,17283,17291,17299,17307,
				17315,17323,17331,17339,17347,17355,17363,17371,17379,17387,
				17395,17404,17412,17420,17428,17436,17444,17452,17460,17468,
				17476,17484,17492,17500,17508,17516,17524,17532,17540,17548,
				17556,17564,17572,17580,17588,17596,17604,17612,17620,17628,
				17636,17645,17653,17661,17669,17677,17685,17693,17701,17709,
				17717,17725,17733,17741,17749,17757,17765,17773,17781,17789,
				17797,17805,17813,17821,17829,17837,17845,17853,17861,17869,
				17877,17886,17894,17902,17910,17918,17926,17934,17942,17950,
				17958,17966,17974,17982,17990,17998,18006,18014,18022,18030,
				18038,18046,18054,18062,18070,18078,18086,18094,18102,18110,
				18119,18127,18135,18143,18151,18159,18167,18175,18183,18191,
				18199,18207,18215,18223,18231,18239,18247,18255,18263,18271,
				18279,18287,18295,18303,18311,18319,18327,18335,18343,18352,
				18360,18368,18376,18384,18392,18400,18408,18416,18424,18432,
				18440,18448,18456,18464,18472,18480,18488,18496,18504,18512,
				18520,18528,18536,18544,18552,18560,18568,18577,18585,18593,
				18601,18609,18617,18625,18633,18641,18649,18657,18665,18673,
				18681,18689,18697,18705,18713,18721,18729,18737,18745,18753,
				18761,18769,18777,18785,18793,18802,18810,18818,18826,18834,
				18842,18850,18858,18866,18874,18882,18890,18898,18906,18914,
				18922,18930,18938,18946,18954,18962,18970,18978,18986,18994,
				19002,19010,19018,19027,19035,19043,19051,19059,19067,19075,
				19083,19091,19099,19107,19115,19123,19131,19139,19147,19155,
				19163,19171,19179,19187,19195,19203,19211,19219,19227,19235,
				19244,19252,19260,19268,19276,19284,19292,19300,19308,19316,
				19324,19332,19340,19348,19356,19364,19372,19380,19388,19396,
				19404,19412,19420,19428,19436,19444,19452,19461,19469,19477,
				19485,19493,19501,19509,19517,19525,19533,19541,19549,19557,
				19565,19573,19581,19589,19597,19605,19613,19621,19629,19637,
				19645,19653,19661,19669,19678,19686,19694,19702,19710,19718,
				19726,19734,19742,19750,19758,19766,19774,19782,19790,19798,
				19806,19814,19822,19830,19838,19846,19854,19862,19870,19878,
				19886,19895,19903,19911,19919,19927,19935,19943,19951,19959,
				19967,19975,19983,19991,19999,20007,20015,20023,20031,20039,
				20047,20055,20063,20071,20079,20087,20095,20104,20112,20120,
				20128,20136,20144,20152,20160,20168,20176,20184,20192,20200,
				20208,20216,20224,20232,20240,20248,20256,20264,20272,20280,
				20288,20296,20304,20313,20321,20329,20337,20345,20353,20361,
				20369,20377,20385,20393,20401,20409,20417,20425,20433,20441,
				20449,20457,20465,20473,20481,20489,20497,20505,20514,20522,
				20530,20538,20546,20554,20562,20570,20578,20586,20594,20602,
				20610,20618,20626,20634,20642,20650,20658,20666,20674,20682,
				20690,20698,20706,20714,20723,20731,20739,20747,20755,20763,
				20771,20779,20787,20795,20803,20811,20819,20827,20835,20843,
				20851,20859,20867,20875,20883,20891,20899,20907,20915,20924,
				20932,20940,20948,20956,20964,20972,20980,20988,20996,21004,
				21012,21020,21028,21036,21044,21052,21060,21068,21076,21084,
				21092,21100,21108,21116,21125,21133,21141,21149,21157,21165,
				21173,21181,21189,21197,21205,21213,21221,21229,21237,21245,
				21253,21261,21269,21277,21285,21293,21301,21309,21317,21326,
				21334,21342,21350,21358,21366,21374,21382,21390,21398,21406,
				21414,21422,21430,21438,21446,21454,21462,21470,21478,21486,
				21494,21502,21510,21519,21527,21535,21543,21551,21559,21567,
				21575,21583,21591,21599,21607,21615,21623,21631,21639,21647,
				21655,21663,21671,21679,21687,21695,21703,21712,21720,21728,
				21736,21744,21752,21760,21768,21776,21784,21792,21800,21808,
				21816,21824,21832,21840,21848,21856,21864,21872,21880,21888,
				21896,21905,21913,21921,21929,21937,21945,21953,21961,21969,
				21977,21985,21993,22001,22009,22017,22025,22033,22041,22049,
				22057,22065,22073,22081,22089,22098,22106,22114,22122,22130,
				22138,22146,22154,22162,22170,22178,22186,22194,22202,22210,
				22218,22226,22234,22242,22250,22258,22266,22274,22282,22291,
				22299,22307,22315,22323,22331,22339,22347,22355,22363,22371,
				22379,22387,22395,22403,22411,22419,22427,22435,22443,22451,
				22459,22467,22476,22484,22492,22500,22508,22516,22524,22532,
				22540,22548,22556,22564,22572,22580,22588,22596,22604,22612,
				22620,22628,22636,22644,22652,22660,22669,22677,22685,22693,
				22701,22709,22717,22725,22733,22741,22749,22757,22765,22773,
				22781,22789,22797,22805,22813,22821,22829,22837,22845,22854,
				22862,22870,22878,22886,22894,22902,22910,22918,22926,22934,
				22942,22950,22958,22966,22974,22982,22990,22998,23006,23014,
				23022,23031,23039,23047,23055,23063,23071,23079,23087,23095,
				23103,23111,23119,23127,23135,23143,23151,23159,23167,23175,
				23183,23191,23199,23207,23216,23224,23232,23240,23248,23256,
				23264,23272,23280,23288,23296,23304,23312,23320,23328,23336,
				23344,23352,23360,23368,23376,23384,23392,23401,23409,23417,
				23425,23433,23441,23449,23457,23465,23473,23481,23489,23497,
				23505,23513,23521,23529,23537,23545,23553,23561,23569,23578,
				23586,23594,23602,23610,23618,23626,23634,23642,23650,23658,
				23666,23674,23682,23690,23698,23706,23714,23722,23730,23738,
				23746,23755,23763,23771,23779,23787,23795,23803,23811,23819,
				23827,23835,23843,23851,23859,23867,23875,23883,23891,23899,
				23907,23915,23923,23932,23940,23948,23956,23964,23972,23980,
				23988,23996,24004,24012,24020,24028,24036,24044,24052,24060,
				24068,24076,24084,24092,24100,24109,24117,24125,24133,24141,
				24149,24157,24165,24173,24181,24189,24197,24205,24213,24221,
				24229,24237,24245,24253,24261,24269,24277,24286,24294,24302,
				24310,24318,24326,24334,24342,24350,24358,24366,24374,24382,
				24390,24398,24406,24414,24422,24430,24438,24446,24455,24463,
				24471,24479,24487,24495,24503,24511,24519,24527,24535,24543,
				24551,24559,24567,24575,24583,24591,24599,24607,24615,24623,
				24632,24640,24648,24656,24664,24672,24680,24688,24696,24704,
				24712,24720,24728,24736,24744,24752,24760,24768,24776,24784,
				24792,24801,24809,24817,24825,24833,24841,24849,24857,24865,
				24873,24881,24889,24897,24905,24913,24921,24929,24937,24945,
				24953,24961,24970,24978,24986,24994,25002,25010,25018,25026,
				25034,25042,25050,25058,25066,25074,25082,25090,25098,25106,
				25114,25122,25130,25139,25147,25155,25163,25171,25179,25187,
				25195,25203,25211,25219,25227,25235,25243,25251,25259,25267,
				25275,25283,25291,25299,25308,25316,25324,25332,25340,25348,
				25356,25364,25372,25380,25388,25396,25404,25412,25420,25428,
				25436,25444,25452,25460,25469,25477,25485,25493,25501,25509,
				25517,25525,25533,25541,25549,25557,25565,25573,25581,25589,
				25597,25605,25613,25621,25629,25638,25646,25654,25662,25670,
				25678,25686,25694,25702,25710,25718,25726,25734,25742,25750,
				25758,25766,25774,25782,25790,25799,25807,25815,25823,25831,
				25839,25847,25855,25863,25871,25879,25887,25895,25903,25911,
				25919,25927,25935,25943,25951,25960,25968,25976,25984,25992,
				26000,26008,26016,26024,26032,26040,26048,26056,26064,26072,
				26080,26088,26096,26104,26112,26121,26129,26137,26145,26153,
				26161,26169,26177,26185,26193,26201,26209,26217,26225,26233,
				26241,26249,26257,26265,26273,26282,26290,26298,26306,26314,
				26322,26330,26338,26346,26354,26362,26370,26378,26386,26394,
				26402,26410,26418,26426,26434,26443,26451,26459,26467,26475,
				26483,26491,26499,26507,26515,26523,26531,26539,26547,26555,
				26563,26571,26579,26587,26595,26604,26612,26620,26628,26636,
				26644,26652,26660,26668,26676,26684,26692,26700,26708,26716,
				26724,26732,26740,26748,26756,26765,26773,26781,26789,26797,
				26805,26813,26821,26829,26837,26845,26853,26861,26869,26877,
				26885,26893,26901,26909,26918,26926,26934,26942,26950,26958,
				26966,26974,26982,26990,26998,27006,27014,27022,27030,27038,
				27046,27054,27062,27070,27079,27087,27095,27103,27111,27119,
				27127,27135,27143,27151,27159,27167,27175,27183,27191,27199,
				27207,27215,27223,27232,27240,27248,27256,27264,27272,27280,
				27288,27296,27304,27312,27320,27328,27336,27344,27352,27360,
				27368,27376,27385,27393,27401,27409,27417,27425,27433,27441,
				27449,27457,27465,27473,27481,27489,27497,27505,27513,27521,
				27529,27538,27546,27554,27562,27570,27578,27586,27594,27602,
				27610,27618,27626,27634,27642,27650,27658,27666,27674,27682,
				27691,27699,27707,27715,27723,27731,27739,27747,27755,27763,
				27771,27779,27787,27795,27803,27811,27819,27827,27835,27844,
				27852,27860,27868,27876,27884,27892,27900,27908,27916,27924,
				27932,27940,27948,27956,27964,27972,27980,27988,27997,28005,
				28013,28021,28029,28037,28045,28053,28061,28069,28077,28085,
				28093,28101,28109,28117,28125,28133,28141,28150,28158,28166,
				28174,28182,28190,28198,28206,28214,28222,28230,28238,28246,
				28254,28262,28270,28278,28286,28295,28303,28311,28319,28327,
				28335,28343,28351,28359,28367,28375,28383,28391,28399,28407,
				28415,28423,28431,28439,28448,28456,28464,28472,28480,28488,
				28496,28504,28512,28520,28528,28536,28544,28552,28560,28568,
				28576,28584,28593,28601,28609,28617,28625,28633,28641,28649,
				28657,28665,28673,28681,28689,28697,28705,28713,28721,28729,
				28738,28746,28754,28762,28770,28778,28786,28794,28802,28810,
				28818,28826,28834,28842,28850,28858,28866,28874,28882,28891,
				28899,28907,28915,28923,28931,28939,28947,28955,28963,28971,
				28979,28987,28995,29003,29011,29019,29027,29036,29044,29052,
				29060,29068,29076,29084,29092,29100,29108,29116,29124,29132,
				29140,29148,29156,29164,29172,29181,29189,29197,29205,29213,
				29221,29229,29237,29245,29253,29261,29269,29277,29285,29293,
				29301,29309,29317,29326,29334,29342,29350,29358,29366,29374,
				29382,29390,29398,29406,29414,29422,29430,29438,29446,29454,
				29462,29471,29479,29487,29495,29503,29511,29519,29527,29535,
				29543,29551,29559,29567,29575,29583,29591,29599,29608,29616,
				29624,29632,29640,29648,29656,29664,29672,29680,29688,29696,
				29704,29712,29720,29728,29736,29744,29753,29761,29769,29777,
				29785,29793,29801,29809,29817,29825,29833,29841,29849,29857,
				29865,29873,29881,29889,29898,29906,29914,29922,29930,29938,
				29946,29954,29962,29970,29978,29986,29994,30002,30010,30018,
				30026,30035,30043,30051,30059,30067,30075,30083,30091,30099,
				30107,30115,30123,30131,30139,30147,30155,30163,30172,30180,
				30188,30196,30204,30212,30220,30228,30236,30244,30252,30260,
				30268,30276,30284,30292,30300,30308,30317,30325,30333,30341,
				30349,30357,30365,30373,30381,30389,30397,30405,30413,30421,
				30429,30437,30445,30454,30462,30470,30478,30486,30494,30502,
				30510,30518,30526,30534,30542,30550,30558,30566,30574,30582,
				30591,30599,30607,30615,30623,30631,30639,30647,30655,30663,
				30671,30679,30687,30695,30703,30711,30719,30728,30736,30744,
				30752,30760,30768,30776,30784,30792,30800,30808,30816,30824,
				30832,30840,30848,30856,30865,30873,30881,30889,30897,30905,
				30913,30921,30929,30937,30945,30953,30961,30969,30977,30985,
				30993,31002,31010,31018,31026,31034,31042,31050,31058,31066,
				31074,31082,31090,31098,31106,31114,31122,31130,31139,31147,
				31155,31163,31171,31179,31187,31195,31203,31211,31219,31227,
				31235,31243,31251,31259,31267,31276,31284,31292,31300,31308,
				31316,31324,31332,31340,31348,31356,31364,31372,31380,31388,
				31396,31404,31413,31421,31429,31437,31445,31453,31461,31469,
				31477,31485,31493,31501,31509,31517,31525,31533,31542,31550,
				31558,31566,31574,31582,31590,31598,31606,31614,31622,31630,
				31638,31646,31654,31662,31670,31679,31687,31695,31703,31711,
				31719,31727,31735,31743,31751,31759,31767,31775,31783,31791,
				31799,31808,31816,31824,31832,31840,31848,31856,31864,31872,
				31880,31888,31896,31904,31912,31920,31928,31936,31945,31953,
				31961,31969,31977,31985,31993,32001,32009,32017,32025,32033,
				32041,32049,32057,32065,32074,32082,32090,32098,32106,32114,
				32122,32130,32138,32146,32154,32162,32170,32178,32186,32194,
				32202,32211,32219,32227,32235,32243,32251,32259,32267,32275,
				32283,32291,32299,32307,32315,32323,32331,32340,32348,32356,
				32364,32372,32380,32388,32396,32404,32412,32420,32428,32436,
				32444,32452,32460,32469,32477,32485,32493,32501,32509,32517,
				32525,32533,32541,32549,32557,32565,32573,32581,32589,32598,
				32606,32614,32622,32630,32638,32646,32654,32662,32670,32678,
				32686,32694,32702,32710,32718,32727,32735,32743,32751,32759,
				32767,32775,32783,32791,32799,32807,32815,32823,32831,32839,
				32847,32856,32864,32872,32880,32888,32896,32896,32896,32896,
				32896 };

/*****************************************************************************/
/**
* Look up table for division in Q16 format
*
******************************************************************************/
static unsigned short division_lut[] = {
				65535,65520,65504,65488,65472,65456,65440,65424,65408,65392,
				65376,65360,65344,65328,65312,65296,65280,65265,65249,65233,
				65217,65201,65185,65170,65154,65138,65122,65106,65091,65075,
				65059,65043,65027,65012,64996,64980,64965,64949,64933,64917,
				64902,64886,64870,64855,64839,64823,64808,64792,64776,64761,
				64745,64730,64714,64698,64683,64667,64652,64636,64620,64605,
				64589,64574,64558,64543,64527,64512,64496,64481,64465,64450,
				64434,64419,64403,64388,64373,64357,64342,64326,64311,64295,
				64280,64265,64249,64234,64219,64203,64188,64172,64157,64142,
				64126,64111,64096,64081,64065,64050,64035,64019,64004,63989,
				63974,63958,63943,63928,63913,63897,63882,63867,63852,63837,
				63822,63806,63791,63776,63761,63746,63731,63715,63700,63685,
				63670,63655,63640,63625,63610,63595,63580,63565,63550,63535,
				63519,63504,63489,63474,63459,63444,63429,63414,63399,63384,
				63370,63355,63340,63325,63310,63295,63280,63265,63250,63235,
				63220,63205,63191,63176,63161,63146,63131,63116,63101,63087,
				63072,63057,63042,63027,63013,62998,62983,62968,62953,62939,
				62924,62909,62894,62880,62865,62850,62836,62821,62806,62791,
				62777,62762,62747,62733,62718,62703,62689,62674,62660,62645,
				62630,62616,62601,62586,62572,62557,62543,62528,62514,62499,
				62484,62470,62455,62441,62426,62412,62397,62383,62368,62354,
				62339,62325,62310,62296,62282,62267,62253,62238,62224,62209,
				62195,62181,62166,62152,62137,62123,62109,62094,62080,62066,
				62051,62037,62022,62008,61994,61980,61965,61951,61937,61922,
				61908,61894,61880,61865,61851,61837,61822,61808,61794,61780,
				61766,61751,61737,61723,61709,61695,61680,61666,61652,61638,
				61624,61610,61596,61581,61567,61553,61539,61525,61511,61497,
				61483,61469,61455,61440,61426,61412,61398,61384,61370,61356,
				61342,61328,61314,61300,61286,61272,61258,61244,61230,61216,
				61202,61188,61174,61160,61147,61133,61119,61105,61091,61077,
				61063,61049,61035,61021,61008,60994,60980,60966,60952,60938,
				60924,60911,60897,60883,60869,60855,60842,60828,60814,60800,
				60787,60773,60759,60745,60732,60718,60704,60690,60677,60663,
				60649,60635,60622,60608,60594,60581,60567,60553,60540,60526,
				60512,60499,60485,60472,60458,60444,60431,60417,60404,60390,
				60376,60363,60349,60336,60322,60309,60295,60281,60268,60254,
				60241,60227,60214,60200,60187,60173,60160,60146,60133,60119,
				60106,60093,60079,60066,60052,60039,60025,60012,59998,59985,
				59972,59958,59945,59932,59918,59905,59891,59878,59865,59851,
				59838,59825,59811,59798,59785,59771,59758,59745,59731,59718,
				59705,59692,59678,59665,59652,59639,59625,59612,59599,59586,
				59572,59559,59546,59533,59520,59506,59493,59480,59467,59454,
				59440,59427,59414,59401,59388,59375,59362,59348,59335,59322,
				59309,59296,59283,59270,59257,59244,59231,59218,59204,59191,
				59178,59165,59152,59139,59126,59113,59100,59087,59074,59061,
				59048,59035,59022,59009,58996,58983,58970,58957,58944,58932,
				58919,58906,58893,58880,58867,58854,58841,58828,58815,58802,
				58790,58777,58764,58751,58738,58725,58712,58700,58687,58674,
				58661,58648,58635,58623,58610,58597,58584,58571,58559,58546,
				58533,58520,58508,58495,58482,58469,58457,58444,58431,58419,
				58406,58393,58380,58368,58355,58342,58330,58317,58304,58292,
				58279,58266,58254,58241,58228,58216,58203,58191,58178,58165,
				58153,58140,58128,58115,58102,58090,58077,58065,58052,58040,
				58027,58015,58002,57989,57977,57964,57952,57939,57927,57914,
				57902,57889,57877,57864,57852,57840,57827,57815,57802,57790,
				57777,57765,57752,57740,57728,57715,57703,57690,57678,57666,
				57653,57641,57628,57616,57604,57591,57579,57567,57554,57542,
				57530,57517,57505,57493,57480,57468,57456,57443,57431,57419,
				57407,57394,57382,57370,57358,57345,57333,57321,57309,57296,
				57284,57272,57260,57247,57235,57223,57211,57199,57186,57174,
				57162,57150,57138,57126,57113,57101,57089,57077,57065,57053,
				57041,57028,57016,57004,56992,56980,56968,56956,56944,56932,
				56920,56908,56896,56883,56871,56859,56847,56835,56823,56811,
				56799,56787,56775,56763,56751,56739,56727,56715,56703,56691,
				56679,56667,56655,56643,56631,56620,56608,56596,56584,56572,
				56560,56548,56536,56524,56512,56500,56488,56477,56465,56453,
				56441,56429,56417,56405,56394,56382,56370,56358,56346,56334,
				56323,56311,56299,56287,56275,56263,56252,56240,56228,56216,
				56205,56193,56181,56169,56158,56146,56134,56122,56111,56099,
				56087,56075,56064,56052,56040,56029,56017,56005,55994,55982,
				55970,55959,55947,55935,55924,55912,55900,55889,55877,55865,
				55854,55842,55831,55819,55807,55796,55784,55773,55761,55749,
				55738,55726,55715,55703,55692,55680,55668,55657,55645,55634,
				55622,55611,55599,55588,55576,55565,55553,55542,55530,55519,
				55507,55496,55484,55473,55461,55450,55438,55427,55416,55404,
				55393,55381,55370,55358,55347,55336,55324,55313,55301,55290,
				55279,55267,55256,55245,55233,55222,55210,55199,55188,55176,
				55165,55154,55142,55131,55120,55108,55097,55086,55074,55063,
				55052,55041,55029,55018,55007,54995,54984,54973,54962,54950,
				54939,54928,54917,54906,54894,54883,54872,54861,54849,54838,
				54827,54816,54805,54793,54782,54771,54760,54749,54738,54726,
				54715,54704,54693,54682,54671,54660,54648,54637,54626,54615,
				54604,54593,54582,54571,54560,54548,54537,54526,54515,54504,
				54493,54482,54471,54460,54449,54438,54427,54416,54405,54394,
				54383,54372,54361,54350,54339,54328,54317,54306,54295,54284,
				54273,54262,54251,54240,54229,54218,54207,54196,54185,54174,
				54163,54152,54141,54130,54120,54109,54098,54087,54076,54065,
				54054,54043,54032,54022,54011,54000,53989,53978,53967,53956,
				53946,53935,53924,53913,53902,53891,53881,53870,53859,53848,
				53837,53827,53816,53805,53794,53783,53773,53762,53751,53740,
				53730,53719,53708,53697,53687,53676,53665,53654,53644,53633,
				53622,53612,53601,53590,53579,53569,53558,53547,53537,53526,
				53515,53505,53494,53483,53473,53462,53451,53441,53430,53419,
				53409,53398,53388,53377,53366,53356,53345,53335,53324,53313,
				53303,53292,53282,53271,53261,53250,53239,53229,53218,53208,
				53197,53187,53176,53166,53155,53145,53134,53123,53113,53102,
				53092,53081,53071,53060,53050,53040,53029,53019,53008,52998,
				52987,52977,52966,52956,52945,52935,52924,52914,52904,52893,
				52883,52872,52862,52852,52841,52831,52820,52810,52800,52789,
				52779,52768,52758,52748,52737,52727,52717,52706,52696,52686,
				52675,52665,52655,52644,52634,52624,52613,52603,52593,52582,
				52572,52562,52551,52541,52531,52521,52510,52500,52490,52480,
				52469,52459,52449,52439,52428,52418,52408,52398,52387,52377,
				52367,52357,52347,52336,52326,52316,52306,52296,52285,52275,
				52265,52255,52245,52234,52224,52214,52204,52194,52184,52174,
				52163,52153,52143,52133,52123,52113,52103,52093,52082,52072,
				52062,52052,52042,52032,52022,52012,52002,51992,51982,51972,
				51961,51951,51941,51931,51921,51911,51901,51891,51881,51871,
				51861,51851,51841,51831,51821,51811,51801,51791,51781,51771,
				51761,51751,51741,51731,51721,51711,51701,51691,51681,51671,
				51661,51652,51642,51632,51622,51612,51602,51592,51582,51572,
				51562,51552,51542,51533,51523,51513,51503,51493,51483,51473,
				51463,51453,51444,51434,51424,51414,51404,51394,51385,51375,
				51365,51355,51345,51335,51326,51316,51306,51296,51286,51277,
				51267,51257,51247,51237,51228,51218,51208,51198,51189,51179,
				51169,51159,51150,51140,51130,51120,51111,51101,51091,51081,
				51072,51062,51052,51043,51033,51023,51013,51004,50994,50984,
				50975,50965,50955,50946,50936,50926,50917,50907,50897,50888,
				50878,50868,50859,50849,50840,50830,50820,50811,50801,50791,
				50782,50772,50763,50753,50743,50734,50724,50715,50705,50696,
				50686,50676,50667,50657,50648,50638,50629,50619,50610,50600,
				50590,50581,50571,50562,50552,50543,50533,50524,50514,50505,
				50495,50486,50476,50467,50457,50448,50438,50429,50419,50410,
				50400,50391,50382,50372,50363,50353,50344,50334,50325,50315,
				50306,50297,50287,50278,50268,50259,50249,50240,50231,50221,
				50212,50203,50193,50184,50174,50165,50156,50146,50137,50128,
				50118,50109,50099,50090,50081,50071,50062,50053,50043,50034,
				50025,50015,50006,49997,49987,49978,49969,49960,49950,49941,
				49932,49922,49913,49904,49895,49885,49876,49867,49857,49848,
				49839,49830,49820,49811,49802,49793,49784,49774,49765,49756,
				49747,49737,49728,49719,49710,49701,49691,49682,49673,49664,
				49655,49645,49636,49627,49618,49609,49600,49590,49581,49572,
				49563,49554,49545,49535,49526,49517,49508,49499,49490,49481,
				49472,49462,49453,49444,49435,49426,49417,49408,49399,49390,
				49381,49371,49362,49353,49344,49335,49326,49317,49308,49299,
				49290,49281,49272,49263,49254,49245,49236,49227,49218,49209,
				49200,49191,49182,49173,49164,49155,49146,49137,49128,49119,
				49110,49101,49092,49083,49074,49065,49056,49047,49038,49029,
				49020,49011,49002,48993,48984,48975,48966,48957,48948,48939,
				48930,48922,48913,48904,48895,48886,48877,48868,48859,48850,
				48841,48833,48824,48815,48806,48797,48788,48779,48770,48762,
				48753,48744,48735,48726,48717,48709,48700,48691,48682,48673,
				48664,48656,48647,48638,48629,48620,48611,48603,48594,48585,
				48576,48568,48559,48550,48541,48532,48524,48515,48506,48497,
				48489,48480,48471,48462,48454,48445,48436,48427,48419,48410,
				48401,48392,48384,48375,48366,48358,48349,48340,48331,48323,
				48314,48305,48297,48288,48279,48271,48262,48253,48245,48236,
				48227,48219,48210,48201,48193,48184,48175,48167,48158,48149,
				48141,48132,48123,48115,48106,48098,48089,48080,48072,48063,
				48055,48046,48037,48029,48020,48012,48003,47994,47986,47977,
				47969,47960,47952,47943,47934,47926,47917,47909,47900,47892,
				47883,47875,47866,47857,47849,47840,47832,47823,47815,47806,
				47798,47789,47781,47772,47764,47755,47747,47738,47730,47721,
				47713,47704,47696,47687,47679,47671,47662,47654,47645,47637,
				47628,47620,47611,47603,47594,47586,47578,47569,47561,47552,
				47544,47535,47527,47519,47510,47502,47493,47485,47477,47468,
				47460,47451,47443,47435,47426,47418,47410,47401,47393,47384,
				47376,47368,47359,47351,47343,47334,47326,47318,47309,47301,
				47293,47284,47276,47268,47259,47251,47243,47234,47226,47218,
				47209,47201,47193,47184,47176,47168,47160,47151,47143,47135,
				47127,47118,47110,47102,47093,47085,47077,47069,47060,47052,
				47044,47036,47027,47019,47011,47003,46995,46986,46978,46970,
				46962,46953,46945,46937,46929,46921,46912,46904,46896,46888,
				46880,46871,46863,46855,46847,46839,46831,46822,46814,46806,
				46798,46790,46782,46773,46765,46757,46749,46741,46733,46725,
				46716,46708,46700,46692,46684,46676,46668,46660,46651,46643,
				46635,46627,46619,46611,46603,46595,46587,46579,46571,46562,
				46554,46546,46538,46530,46522,46514,46506,46498,46490,46482,
				46474,46466,46458,46450,46442,46434,46426,46418,46410,46401,
				46393,46385,46377,46369,46361,46353,46345,46337,46329,46321,
				46313,46305,46297,46289,46281,46273,46266,46258,46250,46242,
				46234,46226,46218,46210,46202,46194,46186,46178,46170,46162,
				46154,46146,46138,46130,46122,46115,46107,46099,46091,46083,
				46075,46067,46059,46051,46043,46035,46028,46020,46012,46004,
				45996,45988,45980,45972,45964,45957,45949,45941,45933,45925,
				45917,45909,45902,45894,45886,45878,45870,45862,45855,45847,
				45839,45831,45823,45815,45808,45800,45792,45784,45776,45769,
				45761,45753,45745,45737,45730,45722,45714,45706,45698,45691,
				45683,45675,45667,45660,45652,45644,45636,45629,45621,45613,
				45605,45598,45590,45582,45574,45567,45559,45551,45543,45536,
				45528,45520,45512,45505,45497,45489,45482,45474,45466,45459,
				45451,45443,45435,45428,45420,45412,45405,45397,45389,45382,
				45374,45366,45359,45351,45343,45336,45328,45320,45313,45305,
				45297,45290,45282,45274,45267,45259,45252,45244,45236,45229,
				45221,45213,45206,45198,45191,45183,45175,45168,45160,45153,
				45145,45137,45130,45122,45115,45107,45100,45092,45084,45077,
				45069,45062,45054,45047,45039,45031,45024,45016,45009,45001,
				44994,44986,44979,44971,44964,44956,44949,44941,44933,44926,
				44918,44911,44903,44896,44888,44881,44873,44866,44858,44851,
				44843,44836,44828,44821,44813,44806,44798,44791,44784,44776,
				44769,44761,44754,44746,44739,44731,44724,44716,44709,44701,
				44694,44687,44679,44672,44664,44657,44649,44642,44635,44627,
				44620,44612,44605,44598,44590,44583,44575,44568,44560,44553,
				44546,44538,44531,44524,44516,44509,44501,44494,44487,44479,
				44472,44465,44457,44450,44442,44435,44428,44420,44413,44406,
				44398,44391,44384,44376,44369,44362,44354,44347,44340,44332,
				44325,44318,44310,44303,44296,44288,44281,44274,44267,44259,
				44252,44245,44237,44230,44223,44216,44208,44201,44194,44186,
				44179,44172,44165,44157,44150,44143,44136,44128,44121,44114,
				44107,44099,44092,44085,44078,44070,44063,44056,44049,44041,
				44034,44027,44020,44013,44005,43998,43991,43984,43976,43969,
				43962,43955,43948,43940,43933,43926,43919,43912,43905,43897,
				43890,43883,43876,43869,43862,43854,43847,43840,43833,43826,
				43819,43811,43804,43797,43790,43783,43776,43769,43761,43754,
				43747,43740,43733,43726,43719,43712,43704,43697,43690,43683,
				43676,43669,43662,43655,43648,43640,43633,43626,43619,43612,
				43605,43598,43591,43584,43577,43570,43563,43555,43548,43541,
				43534,43527,43520,43513,43506,43499,43492,43485,43478,43471,
				43464,43457,43450,43443,43436,43429,43422,43415,43408,43401,
				43394,43387,43380,43372,43365,43358,43351,43344,43337,43330,
				43323,43317,43310,43303,43296,43289,43282,43275,43268,43261,
				43254,43247,43240,43233,43226,43219,43212,43205,43198,43191,
				43184,43177,43170,43163,43156,43149,43142,43136,43129,43122,
				43115,43108,43101,43094,43087,43080,43073,43066,43059,43053,
				43046,43039,43032,43025,43018,43011,43004,42997,42990,42984,
				42977,42970,42963,42956,42949,42942,42935,42929,42922,42915,
				42908,42901,42894,42887,42881,42874,42867,42860,42853,42846,
				42840,42833,42826,42819,42812,42805,42799,42792,42785,42778,
				42771,42764,42758,42751,42744,42737,42730,42724,42717,42710,
				42703,42696,42690,42683,42676,42669,42662,42656,42649,42642,
				42635,42629,42622,42615,42608,42602,42595,42588,42581,42575,
				42568,42561,42554,42548,42541,42534,42527,42521,42514,42507,
				42500,42494,42487,42480,42473,42467,42460,42453,42447,42440,
				42433,42426,42420,42413,42406,42400,42393,42386,42380,42373,
				42366,42360,42353,42346,42339,42333,42326,42319,42313,42306,
				42299,42293,42286,42279,42273,42266,42259,42253,42246,42240,
				42233,42226,42220,42213,42206,42200,42193,42186,42180,42173,
				42167,42160,42153,42147,42140,42133,42127,42120,42114,42107,
				42100,42094,42087,42081,42074,42067,42061,42054,42048,42041,
				42034,42028,42021,42015,42008,42002,41995,41988,41982,41975,
				41969,41962,41956,41949,41943,41936,41929,41923,41916,41910,
				41903,41897,41890,41884,41877,41871,41864,41858,41851,41844,
				41838,41831,41825,41818,41812,41805,41799,41792,41786,41779,
				41773,41766,41760,41753,41747,41740,41734,41727,41721,41714,
				41708,41701,41695,41688,41682,41676,41669,41663,41656,41650,
				41643,41637,41630,41624,41617,41611,41604,41598,41592,41585,
				41579,41572,41566,41559,41553,41547,41540,41534,41527,41521,
				41514,41508,41502,41495,41489,41482,41476,41470,41463,41457,
				41450,41444,41438,41431,41425,41418,41412,41406,41399,41393,
				41386,41380,41374,41367,41361,41355,41348,41342,41335,41329,
				41323,41316,41310,41304,41297,41291,41285,41278,41272,41266,
				41259,41253,41246,41240,41234,41227,41221,41215,41209,41202,
				41196,41190,41183,41177,41171,41164,41158,41152,41145,41139,
				41133,41126,41120,41114,41108,41101,41095,41089,41082,41076,
				41070,41064,41057,41051,41045,41038,41032,41026,41020,41013,
				41007,41001,40995,40988,40982,40976,40970,40963,40957,40951,
				40945,40938,40932,40926,40920,40913,40907,40901,40895,40888,
				40882,40876,40870,40863,40857,40851,40845,40839,40832,40826,
				40820,40814,40808,40801,40795,40789,40783,40777,40770,40764,
				40758,40752,40746,40739,40733,40727,40721,40715,40709,40702,
				40696,40690,40684,40678,40672,40665,40659,40653,40647,40641,
				40635,40628,40622,40616,40610,40604,40598,40592,40585,40579,
				40573,40567,40561,40555,40549,40543,40536,40530,40524,40518,
				40512,40506,40500,40494,40488,40481,40475,40469,40463,40457,
				40451,40445,40439,40433,40427,40420,40414,40408,40402,40396,
				40390,40384,40378,40372,40366,40360,40354,40348,40341,40335,
				40329,40323,40317,40311,40305,40299,40293,40287,40281,40275,
				40269,40263,40257,40251,40245,40239,40233,40227,40221,40215,
				40209,40203,40196,40190,40184,40178,40172,40166,40160,40154,
				40148,40142,40136,40130,40124,40118,40112,40106,40100,40094,
				40088,40082,40076,40070,40064,40059,40053,40047,40041,40035,
				40029,40023,40017,40011,40005,39999,39993,39987,39981,39975,
				39969,39963,39957,39951,39945,39939,39933,39927,39921,39916,
				39910,39904,39898,39892,39886,39880,39874,39868,39862,39856,
				39850,39844,39839,39833,39827,39821,39815,39809,39803,39797,
				39791,39785,39780,39774,39768,39762,39756,39750,39744,39738,
				39732,39727,39721,39715,39709,39703,39697,39691,39685,39680,
				39674,39668,39662,39656,39650,39644,39639,39633,39627,39621,
				39615,39609,39603,39598,39592,39586,39580,39574,39568,39563,
				39557,39551,39545,39539,39533,39528,39522,39516,39510,39504,
				39499,39493,39487,39481,39475,39469,39464,39458,39452,39446,
				39441,39435,39429,39423,39417,39412,39406,39400,39394,39388,
				39383,39377,39371,39365,39360,39354,39348,39342,39336,39331,
				39325,39319,39313,39308,39302,39296,39290,39285,39279,39273,
				39267,39262,39256,39250,39244,39239,39233,39227,39222,39216,
				39210,39204,39199,39193,39187,39181,39176,39170,39164,39159,
				39153,39147,39141,39136,39130,39124,39119,39113,39107,39102,
				39096,39090,39084,39079,39073,39067,39062,39056,39050,39045,
				39039,39033,39028,39022,39016,39011,39005,38999,38994,38988,
				38982,38977,38971,38965,38960,38954,38948,38943,38937,38931,
				38926,38920,38914,38909,38903,38898,38892,38886,38881,38875,
				38869,38864,38858,38853,38847,38841,38836,38830,38824,38819,
				38813,38808,38802,38796,38791,38785,38780,38774,38768,38763,
				38757,38752,38746,38740,38735,38729,38724,38718,38712,38707,
				38701,38696,38690,38685,38679,38673,38668,38662,38657,38651,
				38646,38640,38634,38629,38623,38618,38612,38607,38601,38596,
				38590,38584,38579,38573,38568,38562,38557,38551,38546,38540,
				38535,38529,38524,38518,38512,38507,38501,38496,38490,38485,
				38479,38474,38468,38463,38457,38452,38446,38441,38435,38430,
				38424,38419,38413,38408,38402,38397,38391,38386,38380,38375,
				38369,38364,38358,38353,38347,38342,38336,38331,38326,38320,
				38315,38309,38304,38298,38293,38287,38282,38276,38271,38265,
				38260,38255,38249,38244,38238,38233,38227,38222,38216,38211,
				38206,38200,38195,38189,38184,38178,38173,38167,38162,38157,
				38151,38146,38140,38135,38130,38124,38119,38113,38108,38102,
				38097,38092,38086,38081,38075,38070,38065,38059,38054,38048,
				38043,38038,38032,38027,38022,38016,38011,38005,38000,37995,
				37989,37984,37978,37973,37968,37962,37957,37952,37946,37941,
				37936,37930,37925,37919,37914,37909,37903,37898,37893,37887,
				37882,37877,37871,37866,37861,37855,37850,37845,37839,37834,
				37829,37823,37818,37813,37807,37802,37797,37791,37786,37781,
				37775,37770,37765,37759,37754,37749,37744,37738,37733,37728,
				37722,37717,37712,37706,37701,37696,37691,37685,37680,37675,
				37669,37664,37659,37654,37648,37643,37638,37632,37627,37622,
				37617,37611,37606,37601,37596,37590,37585,37580,37574,37569,
				37564,37559,37553,37548,37543,37538,37532,37527,37522,37517,
				37511,37506,37501,37496,37490,37485,37480,37475,37470,37464,
				37459,37454,37449,37443,37438,37433,37428,37423,37417,37412,
				37407,37402,37396,37391,37386,37381,37376,37370,37365,37360,
				37355,37350,37344,37339,37334,37329,37324,37318,37313,37308,
				37303,37298,37293,37287,37282,37277,37272,37267,37262,37256,
				37251,37246,37241,37236,37230,37225,37220,37215,37210,37205,
				37200,37194,37189,37184,37179,37174,37169,37163,37158,37153,
				37148,37143,37138,37133,37128,37122,37117,37112,37107,37102,
				37097,37092,37086,37081,37076,37071,37066,37061,37056,37051,
				37046,37040,37035,37030,37025,37020,37015,37010,37005,37000,
				36994,36989,36984,36979,36974,36969,36964,36959,36954,36949,
				36944,36938,36933,36928,36923,36918,36913,36908,36903,36898,
				36893,36888,36883,36878,36873,36867,36862,36857,36852,36847,
				36842,36837,36832,36827,36822,36817,36812,36807,36802,36797,
				36792,36787,36782,36777,36771,36766,36761,36756,36751,36746,
				36741,36736,36731,36726,36721,36716,36711,36706,36701,36696,
				36691,36686,36681,36676,36671,36666,36661,36656,36651,36646,
				36641,36636,36631,36626,36621,36616,36611,36606,36601,36596,
				36591,36586,36581,36576,36571,36566,36561,36556,36551,36546,
				36541,36536,36531,36526,36521,36516,36511,36506,36501,36497,
				36492,36487,36482,36477,36472,36467,36462,36457,36452,36447,
				36442,36437,36432,36427,36422,36417,36412,36407,36402,36398,
				36393,36388,36383,36378,36373,36368,36363,36358,36353,36348,
				36343,36338,36333,36329,36324,36319,36314,36309,36304,36299,
				36294,36289,36284,36279,36275,36270,36265,36260,36255,36250,
				36245,36240,36235,36230,36226,36221,36216,36211,36206,36201,
				36196,36191,36187,36182,36177,36172,36167,36162,36157,36152,
				36148,36143,36138,36133,36128,36123,36118,36114,36109,36104,
				36099,36094,36089,36084,36080,36075,36070,36065,36060,36055,
				36050,36046,36041,36036,36031,36026,36021,36017,36012,36007,
				36002,35997,35992,35988,35983,35978,35973,35968,35964,35959,
				35954,35949,35944,35939,35935,35930,35925,35920,35915,35911,
				35906,35901,35896,35891,35887,35882,35877,35872,35867,35863,
				35858,35853,35848,35843,35839,35834,35829,35824,35820,35815,
				35810,35805,35800,35796,35791,35786,35781,35777,35772,35767,
				35762,35758,35753,35748,35743,35738,35734,35729,35724,35719,
				35715,35710,35705,35700,35696,35691,35686,35681,35677,35672,
				35667,35663,35658,35653,35648,35644,35639,35634,35629,35625,
				35620,35615,35610,35606,35601,35596,35592,35587,35582,35577,
				35573,35568,35563,35559,35554,35549,35544,35540,35535,35530,
				35526,35521,35516,35512,35507,35502,35497,35493,35488,35483,
				35479,35474,35469,35465,35460,35455,35451,35446,35441,35437,
				35432,35427,35422,35418,35413,35408,35404,35399,35394,35390,
				35385,35380,35376,35371,35366,35362,35357,35353,35348,35343,
				35339,35334,35329,35325,35320,35315,35311,35306,35301,35297,
				35292,35287,35283,35278,35274,35269,35264,35260,35255,35250,
				35246,35241,35236,35232,35227,35223,35218,35213,35209,35204,
				35200,35195,35190,35186,35181,35176,35172,35167,35163,35158,
				35153,35149,35144,35140,35135,35130,35126,35121,35117,35112,
				35107,35103,35098,35094,35089,35085,35080,35075,35071,35066,
				35062,35057,35052,35048,35043,35039,35034,35030,35025,35020,
				35016,35011,35007,35002,34998,34993,34988,34984,34979,34975,
				34970,34966,34961,34957,34952,34947,34943,34938,34934,34929,
				34925,34920,34916,34911,34907,34902,34898,34893,34888,34884,
				34879,34875,34870,34866,34861,34857,34852,34848,34843,34839,
				34834,34830,34825,34821,34816,34812,34807,34802,34798,34793,
				34789,34784,34780,34775,34771,34766,34762,34757,34753,34748,
				34744,34739,34735,34730,34726,34721,34717,34712,34708,34704,
				34699,34695,34690,34686,34681,34677,34672,34668,34663,34659,
				34654,34650,34645,34641,34636,34632,34627,34623,34618,34614,
				34610,34605,34601,34596,34592,34587,34583,34578,34574,34569,
				34565,34561,34556,34552,34547,34543,34538,34534,34529,34525,
				34521,34516,34512,34507,34503,34498,34494,34489,34485,34481,
				34476,34472,34467,34463,34458,34454,34450,34445,34441,34436,
				34432,34428,34423,34419,34414,34410,34405,34401,34397,34392,
				34388,34383,34379,34375,34370,34366,34361,34357,34353,34348,
				34344,34339,34335,34331,34326,34322,34318,34313,34309,34304,
				34300,34296,34291,34287,34282,34278,34274,34269,34265,34261,
				34256,34252,34247,34243,34239,34234,34230,34226,34221,34217,
				34213,34208,34204,34199,34195,34191,34186,34182,34178,34173,
				34169,34165,34160,34156,34152,34147,34143,34139,34134,34130,
				34126,34121,34117,34113,34108,34104,34100,34095,34091,34087,
				34082,34078,34074,34069,34065,34061,34056,34052,34048,34043,
				34039,34035,34030,34026,34022,34017,34013,34009,34004,34000,
				33996,33992,33987,33983,33979,33974,33970,33966,33961,33957,
				33953,33949,33944,33940,33936,33931,33927,33923,33919,33914,
				33910,33906,33901,33897,33893,33889,33884,33880,33876,33871,
				33867,33863,33859,33854,33850,33846,33842,33837,33833,33829,
				33825,33820,33816,33812,33807,33803,33799,33795,33790,33786,
				33782,33778,33773,33769,33765,33761,33756,33752,33748,33744,
				33740,33735,33731,33727,33723,33718,33714,33710,33706,33701,
				33697,33693,33689,33684,33680,33676,33672,33668,33663,33659,
				33655,33651,33646,33642,33638,33634,33630,33625,33621,33617,
				33613,33609,33604,33600,33596,33592,33588,33583,33579,33575,
				33571,33567,33562,33558,33554,33550,33546,33541,33537,33533,
				33529,33525,33520,33516,33512,33508,33504,33499,33495,33491,
				33487,33483,33479,33474,33470,33466,33462,33458,33454,33449,
				33445,33441,33437,33433,33429,33424,33420,33416,33412,33408,
				33404,33399,33395,33391,33387,33383,33379,33375,33370,33366,
				33362,33358,33354,33350,33346,33341,33337,33333,33329,33325,
				33321,33317,33312,33308,33304,33300,33296,33292,33288,33283,
				33279,33275,33271,33267,33263,33259,33255,33251,33246,33242,
				33238,33234,33230,33226,33222,33218,33213,33209,33205,33201,
				33197,33193,33189,33185,33181,33177,33172,33168,33164,33160,
				33156,33152,33148,33144,33140,33136,33131,33127,33123,33119,
				33115,33111,33107,33103,33099,33095,33091,33087,33082,33078,
				33074,33070,33066,33062,33058,33054,33050,33046,33042,33038,
				33034,33030,33026,33021,33017,33013,33009,33005,33001,32997,
				32993,32989,32985,32981,32977,32973,32969,32965,32961,32957,
				32953,32948,32944,32940,32936,32932,32928,32924,32920,32916,
				32912,32908,32904,32900,32896,32892,32888,32884,32880,32876,
				32872,32868,32864,32860,32856,32852,32848,32844,32840,32836,
				32832,32828,32824,32820,32816,32812,32808,32804,32800,32796,
				32792,32788,32784,32780,32776,32772,32772 };

/*****************************************************************************/
/**
* This function computes exponental of positive values e^x represented in Q12 format
*
* @param  gval, positive short value of x represented in Q12 format
*
* @return returns positive integer of fixed point format of Q22 format
*
******************************************************************************/
//exp_pos_int_lut --> Q10
//exp_pos_fract_lut1 --> Q14
//exp_pos_fract_lut2 --> Q22
unsigned int XVWarpInit_ExponentialPos(unsigned short gval) {
	unsigned int fract, fract1;
	unsigned short int_val;
	unsigned long long fract_part, t_val;
	unsigned int exp_val;
	unsigned int val = gval;

	val <<= 12;

	if (val > 115762790) //6.9 * 2 ^ 24
		return 1692103002; //e^6

	int_val = val >> 24; //int part
	fract = val & 0xffffff;
	fract1 = fract >> 17;
	fract = ((fract & 0x1ffff) + 16) >> 5;

	fract_part = exp_pos_fract_lut2[fract];
	t_val = exp_pos_fract_lut1[fract1];
	fract_part *= t_val;//22+14
	fract_part += (t_val << 22);
	fract_part *= exp_pos_int_lut[int_val];//36+10
	exp_val = fract_part >> 24;//46-24= 22

	return exp_val;
}

/*****************************************************************************/
/**
* This function computes exponental of negative values e^-x represented in Q12 format
*
* @param  gval, positive short value of -x represented in Q12 format
*
* @return returns positive integer of fixed point format of Q31 format
*
******************************************************************************/
//exp_neg_int_lut --> Q17 (but within 16bits)
//exp_neg_fract_lut1 --> Q16
//exp_neg_fract_lut2 --> Q22
unsigned int XVWarpInit_ExponentialNeg(unsigned short gval) {
	unsigned int fract, fract1;
	unsigned short int_val;
	unsigned long long fract_part, t_val;
	unsigned int exp_val;
	unsigned int val = gval;

	val <<= 12;

	if (val > 184549376) //11 * 2^24
		return 1;

	int_val = (val >> 24) + 1; //int part
	fract = (int_val << 24) - val;

	fract1 = fract >> 17;
	fract = ((fract & 0x1ffff) + 16) >> 5;

	fract_part = exp_pos_fract_lut2[fract];
	t_val = exp_pos_fract_lut1[fract1];
	fract_part *= t_val;//22+14
	fract_part += (t_val << 22);
	fract_part *= exp_neg_int_lut[int_val];//36+17
	exp_val = fract_part >> 22;//53-22 = 31

	return exp_val;
}

/*****************************************************************************/
/**
* This function computes exponental of fractional number given in fixed point value
*
* @param  exp_value, integer value for calculating e^x. x is Q_fact fixed point format
* @param  k_type, exp_value type +ve or -ve.
* @param  Q_fact, fixed point format.
*
* @return Q_exp, return fixed point format.
* @return returns positive integer of fixed point format of Q_exp
*
******************************************************************************/
unsigned int XVWarpInit_ExponentialFact(unsigned exp_value, short k_type,
		unsigned int Q_fact, char *Q_exp) {
	unsigned int fract, exp_factor;
	unsigned short part1, part2;
	unsigned long long ul_temp_64;
	unsigned short int_val;

	if (k_type < 0) {
		if (exp_value > 115762790) //6.9 * 2 ^ 24
			exp_value = 115762790; //e^6
		int_val = exp_value >> 24; //int part
		fract = exp_value & 0xffffff;
	}
	else {
		if (exp_value > 184549376) //11 * 2^24
			exp_value = 184549376;
		int_val = (exp_value >> 24) + 1; //int part
		fract = (int_val << 24) - exp_value;
	}

	exp_factor = fract >> 17;
	fract = ((fract & 0x1ffff) + 16) >> 5;

	part2 = exp_pos_fract_lut2[fract];
	part1 = exp_pos_fract_lut1[exp_factor];
	ul_temp_64 = ((part1 * part2) >> 6) + (((unsigned int)part1) << 16);//Q30

	if (k_type < 0) {
		ul_temp_64 *= exp_pos_int_lut[int_val];//Q30 * Q10 = Q40
		exp_factor = ul_temp_64 >> 18;//Q22
		exp_factor = exp_factor - Q_fact;
		*Q_exp = 22;
	}
	else {
		ul_temp_64 *= exp_neg_int_lut[int_val];//Q30 * Q17 = Q47
		exp_factor = ul_temp_64 >> 16;//Q31
		exp_factor = Q_fact - exp_factor;
		*Q_exp = 31;
	}

	return exp_factor;
}

/*****************************************************************************/
/**
* This function counts leading zeros in given positive integer
*
* @param  val, integer value
*
* @return returns number of leading zeros
*
******************************************************************************/
unsigned char XVWarpInit_DominantBit(unsigned int val) {
	unsigned char cnt = 0;
#if USE_BUILTIN_CLZ
	if (val)
		cnt = (32 - __builtin_clz(val));

	return cnt;
#else
	int tmp, block;
	unsigned short x, x1;

	if (!val)
		return 0;

	block = 0;
	if (val >> 16) {
		x = val >> 24;
		if (x) {
			x1 = (x >> 4) & 0x000F;
			if (x1) {
				block = 7;
				tmp = 3;
				while (!(x1 >> tmp) && tmp)
					tmp--;
			}
			else {
				block = 6;
				tmp = 3;
				while (!(x >> tmp) && tmp)
					tmp--;
			}
		}
		else {
			x1 = (val >> 20) & 0x000F;
			if (x1) {
				block = 5;
				tmp = 3;
				while (!(x1 >> tmp) && tmp)
					tmp--;
			}
			else {
				x1 = (val >> 16) & 0x000F;
				block = 4;
				tmp = 3;
				while (!(x1 >> tmp) && tmp)
					tmp--;
			}
		}
		cnt = 4 * block + tmp + 1;
	}
	else {
		x = val >> 8;
		if (x) {
			x1 = (x >> 4) & 0x000F;
			if (x1) {
				block = 3;
				tmp = 3;
				while (!(x1 >> tmp) && tmp)
					tmp--;
			}
			else {
				block = 2;
				tmp = 3;
				while (!(x >> tmp) && tmp)
					tmp--;
			}
		}
		else {
			x1 = (val >> 4) & 0x000F;
			if (x1) {
				block = 1;
				tmp = 3;
				while (!(x1 >> tmp) && tmp)
					tmp--;
			}
			else {
				//x1 = (val >> 16) & 0x000F;
				block = 0;
				tmp = 3;
				while (!(val >> tmp) && tmp)
					tmp--;
			}
		}
	}

	cnt = 4 * block + tmp + 1;

	return cnt;
#endif
}

/*****************************************************************************/
/**
* This function computes inverse of positive short
*
* @param  x, integer value for calculating 1/x. x is QM.(16-M) fixed point format
* @param  M, integer part of the value x.
*
* @return N, Fractional bits in return value.
* @return returns inverse of value x in Q(16-N).N fixed point format
*
******************************************************************************/
unsigned short XVWarpInit_Inverse(unsigned short x, int M, char* N) {
	//assert((M <= 16) && "Integer part of x should always be less than or equal to 16 bits.");
	unsigned short val = 0;
	unsigned int index;
	int B_L;

	if (x == 0) {
		val = division_lut[0];
		*N = 16;
	}
	else {
		B_L = 17 - XVWarpInit_DominantBit(x);
		index = (((x << (B_L - 1)) & 0x7FFF) + 4) >> (INV_BIT_SHIFT);

		val = division_lut[index];
		*N = M + DATA_SIZE - B_L;
	}
	return val;
}

/*****************************************************************************/
/**
* This function computes sqaure root of positive integer
*
* @param  v, integer value for calculating square root.
*
* @return square root of input v
*
******************************************************************************/
unsigned int XVWarpInit_Sqrt(unsigned int v)
{
	unsigned int t, q, b, r, i;
	r = v;
	b = 0x40000000;
	q = 0;
	for(i=0; i < 16; i++)
	{
		t = q + b;
		q >>= 1;
		if (r >= t)
		{
			r -= t;
			q += b;
		}
		b >>= 2;
	}
	return q;
}
