/******************************************************************************
* Copyright (C) 2018 – 2022 Xilinx, Inc.  All rights reserved.
* Copyright 2022-2023 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************/
/**
*
* @file rc21008adrv.h
*
* This file contains the Xilinx Menu implementation as used
* in the HDMI example design. Please see xhdmi_menu.h for more details.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who  Date       Changes
* ----- ---- ---------- --------------------------------------------------
* X.X   ..   DD-MM-YYYY ..
* 1.0   ssh  25-01-2023 Initial version
*
* </pre>
*
******************************************************************************/

/***************************** Include Files *********************************/
#include "xparameters.h"

#if defined (XPS_BOARD_VEK280_ES) || \
	defined (XPS_BOARD_VEK280_ES_REVB)
#define XPS_BOARD_VEK280
#endif

#if defined (XPS_BOARD_VEK280)
#ifndef RC21008A_H
/**  prevent circular inclusions by using protection macros */
#define RC21008A_H
#include "xil_types.h"
#include "xil_assert.h"
#include "xstatus.h"
#include "sleep.h"
#include <stdlib.h>
#if defined (XPS_BOARD_ZCU102) || \
	defined (XPS_BOARD_ZCU104) || \
	defined (XPS_BOARD_ZCU106) || \
    defined (XPS_BOARD_VCK190) || \
	defined (XPS_BOARD_VEK280)
#include "xiicps.h"
#else
#include "xiic.h"
#endif

/************************** Constant Definitions *****************************/
#define RC21008A_REVD_CONFIG_NUM_REGS				70

/**************************** Type Definitions *******************************/
typedef struct
{
	unsigned int address; /* 16-bit register address */
	unsigned int bytecount; /*8-bit register bytecount */
	unsigned char value; /* 8-bit register data */
	unsigned char value1; /* 8-bit register data */
	unsigned char value2; /* 8-bit register data */
	unsigned char value3; /* 8-bit register data */
	unsigned char value4; /* 8-bit register data */
	unsigned char value5; /* 8-bit register data */
	unsigned char value6; /* 8-bit register data */
	unsigned char value7; /* 8-bit register data */
	unsigned char value8; /* 8-bit register data */
	unsigned char value9; /* 8-bit register data */
	unsigned char value10; /* 8-bit register data */
	unsigned char value11; /* 8-bit register data */
	unsigned char value12; /* 8-bit register data */
	unsigned char value13; /* 8-bit register data */
	unsigned char value14; /* 8-bit register data */
	unsigned char value15; /* 8-bit register data */


} rc21008a_revd;

rc21008a_revd static const rc21008a_revd_registers[RC21008A_REVD_CONFIG_NUM_REGS] =
{

		/* Start configuration registers */
		{0x00FC, 0x04, 0x00, 0x00, 0x00, 0x00},
		{0x0000, 0x10, 0x33, 0x10, 0x00, 0x00, 0x22, 0x01, 0x30, 0x01, 0x2A, 0xF0, 0x12, 0x00, 0x00, 0x00, 0x01, 0x00},
		{0x0010, 0x10, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x05, 0x80, 0x80, 0x00, 0x8C, 0x03, 0x00, 0x00, 0x00, 0x00},
		{0x0020, 0x06, 0x00, 0x03, 0x22, 0x09, 0x08, 0x79},
		{0x0027, 0x10, 0x00, 0xB2, 0x00, 0x00, 0x00, 0x45, 0x19, 0x59, 0x20, 0x01, 0x80, 0x00, 0x00, 0x01, 0x80, 0x00},
		{0x0037, 0x10, 0x00, 0x02, 0x00, 0x50, 0x00, 0x02, 0x00, 0x50, 0x00, 0x02, 0x00, 0x50, 0x00, 0x02, 0x00, 0x50},
		{0x0047, 0x10, 0x00, 0x0B, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0057, 0x10, 0x00, 0x44, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0067, 0x10, 0x00, 0x44, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0077, 0x10, 0x00, 0x44, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0087, 0x10, 0x00, 0x44, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0097, 0x10, 0x00, 0x44, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00},
		{0x00A7, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xFF},
		{0x00B7, 0x10, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00},
		{0x00C7, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xFF},
		{0x00D7, 0x10, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00},
		{0x00E7, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xFF},
		{0x00F7, 0x09, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x00FC, 0x04, 0x00, 0x01, 0x00, 0x00},
		{0x0000, 0x10, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0010, 0x10, 0x01, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0020, 0x10, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x01, 0x55, 0x00, 0x37, 0xB7, 0x05, 0x1B, 0x05, 0x00},
		{0x0030, 0x10, 0x0F, 0x09, 0x80, 0x01, 0x64, 0x00, 0xF7, 0x5F, 0x40, 0x5A, 0x42, 0x00, 0x20, 0x7A, 0x00, 0x00},
		{0x0040, 0x10, 0x00, 0x00, 0x25, 0x01, 0x01, 0x00, 0x00, 0x00, 0x90, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0050, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0060, 0x10, 0x4A, 0x1E, 0x5C, 0x8F, 0x22, 0x81, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0070, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0080, 0x10, 0x04, 0x81, 0x36, 0x00, 0x00, 0x38, 0x42, 0x5B, 0x10, 0x11, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x1F},
		{0x0090, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x00A0, 0x10, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x01, 0x00, 0x00, 0x55, 0x01, 0xFF, 0x00},
		{0x00B0, 0x10, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x00C0, 0x10, 0x64, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00},
		{0x00D0, 0x10, 0x2C, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x00E0, 0x10, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x00F0, 0x10, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x00FC, 0x04, 0x00, 0x02, 0x00, 0x00},
		{0x0000, 0x10, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0010, 0x10, 0x68, 0x98, 0x0A, 0x80, 0x00, 0x6F, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0020, 0x10, 0x68, 0x98, 0x0A, 0x80, 0x00, 0x6F, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0030, 0x10, 0x68, 0x98, 0x0A, 0x80, 0x00, 0x6F, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0040, 0x10, 0x87, 0x00, 0x3C, 0x00, 0x06, 0x00, 0x3E, 0x00, 0x06, 0x00, 0x3E, 0x00, 0x06, 0x00, 0x3E, 0x00},
		{0x0050, 0x10, 0x06, 0x00, 0x3C, 0x00, 0x06, 0x00, 0x3C, 0x00, 0x06, 0x00, 0x3E, 0x00, 0x06, 0x00, 0x3E, 0x00},
		{0x0060, 0x10, 0x06, 0x00, 0x3E, 0x00, 0x06, 0x00, 0x3C, 0x00, 0x06, 0x00, 0x3F, 0x04, 0x06, 0x00, 0x3F, 0x04},
		{0x0070, 0x10, 0x04, 0x0A, 0x80, 0x25, 0xC2, 0x61, 0x09, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0080, 0x10, 0x25, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00},
		{0x0090, 0x10, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00},
		{0x00A0, 0x10, 0x90, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x90, 0x04, 0x00, 0x00},
		{0x00B0, 0x10, 0x90, 0x04, 0x00, 0x00, 0x90, 0x04, 0x00, 0x00, 0x90, 0x04, 0x00, 0x00, 0x90, 0x04, 0x00, 0x00},
		{0x00C0, 0x10, 0x00, 0x00, 0xC0, 0x03, 0x0D, 0x07, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00},
		{0x00D0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x00E0, 0x10, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x00F0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x00FC, 0x04, 0x00, 0x03, 0x00, 0x00},
		{0x0000, 0x00, 0x8C, 0x2B, 0x51, 0x00, 0x8C, 0x2B, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0010, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0020, 0x10, 0x2C, 0x1D, 0x00, 0x00, 0x30, 0xC0, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0030, 0x10, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0xD0, 0x03, 0x1A, 0xA6, 0x08, 0x24, 0x24, 0x00, 0x24, 0x00},
		{0x0040, 0x10, 0x00, 0x11, 0x20, 0x12, 0x0B, 0x10, 0x02, 0x30, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0xD3, 0x9A},
		{0x0050, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0060, 0x10, 0x00, 0x00, 0x88, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0070, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x0080, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		{0x00FC, 0x04, 0x00, 0x01, 0x00, 0x00},
		{0x003C, 0x02, 0x20, 0x7A},
		{0x003C, 0x02, 0x20, 0x7A},
		{0x003C, 0x02, 0x20, 0x7A},
		{0x003C, 0x02, 0x20, 0x7A},
		{0x003C, 0x02, 0xA0, 0x7A},
		{0x003C, 0x02, 0x20, 0x7A},
		{0x00FC, 0x04, 0x00, 0x00, 0x00, 0x00},

};


/***************** Macros (Inline Functions) Definitions *********************/

/************************** Function Prototypes ******************************/
int RC21008A_Init(void *IicPtr, u8 I2CSlaveAddress);

/************************** Variable Declarations ****************************/

#endif
#endif /* RC21008A_H */
