/******************************************************************************
* Copyright (C) 2025 Advanced Micro Devices, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************/
/**
 *
 * @file xdc_hw.h
 *
 * @note	None.
 *
 * <pre>
 * MODIFICATION HISTORY:
 *
 * Ver	Who   Date     Changes
 * ---- ----- -------- ----------------------------------------------------
 * 1.0  ck   03/14/25  Initial Release.
 * </pre>
 *
 *****************************************************************************/

#ifndef XDCHW_H_
/* Prevent circular inclusions by using protection macros. */
#define XDCHW_H_

#ifdef __cplusplus
extern "C" {
#endif

/***************************** Include Files **********************************/

#include "xil_io.h"

/************************** Constant Definitions ******************************/
#define XDC_PL_CLK              0x0
#define XDC_PS_CLK              0x1

#define XDC_NUM_SUPPORTED	121

#define XDC_BUF_4BIT_SF 	0x11111
#define XDC_BUF_5BIT_SF 	0x10842
#define XDC_BUF_6BIT_SF 	0x10410
#define XDC_BUF_8BIT_SF		0x10101
#define XDC_BUF_10BIT_SF	0x10040
#define XDC_BUF_12BIT_SF 	0x10000

/******************************************************************************/
/**
 * Address mapping for DC.
 */
/******************************************************************************/
/** @name DC registers
 *  @{
 */

#define XDC_BASEADDR	0xEDD08000

/**
 *  * Register: XDC_V_BLEND_BG_CLR_0
 *   */
#define XDC_V_BLEND_BG_CLR_0         0x0000A000

#define XDC_V_BLEND_BG_CLR_0_CLR0_SHIFT   0
#define XDC_V_BLEND_BG_CLR_0_CLR0_WIDTH   12
#define XDC_V_BLEND_BG_CLR_0_CLR0_MASK    0x00000FFF

/**
 *  * Register: XDC_V_BLEND_BG_CLR_1
 *   */
#define XDC_V_BLEND_BG_CLR_1         0x0000A004

#define XDC_V_BLEND_BG_CLR_1_CLR1_SHIFT   0
#define XDC_V_BLEND_BG_CLR_1_CLR1_WIDTH   12
#define XDC_V_BLEND_BG_CLR_1_CLR1_MASK    0x00000FFF

/**
 *  * Register: XDC_V_BLEND_BG_CLR_2
 *   */
#define XDC_V_BLEND_BG_CLR_2         0x0000A008

#define XDC_V_BLEND_BG_CLR_2_CLR2_SHIFT   0
#define XDC_V_BLEND_BG_CLR_2_CLR2_WIDTH   12
#define XDC_V_BLEND_BG_CLR_2_CLR2_MASK    0x00000FFF

/**
 *  * Register: XDC_V_BLEND_SET_GLOBAL_ALPHA_REG
 *   */
#define XDC_V_BLEND_SET_GLOBAL_ALPHA_REG         0x0000A00C

#define XDC_V_BLEND_SET_GLOBAL_ALPHA_REG_VALUE_SHIFT   1
#define XDC_V_BLEND_SET_GLOBAL_ALPHA_REG_VALUE_WIDTH   8
#define XDC_V_BLEND_SET_GLOBAL_ALPHA_REG_VALUE_MASK    0x000001FE

#define XDC_V_BLEND_SET_GLOBAL_ALPHA_REG_EN_SHIFT   0
#define XDC_V_BLEND_SET_GLOBAL_ALPHA_REG_EN_WIDTH   1
#define XDC_V_BLEND_SET_GLOBAL_ALPHA_REG_EN_MASK    0x00000001

/**
 *  * Register: XDC_V_BLEND_OUTPUT_VID_FORMAT
 *   */
#define XDC_V_BLEND_OUTPUT_VID_FORMAT         0x0000A014

#define XDC_V_BLEND_OUTPUT_VID_FORMAT_EN_DOWNSAMPLE_SHIFT   4
#define XDC_V_BLEND_OUTPUT_VID_FORMAT_EN_DOWNSAMPLE_WIDTH   1
#define XDC_V_BLEND_OUTPUT_VID_FORMAT_EN_DOWNSAMPLE_MASK    0x00000010

#define XDC_V_BLEND_OUTPUT_VID_FORMAT_VID_FORMAT_SHIFT   0
#define XDC_V_BLEND_OUTPUT_VID_FORMAT_VID_FORMAT_WIDTH   3
#define XDC_V_BLEND_OUTPUT_VID_FORMAT_VID_FORMAT_MASK    0x00000007

/**
 *  * Register: XDC_V_BLEND_LAYER0_CONTROL
 *   */
#define XDC_V_BLEND_LAYER0_CONTROL         0x0000A018

#define XDC_V_BLEND_LAYER0_CONTROL_BYPASS_SHIFT   8
#define XDC_V_BLEND_LAYER0_CONTROL_BYPASS_WIDTH   1
#define XDC_V_BLEND_LAYER0_CONTROL_BYPASS_MASK    0x00000100

#define XDC_V_BLEND_LAYER0_CONTROL_RGB_MODE_SHIFT   1
#define XDC_V_BLEND_LAYER0_CONTROL_RGB_MODE_WIDTH   1
#define XDC_V_BLEND_LAYER0_CONTROL_RGB_MODE_MASK    0x00000002

#define XDC_V_BLEND_LAYER0_CONTROL_EN_US_SHIFT   0
#define XDC_V_BLEND_LAYER0_CONTROL_EN_US_WIDTH   1
#define XDC_V_BLEND_LAYER0_CONTROL_EN_US_MASK    0x00000001

/**
 *  * Register: XDC_V_BLEND_LAYER1_CONTROL
 *   */
#define XDC_V_BLEND_LAYER1_CONTROL         0x0000A01C

#define XDC_V_BLEND_LAYER1_CONTROL_BYPASS_SHIFT   8
#define XDC_V_BLEND_LAYER1_CONTROL_BYPASS_WIDTH   1
#define XDC_V_BLEND_LAYER1_CONTROL_BYPASS_MASK    0x00000100

#define XDC_V_BLEND_LAYER1_CONTROL_RGB_MODE_SHIFT   1
#define XDC_V_BLEND_LAYER1_CONTROL_RGB_MODE_WIDTH   1
#define XDC_V_BLEND_LAYER1_CONTROL_RGB_MODE_MASK    0x00000002

#define XDC_V_BLEND_LAYER1_CONTROL_EN_US_SHIFT   0
#define XDC_V_BLEND_LAYER1_CONTROL_EN_US_WIDTH   1
#define XDC_V_BLEND_LAYER1_CONTROL_EN_US_MASK    0x00000001

/**
 *  * Register: XDC_V_BLEND_RGB2YCBCR_COEFF0
 *   */
#define XDC_V_BLEND_RGB2YCBCR_COEFF0         0x0000A020

#define XDC_V_BLEND_RGB2YCBCR_COEFF0_RGB2Y_C0_SHIFT   0
#define XDC_V_BLEND_RGB2YCBCR_COEFF0_RGB2Y_C0_WIDTH   15
#define XDC_V_BLEND_RGB2YCBCR_COEFF0_RGB2Y_C0_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_RGB2YCBCR_COEFF1
 *   */
#define XDC_V_BLEND_RGB2YCBCR_COEFF1         0x0000A024

#define XDC_V_BLEND_RGB2YCBCR_COEFF1_RGB2Y_C1_SHIFT   0
#define XDC_V_BLEND_RGB2YCBCR_COEFF1_RGB2Y_C1_WIDTH   15
#define XDC_V_BLEND_RGB2YCBCR_COEFF1_RGB2Y_C1_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_RGB2YCBCR_COEFF2
 *   */
#define XDC_V_BLEND_RGB2YCBCR_COEFF2         0x0000A028

#define XDC_V_BLEND_RGB2YCBCR_COEFF2_RGB2Y_C2_SHIFT   0
#define XDC_V_BLEND_RGB2YCBCR_COEFF2_RGB2Y_C2_WIDTH   15
#define XDC_V_BLEND_RGB2YCBCR_COEFF2_RGB2Y_C2_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_RGB2YCBCR_COEFF3
 *   */
#define XDC_V_BLEND_RGB2YCBCR_COEFF3         0x0000A02C

#define XDC_V_BLEND_RGB2YCBCR_COEFF3_RGB2Y_C3_SHIFT   0
#define XDC_V_BLEND_RGB2YCBCR_COEFF3_RGB2Y_C3_WIDTH   15
#define XDC_V_BLEND_RGB2YCBCR_COEFF3_RGB2Y_C3_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_RGB2YCBCR_COEFF4
 *   */
#define XDC_V_BLEND_RGB2YCBCR_COEFF4         0x0000A030

#define XDC_V_BLEND_RGB2YCBCR_COEFF4_RGB2Y_C4_SHIFT   0
#define XDC_V_BLEND_RGB2YCBCR_COEFF4_RGB2Y_C4_WIDTH   15
#define XDC_V_BLEND_RGB2YCBCR_COEFF4_RGB2Y_C4_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_RGB2YCBCR_COEFF5
 *   */
#define XDC_V_BLEND_RGB2YCBCR_COEFF5         0x0000A034

#define XDC_V_BLEND_RGB2YCBCR_COEFF5_RGB2Y_C5_SHIFT   0
#define XDC_V_BLEND_RGB2YCBCR_COEFF5_RGB2Y_C5_WIDTH   15
#define XDC_V_BLEND_RGB2YCBCR_COEFF5_RGB2Y_C5_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_RGB2YCBCR_COEFF6
 *   */
#define XDC_V_BLEND_RGB2YCBCR_COEFF6         0x0000A038

#define XDC_V_BLEND_RGB2YCBCR_COEFF6_RGB2Y_C6_SHIFT   0
#define XDC_V_BLEND_RGB2YCBCR_COEFF6_RGB2Y_C6_WIDTH   15
#define XDC_V_BLEND_RGB2YCBCR_COEFF6_RGB2Y_C6_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_RGB2YCBCR_COEFF7
 *   */
#define XDC_V_BLEND_RGB2YCBCR_COEFF7         0x0000A03C

#define XDC_V_BLEND_RGB2YCBCR_COEFF7_RGB2Y_C7_SHIFT   0
#define XDC_V_BLEND_RGB2YCBCR_COEFF7_RGB2Y_C7_WIDTH   15
#define XDC_V_BLEND_RGB2YCBCR_COEFF7_RGB2Y_C7_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_RGB2YCBCR_COEFF8
 *   */
#define XDC_V_BLEND_RGB2YCBCR_COEFF8         0x0000A040

#define XDC_V_BLEND_RGB2YCBCR_COEFF8_RGB2Y_C8_SHIFT   0
#define XDC_V_BLEND_RGB2YCBCR_COEFF8_RGB2Y_C8_WIDTH   15
#define XDC_V_BLEND_RGB2YCBCR_COEFF8_RGB2Y_C8_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN1CSC_COEFF0
 *   */
#define XDC_V_BLEND_IN1CSC_COEFF0         0x0000A044

#define XDC_V_BLEND_IN1CSC_COEFF0_Y2R_C0_SHIFT   0
#define XDC_V_BLEND_IN1CSC_COEFF0_Y2R_C0_WIDTH   15
#define XDC_V_BLEND_IN1CSC_COEFF0_Y2R_C0_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN1CSC_COEFF1
 *   */
#define XDC_V_BLEND_IN1CSC_COEFF1         0x0000A048

#define XDC_V_BLEND_IN1CSC_COEFF1_Y2R_C1_SHIFT   0
#define XDC_V_BLEND_IN1CSC_COEFF1_Y2R_C1_WIDTH   15
#define XDC_V_BLEND_IN1CSC_COEFF1_Y2R_C1_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN1CSC_COEFF2
 *   */
#define XDC_V_BLEND_IN1CSC_COEFF2         0x0000A04C

#define XDC_V_BLEND_IN1CSC_COEFF2_Y2R_C2_SHIFT   0
#define XDC_V_BLEND_IN1CSC_COEFF2_Y2R_C2_WIDTH   15
#define XDC_V_BLEND_IN1CSC_COEFF2_Y2R_C2_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN1CSC_COEFF3
 *   */
#define XDC_V_BLEND_IN1CSC_COEFF3         0x0000A050

#define XDC_V_BLEND_IN1CSC_COEFF3_Y2R_C3_SHIFT   0
#define XDC_V_BLEND_IN1CSC_COEFF3_Y2R_C3_WIDTH   15
#define XDC_V_BLEND_IN1CSC_COEFF3_Y2R_C3_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN1CSC_COEFF4
 *   */
#define XDC_V_BLEND_IN1CSC_COEFF4         0x0000A054

#define XDC_V_BLEND_IN1CSC_COEFF4_Y2R_C4_SHIFT   0
#define XDC_V_BLEND_IN1CSC_COEFF4_Y2R_C4_WIDTH   15
#define XDC_V_BLEND_IN1CSC_COEFF4_Y2R_C4_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN1CSC_COEFF5
 *   */
#define XDC_V_BLEND_IN1CSC_COEFF5         0x0000A058

#define XDC_V_BLEND_IN1CSC_COEFF5_Y2R_C5_SHIFT   0
#define XDC_V_BLEND_IN1CSC_COEFF5_Y2R_C5_WIDTH   15
#define XDC_V_BLEND_IN1CSC_COEFF5_Y2R_C5_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN1CSC_COEFF6
 *   */
#define XDC_V_BLEND_IN1CSC_COEFF6         0x0000A05C

#define XDC_V_BLEND_IN1CSC_COEFF6_Y2R_C6_SHIFT   0
#define XDC_V_BLEND_IN1CSC_COEFF6_Y2R_C6_WIDTH   15
#define XDC_V_BLEND_IN1CSC_COEFF6_Y2R_C6_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN1CSC_COEFF7
 *   */
#define XDC_V_BLEND_IN1CSC_COEFF7         0x0000A060

#define XDC_V_BLEND_IN1CSC_COEFF7_Y2R_C7_SHIFT   0
#define XDC_V_BLEND_IN1CSC_COEFF7_Y2R_C7_WIDTH   15
#define XDC_V_BLEND_IN1CSC_COEFF7_Y2R_C7_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN1CSC_COEFF8
 *   */
#define XDC_V_BLEND_IN1CSC_COEFF8         0x0000A064

#define XDC_V_BLEND_IN1CSC_COEFF8_Y2R_C8_SHIFT   0
#define XDC_V_BLEND_IN1CSC_COEFF8_Y2R_C8_WIDTH   15
#define XDC_V_BLEND_IN1CSC_COEFF8_Y2R_C8_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_LUMA_IN1CSC_OFFSET
 *   */
#define XDC_V_BLEND_LUMA_IN1CSC_OFFSET         0x0000A068

#define XDC_V_BLEND_LUMA_IN1CSC_OFFSET_POST_OFFSET_SHIFT   16
#define XDC_V_BLEND_LUMA_IN1CSC_OFFSET_POST_OFFSET_WIDTH   13
#define XDC_V_BLEND_LUMA_IN1CSC_OFFSET_POST_OFFSET_MASK    0x1FFF0000

#define XDC_V_BLEND_LUMA_IN1CSC_OFFSET_PRE_OFFSET_SHIFT   0
#define XDC_V_BLEND_LUMA_IN1CSC_OFFSET_PRE_OFFSET_WIDTH   13
#define XDC_V_BLEND_LUMA_IN1CSC_OFFSET_PRE_OFFSET_MASK    0x00001FFF

/**
 *  * Register: XDC_V_BLEND_CR_IN1CSC_OFFSET
 *   */
#define XDC_V_BLEND_CR_IN1CSC_OFFSET         0x0000A06C

#define XDC_V_BLEND_CR_IN1CSC_OFFSET_POST_OFFSET_SHIFT   16
#define XDC_V_BLEND_CR_IN1CSC_OFFSET_POST_OFFSET_WIDTH   13
#define XDC_V_BLEND_CR_IN1CSC_OFFSET_POST_OFFSET_MASK    0x1FFF0000

#define XDC_V_BLEND_CR_IN1CSC_OFFSET_PRE_OFFSET_SHIFT   0
#define XDC_V_BLEND_CR_IN1CSC_OFFSET_PRE_OFFSET_WIDTH   13
#define XDC_V_BLEND_CR_IN1CSC_OFFSET_PRE_OFFSET_MASK    0x00001FFF

/**
 *  * Register: XDC_V_BLEND_LUMA_OUTCSC_OFFSET
 *   */
#define XDC_V_BLEND_LUMA_OUTCSC_OFFSET         0x0000A074

#define XDC_V_BLEND_LUMA_OUTCSC_OFFSET_POST_OFFSET_SHIFT   16
#define XDC_V_BLEND_LUMA_OUTCSC_OFFSET_POST_OFFSET_WIDTH   13
#define XDC_V_BLEND_LUMA_OUTCSC_OFFSET_POST_OFFSET_MASK    0x1FFF0000

#define XDC_V_BLEND_LUMA_OUTCSC_OFFSET_PRE_OFFSET_SHIFT   0
#define XDC_V_BLEND_LUMA_OUTCSC_OFFSET_PRE_OFFSET_WIDTH   13
#define XDC_V_BLEND_LUMA_OUTCSC_OFFSET_PRE_OFFSET_MASK    0x00001FFF

/**
 *  * Register: XDC_V_BLEND_CR_OUTCSC_OFFSET
 *   */
#define XDC_V_BLEND_CR_OUTCSC_OFFSET         0x0000A078

#define XDC_V_BLEND_CR_OUTCSC_OFFSET_POST_OFFSET_SHIFT   16
#define XDC_V_BLEND_CR_OUTCSC_OFFSET_POST_OFFSET_WIDTH   13
#define XDC_V_BLEND_CR_OUTCSC_OFFSET_POST_OFFSET_MASK    0x1FFF0000

#define XDC_V_BLEND_CR_OUTCSC_OFFSET_PRE_OFFSET_SHIFT   0
#define XDC_V_BLEND_CR_OUTCSC_OFFSET_PRE_OFFSET_WIDTH   13
#define XDC_V_BLEND_CR_OUTCSC_OFFSET_PRE_OFFSET_MASK    0x00001FFF

/**
 *  * Register: XDC_V_BLEND_CB_OUTCSC_OFFSET
 *   */
#define XDC_V_BLEND_CB_OUTCSC_OFFSET         0x0000A07C

#define XDC_V_BLEND_CB_OUTCSC_OFFSET_POST_OFFSET_SHIFT   16
#define XDC_V_BLEND_CB_OUTCSC_OFFSET_POST_OFFSET_WIDTH   13
#define XDC_V_BLEND_CB_OUTCSC_OFFSET_POST_OFFSET_MASK    0x1FFF0000

#define XDC_V_BLEND_CB_OUTCSC_OFFSET_PRE_OFFSET_SHIFT   0
#define XDC_V_BLEND_CB_OUTCSC_OFFSET_PRE_OFFSET_WIDTH   13
#define XDC_V_BLEND_CB_OUTCSC_OFFSET_PRE_OFFSET_MASK    0x00001FFF

/**
 *  * Register: XDC_V_BLEND_IN2CSC_COEFF0
 *   */
#define XDC_V_BLEND_IN2CSC_COEFF0         0x0000A080

#define XDC_V_BLEND_IN2CSC_COEFF0_Y2R_C0_SHIFT   0
#define XDC_V_BLEND_IN2CSC_COEFF0_Y2R_C0_WIDTH   15
#define XDC_V_BLEND_IN2CSC_COEFF0_Y2R_C0_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN2CSC_COEFF1
 *   */
#define XDC_V_BLEND_IN2CSC_COEFF1         0x0000A084

#define XDC_V_BLEND_IN2CSC_COEFF1_Y2R_C1_SHIFT   0
#define XDC_V_BLEND_IN2CSC_COEFF1_Y2R_C1_WIDTH   15
#define XDC_V_BLEND_IN2CSC_COEFF1_Y2R_C1_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN2CSC_COEFF2
 *   */
#define XDC_V_BLEND_IN2CSC_COEFF2         0x0000A088

#define XDC_V_BLEND_IN2CSC_COEFF2_Y2R_C2_SHIFT   0
#define XDC_V_BLEND_IN2CSC_COEFF2_Y2R_C2_WIDTH   15
#define XDC_V_BLEND_IN2CSC_COEFF2_Y2R_C2_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN2CSC_COEFF3
 *   */
#define XDC_V_BLEND_IN2CSC_COEFF3         0x0000A08C

#define XDC_V_BLEND_IN2CSC_COEFF3_Y2R_C3_SHIFT   0
#define XDC_V_BLEND_IN2CSC_COEFF3_Y2R_C3_WIDTH   15
#define XDC_V_BLEND_IN2CSC_COEFF3_Y2R_C3_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN2CSC_COEFF4
 *   */
#define XDC_V_BLEND_IN2CSC_COEFF4         0x0000A090

#define XDC_V_BLEND_IN2CSC_COEFF4_Y2R_C4_SHIFT   0
#define XDC_V_BLEND_IN2CSC_COEFF4_Y2R_C4_WIDTH   15
#define XDC_V_BLEND_IN2CSC_COEFF4_Y2R_C4_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN2CSC_COEFF5
 *   */
#define XDC_V_BLEND_IN2CSC_COEFF5         0x0000A094

#define XDC_V_BLEND_IN2CSC_COEFF5_Y2R_C5_SHIFT   0
#define XDC_V_BLEND_IN2CSC_COEFF5_Y2R_C5_WIDTH   15
#define XDC_V_BLEND_IN2CSC_COEFF5_Y2R_C5_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN2CSC_COEFF6
 *   */
#define XDC_V_BLEND_IN2CSC_COEFF6         0x0000A098

#define XDC_V_BLEND_IN2CSC_COEFF6_Y2R_C6_SHIFT   0
#define XDC_V_BLEND_IN2CSC_COEFF6_Y2R_C6_WIDTH   15
#define XDC_V_BLEND_IN2CSC_COEFF6_Y2R_C6_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN2CSC_COEFF7
 *   */
#define XDC_V_BLEND_IN2CSC_COEFF7         0x0000A09C

#define XDC_V_BLEND_IN2CSC_COEFF7_Y2R_C7_SHIFT   0
#define XDC_V_BLEND_IN2CSC_COEFF7_Y2R_C7_WIDTH   15
#define XDC_V_BLEND_IN2CSC_COEFF7_Y2R_C7_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_IN2CSC_COEFF8
 *   */
#define XDC_V_BLEND_IN2CSC_COEFF8         0x0000A0A0

#define XDC_V_BLEND_IN2CSC_COEFF8_Y2R_C8_SHIFT   0
#define XDC_V_BLEND_IN2CSC_COEFF8_Y2R_C8_WIDTH   15
#define XDC_V_BLEND_IN2CSC_COEFF8_Y2R_C8_MASK    0x00007FFF

/**
 *  * Register: XDC_V_BLEND_LUMA_IN2CSC_OFFSET
 *   */
#define XDC_V_BLEND_LUMA_IN2CSC_OFFSET         0x0000A0A4

#define XDC_V_BLEND_LUMA_IN2CSC_OFFSET_POST_OFFSET_SHIFT   16
#define XDC_V_BLEND_LUMA_IN2CSC_OFFSET_POST_OFFSET_WIDTH   13
#define XDC_V_BLEND_LUMA_IN2CSC_OFFSET_POST_OFFSET_MASK    0x1FFF0000

#define XDC_V_BLEND_LUMA_IN2CSC_OFFSET_PRE_OFFSET_SHIFT   0
#define XDC_V_BLEND_LUMA_IN2CSC_OFFSET_PRE_OFFSET_WIDTH   13
#define XDC_V_BLEND_LUMA_IN2CSC_OFFSET_PRE_OFFSET_MASK    0x00001FFF

/**
 *  * Register: XDC_V_BLEND_CR_IN2CSC_OFFSET
 *   */
#define XDC_V_BLEND_CR_IN2CSC_OFFSET         0x0000A0A8

#define XDC_V_BLEND_CR_IN2CSC_OFFSET_POST_OFFSET_SHIFT   16
#define XDC_V_BLEND_CR_IN2CSC_OFFSET_POST_OFFSET_WIDTH   13
#define XDC_V_BLEND_CR_IN2CSC_OFFSET_POST_OFFSET_MASK    0x1FFF0000

#define XDC_V_BLEND_CR_IN2CSC_OFFSET_PRE_OFFSET_SHIFT   0
#define XDC_V_BLEND_CR_IN2CSC_OFFSET_PRE_OFFSET_WIDTH   13
#define XDC_V_BLEND_CR_IN2CSC_OFFSET_PRE_OFFSET_MASK    0x00001FFF

/**
 *  * Register: XDC_V_BLEND_CB_IN2CSC_OFFSET
 *   */
#define XDC_V_BLEND_CB_IN2CSC_OFFSET         0x0000A0AC

#define XDC_V_BLEND_CB_IN2CSC_OFFSET_POST_OFFSET_SHIFT   16
#define XDC_V_BLEND_CB_IN2CSC_OFFSET_POST_OFFSET_WIDTH   13
#define XDC_V_BLEND_CB_IN2CSC_OFFSET_POST_OFFSET_MASK    0x1FFF0000

#define XDC_V_BLEND_CB_IN2CSC_OFFSET_PRE_OFFSET_SHIFT   0
#define XDC_V_BLEND_CB_IN2CSC_OFFSET_PRE_OFFSET_WIDTH   13
#define XDC_V_BLEND_CB_IN2CSC_OFFSET_PRE_OFFSET_MASK    0x00001FFF

/**
 *  * Register: XDC_V_BLEND_CHROMA_KEY_ENABLE
 *   */
#define XDC_V_BLEND_CHROMA_KEY_ENABLE         0x0000A1D0

#define XDC_V_BLEND_CHROMA_KEY_ENABLE_M_SEL_SHIFT   1
#define XDC_V_BLEND_CHROMA_KEY_ENABLE_M_SEL_WIDTH   1
#define XDC_V_BLEND_CHROMA_KEY_ENABLE_M_SEL_MASK    0x00000002

#define XDC_V_BLEND_CHROMA_KEY_ENABLE_EN_SHIFT   0
#define XDC_V_BLEND_CHROMA_KEY_ENABLE_EN_WIDTH   1
#define XDC_V_BLEND_CHROMA_KEY_ENABLE_EN_MASK    0x00000001

/**
 *  * Register: XDC_V_BLEND_CHROMA_KEY_COMP1
 *   */
#define XDC_V_BLEND_CHROMA_KEY_COMP1         0x0000A1D4

#define XDC_V_BLEND_CHROMA_KEY_COMP1_MAX_SHIFT   16
#define XDC_V_BLEND_CHROMA_KEY_COMP1_MAX_WIDTH   12
#define XDC_V_BLEND_CHROMA_KEY_COMP1_MAX_MASK    0x0FFF0000

#define XDC_V_BLEND_CHROMA_KEY_COMP1_MIN_SHIFT   0
#define XDC_V_BLEND_CHROMA_KEY_COMP1_MIN_WIDTH   12
#define XDC_V_BLEND_CHROMA_KEY_COMP1_MIN_MASK    0x00000FFF

/**
 *  * Register: XDC_V_BLEND_CHROMA_KEY_COMP2
 *   */
#define XDC_V_BLEND_CHROMA_KEY_COMP2         0x0000A1D8

#define XDC_V_BLEND_CHROMA_KEY_COMP2_MAX_SHIFT   16
#define XDC_V_BLEND_CHROMA_KEY_COMP2_MAX_WIDTH   12
#define XDC_V_BLEND_CHROMA_KEY_COMP2_MAX_MASK    0x0FFF0000

#define XDC_V_BLEND_CHROMA_KEY_COMP2_MIN_SHIFT   0
#define XDC_V_BLEND_CHROMA_KEY_COMP2_MIN_WIDTH   12
#define XDC_V_BLEND_CHROMA_KEY_COMP2_MIN_MASK    0x00000FFF

/**
 *  * Register: XDC_V_BLEND_CHROMA_KEY_COMP3
 *   */
#define XDC_V_BLEND_CHROMA_KEY_COMP3         0x0000A1DC

#define XDC_V_BLEND_CHROMA_KEY_COMP3_MAX_SHIFT   16
#define XDC_V_BLEND_CHROMA_KEY_COMP3_MAX_WIDTH   12
#define XDC_V_BLEND_CHROMA_KEY_COMP3_MAX_MASK    0x0FFF0000

#define XDC_V_BLEND_CHROMA_KEY_COMP3_MIN_SHIFT   0
#define XDC_V_BLEND_CHROMA_KEY_COMP3_MIN_WIDTH   12
#define XDC_V_BLEND_CHROMA_KEY_COMP3_MIN_MASK    0x00000FFF

/**
 *  * Register: XDC_AV_BUF_FORMAT
 *   */
#define XDC_AV_BUF_FORMAT         0x0000B000

#define XDC_AV_BUF_FORMAT_NL_VID1_FORMAT_SHIFT   8
#define XDC_AV_BUF_FORMAT_NL_VID1_FORMAT_WIDTH   8
#define XDC_AV_BUF_FORMAT_NL_VID1_FORMAT_MASK    0x0000FF00

#define XDC_AV_BUF_FORMAT_NL_VID0_FORMAT_SHIFT   0
#define XDC_AV_BUF_FORMAT_NL_VID0_FORMAT_WIDTH   8
#define XDC_AV_BUF_FORMAT_NL_VID0_FORMAT_MASK    0x000000FF

/**
 *  * Register: XDC_AV_BUF_NON_LIVE_LATENCY
 *   */
#define XDC_AV_BUF_NON_LIVE_LATENCY         0x0000B008

#define XDC_AV_BUF_NON_LIVE_LATENCY_V1_LINE_LATENCY_SHIFT	19
#define XDC_AV_BUF_NON_LIVE_LATENCY_V1_LINE_LATENCY_WIDTH	3
#define XDC_AV_BUF_NON_LIVE_LATENCY_V1_LINE_LATENCY_MASK	0x00380000

#define XDC_AV_BUF_NON_LIVE_LATENCY_V0_LINE_LATENCY_SHIFT	16
#define XDC_AV_BUF_NON_LIVE_LATENCY_V0_LINE_LATENCY_WIDTH	3
#define XDC_AV_BUF_NON_LIVE_LATENCY_V0_LINE_LATENCY_MASK	0x00030000

#define XDC_AV_BUF_NON_LIVE_LATENCY_NL_LATENCY_SHIFT   0
#define XDC_AV_BUF_NON_LIVE_LATENCY_NL_LATENCY_WIDTH   16
#define XDC_AV_BUF_NON_LIVE_LATENCY_NL_LATENCY_MASK    0x0000FFFF

/**
 *  * Register: XDC_AV_CHBUF0
 *   */
#define XDC_AV_CHBUF0         0x0000B010

#define XDC_AV_CHBUF0_BURST_LEN_SHIFT   2
#define XDC_AV_CHBUF0_BURST_LEN_WIDTH   5
#define XDC_AV_CHBUF0_BURST_LEN_MASK    0x0000007C

#define XDC_AV_CHBUF0_FLUSH_SHIFT   1
#define XDC_AV_CHBUF0_FLUSH_WIDTH   1
#define XDC_AV_CHBUF0_FLUSH_MASK    0x00000002

#define XDC_AV_CHBUF0_EN_SHIFT   0
#define XDC_AV_CHBUF0_EN_WIDTH   1
#define XDC_AV_CHBUF0_EN_MASK    0x00000001

/**
 *  * Register: XDC_AV_CHBUF1
 *   */
#define XDC_AV_CHBUF1         0x0000B014

#define XDC_AV_CHBUF1_BURST_LEN_SHIFT   2
#define XDC_AV_CHBUF1_BURST_LEN_WIDTH   5
#define XDC_AV_CHBUF1_BURST_LEN_MASK    0x0000007C

#define XDC_AV_CHBUF1_FLUSH_SHIFT   1
#define XDC_AV_CHBUF1_FLUSH_WIDTH   1
#define XDC_AV_CHBUF1_FLUSH_MASK    0x00000002

#define XDC_AV_CHBUF1_EN_SHIFT   0
#define XDC_AV_CHBUF1_EN_WIDTH   1
#define XDC_AV_CHBUF1_EN_MASK    0x00000001

/**
 *  * Register: XDC_AV_CHBUF2
 *   */
#define XDC_AV_CHBUF2         0x0000B018

#define XDC_AV_CHBUF2_BURST_LEN_SHIFT   2
#define XDC_AV_CHBUF2_BURST_LEN_WIDTH   5
#define XDC_AV_CHBUF2_BURST_LEN_MASK    0x0000007C

#define XDC_AV_CHBUF2_FLUSH_SHIFT   1
#define XDC_AV_CHBUF2_FLUSH_WIDTH   1
#define XDC_AV_CHBUF2_FLUSH_MASK    0x00000002

#define XDC_AV_CHBUF2_EN_SHIFT   0
#define XDC_AV_CHBUF2_EN_WIDTH   1
#define XDC_AV_CHBUF2_EN_MASK    0x00000001

/**
 *  * Register: XDC_AV_CHBUF3
 *   */
#define XDC_AV_CHBUF3         0x0000B01C

#define XDC_AV_CHBUF3_BURST_LEN_SHIFT   2
#define XDC_AV_CHBUF3_BURST_LEN_WIDTH   5
#define XDC_AV_CHBUF3_BURST_LEN_MASK    0x0000007C

#define XDC_AV_CHBUF3_FLUSH_SHIFT   1
#define XDC_AV_CHBUF3_FLUSH_WIDTH   1
#define XDC_AV_CHBUF3_FLUSH_MASK    0x00000002

#define XDC_AV_CHBUF3_EN_SHIFT   0
#define XDC_AV_CHBUF3_EN_WIDTH   1
#define XDC_AV_CHBUF3_EN_MASK    0x00000001

/**
 *  * Register: XDC_AV_CHBUF4
 *   */
#define XDC_AV_CHBUF4         0x0000B020

#define XDC_AV_CHBUF4_BURST_LEN_SHIFT   2
#define XDC_AV_CHBUF4_BURST_LEN_WIDTH   5
#define XDC_AV_CHBUF4_BURST_LEN_MASK    0x0000007C

#define XDC_AV_CHBUF4_FLUSH_SHIFT   1
#define XDC_AV_CHBUF4_FLUSH_WIDTH   1
#define XDC_AV_CHBUF4_FLUSH_MASK    0x00000002

#define XDC_AV_CHBUF4_EN_SHIFT   0
#define XDC_AV_CHBUF4_EN_WIDTH   1
#define XDC_AV_CHBUF4_EN_MASK    0x00000001

/**
 *  * Register: XDC_AV_CHBUF5
 *   */
#define XDC_AV_CHBUF5         0x0000B024

#define XDC_AV_CHBUF5_BURST_LEN_SHIFT   2
#define XDC_AV_CHBUF5_BURST_LEN_WIDTH   5
#define XDC_AV_CHBUF5_BURST_LEN_MASK    0x0000007C

#define XDC_AV_CHBUF5_FLUSH_SHIFT   1
#define XDC_AV_CHBUF5_FLUSH_WIDTH   1
#define XDC_AV_CHBUF5_FLUSH_MASK    0x00000002

#define XDC_AV_CHBUF5_EN_SHIFT   0
#define XDC_AV_CHBUF5_EN_WIDTH   1
#define XDC_AV_CHBUF5_EN_MASK    0x00000001

/**
 *  * Register: XDC_AV_BUF_STC_CONTROL
 *   */
#define XDC_AV_BUF_STC_CONTROL         0x0000B02C

#define XDC_AV_BUF_STC_CONTROL_EN_SHIFT   0
#define XDC_AV_BUF_STC_CONTROL_EN_WIDTH   1
#define XDC_AV_BUF_STC_CONTROL_EN_MASK    0x00000001

/**
 *  * Register: XDC_AV_BUF_STC_INIT_VALUE0
 *   */
#define XDC_AV_BUF_STC_INIT_VALUE0         0x0000B030

#define XDC_AV_BUF_STC_INIT_VALUE0_INIT_VALUE0_SHIFT   0
#define XDC_AV_BUF_STC_INIT_VALUE0_INIT_VALUE0_WIDTH   32
#define XDC_AV_BUF_STC_INIT_VALUE0_INIT_VALUE0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AV_BUF_STC_INIT_VALUE1
 *   */
#define XDC_AV_BUF_STC_INIT_VALUE1         0x0000B034

#define XDC_AV_BUF_STC_INIT_VALUE1_INIT_VALUE1_SHIFT   0
#define XDC_AV_BUF_STC_INIT_VALUE1_INIT_VALUE1_WIDTH   10
#define XDC_AV_BUF_STC_INIT_VALUE1_INIT_VALUE1_MASK    0x000003FF

/**
 *  * Register: XDC_AV_BUF_STC_ADJ
 *   */
#define XDC_AV_BUF_STC_ADJ         0x0000B038

#define XDC_AV_BUF_STC_ADJ_SIGN_SHIFT   31
#define XDC_AV_BUF_STC_ADJ_SIGN_WIDTH   1
#define XDC_AV_BUF_STC_ADJ_SIGN_MASK    0x80000000

#define XDC_AV_BUF_STC_ADJ_VALUE_SHIFT   0
#define XDC_AV_BUF_STC_ADJ_VALUE_WIDTH   31
#define XDC_AV_BUF_STC_ADJ_VALUE_MASK    0x7FFFFFFF

/**
 *  * Register: XDC_AV_BUF_STC_VID_VSYNC_TS_REG0
 *   */
#define XDC_AV_BUF_STC_VID_VSYNC_TS_REG0         0x0000B03C

#define XDC_AV_BUF_STC_VID_VSYNC_TS_REG0_VSYNC_TS0_SHIFT   0
#define XDC_AV_BUF_STC_VID_VSYNC_TS_REG0_VSYNC_TS0_WIDTH   32
#define XDC_AV_BUF_STC_VID_VSYNC_TS_REG0_VSYNC_TS0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AV_BUF_STC_VID_VSYNC_TS_REG1
 *   */
#define XDC_AV_BUF_STC_VID_VSYNC_TS_REG1         0x0000B040

#define XDC_AV_BUF_STC_VID_VSYNC_TS_REG1_VSYNC_TS1_SHIFT   0
#define XDC_AV_BUF_STC_VID_VSYNC_TS_REG1_VSYNC_TS1_WIDTH   10
#define XDC_AV_BUF_STC_VID_VSYNC_TS_REG1_VSYNC_TS1_MASK    0x000003FF

/**
 *  * Register: XDC_AV_BUF_STC_EXT_VSYNC_TS_REG0
 *   */
#define XDC_AV_BUF_STC_EXT_VSYNC_TS_REG0         0x0000B044

#define XDC_AV_BUF_STC_EXT_VSYNC_TS_REG0_EXT_VSYNC_TS0_SHIFT   0
#define XDC_AV_BUF_STC_EXT_VSYNC_TS_REG0_EXT_VSYNC_TS0_WIDTH   32
#define XDC_AV_BUF_STC_EXT_VSYNC_TS_REG0_EXT_VSYNC_TS0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AV_BUF_STC_EXT_VSYNC_TS_REG1
 *   */
#define XDC_AV_BUF_STC_EXT_VSYNC_TS_REG1         0x0000B048

#define XDC_AV_BUF_STC_EXT_VSYNC_TS_REG1_EXT_VSYNC_TS1_SHIFT   0
#define XDC_AV_BUF_STC_EXT_VSYNC_TS_REG1_EXT_VSYNC_TS1_WIDTH   10
#define XDC_AV_BUF_STC_EXT_VSYNC_TS_REG1_EXT_VSYNC_TS1_MASK    0x000003FF

/**
 *  * Register: XDC_AV_BUF_STC_CUSTOM_EVENT_TS_REG0
 *   */
#define XDC_AV_BUF_STC_CUSTOM_EVENT_TS_REG0         0x0000B04C

#define XDC_AV_BUF_STC_CUSTOM_EVENT_TS_REG0_CUST_EVENT_TS0_SHIFT   0
#define XDC_AV_BUF_STC_CUSTOM_EVENT_TS_REG0_CUST_EVENT_TS0_WIDTH   32
#define XDC_AV_BUF_STC_CUSTOM_EVENT_TS_REG0_CUST_EVENT_TS0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AV_BUF_STC_CUSTOM_EVENT_TS_REG1
 *   */
#define XDC_AV_BUF_STC_CUSTOM_EVENT_TS_REG1         0x0000B050

#define XDC_AV_BUF_STC_CUSTOM_EVENT_TS_REG1_CUST_EVENT_TS1_SHIFT   0
#define XDC_AV_BUF_STC_CUSTOM_EVENT_TS_REG1_CUST_EVENT_TS1_WIDTH   10
#define XDC_AV_BUF_STC_CUSTOM_EVENT_TS_REG1_CUST_EVENT_TS1_MASK    0x000003FF

/**
 *  * Register: XDC_AV_BUF_STC_CUSTOM_EVENT2_TS_REG0
 *   */
#define XDC_AV_BUF_STC_CUSTOM_EVENT2_TS_REG0         0x0000B054

#define XDC_AV_BUF_STC_CUSTOM_EVENT2_TS_REG0_CUST_EVENT2_TS0_SHIFT   0
#define XDC_AV_BUF_STC_CUSTOM_EVENT2_TS_REG0_CUST_EVENT2_TS0_WIDTH   32
#define XDC_AV_BUF_STC_CUSTOM_EVENT2_TS_REG0_CUST_EVENT2_TS0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AV_BUF_STC_CUSTOM_EVENT2_TS_REG1
 *   */
#define XDC_AV_BUF_STC_CUSTOM_EVENT2_TS_REG1         0x0000B058

#define XDC_AV_BUF_STC_CUSTOM_EVENT2_TS_REG1_CUST_EVENT2_TS1_SHIFT   0
#define XDC_AV_BUF_STC_CUSTOM_EVENT2_TS_REG1_CUST_EVENT2_TS1_WIDTH   10
#define XDC_AV_BUF_STC_CUSTOM_EVENT2_TS_REG1_CUST_EVENT2_TS1_MASK    0x000003FF

/**
 *  * Register: XDC_AV_BUF_STC_SNAPSHOT0
 *   */
#define XDC_AV_BUF_STC_SNAPSHOT0         0x0000B060

#define XDC_AV_BUF_STC_SNAPSHOT0_STC0_SHIFT   0
#define XDC_AV_BUF_STC_SNAPSHOT0_STC0_WIDTH   32
#define XDC_AV_BUF_STC_SNAPSHOT0_STC0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AV_BUF_STC_SNAPSHOT1
 *   */
#define XDC_AV_BUF_STC_SNAPSHOT1         0x0000B064

#define XDC_AV_BUF_STC_SNAPSHOT1_STC1_SHIFT   0
#define XDC_AV_BUF_STC_SNAPSHOT1_STC1_WIDTH   10
#define XDC_AV_BUF_STC_SNAPSHOT1_STC1_MASK    0x000003FF

/**
 *  * Register: XDC_AV_BUF_OUTPUT_AUD_VID_SELECT
 *   */
#define XDC_AV_BUF_OUTPUT_AUD_VID_SELECT         0x0000B070

#define XDC_AV_BUF_OUTPUT_AUD_VID_SELECT_AUD_STREAM1_SEL_SHIFT   4
#define XDC_AV_BUF_OUTPUT_AUD_VID_SELECT_AUD_STREAM1_SEL_WIDTH   2
#define XDC_AV_BUF_OUTPUT_AUD_VID_SELECT_AUD_STREAM1_SEL_MASK    0x00000030

#define XDC_AV_BUF_OUTPUT_AUD_VID_SELECT_VID_STREAM2_SEL_SHIFT   2
#define XDC_AV_BUF_OUTPUT_AUD_VID_SELECT_VID_STREAM2_SEL_WIDTH   2
#define XDC_AV_BUF_OUTPUT_AUD_VID_SELECT_VID_STREAM2_SEL_MASK    0x0000000C

#define XDC_AV_BUF_OUTPUT_AUD_VID_SELECT_VID_STREAM1_SEL_SHIFT   0
#define XDC_AV_BUF_OUTPUT_AUD_VID_SELECT_VID_STREAM1_SEL_WIDTH   2
#define XDC_AV_BUF_OUTPUT_AUD_VID_SELECT_VID_STREAM1_SEL_MASK    0x00000003

/**
 *  * Register: XDC_AV_BUF_HCOUNT_VCOUNT_INT0
 *   */
#define XDC_AV_BUF_HCOUNT_VCOUNT_INT0         0x0000B074

#define XDC_AV_BUF_HCOUNT_VCOUNT_INT0_HCOUNT_SHIFT   16
#define XDC_AV_BUF_HCOUNT_VCOUNT_INT0_HCOUNT_WIDTH   14
#define XDC_AV_BUF_HCOUNT_VCOUNT_INT0_HCOUNT_MASK    0x3FFF0000

#define XDC_AV_BUF_HCOUNT_VCOUNT_INT0_VCOUNT_SHIFT   0
#define XDC_AV_BUF_HCOUNT_VCOUNT_INT0_VCOUNT_WIDTH   14
#define XDC_AV_BUF_HCOUNT_VCOUNT_INT0_VCOUNT_MASK    0x00003FFF

/**
 *  * Register: XDC_AV_BUF_HCOUNT_VCOUNT_INT1
 *   */
#define XDC_AV_BUF_HCOUNT_VCOUNT_INT1         0x0000B078

#define XDC_AV_BUF_HCOUNT_VCOUNT_INT1_HCOUNT_SHIFT   16
#define XDC_AV_BUF_HCOUNT_VCOUNT_INT1_HCOUNT_WIDTH   14
#define XDC_AV_BUF_HCOUNT_VCOUNT_INT1_HCOUNT_MASK    0x3FFF0000

#define XDC_AV_BUF_HCOUNT_VCOUNT_INT1_VCOUNT_SHIFT   0
#define XDC_AV_BUF_HCOUNT_VCOUNT_INT1_VCOUNT_WIDTH   14
#define XDC_AV_BUF_HCOUNT_VCOUNT_INT1_VCOUNT_MASK    0x00003FFF

/**
 *  * Register: XDC_AV_BUF_DITHER_CFG
 *   */
#define XDC_AV_BUF_DITHER_CFG         0x0000B07C

#define XDC_AV_BUF_DITHER_CFG_TAP_MSB_SHIFT   10
#define XDC_AV_BUF_DITHER_CFG_TAP_MSB_WIDTH   1
#define XDC_AV_BUF_DITHER_CFG_TAP_MSB_MASK    0x00000400

#define XDC_AV_BUF_DITHER_CFG_DW_SEL_SHIFT   9
#define XDC_AV_BUF_DITHER_CFG_DW_SEL_WIDTH   1
#define XDC_AV_BUF_DITHER_CFG_DW_SEL_MASK    0x00000200

#define XDC_AV_BUF_DITHER_CFG_LD_SHIFT   8
#define XDC_AV_BUF_DITHER_CFG_LD_WIDTH   1
#define XDC_AV_BUF_DITHER_CFG_LD_MASK    0x00000100

#define XDC_AV_BUF_DITHER_CFG_TRUNC_PT_SHIFT   5
#define XDC_AV_BUF_DITHER_CFG_TRUNC_PT_WIDTH   3
#define XDC_AV_BUF_DITHER_CFG_TRUNC_PT_MASK    0x000000E0

#define XDC_AV_BUF_DITHER_CFG_MODE_SHIFT   3
#define XDC_AV_BUF_DITHER_CFG_MODE_WIDTH   2
#define XDC_AV_BUF_DITHER_CFG_MODE_MASK    0x00000018

#define XDC_AV_BUF_DITHER_CFG_SIZE_SHIFT   0
#define XDC_AV_BUF_DITHER_CFG_SIZE_WIDTH   3
#define XDC_AV_BUF_DITHER_CFG_SIZE_MASK    0x00000007

/**
 *  * Register: XDC_DITHER_CFG_SEED0
 *   */
#define XDC_DITHER_CFG_SEED0         0x0000B080

#define XDC_DITHER_CFG_SEED0_COLR0_SHIFT   0
#define XDC_DITHER_CFG_SEED0_COLR0_WIDTH   16
#define XDC_DITHER_CFG_SEED0_COLR0_MASK    0x0000FFFF

/**
 *  * Register: XDC_DITHER_CFG_SEED1
 *   */
#define XDC_DITHER_CFG_SEED1         0x0000B084

#define XDC_DITHER_CFG_SEED1_COLR1_SHIFT   0
#define XDC_DITHER_CFG_SEED1_COLR1_WIDTH   16
#define XDC_DITHER_CFG_SEED1_COLR1_MASK    0x0000FFFF

/**
 *  * Register: XDC_DITHER_CFG_SEED2
 *   */
#define XDC_DITHER_CFG_SEED2         0x0000B088

#define XDC_DITHER_CFG_SEED2_COLR2_SHIFT   0
#define XDC_DITHER_CFG_SEED2_COLR2_WIDTH   16
#define XDC_DITHER_CFG_SEED2_COLR2_MASK    0x0000FFFF

/**
 *  * Register: XDC_DITHER_CFG_MAX
 *   */
#define XDC_DITHER_CFG_MAX         0x0000B08C

#define XDC_DITHER_CFG_MAX_COLR_MAX_SHIFT   0
#define XDC_DITHER_CFG_MAX_COLR_MAX_WIDTH   12
#define XDC_DITHER_CFG_MAX_COLR_MAX_MASK    0x00000FFF

/**
 *  * Register: XDC_DITHER_CFG_MIN
 *   */
#define XDC_DITHER_CFG_MIN         0x0000B090

#define XDC_DITHER_CFG_MIN_COLR_MIN_SHIFT   0
#define XDC_DITHER_CFG_MIN_COLR_MIN_WIDTH   12
#define XDC_DITHER_CFG_MIN_COLR_MIN_MASK    0x00000FFF

/**
 *  * Register: XDC_AV_BUF_AUD_VID_CLK_SOURCE
 *   */
#define XDC_AV_BUF_AUD_VID_CLK_SOURCE         0x0000B120

#define XDC_AV_BUF_AUD_VID_CLK_SOURCE_VID_TIMING_SRC_SHIFT   2
#define XDC_AV_BUF_AUD_VID_CLK_SOURCE_VID_TIMING_SRC_WIDTH   1
#define XDC_AV_BUF_AUD_VID_CLK_SOURCE_VID_TIMING_SRC_MASK    0x00000004

#define XDC_AV_BUF_AUD_VID_CLK_SOURCE_AUD_CLK_SRC_SHIFT   1
#define XDC_AV_BUF_AUD_VID_CLK_SOURCE_AUD_CLK_SRC_WIDTH   1
#define XDC_AV_BUF_AUD_VID_CLK_SOURCE_AUD_CLK_SRC_MASK    0x00000002

#define XDC_AV_BUF_AUD_VID_CLK_SOURCE_VID_CLK_SRC_SHIFT   0
#define XDC_AV_BUF_AUD_VID_CLK_SOURCE_VID_CLK_SRC_WIDTH   1
#define XDC_AV_BUF_AUD_VID_CLK_SOURCE_VID_CLK_SRC_MASK    0x00000001

/**
 *  * Register: XDC_AV_BUF_SRST_REG
 *   */
#define XDC_AV_BUF_SRST_REG         0x0000B124

#define XDC_AV_BUF_SRST_REG_VID_RST_SHIFT   1
#define XDC_AV_BUF_SRST_REG_VID_RST_WIDTH   1
#define XDC_AV_BUF_SRST_REG_VID_RST_MASK    0x00000002

/**
 *  * Register: XDC_AV_BUF_AUD_CH_CFG
 *   */
#define XDC_AV_BUF_AUD_CH_CFG         0x0000B12C

#define XDC_AV_BUF_AUD_CH_CFG_AUD_CH_ID_SHIFT   0
#define XDC_AV_BUF_AUD_CH_CFG_AUD_CH_ID_WIDTH   2
#define XDC_AV_BUF_AUD_CH_CFG_AUD_CH_ID_MASK    0x00000003

/**
 *  * Register: XDC_AV_BUF_GRAPHICS_COMP0_SCALE_FACTOR
 *   */
#define XDC_AV_BUF_GRAPHICS_COMP0_SCALE_FACTOR         0x0000B200

#define XDC_AV_BUF_GRAPHICS_COMP0_SCALE_FACTOR_GRAPHICS_SCALE_FACTOR0_SHIFT   0
#define XDC_AV_BUF_GRAPHICS_COMP0_SCALE_FACTOR_GRAPHICS_SCALE_FACTOR0_WIDTH   17
#define XDC_AV_BUF_GRAPHICS_COMP0_SCALE_FACTOR_GRAPHICS_SCALE_FACTOR0_MASK    0x0001FFFF

/**
 *  * Register: XDC_AV_BUF_GRAPHICS_COMP1_SCALE_FACTOR
 *   */
#define XDC_AV_BUF_GRAPHICS_COMP1_SCALE_FACTOR         0x0000B204

#define XDC_AV_BUF_GRAPHICS_COMP1_SCALE_FACTOR_GRAPHICS_SCALE_FACTOR1_SHIFT   0
#define XDC_AV_BUF_GRAPHICS_COMP1_SCALE_FACTOR_GRAPHICS_SCALE_FACTOR1_WIDTH   17
#define XDC_AV_BUF_GRAPHICS_COMP1_SCALE_FACTOR_GRAPHICS_SCALE_FACTOR1_MASK    0x0001FFFF

/**
 *  * Register: XDC_AV_BUF_GRAPHICS_COMP2_SCALE_FACTOR
 *   */
#define XDC_AV_BUF_GRAPHICS_COMP2_SCALE_FACTOR         0x0000B208

#define XDC_AV_BUF_GRAPHICS_COMP2_SCALE_FACTOR_GRAPHICS_SCALE_FACTOR2_SHIFT   0
#define XDC_AV_BUF_GRAPHICS_COMP2_SCALE_FACTOR_GRAPHICS_SCALE_FACTOR2_WIDTH   17
#define XDC_AV_BUF_GRAPHICS_COMP2_SCALE_FACTOR_GRAPHICS_SCALE_FACTOR2_MASK    0x0001FFFF

/**
 *  * Register: XDC_AV_BUF_VID_COMP0_SCALE_FACTOR
 *   */
#define XDC_AV_BUF_VID_COMP0_SCALE_FACTOR         0x0000B20C

#define XDC_AV_BUF_VID_COMP0_SCALE_FACTOR_VID_SCA_FACT0_SHIFT   0
#define XDC_AV_BUF_VID_COMP0_SCALE_FACTOR_VID_SCA_FACT0_WIDTH   17
#define XDC_AV_BUF_VID_COMP0_SCALE_FACTOR_VID_SCA_FACT0_MASK    0x0001FFFF

/**
 *  * Register: XDC_AV_BUF_VID_COMP1_SCALE_FACTOR
 *   */
#define XDC_AV_BUF_VID_COMP1_SCALE_FACTOR         0x0000B210

#define XDC_AV_BUF_VID_COMP1_SCALE_FACTOR_VID_SCA_FACT1_SHIFT   0
#define XDC_AV_BUF_VID_COMP1_SCALE_FACTOR_VID_SCA_FACT1_WIDTH   17
#define XDC_AV_BUF_VID_COMP1_SCALE_FACTOR_VID_SCA_FACT1_MASK    0x0001FFFF

/**
 *  * Register: XDC_AV_BUF_VID_COMP2_SCALE_FACTOR
 *   */
#define XDC_AV_BUF_VID_COMP2_SCALE_FACTOR         0x0000B214

#define XDC_AV_BUF_VID_COMP2_SCALE_FACTOR_VID_SCA_FACT2_SHIFT   0
#define XDC_AV_BUF_VID_COMP2_SCALE_FACTOR_VID_SCA_FACT2_WIDTH   17
#define XDC_AV_BUF_VID_COMP2_SCALE_FACTOR_VID_SCA_FACT2_MASK    0x0001FFFF

/**
 *  * Register: XDC_AV_BUF_LIVE_VID_COMP0_SF
 *   */
#define XDC_AV_BUF_LIVE_VID_COMP0_SF         0x0000B218

#define XDC_AV_BUF_LIVE_VID_COMP0_SF_LIV_VID_SCA_FACT0_SHIFT   0
#define XDC_AV_BUF_LIVE_VID_COMP0_SF_LIV_VID_SCA_FACT0_WIDTH   17
#define XDC_AV_BUF_LIVE_VID_COMP0_SF_LIV_VID_SCA_FACT0_MASK    0x0001FFFF

/**
 *  * Register: XDC_AV_BUF_LIVE_VID_COMP1_SF
 *   */
#define XDC_AV_BUF_LIVE_VID_COMP1_SF         0x0000B21C

#define XDC_AV_BUF_LIVE_VID_COMP1_SF_LIV_VID_SCA_FACT1_SHIFT   0
#define XDC_AV_BUF_LIVE_VID_COMP1_SF_LIV_VID_SCA_FACT1_WIDTH   17
#define XDC_AV_BUF_LIVE_VID_COMP1_SF_LIV_VID_SCA_FACT1_MASK    0x0001FFFF

/**
 *  * Register: XDC_AV_BUF_LIVE_VID_COMP2_SF
 *   */
#define XDC_AV_BUF_LIVE_VID_COMP2_SF         0x0000B220

#define XDC_AV_BUF_LIVE_VID_COMP2_SF_LIV_VID_SCA_FACT2_SHIFT   0
#define XDC_AV_BUF_LIVE_VID_COMP2_SF_LIV_VID_SCA_FACT2_WIDTH   17
#define XDC_AV_BUF_LIVE_VID_COMP2_SF_LIV_VID_SCA_FACT2_MASK    0x0001FFFF

/**
 *  * Register: XDC_AV_BUF_LIVE_VID_CFG
 *   */
#define XDC_AV_BUF_LIVE_VID_CFG         0x0000B224

#define XDC_AV_BUF_LIVE_VID_CFG_CB_FIRST_SHIFT   8
#define XDC_AV_BUF_LIVE_VID_CFG_CB_FIRST_WIDTH   1
#define XDC_AV_BUF_LIVE_VID_CFG_CB_FIRST_MASK    0x00000100

#define XDC_AV_BUF_LIVE_VID_CFG_FORMAT_SHIFT   4
#define XDC_AV_BUF_LIVE_VID_CFG_FORMAT_WIDTH   2
#define XDC_AV_BUF_LIVE_VID_CFG_FORMAT_MASK    0x00000030

#define XDC_AV_BUF_LIVE_VID_CFG_BPC_SHIFT   0
#define XDC_AV_BUF_LIVE_VID_CFG_BPC_WIDTH   3
#define XDC_AV_BUF_LIVE_VID_CFG_BPC_MASK    0x00000007

/**
 *  * Register: XDC_AV_BUF_LIVE_GFX_COMP0_SF
 *   */
#define XDC_AV_BUF_LIVE_GFX_COMP0_SF         0x0000B228

#define XDC_AV_BUF_LIVE_GFX_COMP0_SF_LIV_VID_SCA_FACT0_SHIFT   0
#define XDC_AV_BUF_LIVE_GFX_COMP0_SF_LIV_VID_SCA_FACT0_WIDTH   17
#define XDC_AV_BUF_LIVE_GFX_COMP0_SF_LIV_VID_SCA_FACT0_MASK    0x0001FFFF

/**
 *  * Register: XDC_AV_BUF_LIVE_GFX_COMP1_SF
 *   */
#define XDC_AV_BUF_LIVE_GFX_COMP1_SF         0x0000B22C

#define XDC_AV_BUF_LIVE_GFX_COMP1_SF_LIV_VID_SCA_FACT1_SHIFT   0
#define XDC_AV_BUF_LIVE_GFX_COMP1_SF_LIV_VID_SCA_FACT1_WIDTH   17
#define XDC_AV_BUF_LIVE_GFX_COMP1_SF_LIV_VID_SCA_FACT1_MASK    0x0001FFFF

/**
 *  * Register: XDC_AV_BUF_LIVE_GFX_COMP2_SF
 *   */
#define XDC_AV_BUF_LIVE_GFX_COMP2_SF         0x0000B230

#define XDC_AV_BUF_LIVE_GFX_COMP2_SF_LIV_VID_SCA_FACT2_SHIFT   0
#define XDC_AV_BUF_LIVE_GFX_COMP2_SF_LIV_VID_SCA_FACT2_WIDTH   17
#define XDC_AV_BUF_LIVE_GFX_COMP2_SF_LIV_VID_SCA_FACT2_MASK    0x0001FFFF

/**
 *  * Register: XDC_AV_BUF_LIVE_GFX_CFG
 *   */
#define XDC_AV_BUF_LIVE_GFX_CFG         0x0000B234

#define XDC_AV_BUF_LIVE_GFX_CFG_CB_FIRST_SHIFT   8
#define XDC_AV_BUF_LIVE_GFX_CFG_CB_FIRST_WIDTH   1
#define XDC_AV_BUF_LIVE_GFX_CFG_CB_FIRST_MASK    0x00000100

#define XDC_AV_BUF_LIVE_GFX_CFG_FORMAT_SHIFT   4
#define XDC_AV_BUF_LIVE_GFX_CFG_FORMAT_WIDTH   2
#define XDC_AV_BUF_LIVE_GFX_CFG_FORMAT_MASK    0x00000030

#define XDC_AV_BUF_LIVE_GFX_CFG_BPC_SHIFT   0
#define XDC_AV_BUF_LIVE_GFX_CFG_BPC_WIDTH   3
#define XDC_AV_BUF_LIVE_GFX_CFG_BPC_MASK    0x00000007

/**
 *  * Register: XDC_AUD_MIXER_VOLUME_CONTROL
 *   */
#define XDC_AUD_MIXER_VOLUME_CONTROL         0x0000C000

#define XDC_AUD_MIXER_VOLUME_CONTROL_VOL_CTRL_CH1_SHIFT   16
#define XDC_AUD_MIXER_VOLUME_CONTROL_VOL_CTRL_CH1_WIDTH   16
#define XDC_AUD_MIXER_VOLUME_CONTROL_VOL_CTRL_CH1_MASK    0xFFFF0000

#define XDC_AUD_MIXER_VOLUME_CONTROL_VOL_CTRL_CH0_SHIFT   0
#define XDC_AUD_MIXER_VOLUME_CONTROL_VOL_CTRL_CH0_WIDTH   16
#define XDC_AUD_MIXER_VOLUME_CONTROL_VOL_CTRL_CH0_MASK    0x0000FFFF

/**
 *  * Register: XDC_AUD_MIXER_META_DATA
 *   */
#define XDC_AUD_MIXER_META_DATA         0x0000C004

#define XDC_AUD_MIXER_META_DATA_AUD_META_DATA_SEL_SHIFT   0
#define XDC_AUD_MIXER_META_DATA_AUD_META_DATA_SEL_WIDTH   1
#define XDC_AUD_MIXER_META_DATA_AUD_META_DATA_SEL_MASK    0x00000001

/**
 *  * Register: XDC_AUD_CH_STATUS01_REG0
 *   */
#define XDC_AUD_CH_STATUS01_REG0         0x0000C008

#define XDC_AUD_CH_STATUS01_REG0_STATUS0_SHIFT   0
#define XDC_AUD_CH_STATUS01_REG0_STATUS0_WIDTH   32
#define XDC_AUD_CH_STATUS01_REG0_STATUS0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS01_REG1
 *   */
#define XDC_AUD_CH_STATUS01_REG1         0x0000C00C

#define XDC_AUD_CH_STATUS01_REG1_STATUS1_SHIFT   0
#define XDC_AUD_CH_STATUS01_REG1_STATUS1_WIDTH   32
#define XDC_AUD_CH_STATUS01_REG1_STATUS1_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS01_REG2
 *   */
#define XDC_AUD_CH_STATUS01_REG2         0x0000C010

#define XDC_AUD_CH_STATUS01_REG2_STATUS2_SHIFT   0
#define XDC_AUD_CH_STATUS01_REG2_STATUS2_WIDTH   32
#define XDC_AUD_CH_STATUS01_REG2_STATUS2_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS01_REG3
 *   */
#define XDC_AUD_CH_STATUS01_REG3         0x0000C014

#define XDC_AUD_CH_STATUS01_REG3_STATUS3_SHIFT   0
#define XDC_AUD_CH_STATUS01_REG3_STATUS3_WIDTH   32
#define XDC_AUD_CH_STATUS01_REG3_STATUS3_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS01_REG4
 *   */
#define XDC_AUD_CH_STATUS01_REG4         0x0000C018

#define XDC_AUD_CH_STATUS01_REG4_STATUS4_SHIFT   0
#define XDC_AUD_CH_STATUS01_REG4_STATUS4_WIDTH   32
#define XDC_AUD_CH_STATUS01_REG4_STATUS4_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS01_REG5
 *   */
#define XDC_AUD_CH_STATUS01_REG5         0x0000C01C

#define XDC_AUD_CH_STATUS01_REG5_STATUS5_SHIFT   0
#define XDC_AUD_CH_STATUS01_REG5_STATUS5_WIDTH   32
#define XDC_AUD_CH_STATUS01_REG5_STATUS5_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS23_REG0
 *   */
#define XDC_AUD_CH_STATUS23_REG0         0x0000C020

#define XDC_AUD_CH_STATUS23_REG0_STATUS0_SHIFT   0
#define XDC_AUD_CH_STATUS23_REG0_STATUS0_WIDTH   32
#define XDC_AUD_CH_STATUS23_REG0_STATUS0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS23_REG1
 *   */
#define XDC_AUD_CH_STATUS23_REG1         0x0000C024

#define XDC_AUD_CH_STATUS23_REG1_STATUS1_SHIFT   0
#define XDC_AUD_CH_STATUS23_REG1_STATUS1_WIDTH   32
#define XDC_AUD_CH_STATUS23_REG1_STATUS1_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS23_REG2
 *   */
#define XDC_AUD_CH_STATUS23_REG2         0x0000C028

#define XDC_AUD_CH_STATUS23_REG2_STATUS2_SHIFT   0
#define XDC_AUD_CH_STATUS23_REG2_STATUS2_WIDTH   32
#define XDC_AUD_CH_STATUS23_REG2_STATUS2_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS23_REG3
 *   */
#define XDC_AUD_CH_STATUS23_REG3         0x0000C02C

#define XDC_AUD_CH_STATUS23_REG3_STATUS3_SHIFT   0
#define XDC_AUD_CH_STATUS23_REG3_STATUS3_WIDTH   32
#define XDC_AUD_CH_STATUS23_REG3_STATUS3_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS23_REG4
 *   */
#define XDC_AUD_CH_STATUS23_REG4         0x0000C030

#define XDC_AUD_CH_STATUS23_REG4_STATUS4_SHIFT   0
#define XDC_AUD_CH_STATUS23_REG4_STATUS4_WIDTH   32
#define XDC_AUD_CH_STATUS23_REG4_STATUS4_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS23_REG5
 *   */
#define XDC_AUD_CH_STATUS23_REG5         0x0000C034

#define XDC_AUD_CH_STATUS23_REG5_STATUS5_SHIFT   0
#define XDC_AUD_CH_STATUS23_REG5_STATUS5_WIDTH   32
#define XDC_AUD_CH_STATUS23_REG5_STATUS5_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS45_REG0
 *   */
#define XDC_AUD_CH_STATUS45_REG0         0x0000C038

#define XDC_AUD_CH_STATUS45_REG0_STATUS0_SHIFT   0
#define XDC_AUD_CH_STATUS45_REG0_STATUS0_WIDTH   32
#define XDC_AUD_CH_STATUS45_REG0_STATUS0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS45_REG1
 *   */
#define XDC_AUD_CH_STATUS45_REG1         0x0000C03C

#define XDC_AUD_CH_STATUS45_REG1_STATUS1_SHIFT   0
#define XDC_AUD_CH_STATUS45_REG1_STATUS1_WIDTH   32
#define XDC_AUD_CH_STATUS45_REG1_STATUS1_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS45_REG2
 *   */
#define XDC_AUD_CH_STATUS45_REG2         0x0000C040

#define XDC_AUD_CH_STATUS45_REG2_STATUS2_SHIFT   0
#define XDC_AUD_CH_STATUS45_REG2_STATUS2_WIDTH   32
#define XDC_AUD_CH_STATUS45_REG2_STATUS2_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS45_REG3
 *   */
#define XDC_AUD_CH_STATUS45_REG3         0x0000C044

#define XDC_AUD_CH_STATUS45_REG3_STATUS3_SHIFT   0
#define XDC_AUD_CH_STATUS45_REG3_STATUS3_WIDTH   32
#define XDC_AUD_CH_STATUS45_REG3_STATUS3_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS45_REG4
 *   */
#define XDC_AUD_CH_STATUS45_REG4         0x0000C048

#define XDC_AUD_CH_STATUS45_REG4_STATUS4_SHIFT   0
#define XDC_AUD_CH_STATUS45_REG4_STATUS4_WIDTH   32
#define XDC_AUD_CH_STATUS45_REG4_STATUS4_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS45_REG5
 *   */
#define XDC_AUD_CH_STATUS45_REG5         0x0000C04C

#define XDC_AUD_CH_STATUS45_REG5_STATUS5_SHIFT   0
#define XDC_AUD_CH_STATUS45_REG5_STATUS5_WIDTH   32
#define XDC_AUD_CH_STATUS45_REG5_STATUS5_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS67_REG0
 *   */
#define XDC_AUD_CH_STATUS67_REG0         0x0000C050

#define XDC_AUD_CH_STATUS67_REG0_STATUS0_SHIFT   0
#define XDC_AUD_CH_STATUS67_REG0_STATUS0_WIDTH   32
#define XDC_AUD_CH_STATUS67_REG0_STATUS0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS67_REG1
 *   */
#define XDC_AUD_CH_STATUS67_REG1         0x0000C054

#define XDC_AUD_CH_STATUS67_REG1_STATUS1_SHIFT   0
#define XDC_AUD_CH_STATUS67_REG1_STATUS1_WIDTH   32
#define XDC_AUD_CH_STATUS67_REG1_STATUS1_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS67_REG2
 *   */
#define XDC_AUD_CH_STATUS67_REG2         0x0000C058

#define XDC_AUD_CH_STATUS67_REG2_STATUS2_SHIFT   0
#define XDC_AUD_CH_STATUS67_REG2_STATUS2_WIDTH   32
#define XDC_AUD_CH_STATUS67_REG2_STATUS2_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS67_REG3
 *   */
#define XDC_AUD_CH_STATUS67_REG3         0x0000C05C

#define XDC_AUD_CH_STATUS67_REG3_STATUS3_SHIFT   0
#define XDC_AUD_CH_STATUS67_REG3_STATUS3_WIDTH   32
#define XDC_AUD_CH_STATUS67_REG3_STATUS3_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS67_REG4
 *   */
#define XDC_AUD_CH_STATUS67_REG4         0x0000C060

#define XDC_AUD_CH_STATUS67_REG4_STATUS4_SHIFT   0
#define XDC_AUD_CH_STATUS67_REG4_STATUS4_WIDTH   32
#define XDC_AUD_CH_STATUS67_REG4_STATUS4_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_STATUS67_REG5
 *   */
#define XDC_AUD_CH_STATUS67_REG5         0x0000C064

#define XDC_AUD_CH_STATUS67_REG5_STATUS5_SHIFT   0
#define XDC_AUD_CH_STATUS67_REG5_STATUS5_WIDTH   32
#define XDC_AUD_CH_STATUS67_REG5_STATUS5_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_0_DATA_REG0
 *   */
#define XDC_AUD_CH_0_DATA_REG0         0x0000C068

#define XDC_AUD_CH_0_DATA_REG0_USER_DATA0_SHIFT   0
#define XDC_AUD_CH_0_DATA_REG0_USER_DATA0_WIDTH   32
#define XDC_AUD_CH_0_DATA_REG0_USER_DATA0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_0_DATA_REG1
 *   */
#define XDC_AUD_CH_0_DATA_REG1         0x0000C06C

#define XDC_AUD_CH_0_DATA_REG1_USER_DATA1_SHIFT   0
#define XDC_AUD_CH_0_DATA_REG1_USER_DATA1_WIDTH   32
#define XDC_AUD_CH_0_DATA_REG1_USER_DATA1_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_0_DATA_REG2
 *   */
#define XDC_AUD_CH_0_DATA_REG2         0x0000C070

#define XDC_AUD_CH_0_DATA_REG2_USER_DATA2_SHIFT   0
#define XDC_AUD_CH_0_DATA_REG2_USER_DATA2_WIDTH   32
#define XDC_AUD_CH_0_DATA_REG2_USER_DATA2_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_0_DATA_REG3
 *   */
#define XDC_AUD_CH_0_DATA_REG3         0x0000C074

#define XDC_AUD_CH_0_DATA_REG3_USER_DATA3_SHIFT   0
#define XDC_AUD_CH_0_DATA_REG3_USER_DATA3_WIDTH   32
#define XDC_AUD_CH_0_DATA_REG3_USER_DATA3_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_0_DATA_REG4
 *   */
#define XDC_AUD_CH_0_DATA_REG4         0x0000C078

#define XDC_AUD_CH_0_DATA_REG4_USER_DATA4_SHIFT   0
#define XDC_AUD_CH_0_DATA_REG4_USER_DATA4_WIDTH   32
#define XDC_AUD_CH_0_DATA_REG4_USER_DATA4_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_0_DATA_REG5
 *   */
#define XDC_AUD_CH_0_DATA_REG5         0x0000C07C

#define XDC_AUD_CH_0_DATA_REG5_USER_DATA5_SHIFT   0
#define XDC_AUD_CH_0_DATA_REG5_USER_DATA5_WIDTH   32
#define XDC_AUD_CH_0_DATA_REG5_USER_DATA5_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_1_DATA_REG0
 *   */
#define XDC_AUD_CH_1_DATA_REG0         0x0000C080

#define XDC_AUD_CH_1_DATA_REG0_USER_DATA0_SHIFT   0
#define XDC_AUD_CH_1_DATA_REG0_USER_DATA0_WIDTH   32
#define XDC_AUD_CH_1_DATA_REG0_USER_DATA0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_1_DATA_REG1
 *   */
#define XDC_AUD_CH_1_DATA_REG1         0x0000C084

#define XDC_AUD_CH_1_DATA_REG1_USER_DATA1_SHIFT   0
#define XDC_AUD_CH_1_DATA_REG1_USER_DATA1_WIDTH   32
#define XDC_AUD_CH_1_DATA_REG1_USER_DATA1_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_1_DATA_REG2
 *   */
#define XDC_AUD_CH_1_DATA_REG2         0x0000C088

#define XDC_AUD_CH_1_DATA_REG2_USER_DATA2_SHIFT   0
#define XDC_AUD_CH_1_DATA_REG2_USER_DATA2_WIDTH   32
#define XDC_AUD_CH_1_DATA_REG2_USER_DATA2_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_1_DATA_REG3
 *   */
#define XDC_AUD_CH_1_DATA_REG3         0x0000C08C

#define XDC_AUD_CH_1_DATA_REG3_USER_DATA3_SHIFT   0
#define XDC_AUD_CH_1_DATA_REG3_USER_DATA3_WIDTH   32
#define XDC_AUD_CH_1_DATA_REG3_USER_DATA3_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_1_DATA_REG4
 *   */
#define XDC_AUD_CH_1_DATA_REG4         0x0000C090

#define XDC_AUD_CH_1_DATA_REG4_USER_DATA4_SHIFT   0
#define XDC_AUD_CH_1_DATA_REG4_USER_DATA4_WIDTH   32
#define XDC_AUD_CH_1_DATA_REG4_USER_DATA4_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_1_DATA_REG5
 *   */
#define XDC_AUD_CH_1_DATA_REG5         0x0000C094

#define XDC_AUD_CH_1_DATA_REG5_USER_DATA5_SHIFT   0
#define XDC_AUD_CH_1_DATA_REG5_USER_DATA5_WIDTH   32
#define XDC_AUD_CH_1_DATA_REG5_USER_DATA5_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_2_DATA_REG0
 *   */
#define XDC_AUD_CH_2_DATA_REG0         0x0000C098

#define XDC_AUD_CH_2_DATA_REG0_USER_DATA0_SHIFT   0
#define XDC_AUD_CH_2_DATA_REG0_USER_DATA0_WIDTH   32
#define XDC_AUD_CH_2_DATA_REG0_USER_DATA0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_2_DATA_REG1
 *   */
#define XDC_AUD_CH_2_DATA_REG1         0x0000C09C

#define XDC_AUD_CH_2_DATA_REG1_USER_DATA1_SHIFT   0
#define XDC_AUD_CH_2_DATA_REG1_USER_DATA1_WIDTH   32
#define XDC_AUD_CH_2_DATA_REG1_USER_DATA1_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_2_DATA_REG2
 *   */
#define XDC_AUD_CH_2_DATA_REG2         0x0000C0A0

#define XDC_AUD_CH_2_DATA_REG2_USER_DATA2_SHIFT   0
#define XDC_AUD_CH_2_DATA_REG2_USER_DATA2_WIDTH   32
#define XDC_AUD_CH_2_DATA_REG2_USER_DATA2_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_2_DATA_REG3
 *   */
#define XDC_AUD_CH_2_DATA_REG3         0x0000C0A4

#define XDC_AUD_CH_2_DATA_REG3_USER_DATA3_SHIFT   0
#define XDC_AUD_CH_2_DATA_REG3_USER_DATA3_WIDTH   32
#define XDC_AUD_CH_2_DATA_REG3_USER_DATA3_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_2_DATA_REG4
 *   */
#define XDC_AUD_CH_2_DATA_REG4         0x0000C0A8

#define XDC_AUD_CH_2_DATA_REG4_USER_DATA4_SHIFT   0
#define XDC_AUD_CH_2_DATA_REG4_USER_DATA4_WIDTH   32
#define XDC_AUD_CH_2_DATA_REG4_USER_DATA4_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_2_DATA_REG5
 *   */
#define XDC_AUD_CH_2_DATA_REG5         0x0000C0AC

#define XDC_AUD_CH_2_DATA_REG5_USER_DATA5_SHIFT   0
#define XDC_AUD_CH_2_DATA_REG5_USER_DATA5_WIDTH   32
#define XDC_AUD_CH_2_DATA_REG5_USER_DATA5_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_3_DATA_REG0
 *   */
#define XDC_AUD_CH_3_DATA_REG0         0x0000C0B0

#define XDC_AUD_CH_3_DATA_REG0_USER_DATA0_SHIFT   0
#define XDC_AUD_CH_3_DATA_REG0_USER_DATA0_WIDTH   32
#define XDC_AUD_CH_3_DATA_REG0_USER_DATA0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_3_DATA_REG1
 *   */
#define XDC_AUD_CH_3_DATA_REG1         0x0000C0B4

#define XDC_AUD_CH_3_DATA_REG1_USER_DATA1_SHIFT   0
#define XDC_AUD_CH_3_DATA_REG1_USER_DATA1_WIDTH   32
#define XDC_AUD_CH_3_DATA_REG1_USER_DATA1_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_3_DATA_REG2
 *   */
#define XDC_AUD_CH_3_DATA_REG2         0x0000C0B8

#define XDC_AUD_CH_3_DATA_REG2_USER_DATA2_SHIFT   0
#define XDC_AUD_CH_3_DATA_REG2_USER_DATA2_WIDTH   32
#define XDC_AUD_CH_3_DATA_REG2_USER_DATA2_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_3_DATA_REG3
 *   */
#define XDC_AUD_CH_3_DATA_REG3         0x0000C0BC

#define XDC_AUD_CH_3_DATA_REG3_USER_DATA3_SHIFT   0
#define XDC_AUD_CH_3_DATA_REG3_USER_DATA3_WIDTH   32
#define XDC_AUD_CH_3_DATA_REG3_USER_DATA3_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_3_DATA_REG4
 *   */
#define XDC_AUD_CH_3_DATA_REG4         0x0000C0C0

#define XDC_AUD_CH_3_DATA_REG4_USER_DATA4_SHIFT   0
#define XDC_AUD_CH_3_DATA_REG4_USER_DATA4_WIDTH   32
#define XDC_AUD_CH_3_DATA_REG4_USER_DATA4_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_3_DATA_REG5
 *   */
#define XDC_AUD_CH_3_DATA_REG5         0x0000C0C4

#define XDC_AUD_CH_3_DATA_REG5_USER_DATA5_SHIFT   0
#define XDC_AUD_CH_3_DATA_REG5_USER_DATA5_WIDTH   32
#define XDC_AUD_CH_3_DATA_REG5_USER_DATA5_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_4_DATA_REG0
 *   */
#define XDC_AUD_CH_4_DATA_REG0         0x0000C0C8

#define XDC_AUD_CH_4_DATA_REG0_USER_DATA0_SHIFT   0
#define XDC_AUD_CH_4_DATA_REG0_USER_DATA0_WIDTH   32
#define XDC_AUD_CH_4_DATA_REG0_USER_DATA0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_4_DATA_REG1
 *   */
#define XDC_AUD_CH_4_DATA_REG1         0x0000C0CC

#define XDC_AUD_CH_4_DATA_REG1_USER_DATA1_SHIFT   0
#define XDC_AUD_CH_4_DATA_REG1_USER_DATA1_WIDTH   32
#define XDC_AUD_CH_4_DATA_REG1_USER_DATA1_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_4_DATA_REG2
 *   */
#define XDC_AUD_CH_4_DATA_REG2         0x0000C0D0

#define XDC_AUD_CH_4_DATA_REG2_USER_DATA2_SHIFT   0
#define XDC_AUD_CH_4_DATA_REG2_USER_DATA2_WIDTH   32
#define XDC_AUD_CH_4_DATA_REG2_USER_DATA2_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_4_DATA_REG3
 *   */
#define XDC_AUD_CH_4_DATA_REG3         0x0000C0D4

#define XDC_AUD_CH_4_DATA_REG3_USER_DATA3_SHIFT   0
#define XDC_AUD_CH_4_DATA_REG3_USER_DATA3_WIDTH   32
#define XDC_AUD_CH_4_DATA_REG3_USER_DATA3_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_4_DATA_REG4
 *   */
#define XDC_AUD_CH_4_DATA_REG4         0x0000C0D8

#define XDC_AUD_CH_4_DATA_REG4_USER_DATA4_SHIFT   0
#define XDC_AUD_CH_4_DATA_REG4_USER_DATA4_WIDTH   32
#define XDC_AUD_CH_4_DATA_REG4_USER_DATA4_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_4_DATA_REG5
 *   */
#define XDC_AUD_CH_4_DATA_REG5         0x0000C0DC

#define XDC_AUD_CH_4_DATA_REG5_USER_DATA5_SHIFT   0
#define XDC_AUD_CH_4_DATA_REG5_USER_DATA5_WIDTH   32
#define XDC_AUD_CH_4_DATA_REG5_USER_DATA5_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_5_DATA_REG0
 *   */
#define XDC_AUD_CH_5_DATA_REG0         0x0000C0E0

#define XDC_AUD_CH_5_DATA_REG0_USER_DATA0_SHIFT   0
#define XDC_AUD_CH_5_DATA_REG0_USER_DATA0_WIDTH   32
#define XDC_AUD_CH_5_DATA_REG0_USER_DATA0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_5_DATA_REG1
 *   */
#define XDC_AUD_CH_5_DATA_REG1         0x0000C0E4

#define XDC_AUD_CH_5_DATA_REG1_USER_DATA1_SHIFT   0
#define XDC_AUD_CH_5_DATA_REG1_USER_DATA1_WIDTH   32
#define XDC_AUD_CH_5_DATA_REG1_USER_DATA1_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_5_DATA_REG2
 *   */
#define XDC_AUD_CH_5_DATA_REG2         0x0000C0E8

#define XDC_AUD_CH_5_DATA_REG2_USER_DATA2_SHIFT   0
#define XDC_AUD_CH_5_DATA_REG2_USER_DATA2_WIDTH   32
#define XDC_AUD_CH_5_DATA_REG2_USER_DATA2_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_5_DATA_REG3
 *   */
#define XDC_AUD_CH_5_DATA_REG3         0x0000C0EC

#define XDC_AUD_CH_5_DATA_REG3_USER_DATA3_SHIFT   0
#define XDC_AUD_CH_5_DATA_REG3_USER_DATA3_WIDTH   32
#define XDC_AUD_CH_5_DATA_REG3_USER_DATA3_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_5_DATA_REG4
 *   */
#define XDC_AUD_CH_5_DATA_REG4         0x0000C0F0

#define XDC_AUD_CH_5_DATA_REG4_USER_DATA4_SHIFT   0
#define XDC_AUD_CH_5_DATA_REG4_USER_DATA4_WIDTH   32
#define XDC_AUD_CH_5_DATA_REG4_USER_DATA4_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_5_DATA_REG5
 *   */
#define XDC_AUD_CH_5_DATA_REG5         0x0000C0F4

#define XDC_AUD_CH_5_DATA_REG5_USER_DATA5_SHIFT   0
#define XDC_AUD_CH_5_DATA_REG5_USER_DATA5_WIDTH   32
#define XDC_AUD_CH_5_DATA_REG5_USER_DATA5_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_6_DATA_REG0
 *   */
#define XDC_AUD_CH_6_DATA_REG0         0x0000C0F8

#define XDC_AUD_CH_6_DATA_REG0_USER_DATA0_SHIFT   0
#define XDC_AUD_CH_6_DATA_REG0_USER_DATA0_WIDTH   32
#define XDC_AUD_CH_6_DATA_REG0_USER_DATA0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_6_DATA_REG1
 *   */
#define XDC_AUD_CH_6_DATA_REG1         0x0000C0FC

#define XDC_AUD_CH_6_DATA_REG1_USER_DATA1_SHIFT   0
#define XDC_AUD_CH_6_DATA_REG1_USER_DATA1_WIDTH   32
#define XDC_AUD_CH_6_DATA_REG1_USER_DATA1_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_6_DATA_REG2
 *   */
#define XDC_AUD_CH_6_DATA_REG2         0x0000C100

#define XDC_AUD_CH_6_DATA_REG2_USER_DATA2_SHIFT   0
#define XDC_AUD_CH_6_DATA_REG2_USER_DATA2_WIDTH   32
#define XDC_AUD_CH_6_DATA_REG2_USER_DATA2_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_6_DATA_REG3
 *   */
#define XDC_AUD_CH_6_DATA_REG3         0x0000C104

#define XDC_AUD_CH_6_DATA_REG3_USER_DATA3_SHIFT   0
#define XDC_AUD_CH_6_DATA_REG3_USER_DATA3_WIDTH   32
#define XDC_AUD_CH_6_DATA_REG3_USER_DATA3_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_6_DATA_REG4
 *   */
#define XDC_AUD_CH_6_DATA_REG4         0x0000C108

#define XDC_AUD_CH_6_DATA_REG4_USER_DATA4_SHIFT   0
#define XDC_AUD_CH_6_DATA_REG4_USER_DATA4_WIDTH   32
#define XDC_AUD_CH_6_DATA_REG4_USER_DATA4_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_6_DATA_REG6
 *   */
#define XDC_AUD_CH_6_DATA_REG6         0x0000C10C

#define XDC_AUD_CH_6_DATA_REG6_USER_DATA6_SHIFT   0
#define XDC_AUD_CH_6_DATA_REG6_USER_DATA6_WIDTH   32
#define XDC_AUD_CH_6_DATA_REG6_USER_DATA6_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_7_DATA_REG0
 *   */
#define XDC_AUD_CH_7_DATA_REG0         0x0000C110

#define XDC_AUD_CH_7_DATA_REG0_USER_DATA0_SHIFT   0
#define XDC_AUD_CH_7_DATA_REG0_USER_DATA0_WIDTH   32
#define XDC_AUD_CH_7_DATA_REG0_USER_DATA0_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_7_DATA_REG1
 *   */
#define XDC_AUD_CH_7_DATA_REG1         0x0000C114

#define XDC_AUD_CH_7_DATA_REG1_USER_DATA1_SHIFT   0
#define XDC_AUD_CH_7_DATA_REG1_USER_DATA1_WIDTH   32
#define XDC_AUD_CH_7_DATA_REG1_USER_DATA1_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_7_DATA_REG2
 *   */
#define XDC_AUD_CH_7_DATA_REG2         0x0000C118

#define XDC_AUD_CH_7_DATA_REG2_USER_DATA2_SHIFT   0
#define XDC_AUD_CH_7_DATA_REG2_USER_DATA2_WIDTH   32
#define XDC_AUD_CH_7_DATA_REG2_USER_DATA2_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_7_DATA_REG3
 *   */
#define XDC_AUD_CH_7_DATA_REG3         0x0000C11C

#define XDC_AUD_CH_7_DATA_REG3_USER_DATA3_SHIFT   0
#define XDC_AUD_CH_7_DATA_REG3_USER_DATA3_WIDTH   32
#define XDC_AUD_CH_7_DATA_REG3_USER_DATA3_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_7_DATA_REG4
 *   */
#define XDC_AUD_CH_7_DATA_REG4         0x0000C11E

#define XDC_AUD_CH_7_DATA_REG4_USER_DATA4_SHIFT   0
#define XDC_AUD_CH_7_DATA_REG4_USER_DATA4_WIDTH   32
#define XDC_AUD_CH_7_DATA_REG4_USER_DATA4_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_CH_7_DATA_REG5
 *   */
#define XDC_AUD_CH_7_DATA_REG5         0x0000C120

#define XDC_AUD_CH_7_DATA_REG5_USER_DATA5_SHIFT   0
#define XDC_AUD_CH_7_DATA_REG5_USER_DATA5_WIDTH   32
#define XDC_AUD_CH_7_DATA_REG5_USER_DATA5_MASK    0xFFFFFFFF

/**
 *  * Register: XDC_AUD_SOFT_RST
 *   */
#define XDC_AUD_SOFT_RST         0x0000CC00

#define XDC_AUD_SOFT_RST_EXTRA_BS_CONTROL_SHIFT   2
#define XDC_AUD_SOFT_RST_EXTRA_BS_CONTROL_WIDTH   1
#define XDC_AUD_SOFT_RST_EXTRA_BS_CONTROL_MASK    0x00000004

#define XDC_AUD_SOFT_RST_LINE_RST_DISABLE_SHIFT   1
#define XDC_AUD_SOFT_RST_LINE_RST_DISABLE_WIDTH   1
#define XDC_AUD_SOFT_RST_LINE_RST_DISABLE_MASK    0x00000002

#define XDC_AUD_SOFT_RST_AUD_SRST_SHIFT   0
#define XDC_AUD_SOFT_RST_AUD_SRST_WIDTH   1
#define XDC_AUD_SOFT_RST_AUD_SRST_MASK    0x00000001

/**
 *  * Register: XDC_AV_CHBUF_AUD
 *   */
#define XDC_AV_CHBUF_AUD         0x0000CC08

#define XDC_AV_CHBUF_AUD_BURST_LENGTH_SHIFT   2
#define XDC_AV_CHBUF_AUD_BURST_LENGTH_WIDTH   5
#define XDC_AV_CHBUF_AUD_BURST_LENGTH_MASK    0x0000007C

#define XDC_AV_CHBUF_AUD_FLUSH_SHIFT   1
#define XDC_AV_CHBUF_AUD_FLUSH_WIDTH   1
#define XDC_AV_CHBUF_AUD_FLUSH_MASK    0x00000002

#define XDC_AV_CHBUF_AUD_EN_SHIFT   0
#define XDC_AV_CHBUF_AUD_EN_WIDTH   1
#define XDC_AV_CHBUF_AUD_EN_MASK    0x00000001

/**
 *  * Register: XDC_NL_AUD
 *   */
#define XDC_NL_AUD         0x0000CC0C

#define XDC_NL_AUD_SAMPLE_RATE_SHIFT   3
#define XDC_NL_AUD_SAMPLE_RATE_WIDTH   12
#define XDC_NL_AUD_SAMPLE_RATE_MASK    0x00007FF8

#define XDC_NL_AUD_CH_SEL_SHIFT   0
#define XDC_NL_AUD_CH_SEL_WIDTH   3
#define XDC_NL_AUD_CH_SEL_MASK    0x00000007

/**
 *  * Register: XDC_AV_CHBUF_CURSOR_SDP
 *   */
#define XDC_AV_CHBUF_CURSOR_SDP         0x0000CC1C

#define XDC_AV_CHBUF_CURSOR_SDP_BURST_LENGTH_SHIFT   2
#define XDC_AV_CHBUF_CURSOR_SDP_BURST_LENGTH_WIDTH   5
#define XDC_AV_CHBUF_CURSOR_SDP_BURST_LENGTH_MASK    0x0000007C

#define XDC_AV_CHBUF_CURSOR_SDP_FLUSH_SHIFT   1
#define XDC_AV_CHBUF_CURSOR_SDP_FLUSH_WIDTH   1
#define XDC_AV_CHBUF_CURSOR_SDP_FLUSH_MASK    0x00000002

#define XDC_AV_CHBUF_CURSOR_SDP_EN_SHIFT   0
#define XDC_AV_CHBUF_CURSOR_SDP_EN_WIDTH   1
#define XDC_AV_CHBUF_CURSOR_SDP_EN_MASK    0x00000001

/**
 *  * Register: XDC_CURSOR_COORDINATE
 *   */
#define XDC_CURSOR_COORDINATE         0x0000CC20

#define XDC_CURSOR_ENABLE_SHIFT     28
#define XDC_CURSOR_ENABLE_WIDTH     1
#define XDC_CURSOR_ENABLE_MASK      0x10000000

#define XDC_CURSOR_COORD_Y_SHIFT   14
#define XDC_CURSOR_COORD_Y_WIDTH   14
#define XDC_CURSOR_COORD_Y_MASK    0x07FFE000

#define XDC_CURSOR_COORD_X_SHIFT   0
#define XDC_CURSOR_COORD_X_WIDTH   14
#define XDC_CURSOR_COORD_X_MASK    0x00003FFF

/**
 *  * Register: XDC_CURSOR_SIZE
 *   */
#define XDC_CURSOR_SIZE         0x0000CC24

#define XDC_CURSOR_SIZE_Y_SHIFT   8
#define XDC_CURSOR_SIZE_Y_WIDTH   8
#define XDC_CURSOR_SIZE_Y_MASK    0x0000FF00

#define XDC_CURSOR_SIZE_X_SHIFT   0
#define XDC_CURSOR_SIZE_X_WIDTH   8
#define XDC_CURSOR_SIZE_X_MASK    0x000000FF

/**
 *  * Register: XDC_RDY_INTERVAL
 *   */
#define XDC_RDY_INTERVAL         0x0000CC28

#define XDC_RDY_INTERVAL_CURSOR_SDP_SHIFT   0
#define XDC_RDY_INTERVAL_CURSOR_SDP_WIDTH   12
#define XDC_RDY_INTERVAL_CURSOR_SDP_MASK    0x00000FFF

/**
 *  * Register: XDC_V0
 *   */
#define XDC_V0         0x0000CC2C

#define XDC_V0_PB_SELF_CLEAR_SHIFT   29
#define XDC_V0_PB_SELF_CLEAR_WIDTH   1
#define XDC_V0_PB_SELF_CLEAR_MASK    0x20000000

#define XDC_V0_PB_ENABLE_SHIFT   28
#define XDC_V0_PB_ENABLE_WIDTH   1
#define XDC_V0_PB_ENABLE_MASK    0x10000000

#define XDC_V0_PB_COORD_Y_SHIFT   14
#define XDC_V0_PB_COORD_Y_WIDTH   14
#define XDC_V0_PB_COORD_Y_MASK    0x0FFFC000

#define XDC_V0_PB_COORD_X_SHIFT   0
#define XDC_V0_PB_COORD_X_WIDTH   14
#define XDC_V0_PB_COORD_X_MASK    0x00003FFF

/**
 *  * Register: XDC_V0_PARTIALBLEND_SIZE
 *   */
#define XDC_V0_PARTIALBLEND_SIZE         0x0000CC30

#define XDC_V0_PARTIALBLEND_SIZE_Y_SHIFT   14
#define XDC_V0_PARTIALBLEND_SIZE_Y_WIDTH   14
#define XDC_V0_PARTIALBLEND_SIZE_Y_MASK    0x0FFFC000

#define XDC_V0_PARTIALBLEND_SIZE_X_SHIFT   0
#define XDC_V0_PARTIALBLEND_SIZE_X_WIDTH   14
#define XDC_V0_PARTIALBLEND_SIZE_X_MASK    0x000003FF

/**
 *  * Register: XDC_V0_PARTIALBLEND_COORD_OFFSET
 *   */
#define XDC_V0_PARTIALBLEND_COORD_OFFSET         0x0000CC34

#define XDC_V0_PARTIALBLEND_COORD_OFFSET_Y_SHIFT   14
#define XDC_V0_PARTIALBLEND_COORD_OFFSET_Y_WIDTH   14
#define XDC_V0_PARTIALBLEND_COORD_OFFSET_Y_MASK    0x0FFFC000

#define XDC_V0_PARTIALBLEND_COORD_OFFSET_X_SHIFT   0
#define XDC_V0_PARTIALBLEND_COORD_OFFSET_X_WIDTH   14
#define XDC_V0_PARTIALBLEND_COORD_OFFSET_X_MASK    0x000003FF

/**
 *  * Register: XDC_V1
 *   */
#define XDC_V1         0x0000CC3C

#define XDC_V1_PB_SELF_CLEAR_SHIFT   29
#define XDC_V1_PB_SELF_CLEAR_WIDTH   1
#define XDC_V1_PB_SELF_CLEAR_MASK    0x20000000

#define XDC_V1_PB_ENABLE_SHIFT   28
#define XDC_V1_PB_ENABLE_WIDTH   1
#define XDC_V1_PB_ENABLE_MASK    0x10000000

#define XDC_V1_PB_COORD_Y_SHIFT   14
#define XDC_V1_PB_COORD_Y_WIDTH   14
#define XDC_V1_PB_COORD_Y_MASK    0x0FFFC000

#define XDC_V1_PB_COORD_X_SHIFT   0
#define XDC_V1_PB_COORD_X_WIDTH   14
#define XDC_V1_PB_COORD_X_MASK    0x00003FFF

/**
 *  * Register: XDC_V1_PARTIALBLEND_SIZE
 *   */
#define XDC_V1_PARTIALBLEND_SIZE         0x0000CC40

#define XDC_V1_PARTIALBLEND_SIZE_Y_SHIFT   14
#define XDC_V1_PARTIALBLEND_SIZE_Y_WIDTH   14
#define XDC_V1_PARTIALBLEND_SIZE_Y_MASK    0x0FFFC000

#define XDC_V1_PARTIALBLEND_SIZE_X_SHIFT   0
#define XDC_V1_PARTIALBLEND_SIZE_X_WIDTH   14
#define XDC_V1_PARTIALBLEND_SIZE_X_MASK    0x000003FF

/**
 *  * Register: XDC_V1_PARTIALBLEND_COORD_OFFSET
 *   */
#define XDC_V1_PARTIALBLEND_COORD_OFFSET         0x0000CC44

#define XDC_V1_PARTIALBLEND_COORD_OFFSET_Y_SHIFT   14
#define XDC_V1_PARTIALBLEND_COORD_OFFSET_Y_WIDTH   14
#define XDC_V1_PARTIALBLEND_COORD_OFFSET_Y_MASK    0x0FFFC000

#define XDC_V1_PARTIALBLEND_COORD_OFFSET_X_SHIFT   0
#define XDC_V1_PARTIALBLEND_COORD_OFFSET_X_WIDTH   14
#define XDC_V1_PARTIALBLEND_COORD_OFFSET_X_MASK    0x000003FF

/**
 *  * Register: XDC_LINE_OR_TILE
 *   */
#define XDC_LINE_OR_TILE         0x0000CC48

#define XDC_LINE_OR_TILE_V1_SHIFT   1
#define XDC_LINE_OR_TILE_V1_WIDTH   1
#define XDC_LINE_OR_TILE_V1_MASK    0x00000002

#define XDC_LINE_OR_TILE_V0_SHIFT   0
#define XDC_LINE_OR_TILE_V0_WIDTH   1
#define XDC_LINE_OR_TILE_V0_MASK    0x00000001

/**
 *  * Register: XDC_DC_BYPASS
 *   */
#define XDC_DC_BYPASS         0x0000CC4C

#define XDC_DC_BYPASS_MODE_SHIFT   0
#define XDC_DC_BYPASS_MODE_WIDTH   1
#define XDC_DC_BYPASS_MODE_MASK    0x00000001

/**
 *  * Register: XDC_SDP_EMPTY
 *   */
#define XDC_SDP_EMPTY         0x0000CC50

#define XDC_SDP_EMPTY_THRESHOLD_SHIFT   0
#define XDC_SDP_EMPTY_THRESHOLD_WIDTH   8
#define XDC_SDP_EMPTY_THRESHOLD_MASK    0x0000000F

/**
 *  * Register: XDC_SDP
 *   */
#define XDC_SDP         0x0000CC54

#define XDC_SDP_SELECT_SHIFT   0
#define XDC_SDP_SELECT_WIDTH   1
#define XDC_SDP_SELECT_MASK    0x00000001

/**
 *  * Register: XDC_DP
 *   */
#define XDC_DP         0x0000CC58

#define XDC_DP_SDP_ACK_SEL_SHIFT   0
#define XDC_DP_SDP_ACK_SEL_WIDTH   1
#define XDC_DP_SDP_ACK_SEL_MASK    0x00000001

/**
 *  * Register: XDC_DC_VID_CLK
 *   */
#define XDC_DC_VID_CLK         0x0000CC5C

#define XDC_DC_VID_CLK_SELECT_SHIFT   0
#define XDC_DC_VID_CLK_SELECT_WIDTH   1
#define XDC_DC_VID_CLK_SELECT_MASK    0x00000001

/**
 *  * Register: XDC_DC_AUD_CLK
 *   */
#define XDC_DC_AUD_CLK         0x0000CC60

#define XDC_DC_AUD_CLK_SELECT_SHIFT   0
#define XDC_DC_AUD_CLK_SELECT_WIDTH   1
#define XDC_DC_AUD_CLK_SELECT_MASK    0x00000001

/**
 *  * Register: XDC_DC_AUD
 *   */
#define XDC_DC_AUD         0x0000CC64

#define XDC_DC_AUD_BYPASS_SHIFT   0
#define XDC_DC_AUD_BYPASS_WIDTH   1
#define XDC_DC_AUD_BYPASS_MASK    0x00000001

/**
 *  * Register: XDC_DC_AUDIO
 *   */
#define XDC_DC_AUDIO         0x0000CC68

#define XDC_DC_AUDIO_ENABLE_SHIFT   0
#define XDC_DC_AUDIO_ENABLE_WIDTH   1
#define XDC_DC_AUDIO_ENABLE_MASK    0x00000001

#define XDC_AUDIO_ENABLE    0x1
#define XDC_AUDIO_DISABLE   0x0

/**
 *  * Register: XDC_DC_PL
 *   */
#define XDC_DC_PL         0x0000CC6C

#define XDC_DC_PL_ALIGN_SHIFT   0
#define XDC_DC_PL_ALIGN_WIDTH   1
#define XDC_DC_PL_ALIGN_MASK    0x00000001

/**
 *  * Register: XDC_DC_WPROTS
 *   */
#define XDC_WPROTS         0x0000CC70

#define XDC_WPROTS_ACTIVE_SHIFT   0
#define XDC_WPROTS_ACTIVE_WIDTH   1
#define XDC_WPROTS_ACTIVE_MASK    0x00000001
#define XDC_WPROTS_ENABLE 	     1
#define XDC_WPROTS_DISABLE	     0

/**
 *  * Register: XDC_MISC_CTRL
 *   */
#define XDC_MISC_CTRL         0x0000CC74

#define XDC_MISC_CTRL_SLVERR_ENABLE_SHIFT   0
#define XDC_MISC_CTRL_SLVERR_ENABLE_WIDTH   1
#define XDC_MISC_CTRL_SLVERR_ENABLE_MASK   0x00000001

/**
 *  * Register: XDC_ISR
 *   */
#define XDC_ISR         0x0000CC78

#define XDC_ISR_ADDR_DECODE_ERR_SHIFT   0
#define XDC_ISR_ADDR_DECODE_ERR_WIDTH   1
#define XDC_ISR_ADDR_DECODE_ERR_MASK   0x00000001

/**
 *  * Register: XDC_IMR
 *   */
#define XDC_IMR         0x0000CC80

#define XDC_IMR_ADDR_DECODE_ERR_SHIFT   0
#define XDC_IMR_ADDR_DECODE_ERR_WIDTH   1
#define XDC_IMR_ADDR_DECODE_ERR_MASK   0x00000001

/**
 *  * Register: XDC_IER
 *   */
#define XDC_IER         0x0000CC84

#define XDC_IER_ADDR_DECODE_ERR_SHIFT   0
#define XDC_IER_ADDR_DECODE_ERR_WIDTH   1
#define XDC_IER_ADDR_DECODE_ERR_MASK   0x00000001

/**
 *  * Register: XDC_IDR
 *   */
#define XDC_IDR         0x0000CC88

#define XDC_IDR_ADDR_DECODE_ERR_SHIFT   0
#define XDC_IDR_ADDR_DECODE_ERR_WIDTH   1
#define XDC_IDR_ADDR_DECODE_ERR_MASK   0x00000001

/**
 *  * Register: XDC_ITR
 *   */
#define XDC_ITR         0x0000CC8C

#define XDC_ITR_ADDR_DECODE_ERR_SHIFT   0
#define XDC_ITR_ADDR_DECODE_ERR_WIDTH   1
#define XDC_ITR_ADDR_DECODE_ERR_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS         0x0000CC90

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_STATUS_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK         0x0000CC94

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_MASK_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE         0x0000CC98

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_ENABLE_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE         0x0000CD00

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_DISABLE_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER         0x0000CD04

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_0_31_TRIGGER_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS         0x0000CD08

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_STATUS_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK         0x0000CD0C

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_MASK_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE         0x0000CD10

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_ENABLE_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE         0x0000CD14

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_DISABLE_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER         0x0000CD18

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_32_63_TRIGGER_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS         0x0000CD1C

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_STATUS_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK         0x0000CD20

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_MASK_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE         0x0000CD24

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_ENABLE_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE         0x0000CD28

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_DISABLE_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER
 *   */
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER         0x0000CD2C

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW31_SHIFT   31
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW31_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW30_SHIFT   30
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW30_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW29_SHIFT   29
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW29_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW28_SHIFT   28
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW28_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW27_SHIFT   27
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW27_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW26_SHIFT   26
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW26_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW25_SHIFT   25
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW25_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW24_SHIFT   24
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW24_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW23_SHIFT   23
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW23_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW22_SHIFT   22
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW22_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW21_SHIFT   21
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW21_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW20_SHIFT   20
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW20_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW19_SHIFT   19
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW19_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW18_SHIFT   18
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW18_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW17_SHIFT   17
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW17_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW16_SHIFT   16
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW16_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW15_SHIFT   15
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW15_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW14_SHIFT   14
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW14_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW13_SHIFT   13
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW13_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW12_SHIFT   12
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW12_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW11_SHIFT   11
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW11_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW10_SHIFT   10
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW10_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW9_SHIFT   9
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW9_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW8_SHIFT   8
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW8_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW7_SHIFT   7
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW7_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW6_SHIFT   6
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW6_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW5_SHIFT   5
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW5_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW4_SHIFT   4
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW4_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW3_SHIFT   3
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW3_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW2_SHIFT   2
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW2_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW1_SHIFT   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW1_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW0_SHIFT   0
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW0_WIDTH   1
#define XDC_TILEMEM_OVERFLOW_ERR_64_95_TRIGGER_MEM_TRC_OVERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS         0x0000CD30

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_STATUS_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK         0x0000CD34

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_MASK_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE         0x0000CD38

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_ENABLE_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE         0x0000CD3C

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_DISABLE_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER         0x0000CD40

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_0_31_TRIGGER_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS         0x0000CD44

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_STATUS_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK         0x0000CD48

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_MASK_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE         0x0000CD4C

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_ENABLE_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE         0x0000CD50

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_DISABLE_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER         0x0000CD54

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_32_63_TRIGGER_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS         0x0000CD58

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_STATUS_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK         0x0000CD5C

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_MASK_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE         0x0000CD60

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_ENABLE_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE         0x0000CD64

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_DISABLE_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER
 *   */
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER         0x0000CD68

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW31_SHIFT   31
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW31_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW31_MASK   0x80000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW30_SHIFT   30
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW30_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW30_MASK   0x40000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW29_SHIFT   29
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW29_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW29_MASK   0x20000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW28_SHIFT   28
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW28_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW28_MASK   0x10000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW27_SHIFT   27
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW27_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW27_MASK   0x08000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW26_SHIFT   26
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW26_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW26_MASK   0x04000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW25_SHIFT   25
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW25_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW25_MASK   0x02000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW24_SHIFT   24
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW24_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW24_MASK   0x01000000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW23_SHIFT   23
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW23_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW23_MASK   0x00800000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW22_SHIFT   22
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW22_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW22_MASK   0x00400000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW21_SHIFT   21
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW21_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW21_MASK   0x00200000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW20_SHIFT   20
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW20_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW20_MASK   0x00100000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW19_SHIFT   19
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW19_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW19_MASK   0x00080000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW18_SHIFT   18
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW18_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW18_MASK   0x00040000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW17_SHIFT   17
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW17_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW17_MASK   0x00020000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW16_SHIFT   16
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW16_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW16_MASK   0x00010000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW15_SHIFT   15
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW15_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW15_MASK   0x00008000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW14_SHIFT   14
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW14_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW14_MASK   0x00004000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW13_SHIFT   13
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW13_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW13_MASK   0x00002000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW12_SHIFT   12
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW12_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW12_MASK   0x00001000

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW11_SHIFT   11
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW11_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW11_MASK   0x00000800

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW10_SHIFT   10
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW10_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW10_MASK   0x00000400

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW9_SHIFT   9
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW9_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW9_MASK   0x00000200

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW8_SHIFT   8
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW8_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW8_MASK   0x00000100

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW7_SHIFT   7
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW7_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW7_MASK   0x00000080

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW6_SHIFT   6
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW6_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW6_MASK   0x00000040

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW5_SHIFT   5
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW5_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW5_MASK   0x00000020

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW4_SHIFT   4
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW4_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW4_MASK   0x00000010

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW3_SHIFT   3
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW3_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW3_MASK   0x00000008

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW2_SHIFT   2
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW2_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW2_MASK   0x00000004

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW1_SHIFT   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW1_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW1_MASK   0x00000002

#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW0_SHIFT   0
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW0_WIDTH   1
#define XDC_TILEMEM_UNDERFLOW_ERR_64_95_TRIGGER_MEM_TRC_UNDERFLOW0_MASK   0x00000001

/**
 *  * Register: XDC_VID_TILE_STATUS
 *   */
#define XDC_VID_TILE_STATUS         0x0000CD6C

#define XDC_VID_TILE_STATUS_FORMAT_ERR5_SHIFT   5
#define XDC_VID_TILE_STATUS_FORMAT_ERR5_WIDTH   1
#define XDC_VID_TILE_STATUS_FORMAT_ERR5_MASK   0x00000020

#define XDC_VID_TILE_STATUS_FORMAT_ERR4_SHIFT   4
#define XDC_VID_TILE_STATUS_FORMAT_ERR4_WIDTH   1
#define XDC_VID_TILE_STATUS_FORMAT_ERR4_MASK   0x00000010

#define XDC_VID_TILE_STATUS_FORMAT_ERR3_SHIFT   3
#define XDC_VID_TILE_STATUS_FORMAT_ERR3_WIDTH   1
#define XDC_VID_TILE_STATUS_FORMAT_ERR3_MASK   0x00000008

#define XDC_VID_TILE_STATUS_FORMAT_ERR2_SHIFT   2
#define XDC_VID_TILE_STATUS_FORMAT_ERR2_WIDTH   1
#define XDC_VID_TILE_STATUS_FORMAT_ERR2_MASK   0x00000004

#define XDC_VID_TILE_STATUS_FORMAT_ERR1_SHIFT   1
#define XDC_VID_TILE_STATUS_FORMAT_ERR1_WIDTH   1
#define XDC_VID_TILE_STATUS_FORMAT_ERR1_MASK   0x00000002

#define XDC_VID_TILE_STATUS_FORMAT_ERR0_SHIFT   0
#define XDC_VID_TILE_STATUS_FORMAT_ERR0_WIDTH   1
#define XDC_VID_TILE_STATUS_FORMAT_ERR0_MASK   0x00000001

/**
 *  * Register: XDC_VID_TILE_MASK
 *   */
#define XDC_VID_TILE_MASK         0x0000CD70

#define XDC_VID_TILE_MASK_FORMAT_ERR5_SHIFT   5
#define XDC_VID_TILE_MASK_FORMAT_ERR5_WIDTH   1
#define XDC_VID_TILE_MASK_FORMAT_ERR5_MASK   0x00000020

#define XDC_VID_TILE_MASK_FORMAT_ERR4_SHIFT   4
#define XDC_VID_TILE_MASK_FORMAT_ERR4_WIDTH   1
#define XDC_VID_TILE_MASK_FORMAT_ERR4_MASK   0x00000010

#define XDC_VID_TILE_MASK_FORMAT_ERR3_SHIFT   3
#define XDC_VID_TILE_MASK_FORMAT_ERR3_WIDTH   1
#define XDC_VID_TILE_MASK_FORMAT_ERR3_MASK   0x00000008

#define XDC_VID_TILE_MASK_FORMAT_ERR2_SHIFT   2
#define XDC_VID_TILE_MASK_FORMAT_ERR2_WIDTH   1
#define XDC_VID_TILE_MASK_FORMAT_ERR2_MASK   0x00000004

#define XDC_VID_TILE_MASK_FORMAT_ERR1_SHIFT   1
#define XDC_VID_TILE_MASK_FORMAT_ERR1_WIDTH   1
#define XDC_VID_TILE_MASK_FORMAT_ERR1_MASK   0x00000002

#define XDC_VID_TILE_MASK_FORMAT_ERR0_SHIFT   0
#define XDC_VID_TILE_MASK_FORMAT_ERR0_WIDTH   1
#define XDC_VID_TILE_MASK_FORMAT_ERR0_MASK   0x00000001

/**
 *  * Register: XDC_VID_TILE_ENABLE
 *   */
#define XDC_VID_TILE_ENABLE         0x0000CD74

#define XDC_VID_TILE_ENABLE_FORMAT_ERR5_SHIFT   5
#define XDC_VID_TILE_ENABLE_FORMAT_ERR5_WIDTH   1
#define XDC_VID_TILE_ENABLE_FORMAT_ERR5_MASK   0x00000020

#define XDC_VID_TILE_ENABLE_FORMAT_ERR4_SHIFT   4
#define XDC_VID_TILE_ENABLE_FORMAT_ERR4_WIDTH   1
#define XDC_VID_TILE_ENABLE_FORMAT_ERR4_MASK   0x00000010

#define XDC_VID_TILE_ENABLE_FORMAT_ERR3_SHIFT   3
#define XDC_VID_TILE_ENABLE_FORMAT_ERR3_WIDTH   1
#define XDC_VID_TILE_ENABLE_FORMAT_ERR3_MASK   0x00000008

#define XDC_VID_TILE_ENABLE_FORMAT_ERR2_SHIFT   2
#define XDC_VID_TILE_ENABLE_FORMAT_ERR2_WIDTH   1
#define XDC_VID_TILE_ENABLE_FORMAT_ERR2_MASK   0x00000004

#define XDC_VID_TILE_ENABLE_FORMAT_ERR1_SHIFT   1
#define XDC_VID_TILE_ENABLE_FORMAT_ERR1_WIDTH   1
#define XDC_VID_TILE_ENABLE_FORMAT_ERR1_MASK   0x00000002

#define XDC_VID_TILE_ENABLE_FORMAT_ERR0_SHIFT   0
#define XDC_VID_TILE_ENABLE_FORMAT_ERR0_WIDTH   1
#define XDC_VID_TILE_ENABLE_FORMAT_ERR0_MASK   0x00000001

/**
 *  * Register: XDC_VID_TILE_DISABLE
 *   */
#define XDC_VID_TILE_DISABLE         0x0000CD78

#define XDC_VID_TILE_DISABLE_FORMAT_ERR5_SHIFT   5
#define XDC_VID_TILE_DISABLE_FORMAT_ERR5_WIDTH   1
#define XDC_VID_TILE_DISABLE_FORMAT_ERR5_MASK   0x00000020

#define XDC_VID_TILE_DISABLE_FORMAT_ERR4_SHIFT   4
#define XDC_VID_TILE_DISABLE_FORMAT_ERR4_WIDTH   1
#define XDC_VID_TILE_DISABLE_FORMAT_ERR4_MASK   0x00000010

#define XDC_VID_TILE_DISABLE_FORMAT_ERR3_SHIFT   3
#define XDC_VID_TILE_DISABLE_FORMAT_ERR3_WIDTH   1
#define XDC_VID_TILE_DISABLE_FORMAT_ERR3_MASK   0x00000008

#define XDC_VID_TILE_DISABLE_FORMAT_ERR2_SHIFT   2
#define XDC_VID_TILE_DISABLE_FORMAT_ERR2_WIDTH   1
#define XDC_VID_TILE_DISABLE_FORMAT_ERR2_MASK   0x00000004

#define XDC_VID_TILE_DISABLE_FORMAT_ERR1_SHIFT   1
#define XDC_VID_TILE_DISABLE_FORMAT_ERR1_WIDTH   1
#define XDC_VID_TILE_DISABLE_FORMAT_ERR1_MASK   0x00000002

#define XDC_VID_TILE_DISABLE_FORMAT_ERR0_SHIFT   0
#define XDC_VID_TILE_DISABLE_FORMAT_ERR0_WIDTH   1
#define XDC_VID_TILE_DISABLE_FORMAT_ERR0_MASK   0x00000001

/**
 *  * Register: XDC_VID_TILE_TRIGGER
 *   */
#define XDC_VID_TILE_TRIGGER         0x0000CD7C

#define XDC_VID_TILE_TRIGGER_FORMAT_ERR5_SHIFT   5
#define XDC_VID_TILE_TRIGGER_FORMAT_ERR5_WIDTH   1
#define XDC_VID_TILE_TRIGGER_FORMAT_ERR5_MASK   0x00000020

#define XDC_VID_TILE_TRIGGER_FORMAT_ERR4_SHIFT   4
#define XDC_VID_TILE_TRIGGER_FORMAT_ERR4_WIDTH   1
#define XDC_VID_TILE_TRIGGER_FORMAT_ERR4_MASK   0x00000010

#define XDC_VID_TILE_TRIGGER_FORMAT_ERR3_SHIFT   3
#define XDC_VID_TILE_TRIGGER_FORMAT_ERR3_WIDTH   1
#define XDC_VID_TILE_TRIGGER_FORMAT_ERR3_MASK   0x00000008

#define XDC_VID_TILE_TRIGGER_FORMAT_ERR2_SHIFT   2
#define XDC_VID_TILE_TRIGGER_FORMAT_ERR2_WIDTH   1
#define XDC_VID_TILE_TRIGGER_FORMAT_ERR2_MASK   0x00000004

#define XDC_VID_TILE_TRIGGER_FORMAT_ERR1_SHIFT   1
#define XDC_VID_TILE_TRIGGER_FORMAT_ERR1_WIDTH   1
#define XDC_VID_TILE_TRIGGER_FORMAT_ERR1_MASK   0x00000002

#define XDC_VID_TILE_TRIGGER_FORMAT_ERR0_SHIFT   0
#define XDC_VID_TILE_TRIGGER_FORMAT_ERR0_WIDTH   1
#define XDC_VID_TILE_TRIGGER_FORMAT_ERR0_MASK   0x00000001

/**
 *  * Register: XDC_DP_INT_STATUS
 *   */
#define XDC_DP_INT_STATUS         0x0000D000

#define XDC_DP_INT_STATUS_VSYNC_TS_SHIFT   31
#define XDC_DP_INT_STATUS_VSYNC_TS_WIDTH   1
#define XDC_DP_INT_STATUS_VSYNC_TS_MASK   0x80000000

#define XDC_DP_INT_STATUS_EXT_VSYNC_TS_SHIFT   30
#define XDC_DP_INT_STATUS_EXT_VSYNC_TS_WIDTH   1
#define XDC_DP_INT_STATUS_EXT_VSYNC_TS_MASK   0x40000000

#define XDC_DP_INT_STATUS_CUST_TS_SHIFT   29
#define XDC_DP_INT_STATUS_CUST_TS_WIDTH   1
#define XDC_DP_INT_STATUS_CUST_TS_MASK   0x20000000

#define XDC_DP_INT_STATUS_CUST_TS_2_SHIFT   28
#define XDC_DP_INT_STATUS_CUST_TS_2_WIDTH   1
#define XDC_DP_INT_STATUS_CUST_TS_2_MASK   0x10000000

#define XDC_DP_INT_STATUS_CHBUF0_OVERFLW_SHIFT   27
#define XDC_DP_INT_STATUS_CHBUF0_OVERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF0_OVERFLW_MASK   0x08000000

#define XDC_DP_INT_STATUS_CHBUF1_OVERFLW_SHIFT   26
#define XDC_DP_INT_STATUS_CHBUF1_OVERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF1_OVERFLW_MASK   0x04000000

#define XDC_DP_INT_STATUS_CHBUF2_0_OVERFLW_SHIFT   25
#define XDC_DP_INT_STATUS_CHBUF2_0_OVERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF2_0_OVERFLW_MASK   0x02000000

#define XDC_DP_INT_STATUS_CHBUF2_1_OVERFLW_SHIFT   24
#define XDC_DP_INT_STATUS_CHBUF2_1_OVERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF2_1_OVERFLW_MASK   0x01000000

#define XDC_DP_INT_STATUS_CHBUF3_OVERFLW_SHIFT   23
#define XDC_DP_INT_STATUS_CHBUF3_OVERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF3_OVERFLW_MASK   0x00800000

#define XDC_DP_INT_STATUS_CHBUF4_OVERFLW_SHIFT   22
#define XDC_DP_INT_STATUS_CHBUF4_OVERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF4_OVERFLW_MASK   0x00400000

#define XDC_DP_INT_STATUS_CHBUF5_0_OVERFLW_SHIFT   21
#define XDC_DP_INT_STATUS_CHBUF5_0_OVERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF5_0_OVERFLW_MASK   0x00200000

#define XDC_DP_INT_STATUS_CHBUF5_1_OVERFLW_SHIFT   20
#define XDC_DP_INT_STATUS_CHBUF5_1_OVERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF5_1_OVERFLW_MASK   0x00100000

#define XDC_DP_INT_STATUS_CHBUF_CURSOR_OVERFLW_SHIFT   19
#define XDC_DP_INT_STATUS_CHBUF_CURSOR_OVERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF_CURSOR_OVERFLW_MASK   0x00080000

#define XDC_DP_INT_STATUS_CHBUF_SDP_OVERFLW_SHIFT   18
#define XDC_DP_INT_STATUS_CHBUF_SDP_OVERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF_SDP_OVERFLW_MASK   0x00040000

#define XDC_DP_INT_STATUS_CHBUF_AUD_OVERFLW_SHIFT   17
#define XDC_DP_INT_STATUS_CHBUF_AUD_OVERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF_AUD_OVERFLW_MASK   0x00020000

#define XDC_DP_INT_STATUS_CHBUF0_UNDERFLW_SHIFT   16
#define XDC_DP_INT_STATUS_CHBUF0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF0_UNDERFLW_MASK   0x00010000

#define XDC_DP_INT_STATUS_CHBUF1_UNDERFLW_SHIFT   15
#define XDC_DP_INT_STATUS_CHBUF1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF1_UNDERFLW_MASK   0x00008000

#define XDC_DP_INT_STATUS_CHBUF2_0_UNDERFLW_SHIFT   14
#define XDC_DP_INT_STATUS_CHBUF2_0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF2_0_UNDERFLW_MASK   0x00004000

#define XDC_DP_INT_STATUS_CHBUF2_1_UNDERFLW_SHIFT   13
#define XDC_DP_INT_STATUS_CHBUF2_1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF2_1_UNDERFLW_MASK   0x00002000

#define XDC_DP_INT_STATUS_CHBUF3_UNDERFLW_SHIFT   12
#define XDC_DP_INT_STATUS_CHBUF3_UNDERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF3_UNDERFLW_MASK   0x00001000

#define XDC_DP_INT_STATUS_CHBUF4_UNDERFLW_SHIFT   11
#define XDC_DP_INT_STATUS_CHBUF4_UNDERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF4_UNDERFLW_MASK   0x00000800

#define XDC_DP_INT_STATUS_CHBUF5_0_UNDERFLW_SHIFT   10
#define XDC_DP_INT_STATUS_CHBUF5_0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF5_0_UNDERFLW_MASK   0x00000400

#define XDC_DP_INT_STATUS_CHBUF5_1_UNDERFLW_SHIFT   9
#define XDC_DP_INT_STATUS_CHBUF5_1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF5_1_UNDERFLW_MASK   0x00000200

#define XDC_DP_INT_STATUS_CHBUF_CURSOR_UNDERFLW_SHIFT   8
#define XDC_DP_INT_STATUS_CHBUF_CURSOR_UNDERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF_CURSOR_UNDERFLW_MASK   0x00000100

#define XDC_DP_INT_STATUS_CHBUF_SDP_UNDERFLW_SHIFT   7
#define XDC_DP_INT_STATUS_CHBUF_SDP_UNDERFLW_WIDTH   1
#define XDC_DP_INT_STATUS_CHBUF_SDP_UNDERFLW_MASK   0x00000080

#define XDC_DP_INT_STATUS_AUD_SHIFT   6
#define XDC_DP_INT_STATUS_AUD_WIDTH   1
#define XDC_DP_INT_STATUS_AUD_MASK   0x00000040

#define XDC_DP_INT_STATUS_PIXEL_MATCH0_SHIFT   5
#define XDC_DP_INT_STATUS_PIXEL_MATCH0_WIDTH   1
#define XDC_DP_INT_STATUS_PIXEL_MATCH0_MASK   0x00000020

#define XDC_DP_INT_STATUS_PIXEL_MATCH1_SHIFT   4
#define XDC_DP_INT_STATUS_PIXEL_MATCH1_WIDTH   1
#define XDC_DP_INT_STATUS_PIXEL_MATCH1_MASK   0x00000010

#define XDC_DP_INT_STATUS_EARLY_VBLNK_START_SHIFT   3
#define XDC_DP_INT_STATUS_EARLY_VBLNK_START_WIDTH   1
#define XDC_DP_INT_STATUS_EARLY_VBLNK_START_MASK   0x00000008

#define XDC_DP_INT_STATUS_TILEMEM_UNDERFLOW_SHIFT   2
#define XDC_DP_INT_STATUS_TILEMEM_UNDERFLOW_WIDTH   1
#define XDC_DP_INT_STATUS_TILEMEM_UNDERFLOW_MASK   0x00000004

#define XDC_DP_INT_STATUS_TILEMEM_OVERFLOW_SHIFT   1
#define XDC_DP_INT_STATUS_TILEMEM_OVERFLOW_WIDTH   1
#define XDC_DP_INT_STATUS_TILEMEM_OVERFLOW_MASK   0x00000002

#define XDC_DP_INT_STATUS_VIDTILE_FORMAT_ERR_SHIFT   0
#define XDC_DP_INT_STATUS_VIDTILE_FORMAT_ERR_WIDTH   1
#define XDC_DP_INT_STATUS_VIDTILE_FORMAT_ERR_MASK   0x00000001

/**
 *  * Register: XDC_DP_INT_MASK
 *   */
#define XDC_DP_INT_MASK         0x0000D004

#define XDC_DP_INT_MASK_VSYNC_TS_SHIFT   31
#define XDC_DP_INT_MASK_VSYNC_TS_WIDTH   1
#define XDC_DP_INT_MASK_VSYNC_TS_MASK   0x80000000

#define XDC_DP_INT_MASK_EXT_VSYNC_TS_SHIFT   30
#define XDC_DP_INT_MASK_EXT_VSYNC_TS_WIDTH   1
#define XDC_DP_INT_MASK_EXT_VSYNC_TS_MASK   0x40000000

#define XDC_DP_INT_MASK_CUST_TS_SHIFT   29
#define XDC_DP_INT_MASK_CUST_TS_WIDTH   1
#define XDC_DP_INT_MASK_CUST_TS_MASK   0x20000000

#define XDC_DP_INT_MASK_CUST_TS_2_SHIFT   28
#define XDC_DP_INT_MASK_CUST_TS_2_WIDTH   1
#define XDC_DP_INT_MASK_CUST_TS_2_MASK   0x10000000

#define XDC_DP_INT_MASK_CHBUF0_OVERFLW_SHIFT   27
#define XDC_DP_INT_MASK_CHBUF0_OVERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF0_OVERFLW_MASK   0x08000000

#define XDC_DP_INT_MASK_CHBUF1_OVERFLW_SHIFT   26
#define XDC_DP_INT_MASK_CHBUF1_OVERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF1_OVERFLW_MASK   0x04000000

#define XDC_DP_INT_MASK_CHBUF2_0_OVERFLW_SHIFT   25
#define XDC_DP_INT_MASK_CHBUF2_0_OVERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF2_0_OVERFLW_MASK   0x02000000

#define XDC_DP_INT_MASK_CHBUF2_1_OVERFLW_SHIFT   24
#define XDC_DP_INT_MASK_CHBUF2_1_OVERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF2_1_OVERFLW_MASK   0x01000000

#define XDC_DP_INT_MASK_CHBUF3_OVERFLW_SHIFT   23
#define XDC_DP_INT_MASK_CHBUF3_OVERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF3_OVERFLW_MASK   0x00800000

#define XDC_DP_INT_MASK_CHBUF4_OVERFLW_SHIFT   22
#define XDC_DP_INT_MASK_CHBUF4_OVERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF4_OVERFLW_MASK   0x00400000

#define XDC_DP_INT_MASK_CHBUF5_0_OVERFLW_SHIFT   21
#define XDC_DP_INT_MASK_CHBUF5_0_OVERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF5_0_OVERFLW_MASK   0x00200000

#define XDC_DP_INT_MASK_CHBUF5_1_OVERFLW_SHIFT   20
#define XDC_DP_INT_MASK_CHBUF5_1_OVERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF5_1_OVERFLW_MASK   0x00100000

#define XDC_DP_INT_MASK_CHBUF_CURSOR_OVERFLW_SHIFT   19
#define XDC_DP_INT_MASK_CHBUF_CURSOR_OVERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF_CURSOR_OVERFLW_MASK   0x00080000

#define XDC_DP_INT_MASK_CHBUF_SDP_OVERFLW_SHIFT   18
#define XDC_DP_INT_MASK_CHBUF_SDP_OVERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF_SDP_OVERFLW_MASK   0x00040000

#define XDC_DP_INT_MASK_CHBUF_AUD_OVERFLW_SHIFT   17
#define XDC_DP_INT_MASK_CHBUF_AUD_OVERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF_AUD_OVERFLW_MASK   0x00020000

#define XDC_DP_INT_MASK_CHBUF0_UNDERFLW_SHIFT   16
#define XDC_DP_INT_MASK_CHBUF0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF0_UNDERFLW_MASK   0x00010000

#define XDC_DP_INT_MASK_CHBUF1_UNDERFLW_SHIFT   15
#define XDC_DP_INT_MASK_CHBUF1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF1_UNDERFLW_MASK   0x00008000

#define XDC_DP_INT_MASK_CHBUF2_0_UNDERFLW_SHIFT   14
#define XDC_DP_INT_MASK_CHBUF2_0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF2_0_UNDERFLW_MASK   0x00004000

#define XDC_DP_INT_MASK_CHBUF2_1_UNDERFLW_SHIFT   13
#define XDC_DP_INT_MASK_CHBUF2_1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF2_1_UNDERFLW_MASK   0x00002000

#define XDC_DP_INT_MASK_CHBUF3_UNDERFLW_SHIFT   12
#define XDC_DP_INT_MASK_CHBUF3_UNDERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF3_UNDERFLW_MASK   0x00001000

#define XDC_DP_INT_MASK_CHBUF4_UNDERFLW_SHIFT   11
#define XDC_DP_INT_MASK_CHBUF4_UNDERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF4_UNDERFLW_MASK   0x00000800

#define XDC_DP_INT_MASK_CHBUF5_0_UNDERFLW_SHIFT   10
#define XDC_DP_INT_MASK_CHBUF5_0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF5_0_UNDERFLW_MASK   0x00000400

#define XDC_DP_INT_MASK_CHBUF5_1_UNDERFLW_SHIFT   9
#define XDC_DP_INT_MASK_CHBUF5_1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF5_1_UNDERFLW_MASK   0x00000200

#define XDC_DP_INT_MASK_CHBUF_CURSOR_UNDERFLW_SHIFT   8
#define XDC_DP_INT_MASK_CHBUF_CURSOR_UNDERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF_CURSOR_UNDERFLW_MASK   0x00000100

#define XDC_DP_INT_MASK_CHBUF_SDP_UNDERFLW_SHIFT   7
#define XDC_DP_INT_MASK_CHBUF_SDP_UNDERFLW_WIDTH   1
#define XDC_DP_INT_MASK_CHBUF_SDP_UNDERFLW_MASK   0x00000080

#define XDC_DP_INT_MASK_AUD_SHIFT   6
#define XDC_DP_INT_MASK_AUD_WIDTH   1
#define XDC_DP_INT_MASK_AUD_MASK   0x00000040

#define XDC_DP_INT_MASK_PIXEL_MATCH0_SHIFT   5
#define XDC_DP_INT_MASK_PIXEL_MATCH0_WIDTH   1
#define XDC_DP_INT_MASK_PIXEL_MATCH0_MASK   0x00000020

#define XDC_DP_INT_MASK_PIXEL_MATCH1_SHIFT   4
#define XDC_DP_INT_MASK_PIXEL_MATCH1_WIDTH   1
#define XDC_DP_INT_MASK_PIXEL_MATCH1_MASK   0x00000010

#define XDC_DP_INT_MASK_EARLY_VBLNK_START_SHIFT   3
#define XDC_DP_INT_MASK_EARLY_VBLNK_START_WIDTH   1
#define XDC_DP_INT_MASK_EARLY_VBLNK_START_MASK   0x00000008

#define XDC_DP_INT_MASK_TILEMEM_UNDERFLOW_SHIFT   2
#define XDC_DP_INT_MASK_TILEMEM_UNDERFLOW_WIDTH   1
#define XDC_DP_INT_MASK_TILEMEM_UNDERFLOW_MASK   0x00000004

#define XDC_DP_INT_MASK_TILEMEM_OVERFLOW_SHIFT   1
#define XDC_DP_INT_MASK_TILEMEM_OVERFLOW_WIDTH   1
#define XDC_DP_INT_MASK_TILEMEM_OVERFLOW_MASK   0x00000002

#define XDC_DP_INT_MASK_VIDTILE_FORMAT_ERR_SHIFT   0
#define XDC_DP_INT_MASK_VIDTILE_FORMAT_ERR_WIDTH   1
#define XDC_DP_INT_MASK_VIDTILE_FORMAT_ERR_MASK   0x00000001

/**
 *  * Register: XDC_DP_INT_EN
 *   */
#define XDC_DP_INT_EN         0x0000D008

#define XDC_DP_INT_EN_VSYNC_TS_SHIFT   31
#define XDC_DP_INT_EN_VSYNC_TS_WIDTH   1
#define XDC_DP_INT_EN_VSYNC_TS_EN   0x80000000

#define XDC_DP_INT_EN_EXT_VSYNC_TS_SHIFT   30
#define XDC_DP_INT_EN_EXT_VSYNC_TS_WIDTH   1
#define XDC_DP_INT_EN_EXT_VSYNC_TS_EN   0x40000000

#define XDC_DP_INT_EN_CUST_TS_SHIFT   29
#define XDC_DP_INT_EN_CUST_TS_WIDTH   1
#define XDC_DP_INT_EN_CUST_TS_EN   0x20000000

#define XDC_DP_INT_EN_CUST_TS_2_SHIFT   28
#define XDC_DP_INT_EN_CUST_TS_2_WIDTH   1
#define XDC_DP_INT_EN_CUST_TS_2_EN   0x10000000

#define XDC_DP_INT_EN_CHBUF0_OVERFLW_SHIFT   27
#define XDC_DP_INT_EN_CHBUF0_OVERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF0_OVERFLW_EN   0x08000000

#define XDC_DP_INT_EN_CHBUF1_OVERFLW_SHIFT   26
#define XDC_DP_INT_EN_CHBUF1_OVERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF1_OVERFLW_EN   0x04000000

#define XDC_DP_INT_EN_CHBUF2_0_OVERFLW_SHIFT   25
#define XDC_DP_INT_EN_CHBUF2_0_OVERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF2_0_OVERFLW_EN   0x02000000

#define XDC_DP_INT_EN_CHBUF2_1_OVERFLW_SHIFT   24
#define XDC_DP_INT_EN_CHBUF2_1_OVERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF2_1_OVERFLW_EN   0x01000000

#define XDC_DP_INT_EN_CHBUF3_OVERFLW_SHIFT   23
#define XDC_DP_INT_EN_CHBUF3_OVERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF3_OVERFLW_EN   0x00800000

#define XDC_DP_INT_EN_CHBUF4_OVERFLW_SHIFT   22
#define XDC_DP_INT_EN_CHBUF4_OVERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF4_OVERFLW_EN   0x00400000

#define XDC_DP_INT_EN_CHBUF5_0_OVERFLW_SHIFT   21
#define XDC_DP_INT_EN_CHBUF5_0_OVERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF5_0_OVERFLW_EN   0x00200000

#define XDC_DP_INT_EN_CHBUF5_1_OVERFLW_SHIFT   20
#define XDC_DP_INT_EN_CHBUF5_1_OVERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF5_1_OVERFLW_EN   0x00100000

#define XDC_DP_INT_EN_CHBUF_CURSOR_OVERFLW_SHIFT   19
#define XDC_DP_INT_EN_CHBUF_CURSOR_OVERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF_CURSOR_OVERFLW_EN   0x00080000

#define XDC_DP_INT_EN_CHBUF_SDP_OVERFLW_SHIFT   18
#define XDC_DP_INT_EN_CHBUF_SDP_OVERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF_SDP_OVERFLW_EN   0x00040000

#define XDC_DP_INT_EN_CHBUF_AUD_OVERFLW_SHIFT   17
#define XDC_DP_INT_EN_CHBUF_AUD_OVERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF_AUD_OVERFLW_EN   0x00020000

#define XDC_DP_INT_EN_CHBUF0_UNDERFLW_SHIFT   16
#define XDC_DP_INT_EN_CHBUF0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF0_UNDERFLW_EN   0x00010000

#define XDC_DP_INT_EN_CHBUF1_UNDERFLW_SHIFT   15
#define XDC_DP_INT_EN_CHBUF1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF1_UNDERFLW_EN   0x00008000

#define XDC_DP_INT_EN_CHBUF2_0_UNDERFLW_SHIFT   14
#define XDC_DP_INT_EN_CHBUF2_0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF2_0_UNDERFLW_EN   0x00004000

#define XDC_DP_INT_EN_CHBUF2_1_UNDERFLW_SHIFT   13
#define XDC_DP_INT_EN_CHBUF2_1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF2_1_UNDERFLW_EN   0x00002000

#define XDC_DP_INT_EN_CHBUF3_UNDERFLW_SHIFT   12
#define XDC_DP_INT_EN_CHBUF3_UNDERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF3_UNDERFLW_EN   0x00001000

#define XDC_DP_INT_EN_CHBUF4_UNDERFLW_SHIFT   11
#define XDC_DP_INT_EN_CHBUF4_UNDERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF4_UNDERFLW_EN   0x00000800

#define XDC_DP_INT_EN_CHBUF5_0_UNDERFLW_SHIFT   10
#define XDC_DP_INT_EN_CHBUF5_0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF5_0_UNDERFLW_EN   0x00000400

#define XDC_DP_INT_EN_CHBUF5_1_UNDERFLW_SHIFT   9
#define XDC_DP_INT_EN_CHBUF5_1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF5_1_UNDERFLW_EN   0x00000200

#define XDC_DP_INT_EN_CHBUF_CURSOR_UNDERFLW_SHIFT   8
#define XDC_DP_INT_EN_CHBUF_CURSOR_UNDERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF_CURSOR_UNDERFLW_EN   0x00000100

#define XDC_DP_INT_EN_CHBUF_SDP_UNDERFLW_SHIFT   7
#define XDC_DP_INT_EN_CHBUF_SDP_UNDERFLW_WIDTH   1
#define XDC_DP_INT_EN_CHBUF_SDP_UNDERFLW_EN   0x00000080

#define XDC_DP_INT_EN_AUD_SHIFT   6
#define XDC_DP_INT_EN_AUD_WIDTH   1
#define XDC_DP_INT_EN_AUD_EN   0x00000040

#define XDC_DP_INT_EN_PIXEL_MATCH0_SHIFT   5
#define XDC_DP_INT_EN_PIXEL_MATCH0_WIDTH   1
#define XDC_DP_INT_EN_PIXEL_MATCH0_EN   0x00000020

#define XDC_DP_INT_EN_PIXEL_MATCH1_SHIFT   4
#define XDC_DP_INT_EN_PIXEL_MATCH1_WIDTH   1
#define XDC_DP_INT_EN_PIXEL_MATCH1_EN   0x00000010

#define XDC_DP_INT_EN_EARLY_VBLNK_START_SHIFT   3
#define XDC_DP_INT_EN_EARLY_VBLNK_START_WIDTH   1
#define XDC_DP_INT_EN_EARLY_VBLNK_START_EN   0x00000008

#define XDC_DP_INT_EN_TILEMEM_UNDERFLOW_SHIFT   2
#define XDC_DP_INT_EN_TILEMEM_UNDERFLOW_WIDTH   1
#define XDC_DP_INT_EN_TILEMEM_UNDERFLOW_EN   0x00000004

#define XDC_DP_INT_EN_TILEMEM_OVERFLOW_SHIFT   1
#define XDC_DP_INT_EN_TILEMEM_OVERFLOW_WIDTH   1
#define XDC_DP_INT_EN_TILEMEM_OVERFLOW_EN   0x00000002

#define XDC_DP_INT_EN_VIDTILE_FORMAT_ERR_SHIFT   0
#define XDC_DP_INT_EN_VIDTILE_FORMAT_ERR_WIDTH   1
#define XDC_DP_INT_EN_VIDTILE_FORMAT_ERR_EN   0x00000001

/**
 *  * Register: XDC_DP_INT_DS
 *   */
#define XDC_DP_INT_DS         0x0000D00C

#define XDC_DP_INT_DS_VSYNC_TS_SHIFT   31
#define XDC_DP_INT_DS_VSYNC_TS_WIDTH   1
#define XDC_DP_INT_DS_VSYNC_TS_DS   0x80000000

#define XDC_DP_INT_DS_EXT_VSYNC_TS_SHIFT   30
#define XDC_DP_INT_DS_EXT_VSYNC_TS_WIDTH   1
#define XDC_DP_INT_DS_EXT_VSYNC_TS_DS   0x40000000

#define XDC_DP_INT_DS_CUST_TS_SHIFT   29
#define XDC_DP_INT_DS_CUST_TS_WIDTH   1
#define XDC_DP_INT_DS_CUST_TS_DS   0x20000000

#define XDC_DP_INT_DS_CUST_TS_2_SHIFT   28
#define XDC_DP_INT_DS_CUST_TS_2_WIDTH   1
#define XDC_DP_INT_DS_CUST_TS_2_DS   0x10000000

#define XDC_DP_INT_DS_CHBUF0_OVERFLW_SHIFT   27
#define XDC_DP_INT_DS_CHBUF0_OVERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF0_OVERFLW_DS   0x08000000

#define XDC_DP_INT_DS_CHBUF1_OVERFLW_SHIFT   26
#define XDC_DP_INT_DS_CHBUF1_OVERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF1_OVERFLW_DS   0x04000000

#define XDC_DP_INT_DS_CHBUF2_0_OVERFLW_SHIFT   25
#define XDC_DP_INT_DS_CHBUF2_0_OVERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF2_0_OVERFLW_DS   0x02000000

#define XDC_DP_INT_DS_CHBUF2_1_OVERFLW_SHIFT   24
#define XDC_DP_INT_DS_CHBUF2_1_OVERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF2_1_OVERFLW_DS   0x01000000

#define XDC_DP_INT_DS_CHBUF3_OVERFLW_SHIFT   23
#define XDC_DP_INT_DS_CHBUF3_OVERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF3_OVERFLW_DS   0x00800000

#define XDC_DP_INT_DS_CHBUF4_OVERFLW_SHIFT   22
#define XDC_DP_INT_DS_CHBUF4_OVERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF4_OVERFLW_DS   0x00400000

#define XDC_DP_INT_DS_CHBUF5_0_OVERFLW_SHIFT   21
#define XDC_DP_INT_DS_CHBUF5_0_OVERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF5_0_OVERFLW_DS   0x00200000

#define XDC_DP_INT_DS_CHBUF5_1_OVERFLW_SHIFT   20
#define XDC_DP_INT_DS_CHBUF5_1_OVERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF5_1_OVERFLW_DS   0x00100000

#define XDC_DP_INT_DS_CHBUF_CURSOR_OVERFLW_SHIFT   19
#define XDC_DP_INT_DS_CHBUF_CURSOR_OVERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF_CURSOR_OVERFLW_DS   0x00080000

#define XDC_DP_INT_DS_CHBUF_SDP_OVERFLW_SHIFT   18
#define XDC_DP_INT_DS_CHBUF_SDP_OVERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF_SDP_OVERFLW_DS   0x00040000

#define XDC_DP_INT_DS_CHBUF_AUD_OVERFLW_SHIFT   17
#define XDC_DP_INT_DS_CHBUF_AUD_OVERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF_AUD_OVERFLW_DS   0x00020000

#define XDC_DP_INT_DS_CHBUF0_UNDERFLW_SHIFT   16
#define XDC_DP_INT_DS_CHBUF0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF0_UNDERFLW_DS   0x00010000

#define XDC_DP_INT_DS_CHBUF1_UNDERFLW_SHIFT   15
#define XDC_DP_INT_DS_CHBUF1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF1_UNDERFLW_DS   0x00008000

#define XDC_DP_INT_DS_CHBUF2_0_UNDERFLW_SHIFT   14
#define XDC_DP_INT_DS_CHBUF2_0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF2_0_UNDERFLW_DS   0x00004000

#define XDC_DP_INT_DS_CHBUF2_1_UNDERFLW_SHIFT   13
#define XDC_DP_INT_DS_CHBUF2_1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF2_1_UNDERFLW_DS   0x00002000

#define XDC_DP_INT_DS_CHBUF3_UNDERFLW_SHIFT   12
#define XDC_DP_INT_DS_CHBUF3_UNDERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF3_UNDERFLW_DS   0x00001000

#define XDC_DP_INT_DS_CHBUF4_UNDERFLW_SHIFT   11
#define XDC_DP_INT_DS_CHBUF4_UNDERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF4_UNDERFLW_DS   0x00000800

#define XDC_DP_INT_DS_CHBUF5_0_UNDERFLW_SHIFT   10
#define XDC_DP_INT_DS_CHBUF5_0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF5_0_UNDERFLW_DS   0x00000400

#define XDC_DP_INT_DS_CHBUF5_1_UNDERFLW_SHIFT   9
#define XDC_DP_INT_DS_CHBUF5_1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF5_1_UNDERFLW_DS   0x00000200

#define XDC_DP_INT_DS_CHBUF_CURSOR_UNDERFLW_SHIFT   8
#define XDC_DP_INT_DS_CHBUF_CURSOR_UNDERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF_CURSOR_UNDERFLW_DS   0x00000100

#define XDC_DP_INT_DS_CHBUF_SDP_UNDERFLW_SHIFT   7
#define XDC_DP_INT_DS_CHBUF_SDP_UNDERFLW_WIDTH   1
#define XDC_DP_INT_DS_CHBUF_SDP_UNDERFLW_DS   0x00000080

#define XDC_DP_INT_DS_AUD_SHIFT   6
#define XDC_DP_INT_DS_AUD_WIDTH   1
#define XDC_DP_INT_DS_AUD_DS   0x00000040

#define XDC_DP_INT_DS_PIXEL_MATCH0_SHIFT   5
#define XDC_DP_INT_DS_PIXEL_MATCH0_WIDTH   1
#define XDC_DP_INT_DS_PIXEL_MATCH0_DS   0x00000020

#define XDC_DP_INT_DS_PIXEL_MATCH1_SHIFT   4
#define XDC_DP_INT_DS_PIXEL_MATCH1_WIDTH   1
#define XDC_DP_INT_DS_PIXEL_MATCH1_DS   0x00000010

#define XDC_DP_INT_DS_EARLY_VBLNK_START_SHIFT   3
#define XDC_DP_INT_DS_EARLY_VBLNK_START_WIDTH   1
#define XDC_DP_INT_DS_EARLY_VBLNK_START_DS   0x00000008

#define XDC_DP_INT_DS_TILEMEM_UNDERFLOW_SHIFT   2
#define XDC_DP_INT_DS_TILEMEM_UNDERFLOW_WIDTH   1
#define XDC_DP_INT_DS_TILEMEM_UNDERFLOW_DS   0x00000004

#define XDC_DP_INT_DS_TILEMEM_OVERFLOW_SHIFT   1
#define XDC_DP_INT_DS_TILEMEM_OVERFLOW_WIDTH   1
#define XDC_DP_INT_DS_TILEMEM_OVERFLOW_DS   0x00000002

#define XDC_DP_INT_DS_VIDTILE_FORMAT_ERR_SHIFT   0
#define XDC_DP_INT_DS_VIDTILE_FORMAT_ERR_WIDTH   1
#define XDC_DP_INT_DS_VIDTILE_FORMAT_ERR_DS   0x00000001

/**
 *  * Register: XDC_DP_INT_TRIGGER
 *   */
#define XDC_DP_INT_TRIGGER         0x0000D010

#define XDC_DP_INT_TRIGGER_VSYNC_TS_SHIFT   31
#define XDC_DP_INT_TRIGGER_VSYNC_TS_WIDTH   1
#define XDC_DP_INT_TRIGGER_VSYNC_TS_TRIGGER   0x80000000

#define XDC_DP_INT_TRIGGER_EXT_VSYNC_TS_SHIFT   30
#define XDC_DP_INT_TRIGGER_EXT_VSYNC_TS_WIDTH   1
#define XDC_DP_INT_TRIGGER_EXT_VSYNC_TS_TRIGGER   0x40000000

#define XDC_DP_INT_TRIGGER_CUST_TS_SHIFT   29
#define XDC_DP_INT_TRIGGER_CUST_TS_WIDTH   1
#define XDC_DP_INT_TRIGGER_CUST_TS_TRIGGER   0x20000000

#define XDC_DP_INT_TRIGGER_CUST_TS_2_SHIFT   28
#define XDC_DP_INT_TRIGGER_CUST_TS_2_WIDTH   1
#define XDC_DP_INT_TRIGGER_CUST_TS_2_TRIGGER   0x10000000

#define XDC_DP_INT_TRIGGER_CHBUF0_OVERFLW_SHIFT   27
#define XDC_DP_INT_TRIGGER_CHBUF0_OVERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF0_OVERFLW_TRIGGER   0x08000000

#define XDC_DP_INT_TRIGGER_CHBUF1_OVERFLW_SHIFT   26
#define XDC_DP_INT_TRIGGER_CHBUF1_OVERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF1_OVERFLW_TRIGGER   0x04000000

#define XDC_DP_INT_TRIGGER_CHBUF2_0_OVERFLW_SHIFT   25
#define XDC_DP_INT_TRIGGER_CHBUF2_0_OVERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF2_0_OVERFLW_TRIGGER   0x02000000

#define XDC_DP_INT_TRIGGER_CHBUF2_1_OVERFLW_SHIFT   24
#define XDC_DP_INT_TRIGGER_CHBUF2_1_OVERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF2_1_OVERFLW_TRIGGER   0x01000000

#define XDC_DP_INT_TRIGGER_CHBUF3_OVERFLW_SHIFT   23
#define XDC_DP_INT_TRIGGER_CHBUF3_OVERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF3_OVERFLW_TRIGGER   0x00800000

#define XDC_DP_INT_TRIGGER_CHBUF4_OVERFLW_SHIFT   22
#define XDC_DP_INT_TRIGGER_CHBUF4_OVERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF4_OVERFLW_TRIGGER   0x00400000

#define XDC_DP_INT_TRIGGER_CHBUF5_0_OVERFLW_SHIFT   21
#define XDC_DP_INT_TRIGGER_CHBUF5_0_OVERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF5_0_OVERFLW_TRIGGER   0x00200000

#define XDC_DP_INT_TRIGGER_CHBUF5_1_OVERFLW_SHIFT   20
#define XDC_DP_INT_TRIGGER_CHBUF5_1_OVERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF5_1_OVERFLW_TRIGGER   0x00100000

#define XDC_DP_INT_TRIGGER_CHBUF_CURSOR_OVERFLW_SHIFT   19
#define XDC_DP_INT_TRIGGER_CHBUF_CURSOR_OVERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF_CURSOR_OVERFLW_TRIGGER   0x00080000

#define XDC_DP_INT_TRIGGER_CHBUF_SDP_OVERFLW_SHIFT   18
#define XDC_DP_INT_TRIGGER_CHBUF_SDP_OVERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF_SDP_OVERFLW_TRIGGER   0x00040000

#define XDC_DP_INT_TRIGGER_CHBUF_AUD_OVERFLW_SHIFT   17
#define XDC_DP_INT_TRIGGER_CHBUF_AUD_OVERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF_AUD_OVERFLW_TRIGGER   0x00020000

#define XDC_DP_INT_TRIGGER_CHBUF0_UNDERFLW_SHIFT   16
#define XDC_DP_INT_TRIGGER_CHBUF0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF0_UNDERFLW_TRIGGER   0x00010000

#define XDC_DP_INT_TRIGGER_CHBUF1_UNDERFLW_SHIFT   15
#define XDC_DP_INT_TRIGGER_CHBUF1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF1_UNDERFLW_TRIGGER   0x00008000

#define XDC_DP_INT_TRIGGER_CHBUF2_0_UNDERFLW_SHIFT   14
#define XDC_DP_INT_TRIGGER_CHBUF2_0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF2_0_UNDERFLW_TRIGGER   0x00004000

#define XDC_DP_INT_TRIGGER_CHBUF2_1_UNDERFLW_SHIFT   13
#define XDC_DP_INT_TRIGGER_CHBUF2_1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF2_1_UNDERFLW_TRIGGER   0x00002000

#define XDC_DP_INT_TRIGGER_CHBUF3_UNDERFLW_SHIFT   12
#define XDC_DP_INT_TRIGGER_CHBUF3_UNDERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF3_UNDERFLW_TRIGGER   0x00001000

#define XDC_DP_INT_TRIGGER_CHBUF4_UNDERFLW_SHIFT   11
#define XDC_DP_INT_TRIGGER_CHBUF4_UNDERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF4_UNDERFLW_TRIGGER   0x00000800

#define XDC_DP_INT_TRIGGER_CHBUF5_0_UNDERFLW_SHIFT   10
#define XDC_DP_INT_TRIGGER_CHBUF5_0_UNDERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF5_0_UNDERFLW_TRIGGER   0x00000400

#define XDC_DP_INT_TRIGGER_CHBUF5_1_UNDERFLW_SHIFT   9
#define XDC_DP_INT_TRIGGER_CHBUF5_1_UNDERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF5_1_UNDERFLW_TRIGGER   0x00000200

#define XDC_DP_INT_TRIGGER_CHBUF_CURSOR_UNDERFLW_SHIFT   8
#define XDC_DP_INT_TRIGGER_CHBUF_CURSOR_UNDERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF_CURSOR_UNDERFLW_TRIGGER   0x00000100

#define XDC_DP_INT_TRIGGER_CHBUF_SDP_UNDERFLW_SHIFT   7
#define XDC_DP_INT_TRIGGER_CHBUF_SDP_UNDERFLW_WIDTH   1
#define XDC_DP_INT_TRIGGER_CHBUF_SDP_UNDERFLW_TRIGGER   0x00000080

#define XDC_DP_INT_TRIGGER_AUD_SHIFT   6
#define XDC_DP_INT_TRIGGER_AUD_WIDTH   1
#define XDC_DP_INT_TRIGGER_AUD_TRIGGER   0x00000040

#define XDC_DP_INT_TRIGGER_PIXEL_MATCH0_SHIFT   5
#define XDC_DP_INT_TRIGGER_PIXEL_MATCH0_WIDTH   1
#define XDC_DP_INT_TRIGGER_PIXEL_MATCH0_TRIGGER   0x00000020

#define XDC_DP_INT_TRIGGER_PIXEL_MATCH1_SHIFT   4
#define XDC_DP_INT_TRIGGER_PIXEL_MATCH1_WIDTH   1
#define XDC_DP_INT_TRIGGER_PIXEL_MATCH1_TRIGGER   0x00000010

#define XDC_DP_INT_TRIGGER_EARLY_VBLNK_START_SHIFT   3
#define XDC_DP_INT_TRIGGER_EARLY_VBLNK_START_WIDTH   1
#define XDC_DP_INT_TRIGGER_EARLY_VBLNK_START_TRIGGER   0x00000008

#define XDC_DP_INT_TRIGGER_TILEMEM_UNDERFLOW_SHIFT   2
#define XDC_DP_INT_TRIGGER_TILEMEM_UNDERFLOW_WIDTH   1
#define XDC_DP_INT_TRIGGER_TILEMEM_UNDERFLOW_TRIGGER   0x00000004

#define XDC_DP_INT_TRIGGER_TILEMEM_OVERFLOW_SHIFT   1
#define XDC_DP_INT_TRIGGER_TILEMEM_OVERFLOW_WIDTH   1
#define XDC_DP_INT_TRIGGER_TILEMEM_OVERFLOW_TRIGGER   0x00000002

#define XDC_DP_INT_TRIGGER_VIDTILE_FORMAT_ERR_SHIFT   0
#define XDC_DP_INT_TRIGGER_VIDTILE_FORMAT_ERR_WIDTH   1
#define XDC_DP_INT_TRIGGER_VIDTILE_FORMAT_ERR_TRIGGER   0x00000001

/**
 *  * Register: XDC_VID_CLK
 *   */
#define XDC_VID_CLK         0X0000CC5C

#define XDC_VIDEO_FRAME_SWITCH 0x0000CD80

/**
 *  * Register: XDC_AUD_CLK
 *   */
#define XDC_AUD_CLK         0X0000CC60

/******************************************************************************/
/**
 * Address mapping for DC TIMING Registers.
 */
/******************************************************************************/
/** @name DC TIMING registers
 *  @{
 */

#define XDC_TIMING_BASEADDR 		0xEDD00000

#define XDC_TIMING_MAIN_STREAM_HTOTAL  	0x00000000
#define XDC_TIMING_MAIN_STREAM_VTOTAL  	0x00000004
#define XDC_TIMING_MAIN_STREAM_HSWIDTH 	0x0000000C
#define XDC_TIMING_MAIN_STREAM_VSWIDTH 	0x00000010
#define XDC_TIMING_MAIN_STREAM_HRES	0x00000014
#define XDC_TIMING_MAIN_STREAM_VRES	0x00000018
#define XDC_TIMING_MAIN_STREAM_HSTART	0x0000001C
#define XDC_TIMING_MAIN_STREAM_VSTART	0x00000020

/******************* Macros (Inline Functions) Definitions ********************/

/** @name Register access macro definitions.
  * @{
  */
#define XDc_In32 Xil_In32
#define XDc_Out32 Xil_Out32
/* @} */

/******************************************************************************/
/**
 * This is a low-level function that reads from the specified register.
 *
 * @param       BaseAddress is the base address of the device.
 * @param       RegOffset is the register offset to be read from.
 *
 * @return      The 32-bit value of the specified register.
 *
 * @note        C-style signature:
 *              u32 XDc_ReadReg(u32 BaseAddress, u32 RegOffset
 *
*******************************************************************************/
#define XDc_ReadReg(BaseAddress, RegOffset) \
	XDc_In32((BaseAddress) + (RegOffset))

/******************************************************************************/
/**
 * This is a low-level function that writes to the specified register.
 *
 * @param       BaseAddress is the base address of the device.
 * @param       RegOffset is the register offset to write to.
 * @param       Data is the 32-bit data to write to the specified register.
 *
 * @return      None.
 *
 * @note        C-style signature:
 *              void XDc_WriteReg(u32 BaseAddress, u32 RegOffset, u32 Data)
 *
*******************************************************************************/
#define XDc_WriteReg(BaseAddress, RegOffset, Data) \
	XDc_Out32((BaseAddress) + (RegOffset), (Data))

#ifdef __cplusplus
}
#endif

#endif /* _XDCHW_H_ */
