/******************************************************************************
* Copyright (C) 2021 Xilinx, Inc. All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************/
/**
*
* @file xrfclk_LMK_conf.h
* @addtogroup xrfclk_LMK_conf
* @{
*
* Contains the configuration data for LMK.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who    Date     Changes
* ----- ---    -------- -----------------------------------------------
* 1.0   dc     08/28/19 Initial version
* 1.1   dc     11/21/19 Remove xil dependencies from linux build
*       dc     11/25/19 update LMX and LMK configs
*       dc     12/05/19 adjust LMX and LMK configs to a rftool needs
* 1.2   dc     22/01/20 add version and list of LMK frequencies
* 1.3   dc     03/10/20 update LMK/LMX config for MTS
* 1.5   dc     13/05/21 Make clear LMK/LMX configuration comments
*
* </pre>
*
******************************************************************************/
#ifndef __XRFCLK_LMK_CONF_H_
#define __XRFCLK_LMK_CONF_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "xrfclk.h"

/* Frequency values for LMK04208 PLL */
#ifdef XPS_BOARD_ZCU111
/* Frequency list for LMK */
const u8 LMK_FREQ_LIST[LMK_FREQ_NUM][FREQ_LIST_STR_SIZE] = { "122.88", "122.88",
							     "122.88" };

const u32 LMK_CKin[LMK_FREQ_NUM][LMK_COUNT] = {

	/* File name reference: LMK04208_ZCU111_revAB_CKin1=12M8_VCO=3072M_Out=122M88_MTS
	   LMX input: 122.88MHz
	   Input 12.8MHz
	   VCO 3072MHz
	   SYSREF (Analog and digital, MTS): 7.68MHz
	   PL REFCLK (MTS) 122.88
	   Input auto detect
	   -- MTS*/
	{ 0x00160040, 0x00143200, 0x00143201, 0x00140322, 0x80140323,
	  0x00140324, 0x80141E05, 0x01100006, 0x01100007, 0x06010008,
	  0x55555549, 0x9102410A, 0x0401900B, 0x1B8C006C, 0x2302886D,
	  0x0200000E, 0x8000800F, 0xC1550410, 0x00000058, 0x02C9C419,
	  0x8FA8001A, 0x10001E1B, 0x0021201C, 0x0180033D, 0x0200033E,
	  0x003F001F },

	/* File name reference: LMK04208_ZCU111_revAB_CKin1=12M8_VCO=3072M_Out=122M88.tcs
	   LMX input: 122.88MHz
	   input 12.8MHz
	   VCO 3072M Output
	   Sysref 0 MHz
	   PL REFCLK 0 MHz
	   Input auto detect
	*/
	{ 0x00160040, 0x80140320, 0x80140321, 0x80140322, 0xC0140023,
	  0x40140024, 0x80141E05, 0x03300006, 0x01300007, 0x06010008,
	  0x55555549, 0x9102410A, 0x0401100B, 0x1B0C006C, 0x2302886D,
	  0x0200000E, 0x8000800F, 0xC1550410, 0x00000058, 0x02C9C419,
	  0x8FA8001A, 0x10001E1B, 0x0021201C, 0x0180033D, 0x0200033E,
	  0x003F001F },

	/* File name reference: LMK04208_ZCU111_revAB_0delay_sync_CKin1=7p68M_VCO=3072M_Out=122M88
	   LMX input: 122.88MHz
	   input 7.68MHz
	   VCO 3072M Output
	   Sysref 7.68 MHz
	   PL REFCLK 122.88 MHz
	   Input auto detect, Zero delay mode
	   --  Multi Board MTS */
	{ 0x00160040, 0x00503200, 0x00503201, 0x00500322, 0xC0140023,
	  0x00500324, 0x00503205, 0x03300006, 0x01300007, 0x0C010008,
	  0x55555549, 0x9102490A, 0x1403900B, 0x1B0C006C, 0x2302886D,
	  0x0200000E, 0x8000800F, 0xC1550410, 0x00000058, 0x02C9C419,
	  0x8FA8001A, 0x1000101B, 0x0020101C, 0x0180033D, 0x0200033E,
	  0x003F001F }
};
#else

/* Frequency list for LMK */
const u8 LMK_FREQ_LIST[LMK_FREQ_NUM][FREQ_LIST_STR_SIZE] = {
	"245M76_PL_122M88_SYSREF_7M68", "250M_PL_125M_SYSREF_10M"
};

const u32 LMK_CKin[LMK_FREQ_NUM][LMK_COUNT] = {

	/* File name reference: 245M76_PL_122M88_SYSREF_7M68.txt
	   DAC refclk/ADC refclk/LMX input:  245.76 MHz
	   PL refclk (MTS): 122.88MHz,
	   Sysref (Analog and digital, MTS): 7.68MHz */
	{
		0x000090, 0x000010, 0x000200, 0x000306, 0x0004D0, 0x00055B,
		0x000600, 0x000C51, 0x000D04, 0x01006A, 0x010155, 0x010255,
		0x010301, 0x010422, 0x010500, 0x010673, 0x010703, 0x01086A,
		0x010955, 0x010A55, 0x010B00, 0x010C22, 0x010D00, 0x010EF0,
		0x010F30, 0x01106A, 0x011155, 0x011255, 0x011301, 0x011422,
		0x011500, 0x011673, 0x011703, 0x01186A, 0x011955, 0x011A55,
		0x011B01, 0x011C22, 0x011D00, 0x011E72, 0x011F03, 0x012074,
		0x012155, 0x012255, 0x012301, 0x012422, 0x012500, 0x012670,
		0x012733, 0x01286A, 0x012955, 0x012A55, 0x012B00, 0x012C22,
		0x012D00, 0x012EF0, 0x012F30, 0x01306A, 0x013155, 0x013255,
		0x013301, 0x013422, 0x013500, 0x013673, 0x013703, 0x013800,
		0x013903, 0x013A01, 0x013B40, 0x013C00, 0x013D01, 0x013E03,
		0x013F02, 0x014009, 0x014100, 0x014200, 0x014331, 0x0144FF,
		0x01457F, 0x014618, 0x01471A, 0x014806, 0x014946, 0x014A06,
		0x014B06, 0x014C00, 0x014D00, 0x014EC0, 0x014F7F, 0x015013,
		0x015102, 0x015200, 0x015300, 0x01547D, 0x015500, 0x01567D,
		0x015703, 0x0158C0, 0x015907, 0x015AD0, 0x015BDA, 0x015C20,
		0x015D00, 0x015E00, 0x015F3E, 0x016000, 0x016119, 0x016244,
		0x016300, 0x016400, 0x0165A0, 0x0171AA, 0x017202, 0x017C15,
		0x017D33, 0x016600, 0x016700, 0x0168C0, 0x016959, 0x016A20,
		0x016B00, 0x016C00, 0x016D00, 0x016E1B, 0x017300, 0x1FFD00,
		0x1FFE00, 0x1FFF53,
	},

	/* File name reference: 250M_PL_125M_SYSREF_10M.txt */
	/* DAC refclk, ADC refclk, and LMX input: 250MHz
	   PL refclk (MTS): 125MHz
	   Sysref (Analog and digital, MTS): 10MHz */
	{
		0x000090, 0x000010, 0x000200, 0x000306, 0x0004D0, 0x00055B,
		0x000600, 0x000C51, 0x000D04, 0x01006C, 0x010155, 0x010255,
		0x010301, 0x010422, 0x010500, 0x010673, 0x010703, 0x01086C,
		0x010955, 0x010A55, 0x010B00, 0x010C22, 0x010D00, 0x010EF0,
		0x010F30, 0x01106C, 0x011155, 0x011255, 0x011301, 0x011422,
		0x011500, 0x011673, 0x011703, 0x01186C, 0x011955, 0x011A55,
		0x011B01, 0x011C22, 0x011D00, 0x011E72, 0x011F03, 0x012078,
		0x012155, 0x012255, 0x012301, 0x012422, 0x012500, 0x012670,
		0x012733, 0x01286C, 0x012955, 0x012A55, 0x012B00, 0x012C22,
		0x012D00, 0x012EF0, 0x012F30, 0x01306C, 0x013155, 0x013255,
		0x013301, 0x013422, 0x013500, 0x013673, 0x013703, 0x013820,
		0x013903, 0x013A01, 0x013B2C, 0x013C00, 0x013D01, 0x013E03,
		0x013F02, 0x014009, 0x014100, 0x014200, 0x014331, 0x0144FF,
		0x01457F, 0x014618, 0x01471A, 0x014806, 0x014946, 0x014A06,
		0x014B06, 0x014C00, 0x014D00, 0x014EC0, 0x014F7F, 0x015013,
		0x015102, 0x015200, 0x015300, 0x01547D, 0x015500, 0x01567D,
		0x015703, 0x0158C0, 0x015907, 0x015AD0, 0x015BDA, 0x015C20,
		0x015D00, 0x015E00, 0x015F3E, 0x016000, 0x016104, 0x016264,
		0x016300, 0x016400, 0x0165A0, 0x0171AA, 0x017202, 0x017C15,
		0x017D33, 0x016600, 0x016700, 0x016819, 0x016959, 0x016A20,
		0x016B00, 0x016C00, 0x016D00, 0x016E1B, 0x017300, 0x1FFD00,
		0x1FFE00, 0x1FFF53,
	},
};

#endif

#ifdef __cplusplus
}
#endif

#endif
/** @} */
