# 水母合成游戏

## 项目介绍

这是一款基于Unity开发的休闲水母合成游戏。玩家需要操控机械爪抓取不同等级的水母，通过合并相同等级的水母来获得更高等级水母，不断挑战高分。

## 游戏特点

- **水母合成机制**：相同等级的水母碰撞后会合成为更高等级的水母
- **物理模拟**：逼真的水母物理效果和机械爪操控
- **精美视觉效果**：水母使用自定义着色器实现动态涟漪和触须摇摆效果
- **分数系统**：根据合成的水母等级计算得分，并记录最高分

## 操作说明

- 使用机械爪抓取水母
- 将相同等级的水母碰撞在一起使其合成
- 尝试获得尽可能高的分数

## 技术实现

### 核心系统

- **GameManager**：负责游戏数据管理，包括分数计算和最高分记录
- **JellyfishController**：控制水母行为，包括合成效果和物理碰撞
- **MechanicalArmController** & **MechanicalClawController**：控制机械臂和机械爪的移动和抓取
- **UIManager**：管理游戏界面和用户交互

### 特效系统

- **JellyfishShader**：自定义水母着色器，实现水母头部的涟漪效果和触须的摇摆动画
- **JellyfishEffect**：控制水母的视觉效果和动画

### 音效系统

- 水母合成音效
- 机械爪操作音效
- 背景音乐

## 开发环境

- Unity 2021.3 或更高版本
- 依赖库：DOTween (用于动画效果)

## 安装说明

1. 克隆或下载本仓库
2. 使用Unity Hub打开项目
3. 确保已安装所有依赖库
4. 构建并运行游戏

## 未来计划

- 添加更多等级的水母
- 实现更多游戏模式
- 优化移动端体验
- 添加更多视觉和音效

## 许可证

本项目遵循 [MIT许可证](LICENSE)

## 联系方式

如有问题或建议，请通过以下方式联系我们：

- 电子邮件：LK13079363917@163.com
