/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.collections.MappingChange;
import impl.org.controlsfx.collections.NonIterableChange;
import impl.org.controlsfx.collections.ReadOnlyUnbackedObservableList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.controlsfx.control.IndexedCheckModel;

abstract class CheckBitSetModelBase<T>
implements IndexedCheckModel<T> {
    private final Map<T, BooleanProperty> itemBooleanMap;
    private final BitSet checkedIndices;
    private final BitSetReadOnlyUnbackedObservableList checkedIndicesList;
    private final ReadOnlyUnbackedObservableList<T> checkedItemsList;
    private AtomicBoolean listenerFlag = new AtomicBoolean();

    CheckBitSetModelBase(Map<T, BooleanProperty> itemBooleanMap) {
        this.itemBooleanMap = itemBooleanMap;
        this.checkedIndices = new BitSet();
        this.checkedIndicesList = new BitSetReadOnlyUnbackedObservableList(this.checkedIndices);
        this.checkedItemsList = new ReadOnlyUnbackedObservableList<T>(){

            @Override
            public T get(int i) {
                int pos = CheckBitSetModelBase.this.checkedIndicesList.get(i);
                if (pos < 0 || pos >= CheckBitSetModelBase.this.getItemCount()) {
                    return null;
                }
                return CheckBitSetModelBase.this.getItem(pos);
            }

            @Override
            public int size() {
                return CheckBitSetModelBase.this.checkedIndices.cardinality();
            }
        };
        MappingChange.Map<Integer, Object> map = f -> this.getItem((int)f);
        this.checkedIndicesList.addListener(c -> {
            boolean hasRealChangeOccurred = false;
            while (c.next() && !hasRealChangeOccurred) {
                hasRealChangeOccurred = c.wasAdded() || c.wasRemoved();
            }
            if (hasRealChangeOccurred) {
                c.reset();
                this.checkedItemsList.callObservers(new MappingChange(c, map, this.checkedItemsList));
            }
            c.reset();
        });
        this.getCheckedItems().addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    for (Object item : c.getAddedSubList()) {
                        this.updateBooleanProperty(item, true);
                    }
                }
                if (!c.wasRemoved()) continue;
                for (Object item : c.getRemoved()) {
                    this.updateBooleanProperty(item, false);
                }
            }
        });
    }

    private void updateBooleanProperty(T item, boolean value) {
        BooleanProperty p = this.getItemBooleanProperty(item);
        if (p != null) {
            this.listenerFlag.set(true);
            p.set(value);
            this.listenerFlag.set(false);
        }
    }

    @Override
    public abstract T getItem(int var1);

    @Override
    public abstract int getItemCount();

    @Override
    public abstract int getItemIndex(T var1);

    BooleanProperty getItemBooleanProperty(T item) {
        return this.itemBooleanMap.get(item);
    }

    @Override
    public ObservableList<Integer> getCheckedIndices() {
        return this.checkedIndicesList;
    }

    @Override
    public ObservableList<T> getCheckedItems() {
        return this.checkedItemsList;
    }

    @Override
    public void checkAll() {
        for (int i = 0; i < this.getItemCount(); ++i) {
            this.check(i);
        }
    }

    @Override
    public void checkIndices(int ... indices) {
        for (int index : indices) {
            this.checkedIndices.set(index);
        }
        ListChangeListener.Change<Integer> change = CheckBitSetModelBase.createRangeChange((ObservableList<Integer>)this.checkedIndicesList, Arrays.stream(indices).boxed().collect(Collectors.toList()), false);
        this.checkedIndicesList.callObservers(change);
    }

    @Override
    public void clearCheck(T item) {
        int index = this.getItemIndex(item);
        this.clearCheck(index);
    }

    @Override
    public void clearChecks() {
        BitSetReadOnlyUnbackedObservableList removed = new BitSetReadOnlyUnbackedObservableList((BitSet)this.checkedIndices.clone());
        this.checkedIndices.clear();
        this.checkedIndicesList.callObservers(new NonIterableChange.GenericAddRemoveChange(0, 0, removed, this.checkedIndicesList));
    }

    @Override
    public void clearCheck(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            return;
        }
        int changeIndex = this.checkedIndicesList.indexOf(index);
        this.checkedIndices.clear(index);
        this.checkedIndicesList.callObservers(new NonIterableChange.SimpleRemovedChange<Integer>(changeIndex, changeIndex, index, (ObservableList<Integer>)this.checkedIndicesList));
    }

    @Override
    public boolean isEmpty() {
        return this.checkedIndices.isEmpty();
    }

    @Override
    public boolean isChecked(T item) {
        int index = this.getItemIndex(item);
        return this.isChecked(index);
    }

    @Override
    public boolean isChecked(int index) {
        return this.checkedIndices.get(index);
    }

    @Override
    public void toggleCheckState(T item) {
        int index = this.getItemIndex(item);
        this.toggleCheckState(index);
    }

    @Override
    public void toggleCheckState(int index) {
        if (this.isChecked(index)) {
            this.clearCheck(index);
        } else {
            this.check(index);
        }
    }

    @Override
    public void check(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            return;
        }
        this.checkedIndices.set(index);
        int changeIndex = this.checkedIndicesList.indexOf(index);
        this.checkedIndicesList.callObservers(new NonIterableChange.SimpleAddChange(changeIndex, changeIndex + 1, this.checkedIndicesList));
    }

    @Override
    public void check(T item) {
        int index = this.getItemIndex(item);
        this.check(index);
    }

    protected void updateMap() {
        this.itemBooleanMap.clear();
        int i = 0;
        while (i < this.getItemCount()) {
            int index = i++;
            T item = this.getItem(index);
            SimpleBooleanProperty booleanProperty = new SimpleBooleanProperty(item, "selected", false);
            this.itemBooleanMap.put(item, (BooleanProperty)booleanProperty);
            booleanProperty.addListener(arg_0 -> this.lambda$updateMap$3((BooleanProperty)booleanProperty, index, arg_0));
        }
    }

    private static ListChangeListener.Change<Integer> createRangeChange(final ObservableList<Integer> list, final List<Integer> addedItems, final boolean splitChanges) {
        ListChangeListener.Change<Integer> change = new ListChangeListener.Change<Integer>(list){
            private final int[] EMPTY_PERM;
            private final int addedSize;
            private boolean invalid;
            private int pos;
            private int from;
            private int to;
            {
                super(arg0);
                this.EMPTY_PERM = new int[0];
                this.addedSize = addedItems.size();
                this.invalid = true;
                this.from = this.pos = 0;
                this.to = this.pos;
            }

            public int getFrom() {
                this.checkState();
                return this.from;
            }

            public int getTo() {
                this.checkState();
                return this.to;
            }

            public List<Integer> getRemoved() {
                this.checkState();
                return Collections.emptyList();
            }

            protected int[] getPermutation() {
                this.checkState();
                return this.EMPTY_PERM;
            }

            public int getAddedSize() {
                return this.to - this.from;
            }

            public boolean next() {
                if (this.pos >= this.addedSize) {
                    return false;
                }
                int startValue = (Integer)addedItems.get(this.pos++);
                this.from = list.indexOf((Object)startValue);
                this.to = this.from + 1;
                int endValue = startValue;
                while (this.pos < this.addedSize) {
                    int previousEndValue = endValue;
                    endValue = (Integer)addedItems.get(this.pos++);
                    ++this.to;
                    if (!splitChanges || previousEndValue == endValue - 1) continue;
                    break;
                }
                if (this.invalid) {
                    this.invalid = false;
                    return true;
                }
                return splitChanges && this.pos < this.addedSize;
            }

            public void reset() {
                this.invalid = true;
                this.pos = 0;
                this.to = 0;
                this.from = 0;
            }

            private void checkState() {
                if (this.invalid) {
                    throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
                }
            }
        };
        return change;
    }

    private /* synthetic */ void lambda$updateMap$3(BooleanProperty booleanProperty, int index, Observable o) {
        if (!this.listenerFlag.get()) {
            if (booleanProperty.get()) {
                this.check(index);
            } else {
                this.clearCheck(index);
            }
        }
    }

    private class BitSetReadOnlyUnbackedObservableList
    extends ReadOnlyUnbackedObservableList<Integer> {
        private final BitSet bitset;
        private int lastGetIndex = -1;
        private int lastGetValue = -1;

        public BitSetReadOnlyUnbackedObservableList(BitSet bitset) {
            this.bitset = bitset;
        }

        @Override
        public Integer get(int index) {
            int itemCount = CheckBitSetModelBase.this.getItemCount();
            if (index < 0 || index >= itemCount) {
                return -1;
            }
            if (index == this.lastGetIndex + 1 && this.lastGetValue < itemCount) {
                ++this.lastGetIndex;
                this.lastGetValue = this.bitset.nextSetBit(this.lastGetValue + 1);
                return this.lastGetValue;
            }
            if (index == this.lastGetIndex - 1 && this.lastGetValue > 0) {
                --this.lastGetIndex;
                this.lastGetValue = this.bitset.previousSetBit(this.lastGetValue - 1);
                return this.lastGetValue;
            }
            this.lastGetIndex = 0;
            this.lastGetValue = this.bitset.nextSetBit(0);
            while (this.lastGetValue >= 0 || this.lastGetIndex == index) {
                if (this.lastGetIndex == index) {
                    return this.lastGetValue;
                }
                ++this.lastGetIndex;
                this.lastGetValue = this.bitset.nextSetBit(this.lastGetValue + 1);
            }
            return -1;
        }

        @Override
        public int size() {
            return this.bitset.cardinality();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Number) {
                Number n = (Number)o;
                int index = n.intValue();
                return index >= 0 && index < this.bitset.length() && this.bitset.get(index);
            }
            return false;
        }

        public void reset() {
            this.lastGetIndex = -1;
            this.lastGetValue = -1;
        }
    }
}

