/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.loaders;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.bramp.ffmpeg.FFprobe;
import net.bramp.ffmpeg.probe.FFmpegChapter;
import net.bramp.ffmpeg.probe.FFmpegFormat;
import net.bramp.ffmpeg.probe.FFmpegProbeResult;
import net.bramp.ffmpeg.probe.FFmpegStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionGroup;
import uk.yermak.audiobookconverter.book.ArtWork;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.book.MediaInfoBean;
import uk.yermak.audiobookconverter.book.Track;
import uk.yermak.audiobookconverter.loaders.ArtWorkProxy;
import uk.yermak.audiobookconverter.loaders.FFMediaLoader;
import uk.yermak.audiobookconverter.loaders.FFmpegArtWorkExtractor;
import uk.yermak.audiobookconverter.loaders.FlacLoader;
import uk.yermak.audiobookconverter.loaders.MP4v2ArtWorkChecker;
import uk.yermak.audiobookconverter.loaders.MP4v2ArtWorkExtractor;

class MediaInfoLoader
implements Callable<MediaInfo> {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Set<String> AUDIO_CODECS = ImmutableSet.of((Object)"mp3", (Object)"aac", (Object)"wmav2", (Object)"flac", (Object)"alac", (Object)"vorbis", (Object[])new String[]{"opus"});
    private static final ImmutableMap<String, String> ART_WORK_CODECS = ImmutableMap.of((Object)"mjpeg", (Object)"jpg", (Object)"png", (Object)"png", (Object)"bmp", (Object)"bmp");
    private static final Set<String> MP4_FILES = ImmutableSet.of((Object)"m4b", (Object)"m4a", (Object)"mp4");
    private final String filename;
    private final ConversionGroup conversionGroup;
    private final FFprobe ffprobe;
    private static final ScheduledExecutorService artExecutor = Executors.newScheduledThreadPool(8);

    public MediaInfoLoader(FFprobe ffprobe, String filename, ConversionGroup conversionGroup) {
        this.ffprobe = ffprobe;
        this.filename = filename;
        this.conversionGroup = conversionGroup;
    }

    @Override
    public MediaInfo call() throws Exception {
        try {
            if (this.conversionGroup.isOver() || this.conversionGroup.isRunning()) {
                throw new InterruptedException("Media Info Loading was interrupted");
            }
            FFmpegProbeResult probeResult = this.ffprobe.probe(this.filename);
            FFMediaLoader.logger.debug("Extracted ffprobe error: {}", (Object)probeResult.getError());
            FFmpegFormat format = probeResult.getFormat();
            FFMediaLoader.logger.debug("Extracted track format: {}", (Object)format.format_name);
            MediaInfoBean mediaInfo = new MediaInfoBean(this.filename);
            List streams = probeResult.getStreams();
            FFMediaLoader.logger.debug("Found {} streams in {}", (Object)streams.size(), (Object)this.filename);
            Map streamTags = null;
            for (int i = 0; i < streams.size(); ++i) {
                FFmpegStream ffMpegStream = (FFmpegStream)streams.get(i);
                if (AUDIO_CODECS.contains(ffMpegStream.codec_name) || ffMpegStream.codec_name.startsWith("pcm")) {
                    FFMediaLoader.logger.debug("Found {} audio stream in {}", (Object)ffMpegStream.codec_name, (Object)this.filename);
                    mediaInfo.setCodec(ffMpegStream.codec_name);
                    mediaInfo.setChannels(ffMpegStream.channels);
                    mediaInfo.setFrequency(ffMpegStream.sample_rate);
                    mediaInfo.setBitrate((int)ffMpegStream.bit_rate);
                    mediaInfo.setDuration(Math.round(ffMpegStream.duration * 1000.0));
                    streamTags = ffMpegStream.tags;
                    continue;
                }
                if (ART_WORK_CODECS.containsKey((Object)ffMpegStream.codec_name) && !MP4_FILES.contains(FilenameUtils.getExtension((String)this.filename).toLowerCase())) {
                    FFMediaLoader.logger.debug("Found {} image stream in {}", (Object)ffMpegStream.codec_name, (Object)this.filename);
                    if (this.conversionGroup.isDetached()) continue;
                    ScheduledFuture<ArtWork> futureLoad = artExecutor.schedule(new FFmpegArtWorkExtractor(mediaInfo, (String)ART_WORK_CODECS.get((Object)ffMpegStream.codec_name), this.conversionGroup, i), 100L, TimeUnit.MILLISECONDS);
                    ArtWorkProxy artWork = new ArtWorkProxy(futureLoad);
                    mediaInfo.addArtWork(artWork);
                    continue;
                }
                if (!ffMpegStream.codec_name.equals("bin_data") || !MP4_FILES.contains(FilenameUtils.getExtension((String)this.filename).toLowerCase()) || this.conversionGroup.isDetached()) continue;
                List<String> imageFormats = new MP4v2ArtWorkChecker(this.conversionGroup, mediaInfo.getFileName()).list();
                for (int j = 0; j < imageFormats.size(); ++j) {
                    String imageType = imageFormats.get(j);
                    ScheduledFuture<ArtWork> futureLoad = artExecutor.schedule(new MP4v2ArtWorkExtractor(mediaInfo, imageType, this.conversionGroup, j), (long)(1 * j), TimeUnit.MILLISECONDS);
                    ArtWorkProxy artWork = new ArtWorkProxy(futureLoad);
                    mediaInfo.addArtWork(artWork);
                }
            }
            FFMediaLoader.logger.debug("Found tags: {} in {}", (Object)format.tags, (Object)this.filename);
            HashMap<String, String> tags = new HashMap<String, String>();
            if (format.tags != null) {
                tags.putAll(format.tags);
            }
            if (streamTags != null) {
                tags.putAll(streamTags);
            }
            AudioBookInfo bookInfo = AudioBookInfo.instance(tags);
            mediaInfo.setBookInfo(bookInfo);
            this.processEmbededChapter(mediaInfo, probeResult.getChapters());
            if (FilenameUtils.getExtension((String)this.filename).equalsIgnoreCase("FLAC")) {
                FlacLoader.parseCueChapters(mediaInfo);
            }
            logger.info("Created AudioBookInfo {}", (Object)bookInfo);
            return mediaInfo;
        }
        catch (Exception e) {
            FFMediaLoader.logger.error("Failed to load media info", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
    }

    private void processEmbededChapter(MediaInfoBean mediaInfo, List<FFmpegChapter> chapters) {
        AudioBookInfo bookInfo = mediaInfo.getBookInfo();
        for (int i = 0; i < chapters.size(); ++i) {
            FFmpegChapter chapter = chapters.get(i);
            String trackNo = StringUtils.leftPad((String)String.valueOf(i + 1), (int)3, (String)"00");
            Track track = new Track(trackNo);
            if (chapter.tags != null) {
                track.setTitle(chapter.tags.title);
            } else {
                track.setTitle("Chapter " + trackNo);
            }
            track.setStart((long)(Double.parseDouble(chapter.start_time) * 1000.0));
            track.setEnd((long)(Double.parseDouble(chapter.end_time) * 1000.0));
            bookInfo.tracks().add((Object)track);
        }
    }
}

