/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.loaders;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javafx.scene.image.Image;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.ConversionGroup;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.StreamCopier;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.ArtWork;
import uk.yermak.audiobookconverter.book.MediaInfoBean;
import uk.yermak.audiobookconverter.loaders.ArtWorkImage;
import uk.yermak.audiobookconverter.loaders.FFMediaLoader;

class MP4v2ArtWorkExtractor
implements Callable<ArtWork> {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MediaInfoBean mediaInfo;
    private final String format;
    private final ConversionGroup conversionGroup;
    private int index;

    public MP4v2ArtWorkExtractor(MediaInfoBean mediaInfo, String format, ConversionGroup conversionGroup, int index) {
        this.mediaInfo = mediaInfo;
        this.format = format;
        this.conversionGroup = conversionGroup;
        this.index = index;
    }

    /*
     * Loose catch block
     */
    @Override
    public ArtWork call() throws Exception {
        Process process = null;
        File poster = null;
        if (this.conversionGroup.isOver() || this.conversionGroup.isStarted() || this.conversionGroup.isDetached()) {
            throw new InterruptedException("ArtWork loading was interrupted");
        }
        poster = new File(new File(this.mediaInfo.getFileName()).getParentFile(), FilenameUtils.getBaseName((String)this.mediaInfo.getFileName()) + ".art[" + this.index + "]." + this.format);
        ProcessBuilder pictureProcessBuilder = new ProcessBuilder(Platform.MP4ART, "--art-index", String.valueOf(this.index), "--extract", "-o", this.mediaInfo.getFileName());
        process = pictureProcessBuilder.start();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamCopier.copy(process.getInputStream(), out);
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        StreamCopier.copy(process.getErrorStream(), err);
        boolean finished = false;
        while (!this.conversionGroup.isOver() && !finished) {
            finished = process.waitFor(500L, TimeUnit.MILLISECONDS);
        }
        FFMediaLoader.logger.debug("ArtWork Out: {}", (Object)out);
        FFMediaLoader.logger.error("ArtWork Error: {}", (Object)err);
        FileInputStream imageStream = new FileInputStream(poster);
        ArtWorkImage artWorkBean = new ArtWorkImage(new Image((InputStream)imageStream));
        javafx.application.Platform.runLater(() -> {
            if (!(this.conversionGroup.isOver() || this.conversionGroup.isStarted() || this.conversionGroup.isDetached())) {
                AudiobookConverter.getContext().addPosterIfMissingWithDelay(artWorkBean);
            }
        });
        ArtWorkImage artWorkImage = artWorkBean;
        imageStream.close();
        FileUtils.deleteQuietly((File)poster);
        Utils.closeSilently(process);
        return artWorkImage;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            imageStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.error("Error in extracting image with MP4Art:", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                catch (Throwable throwable3) {
                    FileUtils.deleteQuietly(poster);
                    Utils.closeSilently(process);
                    throw throwable3;
                }
            }
        }
    }
}

