/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.loaders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionGroup;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.StreamCopier;
import uk.yermak.audiobookconverter.Utils;

public class MP4v2ArtWorkChecker {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ConversionGroup conversionGroup;
    private String filename;

    public MP4v2ArtWorkChecker(ConversionGroup conversionGroup, String filename) {
        this.conversionGroup = conversionGroup;
        this.filename = filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> list() throws InterruptedException, IOException {
        List<String> list;
        Process process = null;
        try {
            List<String> result;
            if (this.conversionGroup.isOver() || this.conversionGroup.isStarted() || this.conversionGroup.isDetached()) {
                throw new InterruptedException("ArtWork loading was interrupted");
            }
            ProcessBuilder pictureProcessBuilder = new ProcessBuilder(Platform.MP4ART, "--list", this.filename);
            process = pictureProcessBuilder.start();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamCopier.copy(process.getInputStream(), out);
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            StreamCopier.copy(process.getErrorStream(), err);
            boolean finished = false;
            while (!this.conversionGroup.isOver() && !finished) {
                finished = process.waitFor(500L, TimeUnit.MILLISECONDS);
            }
            logger.debug("MP4Art Out: {}", (Object)out);
            logger.error("MP4Art Error: {}", (Object)err);
            list = result = MP4v2ArtWorkChecker.parseMP4v2ArtList(out.toString());
        }
        catch (Throwable throwable) {
            Utils.closeSilently(process);
            throw throwable;
        }
        Utils.closeSilently(process);
        return list;
    }

    static List<String> parseMP4v2ArtList(String out) {
        ArrayList<String> result = new ArrayList<String>();
        String[] lines = StringUtils.split((String)out, (String)"\n");
        for (int i = 2; i < lines.length; ++i) {
            String line = lines[i];
            if (!StringUtils.isNotEmpty((CharSequence)line)) continue;
            String[] columns = StringUtils.split((String)line, (String)" ");
            int imageId = Integer.parseInt(StringUtils.trimToEmpty((String)columns[0]));
            if (i - 2 == imageId) {
                String fileType;
                switch (fileType = StringUtils.trimToEmpty((String)columns[3])) {
                    case "implicit": {
                        result.add("dat");
                        break;
                    }
                    case "jpeg": {
                        result.add("jpg");
                        break;
                    }
                    default: {
                        result.add(fileType);
                        break;
                    }
                }
                continue;
            }
            logger.error("Unexpected result parsing mp4art output for line :" + (i - 2) + ", received image number: " + imageId);
        }
        return result;
    }
}

