/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.loaders;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.MediaInfoBean;
import uk.yermak.audiobookconverter.book.Track;

public class FlacLoader {
    static void parseCueChapters(MediaInfoBean mediaInfo) throws IOException {
        String filename = mediaInfo.getFileName();
        File file = new File(FilenameUtils.getFullPath((String)filename) + FilenameUtils.getBaseName((String)filename) + ".cue");
        if (file.exists()) {
            String cue = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            FlacLoader.parseCue(mediaInfo, cue);
        }
    }

    static void parseCue(MediaInfoBean mediaInfo, String cue) {
        String[] split;
        AudioBookInfo bookInfo = mediaInfo.getBookInfo();
        for (String line : split = StringUtils.split((String)cue, (String)"\n")) {
            Track track;
            int i = -1;
            if (bookInfo.tracks().isEmpty()) {
                i = line.indexOf("GENRE");
                if (i != -1) {
                    bookInfo.genre().set(Utils.cleanText(line.substring(i + 5)));
                }
                if ((i = line.indexOf("TITLE")) != -1) {
                    bookInfo.title().set(Utils.cleanText(line.substring(i + 5)));
                }
                if ((i = line.indexOf("DATE")) != -1) {
                    bookInfo.year().set(Utils.cleanText(line.substring(i + 4)));
                }
                if ((i = line.indexOf("PERFORMER")) != -1) {
                    bookInfo.narrator().set(Utils.cleanText(line.substring(i + 9)));
                }
            } else {
                Track track2 = (Track)bookInfo.tracks().get(bookInfo.tracks().size() - 1);
                i = line.indexOf("TITLE");
                if (i != -1) {
                    track2.setTitle(Utils.cleanText(line.substring(i + 5)));
                }
                if ((i = line.indexOf("PERFORMER")) != -1) {
                    track2.setWriter(Utils.cleanText(line.substring(i + 9)));
                }
            }
            if ((i = line.indexOf("TRACK")) != -1) {
                bookInfo.tracks().add((Object)new Track(Utils.cleanText(line.substring(i + 5))));
                continue;
            }
            i = line.indexOf("INDEX 01");
            if (i == -1) continue;
            long time = FlacLoader.parseCueTime(line.substring(i + 8));
            if (bookInfo.tracks().size() > 1) {
                track = (Track)bookInfo.tracks().get(bookInfo.tracks().size() - 2);
                track.setEnd(time);
            }
            track = (Track)bookInfo.tracks().get(bookInfo.tracks().size() - 1);
            track.setStart(time);
        }
        if (!bookInfo.tracks().isEmpty()) {
            ((Track)bookInfo.tracks().get(bookInfo.tracks().size() - 1)).setEnd(mediaInfo.getDuration());
        }
    }

    private static long parseCueTime(String substring) {
        String cleanText = Utils.cleanText(substring);
        String[] split = cleanText.split(":");
        return 1000 * (Integer.parseInt(split[0]) * 60 + Integer.parseInt(split[1])) + Integer.parseInt(split[2]) * 1000 / 75;
    }
}

