/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.loaders;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.scene.image.Image;
import net.bramp.ffmpeg.FFprobe;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.ConversionGroup;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.book.ArtWork;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.fx.ConversionContext;
import uk.yermak.audiobookconverter.loaders.ArtWorkImage;
import uk.yermak.audiobookconverter.loaders.MediaInfoLoader;
import uk.yermak.audiobookconverter.loaders.MediaInfoProxy;

public class FFMediaLoader {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<String> fileNames;
    private final ConversionGroup conversionGroup;
    private static final ExecutorService mediaExecutor = Executors.newSingleThreadExecutor();

    public FFMediaLoader(List<String> files, ConversionGroup conversionGroup) {
        this.fileNames = files;
        this.conversionGroup = conversionGroup;
    }

    public List<MediaInfo> loadMediaInfo() {
        logger.info("Loading media info");
        try {
            FFprobe ffprobe = new FFprobe(Platform.FFPROBE);
            ArrayList<MediaInfo> media = new ArrayList<MediaInfo>();
            for (String fileName : this.fileNames) {
                Future<MediaInfo> futureLoad = mediaExecutor.submit(new MediaInfoLoader(ffprobe, fileName, this.conversionGroup));
                MediaInfoProxy mediaInfo = new MediaInfoProxy(fileName, futureLoad);
                media.add(mediaInfo);
            }
            FFMediaLoader.searchForPosters(media);
            return media;
        }
        catch (Exception e) {
            logger.error("Error during loading media info", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void detach() {
    }

    static Collection<File> findPictures(File dir) {
        try {
            return FileUtils.listFiles((File)dir, (String[])ArtWork.IMAGE_EXTENSIONS, (boolean)true);
        }
        catch (Exception e) {
            logger.error("Failed to search for images in dir:" + String.valueOf(dir), (Throwable)e);
            return Collections.emptyList();
        }
    }

    static void searchForPosters(List<MediaInfo> media) throws FileNotFoundException {
        HashSet searchDirs = new HashSet();
        media.forEach(mi -> searchDirs.add(new File(mi.getFileName()).getParentFile()));
        ArrayList<File> pictures = new ArrayList<File>();
        ConversionContext context = AudiobookConverter.getContext();
        for (File d : searchDirs) {
            pictures.addAll(FFMediaLoader.findPictures(d));
        }
        if (!pictures.isEmpty()) {
            for (int i = 0; i < 10 && i < pictures.size(); ++i) {
                try (FileInputStream imageStream = new FileInputStream(((File)pictures.get(i)).getPath());){
                    context.addPosterIfMissingWithDelay(new ArtWorkImage(new Image((InputStream)imageStream)));
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

