/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.loaders;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.ArtWork;
import uk.yermak.audiobookconverter.loaders.ArtWorkBean;

public class ArtWorkImage
implements ArtWork {
    private final Image image;
    private final Logger logger;
    private ArtWork bean;

    @Override
    public Image image() {
        return this.image;
    }

    private Logger logger() {
        return this.logger;
    }

    private ArtWork getBean() {
        if (this.bean != null) {
            return this.bean;
        }
        BufferedImage bImage = SwingFXUtils.fromFXImage((Image)this.image(), null);
        String poster = Utils.getTmp(AudiobookConverter.getContext().getConversionGroup().getGroupId(), this.image().hashCode(), "png");
        try {
            File posterFile = new File(poster);
            posterFile.deleteOnExit();
            ImageIO.write((RenderedImage)bImage, "png", posterFile);
            long crc32 = Utils.checksumCRC32(posterFile);
            this.bean = new ArtWorkBean(poster, crc32);
        }
        catch (IOException var7) {
            this.logger().error("Error during parallel conversion", (Throwable)var7);
            var7.printStackTrace();
        }
        return this.bean;
    }

    @Override
    public long getCrc32() {
        return this.getBean().getCrc32();
    }

    @Override
    public String getFileName() {
        return this.getBean().getFileName();
    }

    @Override
    public boolean matchCrc32(long crc32) {
        return this.getCrc32() == crc32;
    }

    public ArtWorkImage(Image image) {
        this.image = image;
        this.logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        this.bean = null;
    }
}

