/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx.util;

import java.text.DecimalFormatSymbols;
import java.util.regex.Pattern;
import javafx.beans.NamedArg;
import javafx.scene.control.TextFormatter;

public class TextFieldValidator {
    private static final String CURRENCY_SYMBOL = DecimalFormatSymbols.getInstance().getCurrencySymbol();
    private static final char DECIMAL_SEPARATOR = DecimalFormatSymbols.getInstance().getDecimalSeparator();
    private final Pattern INPUT_PATTERN;

    public TextFieldValidator(@NamedArg(value="modus") ValidationModus modus, @NamedArg(value="countOf") int countOf) {
        this(modus.createPattern(countOf));
    }

    public TextFieldValidator(@NamedArg(value="regex") String regex) {
        this(Pattern.compile(regex));
    }

    public TextFieldValidator(Pattern inputPattern) {
        this.INPUT_PATTERN = inputPattern;
    }

    public static TextFieldValidator maxFractionDigits(int countOf) {
        return new TextFieldValidator(TextFieldValidator.maxFractionPattern(countOf));
    }

    public static TextFieldValidator maxIntegers(int countOf) {
        return new TextFieldValidator(TextFieldValidator.maxIntegerPattern(countOf));
    }

    public static TextFieldValidator integersOnly() {
        return new TextFieldValidator(TextFieldValidator.integersOnlyPattern());
    }

    public TextFormatter<Object> getFormatter() {
        return new TextFormatter<Object>(this::validateChange);
    }

    private TextFormatter.Change validateChange(TextFormatter.Change c) {
        if (this.validate(c.getControlNewText())) {
            return c;
        }
        return null;
    }

    public boolean validate(String input) {
        return this.INPUT_PATTERN.matcher(input).matches();
    }

    private static Pattern maxFractionPattern(int countOf) {
        return Pattern.compile("\\d*(\\" + DECIMAL_SEPARATOR + "\\d{0," + countOf + "})?");
    }

    private static Pattern maxCurrencyFractionPattern(int countOf) {
        return Pattern.compile("^\\" + CURRENCY_SYMBOL + "?\\s?\\d*(\\" + DECIMAL_SEPARATOR + "\\d{0," + countOf + "})?\\s?\\" + CURRENCY_SYMBOL + "?");
    }

    private static Pattern maxIntegerPattern(int countOf) {
        return Pattern.compile("\\d{0," + countOf + "}");
    }

    private static Pattern integersOnlyPattern() {
        return Pattern.compile("\\d*");
    }

    public static enum ValidationModus {
        MAX_CURRENCY_FRACTION_DIGITS{

            @Override
            public Pattern createPattern(int countOf) {
                return TextFieldValidator.maxCurrencyFractionPattern(countOf);
            }
        }
        ,
        MAX_FRACTION_DIGITS{

            @Override
            public Pattern createPattern(int countOf) {
                return TextFieldValidator.maxFractionPattern(countOf);
            }
        }
        ,
        MAX_INTEGERS{

            @Override
            public Pattern createPattern(int countOf) {
                return TextFieldValidator.maxIntegerPattern(countOf);
            }
        }
        ,
        INTEGERS_ONLY{

            @Override
            public Pattern createPattern(int countOf) {
                return TextFieldValidator.integersOnlyPattern();
            }
        };


        public abstract Pattern createPattern(int var1);
    }
}

