/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx.util;

import javafx.scene.control.ContextMenu;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.util.Callback;
import uk.yermak.audiobookconverter.fx.util.ContextMenuBuilder;

public class ContextMenuTreeTableRow<T>
extends TreeTableRow<T> {
    public static <T> Callback<TreeTableView<T>, TreeTableRow<T>> forListView(ContextMenuBuilder contextMenuBuilder) {
        return ContextMenuTreeTableRow.forListView(contextMenuBuilder, null);
    }

    public static <T> Callback<TreeTableView<T>, TreeTableRow<T>> forListView(ContextMenuBuilder contextMenuBuilder, Callback<TreeTableView<T>, TreeTableRow<T>> treeTableRowFactory) {
        return listView -> {
            TreeTableRow row = treeTableRowFactory == null ? new TreeTableRow() : (TreeTableRow)treeTableRowFactory.call(listView);
            row.emptyProperty().addListener((obs, wasEmpty, isNowEmpty) -> {
                if (isNowEmpty.booleanValue()) {
                    row.setContextMenu(null);
                } else {
                    row.setContextMenu(contextMenuBuilder.menu(row.getTreeItem().getValue()));
                }
            });
            row.selectedProperty().addListener((observableValue, prev, current) -> {
                if (row.getTreeItem() != null) {
                    row.setContextMenu(contextMenuBuilder.menu(row.getTreeItem().getValue()));
                } else {
                    row.setContextMenu(null);
                }
            });
            return row;
        };
    }

    public ContextMenuTreeTableRow(ContextMenu contextMenu) {
        this.setContextMenu(contextMenu);
    }
}

