/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx.util;

import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import uk.yermak.audiobookconverter.fx.util.ContextMenuBuilder;
import uk.yermak.audiobookconverter.fx.util.DefaultListCell;

public class ContextMenuListCell<T>
extends ListCell<T> {
    public static <T> Callback<ListView<T>, ListCell<T>> forListView(ContextMenuBuilder contextMenuBuilder) {
        return ContextMenuListCell.forListView(contextMenuBuilder, null);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(ContextMenuBuilder contextMenuBuilder, Callback<ListView<T>, ListCell<T>> cellFactory) {
        return listView -> {
            ListCell cell = cellFactory == null ? new DefaultListCell() : (ListCell)cellFactory.call(listView);
            cell.emptyProperty().addListener((obs, wasEmpty, isNowEmpty) -> {
                if (isNowEmpty.booleanValue()) {
                    cell.setContextMenu(null);
                } else {
                    cell.setContextMenu(contextMenuBuilder.menu(cell.getItem()));
                }
            });
            return cell;
        };
    }

    public ContextMenuListCell(ContextMenu contextMenu) {
        this.setContextMenu(contextMenu);
    }
}

