/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

public class Comparators {
    private Comparators() {
        throw new AssertionError((Object)"no instances");
    }

    public static <T extends CharSequence> Comparator<T> comparingAlphaDecimal(Comparator<? super CharSequence> alphaComparator) {
        return new AlphaDecimalComparator(Objects.requireNonNull(alphaComparator), false);
    }

    static class AlphaDecimalComparator<T extends CharSequence>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = -2907334574887336595L;
        private final Comparator<? super CharSequence> alphaComparator;
        private final Comparator<CharSequence> decimalComparator;

        AlphaDecimalComparator(Comparator<? super CharSequence> alphaComparator, boolean leadingZeroesFirst) {
            this(alphaComparator, DecimalComparator.getInstance(leadingZeroesFirst));
        }

        private AlphaDecimalComparator(Comparator<? super CharSequence> alphaComparator, Comparator<CharSequence> decimalComparator) {
            this.alphaComparator = alphaComparator;
            this.decimalComparator = decimalComparator;
        }

        @Override
        public Comparator<T> reversed() {
            return new AlphaDecimalComparator<T>(this.alphaComparator.reversed(), this.decimalComparator.reversed());
        }

        @Override
        public int compare(T cs1, T cs2) {
            Decomposer d1 = new Decomposer((CharSequence)cs1);
            Decomposer d2 = new Decomposer((CharSequence)cs2);
            do {
                int cmp;
                if ((cmp = this.alphaComparator.compare(d1.get(), d2.get())) == 0 && (cmp = this.decimalComparator.compare(d1.get(), d2.get())) == 0) continue;
                return cmp;
            } while (!d1.eos() || !d2.eos());
            return 0;
        }

        private static class Decomposer {
            private final CharSequence sequence;
            private boolean expectingDecimal = false;
            private int index = 0;

            Decomposer(CharSequence sequence) {
                this.sequence = sequence;
            }

            CharSequence get() {
                int cpWidth;
                int start;
                int end = start = this.index;
                for (int len = this.sequence.length() - start; len > 0; len -= cpWidth) {
                    boolean isDecimal;
                    int cp = Character.codePointAt(this.sequence, end);
                    int ct = Character.getType(cp);
                    boolean bl = isDecimal = ct == 9;
                    if (isDecimal ^ this.expectingDecimal) break;
                    cpWidth = Character.charCount(cp);
                    end += cpWidth;
                }
                this.expectingDecimal = !this.expectingDecimal;
                this.index = end;
                return this.sequence.subSequence(start, this.index);
            }

            boolean eos() {
                return this.index >= this.sequence.length();
            }
        }
    }

    private static class DecimalComparator
    implements Comparator<CharSequence>,
    Serializable {
        private static final long serialVersionUID = 7358473620261662797L;
        private static final Comparator<CharSequence> DECIMAL_COMPARATOR_LEADING_ZEROES_FIRST = new DecimalComparator(true){

            @Override
            public Comparator<CharSequence> reversed() {
                return DECIMAL_COMPARATOR_LEADING_ZEROES_FIRST_REVERSED;
            }
        };
        private static final Comparator<CharSequence> DECIMAL_COMPARATOR_LEADING_ZEROES_LAST = new DecimalComparator(false){

            @Override
            public Comparator<CharSequence> reversed() {
                return DECIMAL_COMPARATOR_LEADING_ZEROES_LAST_REVERSED;
            }
        };
        private static final Comparator<CharSequence> DECIMAL_COMPARATOR_LEADING_ZEROES_FIRST_REVERSED = new DecimalComparator(true){

            @Override
            public Comparator<CharSequence> reversed() {
                return DECIMAL_COMPARATOR_LEADING_ZEROES_FIRST;
            }

            @Override
            public int compare(CharSequence cs1, CharSequence cs2) {
                return super.compare(cs2, cs1);
            }
        };
        private static final Comparator<CharSequence> DECIMAL_COMPARATOR_LEADING_ZEROES_LAST_REVERSED = new DecimalComparator(false){

            @Override
            public Comparator<CharSequence> reversed() {
                return DECIMAL_COMPARATOR_LEADING_ZEROES_LAST;
            }

            @Override
            public int compare(CharSequence cs1, CharSequence cs2) {
                return super.compare(cs2, cs1);
            }
        };
        private final boolean leadingZeroesFirst;

        private DecimalComparator(boolean leadingZeroesFirst) {
            this.leadingZeroesFirst = leadingZeroesFirst;
        }

        static Comparator<CharSequence> getInstance(boolean leadingZeroesFirst) {
            return leadingZeroesFirst ? DECIMAL_COMPARATOR_LEADING_ZEROES_FIRST : DECIMAL_COMPARATOR_LEADING_ZEROES_LAST;
        }

        private boolean canSkipLeadingZeroes(CharSequence s, int len) {
            int cp;
            for (int i = 0; i < len; i += Character.charCount(cp)) {
                cp = Character.codePointAt(s, i);
                if (Character.digit(cp, 10) == 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compare(CharSequence cs1, CharSequence cs2) {
            int len1 = Character.codePointCount(cs1, 0, cs1.length());
            int len2 = Character.codePointCount(cs2, 0, cs2.length());
            int dlen = len1 - len2;
            if (len1 == 0 || len2 == 0) {
                return dlen;
            }
            if (dlen > 0) {
                if (!this.canSkipLeadingZeroes(cs1, dlen)) {
                    return 1;
                }
                off = Character.offsetByCodePoints(cs1, 0, dlen);
                cs1 = cs1.subSequence(off, cs1.length());
            } else if (dlen < 0) {
                if (!this.canSkipLeadingZeroes(cs2, -dlen)) {
                    return -1;
                }
                off = Character.offsetByCodePoints(cs2, 0, -dlen);
                cs2 = cs2.subSequence(off, cs2.length());
            }
            int cmp = 0;
            int i1 = 0;
            int i2 = 0;
            while (i1 < cs1.length()) {
                int cp2;
                int cp1 = Character.codePointAt(cs1, i1);
                if (cp1 != (cp2 = Character.codePointAt(cs2, i2))) {
                    int cmpNum;
                    if (cmp == 0) {
                        cmp = cp1 - cp2;
                    }
                    if ((cmpNum = Character.digit(cp1, 10) - Character.digit(cp2, 10)) != 0) {
                        return cmpNum;
                    }
                }
                i1 += Character.charCount(cp1);
                i2 += Character.charCount(cp2);
            }
            return dlen == 0 ? cmp : (this.leadingZeroesFirst ^ dlen < 0 ? -1 : 1);
        }
    }
}

