/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Font;
import javafx.stage.Modality;

public class WizardDialog
extends Dialog<Void> {
    private final TextArea hintsArea = new TextArea();
    private int currentIndex = 0;
    private List<String> hints;

    public WizardDialog(List<String> hints) {
        this.hints = hints;
        this.setTitle("Tip of the day...");
        this.initModality(Modality.APPLICATION_MODAL);
        this.hintsArea.setMinHeight(200.0);
        this.hintsArea.setMinWidth(500.0);
        this.hintsArea.setEditable(false);
        this.hintsArea.setFocusTraversable(false);
        this.hintsArea.setWrapText(true);
        this.hintsArea.setFont(Font.font((String)"monospaced", (double)15.0));
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.setContent((Node)this.createWizardPane());
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.PREVIOUS, ButtonType.NEXT, ButtonType.CLOSE});
        Button prevButton = (Button)this.getDialogPane().lookupButton(ButtonType.PREVIOUS);
        prevButton.setFocusTraversable(false);
        prevButton.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            event.consume();
            this.prev();
        });
        Button nextButton = (Button)this.getDialogPane().lookupButton(ButtonType.NEXT);
        nextButton.setFocusTraversable(false);
        nextButton.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            event.consume();
            this.next();
        });
    }

    private BorderPane createWizardPane() {
        BorderPane wizardPane = new BorderPane();
        wizardPane.setPadding(new Insets(20.0));
        this.hintsArea.setText(this.hints.get(this.currentIndex));
        wizardPane.setCenter((Node)this.hintsArea);
        return wizardPane;
    }

    private void next() {
        this.currentIndex = this.currentIndex < this.hints.size() - 1 ? ++this.currentIndex : 0;
        this.hintsArea.setText(this.hints.get(this.currentIndex));
    }

    private void prev() {
        this.currentIndex = this.currentIndex > 0 ? --this.currentIndex : this.hints.size() - 1;
        this.hintsArea.setText(this.hints.get(this.currentIndex));
    }
}

