/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Spinner;
import javafx.scene.layout.GridPane;
import javafx.stage.Window;
import org.controlsfx.control.ToggleSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubTracksDialog
extends Dialog<Map<String, Object>> {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String INTERVAL = "interval";
    public static final String AUTO_CHAPTERS = "autoChapters";
    public static final String REPEAT = "repeat";
    @FXML
    private Spinner<Integer> intervalSpinner;
    @FXML
    private ToggleSwitch autoChaptersToggle;
    @FXML
    private ToggleSwitch splitOnceOrRepeat;

    public SubTracksDialog(Window window) {
        this.setTitle("Create sub-tracks");
        this.setHeaderText("Split once after number of seconds \nor cut every number of seconds");
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.getDialogPane().setContent((Node)new GridPane());
        this.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                HashMap<String, Constable> results = new HashMap<String, Constable>();
                results.put(INTERVAL, this.intervalSpinner.getValue());
                results.put(AUTO_CHAPTERS, Boolean.valueOf(this.autoChaptersToggle.isSelected()));
                results.put(REPEAT, Boolean.valueOf(this.splitOnceOrRepeat.isSelected()));
                return results;
            }
            return null;
        });
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("subtracks.fxml"));
        fxmlLoader.setRoot((Object)this.getDialogPane().getContent());
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }
}

