/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.stage.Window;
import org.controlsfx.control.ToggleSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.Settings;

public class SettingsDialog
extends Dialog<Map<String, Object>> {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String FILENAME_FORMAT = "filename_format";
    public static final String PART_FORMAT = "part_format";
    public static final String CHAPTER_FORMAT = "chapter_format";
    public static final String DARK_MODE = "dark_mode";
    public static final String SHOW_HINTS = "show_hints";
    @FXML
    private ToggleSwitch darkMode;
    @FXML
    private TextArea filenameFormat;
    @FXML
    private TextArea partFormat;
    @FXML
    private TextArea chapterFormat;
    @FXML
    private ToggleSwitch showHints;

    public SettingsDialog(Window window) {
        this.setTitle("AudioBookConverter Settings");
        this.setHeaderText("Customize AudioBookConverter");
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.getDialogPane().setContent((Node)new GridPane());
        this.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                HashMap<String, Object> results = new HashMap<String, Object>();
                results.put(DARK_MODE, this.darkMode.isSelected());
                results.put(FILENAME_FORMAT, this.filenameFormat.getText());
                results.put(PART_FORMAT, this.partFormat.getText());
                results.put(CHAPTER_FORMAT, this.chapterFormat.getText());
                results.put(SHOW_HINTS, this.showHints.isSelected());
                return results;
            }
            return null;
        });
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("settings.fxml"));
        fxmlLoader.setRoot((Object)this.getDialogPane().getContent());
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @FXML
    public void initialize() {
        Settings settings = Settings.loadSetting();
        this.darkMode.setSelected(settings.isDarkMode());
        this.filenameFormat.setText(settings.getFilenameFormat());
        this.partFormat.setText(settings.getPartFormat());
        this.chapterFormat.setText(settings.getChapterFormat());
        this.showHints.setSelected(settings.isShowHints());
    }
}

