/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.ProgressStatus;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.ArtWork;
import uk.yermak.audiobookconverter.fx.ConversionProgress;

public class ProgressComponent
extends GridPane {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @FXML
    private Label title;
    @FXML
    private Label elapsedTime;
    @FXML
    private Label remainingTime;
    @FXML
    private Label estimatedSize;
    @FXML
    private Label state;
    @FXML
    private Label filesCount;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Button pauseButton;
    @FXML
    private Button stopButton;
    @FXML
    private ImageView imageView;
    private final ConversionProgress conversionProgress;

    public ProgressComponent(ConversionProgress conversionProgress) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("progress.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        List<ArtWork> posters = conversionProgress.getConversionJob().getConversionGroup().getPosters();
        if (!posters.isEmpty()) {
            this.imageView.setImage(posters.get(0).image());
        }
        this.progressBar.progressProperty().setValue((Number)0);
        this.progressBar.setMaxWidth(Double.MAX_VALUE);
        Object fileName = conversionProgress.getConversionJob().getOutputDestination();
        if (((String)fileName).length() > 80) {
            fileName = ((String)fileName).substring(0, 80) + "...";
        }
        this.title.setText((String)fileName);
        this.filesCount.setText(conversionProgress.filesCount.get());
        this.pauseButton.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.pause()));
        this.stopButton.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.stop()));
        this.conversionProgress = conversionProgress;
        this.assignListeners(conversionProgress);
        conversionProgress.getConversionJob().addStatusChangeListener((ChangeListener<ProgressStatus>)((ChangeListener)(observable, oldValue, newValue) -> this.updateButtons((ProgressStatus)((Object)newValue))));
    }

    private void updateButtons(ProgressStatus newValue) {
        Platform.runLater(() -> {
            switch (newValue) {
                case PAUSED: {
                    this.pauseButton.setText("Resume");
                    break;
                }
                case FINISHED: {
                    this.pauseButton.setDisable(true);
                    this.stopButton.setDisable(true);
                    break;
                }
                case CANCELLED: {
                    this.pauseButton.setDisable(true);
                    this.stopButton.setDisable(true);
                    break;
                }
                case IN_PROGRESS: {
                    this.pauseButton.setText("Pause");
                    this.pauseButton.setDisable(false);
                    this.stopButton.setDisable(false);
                    break;
                }
            }
        });
    }

    private void stop() {
        this.conversionProgress.getConversionJob().stop();
    }

    private void pause() {
        ConversionJob conversionGroup = this.conversionProgress.getConversionJob();
        if (conversionGroup.getStatus().equals((Object)ProgressStatus.PAUSED)) {
            conversionGroup.resume();
        } else {
            conversionGroup.pause();
        }
    }

    void assignListeners(ConversionProgress conversionProgress) {
        conversionProgress.filesCount.addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.filesCount.setText((String)newValue)));
        conversionProgress.progress.addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.progressBar.progressProperty().set(newValue.doubleValue())));
        conversionProgress.size.addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.estimatedSize.setText(Utils.formatSize(newValue.longValue()))));
        conversionProgress.elapsed.addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.elapsedTime.setText(Utils.formatTime(newValue.longValue()))));
        conversionProgress.remaining.addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.remainingTime.setText(Utils.formatTime(newValue.longValue()))));
        conversionProgress.state.addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.state.setText((String)newValue)));
    }

    public boolean isOver() {
        return this.conversionProgress.getConversionJob().getStatus().isOver();
    }
}

