/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.Preset;
import uk.yermak.audiobookconverter.Settings;
import uk.yermak.audiobookconverter.formats.Format;
import uk.yermak.audiobookconverter.formats.OutputParameters;

public class OutputController {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DISABLED = "Disabled";
    @FXML
    public ComboBox<Format> outputFormatBox;
    @FXML
    public ComboBox<String> presetBox;
    public ComboBox<String> forceBox;
    @FXML
    private ComboBox<String> splitFileBox;
    @FXML
    private ComboBox<String> speedBox;
    @FXML
    public ComboBox<String> cutoffBox;
    @FXML
    private ComboBox<String> frequencyBox;
    @FXML
    private ComboBox<String> channelsBox;
    @FXML
    private RadioButton cbrRadio;
    @FXML
    private ComboBox<String> bitRateBox;
    @FXML
    private RadioButton vbrRadio;
    @FXML
    private Slider vbrQualitySlider;

    public void cbr(ActionEvent actionEvent) {
        this.bitRateBox.setDisable(false);
        this.vbrQualitySlider.setDisable(true);
        Settings settings = Settings.loadSetting();
        Preset preset = this.currentPreset(settings);
        preset.setCbr(true);
        settings.save();
    }

    public void vbr(ActionEvent actionEvent) {
        this.bitRateBox.setDisable(true);
        this.vbrQualitySlider.setDisable(false);
        Settings settings = Settings.loadSetting();
        Preset preset = this.currentPreset(settings);
        preset.setCbr(false);
        settings.save();
    }

    @FXML
    private void initialize() {
        this.initPresetBox();
        this.outputFormatBox.getItems().addAll((Object[])new Format[]{Format.M4B, Format.M4A, Format.MP3, Format.OGG});
        this.outputFormatBox.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            Settings settings = Settings.loadSetting();
            Preset preset = this.currentPreset(settings);
            preset.setupFormat((Format)newValue);
            this.refreshFrequencies((Format)newValue, newValue.defaultFrequency());
            this.refreshBitrates((Format)newValue, newValue.defaultBitrate());
            this.refreshChannels((Format)newValue, newValue.defaultChannel());
            this.refreshCutoffs((Format)newValue, newValue.defaultCutoff());
            this.refreshSpeeds((Format)newValue, newValue.defaultSpeed());
            this.updateVbrQuality(newValue.defaultVbrQuality());
            this.updateCBR(newValue.defaultCBR());
            settings.save();
        });
        this.outputFormatBox.getSelectionModel().select(this.currentPreset(Settings.loadSetting()).getFormat());
        this.bitRateBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                Settings settings = Settings.loadSetting();
                Preset preset = this.currentPreset(settings);
                preset.setBitRate(Integer.valueOf(newValue));
                settings.save();
            }
        });
        this.frequencyBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                Settings settings = Settings.loadSetting();
                Preset preset = this.currentPreset(settings);
                preset.setFrequency(Integer.valueOf(newValue));
                settings.save();
            }
        });
        this.channelsBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                Settings settings = Settings.loadSetting();
                Preset preset = this.currentPreset(settings);
                preset.setChannels(Integer.valueOf(newValue));
                settings.save();
            }
        });
        this.vbrQualitySlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                Settings settings = Settings.loadSetting();
                Preset preset = this.currentPreset(settings);
                preset.setVbrQuality((int)Math.round(newValue.doubleValue()));
                settings.save();
            }
        });
        this.cutoffBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            Settings settings = Settings.loadSetting();
            Preset preset = this.currentPreset(settings);
            if (DISABLED.equals(newValue)) {
                preset.setCutoff(0);
            } else {
                preset.setCutoff(Integer.valueOf(newValue));
            }
            settings.save();
        });
        this.speedBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            Settings settings = Settings.loadSetting();
            Preset preset = this.currentPreset(settings);
            preset.setSpeed(Double.parseDouble(newValue));
            settings.save();
            AudiobookConverter.getContext().setSpeed(Double.parseDouble(newValue));
        });
        this.splitFileBox.getSelectionModel().select(0);
        this.splitFileBox.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            switch (newValue) {
                case "parts": {
                    Settings settings = Settings.loadSetting();
                    Preset preset = this.currentPreset(settings);
                    preset.setSplitChapters(false);
                    settings.save();
                    break;
                }
                case "chapters": {
                    Settings settings = Settings.loadSetting();
                    Preset preset = this.currentPreset(settings);
                    preset.setSplitChapters(true);
                    settings.save();
                }
            }
        });
        this.forceBox.getSelectionModel().select(0);
        this.forceBox.valueProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            Settings settings = Settings.loadSetting();
            Preset preset = this.currentPreset(settings);
            preset.setForce(OutputParameters.Force.valueOf(newValue));
            settings.save();
        });
        int selectedIndex = this.presetBox.getSelectionModel().getSelectedIndex();
        Settings settings = Settings.loadSetting();
        Preset preset = settings.getPresets().get(selectedIndex);
        this.updateOutputSettingsFromPreset(preset);
    }

    private void initPresetBox() {
        Settings settings = Settings.loadSetting();
        this.presetBox.getItems().addAll(settings.getPresets().stream().map(Preset::getName).toList());
        this.presetBox.getSelectionModel().select(settings.getLastUsedPreset());
        this.presetBox.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            Settings s = Settings.loadSetting();
            int i = -1;
            i = this.presetBox.getItems().indexOf(newValue);
            if (i != -1) {
                Preset preset = s.findPreset((String)newValue);
                s.setLastUsedPreset(i);
                s.save();
                AudiobookConverter.getContext().setPresetName(preset.getName());
                this.updateOutputSettingsFromPreset(preset);
            } else {
                this.presetBox.getItems().add(newValue);
                Preset preset = Preset.copy(newValue, s.findPreset((String)oldValue));
                AudiobookConverter.getContext().setPresetName(preset.getName());
                ArrayList<Preset> newPresets = new ArrayList<Preset>(s.getPresets());
                newPresets.add(preset);
                s.setPresets(newPresets);
                s.setLastUsedPreset(newPresets.size() - 1);
                s.save();
                this.updateOutputSettingsFromPreset(preset);
            }
        });
    }

    private Preset currentPreset(Settings settings) {
        List<Preset> presets = settings.getPresets();
        int selectedIndex = this.presetBox.getSelectionModel().getSelectedIndex();
        Preset preset = presets.get(selectedIndex);
        return preset;
    }

    private void updateCBR(Boolean cbr) {
        if (cbr.booleanValue()) {
            this.cbrRadio.fire();
        } else {
            this.vbrRadio.fire();
        }
    }

    private void updateVbrQuality(Integer quality) {
        this.vbrQualitySlider.setValue(quality.intValue());
    }

    private void refreshCutoffs(Format format, Integer cutoff) {
        this.cutoffBox.getItems().clear();
        this.cutoffBox.getItems().add((Object)DISABLED);
        this.cutoffBox.getItems().addAll(format.cutoffs().stream().map(String::valueOf).toList());
        this.cutoffBox.getSelectionModel().select(String.valueOf(OutputController.findNearestMatch(cutoff, format.cutoffs(), format.defaultCutoff())));
    }

    private void refreshChannels(Format format, Integer channel) {
        this.channelsBox.getItems().clear();
        this.channelsBox.getItems().addAll(format.channels().stream().map(String::valueOf).toList());
        this.channelsBox.getSelectionModel().select(String.valueOf(OutputController.findNearestMatch(channel, format.channels(), format.defaultChannel())));
    }

    private void refreshBitrates(Format format, Integer bitrate) {
        this.bitRateBox.getItems().clear();
        this.bitRateBox.getItems().addAll(format.bitrates().stream().map(String::valueOf).toList());
        this.bitRateBox.getSelectionModel().select(String.valueOf(OutputController.findNearestMatch(bitrate, format.bitrates(), format.defaultBitrate())));
    }

    private void refreshSpeeds(Format format, Double speed) {
        this.speedBox.getItems().clear();
        this.speedBox.getItems().addAll(format.speeds().stream().map(String::valueOf).toList());
        this.speedBox.getSelectionModel().select(String.valueOf(speed));
    }

    private void refreshFrequencies(Format format, Integer frequency) {
        this.frequencyBox.getItems().clear();
        this.frequencyBox.getItems().addAll(format.frequencies().stream().map(String::valueOf).toList());
        this.frequencyBox.getSelectionModel().select(String.valueOf(OutputController.findNearestMatch(frequency, format.frequencies(), format.defaultFrequency())));
    }

    public void deletePreset(ActionEvent actionEvent) {
        if (this.presetBox.getItems().size() == 1) {
            return;
        }
        Settings settings = Settings.loadSetting();
        Preset presetToRemove = this.currentPreset(settings);
        settings.getPresets().remove(presetToRemove);
        settings.setLastUsedPreset(0);
        settings.save();
        Preset preset = settings.getPresets().get(0);
        this.updateOutputSettingsFromPreset(preset);
        AudiobookConverter.getContext().setPresetName(preset.getName());
        this.presetBox.getItems().remove((Object)presetToRemove.getName());
        this.presetBox.getSelectionModel().select(0);
    }

    private void updateForceSpeed(Preset preset) {
        this.forceBox.getSelectionModel().select(preset.getForce().toString());
    }

    private void updateChapterSplit(Preset preset) {
        this.splitFileBox.getSelectionModel().select(preset.isSplitChapters() ? "chapters" : "parts");
    }

    private void updateOutputSettingsFromPreset(Preset preset) {
        this.outputFormatBox.getSelectionModel().select(preset.getFormat());
        this.refreshFrequencies(preset.getFormat(), preset.getFrequency());
        this.refreshBitrates(preset.getFormat(), preset.getBitRate());
        this.refreshChannels(preset.getFormat(), preset.getChannels());
        this.refreshCutoffs(preset.getFormat(), preset.getCutoff());
        this.refreshSpeeds(preset.getFormat(), preset.getSpeed());
        this.updateVbrQuality(preset.getVbrQuality());
        this.updateCBR(preset.isCbr());
        this.updateChapterSplit(preset);
        this.updateForceSpeed(preset);
    }

    private static Integer findNearestMatch(int value, List<Integer> list, int defaultValue) {
        for (Integer integer : list) {
            if (integer < value) continue;
            return integer;
        }
        return defaultValue;
    }
}

