/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.fx.ConversionContext;

public class MediaPlayerController {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @FXML
    private Button playButton;
    @FXML
    private Slider timelapse;
    @FXML
    private Slider volume;
    @FXML
    private Label playTime;
    @FXML
    private Label totalTime;
    private static MediaPlayer mediaPlayer;
    private MediaInfo playingTrack = null;
    private ScheduledExecutorService executorService;

    @FXML
    public void initialize() {
    }

    private void disablePlayer(boolean disable) {
        this.playButton.setDisable(disable);
        this.timelapse.setDisable(disable);
        this.volume.setDisable(disable);
    }

    public void play(ActionEvent event) {
        ConversionContext context = AudiobookConverter.getContext();
        ObservableList<MediaInfo> selectedMedia = context.getSelectedMedia();
        if (selectedMedia.size() == 1) {
            if (mediaPlayer == null) {
                this.playMedias((MediaInfo)selectedMedia.get(0));
                return;
            }
            if (this.playingTrack != selectedMedia.get(0)) {
                this.executorService.shutdown();
                mediaPlayer.stop();
                mediaPlayer.dispose();
                mediaPlayer = null;
                this.playingTrack = null;
                this.playMedias((MediaInfo)selectedMedia.get(0));
                return;
            }
            this.toggleMediaPlayer();
        }
    }

    private void toggleMediaPlayer() {
        MediaPlayer.Status status = mediaPlayer.getStatus();
        if (status == MediaPlayer.Status.HALTED || status == MediaPlayer.Status.UNKNOWN) {
            return;
        }
        if (status == MediaPlayer.Status.READY || status == MediaPlayer.Status.PAUSED || status == MediaPlayer.Status.STOPPED) {
            mediaPlayer.play();
        } else {
            mediaPlayer.pause();
        }
    }

    private void playMedias(MediaInfo selected) {
        this.playingTrack = selected;
        ConversionContext context = AudiobookConverter.getContext();
        ObservableList<MediaInfo> media = context.getMedia();
        if (media.indexOf((Object)selected) > media.size() - 1) {
            return;
        }
        this.timelapse.setValue(0.0);
        Media m = new Media(new File(selected.getFileName()).toURI().toASCIIString());
        mediaPlayer = new MediaPlayer(m);
        mediaPlayer.setAutoPlay(true);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        mediaPlayer.setOnReady(() -> {
            Duration duration = mediaPlayer.getMedia().getDuration();
            this.timelapse.setMax(duration.toSeconds());
            this.totalTime.setText(Utils.formatTime(duration.toMillis()));
            this.executorService.scheduleAtFixedRate(this::updateValues, 1L, 1L, TimeUnit.SECONDS);
        });
        mediaPlayer.volumeProperty().bindBidirectional((Property)this.volume.valueProperty());
        mediaPlayer.volumeProperty().set(1.0);
        mediaPlayer.rateProperty().set(context.getSpeed());
        mediaPlayer.rateProperty().bind((ObservableValue)context.getSpeedObservable());
        this.timelapse.valueProperty().addListener(observable -> {
            if (this.timelapse.isValueChanging()) {
                boolean wasPlaying = false;
                if (mediaPlayer.getStatus() == MediaPlayer.Status.PLAYING) {
                    wasPlaying = true;
                    mediaPlayer.pause();
                }
                this.playTime.setText(Utils.formatTime(this.timelapse.getValue() * 1000.0));
                mediaPlayer.seek(Duration.seconds((double)this.timelapse.getValue()));
                if (wasPlaying) {
                    mediaPlayer.play();
                }
            }
        });
        mediaPlayer.setOnEndOfMedia(() -> {
            this.executorService.shutdown();
            mediaPlayer.volumeProperty().unbindBidirectional((Property)this.volume.valueProperty());
            mediaPlayer.dispose();
            mediaPlayer = null;
            this.totalTime.setText("00:00:00");
            this.playTime.setText("00:00:00");
            MediaInfo next = this.findNext(selected);
            context.getSelectedMedia().clear();
            context.getSelectedMedia().add((Object)next);
            this.playMedias(next);
        });
        this.toggleMediaPlayer();
    }

    private MediaInfo findNext(MediaInfo selected) {
        ConversionContext context = AudiobookConverter.getContext();
        ObservableList<MediaInfo> media = context.getMedia();
        int i = media.indexOf((Object)selected);
        if (i < media.size()) {
            return (MediaInfo)media.get(i + 1);
        }
        return null;
    }

    private void updateValues() {
        Platform.runLater(() -> {
            Duration currentTime = mediaPlayer.getCurrentTime();
            if (!this.timelapse.isValueChanging()) {
                this.timelapse.setValue(currentTime.toSeconds());
                this.playTime.setText(Utils.formatTime(currentTime.toMillis()));
            }
        });
    }
}

