/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.lang.invoke.MethodHandles;
import javafx.application.HostServices;
import javafx.scene.Scene;
import javafx.scene.input.Mnemonic;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JfxEnv {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Scene scene;
    private final HostServices hostServices;

    public JfxEnv(Scene scene, HostServices hostServices) {
        this.scene = scene;
        this.hostServices = hostServices;
    }

    public void setDarkMode(Boolean darkMode) {
        if (darkMode.booleanValue()) {
            this.scene.getRoot().setStyle("-fx-base: rgba(60, 60, 60, 255);");
        } else {
            this.scene.getRoot().setStyle("");
        }
    }

    public Window getWindow() {
        return this.scene.getWindow();
    }

    public void showDocument(String url) {
        this.hostServices.showDocument(url);
    }

    public void addMnemonic(Mnemonic mnemonic) {
        this.scene.addMnemonic(mnemonic);
    }
}

